"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var legend_1 = require("../actions/legend");
var mouse_1 = require("../actions/mouse");
var series_1 = require("../../chart_types/xy_chart/utils/series");
function interactionsReducer(state, action) {
    switch (action.type) {
        case mouse_1.ON_POINTER_MOVE:
            return __assign(__assign({}, state), { pointer: __assign(__assign({}, state.pointer), { dragging: state.pointer.down && state.pointer.down.time < action.time ? true : false, current: {
                        position: __assign({}, action.position),
                        time: action.time,
                    } }) });
        case mouse_1.ON_MOUSE_DOWN:
            return __assign(__assign({}, state), { pointer: __assign(__assign({}, state.pointer), { dragging: false, up: null, down: {
                        position: __assign({}, action.position),
                        time: action.time,
                    } }) });
        case mouse_1.ON_MOUSE_UP: {
            return __assign(__assign({}, state), { pointer: __assign(__assign({}, state.pointer), { lastDrag: state.pointer.down && state.pointer.dragging
                        ? {
                            start: {
                                position: __assign({}, state.pointer.down.position),
                                time: state.pointer.down.time,
                            },
                            end: {
                                position: __assign({}, action.position),
                                time: action.time,
                            },
                        }
                        : null, lastClick: state.pointer.down && !state.pointer.dragging
                        ? {
                            position: __assign({}, action.position),
                            time: action.time,
                        }
                        : null, dragging: false, down: null, up: {
                        position: __assign({}, action.position),
                        time: action.time,
                    } }) });
        }
        case legend_1.ON_TOGGLE_LEGEND:
            return __assign(__assign({}, state), { legendCollapsed: !state.legendCollapsed });
        case legend_1.ON_LEGEND_ITEM_OUT:
            return __assign(__assign({}, state), { highlightedLegendItemKey: null });
        case legend_1.ON_LEGEND_ITEM_OVER:
            return __assign(__assign({}, state), { highlightedLegendItemKey: action.legendItemKey });
        case legend_1.ON_TOGGLE_DESELECT_SERIES:
            return __assign(__assign({}, state), { deselectedDataSeries: toggleDeselectedDataSeries(action.legendItemId, state.deselectedDataSeries) });
        default:
            return state;
    }
}
exports.interactionsReducer = interactionsReducer;
function toggleDeselectedDataSeries(legendItem, deselectedDataSeries) {
    var index = series_1.getSeriesIndex(deselectedDataSeries, legendItem);
    if (index > -1) {
        return __spread(deselectedDataSeries.slice(0, index), deselectedDataSeries.slice(index + 1));
    }
    else {
        return __spread(deselectedDataSeries, [legendItem]);
    }
}
//# sourceMappingURL=interactions.js.map