/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.Logging;

public class JosmPasswordField
extends JPasswordField
implements FocusListener {
    public JosmPasswordField() {
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    public JosmPasswordField(Document doc, String txt, int columns) {
        super(doc, txt, columns);
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    public JosmPasswordField(int columns) {
        super(columns);
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    public JosmPasswordField(String text, int columns) {
        super(text, columns);
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    public JosmPasswordField(String text) {
        super(text);
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.keyDetector.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.keyDetector.setEnabled(true);
        }
    }

    public static final void workaroundJdkBug6322854(JTextComponent text) {
        if (text != null) {
            text.getActionMap().put("paste", new Action(){
                private final Action pasteAction = TransferHandler.getPasteAction();

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        this.pasteAction.actionPerformed(e);
                    }
                    catch (NullPointerException npe) {
                        Logging.log(Logging.LEVEL_ERROR, "NullPointerException occurred because of JDK bug 6322854. Copy/Paste operation has not been performed. Please complain to Oracle: https://bugs.openjdk.java.net/browse/JDK-6322854", npe);
                    }
                }

                @Override
                public void setEnabled(boolean b) {
                    this.pasteAction.setEnabled(b);
                }

                @Override
                public void removePropertyChangeListener(PropertyChangeListener listener) {
                    this.pasteAction.removePropertyChangeListener(listener);
                }

                @Override
                public void putValue(String key, Object value) {
                    this.pasteAction.putValue(key, value);
                }

                @Override
                public boolean isEnabled() {
                    return this.pasteAction.isEnabled();
                }

                @Override
                public Object getValue(String key) {
                    return this.pasteAction.getValue(key);
                }

                @Override
                public void addPropertyChangeListener(PropertyChangeListener listener) {
                    this.pasteAction.addPropertyChangeListener(listener);
                }
            });
        }
    }
}

