/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.es;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_es extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "Mundo" },
            { "002", "\u00c1frica" },
            { "003", "Am\u00e9rica del Norte" },
            { "005", "Suram\u00e9rica" },
            { "009", "Ocean\u00eda" },
            { "011", "\u00c1frica occidental" },
            { "013", "Centroam\u00e9rica" },
            { "014", "\u00c1frica oriental" },
            { "015", "\u00c1frica septentrional" },
            { "017", "\u00c1frica central" },
            { "018", "\u00c1frica meridional" },
            { "019", "Am\u00e9ricas" },
            { "021", "Norteam\u00e9rica" },
            { "029", "Caribe" },
            { "030", "Asia oriental" },
            { "034", "Asia meridional" },
            { "035", "Sudeste asi\u00e1tico" },
            { "039", "Europa meridional" },
            { "053", "Australia y Nueva Zelanda" },
            { "054", "Melanesia" },
            { "057", "Micronesia [057]" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia central" },
            { "145", "Asia occidental" },
            { "150", "Europa" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "155", "Europa occidental" },
            { "419", "Latinoam\u00e9rica" },
            { "AC", "Isla de la Ascensi\u00f3n" },
            { "AD", "Andorra" },
            { "AE", "Emiratos \u00c1rabes Unidos" },
            { "AF", "Afganist\u00e1n" },
            { "AG", "Antigua y Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AN", "Antillas Neerlandesas" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e1rtida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Islas \u00c5land" },
            { "AZ", "Azerbaiy\u00e1n" },
            { "BA", "Bosnia-Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "B\u00e9lgica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahr\u00e9in" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "San Bartolom\u00e9" },
            { "BM", "Bermudas" },
            { "BN", "Brun\u00e9i" },
            { "BO", "Bolivia" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "But\u00e1n" },
            { "BV", "Isla Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belice" },
            { "CA", "Canad\u00e1" },
            { "CC", "Islas Cocos" },
            { "CD", "Rep\u00fablica Democr\u00e1tica del Congo" },
            { "CF", "Rep\u00fablica Centroafricana" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Suiza" },
            { "CI", "Costa de Marfil" },
            { "CK", "Islas Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u00fan" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Isla Clipperton" },
            { "CR", "Costa Rica" },
            { "CS", "Serbia y Montenegro" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CX", "Isla Christmas" },
            { "CY", "Chipre" },
            { "CZ", "Rep\u00fablica Checa" },
            { "DE", "Alemania" },
            { "DG", "Diego Garc\u00eda" },
            { "DJ", "Yibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "DZ", "Argelia" },
            { "EA", "Ceuta y Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipto" },
            { "EH", "S\u00e1hara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "Espa\u00f1a" },
            { "ET", "Etiop\u00eda" },
            { "EU", "Uni\u00f3n Europea" },
            { "FI", "Finlandia" },
            { "FJ", "Fiyi" },
            { "FK", "Islas Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Islas Feroe" },
            { "FR", "Francia" },
            { "FX", "Francia metropolitana" },
            { "GA", "Gab\u00f3n" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Georgia" },
            { "GF", "Guayana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Islas Georgia del Sur y Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Regi\u00f3n Administrativa Especial de Hong Kong de la Rep\u00fablica Popular China" },
            { "HM", "Islas Heard y McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hungr\u00eda" },
            { "IC", "Islas Canarias" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Isla de Man" },
            { "IN", "India" },
            { "IO", "Territorio Brit\u00e1nico del Oc\u00e9ano \u00cdndico" },
            { "IQ", "Iraq" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordania" },
            { "JP", "Jap\u00f3n" },
            { "KE", "Kenia" },
            { "KG", "Kirguist\u00e1n" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "KN", "San Crist\u00f3bal y Nieves" },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "KW", "Kuwait" },
            { "KY", "Islas Caim\u00e1n" },
            { "KZ", "Kazajist\u00e1n" },
            { "LA", "Laos" },
            { "LB", "L\u00edbano" },
            { "LC", "Santa Luc\u00eda" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Marruecos" },
            { "MC", "M\u00f3naco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "San Mart\u00edn" },
            { "MG", "Madagascar" },
            { "MH", "Islas Marshall" },
            { "MK", "Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar [Birmania]" },
            { "MN", "Mongolia" },
            { "MO", "Regi\u00f3n Administrativa Especial de Macao de la Rep\u00fablica Popular China" },
            { "MP", "Islas Marianas del Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricio" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "M\u00e9xico" },
            { "MY", "Malasia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nueva Caledonia" },
            { "NE", "N\u00edger" },
            { "NF", "Isla Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00edses Bajos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Isla Niue" },
            { "NZ", "Nueva Zelanda" },
            { "OM", "Om\u00e1n" },
            { "PA", "Panam\u00e1" },
            { "PE", "Per\u00fa" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Pap\u00faa Nueva Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Pakist\u00e1n" },
            { "PL", "Polonia" },
            { "PM", "San Pedro y Miquel\u00f3n" },
            { "PN", "Islas Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Territorios alejados de Ocean\u00eda" },
            { "RE", "Reuni\u00f3n" },
            { "RO", "Ruman\u00eda" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saud\u00ed" },
            { "SB", "Islas Salom\u00f3n" },
            { "SC", "Seychelles" },
            { "SD", "Sud\u00e1n" },
            { "SE", "Suecia" },
            { "SG", "Singapur" },
            { "SH", "Santa Elena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard y Jan Mayen" },
            { "SK", "Eslovaquia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "ST", "Santo Tom\u00e9 y Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SY", "Siria" },
            { "SZ", "Suazilandia" },
            { "TA", "Trist\u00e1n da Cunha" },
            { "TC", "Islas Turcas y Caicos" },
            { "TD", "Chad" },
            { "TF", "Territorios Australes Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Tayikist\u00e1n" },
            { "TK", "Tokelau" },
            { "TL", "Timor Oriental" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "T\u00fanez" },
            { "TO", "Tonga" },
            { "TR", "Turqu\u00eda" },
            { "TT", "Trinidad y Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e1n" },
            { "TZ", "Tanzania" },
            { "UA", "Ucrania" },
            { "UG", "Uganda" },
            { "UM", "Islas menores alejadas de los Estados Unidos" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekist\u00e1n" },
            { "VA", "Ciudad del Vaticano" },
            { "VC", "San Vicente y las Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Islas V\u00edrgenes Brit\u00e1nicas" },
            { "VI", "Islas V\u00edrgenes de los Estados Unidos" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis y Futuna" },
            { "WS", "Samoa" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sud\u00e1frica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Regi\u00f3n desconocida" },
            { "aa", "afar" },
            { "ab", "abjasio" },
            { "ae", "av\u00e9stico" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "am\u00e1rico" },
            { "an", "aragon\u00e9s" },
            { "ar", "\u00e1rabe" },
            { "as", "asam\u00e9s" },
            { "av", "avar" },
            { "ay", "aimara" },
            { "az", "azer\u00ed" },
            { "ba", "bashkir" },
            { "be", "bielorruso" },
            { "bg", "b\u00falgaro" },
            { "bh", "bihari" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengal\u00ed" },
            { "bo", "tibetano" },
            { "br", "bret\u00f3n" },
            { "bs", "bosnio" },
            { "ca", "catal\u00e1n" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cr", "cree" },
            { "cs", "checo" },
            { "cu", "eslavo eclesi\u00e1stico" },
            { "cv", "chuvash" },
            { "cy", "gal\u00e9s" },
            { "da", "dan\u00e9s" },
            { "de", "alem\u00e1n" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "griego" },
            { "en", "ingl\u00e9s" },
            { "eo", "esperanto" },
            { "es", "espa\u00f1ol" },
            { "et", "estonio" },
            { "eu", "vasco" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "fin\u00e9s" },
            { "fj", "fidjiano" },
            { "fo", "fero\u00e9s" },
            { "fr", "franc\u00e9s" },
            { "fy", "fris\u00f3n occidental" },
            { "ga", "irland\u00e9s" },
            { "gd", "ga\u00e9lico escoc\u00e9s" },
            { "gl", "gallego" },
            { "gn", "guaran\u00ed" },
            { "gu", "gujarati" },
            { "gv", "ga\u00e9lico man\u00e9s" },
            { "ha", "hausa" },
            { "he", "hebreo" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "haitiano" },
            { "hu", "h\u00fangaro" },
            { "hy", "armenio" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesio" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "island\u00e9s" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", "japon\u00e9s" },
            { "jv", "javan\u00e9s" },
            { "ka", "georgiano" },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazajo" },
            { "kl", "groenland\u00e9s" },
            { "km", "jemer" },
            { "kn", "canar\u00e9s" },
            { "ko", "coreano" },
            { "kr", "kanuri" },
            { "ks", "cachemiro" },
            { "ku", "kurdo" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnico" },
            { "ky", "kirghiz" },
            { "la", "lat\u00edn" },
            { "lb", "luxemburgu\u00e9s" },
            { "lg", "ganda" },
            { "li", "limburgu\u00e9s" },
            { "ln", "lingala" },
            { "lo", "laosiano" },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "let\u00f3n" },
            { "mg", "malgache" },
            { "mh", "marshal\u00e9s" },
            { "mi", "maor\u00ed" },
            { "mk", "macedonio" },
            { "ml", "malayalam" },
            { "mn", "mongol" },
            { "mo", "moldavo" },
            { "mr", "marathi" },
            { "ms", "malayo" },
            { "mt", "malt\u00e9s" },
            { "my", "birmano" },
            { "na", "nauruano" },
            { "nb", "bokmal noruego" },
            { "nd", "ndebele septentrional" },
            { "ne", "nepal\u00ed" },
            { "ng", "ndonga" },
            { "nl", "neerland\u00e9s" },
            { "nn", "nynorsk noruego" },
            { "no", "noruego" },
            { "nr", "ndebele meridional" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitano" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", "oriya" },
            { "os", "os\u00e9tico" },
            { "pa", "punjab\u00ed" },
            { "pi", "pali" },
            { "pl", "polaco" },
            { "ps", "pashto" },
            { "pt", "portugu\u00e9s" },
            { "qu", "quechua" },
            { "rm", "retorrom\u00e1nico" },
            { "rn", "kiroundi" },
            { "ro", "rumano" },
            { "ru", "ruso" },
            { "rw", "kinyarwanda" },
            { "sa", "s\u00e1nscrito" },
            { "sc", "sardo" },
            { "sd", "sindhi" },
            { "se", "sami septentrional" },
            { "sg", "sango" },
            { "sh", "serbocroata" },
            { "si", "cingal\u00e9s" },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somal\u00ed" },
            { "sq", "alban\u00e9s" },
            { "sr", "serbio" },
            { "ss", "siswati" },
            { "st", "sesotho meridional" },
            { "su", "sundan\u00e9s" },
            { "sv", "sueco" },
            { "sw", "swahili" },
            { "ta", "tamil" },
            { "te", "telugu" },
            { "tg", "tayiko" },
            { "th", "tailand\u00e9s" },
            { "ti", "tigri\u00f1a" },
            { "tk", "turcomano" },
            { "tl", "tagalo" },
            { "tn", "setchwana" },
            { "to", "tongano" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "t\u00e1rtaro" },
            { "tw", "twi" },
            { "ty", "tahitiano" },
            { "ug", "uigur" },
            { "uk", "ucraniano" },
            { "ur", "urdu" },
            { "uz", "uzbeko" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volap\u00fck" },
            { "wa", "val\u00f3n" },
            { "wo", "uolof" },
            { "xh", "xhosa" },
            { "yi", "y\u00eddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chino" },
            { "zu", "zul\u00fa" },
            { "ace", "acehn\u00e9s" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adigeo" },
            { "afa", "lengua afroasi\u00e1tica" },
            { "afh", "afrihili" },
            { "ain", "ainu" },
            { "akk", "acadio" },
            { "ale", "aleutiano" },
            { "alg", "lenguas algonquinas" },
            { "alt", "alt\u00e1i meridional" },
            { "ang", "ingl\u00e9s antiguo" },
            { "anp", "angika" },
            { "apa", "lenguas apache" },
            { "arc", "arameo" },
            { "arn", "araucano" },
            { "arp", "arapaho" },
            { "art", "lengua artificial" },
            { "arw", "arahuaco" },
            { "ast", "asturiano" },
            { "ath", "lenguas atabascas" },
            { "aus", "lenguas australianas" },
            { "awa", "avadhi" },
            { "bad", "banda" },
            { "bai", "lenguas bamileke" },
            { "bal", "baluchi" },
            { "ban", "balin\u00e9s" },
            { "bas", "basa" },
            { "bat", "lengua b\u00e1ltica" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "ber", "bereber" },
            { "bho", "bhojpuri" },
            { "bik", "bicol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "bnt", "bant\u00fa" },
            { "bra", "braj" },
            { "btk", "batak" },
            { "bua", "buriat" },
            { "bug", "bugin\u00e9s" },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "cai", "lengua india centroamericana" },
            { "car", "caribe" },
            { "cau", "lengua cauc\u00e1sica" },
            { "cch", "atsam" },
            { "ceb", "cebuano" },
            { "cel", "lengua celta" },
            { "chb", "chibcha" },
            { "chg", "chagat\u00e1i" },
            { "chk", "truk\u00e9s" },
            { "chm", "mar\u00ed" },
            { "chn", "jerga chinuk" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokee" },
            { "chy", "cheyene" },
            { "cmc", "lenguas ch\u00e1micas" },
            { "cop", "copto" },
            { "cpe", "lengua criolla o pidgin basada en el ingl\u00e9s" },
            { "cpf", "lengua criolla o pidgin basada en el franc\u00e9s" },
            { "cpp", "lengua criolla o pidgin basada en el portugu\u00e9s" },
            { "crh", "t\u00e1rtaro de Crimea" },
            { "crp", "lengua criolla o pidgin" },
            { "csb", "casubio" },
            { "cus", "lengua cusita" },
            { "dak", "dakota" },
            { "dar", "dargva" },
            { "day", "dayak" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "doi", "dogri" },
            { "dra", "lengua drav\u00eddica" },
            { "dsb", "sorbio inferior" },
            { "dua", "duala" },
            { "dum", "neerland\u00e9s medieval" },
            { "dyu", "diula" },
            { "efi", "efik" },
            { "egy", "egipcio antiguo" },
            { "eka", "ekajuk" },
            { "elx", "elamita" },
            { "enm", "ingl\u00e9s medieval" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fiu", "lengua fino\u00fagria" },
            { "fon", "fon" },
            { "frm", "franc\u00e9s medieval" },
            { "fro", "franc\u00e9s antiguo" },
            { "frr", "fris\u00f3n septentrional" },
            { "frs", "fris\u00f3n oriental" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gem", "lengua germ\u00e1nica" },
            { "gez", "geez" },
            { "gil", "gilbert\u00e9s" },
            { "gmh", "alem\u00e1n de la alta edad media" },
            { "goh", "alem\u00e1n de la alta edad antigua" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "g\u00f3tico" },
            { "grb", "grebo" },
            { "grc", "griego antiguo" },
            { "gsw", "alem\u00e1n suizo" },
            { "gwi", "kutchin" },
            { "hai", "haida" },
            { "haw", "hawaiano" },
            { "hil", "hiligaynon" },
            { "him", "himachali" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "sorbio superior" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ijo", "ijo" },
            { "ilo", "ilocano" },
            { "inc", "lengua \u00edndica" },
            { "ine", "lengua indoeuropea" },
            { "inh", "ingush" },
            { "ira", "lengua irania" },
            { "iro", "lenguas iroquesas" },
            { "jbo", "lojban" },
            { "jpr", "judeo-persa" },
            { "jrb", "judeo-\u00e1rabe" },
            { "kaa", "karakalpako" },
            { "kab", "cabila" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kar", "karen" },
            { "kaw", "kawi" },
            { "kbd", "kabardiano" },
            { "kcg", "tyap" },
            { "kfo", "koro" },
            { "kha", "khasi" },
            { "khi", "lengua joisana" },
            { "kho", "kotan\u00e9s" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kos", "kosraeano" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "carelio" },
            { "kro", "kru" },
            { "kru", "kurukh" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "lad", "ladino" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgiano" },
            { "lol", "mongo" },
            { "loz", "lozi" },
            { "lua", "luba-lulua" },
            { "lui", "luise\u00f1o" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "mad", "madur\u00e9s" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "macasar" },
            { "man", "mandingo" },
            { "map", "lengua austronesia" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mga", "irland\u00e9s medieval" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mis", "lenguas varias" },
            { "mkh", "lengua mon-jemer" },
            { "mnc", "manch\u00fa" },
            { "mni", "manipuri" },
            { "mno", "lenguas manobo" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mul", "lenguas m\u00faltiples" },
            { "mun", "lenguas munda" },
            { "mus", "creek" },
            { "mwl", "mirand\u00e9s" },
            { "mwr", "marwari" },
            { "myn", "maya" },
            { "myv", "erzya" },
            { "nah", "n\u00e1huatl" },
            { "nai", "lengua india norteamericana" },
            { "nap", "napolitano" },
            { "nds", "bajo alem\u00e1n" },
            { "new", "newari" },
            { "nia", "nias" },
            { "nic", "lengua n\u00edger-cordofana" },
            { "niu", "niueano" },
            { "nog", "nogai" },
            { "non", "n\u00f3rdico antiguo" },
            { "nqo", "n\u2019ko" },
            { "nso", "sotho septentrional" },
            { "nub", "lenguas nubias" },
            { "nwc", "newari cl\u00e1sico" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "osa", "osage" },
            { "ota", "turco otomano" },
            { "oto", "lenguas otomanas" },
            { "paa", "lengua pap\u00fa" },
            { "pag", "pangasin\u00e1n" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauano" },
            { "peo", "persa antiguo" },
            { "phi", "lengua filipina" },
            { "phn", "fenicio" },
            { "pon", "pohnpeiano" },
            { "pra", "lenguas pr\u00e1critas" },
            { "pro", "provenzal antiguo" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongano" },
            { "roa", "lengua romance" },
            { "rom", "roman\u00ed" },
            { "rup", "arrumano" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "sai", "lengua india sudamericana" },
            { "sal", "lenguas salish" },
            { "sam", "arameo samaritano" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "scn", "siciliano" },
            { "sco", "escoc\u00e9s" },
            { "sel", "selkup" },
            { "sem", "lengua sem\u00edtica" },
            { "sga", "irland\u00e9s antiguo" },
            { "sgn", "lenguajes de signos" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "sio", "lenguas sioux" },
            { "sit", "lengua sino-tibetana" },
            { "sla", "lengua eslava" },
            { "sma", "sami meridional" },
            { "smi", "lengua sami" },
            { "smj", "sami lule" },
            { "smn", "sami inari" },
            { "sms", "sami skolt" },
            { "snk", "sonink\u00e9" },
            { "sog", "sogdiano" },
            { "son", "songhai" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssa", "lengua nilo-sahariana" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerio" },
            { "swb", "comorense" },
            { "syc", "sir\u00edaco cl\u00e1sico" },
            { "syr", "siriaco" },
            { "tai", "lengua tai" },
            { "tem", "temne" },
            { "ter", "tereno" },
            { "tet", "tet\u00fan" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tiv" },
            { "tkl", "tokelauano" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tmh", "tamashek" },
            { "tog", "tonga del Nyasa" },
            { "tpi", "tok pisin" },
            { "tsi", "tsimshiano" },
            { "tum", "tumbuka" },
            { "tup", "lenguas tup\u00ed" },
            { "tut", "lengua altaica" },
            { "tvl", "tuvaluano" },
            { "tyv", "tuviniano" },
            { "udm", "udmurt" },
            { "uga", "ugar\u00edtico" },
            { "umb", "umbundu" },
            { "und", "lengua desconocida" },
            { "vai", "vai" },
            { "vot", "v\u00f3tico" },
            { "wak", "lenguas wakasha" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wen", "lenguas sorbias" },
            { "xal", "kalmyk" },
            { "yao", "yao" },
            { "yap", "yap\u00e9s" },
            { "ypk", "lenguas yupik" },
            { "yue", "canton\u00e9s" },
            { "zap", "zapoteco" },
            { "zbl", "s\u00edmbolos Bliss" },
            { "zen", "zenaga" },
            { "znd", "zande" },
            { "zun", "zuni" },
            { "zxx", "sin contenido ling\u00fc\u00edstico" },
            { "zza", "zazaki" },
            { "Arab", "\u00e1rabe" },
            { "Armn", "armenio" },
            { "Avst", "av\u00e9stico" },
            { "Bali", "balin\u00e9s" },
            { "Batk", "batak" },
            { "Beng", "bengal\u00ed" },
            { "Blis", "s\u00edmbolos blis" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", "bugin\u00e9s" },
            { "Buhd", "buhid" },
            { "Cans", "s\u00edmbolos abor\u00edgenes canadienses unificados" },
            { "Cari", "cario" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Cirt", "cirth" },
            { "Copt", "copto" },
            { "Cprt", "chipriota" },
            { "Cyrl", "cir\u00edlico" },
            { "Cyrs", "cir\u00edlico del antiguo eslavo eclesi\u00e1stico" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "egipcio dem\u00f3tico" },
            { "Egyh", "egipcio hier\u00e1tico" },
            { "Egyp", "jerogl\u00edficos egipcios" },
            { "Ethi", "eti\u00f3pico" },
            { "Geok", "georgiano eclesi\u00e1stico" },
            { "Geor", "georgiano" },
            { "Glag", "glagol\u00edtico" },
            { "Goth", "g\u00f3tico" },
            { "Grek", "griego" },
            { "Gujr", "gujarati" },
            { "Guru", "gurmuji" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "han simplificado" },
            { "Hant", "han tradicional" },
            { "Hebr", "hebreo" },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "katakana o hiragana" },
            { "Hung", "h\u00fangaro antiguo" },
            { "Inds", "Indio (harappan)" },
            { "Ital", "antigua bastardilla" },
            { "Java", "javan\u00e9s" },
            { "Jpan", "japon\u00e9s" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharosthi" },
            { "Khmr", "jemer" },
            { "Knda", "canar\u00e9s" },
            { "Kore", "coreano" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "latino fraktur" },
            { "Latg", "latino ga\u00e9lico" },
            { "Latn", "lat\u00edn" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineal A" },
            { "Linb", "lineal B" },
            { "Lyci", "licio" },
            { "Lydi", "lidio" },
            { "Mand", "mandeo" },
            { "Maya", "jerogl\u00edficos mayas" },
            { "Mero", "mero\u00edtico" },
            { "Mlym", "malay\u00e1lam" },
            { "Mong", "mongol" },
            { "Moon", "moon" },
            { "Mtei", "manipuri" },
            { "Mymr", "birmano" },
            { "Nkoo", "n\u2019ko" },
            { "Ogam", "ogham" },
            { "Olck", "ol ciki" },
            { "Orkh", "orkhon" },
            { "Orya", "oriya" },
            { "Osma", "osmaniya" },
            { "Perm", "permiano antiguo" },
            { "Phag", "phags-pa" },
            { "Phnx", "fenicio" },
            { "Plrd", "Pollard Miao" },
            { "Rjng", "rejang" },
            { "Roro", "rongo-rongo" },
            { "Runr", "r\u00fanico" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "shaviano" },
            { "Sinh", "binhala" },
            { "Sund", "sundan\u00e9s" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "siriaco" },
            { "Syre", "siriaco estrangelo" },
            { "Syrj", "siriaco occidental" },
            { "Syrn", "siriaco oriental" },
            { "Tagb", "tagban\u00faa" },
            { "Tale", "tai le" },
            { "Talu", "nuevo tai lue" },
            { "Taml", "tamil" },
            { "Telu", "telugu" },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagalo" },
            { "Thaa", "thaana" },
            { "Thai", "tailand\u00e9s" },
            { "Tibt", "tibetano" },
            { "Ugar", "ugar\u00edtico" },
            { "Vaii", "vai" },
            { "Visp", "lenguaje visible" },
            { "Xpeo", "persa antiguo" },
            { "Xsux", "cuneiforme sumerio-acadio" },
            { "Yiii", "yi" },
            { "Zinh", "heredado" },
            { "Zsym", "s\u00edmbolos" },
            { "Zxxx", "no escrito" },
            { "Zyyy", "com\u00fan" },
            { "Zzzz", "alfabeto desconocido" },
            { "root", "ra\u00edz" },
            { "de_AT", "alem\u00e1n austr\u00edaco" },
            { "de_CH", "alto alem\u00e1n de Suiza" },
            { "en_AU", "ingl\u00e9s australiano" },
            { "en_CA", "ingl\u00e9s canadiense" },
            { "en_GB", "ingl\u00e9s brit\u00e1nico" },
            { "en_US", "ingl\u00e9s estadounidense" },
            { "es_ES", "espa\u00f1ol de Espa\u00f1a" },
            { "fr_CA", "franc\u00e9s canadiense" },
            { "fr_CH", "franc\u00e9s de Suiza" },
            { "nl_BE", "flamenco" },
            { "pt_BR", "portugu\u00e9s de Brasil" },
            { "pt_PT", "portugu\u00e9s de Portugal" },
            { "es_419", "espa\u00f1ol latinoamericano" },
            { "zh_Hans", "chino simplificado" },
            { "zh_Hant", "chino tradicional" },
        };
        return data;
    }
}
