/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.nav;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.nav.NavHandler;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.ValidatorMap;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;

public class NavChecker
implements ContentChecker,
DocumentValidator {
    private static final ValidatorMap validatorMap = ValidatorMap.builder().putAll(XMLValidators.NAV_30_RNC, XMLValidators.XHTML_30_SCH, XMLValidators.NAV_30_SCH).putAll(Predicates.and(Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.EDUPUB), ValidationContext.ValidationContextPredicates.hasPubType("edupub")), Predicates.not(ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.FIXED_LAYOUT))), Predicates.not(ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.NON_LINEAR)))), XMLValidators.XHTML_EDUPUB_STRUCTURE_SCH, XMLValidators.XHTML_EDUPUB_SEMANTICS_SCH, XMLValidators.XHTML_IDX_SCH).putAll(Predicates.and(Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.DICT), ValidationContext.ValidationContextPredicates.hasPubType("dictionary")), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.XHTML_DICT_SCH).putAll(Predicates.and(Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.IDX), ValidationContext.ValidationContextPredicates.hasPubType("index"), ValidationContext.ValidationContextPredicates.hasProp(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.INDEX)), ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.IN_INDEX_COLLECTION))), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)), XMLValidators.XHTML_IDX_SCH, XMLValidators.XHTML_IDX_INDEX_SCH).build();
    private final ValidationContext context;
    private final Report report;
    private final String path;

    public NavChecker(ValidationContext context) {
        Preconditions.checkState("application/xhtml+xml".equals(context.mimeType));
        this.context = context;
        this.report = context.report;
        this.path = context.path;
        if (context.version == EPUBVersion.VERSION_2) {
            context.report.message(MessageId.NAV_001, EPUBLocation.create(this.path), new Object[0]);
        }
    }

    @Override
    public void runChecks() {
        if (!this.context.ocf.get().hasEntry(this.path)) {
            this.report.message(MessageId.RSC_001, EPUBLocation.create(this.context.ocf.get().getName()), this.path);
        } else if (!this.context.ocf.get().canDecrypt(this.path)) {
            this.report.message(MessageId.RSC_004, EPUBLocation.create(this.context.ocf.get().getName()), this.path);
        } else {
            this.validate();
        }
    }

    @Override
    public boolean validate() {
        int fatalErrors = this.report.getFatalErrorCount();
        int errors = this.report.getErrorCount();
        int warnings = this.report.getWarningCount();
        XMLParser navParser = new XMLParser(this.context);
        NavHandler navHandler = new NavHandler(this.context, navParser);
        navParser.addXMLHandler(navHandler);
        for (XMLValidator validator : validatorMap.getValidators(this.context)) {
            navParser.addValidator(validator);
        }
        navParser.process();
        return fatalErrors == this.report.getFatalErrorCount() && errors == this.report.getErrorCount() && warnings == this.report.getWarningCount();
    }
}

