Root.Runtime.cachedResources["animation/animationScreenshotPopover.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\nimg {\n    max-height: 300px;\n    border-radius: 2px;\n}\n\n.animation-progress {\n    position: absolute;\n    height: 2px;\n    bottom: 0;\n    left: 0;\n    background: var(--selection-bg-color);\n}\n\n/*# sourceURL=animation/animationScreenshotPopover.css */";Root.Runtime.cachedResources["animation/animationTimeline.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    overflow: hidden;\n}\n\n.animation-node-row {\n    width: 100%;\n    display: flex;\n    border-bottom: 1px dashed hsla(0,0%,94%,1);\n}\n\n.animation-node-description {\n    width: 150px;\n    padding-left: 8px;\n    overflow: hidden;\n    position: relative;\n    transform-style: preserve-3d;\n    border-bottom: 1px solid hsl(0, 0%, 90%);\n    margin-bottom: -1px;\n    background-color: hsl(0, 0%, 98%);\n    display: flex;\n    align-items: center;\n    flex: 0 0 150px;\n}\n\n.animation-node-description > * {\n    flex: 0 0 auto;\n}\n\n.animation-timeline-row {\n    height: 32px;\n    position: relative;\n}\n\npath.animation-keyframe {\n    fill-opacity: 0.2;\n}\n\nsvg.animation-ui g:first-child:hover path.animation-keyframe {\n    fill-opacity: 0.4;\n}\n\n.animation-node-selected path.animation-keyframe {\n    fill-opacity: 0.4;\n}\n\nline.animation-line {\n    stroke-width: 2px;\n    stroke-linecap: round;\n    fill: none;\n}\n\nline.animation-delay-line {\n    stroke-width: 2px;\n    stroke-dasharray: 6, 4;\n}\n\nline.animation-delay-line.animation-fill {\n    stroke-dasharray: none;\n}\n\ncircle.animation-endpoint, circle.animation-keyframe-point {\n    stroke-width: 2px;\n    transition: transform 100ms cubic-bezier(0, 0, 0.2, 1);\n    transform: scale(1);\n    transform-box: fill-box;\n    transform-origin: 50% 50%;\n}\n\n.animation-ui circle.animation-endpoint:hover, .animation-ui circle.animation-keyframe-point:hover {\n    transform: scale(1.2);\n}\n\ncircle.animation-endpoint:active, circle.animation-keyframe-point:active {\n    transform: scale(1);\n}\n\ncircle.animation-keyframe-point {\n    fill: white;\n}\n\n.animation-name {\n    position: absolute;\n    top: 8px;\n    color: #333;\n    text-align: center;\n    margin-left: -8px;\n    white-space: nowrap;\n}\n\n.animation-timeline-toolbar-container {\n    display: flex;\n    background-color: var(--toolbar-bg-color);\n    border-bottom: var(--divider-border);\n    flex: 0 0 auto;\n}\n\n.animation-timeline-toolbar {\n    display: inline-block;\n}\n\n.animation-timeline-header {\n    height: 28px;\n    border-bottom: 1px solid #ccc;\n    flex-shrink: 0;\n    display: flex;\n}\n\n.animation-timeline-header:after {\n    content: \"\";\n    height: calc(100% - 48px - 28px);\n    position: absolute;\n    width: 150px;\n    left: 0;\n    margin-top: 28px;\n    background-color: hsl(0, 0%, 98%);\n    z-index: 0;\n    border-right: 1px solid hsl(0, 0%, 90%);\n}\n\n.animation-controls {\n    flex: 0 0 150px;\n    position: relative;\n    display: flex;\n    justify-content: flex-end;\n    padding-right: 8px;\n}\n\n.animation-timeline-current-time {flex: 0 0 auto;line-height: 28px;margin-right: 5px;}\n.animation-grid-header {\n    flex: 1 0 auto;\n    z-index: 1;\n    cursor: text;\n}\n\n.animation-timeline-buffer, .animation-timeline-buffer-hint {\n    height: 48px;\n    flex: 0 0 auto;\n    border-bottom: 1px solid #ccc;\n    display: flex;\n    padding: 0 2px;\n}\n\n.animation-timeline-buffer:empty, .animation-timeline-buffer-hint {\n    display: none;\n}\n\n.animation-timeline-buffer:empty ~ .animation-timeline-buffer-hint {\n    align-items: center;\n    justify-content: center;\n    font-size: 14px;\n    z-index: 101;\n    display: flex;\n}\n\n.animation-time-overlay {\n    background-color: black;\n    opacity: 0.05;\n    position: absolute;\n    height: 100%;\n    width: 100%;\n    z-index: -1;\n}\n\n.animation-timeline-end > .animation-time-overlay {\n    visibility: hidden;\n}\n\n.animation-scrubber {\n    opacity: 1;\n    position: absolute;\n    left: 150px;\n    height: calc(100% - 103px);\n    width: calc(100% - 150px);\n    top: 103px;\n    border-left: 1px solid hsla(4,90%,58%,1);\n    z-index: 1;\n}\n\n.animation-scrubber-line {\n    width: 11px;\n    background: linear-gradient(to right, transparent 5px, hsla(4,90%,58%,1) 5px, hsla(4,90%,58%,1) 6px, transparent 6px);\n    position: absolute;\n    top: -28px;\n    height: 28px;\n    left: -6px;\n    padding: 0 5px;\n    z-index: 2;\n}\n\n.animation-scrubber-head {\n    width: 7px;\n    height: 7px;\n    transform: rotate(45deg);\n    background: red;\n    position: absolute;\n    left: 2px;\n    top: 1px;\n}\n\nsvg.animation-timeline-grid {\n    position: absolute;\n    left: 140px;\n    top: 76px;\n    z-index: 0;\n}\n\nrect.animation-timeline-grid-line {\n    fill: hsla(0,0%,93%,1);\n}\n\n.animation-timeline-row > svg.animation-ui {\n    position: absolute;\n}\n\n.animation-node-timeline {\n    flex-grow: 1;\n}\n\n.animation-node-description > div {\n    position: absolute;\n    top: 50%;\n    transform: translateY(-50%);\n    max-height: 100%;\n}\n\n.animation-node-removed {\n    -webkit-filter: saturate(0);\n    cursor: not-allowed;\n}\n\nsvg.animation-ui g:first-child {\n    opacity: 1;\n}\n\n.animation-tail-iterations {\n    opacity: 0.5;\n}\n\n.animation-keyframe-step line {\n    stroke-width: 2;\n    stroke-opacity: 0.3;\n}\n\ntext.animation-timeline-grid-label {\n    font-size: 10px;\n    fill: #5a5a5a;\n    text-anchor: middle;\n}\n\n.animation-timeline-rows, .animation-timeline-rows-hint {\n    flex-grow: 1;\n    overflow-y: auto;\n    z-index: 1;\n    overflow-x: hidden;\n}\n\n.animation-timeline-rows-hint {\n    display: none;\n}\n\n.animation-timeline-buffer:not(:empty) ~ .animation-timeline-rows:empty {\n    flex-grow: 0;\n}\n\n.animation-timeline-buffer:not(:empty) ~ .animation-timeline-rows:empty ~ .animation-timeline-rows-hint {\n    font-size: 14px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    margin-left: 150px;\n    padding: 10px;\n}\n\n.toolbar.animation-controls-toolbar {\n    flex: 0 0 auto;\n}\n\n.animation-node-row.animation-node-selected {\n    background-color: hsla(216, 71%, 53%, 0.08);\n}\n\n.animation-node-selected > .animation-node-description {\n    background-color: #EFF4FD;\n}\n\n.animation-buffer-preview {\n    height: 40px;\n    margin: 4px 2px;\n    background-color: var(--toolbar-bg-color);\n    border-radius: 2px;\n    flex: 1 1;\n    padding: 4px;\n    max-width: 100px;\n    animation: newGroupAnim 200ms;\n    position: relative;\n}\n\n.animation-buffer-preview-animation {\n    width: 100%;\n    height: 100%;\n    border-radius: 2px 0 0 2px;\n    position: absolute;\n    top: 0;\n    left: 0;\n    background: hsla(219, 100%, 66%, 0.27);\n    opacity: 0;\n    border-right: 1px solid #A7A7A7;\n    cursor: pointer;\n}\n\n.animation-buffer-preview:not(.selected):hover {\n    background-color: hsla(217,90%,92%,1);\n}\n\n.animation-buffer-preview.selected {\n    background-color: var(--selection-bg-color);\n}\n\n.animation-paused {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    background-color: hsla(0,0%,70%,0.5);\n    display: none;\n}\n\n.animation-paused:before, .animation-paused:after {\n    content: \"\";\n    background: hsl(0, 100%, 100%);\n    width: 7px;\n    height: 20px;\n    border-radius: 2px;\n    margin: 2px;\n    border: 1px solid #ccc;\n}\n\n.animation-buffer-preview.paused .animation-paused {\n    display: flex;\n}\n\n.animation-buffer-preview.selected > svg > line {\n    stroke: white !important;\n}\n\n.animation-buffer-preview > svg > line {\n    stroke-width: 1px;\n}\n\n@keyframes newGroupAnim {\n    from {\n        -webkit-clip-path: polygon(0% 0%, 0% 100%, 0% 100%, 0% 0%);\n    }\n    to {\n        -webkit-clip-path: polygon(0% 0%, 0% 100%, 100% 100%, 100% 0%);\n    }\n}\n\n.animation-playback-rate-control {\n    margin: 4px 0 4px 2px;\n    display: flex;\n    width: 120px;\n}\n\n.animation-playback-rate-button:first-child {\n    border-radius: 4px 0 0 4px;\n}\n\n.animation-playback-rate-button:last-child {\n    border-radius: 0 4px 4px 0;\n}\n\n.animation-playback-rate-button {\n    border: 1px solid #ccc;\n    display: inline-block;\n    margin-right: -1px;\n    padding: 1px 4px;\n    background: white;\n    flex: 1 0 auto;\n    text-align: center;\n    cursor: pointer;\n}\n\n.animation-playback-rate-button:not(.selected):hover {\n    background: hsl(211, 100%, 95%);\n}\n\n.animation-playback-rate-button.selected {\n    color: hsl(0, 100%, 100%);\n    background-color: var(--selection-bg-color);\n    border-color: var(--selection-bg-color);\n    z-index: 1;\n}\n\n.animation-playback-rate-button.selected:first-child {\n    color: var(--selection-bg-color);\n    background-color: hsl(217, 89%, 100%);\n}\n\n.animation-remove-button, -theme-preserve {\n    position: absolute;\n    top: -3px;\n    right: -3px;\n    background: #7B7B7B;\n    border-radius: 12px;\n    height: 16px;\n    width: 16px;\n    align-items: center;\n    font-size: 10px;\n    justify-content: center;\n    box-shadow: 0 1px 4px 0 rgb(185, 185, 185);\n    z-index: 100;\n    display: none;\n    cursor: pointer;\n    font-weight: 700;\n    color: white;\n}\n\n.animation-remove-button:hover {\n    background: #585858;\n}\n\n.animation-buffer-preview:hover .animation-remove-button {\n    display: flex;\n}\n\n/*# sourceURL=animation/animationTimeline.css */";