/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.object.AbstractPoolingSPListener;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.table.CleanupTableModel;
import ca.sqlpower.swingui.table.EditableJTable;
import ca.sqlpower.util.TransactionEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class IndexColumnTable {
    private static final Logger logger = Logger.getLogger(IndexColumnTable.class);
    public static final String IN_INDEX = Messages.getString("IndexColumnTable.indexTableColumnName");
    public static final String COL_NAME = Messages.getString("IndexColumnTable.columnTableColumnName");
    public static final String ORDER = Messages.getString("IndexColumnTable.ascendingDescendingTableColumnName");
    private final JTable table;
    private final IndexColumnTableModel model;
    private final SQLTable parent;
    private final SQLIndex index;

    public IndexColumnTable(SQLTable parent, SQLIndex index, SQLIndex actualIndex) {
        this.model = new IndexColumnTableModel(index, parent, actualIndex);
        this.table = this.createCustomTable();
        this.parent = parent;
        this.index = index;
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    public void cleanUp() {
        this.model.cleanup();
    }

    public void finalizeIndex() {
        ArrayList<SQLIndex.Column> colsToMatch = new ArrayList<SQLIndex.Column>();
        for (Row r : this.model.getRowList()) {
            if (!r.isEnabled()) continue;
            if (r.getSQLColumn() != null) {
                colsToMatch.add(new SQLIndex.Column(r.getSQLColumn(), r.getOrder()));
                continue;
            }
            logger.debug((Object)("Adding index column with no SQLColumn. Column name is " + r.getColumn().getName()));
            colsToMatch.add(new SQLIndex.Column(r.getColumn().getName(), r.getOrder()));
        }
        try {
            this.index.makeColumnsLike(colsToMatch);
        }
        catch (SQLObjectException e) {
            throw new SQLObjectRuntimeException(e);
        }
    }

    public void moveRow(boolean direction) {
        if (this.table.getSelectedRows().length <= 0) {
            return;
        }
        int start = this.table.getSelectedRows()[0];
        int end = this.table.getSelectedRows()[this.table.getSelectedRows().length - 1];
        int dest = start;
        dest = direction ? --dest : ++dest;
        int count = end - start;
        if (count < 0) {
            return;
        }
        if (dest >= 0 && dest <= this.table.getRowCount() - count - 1) {
            this.model.moveRow(start, end, dest);
            this.table.getSelectionModel().removeSelectionInterval(0, this.table.getRowCount() - 1);
            this.table.getSelectionModel().addSelectionInterval(dest, dest + count);
        }
    }

    private boolean isRowEnabled(int row) {
        return this.table.getValueAt(row, this.table.getColumnModel().getColumnIndex(IN_INDEX)).toString().equals("true");
    }

    private boolean isRowInCurrentSelection(int row) {
        for (int i : this.table.getSelectedRows()) {
            if (i != row) continue;
            return true;
        }
        return false;
    }

    private JTable createCustomTable() {
        EditableJTable newTable = new EditableJTable((TableModel)this.model);
        newTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getComponent() != e.getComponent().getComponentAt(e.getPoint())) {
                    for (MouseListener listener : e.getComponent().getComponentAt(e.getPoint()).getMouseListeners()) {
                        listener.mouseClicked(e);
                    }
                }
            }
        });
        SQLIndex.AscendDescend[] values = new SQLIndex.AscendDescend[]{SQLIndex.AscendDescend.ASCENDING, SQLIndex.AscendDescend.DESCENDING, SQLIndex.AscendDescend.UNSPECIFIED};
        TableColumn col = newTable.getColumnModel().getColumn(2);
        col.setCellEditor(new ComboBoxEditor(values));
        col.setCellRenderer(new ComboBoxRenderer(values));
        return newTable;
    }

    public JTable getTable() {
        return this.table;
    }

    private class ComboBoxEditor
    extends DefaultCellEditor {
        public ComboBoxEditor(SQLIndex.AscendDescend[] items) {
            super(new JComboBox<SQLIndex.AscendDescend>(items));
        }
    }

    private class ComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public ComboBoxRenderer(SQLIndex.AscendDescend[] items) {
            super(items);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }

    private class Row {
        private boolean enabled;
        private SQLColumn sqlColumn;
        private SQLIndex.AscendDescend order;
        private SQLIndex.Column column;

        public Row(boolean enabled, SQLColumn column, SQLIndex.AscendDescend order) {
            this.enabled = enabled;
            this.sqlColumn = column;
            this.order = order;
        }

        public Row(boolean enabled, SQLIndex.Column column, SQLIndex.AscendDescend order) {
            this.enabled = enabled;
            this.column = column;
            this.order = order;
        }

        public String toString() {
            if (this.sqlColumn != null) {
                return new String("Enabled: " + this.enabled + " Col:  " + this.sqlColumn.getName());
            }
            return new String("Enabled: " + this.enabled + " Col:  " + this.column.getName());
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setSQLColumn(SQLColumn column) {
            this.sqlColumn = column;
        }

        public void setOrder(SQLIndex.AscendDescend order) {
            this.order = order;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public SQLColumn getSQLColumn() {
            return this.sqlColumn;
        }

        public SQLIndex.AscendDescend getOrder() {
            return this.order;
        }

        public void setColumn(SQLIndex.Column column) {
            this.column = column;
        }

        public SQLIndex.Column getColumn() {
            return this.column;
        }
    }

    class IndexColumnTableModel
    extends AbstractTableModel
    implements CleanupTableModel,
    SPListener {
        private List<Row> rowList;
        private final SQLIndex index;
        private final SQLTable table;
        private ActualIndexListener indexListener;
        private final SQLIndex actualIndex;

        IndexColumnTableModel(SQLIndex index, SQLTable parent, SQLIndex actualIndex) {
            this.index = index;
            this.actualIndex = actualIndex;
            this.rowList = new ArrayList<Row>();
            this.table = parent;
            this.indexListener = new ActualIndexListener();
            this.setUpListeners();
            this.populateModel();
        }

        private void setUpListeners() {
            this.table.addSPListener((SPListener)this);
            this.actualIndex.addSPListener((SPListener)this.indexListener);
            for (SQLColumn child : this.table.getChildren(SQLColumn.class)) {
                child.addSPListener((SPListener)this);
            }
        }

        public void moveRow(int start, int end, int dest) {
            int i;
            ArrayList<Row> removed = new ArrayList<Row>();
            for (i = end; i >= start; --i) {
                removed.add(this.rowList.remove(i));
            }
            for (i = 0; i <= end - start; ++i) {
                this.rowList.add(dest, (Row)removed.get(i));
            }
            int firstRow = Math.min(start, dest);
            int lastRow = Math.max(end, dest + (end - start));
            this.fireTableRowsUpdated(firstRow, lastRow);
        }

        private void repopulateModel() {
            try {
                this.index.makeColumnsLike(this.actualIndex);
            }
            catch (SQLObjectException ex) {
                throw new SQLObjectRuntimeException(ex);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (ObjectDependentException e) {
                throw new RuntimeException(e);
            }
            for (int i = this.rowList.size() - 1; i >= 0; --i) {
                this.rowList.remove(i);
            }
            this.populateModel();
            this.fireTableDataChanged();
        }

        private void populateModel() {
            for (SQLIndex.Column indexCol : this.index.getChildren(SQLIndex.Column.class)) {
                if (indexCol.getColumn() != null) {
                    this.rowList.add(new Row(true, indexCol.getColumn(), indexCol.getAscendingOrDescending()));
                    continue;
                }
                this.rowList.add(new Row(true, indexCol, indexCol.getAscendingOrDescending()));
            }
            for (SQLColumn col : this.table.getChildren(SQLColumn.class)) {
                if (this.containsColumn(col)) continue;
                this.rowList.add(new Row(false, col, SQLIndex.AscendDescend.UNSPECIFIED));
            }
        }

        private boolean containsColumn(SQLColumn col) {
            for (Row r : this.rowList) {
                if (r.getSQLColumn() != col) continue;
                return true;
            }
            return false;
        }

        public List<Row> getRowList() {
            return this.rowList;
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(col);
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return IN_INDEX;
            }
            if (col == 1) {
                return COL_NAME;
            }
            if (col == 2) {
                return ORDER;
            }
            throw new SQLObjectRuntimeException(new SQLObjectException("This table only has 3 columns."));
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 1;
        }

        public void cleanup() {
            for (SQLColumn child : this.table.getChildren(SQLColumn.class)) {
                child.removeSPListener((SPListener)this);
            }
            this.table.removeSPListener((SPListener)this);
            this.actualIndex.removeSPListener((SPListener)this.indexListener);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.rowList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.rowList.get(row).isEnabled();
            }
            if (col == 1 && this.rowList.get(row).getSQLColumn() != null) {
                return this.rowList.get(row).getSQLColumn();
            }
            if (col == 1) {
                return this.rowList.get(row).getColumn();
            }
            if (col == 2) {
                return this.rowList.get(row).getOrder();
            }
            throw new SQLObjectRuntimeException(new SQLObjectException("This table only has 3 columns."));
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this.rowList.get(row).setEnabled((Boolean)value);
            } else if (col == 1) {
                if (value instanceof SQLColumn) {
                    this.rowList.get(row).setSQLColumn((SQLColumn)value);
                } else {
                    this.rowList.get(row).setColumn((SQLIndex.Column)value);
                }
            } else if (col == 2) {
                this.rowList.get(row).setOrder((SQLIndex.AscendDescend)value);
            } else {
                throw new SQLObjectRuntimeException(new SQLObjectException("This table only has 3 columns."));
            }
            this.fireTableCellUpdated(row, col);
        }

        public void childAdded(SPChildEvent e) {
            if (!e.getClass().equals(SQLColumn.class)) {
                return;
            }
            e.getChild().addSPListener((SPListener)this);
            this.rowList.add(new Row(false, (SQLIndex.Column)e.getChild(), SQLIndex.AscendDescend.UNSPECIFIED));
        }

        public void childRemoved(SPChildEvent e) {
            if (!e.getClass().equals(SQLColumn.class)) {
                return;
            }
            int rowToRemove = -1;
            int i = 0;
            SQLColumn removedCol = (SQLColumn)e.getChild();
            removedCol.removeSPListener((SPListener)this);
            for (Row row : this.rowList) {
                SQLColumn currentCol = row.getSQLColumn();
                if (currentCol == removedCol) {
                    rowToRemove = i;
                    break;
                }
                ++i;
            }
            if (rowToRemove == -1) {
                throw new IllegalStateException("SQLTable's column " + removedCol + " was just removed, but it " + "wasn't in the index table model. Creepy!");
            }
            this.rowList.remove(rowToRemove);
        }

        public void transactionEnded(TransactionEvent e) {
            this.fireTableDataChanged();
        }

        public void propertyChanged(PropertyChangeEvent e) {
        }

        public void transactionStarted(TransactionEvent e) {
        }

        public void transactionRollback(TransactionEvent e) {
        }

        private class ActualIndexListener
        extends AbstractPoolingSPListener {
            private ActualIndexListener() {
            }

            protected void transactionEndedImpl(TransactionEvent e) {
                IndexColumnTableModel.this.repopulateModel();
            }
        }
    }
}

