/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.ProfileSettings;
import ca.sqlpower.architect.profile.event.ProfileResultEvent;
import ca.sqlpower.architect.profile.event.ProfileResultListener;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.SQLPowerUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractProfileResult<T extends SQLObject>
extends AbstractSPObject
implements Comparable<AbstractProfileResult>,
ProfileResult<T> {
    private static final Logger logger = Logger.getLogger(AbstractProfileResult.class);
    private final T profiledObject;
    private long createEndTime = -1L;
    private long createStartTime = -1L;
    private String notes = "";
    private Exception ex;
    private ProfileSettings settings;
    private final List<ProfileResultListener> profileResultListeners = new ArrayList<ProfileResultListener>();

    public AbstractProfileResult(T profiledObject) {
        if (profiledObject == null) {
            throw new NullPointerException("The profiled object has to be non-null");
        }
        this.profiledObject = profiledObject;
    }

    public AbstractProfileResult(AbstractProfileResult<T> profileToCopy, T profiledObject) {
        this(profiledObject);
        this.createStartTime = profileToCopy.createStartTime;
        this.createEndTime = profileToCopy.createEndTime;
        this.ex = profileToCopy.ex;
        this.settings = profileToCopy.settings;
    }

    @Override
    @Accessor
    public T getProfiledObject() {
        return this.profiledObject;
    }

    @Override
    @Accessor
    public long getCreateStartTime() {
        return this.createStartTime;
    }

    @Mutator
    public void setCreateStartTime(long createStartTime) {
        long oldStartTime = this.createStartTime;
        this.createStartTime = createStartTime;
        this.firePropertyChange("createStartTime", oldStartTime, createStartTime);
    }

    @Override
    @Transient
    @Accessor
    public long getTimeToCreate() {
        return this.createEndTime - this.createStartTime;
    }

    @Mutator
    public void setCreateEndTime(long createEndTime) {
        long oldEndTime = this.createEndTime;
        this.createEndTime = createEndTime;
        this.firePropertyChange("createEndTime", oldEndTime, createEndTime);
    }

    @Override
    @Accessor
    public long getCreateEndTime() {
        return this.createEndTime;
    }

    @Override
    @Accessor
    public Exception getException() {
        return this.ex;
    }

    @Mutator
    public void setException(Exception ex) {
        Exception oldEx = this.ex;
        this.ex = ex;
        this.firePropertyChange("exception", oldEx, ex);
    }

    @Override
    public final int compareTo(AbstractProfileResult o) {
        T po = this.getProfiledObject();
        T opo = o.getProfiledObject();
        SQLObject so1 = (SQLObject)SQLPowerUtils.getAncestor(po, SQLDatabase.class);
        SQLObject so2 = (SQLObject)SQLPowerUtils.getAncestor(opo, SQLDatabase.class);
        int diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = (SQLObject)SQLPowerUtils.getAncestor(po, SQLCatalog.class);
        so2 = (SQLObject)SQLPowerUtils.getAncestor(opo, SQLCatalog.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = (SQLObject)SQLPowerUtils.getAncestor(po, SQLSchema.class);
        so2 = (SQLObject)SQLPowerUtils.getAncestor(opo, SQLSchema.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = (SQLObject)SQLPowerUtils.getAncestor(po, SQLTable.class);
        so2 = (SQLObject)SQLPowerUtils.getAncestor(opo, SQLTable.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = (SQLObject)SQLPowerUtils.getAncestor(po, SQLColumn.class);
        so2 = (SQLObject)SQLPowerUtils.getAncestor(opo, SQLColumn.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        if (this.createEndTime > o.createEndTime) {
            return 1;
        }
        if (this.createEndTime < o.createEndTime) {
            return -1;
        }
        if (this.createStartTime > o.createStartTime) {
            return 1;
        }
        if (this.createStartTime < o.createStartTime) {
            return -1;
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof AbstractProfileResult)) {
            return false;
        }
        AbstractProfileResult o = (AbstractProfileResult)obj;
        return this.compareTo(o) == 0;
    }

    public final int hashCode() {
        int hash = 17;
        T po = this.getProfiledObject();
        SQLObject so = (SQLObject)SQLPowerUtils.getAncestor(po, SQLDatabase.class);
        if (so != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = (SQLObject)SQLPowerUtils.getAncestor(po, SQLCatalog.class)) != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = (SQLObject)SQLPowerUtils.getAncestor(po, SQLSchema.class)) != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = (SQLObject)SQLPowerUtils.getAncestor(po, SQLTable.class)) != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = (SQLObject)SQLPowerUtils.getAncestor(po, SQLColumn.class)) != null) {
            hash *= so.getName().hashCode();
        }
        hash = (int)((long)hash * this.createEndTime);
        hash = (int)((long)hash * this.createStartTime);
        return hash;
    }

    @Accessor
    public ProfileSettings getSettings() {
        return this.settings;
    }

    @Mutator
    public void setSettings(ProfileSettings settings) {
        ProfileSettings oldSettings = this.settings;
        this.settings = settings;
        this.firePropertyChange("settings", (Object)oldSettings, (Object)settings);
    }

    @Override
    public void addProfileResultListener(ProfileResultListener listener) {
        this.profileResultListeners.add(listener);
    }

    @Override
    public void removeProfileResultListener(ProfileResultListener listener) {
        this.profileResultListeners.remove(listener);
    }

    protected final void fireProfileStarted() {
        logger.debug((Object)("Firing profile started event for " + this.profiledObject));
        ProfileResultEvent event = new ProfileResultEvent(this);
        for (int i = this.profileResultListeners.size() - 1; i >= 0; --i) {
            this.profileResultListeners.get(i).profileStarted(event);
        }
    }

    protected final void fireProfileFinished() {
        logger.debug((Object)("Firing profile finished event for " + this.profiledObject));
        ProfileResultEvent event = new ProfileResultEvent(this);
        for (int i = this.profileResultListeners.size() - 1; i >= 0; --i) {
            this.profileResultListeners.get(i).profileFinished(event);
        }
    }

    protected final void fireProfileCancelled() {
        logger.debug((Object)("Firing profile cancelled event for " + this.profiledObject));
        ProfileResultEvent event = new ProfileResultEvent(this);
        for (int i = this.profileResultListeners.size() - 1; i >= 0; --i) {
            this.profileResultListeners.get(i).profileCancelled(event);
        }
    }

    public List<? extends SPObject> getDependencies() {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(this.profiledObject);
        dependencies.add((Object)this.settings);
        return dependencies;
    }

    public void removeDependency(SPObject dependency) {
        if (this.getDependencies().contains(dependency)) {
            try {
                this.getParent().removeChild((SPObject)this);
            }
            catch (ObjectDependentException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("ProfileResult is not dependant on that.");
        }
    }

    @Mutator
    public void setNotes(String notes) {
        String oldVal = this.notes;
        this.notes = notes;
        this.firePropertyChange("notes", oldVal, notes);
    }

    @Accessor
    public String getNotes() {
        return this.notes;
    }
}

