/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3.fontface;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssSrc
extends org.w3c.css.properties.css.fontface.CssSrc {
    public CssSrc() {
        this.value = initial;
    }

    public CssSrc(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssExpression nex = new CssExpression();
            while (!expression.end() && expression.getOperator() == ' ') {
                nex.addValue(expression.getValue());
                expression.next();
            }
            if (!expression.end()) {
                nex.addValue(expression.getValue());
            }
            values.add(this.parseSrcLayer(ac, nex, check));
            if (expression.end()) continue;
            char op = expression.getOperator();
            if (op != ',') {
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            expression.next();
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
    }

    protected CssValue parseSrcLayer(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean gotUrl = false;
        boolean gotFormat = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            block0 : switch (val.getType()) {
                case 2: {
                    if (gotUrl) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    gotUrl = true;
                    values.add(val);
                    break;
                }
                case 11: {
                    String funcName;
                    CssFunction f = (CssFunction)val;
                    switch (funcName = f.getName().toLowerCase()) {
                        case "local": {
                            if (expression.getCount() > 1) {
                                throw new InvalidParamException("unrecognize", ac);
                            }
                            this.parseLocalFunction(ac, f);
                            values.add(f);
                            break block0;
                        }
                        case "format": {
                            if (gotFormat) {
                                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                            }
                            this.parseFormatFunction(ac, f);
                            gotFormat = true;
                            values.add(val);
                            break block0;
                        }
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
        }
        return values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    protected void parseFormatFunction(ApplContext ac, CssFunction f) throws InvalidParamException {
        CssExpression exp = f.getParameters();
        while (!exp.end()) {
            CssValue val = exp.getValue();
            char op = exp.getOperator();
            if (val.getType() != 1) {
                throw new InvalidParamException("value", val.toString(), f.getName(), ac);
            }
            if (op != ',' && exp.getRemainingCount() > 1) {
                throw new InvalidParamException("operator", Character.valueOf(op), f.getName(), ac);
            }
            exp.next();
        }
    }

    protected void parseLocalFunction(ApplContext ac, CssFunction f) throws InvalidParamException {
        CssExpression exp = f.getParameters();
        while (!exp.end()) {
            CssValue val = exp.getValue();
            char op = exp.getOperator();
            switch (val.getType()) {
                case 1: {
                    if (exp.getCount() <= 1) break;
                    throw new InvalidParamException("unrecognize", ac);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), f.getName(), ac);
                }
            }
            if (op != ' ' && exp.getRemainingCount() > 1) {
                throw new InvalidParamException("operator", Character.valueOf(op), f.getName(), ac);
            }
            exp.next();
        }
    }

    public CssSrc(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

