/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.Arrays;
import org.w3c.css.properties.css3.CssFontFamily;
import org.w3c.css.properties.css3.CssFontSize;
import org.w3c.css.properties.css3.CssFontStyle;
import org.w3c.css.properties.css3.CssFontVariant;
import org.w3c.css.properties.css3.CssFontWeight;
import org.w3c.css.properties.css3.CssLineHeight;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssFont
extends org.w3c.css.properties.css.CssFont {
    public static final CssIdent normal;
    public static final CssIdent[] systemFonts;
    static final String[] _systemFonts;

    public static final CssIdent getSystemFont(CssIdent ident) {
        int idx = Arrays.binarySearch(systemFonts, ident);
        if (idx >= 0) {
            return systemFonts[idx];
        }
        return null;
    }

    public CssFont() {
        this.value = initial;
    }

    public CssFont(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        boolean gotNormal = false;
        int state = 0;
        block7: while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 0: {
                    CssIdent v;
                    if (inherit.equals(val)) {
                        if (expression.getCount() != 1) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        this.value = inherit;
                        break;
                    }
                    CssIdent ident = CssFont.getSystemFont((CssIdent)val);
                    if (ident != null) {
                        if (expression.getCount() != 1) {
                            throw new InvalidParamException("system-font-keyword-not-sole-value", val.toString(), val.toString(), ac);
                        }
                        this.value = ident;
                        break;
                    }
                    ident = (CssIdent)val;
                    if (state == 0) {
                        if (normal.equals((CssIdent)val)) {
                            gotNormal = true;
                            break;
                        }
                        int pos = CssFontStyle.allowed_values.indexOf(ident);
                        if (pos >= 0) {
                            if (this.fontStyle != null) {
                                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                            }
                            this.fontStyle = new CssFontStyle();
                            this.fontStyle.value = CssFontStyle.allowed_values.get(pos);
                            break;
                        }
                        CssIdent v2 = org.w3c.css.properties.css21.CssFontVariant.getAllowedFontVariant(ident);
                        if (v2 != null) {
                            if (this.fontVariant != null) {
                                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                            }
                            this.fontVariant = new CssFontVariant();
                            this.fontVariant.value = v2;
                            break;
                        }
                        v2 = CssFontWeight.getAllowedValue(ident);
                        if (v2 != null) {
                            if (this.fontWeight != null) {
                                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                            }
                            this.fontWeight = new CssFontWeight();
                            this.fontWeight.value = v2;
                            break;
                        }
                    }
                    if (state == 0 && (v = CssFontSize.getAllowedValue(ident)) != null) {
                        state = 1;
                        if (this.fontSize != null) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        this.fontSize = new CssFontSize();
                        this.fontSize.value = v;
                        break;
                    }
                    if (state == 1) {
                        this.fontFamily = new CssFontFamily(ac, expression, check);
                        state = 2;
                        continue block7;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 14: {
                    if (this.fontSize == null || state != 1 || this.lineHeight != null) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    expression.next();
                    if (expression.end()) {
                        throw new InvalidParamException("value", expression.toString(), this.getPropertyName(), ac);
                    }
                    this.lineHeight = new CssLineHeight(ac, expression, false);
                    state = 1;
                    continue block7;
                }
                case 5: {
                    CssCheckableValue c = (CssCheckableValue)val;
                    if (!c.isZero()) {
                        if (state == 0 && this.fontWeight == null) {
                            this.fontWeight = new CssFontWeight(ac, expression, false);
                            continue block7;
                        }
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                }
                case 4: 
                case 6: {
                    if (state == 0 && this.fontSize == null) {
                        this.fontSize = new CssFontSize(ac, expression, false);
                        state = 1;
                        continue block7;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 1: {
                    if (state == 1) {
                        this.fontFamily = new CssFontFamily(ac, expression, check);
                        state = 2;
                        continue block7;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (gotNormal) {
            if (this.fontSize == null) {
                this.fontSize = new CssFontSize();
                this.fontSize.value = normal;
            }
            if (this.fontVariant == null) {
                this.fontVariant = new CssFontVariant();
                this.fontVariant.value = normal;
            }
            if (this.fontWeight == null) {
                this.fontWeight = new CssFontWeight();
                this.fontWeight.value = normal;
            }
        }
    }

    public CssFont(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        _systemFonts = new String[]{"caption", "icon", "menu", "message-box", "small-caption", "status-bar"};
        normal = CssIdent.getIdent("normal");
        systemFonts = new CssIdent[_systemFonts.length];
        int i = 0;
        for (String s : _systemFonts) {
            CssFont.systemFonts[i++] = CssIdent.getIdent(s);
        }
        Arrays.sort(systemFonts);
    }
}

