/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.atrules.css3.media;

import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class MediaScan
extends MediaFeature {
    static CssIdent progressive = CssIdent.getIdent("progressive");
    static CssIdent interlace = CssIdent.getIdent("interlace");

    public MediaScan() {
    }

    public MediaScan(ApplContext ac, String modifier, CssExpression expression, boolean check) throws InvalidParamException {
        if (modifier != null) {
            throw new InvalidParamException("nomodifiermedia", this.getFeatureName(), ac);
        }
        if (expression != null) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (expression.getCount() == 0) {
                throw new InvalidParamException("few-value", this.getFeatureName(), ac);
            }
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 0: {
                    CssIdent id = (CssIdent)val;
                    if (progressive.equals(id)) {
                        this.value = progressive;
                        break;
                    }
                    if (interlace.equals(id)) {
                        this.value = interlace;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", expression.getValue(), this.getFeatureName(), ac);
                }
            }
        }
    }

    public MediaScan(ApplContext ac, String modifier, CssExpression expression) throws InvalidParamException {
        this(ac, modifier, expression, false);
    }

    public void setModifier(ApplContext ac, String modifier) throws InvalidParamException {
        throw new InvalidParamException("nomodifiermedia", this.getFeatureName(), ac);
    }

    public Object get() {
        return this.value;
    }

    @Override
    public final String getFeatureName() {
        return "scan";
    }

    @Override
    public boolean equals(MediaFeature other) {
        try {
            MediaScan ms = (MediaScan)other;
            return this.value == null && ms.value == null || this.value != null && this.value.equals(ms.value);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }
}

