"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var getCurrentPointerPosition = function (state) { return state.interactions.pointer.current.position; };
exports.getProjectedPointerPositionSelector = re_reselect_1.default([getCurrentPointerPosition, compute_chart_dimensions_1.computeChartDimensionsSelector], function (currentPointerPosition, chartDimensions) {
    return getProjectedPointerPosition(currentPointerPosition, chartDimensions.chartDimensions);
})(get_chart_id_1.getChartIdSelector);
/**
 * Get the x and y pointer position relative to the chart projection area
 * @param chartAreaPointerPosition the pointer position relative to the chart area
 * @param chartAreaDimensions the chart dimensions
 */
function getProjectedPointerPosition(chartAreaPointerPosition, chartAreaDimensions) {
    var x = chartAreaPointerPosition.x, y = chartAreaPointerPosition.y;
    // get positions relative to chart
    var xPos = x - chartAreaDimensions.left;
    var yPos = y - chartAreaDimensions.top;
    // limit cursorPosition to the chart area
    if (xPos < 0 || xPos >= chartAreaDimensions.width) {
        xPos = -1;
    }
    if (yPos < 0 || yPos >= chartAreaDimensions.height) {
        yPos = -1;
    }
    return {
        x: xPos,
        y: yPos,
    };
}
//# sourceMappingURL=get_projected_pointer_position.js.map