"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var redux_1 = require("redux");
var react_redux_1 = require("react-redux");
var react_konva_1 = require("react-konva");
var area_geometries_1 = require("./area_geometries");
var bar_geometries_1 = require("./bar_geometries");
var line_geometries_1 = require("./line_geometries");
var line_annotation_1 = require("./line_annotation");
var rect_annotation_1 = require("./rect_annotation");
var grid_1 = require("./grid");
var axis_1 = require("./axis");
var bar_values_1 = require("./bar_values");
var compute_annotations_1 = require("../../state/selectors/compute_annotations");
var compute_chart_transform_1 = require("../../state/selectors/compute_chart_transform");
var get_specs_1 = require("../../state/selectors/get_specs");
var get_highlighted_series_1 = require("../../state/selectors/get_highlighted_series");
var is_chart_empty_1 = require("../../state/selectors/is_chart_empty");
var is_chart_animatable_1 = require("../../state/selectors/is_chart_animatable");
var is_brush_available_1 = require("../../state/selectors/is_brush_available");
var utils_1 = require("../../state/utils");
var specs_1 = require("../../utils/specs");
var chart_1 = require("../../../../state/actions/chart");
var is_initialized_1 = require("../../../../state/selectors/is_initialized");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var theme_1 = require("../../../../utils/themes/theme");
var light_theme_1 = require("../../../../utils/themes/light_theme");
var compute_series_geometries_1 = require("../../state/selectors/compute_series_geometries");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var compute_chart_dimensions_1 = require("../../state/selectors/compute_chart_dimensions");
var get_chart_container_dimensions_1 = require("../../../../state/selectors/get_chart_container_dimensions");
var Chart = /** @class */ (function (_super) {
    __extends(Chart, _super);
    function Chart() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.firstRender = true;
        _this.renderBarSeries = function (clippings) {
            var _a = _this.props, geometries = _a.geometries, theme = _a.theme, isChartAnimatable = _a.isChartAnimatable, highlightedLegendItem = _a.highlightedLegendItem;
            if (geometries.bars.length === 0) {
                return [];
            }
            var element = (react_1.default.createElement(bar_geometries_1.BarGeometries, { key: 'bar-geometries', animated: isChartAnimatable, bars: geometries.bars, sharedStyle: theme.sharedStyle, highlightedLegendItem: highlightedLegendItem, clippings: clippings }));
            return [
                {
                    element: element,
                    zIndex: 0,
                },
            ];
        };
        _this.renderLineSeries = function (clippings) {
            var _a = _this.props, geometries = _a.geometries, theme = _a.theme, isChartAnimatable = _a.isChartAnimatable, highlightedLegendItem = _a.highlightedLegendItem;
            if (geometries.lines.length === 0) {
                return [];
            }
            var element = (react_1.default.createElement(line_geometries_1.LineGeometries, { key: 'line-geometries', animated: isChartAnimatable, lines: geometries.lines, sharedStyle: theme.sharedStyle, highlightedLegendItem: highlightedLegendItem, clippings: clippings }));
            return [
                {
                    element: element,
                    zIndex: 0,
                },
            ];
        };
        _this.renderAreaSeries = function (clippings) {
            var _a = _this.props, geometries = _a.geometries, theme = _a.theme, isChartAnimatable = _a.isChartAnimatable, highlightedLegendItem = _a.highlightedLegendItem;
            if (geometries.areas.length === 0) {
                return [];
            }
            var element = (react_1.default.createElement(area_geometries_1.AreaGeometries, { key: 'area-geometries', animated: isChartAnimatable, areas: geometries.areas, sharedStyle: theme.sharedStyle, highlightedLegendItem: highlightedLegendItem, clippings: clippings }));
            return [
                {
                    element: element,
                    zIndex: 0,
                },
            ];
        };
        _this.renderAnnotations = function () {
            var _a = _this.props, annotationDimensions = _a.annotationDimensions, annotationSpecs = _a.annotationSpecs;
            var annotationElements = [];
            annotationDimensions.forEach(function (annotation, id) {
                var spec = utils_1.getSpecsById(annotationSpecs, id);
                if (!spec) {
                    return;
                }
                if (specs_1.isLineAnnotation(spec)) {
                    var lineStyle = theme_1.mergeWithDefaultAnnotationLine(spec.style);
                    var element = (react_1.default.createElement(line_annotation_1.LineAnnotation, { key: "line-annotation-group-" + id, lines: annotation, lineStyle: lineStyle }));
                    annotationElements.push({
                        element: element,
                        zIndex: spec.zIndex || 0,
                    });
                }
                else if (specs_1.isRectAnnotation(spec)) {
                    var rectStyle = theme_1.mergeWithDefaultAnnotationRect(spec.style);
                    var element = (react_1.default.createElement(rect_annotation_1.RectAnnotation, { key: "rect-annotation-group-" + id, rects: annotation, rectStyle: rectStyle }));
                    annotationElements.push({
                        element: element,
                        zIndex: spec.zIndex || 0,
                    });
                }
            });
            return annotationElements;
        };
        _this.renderDebugChartBorders = function () {
            var chartDimensions = _this.props.chartDimensions;
            return (react_1.default.createElement(react_konva_1.Rect, { x: chartDimensions.left, y: chartDimensions.top, width: chartDimensions.width, height: chartDimensions.height, stroke: "red", strokeWidth: 4, listening: false, dash: [4, 4] }));
        };
        return _this;
    }
    Chart.prototype.componentDidUpdate = function () {
        if (this.props.initialized) {
            this.props.onChartRendered();
        }
    };
    Chart.prototype.sortAndRenderElements = function () {
        var _a = this.props, chartDimensions = _a.chartDimensions, chartRotation = _a.chartRotation;
        var clippings = {
            clipX: 0,
            clipY: 0,
            clipWidth: [90, -90].includes(chartRotation) ? chartDimensions.height : chartDimensions.width,
            clipHeight: [90, -90].includes(chartRotation) ? chartDimensions.width : chartDimensions.height,
        };
        var bars = this.renderBarSeries(clippings);
        var areas = this.renderAreaSeries(clippings);
        var lines = this.renderLineSeries(clippings);
        var annotations = this.renderAnnotations();
        return __spread(bars, areas, lines, annotations).sort(function (elemIdxA, elemIdxB) { return elemIdxA.zIndex - elemIdxB.zIndex; })
            .map(function (elemIdx) { return elemIdx.element; });
    };
    Chart.prototype.render = function () {
        var _this = this;
        var _a = this.props, initialized = _a.initialized, chartRotation = _a.chartRotation, chartDimensions = _a.chartDimensions, isChartEmpty = _a.isChartEmpty, debug = _a.debug, chartContainerDimensions = _a.chartContainerDimensions;
        if (!initialized || chartDimensions.width === 0 || chartDimensions.height === 0) {
            return null;
        }
        var chartTransform = this.props.chartTransform;
        if (isChartEmpty) {
            return (react_1.default.createElement("div", { className: "echReactiveChart_unavailable" },
                react_1.default.createElement("p", null, "No data to display")));
        }
        var brushProps = {};
        return (react_1.default.createElement(react_redux_1.ReactReduxContext.Consumer, null, function (_a) {
            var store = _a.store;
            return (react_1.default.createElement(react_konva_1.Stage, __assign({ width: chartContainerDimensions.width, height: chartContainerDimensions.height, ref: _this.props.forwardStageRef, style: {
                    width: '100%',
                    height: '100%',
                } }, brushProps),
                react_1.default.createElement(react_redux_1.Provider, { store: store },
                    react_1.default.createElement(react_konva_1.Layer, { hitGraphEnabled: false, listening: false },
                        react_1.default.createElement(grid_1.Grid, null),
                        react_1.default.createElement(axis_1.Axes, null))),
                react_1.default.createElement(react_konva_1.Layer, { x: chartDimensions.left + chartTransform.x, y: chartDimensions.top + chartTransform.y, rotation: chartRotation, hitGraphEnabled: false, listening: false }, _this.sortAndRenderElements()),
                react_1.default.createElement(react_redux_1.Provider, { store: store },
                    react_1.default.createElement(react_konva_1.Layer, { hitGraphEnabled: false, listening: false },
                        react_1.default.createElement(bar_values_1.BarValues, null))),
                debug && (react_1.default.createElement(react_konva_1.Layer, { hitGraphEnabled: false, listening: false }, _this.renderDebugChartBorders()))));
        }));
    };
    Chart.displayName = 'ReactiveChart';
    return Chart;
}(react_1.default.Component));
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({
        onChartRendered: chart_1.onChartRendered,
    }, dispatch);
};
var DEFAULT_PROPS = {
    initialized: false,
    theme: light_theme_1.LIGHT_THEME,
    geometries: {
        areas: [],
        bars: [],
        lines: [],
        points: [],
    },
    debug: false,
    chartContainerDimensions: {
        width: 0,
        height: 0,
        left: 0,
        top: 0,
    },
    chartRotation: 0,
    chartDimensions: {
        width: 0,
        height: 0,
        left: 0,
        top: 0,
    },
    chartTransform: {
        x: 0,
        y: 0,
        rotate: 0,
    },
    isChartAnimatable: false,
    isChartEmpty: true,
    annotationDimensions: new Map(),
    annotationSpecs: [],
    isBrushAvailable: false,
    highlightedLegendItem: undefined,
};
var mapStateToProps = function (state) {
    if (!is_initialized_1.isInitialized(state)) {
        return DEFAULT_PROPS;
    }
    return {
        initialized: true,
        theme: get_chart_theme_1.getChartThemeSelector(state),
        geometries: compute_series_geometries_1.computeSeriesGeometriesSelector(state).geometries,
        chartContainerDimensions: get_chart_container_dimensions_1.getChartContainerDimensionsSelector(state),
        debug: get_settings_specs_1.getSettingsSpecSelector(state).debug,
        chartRotation: get_chart_rotation_1.getChartRotationSelector(state),
        chartDimensions: compute_chart_dimensions_1.computeChartDimensionsSelector(state).chartDimensions,
        chartTransform: compute_chart_transform_1.computeChartTransformSelector(state),
        isChartAnimatable: is_chart_animatable_1.isChartAnimatableSelector(state),
        isChartEmpty: is_chart_empty_1.isChartEmptySelector(state),
        annotationDimensions: compute_annotations_1.computeAnnotationDimensionsSelector(state),
        annotationSpecs: get_specs_1.getAnnotationSpecsSelector(state),
        isBrushAvailable: is_brush_available_1.isBrushAvailableSelector(state),
        highlightedLegendItem: get_highlighted_series_1.getHighlightedSeriesSelector(state),
    };
};
exports.ReactiveChart = react_redux_1.connect(mapStateToProps, mapDispatchToProps)(Chart);
//# sourceMappingURL=reactive_chart.js.map