"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
function rotateBarValueProps(chartRotation, chartDimensions, barDimensions, displayValueDimensions, displayValue, props) {
    var chartWidth = chartDimensions.width;
    var chartHeight = chartDimensions.height;
    var barWidth = barDimensions.width;
    var barHeight = barDimensions.height;
    var x = barDimensions.left;
    var y = barDimensions.top;
    var displayValueWidth = displayValueDimensions.width;
    var displayValueHeight = displayValueDimensions.height;
    var displayValueX = displayValueDimensions.left;
    var displayValueY = displayValueDimensions.top;
    var rotatedDisplayValueX = displayValueHeight > barWidth
        ? x - Math.abs(barWidth - displayValueHeight) / 2
        : x + Math.abs(barWidth - displayValueHeight) / 2;
    switch (chartRotation) {
        case 0:
            props.x = displayValueX;
            props.y = displayValueY;
            break;
        case 180:
            props.x = chartWidth - displayValueX - displayValueWidth;
            props.y = chartHeight - displayValueY - displayValueHeight;
            props.verticalAlign = 'bottom';
            break;
        case 90:
            props.x =
                barHeight >= displayValueWidth ? chartWidth - displayValueY - displayValueWidth : chartWidth - displayValueY;
            props.y = rotatedDisplayValueX;
            props.verticalAlign = 'middle';
            if (displayValue.isValueContainedInElement) {
                props.x = chartWidth - y - barHeight;
                props.y = x;
                props.width = barHeight >= displayValueWidth ? barHeight : 0;
                props.height = displayValue.height <= barWidth ? barWidth : 0;
                props.align = 'right';
            }
            break;
        case -90:
            props.x = barHeight >= displayValueWidth ? displayValueY : displayValueY - displayValueWidth;
            props.y = chartHeight - rotatedDisplayValueX - displayValueHeight;
            props.verticalAlign = 'middle';
            if (displayValue.isValueContainedInElement) {
                props.x = y;
                props.y = chartHeight - x - barWidth;
                props.width = barHeight >= displayValueWidth ? barHeight : 0;
                props.height = displayValue.height <= barWidth ? barWidth : 0;
                props.align = 'left';
            }
            break;
    }
    return props;
}
exports.rotateBarValueProps = rotateBarValueProps;
function buildBarValueProps(_a) {
    var x = _a.x, y = _a.y, barHeight = _a.barHeight, barWidth = _a.barWidth, displayValueStyle = _a.displayValueStyle, displayValue = _a.displayValue, chartRotation = _a.chartRotation, chartDimensions = _a.chartDimensions;
    var padding = displayValueStyle.padding;
    var elementHeight = displayValue.isValueContainedInElement ? barHeight : displayValue.height;
    var displayValueHeight = elementHeight + padding;
    var displayValueWidth = displayValue.width + padding;
    var displayValueY = barHeight >= displayValueHeight ? y : y - displayValueHeight;
    var displayValueX = displayValueWidth > barWidth
        ? x - Math.abs(barWidth - displayValueWidth) / 2
        : x + Math.abs(barWidth - displayValueWidth) / 2;
    var displayValueOffsetY = displayValueStyle.offsetY || 0;
    var displayValueOffsetX = displayValueStyle.offsetX || 0;
    var baseProps = __assign(__assign({ align: 'center', verticalAlign: 'top' }, displayValueStyle), { text: displayValue.text, width: displayValueWidth, height: displayValueHeight, offsetY: displayValueOffsetY, x: displayValueX, y: displayValueY });
    var barDimensions = {
        width: barWidth,
        height: barHeight,
        left: x,
        top: y,
    };
    var displayValueDimensions = {
        width: displayValueWidth,
        height: displayValueHeight,
        left: displayValueX,
        top: displayValueY,
    };
    var props = rotateBarValueProps(chartRotation, chartDimensions, barDimensions, displayValueDimensions, displayValue, baseProps);
    var clip = getBarValueClipDimensions(displayValue, props, barHeight, chartRotation);
    var hideOverflow = isBarValueOverflow(chartDimensions, clip, { x: props.x, y: props.y, offsetX: displayValueOffsetX, offsetY: displayValueOffsetY }, displayValue.hideClippedValue);
    if (hideOverflow) {
        props.width = 0;
        props.height = 0;
    }
    return props;
}
exports.buildBarValueProps = buildBarValueProps;
function getBarValueClipDimensions(displayValue, computedDimensions, barHeight, chartRotation) {
    var height = displayValue.isValueContainedInElement ? displayValue.height : computedDimensions.height;
    var width = displayValue.isValueContainedInElement ? displayValue.width : computedDimensions.width;
    var offsetY = chartRotation === 180 ? barHeight - displayValue.height : 0;
    var offsetX = chartRotation === 90 ? barHeight - displayValue.width : 0;
    return { height: height, width: width, offsetX: offsetX, offsetY: offsetY };
}
exports.getBarValueClipDimensions = getBarValueClipDimensions;
function isBarValueOverflow(chartDimensions, clip, valuePosition, hideClippedValue) {
    var chartHeight = chartDimensions.height;
    var chartWidth = chartDimensions.width;
    var isOverflowX = valuePosition.x + clip.width - valuePosition.offsetX > chartWidth ||
        valuePosition.x + clip.offsetX - valuePosition.offsetX < 0;
    var isOverflowY = valuePosition.y + clip.height - valuePosition.offsetY > chartHeight ||
        valuePosition.y + clip.offsetY - valuePosition.offsetY < 0;
    return !!hideClippedValue && (isOverflowX || isOverflowY);
}
exports.isBarValueOverflow = isBarValueOverflow;
/**
 * Creates `clipFunc` for Konva paths that have clipped ranges
 *
 * @param clippedRanges ranges to be clipped from rendering
 * @param clippings konva global clippings
 * @param negate show, rather than exclude, only selected ranges
 */
function clipRanges(clippedRanges, clippings, negate) {
    if (negate === void 0) { negate = false; }
    var length = clippedRanges.length;
    var clipHeight = clippings.clipHeight, clipWidth = clippings.clipWidth;
    if (negate) {
        return function (ctx) {
            clippedRanges.forEach(function (_a) {
                var _b = __read(_a, 2), x0 = _b[0], x1 = _b[1];
                ctx.rect(x0, 0, x1 - x0, clippings.clipHeight);
            });
        };
    }
    return function (ctx) {
        if (length > 0) {
            ctx.rect(0, 0, clippedRanges[0][0], clipHeight);
            var lastX = clippedRanges[length - 1][1];
            ctx.rect(lastX, 0, clipWidth - lastX, clipHeight);
        }
        if (length > 1) {
            for (var i = 1; i < length; i++) {
                var _a = __read(clippedRanges[i - 1], 2), x0 = _a[1];
                var _b = __read(clippedRanges[i], 1), x1 = _b[0];
                ctx.rect(x0, 0, x1 - x0, clipHeight);
            }
        }
    };
}
exports.clipRanges = clipRanges;
//# sourceMappingURL=bar_values_utils.js.map