/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.DTDIgnoringEntityResolver;
import org.pentaho.di.core.xml.XMLHandlerCache;
import org.pentaho.di.core.xml.XMLHandlerCacheEntry;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLHandler {
    private static XMLHandlerCache cache = XMLHandlerCache.getInstance();
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    public static final String getXMLHeader() {
        return XMLHandler.getXMLHeader("UTF-8");
    }

    public static final String getXMLHeader(String encoding) {
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>" + Const.CR;
    }

    public static final String getTagValue(Node n, String tag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || childnode.getFirstChild() == null) continue;
            return childnode.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static final String getTagValueWithAttribute(Node n, String tag, String attribute) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || childnode.getAttributes().getNamedItem(attribute) == null || childnode.getFirstChild() == null) continue;
            return childnode.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static final String getTagValue(Node n, String tag, String subtag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            NodeList tags = childnode.getChildNodes();
            for (int j = 0; j < tags.getLength(); ++j) {
                Node tagnode = tags.item(j);
                if (!tagnode.getNodeName().equalsIgnoreCase(subtag) || tagnode.getFirstChild() == null) continue;
                return tagnode.getFirstChild().getNodeValue();
            }
        }
        return null;
    }

    public static final int countNodes(Node n, String tag) {
        int count = 0;
        if (n == null) {
            return 0;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            ++count;
        }
        return count;
    }

    public static final Node getNodeWithTagValue(Node n, String tag, String subtag, String subtagvalue, int nr) {
        int count = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node tagnode;
            String value;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || !(value = XMLHandler.getNodeValue(tagnode = XMLHandler.getSubNode(childnode, subtag))).equalsIgnoreCase(subtagvalue)) continue;
            if (count == nr) {
                return childnode;
            }
            ++count;
        }
        return null;
    }

    public static final Node getNodeWithAttributeValue(Node n, String tag, String attributeName, String attributeValue) {
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node attribute;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || (attribute = childnode.getAttributes().getNamedItem(attributeName)) == null || !attributeValue.equals(attribute.getTextContent())) continue;
            return childnode;
        }
        return null;
    }

    public static final Node getSubNode(Node n, String tag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            return childnode;
        }
        return null;
    }

    public static final Node getSubNode(Node n, String tag, String subtag) {
        Node t = XMLHandler.getSubNode(n, tag);
        if (t != null) {
            return XMLHandler.getSubNode(t, subtag);
        }
        return null;
    }

    public static final Node getSubNodeByNr(Node n, String tag, int nr) {
        return XMLHandler.getSubNodeByNr(n, tag, nr, true);
    }

    public static final Node getSubNodeByNr(Node n, String tag, int nr, boolean useCache) {
        if (n == null) {
            return null;
        }
        int count = 0;
        NodeList children = n.getChildNodes();
        int lastChildNr = -1;
        XMLHandlerCacheEntry entry = null;
        if (useCache) {
            entry = new XMLHandlerCacheEntry(n, tag);
            lastChildNr = cache.getLastChildNr(entry);
        }
        if (lastChildNr < 0) {
            lastChildNr = 0;
        } else {
            count = nr;
            ++lastChildNr;
        }
        for (int i = lastChildNr; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            if (count == nr) {
                if (useCache) {
                    cache.storeCache(entry, i);
                }
                return childnode;
            }
            ++count;
        }
        return null;
    }

    public static final String getNodeValue(Node n) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            String retval = childnode.getNodeValue();
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public static final String getTagAttribute(Node node, String attribute) {
        Node attr;
        String retval = null;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null && (attr = nnm.getNamedItem(attribute)) != null) {
            retval = attr.getNodeValue();
        }
        return retval;
    }

    public static final Document loadXMLFile(String filename) throws KettleXMLException {
        try {
            return XMLHandler.loadXMLFile(KettleVFS.getFileObject(filename));
        }
        catch (IOException e) {
            throw new KettleXMLException(e);
        }
    }

    public static final Document loadXMLFile(FileObject fileObject) throws KettleXMLException {
        return XMLHandler.loadXMLFile(fileObject, null, false, false);
    }

    public static final Document loadXMLFile(FileObject fileObject, String systemID, boolean ignoreEntities, boolean namespaceAware) throws KettleXMLException {
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setNamespaceAware(namespaceAware);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (ignoreEntities) {
                db.setEntityResolver(new DTDIgnoringEntityResolver());
            }
            InputStream inputStream = null;
            try {
                if (Const.isEmpty(systemID)) {
                    inputStream = KettleVFS.getInputStream(fileObject);
                    doc = db.parse(inputStream);
                } else {
                    String systemIDwithEndingSlash = systemID.trim();
                    if (!systemIDwithEndingSlash.endsWith("/") && !systemIDwithEndingSlash.endsWith("\\")) {
                        systemIDwithEndingSlash = systemIDwithEndingSlash.concat("/");
                    }
                    inputStream = KettleVFS.getInputStream(fileObject);
                    doc = db.parse(inputStream, systemIDwithEndingSlash);
                }
            }
            catch (FileNotFoundException ef) {
                throw new KettleXMLException(ef);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            return doc;
        }
        catch (Exception e) {
            throw new KettleXMLException("Error reading information from file", e);
        }
    }

    public static final Document loadXMLFile(File resource) throws KettleXMLException {
        try {
            return XMLHandler.loadXMLFile(resource.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new KettleXMLException(e);
        }
    }

    public static final Document loadXMLFile(URL resource) throws KettleXMLException {
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream inputStream = resource.openStream();
            try {
                doc = db.parse(inputStream);
            }
            catch (IOException ef) {
                throw new KettleXMLException(ef);
            }
            finally {
                inputStream.close();
            }
            return doc;
        }
        catch (Exception e) {
            throw new KettleXMLException("Error reading information from resource", e);
        }
    }

    public static final Document loadXMLString(String string) throws KettleXMLException {
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            try {
                doc = db.parse(inputSource);
            }
            catch (IOException ef) {
                throw new KettleXMLException("Error parsing XML", ef);
            }
            finally {
                stringReader.close();
            }
            return doc;
        }
        catch (Exception e) {
            throw new KettleXMLException("Error reading information from XML string : " + Const.CR + string, e);
        }
    }

    public static final String getString() {
        return XMLHandler.class.getName();
    }

    public static final String addTagValue(String tag, String val, boolean cr, String ... attributes) {
        StringBuffer value;
        if (val != null && val.length() > 0) {
            value = new StringBuffer("<");
            value.append(tag);
            for (int i = 0; i < attributes.length; i += 2) {
                value.append(" ").append(attributes[i]).append("=\"").append(attributes[i + 1]).append("\" ");
            }
            value.append('>');
            XMLHandler.appendReplacedChars(value, val);
            value.append("</");
            value.append(tag);
            value.append('>');
        } else {
            value = new StringBuffer("<");
            value.append(tag);
            for (int i = 0; i < attributes.length; i += 2) {
                value.append(" ").append(attributes[i]).append("=\"").append(attributes[i + 1]).append("\" ");
            }
            value.append("/>");
        }
        if (cr) {
            value.append(Const.CR);
        }
        return value.toString();
    }

    public static void appendReplacedChars(StringBuffer value, String string) {
        boolean isCDATA = string.startsWith("<![CDATA[") && string.endsWith("]]>");
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    value.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    value.append("&apos;");
                    continue block9;
                }
                case '<': {
                    if (i != 0 || !isCDATA) {
                        value.append("&lt;");
                        continue block9;
                    }
                    value.append(c);
                    continue block9;
                }
                case '>': {
                    if (i != string.length() - 1 || !isCDATA) {
                        value.append("&gt;");
                        continue block9;
                    }
                    value.append(c);
                    continue block9;
                }
                case '\"': {
                    value.append("&quot;");
                    continue block9;
                }
                case '/': {
                    if (isCDATA) {
                        value.append(c);
                        continue block9;
                    }
                    value.append("&#47;");
                    continue block9;
                }
                case '\u001a': {
                    value.append("{ILLEGAL XML CHARACTER 0x1A}");
                    continue block9;
                }
                default: {
                    value.append(c);
                }
            }
        }
    }

    public static final String addTagValue(String tag, String val) {
        return XMLHandler.addTagValue(tag, val, true, new String[0]);
    }

    public static final String addTagValue(String tag, boolean bool) {
        return XMLHandler.addTagValue(tag, bool, true);
    }

    public static final String addTagValue(String tag, boolean bool, boolean cr) {
        return XMLHandler.addTagValue(tag, bool ? "Y" : "N", cr, new String[0]);
    }

    public static final String addTagValue(String tag, long l) {
        return XMLHandler.addTagValue(tag, l, true);
    }

    public static final String addTagValue(String tag, long l, boolean cr) {
        return XMLHandler.addTagValue(tag, String.valueOf(l), cr, new String[0]);
    }

    public static final String addTagValue(String tag, int i) {
        return XMLHandler.addTagValue(tag, i, true);
    }

    public static final String addTagValue(String tag, int i, boolean cr) {
        return XMLHandler.addTagValue(tag, "" + i, cr, new String[0]);
    }

    public static final String addTagValue(String tag, double d) {
        return XMLHandler.addTagValue(tag, d, true);
    }

    public static final String addTagValue(String tag, double d, boolean cr) {
        return XMLHandler.addTagValue(tag, "" + d, cr, new String[0]);
    }

    public static final String addTagValue(String tag, Date date) {
        return XMLHandler.addTagValue(tag, date, true);
    }

    public static final String addTagValue(String tag, Date date, boolean cr) {
        return XMLHandler.addTagValue(tag, XMLHandler.date2string(date), cr, new String[0]);
    }

    public static final String addTagValue(String tag, BigDecimal val) {
        return XMLHandler.addTagValue(tag, val, true);
    }

    public static final String addTagValue(String tag, BigDecimal val, boolean cr) {
        return XMLHandler.addTagValue(tag, val != null ? val.toString() : (String)null, true, new String[0]);
    }

    public static final String addTagValue(String tag, byte[] val) throws IOException {
        return XMLHandler.addTagValue(tag, val, true);
    }

    public static final String addTagValue(String tag, byte[] val, boolean cr) throws IOException {
        String string;
        if (val == null) {
            string = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            BufferedOutputStream bos = new BufferedOutputStream(gzos);
            bos.write(val);
            bos.flush();
            bos.close();
            string = new String(Base64.encodeBase64((byte[])baos.toByteArray()));
        }
        return XMLHandler.addTagValue(tag, string, true, new String[0]);
    }

    public static String[] getNodeAttributes(Node node) {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            String[] attributes = new String[nnm.getLength()];
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node attr = nnm.item(i);
                attributes[i] = attr.getNodeName();
            }
            return attributes;
        }
        return null;
    }

    public static String[] getNodeElements(Node node) {
        ArrayList<String> elements = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeName = nodeList.item(i).getNodeName();
            if (elements.indexOf(nodeName) >= 0) continue;
            elements.add(nodeName);
        }
        if (elements.isEmpty()) {
            return null;
        }
        return elements.toArray(new String[elements.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String dateString) {
        if (Const.isEmpty(dateString)) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = XMLHandler.simpleDateFormat;
            synchronized (simpleDateFormat) {
                return XMLHandler.simpleDateFormat.parse(dateString);
            }
        }
        catch (ParseException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String date2string(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = XMLHandler.simpleDateFormat;
        synchronized (simpleDateFormat) {
            return XMLHandler.simpleDateFormat.format(date);
        }
    }

    public static byte[] stringToBinary(String string) throws IOException {
        byte[] bytes = string == null ? new byte[]{} : Base64.decodeBase64((byte[])string.getBytes());
        if (bytes.length > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            GZIPInputStream gzip = new GZIPInputStream(bais);
            BufferedInputStream bi = new BufferedInputStream(gzip);
            byte[] result = new byte[]{};
            byte[] extra = new byte[1000000];
            int nrExtra = bi.read(extra);
            while (nrExtra >= 0) {
                int i;
                int newSize = result.length + nrExtra;
                byte[] tmp = new byte[newSize];
                for (i = 0; i < result.length; ++i) {
                    tmp[i] = result[i];
                }
                for (i = 0; i < nrExtra; ++i) {
                    tmp[result.length + i] = extra[i];
                }
                result = tmp;
                nrExtra = bi.read(extra);
            }
            bytes = result;
            gzip.close();
        }
        return bytes;
    }

    public static String buildCDATA(String string) {
        StringBuffer cdata = new StringBuffer("<![CDATA[");
        cdata.append(Const.NVL(string, "")).append("]]>");
        return cdata.toString();
    }

    public static final String openTag(String tag) {
        return "<" + tag + ">";
    }

    public static final String closeTag(String tag) {
        return "</" + tag + ">";
    }
}

