/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import nu.validator.checker.AttributeUtil;
import nu.validator.checker.Checker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UnsupportedFeatureChecker
extends Checker {
    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" != uri) {
            return;
        }
        if ("dialog" == localName || "bdi" == localName) {
            this.warnAboutElement(localName);
        } else if ("textarea" == localName) {
            if (atts.getIndex("", "dirname") > -1) {
                this.warnAboutAttributeOnElement("dirname", "textarea");
            }
            if (atts.getIndex("", "inputmode") > -1) {
                this.warnAboutAttribute("inputmode");
            }
        } else if ("input" == localName) {
            String type;
            if (atts.getIndex("", "dirname") > -1) {
                this.warnAboutAttributeOnElement("dirname", "input");
            }
            if (atts.getIndex("", "inputmode") > -1) {
                this.warnAboutAttribute("inputmode");
            }
            if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("date", type = atts.getValue("", "type"))) {
                this.warnAboutInputType("date");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("month", type)) {
                this.warnAboutInputType("month");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("week", type)) {
                this.warnAboutInputType("week");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("time", type)) {
                this.warnAboutInputType("time");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("datetime-local", type)) {
                this.warnAboutInputType("datetime-local");
            } else if (AttributeUtil.lowerCaseLiteralEqualsIgnoreAsciiCaseString("color", type)) {
                this.warnAboutInputType("color");
            }
        }
    }

    private void warnAboutInputType(String name) throws SAXException {
        this.warn("The \u201c" + name + "\u201d input type is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
    }

    private void warnAboutAttribute(String name) throws SAXException {
        this.warn("The \u201c" + name + "\u201d attribute is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
    }

    private void warnAboutElement(String name) throws SAXException {
        this.warn("The \u201c" + name + "\u201d element is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
    }

    private void warnAboutAttributeOnElement(String attributeName, String elementName) throws SAXException {
        this.warn("The \u201c" + attributeName + "\u201d attribute on the \u201c" + elementName + "\u201d element is not supported in all browsers. Please be sure to test, and consider using a polyfill.");
    }
}

