/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.IntFunction;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetLongMerger;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.LongFuncSlotAcc;
import org.apache.solr.search.facet.LongSortedNumericDVAcc;
import org.apache.solr.search.facet.LongSortedSetDVAcc;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UnInvertedFieldAcc;
import org.apache.solr.search.function.FieldNameValueSource;

public class CountValsAgg
extends SimpleAggValueSource {
    public CountValsAgg(ValueSource vs) {
        super("countvals", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        ValueSource vs = this.getArg();
        if (vs instanceof FieldNameValueSource) {
            String field = ((FieldNameValueSource)vs).getFieldName();
            SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(field);
            if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
                if (sf.hasDocValues()) {
                    if (sf.getType().isPointField()) {
                        return new CountSortedNumericDVAcc(fcontext, sf, numSlots);
                    }
                    return new CountSortedSetDVAcc(fcontext, sf, numSlots);
                }
                if (sf.getType().isPointField()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'countvals' aggregation not supported for PointField without docValues");
                }
                return new CountMultiValuedAcc(fcontext, sf, numSlots);
            }
            vs = sf.getType().getValueSource(sf, null);
        }
        return new CountValSlotAcc(vs, fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new FacetLongMerger();
    }

    class CountMultiValuedAcc
    extends UnInvertedFieldAcc {
        private int currentSlot;
        long[] result;

        public CountMultiValuedAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots);
            this.result = new long[numSlots];
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            this.currentSlot = slot;
            this.docToTerm.getBigTerms(doc + this.currentDocBase, this);
            this.docToTerm.getSmallTerms(doc + this.currentDocBase, this);
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Long.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            return this.result[slotNum];
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.result, 0L);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            resizer.resize(this.result, 0L);
        }

        @Override
        public void call(int termNum) {
            int n = this.currentSlot;
            this.result[n] = this.result[n] + 1L;
        }
    }

    class CountSortedSetDVAcc
    extends LongSortedSetDVAcc {
        public CountSortedSetDVAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0L);
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            while (this.values.nextOrd() != -1L) {
                int n = slot;
                this.result[n] = this.result[n] + 1L;
            }
        }
    }

    class CountSortedNumericDVAcc
    extends LongSortedNumericDVAcc {
        public CountSortedNumericDVAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0L);
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            int n = slot;
            this.result[n] = this.result[n] + (long)this.values.docValueCount();
        }
    }

    class CountValSlotAcc
    extends LongFuncSlotAcc {
        public CountValSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots, 0L);
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            if (this.values.exists(doc)) {
                int n = slot;
                this.result[n] = this.result[n] + 1L;
            }
        }
    }
}

