/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.TriggerBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.metrics.SolrCoreMetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRateTrigger
extends TriggerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COLLECTIONS_PROP = "collections";
    public static final String METRIC_PROP = "metric";
    public static final String MAX_OPS_PROP = "maxOps";
    public static final String MIN_REPLICAS_PROP = "minReplicas";
    public static final String ABOVE_RATE_PROP = "aboveRate";
    public static final String BELOW_RATE_PROP = "belowRate";
    public static final String ABOVE_NODE_RATE_PROP = "aboveNodeRate";
    public static final String BELOW_NODE_RATE_PROP = "belowNodeRate";
    public static final String ABOVE_OP_PROP = "aboveOp";
    public static final String BELOW_OP_PROP = "belowOp";
    public static final String ABOVE_NODE_OP_PROP = "aboveNodeOp";
    public static final String BELOW_NODE_OP_PROP = "belowNodeOp";
    public static final String BC_COLLECTION_PROP = "collection";
    public static final String BC_RATE_PROP = "rate";
    public static final String HOT_NODES = "hotNodes";
    public static final String HOT_COLLECTIONS = "hotCollections";
    public static final String HOT_SHARDS = "hotShards";
    public static final String HOT_REPLICAS = "hotReplicas";
    public static final String COLD_NODES = "coldNodes";
    public static final String COLD_COLLECTIONS = "coldCollections";
    public static final String COLD_SHARDS = "coldShards";
    public static final String COLD_REPLICAS = "coldReplicas";
    public static final String VIOLATION_PROP = "violationType";
    public static final int DEFAULT_MAX_OPS = 3;
    public static final String DEFAULT_METRIC = "QUERY./select.requestTimes:1minRate";
    private String metric;
    private int maxOps;
    private Integer minReplicas = null;
    private final Set<String> collections = new HashSet<String>();
    private String shard;
    private String node;
    private double aboveRate;
    private double belowRate;
    private double aboveNodeRate;
    private double belowNodeRate;
    private CollectionParams.CollectionAction aboveOp;
    private CollectionParams.CollectionAction belowOp;
    private CollectionParams.CollectionAction aboveNodeOp;
    private CollectionParams.CollectionAction belowNodeOp;
    private final Map<String, Long> lastCollectionEvent = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> lastNodeEvent = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> lastShardEvent = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> lastReplicaEvent = new ConcurrentHashMap<String, Long>();
    private final Map<String, Object> state = new HashMap<String, Object>();

    public SearchRateTrigger(String name) {
        super(TriggerEventType.SEARCHRATE, name);
        this.state.put("lastCollectionEvent", this.lastCollectionEvent);
        this.state.put("lastNodeEvent", this.lastNodeEvent);
        this.state.put("lastShardEvent", this.lastShardEvent);
        this.state.put("lastReplicaEvent", this.lastReplicaEvent);
        TriggerUtils.validProperties(this.validProperties, COLLECTIONS_PROP, "shard", "node", METRIC_PROP, MAX_OPS_PROP, MIN_REPLICAS_PROP, ABOVE_OP_PROP, BELOW_OP_PROP, ABOVE_NODE_OP_PROP, BELOW_NODE_OP_PROP, ABOVE_RATE_PROP, BELOW_RATE_PROP, ABOVE_NODE_RATE_PROP, BELOW_NODE_RATE_PROP, BC_COLLECTION_PROP, BC_RATE_PROP);
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        String collectionsStr = (String)properties.get(COLLECTIONS_PROP);
        if (collectionsStr != null) {
            this.collections.addAll(StrUtils.splitSmart((String)collectionsStr, (char)','));
        }
        if ((collectionsStr = (String)properties.get(BC_COLLECTION_PROP)) != null && !collectionsStr.equals("#ANY")) {
            this.collections.add(collectionsStr);
        }
        this.shard = (String)properties.getOrDefault("shard", "#ANY");
        if (!this.shard.equals("#ANY") && (this.collections.isEmpty() || this.collections.size() > 1)) {
            throw new TriggerValidationException(this.name, "shard", "When 'shard' is other than #ANY then exactly one collection name must be set");
        }
        this.node = (String)properties.getOrDefault("node", "#ANY");
        this.metric = (String)properties.getOrDefault(METRIC_PROP, DEFAULT_METRIC);
        String maxOpsStr = String.valueOf(properties.getOrDefault(MAX_OPS_PROP, 3));
        try {
            this.maxOps = Integer.parseInt(maxOpsStr);
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.name, MAX_OPS_PROP, "invalid value '" + maxOpsStr + "': " + e.toString());
        }
        Object o = properties.get(MIN_REPLICAS_PROP);
        if (o != null) {
            try {
                this.minReplicas = Integer.parseInt(o.toString());
                if (this.minReplicas < 1) {
                    throw new Exception("must be at least 1, or not set to use 'replicationFactor'");
                }
            }
            catch (Exception e) {
                throw new TriggerValidationException(this.name, MIN_REPLICAS_PROP, "invalid value '" + o + "': " + e.toString());
            }
        }
        Object above = properties.get(ABOVE_RATE_PROP);
        Object below = properties.get(BELOW_RATE_PROP);
        if (properties.containsKey(BC_RATE_PROP)) {
            above = properties.get(BC_RATE_PROP);
        }
        if (above == null && below == null) {
            throw new TriggerValidationException(this.name, ABOVE_RATE_PROP, "at least one of 'aboveRate' or 'belowRate' must be set");
        }
        if (above != null) {
            try {
                this.aboveRate = Double.parseDouble(String.valueOf(above));
            }
            catch (Exception e) {
                throw new TriggerValidationException(this.name, ABOVE_RATE_PROP, "Invalid configuration value: '" + above + "': " + e.toString());
            }
        } else {
            this.aboveRate = Double.MAX_VALUE;
        }
        if (below != null) {
            try {
                this.belowRate = Double.parseDouble(String.valueOf(below));
            }
            catch (Exception e) {
                throw new TriggerValidationException(this.name, BELOW_RATE_PROP, "Invalid configuration value: '" + below + "': " + e.toString());
            }
        } else {
            this.belowRate = -1.0;
        }
        above = properties.get(ABOVE_NODE_RATE_PROP);
        below = properties.get(BELOW_NODE_RATE_PROP);
        if (above != null) {
            try {
                this.aboveNodeRate = Double.parseDouble(String.valueOf(above));
            }
            catch (Exception e) {
                throw new TriggerValidationException(this.name, ABOVE_NODE_RATE_PROP, "Invalid configuration value: '" + above + "': " + e.toString());
            }
        } else {
            this.aboveNodeRate = Double.MAX_VALUE;
        }
        if (below != null) {
            try {
                this.belowNodeRate = Double.parseDouble(String.valueOf(below));
            }
            catch (Exception e) {
                throw new TriggerValidationException(this.name, BELOW_NODE_RATE_PROP, "Invalid configuration value: '" + below + "': " + e.toString());
            }
        } else {
            this.belowNodeRate = -1.0;
        }
        String aboveOpStr = String.valueOf(properties.getOrDefault(ABOVE_OP_PROP, CollectionParams.CollectionAction.ADDREPLICA.toLower()));
        String belowOpStr = String.valueOf(properties.getOrDefault(BELOW_OP_PROP, CollectionParams.CollectionAction.DELETEREPLICA.toLower()));
        this.aboveOp = CollectionParams.CollectionAction.get((String)aboveOpStr);
        if (this.aboveOp == null) {
            throw new TriggerValidationException(this.getName(), ABOVE_OP_PROP, "unrecognized value: '" + aboveOpStr + "'");
        }
        this.belowOp = CollectionParams.CollectionAction.get((String)belowOpStr);
        if (this.belowOp == null) {
            throw new TriggerValidationException(this.getName(), BELOW_OP_PROP, "unrecognized value: '" + belowOpStr + "'");
        }
        Object aboveNodeObj = properties.getOrDefault(ABOVE_NODE_OP_PROP, CollectionParams.CollectionAction.MOVEREPLICA.toLower());
        Object belowNodeObj = properties.get(BELOW_NODE_OP_PROP);
        try {
            this.aboveNodeOp = CollectionParams.CollectionAction.get((String)String.valueOf(aboveNodeObj));
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.getName(), ABOVE_NODE_OP_PROP, "unrecognized value: '" + aboveNodeObj + "'");
        }
        if (belowNodeObj != null) {
            try {
                this.belowNodeOp = CollectionParams.CollectionAction.get((String)String.valueOf(belowNodeObj));
            }
            catch (Exception e) {
                throw new TriggerValidationException(this.getName(), BELOW_NODE_OP_PROP, "unrecognized value: '" + belowNodeObj + "'");
            }
        }
    }

    @VisibleForTesting
    Map<String, Object> getConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("name", this.name);
        config.put(COLLECTIONS_PROP, this.collections);
        config.put("shard", this.shard);
        config.put("node", this.node);
        config.put(METRIC_PROP, this.metric);
        config.put(MAX_OPS_PROP, this.maxOps);
        config.put(MIN_REPLICAS_PROP, this.minReplicas);
        config.put(ABOVE_RATE_PROP, this.aboveRate);
        config.put(BELOW_RATE_PROP, this.belowRate);
        config.put(ABOVE_NODE_RATE_PROP, this.aboveNodeRate);
        config.put(BELOW_NODE_RATE_PROP, this.belowNodeRate);
        config.put(ABOVE_OP_PROP, this.aboveOp);
        config.put(ABOVE_NODE_OP_PROP, this.aboveNodeOp);
        config.put(BELOW_OP_PROP, this.belowOp);
        config.put(BELOW_NODE_OP_PROP, this.belowNodeOp);
        return config;
    }

    @Override
    protected Map<String, Object> getState() {
        return this.state;
    }

    @Override
    protected void setState(Map<String, Object> state) {
        Map replicaTimes;
        Map shardTimes;
        Map nodeTimes;
        this.lastCollectionEvent.clear();
        this.lastNodeEvent.clear();
        this.lastShardEvent.clear();
        this.lastReplicaEvent.clear();
        Map collTimes = (Map)state.get("lastCollectionEvent");
        if (collTimes != null) {
            this.lastCollectionEvent.putAll(collTimes);
        }
        if ((nodeTimes = (Map)state.get("lastNodeEvent")) != null) {
            this.lastNodeEvent.putAll(nodeTimes);
        }
        if ((shardTimes = (Map)state.get("lastShardEvent")) != null) {
            this.lastShardEvent.putAll(shardTimes);
        }
        if ((replicaTimes = (Map)state.get("lastReplicaEvent")) != null) {
            this.lastReplicaEvent.putAll(replicaTimes);
        }
    }

    @Override
    public void restoreState(AutoScaling.Trigger old) {
        SearchRateTrigger that;
        assert (old.isClosed());
        if (old instanceof SearchRateTrigger) {
            that = (SearchRateTrigger)old;
            assert (this.name.equals(that.name));
        } else {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Unable to restore state from an unknown type of trigger");
        }
        this.lastCollectionEvent.clear();
        this.lastNodeEvent.clear();
        this.lastShardEvent.clear();
        this.lastReplicaEvent.clear();
        this.lastCollectionEvent.putAll(that.lastCollectionEvent);
        this.lastNodeEvent.putAll(that.lastNodeEvent);
        this.lastShardEvent.putAll(that.lastShardEvent);
        this.lastReplicaEvent.putAll(that.lastReplicaEvent);
    }

    @Override
    public void run() {
        AutoScaling.TriggerEventProcessor processor = (AutoScaling.TriggerEventProcessor)this.processorRef.get();
        if (processor == null) {
            return;
        }
        HashMap<String, Map> collectionRates = new HashMap<String, Map>();
        HashMap nodeRates = new HashMap();
        HashMap<String, Map<String, AtomicInteger>> searchableReplicationFactors = new HashMap<String, Map<String, AtomicInteger>>();
        ClusterState clusterState = null;
        try {
            clusterState = this.cloudManager.getClusterStateProvider().getClusterState();
        }
        catch (IOException e2) {
            log.warn("Error getting ClusterState", (Throwable)e2);
            return;
        }
        for (String node2 : this.cloudManager.getClusterStateProvider().getLiveNodes()) {
            HashMap metricTags = new HashMap();
            Map infos = this.cloudManager.getNodeStateProvider().getReplicaInfo(node2, Collections.emptyList());
            infos.forEach((coll, shards) -> {
                Map replPerShard = searchableReplicationFactors.computeIfAbsent((String)coll, c -> new HashMap());
                shards.forEach((sh, replicas) -> {
                    AtomicInteger repl = replPerShard.computeIfAbsent(sh, s -> new AtomicInteger());
                    replicas.forEach(replica -> {
                        if (replica.getState() != Replica.State.ACTIVE) {
                            return;
                        }
                        repl.incrementAndGet();
                        String replicaName = Utils.parseMetricsReplicaName((String)coll, (String)replica.getCore());
                        if (replicaName == null) {
                            replicaName = replica.getName();
                        }
                        String registry = SolrCoreMetricManager.createRegistryName(true, coll, sh, replicaName, null);
                        String tag = "metrics:" + registry + ":" + this.metric;
                        metricTags.put(tag, replica);
                    });
                });
            });
            if (metricTags.isEmpty()) continue;
            Map rates = this.cloudManager.getNodeStateProvider().getNodeValues(node2, metricTags.keySet());
            if (log.isDebugEnabled()) {
                log.debug("### rates for node " + node2);
                rates.forEach((tag, rate) -> log.debug("###  " + tag + "\t" + rate));
            }
            rates.forEach((tag, rate) -> {
                ReplicaInfo info = (ReplicaInfo)metricTags.get(tag);
                if (info == null) {
                    log.warn("Missing replica info for response tag " + tag);
                } else {
                    Map perCollection = collectionRates.computeIfAbsent(info.getCollection(), s -> new HashMap());
                    List perShard = perCollection.computeIfAbsent(info.getShard(), s -> new ArrayList());
                    info = (ReplicaInfo)info.clone();
                    info.getVariables().put(BC_RATE_PROP, ((Number)rate).doubleValue());
                    perShard.add(info);
                    AtomicDouble perNode = nodeRates.computeIfAbsent(node2, s -> new AtomicDouble());
                    perNode.addAndGet(((Number)rate).doubleValue());
                }
            });
        }
        if (log.isDebugEnabled()) {
            collectionRates.forEach((coll, collRates) -> {
                log.debug("## Collection: {}", coll);
                collRates.forEach((s, replicas) -> {
                    log.debug("##  - {}", s);
                    replicas.forEach(ri -> log.debug("##     {}  {}", (Object)ri.getCore(), ri.getVariable(BC_RATE_PROP)));
                });
            });
        }
        long now = this.cloudManager.getTimeSource().getTimeNs();
        HashMap<String, Double> hotNodes = new HashMap<String, Double>();
        HashMap<String, Double> coldNodes = new HashMap<String, Double>();
        nodeRates.entrySet().stream().filter(entry -> this.node.equals("#ANY") || this.node.equals(entry.getKey())).forEach(entry -> {
            if (((AtomicDouble)entry.getValue()).get() > this.aboveNodeRate) {
                if (this.waitForElapsed((String)entry.getKey(), now, this.lastNodeEvent)) {
                    hotNodes.put((String)entry.getKey(), ((AtomicDouble)entry.getValue()).get());
                }
            } else if (((AtomicDouble)entry.getValue()).get() < this.belowNodeRate) {
                if (this.waitForElapsed((String)entry.getKey(), now, this.lastNodeEvent)) {
                    coldNodes.put((String)entry.getKey(), ((AtomicDouble)entry.getValue()).get());
                }
            } else {
                this.lastNodeEvent.remove(entry.getKey());
            }
        });
        HashMap<String, Map<String, Double>> hotShards = new HashMap<String, Map<String, Double>>();
        HashMap<String, Map<String, Double>> coldShards = new HashMap<String, Map<String, Double>>();
        ArrayList<ReplicaInfo> hotReplicas = new ArrayList<ReplicaInfo>();
        ArrayList<ReplicaInfo> coldReplicas = new ArrayList<ReplicaInfo>();
        collectionRates.forEach((coll, shardRates) -> shardRates.forEach((sh, replicaRates) -> {
            double totalShardRate = replicaRates.stream().map(r -> {
                String elapsedKey = r.getCollection() + "." + r.getCore();
                if ((Double)r.getVariable(BC_RATE_PROP) > this.aboveRate) {
                    if (this.waitForElapsed(elapsedKey, now, this.lastReplicaEvent)) {
                        hotReplicas.add((ReplicaInfo)r);
                    }
                } else if ((Double)r.getVariable(BC_RATE_PROP) < this.belowRate) {
                    if (this.waitForElapsed(elapsedKey, now, this.lastReplicaEvent)) {
                        coldReplicas.add((ReplicaInfo)r);
                    }
                } else {
                    this.lastReplicaEvent.remove(elapsedKey);
                }
                return r;
            }).mapToDouble(r -> (Double)r.getVariable(BC_RATE_PROP)).sum();
            double shardRate = totalShardRate / ((AtomicInteger)((Map)searchableReplicationFactors.get(coll)).get(sh)).doubleValue();
            String elapsedKey = coll + "." + sh;
            log.debug("-- {}: totalShardRate={}, shardRate={}", new Object[]{elapsedKey, totalShardRate, shardRate});
            if ((this.collections.isEmpty() || this.collections.contains(coll)) && (this.shard.equals("#ANY") || this.shard.equals(sh))) {
                if (shardRate > this.aboveRate) {
                    if (this.waitForElapsed(elapsedKey, now, this.lastShardEvent)) {
                        hotShards.computeIfAbsent((String)coll, s -> new HashMap()).put(sh, shardRate);
                    }
                } else if (shardRate < this.belowRate) {
                    if (this.waitForElapsed(elapsedKey, now, this.lastShardEvent)) {
                        coldShards.computeIfAbsent((String)coll, s -> new HashMap()).put(sh, shardRate);
                        log.debug("-- coldShard waitFor elapsed {}", (Object)elapsedKey);
                    } else if (log.isDebugEnabled()) {
                        Long lastTime = this.lastShardEvent.computeIfAbsent(elapsedKey, s -> now);
                        long elapsed = TimeUnit.SECONDS.convert(now - lastTime, TimeUnit.NANOSECONDS);
                        log.debug("-- waitFor didn't elapse for {}, waitFor={}, elapsed={}", new Object[]{elapsedKey, this.getWaitForSecond(), elapsed});
                    }
                } else {
                    this.lastShardEvent.remove(elapsedKey);
                }
            }
        }));
        HashMap<String, Double> hotCollections = new HashMap<String, Double>();
        HashMap<String, Double> coldCollections = new HashMap<String, Double>();
        collectionRates.forEach((coll, shardRates) -> {
            double total = shardRates.entrySet().stream().mapToDouble(e -> ((List)e.getValue()).stream().mapToDouble(r -> (Double)r.getVariable(BC_RATE_PROP)).sum()).sum();
            if (this.collections.isEmpty() || this.collections.contains(coll)) {
                if (total > this.aboveRate) {
                    if (this.waitForElapsed((String)coll, now, this.lastCollectionEvent)) {
                        hotCollections.put((String)coll, total);
                    }
                } else if (total < this.belowRate) {
                    if (this.waitForElapsed((String)coll, now, this.lastCollectionEvent)) {
                        coldCollections.put((String)coll, total);
                    }
                } else {
                    this.lastCollectionEvent.remove(coll);
                }
            }
        });
        if (hotCollections.isEmpty() && hotShards.isEmpty() && hotReplicas.isEmpty() && hotNodes.isEmpty() && coldCollections.isEmpty() && coldShards.isEmpty() && coldReplicas.isEmpty() && coldNodes.isEmpty()) {
            return;
        }
        AtomicLong eventTime = new AtomicLong(now);
        hotCollections.forEach((c, r) -> {
            long time = this.lastCollectionEvent.get(c);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        coldCollections.forEach((c, r) -> {
            long time = this.lastCollectionEvent.get(c);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        hotShards.forEach((c, shards) -> shards.forEach((s, r) -> {
            long time = this.lastShardEvent.get(c + "." + s);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        }));
        coldShards.forEach((c, shards) -> shards.forEach((s, r) -> {
            long time = this.lastShardEvent.get(c + "." + s);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        }));
        hotReplicas.forEach(r -> {
            long time = this.lastReplicaEvent.get(r.getCollection() + "." + r.getCore());
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        coldReplicas.forEach(r -> {
            long time = this.lastReplicaEvent.get(r.getCollection() + "." + r.getCore());
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        hotNodes.forEach((n, r) -> {
            long time = this.lastNodeEvent.get(n);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        coldNodes.forEach((n, r) -> {
            long time = this.lastNodeEvent.get(n);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        ArrayList<TriggerEvent.Op> ops = new ArrayList<TriggerEvent.Op>();
        HashSet<String> violations = new HashSet<String>();
        this.calculateHotOps(ops, violations, searchableReplicationFactors, hotNodes, hotCollections, hotShards, hotReplicas);
        this.calculateColdOps(ops, violations, clusterState, searchableReplicationFactors, coldNodes, coldCollections, coldShards, coldReplicas);
        if (ops.isEmpty()) {
            return;
        }
        if (processor.process(new SearchRateEvent(this.getName(), eventTime.get(), ops, hotNodes, hotCollections, hotShards, hotReplicas, coldNodes, coldCollections, coldShards, coldReplicas, violations))) {
            hotNodes.keySet().forEach(node -> this.lastNodeEvent.put((String)node, now));
            coldNodes.keySet().forEach(node -> this.lastNodeEvent.put((String)node, now));
            hotCollections.keySet().forEach(coll -> this.lastCollectionEvent.put((String)coll, now));
            coldCollections.keySet().forEach(coll -> this.lastCollectionEvent.put((String)coll, now));
            hotShards.entrySet().forEach(e -> ((Map)e.getValue()).forEach((sh, rate) -> this.lastShardEvent.put((String)e.getKey() + "." + sh, now)));
            coldShards.entrySet().forEach(e -> ((Map)e.getValue()).forEach((sh, rate) -> this.lastShardEvent.put((String)e.getKey() + "." + sh, now)));
            hotReplicas.forEach(r -> this.lastReplicaEvent.put(r.getCollection() + "." + r.getCore(), now));
            coldReplicas.forEach(r -> this.lastReplicaEvent.put(r.getCollection() + "." + r.getCore(), now));
        }
    }

    private void calculateHotOps(List<TriggerEvent.Op> ops, Set<String> violations, Map<String, Map<String, AtomicInteger>> searchableReplicationFactors, Map<String, Double> hotNodes, Map<String, Double> hotCollections, Map<String, Map<String, Double>> hotShards, List<ReplicaInfo> hotReplicas) {
        if (!hotNodes.isEmpty() && hotShards.isEmpty() && hotCollections.isEmpty() && this.aboveNodeOp != null) {
            hotNodes.forEach((n, r) -> {
                ops.add(new TriggerEvent.Op(this.aboveNodeOp, Suggester.Hint.SRC_NODE, n));
                violations.add(HOT_NODES);
            });
        }
        HashMap hints = new HashMap();
        hotShards.forEach((coll, shards) -> shards.forEach((s, r) -> {
            List perShard = hints.computeIfAbsent(coll, c -> new HashMap()).computeIfAbsent(s, sh -> new ArrayList());
            this.addReplicaHints((String)coll, (String)s, (double)r, ((AtomicInteger)((Map)searchableReplicationFactors.get(coll)).get(s)).get(), perShard);
            violations.add(HOT_SHARDS);
        }));
        hints.values().forEach(m -> m.values().forEach(lst -> lst.forEach(p -> ops.add(new TriggerEvent.Op(this.aboveOp, Suggester.Hint.COLL_SHARD, p)))));
    }

    private void addReplicaHints(String collection, String shard, double r, int replicationFactor, List<Pair<String, String>> hints) {
        int numReplicas = (int)Math.round((r - this.aboveRate) / (double)replicationFactor);
        if (numReplicas < 1) {
            numReplicas = 1;
        }
        if (numReplicas > this.maxOps) {
            numReplicas = this.maxOps;
        }
        for (int i = 0; i < numReplicas; ++i) {
            hints.add((Pair<String, String>)new Pair((Object)collection, (Object)shard));
        }
    }

    private void calculateColdOps(List<TriggerEvent.Op> ops, Set<String> violations, ClusterState clusterState, Map<String, Map<String, AtomicInteger>> searchableReplicationFactors, Map<String, Double> coldNodes, Map<String, Double> coldCollections, Map<String, Map<String, Double>> coldShards, List<ReplicaInfo> coldReplicas) {
        HashMap byCollectionByShard = new HashMap();
        coldReplicas.forEach(ri -> byCollectionByShard.computeIfAbsent(ri.getCollection(), c -> new HashMap()).computeIfAbsent(ri.getShard(), s -> new ArrayList()).add(ri));
        coldShards.forEach((coll, perShard) -> perShard.forEach((shard, rate) -> {
            List<ReplicaInfo> replicas = byCollectionByShard.getOrDefault(coll, Collections.emptyMap()).getOrDefault(shard, Collections.emptyList());
            if (replicas.isEmpty()) {
                return;
            }
            int rf = ((AtomicInteger)((Map)searchableReplicationFactors.get(coll)).get(shard)).get();
            int minRF = 1;
            Integer RF = clusterState.getCollection(coll).getReplicationFactor();
            if (RF != null) {
                minRF = RF;
            }
            if (this.minReplicas != null) {
                minRF = this.minReplicas;
            }
            if (minRF < 1) {
                minRF = 1;
            }
            if (rf > minRF) {
                AtomicInteger limit = new AtomicInteger(Math.min(this.maxOps, rf - minRF));
                replicas.forEach(ri -> {
                    if (limit.get() == 0) {
                        return;
                    }
                    if (ri.getBool("leader", false)) {
                        return;
                    }
                    TriggerEvent.Op op = new TriggerEvent.Op(this.belowOp, Suggester.Hint.COLL_SHARD, new Pair((Object)ri.getCollection(), (Object)ri.getShard()));
                    op.addHint(Suggester.Hint.REPLICA, ri.getName());
                    ops.add(op);
                    violations.add(COLD_SHARDS);
                    limit.decrementAndGet();
                });
            }
        }));
        if (this.belowNodeOp != null) {
            coldNodes.forEach((node, rate) -> {
                ops.add(new TriggerEvent.Op(this.belowNodeOp, Suggester.Hint.SRC_NODE, node));
                violations.add(COLD_NODES);
            });
        }
    }

    private boolean waitForElapsed(String name, long now, Map<String, Long> lastEventMap) {
        Long lastTime = lastEventMap.computeIfAbsent(name, s -> now);
        long elapsed = TimeUnit.SECONDS.convert(now - lastTime, TimeUnit.NANOSECONDS);
        log.trace("name={}, lastTime={}, elapsed={}, waitFor={}", new Object[]{name, lastTime, elapsed, this.getWaitForSecond()});
        return TimeUnit.SECONDS.convert(now - lastTime, TimeUnit.NANOSECONDS) >= (long)this.getWaitForSecond();
    }

    public static class SearchRateEvent
    extends TriggerEvent {
        public SearchRateEvent(String source, long eventTime, List<TriggerEvent.Op> ops, Map<String, Double> hotNodes, Map<String, Double> hotCollections, Map<String, Map<String, Double>> hotShards, List<ReplicaInfo> hotReplicas, Map<String, Double> coldNodes, Map<String, Double> coldCollections, Map<String, Map<String, Double>> coldShards, List<ReplicaInfo> coldReplicas, Set<String> violations) {
            super(TriggerEventType.SEARCHRATE, source, eventTime, null);
            this.properties.put("requestedOps", ops);
            this.properties.put(SearchRateTrigger.HOT_NODES, hotNodes);
            this.properties.put(SearchRateTrigger.HOT_COLLECTIONS, hotCollections);
            this.properties.put(SearchRateTrigger.HOT_SHARDS, hotShards);
            this.properties.put(SearchRateTrigger.HOT_REPLICAS, hotReplicas);
            this.properties.put(SearchRateTrigger.COLD_NODES, coldNodes);
            this.properties.put(SearchRateTrigger.COLD_COLLECTIONS, coldCollections);
            this.properties.put(SearchRateTrigger.COLD_SHARDS, coldShards);
            this.properties.put(SearchRateTrigger.COLD_REPLICAS, coldReplicas);
            this.properties.put(SearchRateTrigger.VIOLATION_PROP, violations);
        }
    }
}

