/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.ScriptTransformer;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.config.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityProcessorWrapper
extends EntityProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private EntityProcessor delegate;
    private Entity entity;
    private DataSource datasource;
    private List<EntityProcessorWrapper> children = new ArrayList<EntityProcessorWrapper>();
    private DocBuilder docBuilder;
    private boolean initialized;
    private String onError;
    private Context context;
    private VariableResolver resolver;
    private String entityName;
    protected List<Transformer> transformers;
    protected List<Map<String, Object>> rowcache;

    public EntityProcessorWrapper(EntityProcessor delegate, Entity entity, DocBuilder docBuilder) {
        this.delegate = delegate;
        this.entity = entity;
        this.docBuilder = docBuilder;
    }

    @Override
    public void init(Context context) {
        this.rowcache = null;
        this.context = context;
        this.resolver = context.getVariableResolver();
        if (this.entityName == null) {
            this.onError = this.resolver.replaceTokens(context.getEntityAttribute("onError"));
            if (this.onError == null) {
                this.onError = "abort";
            }
            this.entityName = context.getEntityAttribute("name");
        }
        this.delegate.init(context);
    }

    void loadTransformers() {
        String transClasses = this.context.getEntityAttribute("transformer");
        if (transClasses == null) {
            this.transformers = Collections.EMPTY_LIST;
            return;
        }
        String[] transArr = transClasses.split(",");
        this.transformers = new ArrayList<Transformer>(){

            @Override
            public boolean add(Transformer transformer) {
                if (EntityProcessorWrapper.this.docBuilder != null && ((EntityProcessorWrapper)EntityProcessorWrapper.this).docBuilder.verboseDebug) {
                    transformer = EntityProcessorWrapper.this.docBuilder.getDebugLogger().wrapTransformer(transformer);
                }
                return super.add(transformer);
            }
        };
        for (String aTransArr : transArr) {
            String trans = aTransArr.trim();
            if (trans.startsWith("script:")) {
                this.checkIfTrusted(trans);
                String functionName = trans.substring("script:".length());
                ScriptTransformer scriptTransformer = new ScriptTransformer();
                scriptTransformer.setFunctionName(functionName);
                this.transformers.add(scriptTransformer);
                continue;
            }
            try {
                Class clazz = DocBuilder.loadClass(trans, this.context.getSolrCore());
                if (Transformer.class.isAssignableFrom(clazz)) {
                    this.transformers.add((Transformer)clazz.newInstance());
                    continue;
                }
                Method meth = clazz.getMethod("transformRow", Map.class);
                this.transformers.add(new ReflectionTransformer(meth, clazz, trans));
            }
            catch (NoSuchMethodException nsme) {
                String msg = "Transformer :" + trans + "does not implement Transformer interface or does not have a transformRow(Map<String.Object> m)method";
                log.error(msg);
                DataImportHandlerException.wrapAndThrow(500, nsme, msg);
            }
            catch (Exception e) {
                log.error("Unable to load Transformer: " + aTransArr, (Throwable)e);
                DataImportHandlerException.wrapAndThrow(500, e, "Unable to load Transformer: " + trans);
            }
        }
    }

    private void checkIfTrusted(String trans) {
        if (this.docBuilder != null) {
            boolean trusted;
            SolrCore core = this.docBuilder.dataImporter.getCore();
            boolean bl = trusted = core != null ? core.getCoreDescriptor().isConfigSetTrusted() : true;
            if (!trusted) {
                SolrException ex = new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "The configset for this collection was uploaded without any authentication in place, and this transformer is not available for collections with untrusted configsets. To use this transformer, re-upload the configset after enabling authentication and authorization.");
                String msg = "Transformer: " + trans + ". " + ex.getMessage();
                log.error(msg);
                DataImportHandlerException.wrapAndThrow(500, (Exception)ex, msg);
            }
        }
    }

    protected Map<String, Object> getFromRowCache() {
        Map<String, Object> r = this.rowcache.remove(0);
        if (this.rowcache.isEmpty()) {
            this.rowcache = null;
        }
        return r;
    }

    protected Map<String, Object> applyTransformer(Map<String, Object> row) {
        if (row == null) {
            return null;
        }
        if (this.transformers == null) {
            this.loadTransformers();
        }
        if (this.transformers == Collections.EMPTY_LIST) {
            return row;
        }
        Map transformedRow = row;
        List rows = null;
        boolean stopTransform = this.checkStopTransform(row);
        VariableResolver resolver = this.context.getVariableResolver();
        for (Transformer t : this.transformers) {
            if (stopTransform) break;
            try {
                if (rows != null) {
                    ArrayList<Map> tmpRows = new ArrayList<Map>();
                    for (Map map : rows) {
                        resolver.addNamespace(this.entityName, map);
                        Object o = t.transformRow(map, this.context);
                        if (o == null) continue;
                        if (o instanceof Map) {
                            Map oMap = (Map)o;
                            stopTransform = this.checkStopTransform(oMap);
                            tmpRows.add((Map)o);
                            continue;
                        }
                        if (o instanceof List) {
                            tmpRows.addAll((List)o);
                            continue;
                        }
                        log.error("Transformer must return Map<String, Object> or a List<Map<String, Object>>");
                    }
                    rows = tmpRows;
                    continue;
                }
                resolver.addNamespace(this.entityName, transformedRow);
                Object o = t.transformRow(transformedRow, this.context);
                if (o == null) {
                    return null;
                }
                if (o instanceof Map) {
                    Map oMap = (Map)o;
                    stopTransform = this.checkStopTransform(oMap);
                    transformedRow = (Map)o;
                    continue;
                }
                if (o instanceof List) {
                    rows = (List)o;
                    continue;
                }
                log.error("Transformer must return Map<String, Object> or a List<Map<String, Object>>");
            }
            catch (Exception e) {
                log.warn("transformer threw error", (Throwable)e);
                if ("abort".equals(this.onError)) {
                    DataImportHandlerException.wrapAndThrow(500, e);
                    continue;
                }
                if (!"skip".equals(this.onError)) continue;
                DataImportHandlerException.wrapAndThrow(300, e);
            }
        }
        if (rows == null) {
            return transformedRow;
        }
        this.rowcache = rows;
        return this.getFromRowCache();
    }

    private boolean checkStopTransform(Map oMap) {
        return oMap.get("$stopTransform") != null && Boolean.parseBoolean(oMap.get("$stopTransform").toString());
    }

    @Override
    public Map<String, Object> nextRow() {
        Map<String, Object> arow;
        if (this.rowcache != null) {
            return this.getFromRowCache();
        }
        do {
            arow = null;
            try {
                arow = this.delegate.nextRow();
            }
            catch (Exception e) {
                if ("abort".equals(this.onError)) {
                    DataImportHandlerException.wrapAndThrow(500, e);
                }
                SolrException.log((Logger)log, (String)("Exception in entity : " + this.entityName), (Throwable)e);
                return null;
            }
            if (arow != null) continue;
            return null;
        } while ((arow = this.applyTransformer(arow)) == null);
        this.delegate.postTransform(arow);
        return arow;
    }

    @Override
    public Map<String, Object> nextModifiedRowKey() {
        Map<String, Object> row = this.delegate.nextModifiedRowKey();
        row = this.applyTransformer(row);
        this.rowcache = null;
        return row;
    }

    @Override
    public Map<String, Object> nextDeletedRowKey() {
        Map<String, Object> row = this.delegate.nextDeletedRowKey();
        row = this.applyTransformer(row);
        this.rowcache = null;
        return row;
    }

    @Override
    public Map<String, Object> nextModifiedParentRowKey() {
        return this.delegate.nextModifiedParentRowKey();
    }

    @Override
    public void destroy() {
        this.delegate.destroy();
    }

    public VariableResolver getVariableResolver() {
        return this.context.getVariableResolver();
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public List<EntityProcessorWrapper> getChildren() {
        return this.children;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    static class ReflectionTransformer
    extends Transformer {
        final Method meth;
        final Class clazz;
        final String trans;
        final Object o;

        public ReflectionTransformer(Method meth, Class clazz, String trans) throws Exception {
            this.meth = meth;
            this.clazz = clazz;
            this.trans = trans;
            this.o = clazz.newInstance();
        }

        @Override
        public Object transformRow(Map<String, Object> aRow, Context context) {
            try {
                return this.meth.invoke(this.o, aRow);
            }
            catch (Exception e) {
                log.warn("method invocation failed on transformer : " + this.trans, (Throwable)e);
                throw new DataImportHandlerException(400, (Throwable)e);
            }
        }
    }
}

