/*!
 * Copyright (c) 2012 - 2019, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"]);
})(this, function(Bokeh) {
  var define;
  return (function(modules, entry, aliases, externals) {
    if (Bokeh != null) {
      return Bokeh.register_plugin(modules, entry, aliases, externals);
    } else {
      throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.");
    }
  })
({
472: function _(e,i,r){var s=e(473);r.Widgets=s,e(108).register_models(s)},
473: function _(r,t,a){var e=r(474);a.AbstractButton=e.AbstractButton;var o=r(477);a.AbstractIcon=o.AbstractIcon;var u=r(478);a.AutocompleteInput=u.AutocompleteInput;var n=r(482);a.Button=n.Button;var v=r(483);a.CheckboxButtonGroup=v.CheckboxButtonGroup;var p=r(485);a.CheckboxGroup=p.CheckboxGroup;var i=r(487);a.ColorPicker=i.ColorPicker;var l=r(488);a.DatePicker=l.DatePicker;var c=r(491);a.DateRangeSlider=c.DateRangeSlider;var d=r(496);a.DateSlider=d.DateSlider;var g=r(497);a.Div=g.Div;var I=r(500);a.Dropdown=I.Dropdown;var S=r(501);a.FileInput=S.FileInput;var k=r(480);a.InputWidget=k.InputWidget;var x=r(498);a.Markup=x.Markup;var D=r(502);a.MultiSelect=D.MultiSelect;var P=r(503);a.Paragraph=P.Paragraph;var b=r(504);a.PasswordInput=b.PasswordInput;var s=r(505);a.PreText=s.PreText;var A=r(506);a.RadioButtonGroup=A.RadioButtonGroup;var B=r(507);a.RadioGroup=B.RadioGroup;var G=r(508);a.RangeSlider=G.RangeSlider;var R=r(509);a.Select=R.Select;var T=r(510);a.Slider=T.Slider;var h=r(511);a.Spinner=h.Spinner;var C=r(479);a.TextInput=C.TextInput;var w=r(512);a.TextAreaInput=w.TextAreaInput;var M=r(513);a.Toggle=M.Toggle;var W=r(534);a.Widget=W.Widget},
474: function _(t,n,e){var i=t(113),o=t(121),r=t(163),s=t(194),l=t(475),c=t(347),u=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.initialize=function(){t.prototype.initialize.call(this),this.icon_views={}},n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return n.render()})},n.prototype.remove=function(){s.remove_views(this.icon_views),t.prototype.remove.call(this)},n.prototype._render_button=function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];return r.button.apply(r,i.__spreadArrays([{type:"button",disabled:this.model.disabled,class:[c.bk_btn,c.bk_btn_type(this.model.button_type)]}],t))},n.prototype.render=function(){var n=this;t.prototype.render.call(this),this.button_el=this._render_button(this.model.label),this.button_el.addEventListener("click",function(){return n.click()});var e=this.model.icon;if(null!=e){s.build_views(this.icon_views,[e],{parent:this});var i=this.icon_views[e.id];i.render(),r.prepend(this.button_el,i.el,r.nbsp())}this.group_el=r.div({class:c.bk_btn_group},this.button_el),this.el.appendChild(this.group_el)},n.prototype.click=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},n}(l.ControlView);e.AbstractButtonView=u,u.__name__="AbstractButtonView";var a=function(t){function n(n){return t.call(this,n)||this}return i.__extends(n,t),n.init_AbstractButton=function(){this.define({label:[o.String,"Button"],icon:[o.Instance],button_type:[o.ButtonType,"default"],callback:[o.Any]})},n}(l.Control);e.AbstractButton=a,a.__name__="AbstractButton",a.init_AbstractButton()},
475: function _(n,t,e){var i=n(113),o=n(534),r=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return i.__extends(t,n),t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this);var e=this.model.properties;this.on_change(e.disabled,function(){return t.render()})},t}(o.WidgetView);e.ControlView=r,r.__name__="ControlView";var s=function(n){function t(t){return n.call(this,t)||this}return i.__extends(t,n),t}(o.Widget);e.Control=s,s.__name__="Control"},
534: function _(t,i,e){var n=t(113),o=t(342),r=t(121),l=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(i,t),i.prototype._width_policy=function(){return"horizontal"==this.model.orientation?t.prototype._width_policy.call(this):"fixed"},i.prototype._height_policy=function(){return"horizontal"==this.model.orientation?"fixed":t.prototype._height_policy.call(this)},i.prototype.box_sizing=function(){var i=t.prototype.box_sizing.call(this);return"horizontal"==this.model.orientation?null==i.width&&(i.width=this.model.default_size):null==i.height&&(i.height=this.model.default_size),i},i}(o.HTMLBoxView);e.WidgetView=l,l.__name__="WidgetView";var h=function(t){function i(i){return t.call(this,i)||this}return n.__extends(i,t),i.init_Widget=function(){this.define({orientation:[r.Orientation,"horizontal"],default_size:[r.Number,300]}),this.override({margin:[5,5,5,5]})},i}(o.HTMLBox);e.Widget=h,h.__name__="Widget",h.init_Widget()},
477: function _(n,t,c){var e=n(113),r=n(166),_=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return e.__extends(t,n),t}(n(161).DOMView);c.AbstractIconView=_,_.__name__="AbstractIconView";var i=function(n){function t(t){return n.call(this,t)||this}return e.__extends(t,n),t}(r.Model);c.AbstractIcon=i,i.__name__="AbstractIcon"},
478: function _(e,t,n){var i=e(113),o=e(479),s=e(163),h=e(121),u=e(111),r=e(240),_=e(348),c=function(e){function t(){var t=e.apply(this,arguments)||this;return t._open=!1,t._last_value="",t._hover_index=0,t}return i.__extends(t,e),t.prototype.render=function(){var t=this;e.prototype.render.call(this),this.input_el.addEventListener("keydown",function(e){return t._keydown(e)}),this.input_el.addEventListener("keyup",function(e){return t._keyup(e)}),this.menu=s.div({class:[_.bk_menu,r.bk_below]}),this.menu.addEventListener("click",function(e){return t._menu_click(e)}),this.menu.addEventListener("mouseover",function(e){return t._menu_hover(e)}),this.el.appendChild(this.menu),s.undisplay(this.menu)},t.prototype.change_input=function(){this._open&&this.menu.children.length>0&&(this.model.value=this.menu.children[this._hover_index].textContent,this.input_el.focus(),this._hide_menu())},t.prototype._update_completions=function(e){s.empty(this.menu);for(var t=0,n=e;t<n.length;t++){var i=n[t],o=s.div({},i);this.menu.appendChild(o)}e.length>0&&this.menu.children[0].classList.add(r.bk_active)},t.prototype._show_menu=function(){var e=this;if(!this._open){this._open=!0,this._hover_index=0,this._last_value=this.model.value,s.display(this.menu);var t=function(n){var i=n.target;i instanceof HTMLElement&&!e.el.contains(i)&&(document.removeEventListener("click",t),e._hide_menu())};document.addEventListener("click",t)}},t.prototype._hide_menu=function(){this._open&&(this._open=!1,s.undisplay(this.menu))},t.prototype._menu_click=function(e){e.target!=e.currentTarget&&e.target instanceof Element&&(this.model.value=e.target.textContent,this.input_el.focus(),this._hide_menu())},t.prototype._menu_hover=function(e){if(e.target!=e.currentTarget&&e.target instanceof Element){var t=0;for(t=0;t<this.menu.children.length&&this.menu.children[t].textContent!=e.target.textContent;t++);this._bump_hover(t)}},t.prototype._bump_hover=function(e){var t=this.menu.children.length;this._open&&t>0&&(this.menu.children[this._hover_index].classList.remove(r.bk_active),this._hover_index=u.clamp(e,0,t-1),this.menu.children[this._hover_index].classList.add(r.bk_active))},t.prototype._keydown=function(e){},t.prototype._keyup=function(e){switch(e.keyCode){case s.Keys.Enter:this.change_input();break;case s.Keys.Esc:this._hide_menu();break;case s.Keys.Up:this._bump_hover(this._hover_index-1);break;case s.Keys.Down:this._bump_hover(this._hover_index+1);break;default:var t=this.input_el.value;if(t.length<this.model.min_characters)return void this._hide_menu();for(var n=[],i=0,o=this.model.completions;i<o.length;i++){var h=o[i];h.startsWith(t)&&n.push(h)}this._update_completions(n),0==n.length?this._hide_menu():this._show_menu()}},t}(o.TextInputView);n.AutocompleteInputView=c,c.__name__="AutocompleteInputView";var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_AutocompleteInput=function(){this.prototype.default_view=c,this.define({completions:[h.Array,[]],min_characters:[h.Int,2]})},t}(o.TextInput);n.AutocompleteInput=a,a.__name__="AutocompleteInput",a.init_AutocompleteInput()},
479: function _(t,e,n){var i=t(113),u=t(480),l=t(163),p=t(121),o=t(481),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,function(){return e.input_el.name=e.model.name||""}),this.connect(this.model.properties.value.change,function(){return e.input_el.value=e.model.value}),this.connect(this.model.properties.value_input.change,function(){return e.input_el.value=e.model.value_input}),this.connect(this.model.properties.disabled.change,function(){return e.input_el.disabled=e.model.disabled}),this.connect(this.model.properties.placeholder.change,function(){return e.input_el.placeholder=e.model.placeholder})},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.input_el=l.input({type:"text",class:o.bk_input,name:this.model.name,value:this.model.value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.input_el.addEventListener("change",function(){return e.change_input()}),this.input_el.addEventListener("input",function(){return e.change_input_oninput()}),this.group_el.appendChild(this.input_el)},e.prototype.change_input=function(){this.model.value=this.input_el.value,t.prototype.change_input.call(this)},e.prototype.change_input_oninput=function(){this.model.value_input=this.input_el.value,t.prototype.change_input.call(this)},e}(u.InputWidgetView);n.TextInputView=a,a.__name__="TextInputView";var r=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_TextInput=function(){this.prototype.default_view=a,this.define({value:[p.String,""],value_input:[p.String,""],placeholder:[p.String,""]})},e}(u.InputWidget);n.TextInput=r,r.__name__="TextInput",r.init_TextInput()},
480: function _(t,e,n){var i=t(113),l=t(475),o=t(163),s=t(121),c=t(481),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.title.change,function(){e.label_el.textContent=e.model.title})},e.prototype.render=function(){t.prototype.render.call(this);var e=this.model.title;this.label_el=o.label({style:{display:0==e.length?"none":""}},e),this.group_el=o.div({class:c.bk_input_group},this.label_el),this.el.appendChild(this.group_el)},e.prototype.change_input=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},e}(l.ControlView);n.InputWidgetView=r,r.__name__="InputWidgetView";var p=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_InputWidget=function(){this.define({title:[s.String,""],callback:[s.Any]})},e}(l.Control);n.InputWidget=p,p.__name__="InputWidget",p.init_InputWidget()},
481: function _(n,o,t){n(164),n(163).styles.append('.bk-root .bk-input {\n  display: inline-block;\n  width: 100%;\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  min-height: 31px;\n  padding: 0 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n}\n.bk-root .bk-input:focus {\n  border-color: #66afe9;\n  outline: 0;\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 8px rgba(102, 175, 233, 0.6);\n}\n.bk-root .bk-input::placeholder,\n.bk-root .bk-input:-ms-input-placeholder,\n.bk-root .bk-input::-moz-placeholder,\n.bk-root .bk-input::-webkit-input-placeholder {\n  color: #999;\n  opacity: 1;\n}\n.bk-root .bk-input[disabled],\n.bk-root .bk-input[readonly] {\n  cursor: not-allowed;\n  background-color: #eee;\n  opacity: 1;\n}\n.bk-root select[multiple].bk-input,\n.bk-root select[size].bk-input,\n.bk-root textarea.bk-input {\n  height: auto;\n}\n.bk-root .bk-input-group {\n  width: 100%;\n  height: 100%;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: start;\n  -webkit-align-items: start;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  white-space: nowrap;\n}\n.bk-root .bk-input-group.bk-inline {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-input-group.bk-inline > *:not(:first-child) {\n  margin-left: 5px;\n}\n.bk-root .bk-input-group input[type="checkbox"] + span,\n.bk-root .bk-input-group input[type="radio"] + span {\n  position: relative;\n  top: -2px;\n  margin-left: 3px;\n}\n'),t.bk_input="bk-input",t.bk_input_group="bk-input-group"},
482: function _(t,n,i){var e=t(113),o=t(474),u=t(376),c=t(121),r=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(n,t),n.prototype.click=function(){this.model.clicks=this.model.clicks+1,this.model.trigger_event(new u.ButtonClick),t.prototype.click.call(this)},n}(o.AbstractButtonView);i.ButtonView=r,r.__name__="ButtonView";var l=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_Button=function(){this.prototype.default_view=r,this.define({clicks:[c.Number,0]}),this.override({label:"Button"})},n}(o.AbstractButton);i.Button=l,l.__name__="Button",l.init_Button()},
483: function _(t,e,o){var n=t(113),i=t(484),u=t(163),c=t(117),r=t(121),a=t(240),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"active",{get:function(){return new c.Set(this.model.active)},enumerable:!0,configurable:!0}),e.prototype.change_active=function(t){var e=this.active;e.toggle(t),this.model.active=e.values,null!=this.model.callback&&this.model.callback.execute(this.model)},e.prototype._update_active=function(){var t=this.active;this._buttons.forEach(function(e,o){u.classes(e).toggle(a.bk_active,t.has(o))})},e}(i.ButtonGroupView);o.CheckboxButtonGroupView=h,h.__name__="CheckboxButtonGroupView";var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_CheckboxButtonGroup=function(){this.prototype.default_view=h,this.define({active:[r.Array,[]]})},e}(i.ButtonGroup);o.CheckboxButtonGroup=l,l.__name__="CheckboxButtonGroup",l.init_CheckboxButtonGroup()},
484: function _(t,n,e){var o=t(113),i=t(475),r=t(163),u=t(121),a=t(347),s=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this);var e=this.model.properties;this.on_change(e.button_type,function(){return n.render()}),this.on_change(e.labels,function(){return n.render()}),this.on_change(e.active,function(){return n._update_active()})},n.prototype.render=function(){var n=this;t.prototype.render.call(this),this._buttons=this.model.labels.map(function(t,e){var o=r.div({class:[a.bk_btn,a.bk_btn_type(n.model.button_type)],disabled:n.model.disabled},t);return o.addEventListener("click",function(){return n.change_active(e)}),o}),this._update_active();var e=r.div({class:a.bk_btn_group},this._buttons);this.el.appendChild(e)},n}(i.ControlView);e.ButtonGroupView=s,s.__name__="ButtonGroupView";var _=function(t){function n(n){return t.call(this,n)||this}return o.__extends(n,t),n.init_ButtonGroup=function(){this.define({labels:[u.Array,[]],button_type:[u.ButtonType,"default"],callback:[u.Any]})},n}(i.Control);e.ButtonGroup=_,_.__name__="ButtonGroup",_.init_ButtonGroup()},
485: function _(e,t,n){var i=e(113),l=e(486),o=e(163),a=e(110),r=e(117),c=e(121),u=e(240),h=e(481),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.render=function(){var t=this;e.prototype.render.call(this);var n=o.div({class:[h.bk_input_group,this.model.inline?u.bk_inline:null]});this.el.appendChild(n);for(var i=this.model,l=i.active,r=i.labels,c=function(e){var i=o.input({type:"checkbox",value:""+e});i.addEventListener("change",function(){return t.change_active(e)}),p.model.disabled&&(i.disabled=!0),a.includes(l,e)&&(i.checked=!0);var c=o.label({},i,o.span({},r[e]));n.appendChild(c)},p=this,s=0;s<r.length;s++)c(s)},t.prototype.change_active=function(e){var t=new r.Set(this.model.active);t.toggle(e),this.model.active=t.values,null!=this.model.callback&&this.model.callback.execute(this.model)},t}(l.InputGroupView);n.CheckboxGroupView=p,p.__name__="CheckboxGroupView";var s=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_CheckboxGroup=function(){this.prototype.default_view=p,this.define({active:[c.Array,[]],labels:[c.Array,[]],inline:[c.Boolean,!1],callback:[c.Any]})},t}(l.InputGroup);n.CheckboxGroup=s,s.__name__="CheckboxGroup",s.init_CheckboxGroup()},
486: function _(n,t,e){var o=n(113),r=n(475),u=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return o.__extends(t,n),t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()})},t}(r.ControlView);e.InputGroupView=u,u.__name__="InputGroupView";var i=function(n){function t(t){return n.call(this,t)||this}return o.__extends(t,n),t}(r.Control);e.InputGroup=i,i.__name__="InputGroup"},
487: function _(e,t,n){var i=e(113),o=e(480),r=e(163),l=e(121),c=e(481),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,function(){return t.input_el.name=t.model.name||""}),this.connect(this.model.properties.color.change,function(){return t.input_el.value=t.model.color}),this.connect(this.model.properties.disabled.change,function(){return t.input_el.disabled=t.model.disabled})},t.prototype.render=function(){var t=this;e.prototype.render.call(this),this.input_el=r.input({type:"color",class:c.bk_input,name:this.model.name,value:this.model.color,disabled:this.model.disabled}),this.input_el.addEventListener("change",function(){return t.change_input()}),this.group_el.appendChild(this.input_el)},t.prototype.change_input=function(){this.model.color=this.input_el.value,e.prototype.change_input.call(this)},t}(o.InputWidgetView);n.ColorPickerView=s,s.__name__="ColorPickerView";var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_ColorPicker=function(){this.prototype.default_view=s,this.define({color:[l.Color,"#000000"]})},t}(o.InputWidget);n.ColorPicker=u,u.__name__="ColorPicker",u.init_ColorPicker()},
488: function _(t,e,i){var n=t(113),o=t(480),s=t(163),l=t(121),a=t(489),r=t(481);t(490),a.prototype.adjustPosition=function(){if(!this._o.container){this.el.style.position="absolute";var t=this._o.trigger,e=this.el.offsetWidth,i=this.el.offsetHeight,n=window.innerWidth||document.documentElement.clientWidth,o=window.innerHeight||document.documentElement.clientHeight,s=window.pageYOffset||document.body.scrollTop||document.documentElement.scrollTop,l=t.getBoundingClientRect(),a=l.left+window.pageXOffset,r=l.bottom+window.pageYOffset;a-=this.el.parentElement.offsetLeft,r-=this.el.parentElement.offsetTop,(this._o.reposition&&a+e>n||this._o.position.indexOf("right")>-1&&a-e+t.offsetWidth>0)&&(a=a-e+t.offsetWidth),(this._o.reposition&&r+i>o+s||this._o.position.indexOf("top")>-1&&r-i-t.offsetHeight>0)&&(r=r-i-t.offsetHeight),this.el.style.left=a+"px",this.el.style.top=r+"px"}};var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()})},e.prototype.render=function(){var e=this;null!=this._picker&&this._picker.destroy(),t.prototype.render.call(this),this.input_el=s.input({type:"text",class:r.bk_input,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el),this._picker=new a({field:this.input_el,defaultDate:this._unlocal_date(new Date(this.model.value)),setDefaultDate:!0,minDate:null!=this.model.min_date?this._unlocal_date(new Date(this.model.min_date)):void 0,maxDate:null!=this.model.max_date?this._unlocal_date(new Date(this.model.max_date)):void 0,onSelect:function(t){return e._on_select(t)}}),this._root_element.appendChild(this._picker.el)},e.prototype._unlocal_date=function(t){var e=6e4*t.getTimezoneOffset();t.setTime(t.getTime()-e);var i=t.toISOString().substr(0,10).split("-");return new Date(Number(i[0]),Number(i[1])-1,Number(i[2]))},e.prototype._on_select=function(t){this.model.value=t.toDateString(),this.change_input()},e}(o.InputWidgetView);i.DatePickerView=d,d.__name__="DatePickerView";var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_DatePicker=function(){this.prototype.default_view=d,this.define({value:[l.Any,(new Date).toDateString()],min_date:[l.Any],max_date:[l.Any]})},e}(o.InputWidget);i.DatePicker=h,h.__name__="DatePicker",h.init_DatePicker()},
489: function _(e,t,n){var a=function(e,t,n,a){e.addEventListener(t,n,!!a)},i=function(e,t,n,a){e.removeEventListener(t,n,!!a)},s=function(e,t){return-1!==(" "+e.className+" ").indexOf(" "+t+" ")},o=function(e,t){s(e,t)||(e.className=""===e.className?t:e.className+" "+t)},r=function(e,t){var n;e.className=(n=(" "+e.className+" ").replace(" "+t+" "," ")).trim?n.trim():n.replace(/^\s+|\s+$/g,"")},l=function(e){return/Array/.test(Object.prototype.toString.call(e))},h=function(e){return/Date/.test(Object.prototype.toString.call(e))&&!isNaN(e.getTime())},d=function(e){var t=e.getDay();return 0===t||6===t},u=function(e){
// solution lifted from date.js (MIT license): https://github.com/datejs/Datejs
return e%4==0&&e%100!=0||e%400==0},c=function(e,t){return[31,u(e)?29:28,31,30,31,30,31,31,30,31,30,31][t]},f=function(e){h(e)&&e.setHours(0,0,0,0)},g=function(e,t){return e.getTime()===t.getTime()},m=function(e,t,n){var a,i;for(a in t)(i=void 0!==e[a])&&"object"==typeof t[a]&&null!==t[a]&&void 0===t[a].nodeName?h(t[a])?n&&(e[a]=new Date(t[a].getTime())):l(t[a])?n&&(e[a]=t[a].slice(0)):e[a]=m({},t[a],n):!n&&i||(e[a]=t[a]);return e},p=function(e,t,n){var a;document.createEvent?((a=document.createEvent("HTMLEvents")).initEvent(t,!0,!1),a=m(a,n),e.dispatchEvent(a)):document.createEventObject&&(a=document.createEventObject(),a=m(a,n),e.fireEvent("on"+t,a))},y=function(e){return e.month<0&&(e.year-=Math.ceil(Math.abs(e.month)/12),e.month+=12),e.month>11&&(e.year+=Math.floor(Math.abs(e.month)/12),e.month-=12),e},D={field:null,bound:void 0,ariaLabel:"Use the arrow keys to pick a date",position:"bottom left",reposition:!0,format:"YYYY-MM-DD",toString:null,parse:null,defaultDate:null,setDefaultDate:!1,firstDay:0,formatStrict:!1,minDate:null,maxDate:null,yearRange:10,showWeekNumber:!1,pickWholeWeek:!1,minYear:0,maxYear:9999,minMonth:void 0,maxMonth:void 0,startRange:null,endRange:null,isRTL:!1,yearSuffix:"",showMonthAfterYear:!1,showDaysInNextAndPreviousMonths:!1,enableSelectionDaysInNextAndPreviousMonths:!1,numberOfMonths:1,mainCalendar:"left",container:void 0,blurFieldOnSelect:!0,i18n:{previousMonth:"Previous Month",nextMonth:"Next Month",months:["January","February","March","April","May","June","July","August","September","October","November","December"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdaysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"]},theme:null,events:[],onSelect:null,onOpen:null,onClose:null,onDraw:null,keyboardInput:!0},b=function(e,t,n){for(t+=e.firstDay;t>=7;)t-=7;return n?e.i18n.weekdaysShort[t]:e.i18n.weekdays[t]},_=function(e){var t=[],n="false";if(e.isEmpty){if(!e.showDaysInNextAndPreviousMonths)return'<td class="is-empty"></td>';t.push("is-outside-current-month"),e.enableSelectionDaysInNextAndPreviousMonths||t.push("is-selection-disabled")}return e.isDisabled&&t.push("is-disabled"),e.isToday&&t.push("is-today"),e.isSelected&&(t.push("is-selected"),n="true"),e.hasEvent&&t.push("has-event"),e.isInRange&&t.push("is-inrange"),e.isStartRange&&t.push("is-startrange"),e.isEndRange&&t.push("is-endrange"),'<td data-day="'+e.day+'" class="'+t.join(" ")+'" aria-selected="'+n+'"><button class="pika-button pika-day" type="button" data-pika-year="'+e.year+'" data-pika-month="'+e.month+'" data-pika-day="'+e.day+'">'+e.day+"</button></td>"},v=function(e,t,n){return'<td class="pika-week">'+function(e){e.setHours(0,0,0,0);var t=e.getDate(),n=e.getDay(),a=function(e){return(e+7-1)%7};e.setDate(t+3-a(n));var i=new Date(e.getFullYear(),0,4),s=(e.getTime()-i.getTime())/864e5;return 1+Math.round((s-3+a(i.getDay()))/7)}(new Date(n,t,e))+"</td>"},w=function(e,t,n,a){return'<tr class="pika-row'+(n?" pick-whole-week":"")+(a?" is-selected":"")+'">'+(t?e.reverse():e).join("")+"</tr>"},k=function(e,t,n,a,i,s){var o,r,h,d,u,c=e._o,f=n===c.minYear,g=n===c.maxYear,m='<div id="'+s+'" class="pika-title" role="heading" aria-live="assertive">',p=!0,y=!0;for(h=[],o=0;o<12;o++)h.push('<option value="'+(n===i?o-t:12+o-t)+'"'+(o===a?' selected="selected"':"")+(f&&o<c.minMonth||g&&o>c.maxMonth?' disabled="disabled"':"")+">"+c.i18n.months[o]+"</option>");for(d='<div class="pika-label">'+c.i18n.months[a]+'<select class="pika-select pika-select-month" tabindex="-1">'+h.join("")+"</select></div>",l(c.yearRange)?(o=c.yearRange[0],r=c.yearRange[1]+1):(o=n-c.yearRange,r=1+n+c.yearRange),h=[];o<r&&o<=c.maxYear;o++)o>=c.minYear&&h.push('<option value="'+o+'"'+(o===n?' selected="selected"':"")+">"+o+"</option>");return u='<div class="pika-label">'+n+c.yearSuffix+'<select class="pika-select pika-select-year" tabindex="-1">'+h.join("")+"</select></div>",c.showMonthAfterYear?m+=u+d:m+=d+u,f&&(0===a||c.minMonth>=a)&&(p=!1),g&&(11===a||c.maxMonth<=a)&&(y=!1),0===t&&(m+='<button class="pika-prev'+(p?"":" is-disabled")+'" type="button">'+c.i18n.previousMonth+"</button>"),t===e._o.numberOfMonths-1&&(m+='<button class="pika-next'+(y?"":" is-disabled")+'" type="button">'+c.i18n.nextMonth+"</button>"),m+"</div>"},M=function(e,t,n){return'<table cellpadding="0" cellspacing="0" class="pika-table" role="grid" aria-labelledby="'+n+'">'+function(e){var t,n=[];for(e.showWeekNumber&&n.push("<th></th>"),t=0;t<7;t++)n.push('<th scope="col"><abbr title="'+b(e,t)+'">'+b(e,t,!0)+"</abbr></th>");return"<thead><tr>"+(e.isRTL?n.reverse():n).join("")+"</tr></thead>"}(e)+("<tbody>"+t.join("")+"</tbody>")+"</table>"},x=function(e){var t=this,n=t.config(e);t._onMouseDown=function(e){if(t._v){var a=(e=e||window.event).target||e.srcElement;if(a)if(s(a,"is-disabled")||(!s(a,"pika-button")||s(a,"is-empty")||s(a.parentNode,"is-disabled")?s(a,"pika-prev")?t.prevMonth():s(a,"pika-next")&&t.nextMonth():(t.setDate(new Date(a.getAttribute("data-pika-year"),a.getAttribute("data-pika-month"),a.getAttribute("data-pika-day"))),n.bound&&setTimeout(function(){t.hide(),n.blurFieldOnSelect&&n.field&&n.field.blur()},100))),s(a,"pika-select"))t._c=!0;else{if(!e.preventDefault)return e.returnValue=!1,!1;e.preventDefault()}}},t._onChange=function(e){var n=(e=e||window.event).target||e.srcElement;n&&(s(n,"pika-select-month")?t.gotoMonth(n.value):s(n,"pika-select-year")&&t.gotoYear(n.value))},t._onKeyChange=function(e){if(e=e||window.event,t.isVisible())switch(e.keyCode){case 13:case 27:n.field&&n.field.blur();break;case 37:t.adjustDate("subtract",1);break;case 38:t.adjustDate("subtract",7);break;case 39:t.adjustDate("add",1);break;case 40:t.adjustDate("add",7);break;case 8:case 46:t.setDate(null)}},t._parseFieldValue=function(){return n.parse?n.parse(n.field.value,n.format):new Date(Date.parse(n.field.value))},t._onInputChange=function(e){var n;e.firedBy!==t&&(n=t._parseFieldValue(),h(n)&&t.setDate(n),t._v||t.show())},t._onInputFocus=function(){t.show()},t._onInputClick=function(){t.show()},t._onInputBlur=function(){var e=document.activeElement;do{if(s(e,"pika-single"))return}while(e=e.parentNode);t._c||(t._b=setTimeout(function(){t.hide()},50)),t._c=!1},t._onClick=function(e){var a=(e=e||window.event).target||e.srcElement,i=a;if(a){do{if(s(i,"pika-single")||i===n.trigger)return}while(i=i.parentNode);t._v&&a!==n.trigger&&i!==n.trigger&&t.hide()}},t.el=document.createElement("div"),t.el.className="pika-single"+(n.isRTL?" is-rtl":"")+(n.theme?" "+n.theme:""),a(t.el,"mousedown",t._onMouseDown,!0),a(t.el,"touchend",t._onMouseDown,!0),a(t.el,"change",t._onChange),n.keyboardInput&&a(document,"keydown",t._onKeyChange),n.field&&(n.container?n.container.appendChild(t.el):n.bound?document.body.appendChild(t.el):n.field.parentNode.insertBefore(t.el,n.field.nextSibling),a(n.field,"change",t._onInputChange),n.defaultDate||(n.defaultDate=t._parseFieldValue(),n.setDefaultDate=!0));var i=n.defaultDate;h(i)?n.setDefaultDate?t.setDate(i,!0):t.gotoDate(i):t.gotoDate(new Date),n.bound?(this.hide(),t.el.className+=" is-bound",a(n.trigger,"click",t._onInputClick),a(n.trigger,"focus",t._onInputFocus),a(n.trigger,"blur",t._onInputBlur)):this.show()};x.prototype={config:function(e){this._o||(this._o=m({},D,!0));var t=m(this._o,e,!0);t.isRTL=!!t.isRTL,t.field=t.field&&t.field.nodeName?t.field:null,t.theme="string"==typeof t.theme&&t.theme?t.theme:null,t.bound=!!(void 0!==t.bound?t.field&&t.bound:t.field),t.trigger=t.trigger&&t.trigger.nodeName?t.trigger:t.field,t.disableWeekends=!!t.disableWeekends,t.disableDayFn="function"==typeof t.disableDayFn?t.disableDayFn:null;var n=parseInt(t.numberOfMonths,10)||1;if(t.numberOfMonths=n>4?4:n,h(t.minDate)||(t.minDate=!1),h(t.maxDate)||(t.maxDate=!1),t.minDate&&t.maxDate&&t.maxDate<t.minDate&&(t.maxDate=t.minDate=!1),t.minDate&&this.setMinDate(t.minDate),t.maxDate&&this.setMaxDate(t.maxDate),l(t.yearRange)){var a=(new Date).getFullYear()-10;t.yearRange[0]=parseInt(t.yearRange[0],10)||a,t.yearRange[1]=parseInt(t.yearRange[1],10)||a}else t.yearRange=Math.abs(parseInt(t.yearRange,10))||D.yearRange,t.yearRange>100&&(t.yearRange=100);return t},toString:function(e){return e=e||this._o.format,h(this._d)?this._o.toString?this._o.toString(this._d,e):this._d.toDateString():""},getDate:function(){return h(this._d)?new Date(this._d.getTime()):null},setDate:function(e,t){if(!e)return this._d=null,this._o.field&&(this._o.field.value="",p(this._o.field,"change",{firedBy:this})),this.draw();if("string"==typeof e&&(e=new Date(Date.parse(e))),h(e)){var n=this._o.minDate,a=this._o.maxDate;h(n)&&e<n?e=n:h(a)&&e>a&&(e=a),this._d=new Date(e.getTime()),f(this._d),this.gotoDate(this._d),this._o.field&&(this._o.field.value=this.toString(),p(this._o.field,"change",{firedBy:this})),t||"function"!=typeof this._o.onSelect||this._o.onSelect.call(this,this.getDate())}},clear:function(){this.setDate(null)},gotoDate:function(e){var t=!0;if(h(e)){if(this.calendars){var n=new Date(this.calendars[0].year,this.calendars[0].month,1),a=new Date(this.calendars[this.calendars.length-1].year,this.calendars[this.calendars.length-1].month,1),i=e.getTime();a.setMonth(a.getMonth()+1),a.setDate(a.getDate()-1),t=i<n.getTime()||a.getTime()<i}t&&(this.calendars=[{month:e.getMonth(),year:e.getFullYear()}],"right"===this._o.mainCalendar&&(this.calendars[0].month+=1-this._o.numberOfMonths)),this.adjustCalendars()}},adjustDate:function(e,t){var n,a=this.getDate()||new Date,i=24*parseInt(t)*60*60*1e3;"add"===e?n=new Date(a.valueOf()+i):"subtract"===e&&(n=new Date(a.valueOf()-i)),this.setDate(n)},adjustCalendars:function(){this.calendars[0]=y(this.calendars[0]);for(var e=1;e<this._o.numberOfMonths;e++)this.calendars[e]=y({month:this.calendars[0].month+e,year:this.calendars[0].year});this.draw()},gotoToday:function(){this.gotoDate(new Date)},gotoMonth:function(e){isNaN(e)||(this.calendars[0].month=parseInt(e,10),this.adjustCalendars())},nextMonth:function(){this.calendars[0].month++,this.adjustCalendars()},prevMonth:function(){this.calendars[0].month--,this.adjustCalendars()},gotoYear:function(e){isNaN(e)||(this.calendars[0].year=parseInt(e,10),this.adjustCalendars())},setMinDate:function(e){e instanceof Date?(f(e),this._o.minDate=e,this._o.minYear=e.getFullYear(),this._o.minMonth=e.getMonth()):(this._o.minDate=D.minDate,this._o.minYear=D.minYear,this._o.minMonth=D.minMonth,this._o.startRange=D.startRange),this.draw()},setMaxDate:function(e){e instanceof Date?(f(e),this._o.maxDate=e,this._o.maxYear=e.getFullYear(),this._o.maxMonth=e.getMonth()):(this._o.maxDate=D.maxDate,this._o.maxYear=D.maxYear,this._o.maxMonth=D.maxMonth,this._o.endRange=D.endRange),this.draw()},setStartRange:function(e){this._o.startRange=e},setEndRange:function(e){this._o.endRange=e},draw:function(e){if(this._v||e){var t,n=this._o,a=n.minYear,i=n.maxYear,s=n.minMonth,o=n.maxMonth,r="";this._y<=a&&(this._y=a,!isNaN(s)&&this._m<s&&(this._m=s)),this._y>=i&&(this._y=i,!isNaN(o)&&this._m>o&&(this._m=o));for(var l=0;l<n.numberOfMonths;l++)t="pika-title-"+Math.random().toString(36).replace(/[^a-z]+/g,"").substr(0,2),r+='<div class="pika-lendar">'+k(this,l,this.calendars[l].year,this.calendars[l].month,this.calendars[0].year,t)+this.render(this.calendars[l].year,this.calendars[l].month,t)+"</div>";this.el.innerHTML=r,n.bound&&"hidden"!==n.field.type&&setTimeout(function(){n.trigger.focus()},1),"function"==typeof this._o.onDraw&&this._o.onDraw(this),n.bound&&n.field.setAttribute("aria-label",n.ariaLabel)}},adjustPosition:function(){var e,t,n,a,i,s,l,h,d,u,c,f;if(!this._o.container){if(this.el.style.position="absolute",t=e=this._o.trigger,n=this.el.offsetWidth,a=this.el.offsetHeight,i=window.innerWidth||document.documentElement.clientWidth,s=window.innerHeight||document.documentElement.clientHeight,l=window.pageYOffset||document.body.scrollTop||document.documentElement.scrollTop,c=!0,f=!0,"function"==typeof e.getBoundingClientRect)h=(u=e.getBoundingClientRect()).left+window.pageXOffset,d=u.bottom+window.pageYOffset;else for(h=t.offsetLeft,d=t.offsetTop+t.offsetHeight;t=t.offsetParent;)h+=t.offsetLeft,d+=t.offsetTop;(this._o.reposition&&h+n>i||this._o.position.indexOf("right")>-1&&h-n+e.offsetWidth>0)&&(h=h-n+e.offsetWidth,c=!1),(this._o.reposition&&d+a>s+l||this._o.position.indexOf("top")>-1&&d-a-e.offsetHeight>0)&&(d=d-a-e.offsetHeight,f=!1),this.el.style.left=h+"px",this.el.style.top=d+"px",o(this.el,c?"left-aligned":"right-aligned"),o(this.el,f?"bottom-aligned":"top-aligned"),r(this.el,c?"right-aligned":"left-aligned"),r(this.el,f?"top-aligned":"bottom-aligned")}},render:function(e,t,n){var a=this._o,i=new Date,s=c(e,t),o=new Date(e,t,1).getDay(),r=[],l=[];f(i),a.firstDay>0&&(o-=a.firstDay)<0&&(o+=7);for(var u=0===t?11:t-1,m=11===t?0:t+1,p=0===t?e-1:e,y=11===t?e+1:e,D=c(p,u),b=s+o,k=b;k>7;)k-=7;b+=7-k;for(var x=!1,R=0,N=0;R<b;R++){var S=new Date(e,t,R-o+1),T=!!h(this._d)&&g(S,this._d),C=g(S,i),I=-1!==a.events.indexOf(S.toDateString()),Y=R<o||R>=s+o,O=R-o+1,E=t,j=e,F=a.startRange&&g(a.startRange,S),W=a.endRange&&g(a.endRange,S),A=a.startRange&&a.endRange&&a.startRange<S&&S<a.endRange;Y&&(R<o?(O=D+O,E=u,j=p):(O-=s,E=m,j=y));var L={day:O,month:E,year:j,hasEvent:I,isSelected:T,isToday:C,isDisabled:a.minDate&&S<a.minDate||a.maxDate&&S>a.maxDate||a.disableWeekends&&d(S)||a.disableDayFn&&a.disableDayFn(S),isEmpty:Y,isStartRange:F,isEndRange:W,isInRange:A,showDaysInNextAndPreviousMonths:a.showDaysInNextAndPreviousMonths,enableSelectionDaysInNextAndPreviousMonths:a.enableSelectionDaysInNextAndPreviousMonths};a.pickWholeWeek&&T&&(x=!0),l.push(_(L)),7==++N&&(a.showWeekNumber&&l.unshift(v(R-o,t,e)),r.push(w(l,a.isRTL,a.pickWholeWeek,x)),l=[],N=0,x=!1)}return M(a,r,n)},isVisible:function(){return this._v},show:function(){this.isVisible()||(this._v=!0,this.draw(),r(this.el,"is-hidden"),this._o.bound&&(a(document,"click",this._onClick),this.adjustPosition()),"function"==typeof this._o.onOpen&&this._o.onOpen.call(this))},hide:function(){var e=this._v;!1!==e&&(this._o.bound&&i(document,"click",this._onClick),this.el.style.position="static",this.el.style.left="auto",this.el.style.top="auto",o(this.el,"is-hidden"),this._v=!1,void 0!==e&&"function"==typeof this._o.onClose&&this._o.onClose.call(this))},destroy:function(){var e=this._o;this.hide(),i(this.el,"mousedown",this._onMouseDown,!0),i(this.el,"touchend",this._onMouseDown,!0),i(this.el,"change",this._onChange),e.keyboardInput&&i(document,"keydown",this._onKeyChange),e.field&&(i(e.field,"change",this._onInputChange),e.bound&&(i(e.trigger,"click",this._onInputClick),i(e.trigger,"focus",this._onInputFocus),i(e.trigger,"blur",this._onInputBlur))),this.el.parentNode&&this.el.parentNode.removeChild(this.el)}},t.exports=x},
490: function _(n,o,t){n(164),n(163).styles.append('.bk-root {\n  @charset "UTF-8";\n  /*!\n * Pikaday\n * Copyright © 2014 David Bushell | BSD & MIT license | https://dbushell.com/\n */\n  /*\nclear child float (pika-lendar), using the famous micro clearfix hack\nhttp://nicolasgallagher.com/micro-clearfix-hack/\n*/\n  /* styling for abbr */\n}\n.bk-root .pika-single {\n  z-index: 9999;\n  display: block;\n  position: relative;\n  color: #333;\n  background: #fff;\n  border: 1px solid #ccc;\n  border-bottom-color: #bbb;\n  font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;\n}\n.bk-root .pika-single:before,\n.bk-root .pika-single:after {\n  content: " ";\n  display: table;\n}\n.bk-root .pika-single:after {\n  clear: both;\n}\n.bk-root .pika-single.is-hidden {\n  display: none;\n}\n.bk-root .pika-single.is-bound {\n  position: absolute;\n  box-shadow: 0 5px 15px -5px rgba(0, 0, 0, 0.5);\n}\n.bk-root .pika-lendar {\n  float: left;\n  width: 240px;\n  margin: 8px;\n}\n.bk-root .pika-title {\n  position: relative;\n  text-align: center;\n}\n.bk-root .pika-label {\n  display: inline-block;\n  position: relative;\n  z-index: 9999;\n  overflow: hidden;\n  margin: 0;\n  padding: 5px 3px;\n  font-size: 14px;\n  line-height: 20px;\n  font-weight: bold;\n  background-color: #fff;\n}\n.bk-root .pika-title select {\n  cursor: pointer;\n  position: absolute;\n  z-index: 9998;\n  margin: 0;\n  left: 0;\n  top: 5px;\n  opacity: 0;\n}\n.bk-root .pika-prev,\n.bk-root .pika-next {\n  display: block;\n  cursor: pointer;\n  position: relative;\n  outline: none;\n  border: 0;\n  padding: 0;\n  width: 20px;\n  height: 30px;\n  /* hide text using text-indent trick, using width value (it\'s enough) */\n  text-indent: 20px;\n  white-space: nowrap;\n  overflow: hidden;\n  background-color: transparent;\n  background-position: center center;\n  background-repeat: no-repeat;\n  background-size: 75% 75%;\n  opacity: 0.5;\n}\n.bk-root .pika-prev:hover,\n.bk-root .pika-next:hover {\n  opacity: 1;\n}\n.bk-root .pika-prev,\n.bk-root .is-rtl .pika-next {\n  float: left;\n  background-image: url(\'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAeCAYAAAAsEj5rAAAAUklEQVR42u3VMQoAIBADQf8Pgj+OD9hG2CtONJB2ymQkKe0HbwAP0xucDiQWARITIDEBEnMgMQ8S8+AqBIl6kKgHiXqQqAeJepBo/z38J/U0uAHlaBkBl9I4GwAAAABJRU5ErkJggg==\');\n}\n.bk-root .pika-next,\n.bk-root .is-rtl .pika-prev {\n  float: right;\n  background-image: url(\'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAeCAYAAAAsEj5rAAAAU0lEQVR42u3VOwoAMAgE0dwfAnNjU26bYkBCFGwfiL9VVWoO+BJ4Gf3gtsEKKoFBNTCoCAYVwaAiGNQGMUHMkjGbgjk2mIONuXo0nC8XnCf1JXgArVIZAQh5TKYAAAAASUVORK5CYII=\');\n}\n.bk-root .pika-prev.is-disabled,\n.bk-root .pika-next.is-disabled {\n  cursor: default;\n  opacity: 0.2;\n}\n.bk-root .pika-select {\n  display: inline-block;\n}\n.bk-root .pika-table {\n  width: 100%;\n  border-collapse: collapse;\n  border-spacing: 0;\n  border: 0;\n}\n.bk-root .pika-table th,\n.bk-root .pika-table td {\n  width: 14.28571429%;\n  padding: 0;\n}\n.bk-root .pika-table th {\n  color: #999;\n  font-size: 12px;\n  line-height: 25px;\n  font-weight: bold;\n  text-align: center;\n}\n.bk-root .pika-button {\n  cursor: pointer;\n  display: block;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  outline: none;\n  border: 0;\n  margin: 0;\n  width: 100%;\n  padding: 5px;\n  color: #666;\n  font-size: 12px;\n  line-height: 15px;\n  text-align: right;\n  background: #f5f5f5;\n}\n.bk-root .pika-week {\n  font-size: 11px;\n  color: #999;\n}\n.bk-root .is-today .pika-button {\n  color: #33aaff;\n  font-weight: bold;\n}\n.bk-root .is-selected .pika-button,\n.bk-root .has-event .pika-button {\n  color: #fff;\n  font-weight: bold;\n  background: #33aaff;\n  box-shadow: inset 0 1px 3px #178fe5;\n  border-radius: 3px;\n}\n.bk-root .has-event .pika-button {\n  background: #005da9;\n  box-shadow: inset 0 1px 3px #0076c9;\n}\n.bk-root .is-disabled .pika-button,\n.bk-root .is-inrange .pika-button {\n  background: #D5E9F7;\n}\n.bk-root .is-startrange .pika-button {\n  color: #fff;\n  background: #6CB31D;\n  box-shadow: none;\n  border-radius: 3px;\n}\n.bk-root .is-endrange .pika-button {\n  color: #fff;\n  background: #33aaff;\n  box-shadow: none;\n  border-radius: 3px;\n}\n.bk-root .is-disabled .pika-button {\n  pointer-events: none;\n  cursor: default;\n  color: #999;\n  opacity: 0.3;\n}\n.bk-root .is-outside-current-month .pika-button {\n  color: #999;\n  opacity: 0.3;\n}\n.bk-root .is-selection-disabled {\n  pointer-events: none;\n  cursor: default;\n}\n.bk-root .pika-button:hover,\n.bk-root .pika-row.pick-whole-week:hover .pika-button {\n  color: #fff;\n  background: #ff8000;\n  box-shadow: none;\n  border-radius: 3px;\n}\n.bk-root .pika-table abbr {\n  border-bottom: none;\n  cursor: help;\n}\n')},
491: function _(e,t,n){var r=e(113),i=e(252),a=e(492),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t}(a.AbstractRangeSliderView);n.DateRangeSliderView=_,_.__name__="DateRangeSliderView";var o=function(e){function t(t){var n=e.call(this,t)||this;return n.behaviour="drag",n.connected=[!1,!0,!1],n}return r.__extends(t,e),t.init_DateRangeSlider=function(){this.prototype.default_view=_,this.override({format:"%d %b %Y"})},t.prototype._formatter=function(e,t){return i(e,t)},t}(a.AbstractSlider);n.DateRangeSlider=o,o.__name__="DateRangeSlider",o.init_DateRangeSlider()},
492: function _(t,e,i){var l=t(113),r=t(493),n=t(121),o=t(163),s=t(110),a=t(119),c=t(475),d=t(494),h="bk-noUi-",_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),Object.defineProperty(e.prototype,"noUiSlider",{get:function(){return this.slider_el.noUiSlider},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_callback()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var i=this.model.properties,l=i.callback,r=i.callback_policy,n=i.callback_throttle;this.on_change([l,r,n],function(){return e._init_callback()});var o=this.model.properties,s=o.start,a=o.end,c=o.value,d=o.step,h=o.title;this.on_change([s,a,c,d],function(){var t=e._calc_to(),i=t.start,l=t.end,r=t.value,n=t.step;e.noUiSlider.updateOptions({range:{min:i,max:l},start:r,step:n})});var _=this.model.properties.bar_color;this.on_change(_,function(){e._set_bar_color()}),this.on_change([c,h],function(){return e._update_title()})},e.prototype._init_callback=function(){var t=this,e=this.model.callback,i=function(){null!=e&&e.execute(t.model),t.model.value_throttled=t.model.value};switch(this.model.callback_policy){case"continuous":this.callback_wrapper=i;break;case"throttle":this.callback_wrapper=a.throttle(i,this.model.callback_throttle);break;default:this.callback_wrapper=void 0}},e.prototype._update_title=function(){var t=this;o.empty(this.title_el);var e=null==this.model.title||0==this.model.title.length&&!this.model.show_value;if(this.title_el.style.display=e?"none":"",!e&&(0!=this.model.title.length&&(this.title_el.textContent=this.model.title+": "),this.model.show_value)){var i=this._calc_to().value.map(function(e){return t.model.pretty(e)}).join(" .. ");this.title_el.appendChild(o.span({class:d.bk_slider_value},i))}},e.prototype._set_bar_color=function(){this.model.disabled||(this.slider_el.querySelector(".bk-noUi-connect").style.backgroundColor=this.model.bar_color)},e.prototype._keypress_handle=function(t,e){void 0===e&&(e=0);var i=this._calc_to(),l=i.start,r=i.value,n=i.end,o=i.step,s=2==r.length,a=l,c=n;switch(s&&0==e?c=r[1]:s&&1==e&&(a=r[0]),t.which){case 37:r[e]=Math.max(r[e]-o,a);break;case 39:r[e]=Math.min(r[e]+o,c);break;default:return}s?(this.model.value=r,this.model.properties.value.change.emit()):this.model.value=r[0],this.noUiSlider.set(r),null!=this.callback_wrapper&&this.callback_wrapper()},e.prototype.render=function(){var e=this;t.prototype.render.call(this);var i,l=this._calc_to(),n=l.start,a=l.end,c=l.value,_=l.step;if(this.model.tooltips){var u={to:function(t){return e.model.pretty(t)}};i=s.repeat(u,c.length)}else i=!1;if(null==this.slider_el){this.slider_el=o.div(),r.create(this.slider_el,{cssPrefix:h,range:{min:n,max:a},start:c,step:_,behaviour:this.model.behaviour,connect:this.model.connected,tooltips:i,orientation:this.model.orientation,direction:this.model.direction}),this.noUiSlider.on("slide",function(t,i,l){return e._slide(l)}),this.noUiSlider.on("change",function(t,i,l){return e._change(l)}),this._set_keypress_handles();var p=function(t,l){i&&(e.slider_el.querySelectorAll(".bk-noUi-handle")[t].querySelector(".bk-noUi-tooltip").style.display=l?"block":"")};this.noUiSlider.on("start",function(t,e){return p(e,!0)}),this.noUiSlider.on("end",function(t,e){return p(e,!1)})}else this.noUiSlider.updateOptions({range:{min:n,max:a},start:c,step:_});this._set_bar_color(),this.model.disabled?this.slider_el.setAttribute("disabled","true"):this.slider_el.removeAttribute("disabled"),this.title_el=o.div({class:d.bk_slider_title}),this._update_title(),this.group_el=o.div({class:d.bk_input_group},this.title_el,this.slider_el),this.el.appendChild(this.group_el)},e.prototype._slide=function(t){this.model.value=this._calc_from(t),null!=this.callback_wrapper&&this.callback_wrapper()},e.prototype._change=function(t){switch(this.model.value=this._calc_from(t),this.model.value_throttled=this.model.value,this.model.callback_policy){case"mouseup":case"throttle":null!=this.model.callback&&this.model.callback.execute(this.model)}},e}(c.ControlView);_.__name__="AbstractBaseSliderView";var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:[this.model.value],step:this.model.step}},e.prototype._calc_from=function(t){var e=t[0];return Number.isInteger(this.model.start)&&Number.isInteger(this.model.end)&&Number.isInteger(this.model.step)?Math.round(e):e},e.prototype._set_keypress_handles=function(){var t=this,e=this.slider_el.querySelector(".bk-noUi-handle");e.setAttribute("tabindex","0"),e.addEventListener("keydown",function(e){return t._keypress_handle(e)})},e}(_);i.AbstractSliderView=u,u.__name__="AbstractSliderView";var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:this.model.value,step:this.model.step}},e.prototype._calc_from=function(t){return t},e.prototype._set_keypress_handles=function(){var t=this,e=this.slider_el.querySelector(".bk-noUi-handle-lower"),i=this.slider_el.querySelector(".bk-noUi-handle-upper");e.setAttribute("tabindex","0"),e.addEventListener("keydown",function(e){return t._keypress_handle(e,0)}),i.setAttribute("tabindex","1"),i.addEventListener("keydown",function(e){return t._keypress_handle(e,1)})},e}(_);i.AbstractRangeSliderView=p,p.__name__="AbstractRangeSliderView";var m=function(t){function e(e){var i=t.call(this,e)||this;return i.connected=!1,i}return l.__extends(e,t),e.init_AbstractSlider=function(){this.define({title:[n.String,""],show_value:[n.Boolean,!0],start:[n.Any],end:[n.Any],value:[n.Any],value_throttled:[n.Any],step:[n.Number,1],format:[n.String],direction:[n.Any,"ltr"],tooltips:[n.Boolean,!0],callback:[n.Any],callback_throttle:[n.Number,200],callback_policy:[n.SliderCallbackPolicy,"throttle"],bar_color:[n.Color,"#e6e6e6"]})},e.prototype._formatter=function(t,e){return""+t},e.prototype.pretty=function(t){return this._formatter(t,this.format)},e}(c.Control);i.AbstractSlider=m,m.__name__="AbstractSlider",m.init_AbstractSlider()},
493: function _(t,e,r){
/*! nouislider - 10.1.0 - 2017-07-28 17:11:18 */var n;n=function(){"use strict";var t="10.1.0";function e(t){t.preventDefault()}function r(t){return"number"==typeof t&&!isNaN(t)&&isFinite(t)}function n(t,e,r){r>0&&(s(t,e),setTimeout(function(){a(t,e)},r))}function i(t){return Array.isArray(t)?t:[t]}function o(t){var e=(t=String(t)).split(".");return e.length>1?e[1].length:0}function s(t,e){t.classList?t.classList.add(e):t.className+=" "+e}function a(t,e){t.classList?t.classList.remove(e):t.className=t.className.replace(new RegExp("(^|\\b)"+e.split(" ").join("|")+"(\\b|$)","gi")," ")}function l(t){var e=void 0!==window.pageXOffset,r="CSS1Compat"===(t.compatMode||"");return{x:e?window.pageXOffset:r?t.documentElement.scrollLeft:t.body.scrollLeft,y:e?window.pageYOffset:r?t.documentElement.scrollTop:t.body.scrollTop}}function u(t,e){return 100/(e-t)}function c(t,e){return 100*e/(t[1]-t[0])}function p(t,e){for(var r=1;t>=e[r];)r+=1;return r}function f(t,e,r){if(r>=t.slice(-1)[0])return 100;var n,i,o,s,a=p(r,t);return n=t[a-1],i=t[a],o=e[a-1],s=e[a],o+function(t,e){return c(t,t[0]<0?e+Math.abs(t[0]):e-t[0])}([n,i],r)/u(o,s)}function d(t,e,r,n){if(100===n)return n;var i,o,s=p(n,t);return r?n-(i=t[s-1])>((o=t[s])-i)/2?o:i:e[s-1]?t[s-1]+function(t,e){return Math.round(t/e)*e}(n-t[s-1],e[s-1]):n}function h(e,n,i){var o;if("number"==typeof n&&(n=[n]),"[object Array]"!==Object.prototype.toString.call(n))throw new Error("noUiSlider ("+t+"): 'range' contains invalid value.");if(!r(o="min"===e?0:"max"===e?100:parseFloat(e))||!r(n[0]))throw new Error("noUiSlider ("+t+"): 'range' value isn't numeric.");i.xPct.push(o),i.xVal.push(n[0]),o?i.xSteps.push(!isNaN(n[1])&&n[1]):isNaN(n[1])||(i.xSteps[0]=n[1]),i.xHighestCompleteStep.push(0)}function m(t,e,r){if(!e)return!0;r.xSteps[t]=c([r.xVal[t],r.xVal[t+1]],e)/u(r.xPct[t],r.xPct[t+1]);var n=(r.xVal[t+1]-r.xVal[t])/r.xNumSteps[t],i=Math.ceil(Number(n.toFixed(3))-1),o=r.xVal[t]+r.xNumSteps[t]*i;r.xHighestCompleteStep[t]=o}function g(t,e,r){this.xPct=[],this.xVal=[],this.xSteps=[r||!1],this.xNumSteps=[!1],this.xHighestCompleteStep=[],this.snap=e;var n,i=[];for(n in t)t.hasOwnProperty(n)&&i.push([t[n],n]);for(i.length&&"object"==typeof i[0][0]?i.sort(function(t,e){return t[0][0]-e[0][0]}):i.sort(function(t,e){return t[0]-e[0]}),n=0;n<i.length;n++)h(i[n][1],i[n][0],this);for(this.xNumSteps=this.xSteps.slice(0),n=0;n<this.xNumSteps.length;n++)m(n,this.xNumSteps[n],this)}g.prototype.getMargin=function(e){var r=this.xNumSteps[0];if(r&&e/r%1!=0)throw new Error("noUiSlider ("+t+"): 'limit', 'margin' and 'padding' must be divisible by step.");return 2===this.xPct.length&&c(this.xVal,e)},g.prototype.toStepping=function(t){return t=f(this.xVal,this.xPct,t)},g.prototype.fromStepping=function(t){return function(t,e,r){if(r>=100)return t.slice(-1)[0];var n,i=p(r,e);return function(t,e){return e*(t[1]-t[0])/100+t[0]}([t[i-1],t[i]],(r-(n=e[i-1]))*u(n,e[i]))}(this.xVal,this.xPct,t)},g.prototype.getStep=function(t){return t=d(this.xPct,this.xSteps,this.snap,t)},g.prototype.getNearbySteps=function(t){var e=p(t,this.xPct);return{stepBefore:{startValue:this.xVal[e-2],step:this.xNumSteps[e-2],highestStep:this.xHighestCompleteStep[e-2]},thisStep:{startValue:this.xVal[e-1],step:this.xNumSteps[e-1],highestStep:this.xHighestCompleteStep[e-1]},stepAfter:{startValue:this.xVal[e-0],step:this.xNumSteps[e-0],highestStep:this.xHighestCompleteStep[e-0]}}},g.prototype.countStepDecimals=function(){var t=this.xNumSteps.map(o);return Math.max.apply(null,t)},g.prototype.convert=function(t){return this.getStep(this.toStepping(t))};var v={to:function(t){return void 0!==t&&t.toFixed(2)},from:Number};function b(e){if(function(t){return"object"==typeof t&&"function"==typeof t.to&&"function"==typeof t.from}(e))return!0;throw new Error("noUiSlider ("+t+"): 'format' requires 'to' and 'from' methods.")}function S(e,n){if(!r(n))throw new Error("noUiSlider ("+t+"): 'step' is not numeric.");e.singleStep=n}function w(e,r){if("object"!=typeof r||Array.isArray(r))throw new Error("noUiSlider ("+t+"): 'range' is not an object.");if(void 0===r.min||void 0===r.max)throw new Error("noUiSlider ("+t+"): Missing 'min' or 'max' in 'range'.");if(r.min===r.max)throw new Error("noUiSlider ("+t+"): 'range' 'min' and 'max' cannot be equal.");e.spectrum=new g(r,e.snap,e.singleStep)}function x(e,r){if(r=i(r),!Array.isArray(r)||!r.length)throw new Error("noUiSlider ("+t+"): 'start' option is incorrect.");e.handles=r.length,e.start=r}function y(e,r){if(e.snap=r,"boolean"!=typeof r)throw new Error("noUiSlider ("+t+"): 'snap' option must be a boolean.")}function E(e,r){if(e.animate=r,"boolean"!=typeof r)throw new Error("noUiSlider ("+t+"): 'animate' option must be a boolean.")}function C(e,r){if(e.animationDuration=r,"number"!=typeof r)throw new Error("noUiSlider ("+t+"): 'animationDuration' option must be a number.")}function N(e,r){var n,i=[!1];if("lower"===r?r=[!0,!1]:"upper"===r&&(r=[!1,!0]),!0===r||!1===r){for(n=1;n<e.handles;n++)i.push(r);i.push(!1)}else{if(!Array.isArray(r)||!r.length||r.length!==e.handles+1)throw new Error("noUiSlider ("+t+"): 'connect' option doesn't match handle count.");i=r}e.connect=i}function U(e,r){switch(r){case"horizontal":e.ort=0;break;case"vertical":e.ort=1;break;default:throw new Error("noUiSlider ("+t+"): 'orientation' option is invalid.")}}function P(e,n){if(!r(n))throw new Error("noUiSlider ("+t+"): 'margin' option must be numeric.");if(0!==n&&(e.margin=e.spectrum.getMargin(n),!e.margin))throw new Error("noUiSlider ("+t+"): 'margin' option is only supported on linear sliders.")}function A(e,n){if(!r(n))throw new Error("noUiSlider ("+t+"): 'limit' option must be numeric.");if(e.limit=e.spectrum.getMargin(n),!e.limit||e.handles<2)throw new Error("noUiSlider ("+t+"): 'limit' option is only supported on linear sliders with 2 or more handles.")}function M(e,n){if(!r(n))throw new Error("noUiSlider ("+t+"): 'padding' option must be numeric.");if(0!==n){if(e.padding=e.spectrum.getMargin(n),!e.padding)throw new Error("noUiSlider ("+t+"): 'padding' option is only supported on linear sliders.");if(e.padding<0)throw new Error("noUiSlider ("+t+"): 'padding' option must be a positive number.");if(e.padding>=50)throw new Error("noUiSlider ("+t+"): 'padding' option must be less than half the range.")}}function O(e,r){switch(r){case"ltr":e.dir=0;break;case"rtl":e.dir=1;break;default:throw new Error("noUiSlider ("+t+"): 'direction' option was not recognized.")}}function k(e,r){if("string"!=typeof r)throw new Error("noUiSlider ("+t+"): 'behaviour' must be a string containing options.");var n=r.indexOf("tap")>=0,i=r.indexOf("drag")>=0,o=r.indexOf("fixed")>=0,s=r.indexOf("snap")>=0,a=r.indexOf("hover")>=0;if(o){if(2!==e.handles)throw new Error("noUiSlider ("+t+"): 'fixed' behaviour must be used with 2 handles");P(e,e.start[1]-e.start[0])}e.events={tap:n||s,drag:i,fixed:o,snap:s,hover:a}}function V(e,r){if(e.multitouch=r,"boolean"!=typeof r)throw new Error("noUiSlider ("+t+"): 'multitouch' option must be a boolean.")}function F(e,r){if(!1!==r)if(!0===r){e.tooltips=[];for(var n=0;n<e.handles;n++)e.tooltips.push(!0)}else{if(e.tooltips=i(r),e.tooltips.length!==e.handles)throw new Error("noUiSlider ("+t+"): must pass a formatter for all handles.");e.tooltips.forEach(function(e){if("boolean"!=typeof e&&("object"!=typeof e||"function"!=typeof e.to))throw new Error("noUiSlider ("+t+"): 'tooltips' must be passed a formatter or 'false'.")})}}function L(t,e){t.ariaFormat=e,b(e)}function z(t,e){t.format=e,b(e)}function j(e,r){if(void 0!==r&&"string"!=typeof r&&!1!==r)throw new Error("noUiSlider ("+t+"): 'cssPrefix' must be a string or `false`.");e.cssPrefix=r}function H(e,r){if(void 0!==r&&"object"!=typeof r)throw new Error("noUiSlider ("+t+"): 'cssClasses' must be an object.");if("string"==typeof e.cssPrefix)for(var n in e.cssClasses={},r)r.hasOwnProperty(n)&&(e.cssClasses[n]=e.cssPrefix+r[n]);else e.cssClasses=r}function D(e,r){if(!0!==r&&!1!==r)throw new Error("noUiSlider ("+t+"): 'useRequestAnimationFrame' option should be true (default) or false.");e.useRequestAnimationFrame=r}function q(e){var r={margin:0,limit:0,padding:0,animate:!0,animationDuration:300,ariaFormat:v,format:v},n={step:{r:!1,t:S},start:{r:!0,t:x},connect:{r:!0,t:N},direction:{r:!0,t:O},snap:{r:!1,t:y},animate:{r:!1,t:E},animationDuration:{r:!1,t:C},range:{r:!0,t:w},orientation:{r:!1,t:U},margin:{r:!1,t:P},limit:{r:!1,t:A},padding:{r:!1,t:M},behaviour:{r:!0,t:k},multitouch:{r:!0,t:V},ariaFormat:{r:!1,t:L},format:{r:!1,t:z},tooltips:{r:!1,t:F},cssPrefix:{r:!1,t:j},cssClasses:{r:!1,t:H},useRequestAnimationFrame:{r:!1,t:D}},i={connect:!1,direction:"ltr",behaviour:"tap",multitouch:!1,orientation:"horizontal",cssPrefix:"noUi-",cssClasses:{target:"target",base:"base",origin:"origin",handle:"handle",handleLower:"handle-lower",handleUpper:"handle-upper",horizontal:"horizontal",vertical:"vertical",background:"background",connect:"connect",ltr:"ltr",rtl:"rtl",draggable:"draggable",drag:"state-drag",tap:"state-tap",active:"active",tooltip:"tooltip",pips:"pips",pipsHorizontal:"pips-horizontal",pipsVertical:"pips-vertical",marker:"marker",markerHorizontal:"marker-horizontal",markerVertical:"marker-vertical",markerNormal:"marker-normal",markerLarge:"marker-large",markerSub:"marker-sub",value:"value",valueHorizontal:"value-horizontal",valueVertical:"value-vertical",valueNormal:"value-normal",valueLarge:"value-large",valueSub:"value-sub"},useRequestAnimationFrame:!0};e.format&&!e.ariaFormat&&(e.ariaFormat=e.format),Object.keys(n).forEach(function(o){if(void 0===e[o]&&void 0===i[o]){if(n[o].r)throw new Error("noUiSlider ("+t+"): '"+o+"' is required.");return!0}n[o].t(r,void 0===e[o]?i[o]:e[o])}),r.pips=e.pips;var o=[["left","top"],["right","bottom"]];return r.style=o[r.dir][r.ort],r.styleOposite=o[r.dir?0:1][r.ort],r}function T(r,o,u){var c,p,f,d,h,m,g,v=window.navigator.pointerEnabled?{start:"pointerdown",move:"pointermove",end:"pointerup"}:window.navigator.msPointerEnabled?{start:"MSPointerDown",move:"MSPointerMove",end:"MSPointerUp"}:{start:"mousedown touchstart",move:"mousemove touchmove",end:"mouseup touchend"},b=window.CSS&&CSS.supports&&CSS.supports("touch-action","none")&&function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",null,e)}catch(t){}return t}(),S=r,w=[],x=[],y=0,E=o.spectrum,C=[],N={},U=r.ownerDocument,P=U.documentElement,A=U.body;function M(t,e){var r=U.createElement("div");return e&&s(r,e),t.appendChild(r),r}function O(t,e){var r=M(t,o.cssClasses.origin),n=M(r,o.cssClasses.handle);return n.setAttribute("data-handle",e),n.setAttribute("tabindex","0"),n.setAttribute("role","slider"),n.setAttribute("aria-orientation",o.ort?"vertical":"horizontal"),0===e?s(n,o.cssClasses.handleLower):e===o.handles-1&&s(n,o.cssClasses.handleUpper),r}function k(t,e){return!!e&&M(t,o.cssClasses.connect)}function V(t,e){return!!o.tooltips[e]&&M(t.firstChild,o.cssClasses.tooltip)}function F(t,e,r){var n=U.createElement("div"),i=[o.cssClasses.valueNormal,o.cssClasses.valueLarge,o.cssClasses.valueSub],a=[o.cssClasses.markerNormal,o.cssClasses.markerLarge,o.cssClasses.markerSub],l=[o.cssClasses.valueHorizontal,o.cssClasses.valueVertical],u=[o.cssClasses.markerHorizontal,o.cssClasses.markerVertical];function c(t,e){var r=e===o.cssClasses.value,n=r?i:a;return e+" "+(r?l:u)[o.ort]+" "+n[t]}return s(n,o.cssClasses.pips),s(n,0===o.ort?o.cssClasses.pipsHorizontal:o.cssClasses.pipsVertical),Object.keys(t).forEach(function(i){!function(t,i){i[1]=i[1]&&e?e(i[0],i[1]):i[1];var s=M(n,!1);s.className=c(i[1],o.cssClasses.marker),s.style[o.style]=t+"%",i[1]&&((s=M(n,!1)).className=c(i[1],o.cssClasses.value),s.style[o.style]=t+"%",s.innerText=r.to(i[0]))}(i,t[i])}),n}function L(){var t;h&&((t=h).parentElement.removeChild(t),h=null)}function z(e){L();var r=e.mode,n=e.density||1,i=e.filter||!1,o=function(e,r,n){if("range"===e||"steps"===e)return E.xVal;if("count"===e){if(!r)throw new Error("noUiSlider ("+t+"): 'values' required for mode 'count'.");var i,o=100/(r-1),s=0;for(r=[];(i=s++*o)<=100;)r.push(i);e="positions"}return"positions"===e?r.map(function(t){return E.fromStepping(n?E.getStep(t):t)}):"values"===e?n?r.map(function(t){return E.fromStepping(E.getStep(E.toStepping(t)))}):r:void 0}(r,e.values||!1,e.stepped||!1),s=function(t,e,r){var n,i={},o=E.xVal[0],s=E.xVal[E.xVal.length-1],a=!1,l=!1,u=0;return n=r.slice().sort(function(t,e){return t-e}),(r=n.filter(function(t){return!this[t]&&(this[t]=!0)},{}))[0]!==o&&(r.unshift(o),a=!0),r[r.length-1]!==s&&(r.push(s),l=!0),r.forEach(function(n,o){var s,c,p,f,d,h,m,g,v,b=n,S=r[o+1];if("steps"===e&&(s=E.xNumSteps[o]),s||(s=S-b),!1!==b&&void 0!==S)for(s=Math.max(s,1e-7),c=b;c<=S;c=(c+s).toFixed(7)/1){for(m=(d=(f=E.toStepping(c))-u)/t,v=d/(g=Math.round(m)),p=1;p<=g;p+=1)i[(u+p*v).toFixed(5)]=["x",0];h=r.indexOf(c)>-1?1:"steps"===e?2:0,!o&&a&&(h=0),c===S&&l||(i[f.toFixed(5)]=[c,h]),u=f}}),i}(n,r,o),a=e.format||{to:Math.round};return h=S.appendChild(F(s,i,a))}function j(){var t=c.getBoundingClientRect(),e="offset"+["Width","Height"][o.ort];return 0===o.ort?t.width||c[e]:t.height||c[e]}function H(t,e,r,n){var i=function(i){return!S.hasAttribute("disabled")&&(s=S,a=o.cssClasses.tap,(s.classList?!s.classList.contains(a):!new RegExp("\\b"+a+"\\b").test(s.className))&&(!!(i=function(t,e,r){var n,i,s=0===t.type.indexOf("touch"),a=0===t.type.indexOf("mouse"),u=0===t.type.indexOf("pointer");0===t.type.indexOf("MSPointer")&&(u=!0);if(s&&o.multitouch){var c=function(t){return t.target===r||r.contains(t.target)};if("touchstart"===t.type){var p=Array.prototype.filter.call(t.touches,c);if(p.length>1)return!1;n=p[0].pageX,i=p[0].pageY}else{var f=Array.prototype.find.call(t.changedTouches,c);if(!f)return!1;n=f.pageX,i=f.pageY}}else if(s){if(t.touches.length>1)return!1;n=t.changedTouches[0].pageX,i=t.changedTouches[0].pageY}e=e||l(U),(a||u)&&(n=t.clientX+e.x,i=t.clientY+e.y);return t.pageOffset=e,t.points=[n,i],t.cursor=a||u,t}(i,n.pageOffset,n.target||e))&&(!(t===v.start&&void 0!==i.buttons&&i.buttons>1)&&((!n.hover||!i.buttons)&&(b||i.preventDefault(),i.calcPoint=i.points[o.ort],void r(i,n))))));var s,a},s=[];return t.split(" ").forEach(function(t){e.addEventListener(t,i,!!b&&{passive:!0}),s.push([t,i])}),s}function D(t){var e,r,n,i,s,a,u=100*(t-(e=c,r=o.ort,n=e.getBoundingClientRect(),i=e.ownerDocument,s=i.documentElement,a=l(i),/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(a.x=0),r?n.top+a.y-s.clientTop:n.left+a.x-s.clientLeft))/j();return o.dir?100-u:u}function T(t,e,r,n){var i=r.slice(),o=[!t,t],s=[t,!t];n=n.slice(),t&&n.reverse(),n.length>1?n.forEach(function(t,r){var n=$(i,t,i[t]+e,o[r],s[r],!1);!1===n?e=0:(e=n-i[t],i[t]=n)}):o=s=[!0];var a=!1;n.forEach(function(t,n){a=K(t,r[t]+e,o[n],s[n])||a}),a&&n.forEach(function(t){R("update",t),R("slide",t)})}function R(t,e,r){Object.keys(N).forEach(function(n){var i=n.split(".")[0];t===i&&N[n].forEach(function(t){t.call(d,C.map(o.format.to),e,C.slice(),r||!1,w.slice())})})}function X(t,e){"mouseout"===t.type&&"HTML"===t.target.nodeName&&null===t.relatedTarget&&Y(t,e)}function B(t,e){if(-1===navigator.appVersion.indexOf("MSIE 9")&&0===t.buttons&&0!==e.buttonsProperty)return Y(t,e);var r=(o.dir?-1:1)*(t.calcPoint-e.startCalcPoint);T(r>0,100*r/e.baseSize,e.locations,e.handleNumbers)}function Y(t,r){r.handle&&(a(r.handle,o.cssClasses.active),y-=1),r.listeners.forEach(function(t){P.removeEventListener(t[0],t[1])}),0===y&&(a(S,o.cssClasses.drag),J(),t.cursor&&(A.style.cursor="",A.removeEventListener("selectstart",e))),r.handleNumbers.forEach(function(t){R("change",t),R("set",t),R("end",t)})}function _(t,r){var n;if(1===r.handleNumbers.length){var i=p[r.handleNumbers[0]];if(i.hasAttribute("disabled"))return!1;n=i.children[0],y+=1,s(n,o.cssClasses.active)}t.stopPropagation();var a=[],l=H(v.move,P,B,{target:t.target,handle:n,listeners:a,startCalcPoint:t.calcPoint,baseSize:j(),pageOffset:t.pageOffset,handleNumbers:r.handleNumbers,buttonsProperty:t.buttons,locations:w.slice()}),u=H(v.end,P,Y,{target:t.target,handle:n,listeners:a,handleNumbers:r.handleNumbers}),c=H("mouseout",P,X,{target:t.target,handle:n,listeners:a,handleNumbers:r.handleNumbers});a.push.apply(a,l.concat(u,c)),t.cursor&&(A.style.cursor=getComputedStyle(t.target).cursor,p.length>1&&s(S,o.cssClasses.drag),A.addEventListener("selectstart",e,!1)),r.handleNumbers.forEach(function(t){R("start",t)})}function I(t){t.stopPropagation();var e=D(t.calcPoint),r=function(t){var e=100,r=!1;return p.forEach(function(n,i){if(!n.hasAttribute("disabled")){var o=Math.abs(w[i]-t);o<e&&(r=i,e=o)}}),r}(e);if(!1===r)return!1;o.events.snap||n(S,o.cssClasses.tap,o.animationDuration),K(r,e,!0,!0),J(),R("slide",r,!0),R("update",r,!0),R("change",r,!0),R("set",r,!0),o.events.snap&&_(t,{handleNumbers:[r]})}function W(t){var e=D(t.calcPoint),r=E.getStep(e),n=E.fromStepping(r);Object.keys(N).forEach(function(t){"hover"===t.split(".")[0]&&N[t].forEach(function(t){t.call(d,n)})})}function $(t,e,r,n,i,s){var a;return p.length>1&&(n&&e>0&&(r=Math.max(r,t[e-1]+o.margin)),i&&e<p.length-1&&(r=Math.min(r,t[e+1]-o.margin))),p.length>1&&o.limit&&(n&&e>0&&(r=Math.min(r,t[e-1]+o.limit)),i&&e<p.length-1&&(r=Math.max(r,t[e+1]-o.limit))),o.padding&&(0===e&&(r=Math.max(r,o.padding)),e===p.length-1&&(r=Math.min(r,100-o.padding))),r=E.getStep(r),a=r,!((r=Math.max(Math.min(a,100),0))===t[e]&&!s)&&r}function G(t){return t+"%"}function J(){x.forEach(function(t){var e=w[t]>50?-1:1,r=3+(p.length+e*t);p[t].childNodes[0].style.zIndex=r})}function K(t,e,r,n){return!1!==(e=$(w,t,e,r,n,!1))&&(function(t,e){w[t]=e,C[t]=E.fromStepping(e);var r=function(){p[t].style[o.style]=G(e),Q(t),Q(t+1)};window.requestAnimationFrame&&o.useRequestAnimationFrame?window.requestAnimationFrame(r):r()}(t,e),!0)}function Q(t){if(f[t]){var e=0,r=100;0!==t&&(e=w[t-1]),t!==f.length-1&&(r=w[t]),f[t].style[o.style]=G(e),f[t].style[o.styleOposite]=G(100-r)}}function Z(t,e){null!==t&&!1!==t&&("number"==typeof t&&(t=String(t)),!1===(t=o.format.from(t))||isNaN(t)||K(e,E.toStepping(t),!1,!1))}function tt(t,e){var r=i(t),s=void 0===w[0];e=void 0===e||!!e,r.forEach(Z),o.animate&&!s&&n(S,o.cssClasses.tap,o.animationDuration),x.forEach(function(t){K(t,w[t],!0,!1)}),J(),x.forEach(function(t){R("update",t),null!==r[t]&&e&&R("set",t)})}function et(){var t=C.map(o.format.to);return 1===t.length?t[0]:t}function rt(t,e){N[t]=N[t]||[],N[t].push(e),"update"===t.split(".")[0]&&p.forEach(function(t,e){R("update",e)})}if(S.noUiSlider)throw new Error("noUiSlider ("+t+"): Slider was already initialized.");return function(t){s(t,o.cssClasses.target),0===o.dir?s(t,o.cssClasses.ltr):s(t,o.cssClasses.rtl),0===o.ort?s(t,o.cssClasses.horizontal):s(t,o.cssClasses.vertical),c=M(t,o.cssClasses.base)}(S),function(t,e){p=[],(f=[]).push(k(e,t[0]));for(var r=0;r<o.handles;r++)p.push(O(e,r)),x[r]=r,f.push(k(e,t[r+1]))}(o.connect,c),d={destroy:function(){for(var t in o.cssClasses)o.cssClasses.hasOwnProperty(t)&&a(S,o.cssClasses[t]);for(;S.firstChild;)S.removeChild(S.firstChild);delete S.noUiSlider},steps:function(){return w.map(function(t,e){var r=E.getNearbySteps(t),n=C[e],i=r.thisStep.step,o=null;!1!==i&&n+i>r.stepAfter.startValue&&(i=r.stepAfter.startValue-n),o=n>r.thisStep.startValue?r.thisStep.step:!1!==r.stepBefore.step&&n-r.stepBefore.highestStep,100===t?i=null:0===t&&(o=null);var s=E.countStepDecimals();return null!==i&&!1!==i&&(i=Number(i.toFixed(s))),null!==o&&!1!==o&&(o=Number(o.toFixed(s))),[o,i]})},on:rt,off:function(t){var e=t&&t.split(".")[0],r=e&&t.substring(e.length);Object.keys(N).forEach(function(t){var n=t.split(".")[0],i=t.substring(n.length);e&&e!==n||r&&r!==i||delete N[t]})},get:et,set:tt,reset:function(t){tt(o.start,t)},__moveHandles:function(t,e,r){T(t,e,w,r)},options:u,updateOptions:function(t,e){var r=et(),n=["margin","limit","padding","range","animate","snap","step","format"];n.forEach(function(e){void 0!==t[e]&&(u[e]=t[e])});var i=q(u);n.forEach(function(e){void 0!==t[e]&&(o[e]=i[e])}),E=i.spectrum,o.margin=i.margin,o.limit=i.limit,o.padding=i.padding,o.pips&&z(o.pips),w=[],tt(t.start||r,e)},target:S,removePips:L,pips:z},(m=o.events).fixed||p.forEach(function(t,e){H(v.start,t.children[0],_,{handleNumbers:[e]})}),m.tap&&H(v.start,c,I,{}),m.hover&&H(v.move,c,W,{hover:!0}),m.drag&&f.forEach(function(t,e){if(!1!==t&&0!==e&&e!==f.length-1){var r=p[e-1],n=p[e],i=[t];s(t,o.cssClasses.draggable),m.fixed&&(i.push(r.children[0]),i.push(n.children[0])),i.forEach(function(t){H(v.start,t,_,{handles:[r,n],handleNumbers:[e-1,e]})})}}),tt(o.start),o.pips&&z(o.pips),o.tooltips&&(g=p.map(V),rt("update",function(t,e,r){if(g[e]){var n=t[e];!0!==o.tooltips[e]&&(n=o.tooltips[e].to(r[e])),g[e].innerHTML=n}})),rt("update",function(t,e,r,n,i){x.forEach(function(t){var e=p[t],n=$(w,t,0,!0,!0,!0),s=$(w,t,100,!0,!0,!0),a=i[t],l=o.ariaFormat.to(r[t]);e.children[0].setAttribute("aria-valuemin",n.toFixed(1)),e.children[0].setAttribute("aria-valuemax",s.toFixed(1)),e.children[0].setAttribute("aria-valuenow",a.toFixed(1)),e.children[0].setAttribute("aria-valuetext",l)})}),d}return{version:t,create:function(e,r){if(!e||!e.nodeName)throw new Error("noUiSlider ("+t+"): create requires a single element, got: "+e);var n=T(e,q(r),r);return e.noUiSlider=n,n}}},"function"==typeof define&&define.amd?define([],n):"object"==typeof r?e.exports=n():window.noUiSlider=n()},
494: function _(e,t,i){e(164),e(495),e(163).styles.append(".bk-root .bk-slider-title {\n  white-space: nowrap;\n}\n.bk-root .bk-slider-value {\n  font-weight: 600;\n}\n"),i.bk_slider_value="bk-slider-value",i.bk_slider_title="bk-slider-title",i.bk_input_group="bk-input-group"},
495: function _(n,o,t){n(164),n(163).styles.append('.bk-root {\n  /* Functional styling;\n * These styles are required for noUiSlider to function.\n * You don\'t need to change these rules to apply your design.\n */\n  /* Painting and performance;\n * Browsers can paint handles in their own layer.\n */\n  /* Slider size and handle placement;\n */\n  /* Styling;\n */\n  /* Handles and cursors;\n */\n  /* Handle stripes;\n */\n  /* Disabled state;\n */\n  /* Base;\n *\n */\n  /* Values;\n *\n */\n  /* Markings;\n *\n */\n  /* Horizontal layout;\n *\n */\n  /* Vertical layout;\n *\n */\n}\n.bk-root .bk-noUi-target,\n.bk-root .bk-noUi-target * {\n  -webkit-touch-callout: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n  -webkit-user-select: none;\n  -ms-touch-action: none;\n  touch-action: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  user-select: none;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .bk-noUi-target {\n  position: relative;\n  direction: ltr;\n}\n.bk-root .bk-noUi-base {\n  width: 100%;\n  height: 100%;\n  position: relative;\n  z-index: 1;\n  /* Fix 401 */\n}\n.bk-root .bk-noUi-connect {\n  position: absolute;\n  right: 0;\n  top: 0;\n  left: 0;\n  bottom: 0;\n}\n.bk-root .bk-noUi-origin {\n  position: absolute;\n  height: 0;\n  width: 0;\n}\n.bk-root .bk-noUi-handle {\n  position: relative;\n  z-index: 1;\n}\n.bk-root .bk-noUi-state-tap .bk-noUi-connect,\n.bk-root .bk-noUi-state-tap .bk-noUi-origin {\n  -webkit-transition: top 0.3s, right 0.3s, bottom 0.3s, left 0.3s;\n  transition: top 0.3s, right 0.3s, bottom 0.3s, left 0.3s;\n}\n.bk-root .bk-noUi-state-drag * {\n  cursor: inherit !important;\n}\n.bk-root .bk-noUi-base,\n.bk-root .bk-noUi-handle {\n  -webkit-transform: translate3d(0, 0, 0);\n  transform: translate3d(0, 0, 0);\n}\n.bk-root .bk-noUi-horizontal {\n  height: 18px;\n}\n.bk-root .bk-noUi-horizontal .bk-noUi-handle {\n  width: 34px;\n  height: 28px;\n  left: -17px;\n  top: -6px;\n}\n.bk-root .bk-noUi-vertical {\n  width: 18px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle {\n  width: 28px;\n  height: 34px;\n  left: -6px;\n  top: -17px;\n}\n.bk-root .bk-noUi-target {\n  background: #FAFAFA;\n  border-radius: 4px;\n  border: 1px solid #D3D3D3;\n  box-shadow: inset 0 1px 1px #F0F0F0, 0 3px 6px -5px #BBB;\n}\n.bk-root .bk-noUi-connect {\n  background: #3FB8AF;\n  border-radius: 4px;\n  box-shadow: inset 0 0 3px rgba(51, 51, 51, 0.45);\n  -webkit-transition: background 450ms;\n  transition: background 450ms;\n}\n.bk-root .bk-noUi-draggable {\n  cursor: ew-resize;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-draggable {\n  cursor: ns-resize;\n}\n.bk-root .bk-noUi-handle {\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #FFF;\n  cursor: default;\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #EBEBEB, 0 3px 6px -3px #BBB;\n}\n.bk-root .bk-noUi-active {\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #DDD, 0 3px 6px -3px #BBB;\n}\n.bk-root .bk-noUi-handle:before,\n.bk-root .bk-noUi-handle:after {\n  content: "";\n  display: block;\n  position: absolute;\n  height: 14px;\n  width: 1px;\n  background: #E8E7E6;\n  left: 14px;\n  top: 6px;\n}\n.bk-root .bk-noUi-handle:after {\n  left: 17px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle:before,\n.bk-root .bk-noUi-vertical .bk-noUi-handle:after {\n  width: 14px;\n  height: 1px;\n  left: 6px;\n  top: 14px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle:after {\n  top: 17px;\n}\n.bk-root [disabled] .bk-noUi-connect {\n  background: #B8B8B8;\n}\n.bk-root [disabled].bk-noUi-target,\n.bk-root [disabled].bk-noUi-handle,\n.bk-root [disabled] .bk-noUi-handle {\n  cursor: not-allowed;\n}\n.bk-root .bk-noUi-pips,\n.bk-root .bk-noUi-pips * {\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .bk-noUi-pips {\n  position: absolute;\n  color: #999;\n}\n.bk-root .bk-noUi-value {\n  position: absolute;\n  white-space: nowrap;\n  text-align: center;\n}\n.bk-root .bk-noUi-value-sub {\n  color: #ccc;\n  font-size: 10px;\n}\n.bk-root .bk-noUi-marker {\n  position: absolute;\n  background: #CCC;\n}\n.bk-root .bk-noUi-marker-sub {\n  background: #AAA;\n}\n.bk-root .bk-noUi-marker-large {\n  background: #AAA;\n}\n.bk-root .bk-noUi-pips-horizontal {\n  padding: 10px 0;\n  height: 80px;\n  top: 100%;\n  left: 0;\n  width: 100%;\n}\n.bk-root .bk-noUi-value-horizontal {\n  -webkit-transform: translate3d(-50%, 50%, 0);\n  transform: translate3d(-50%, 50%, 0);\n}\n.bk-root .bk-noUi-marker-horizontal.bk-noUi-marker {\n  margin-left: -1px;\n  width: 2px;\n  height: 5px;\n}\n.bk-root .bk-noUi-marker-horizontal.bk-noUi-marker-sub {\n  height: 10px;\n}\n.bk-root .bk-noUi-marker-horizontal.bk-noUi-marker-large {\n  height: 15px;\n}\n.bk-root .bk-noUi-pips-vertical {\n  padding: 0 10px;\n  height: 100%;\n  top: 0;\n  left: 100%;\n}\n.bk-root .bk-noUi-value-vertical {\n  -webkit-transform: translate3d(0, 50%, 0);\n  transform: translate3d(0, 50%, 0);\n  padding-left: 25px;\n}\n.bk-root .bk-noUi-marker-vertical.bk-noUi-marker {\n  width: 5px;\n  height: 2px;\n  margin-top: -1px;\n}\n.bk-root .bk-noUi-marker-vertical.bk-noUi-marker-sub {\n  width: 10px;\n}\n.bk-root .bk-noUi-marker-vertical.bk-noUi-marker-large {\n  width: 15px;\n}\n.bk-root .bk-noUi-tooltip {\n  display: block;\n  position: absolute;\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #fff;\n  color: #000;\n  padding: 5px;\n  text-align: center;\n  white-space: nowrap;\n}\n.bk-root .bk-noUi-horizontal .bk-noUi-tooltip {\n  -webkit-transform: translate(-50%, 0);\n  transform: translate(-50%, 0);\n  left: 50%;\n  bottom: 120%;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-tooltip {\n  -webkit-transform: translate(0, -50%);\n  transform: translate(0, -50%);\n  top: 50%;\n  right: 120%;\n}\n.bk-root .bk-noUi-handle {\n  cursor: grab;\n  cursor: -webkit-grab;\n}\n.bk-root .bk-noUi-handle.bk-noUi-active {\n  cursor: grabbing;\n  cursor: -webkit-grabbing;\n}\n.bk-root .bk-noUi-tooltip {\n  display: none;\n  white-space: nowrap;\n}\n.bk-root .bk-noUi-handle:hover .bk-noUi-tooltip {\n  display: block;\n}\n.bk-root .bk-noUi-horizontal {\n  width: 100%;\n  height: 10px;\n}\n.bk-root .bk-noUi-horizontal.bk-noUi-target {\n  margin: 5px 0px;\n}\n.bk-root .bk-noUi-horizontal .bk-noUi-handle {\n  width: 14px;\n  height: 18px;\n  left: -7px;\n  top: -5px;\n}\n.bk-root .bk-noUi-vertical {\n  width: 10px;\n  height: 100%;\n}\n.bk-root .bk-noUi-vertical.bk-noUi-target {\n  margin: 0px 5px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle {\n  width: 18px;\n  height: 14px;\n  left: -5px;\n  top: -7px;\n}\n.bk-root .bk-noUi-handle:after,\n.bk-root .bk-noUi-handle:before {\n  display: none;\n}\n.bk-root .bk-noUi-connect {\n  box-shadow: none;\n}\n')},
496: function _(t,e,i){var r=t(113),n=t(252),a=t(492),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e}(a.AbstractSliderView);i.DateSliderView=_,_.__name__="DateSliderView";var o=function(t){function e(e){var i=t.call(this,e)||this;return i.behaviour="tap",i.connected=[!0,!1],i}return r.__extends(e,t),e.init_DateSlider=function(){this.prototype.default_view=_,this.override({format:"%d %b %Y"})},e.prototype._formatter=function(t,e){return n(t,e)},e}(a.AbstractSlider);i.DateSlider=o,o.__name__="DateSlider",o.init_DateSlider()},
497: function _(t,e,i){var n=t(113),r=t(498),_=t(121),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.model.render_as_text?this.markup_el.textContent=this.model.text:this.markup_el.innerHTML=this.model.text},e}(r.MarkupView);i.DivView=o,o.__name__="DivView";var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Div=function(){this.prototype.default_view=o,this.define({render_as_text:[_.Boolean,!1]})},e}(r.Markup);i.Div=u,u.__name__="Div",u.init_Div()},
498: function _(t,i,n){var e=t(113),s=t(282),o=t(163),r=t(121),a=t(534),l=t(499),u=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(i,t),i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){i.render(),i.root.compute_layout()})},i.prototype._update_layout=function(){this.layout=new s.VariadicBox(this.el),this.layout.set_sizing(this.box_sizing())},i.prototype.render=function(){t.prototype.render.call(this);var i=Object.assign(Object.assign({},this.model.style),{display:"inline-block"});this.markup_el=o.div({class:l.bk_clearfix,style:i}),this.el.appendChild(this.markup_el)},i}(a.WidgetView);n.MarkupView=u,u.__name__="MarkupView";var c=function(t){function i(i){return t.call(this,i)||this}return e.__extends(i,t),i.init_Markup=function(){this.define({text:[r.String,""],style:[r.Any,{}]})},i}(a.Widget);n.Markup=c,c.__name__="Markup",c.init_Markup()},
499: function _(e,n,r){e(164),e(163).styles.append('.bk-root .bk-clearfix:before,\n.bk-root .bk-clearfix:after {\n  content: "";\n  display: table;\n}\n.bk-root .bk-clearfix:after {\n  clear: both;\n}\n'),r.bk_clearfix="bk-clearfix"},
500: function _(e,t,i){var n=e(113),o=e(474),l=e(376),s=e(163),r=e(121),u=e(109),d=e(240),a=e(347),c=e(348),_=function(e){function t(){var t=e.apply(this,arguments)||this;return t._open=!1,t}return n.__extends(t,e),t.prototype.render=function(){var t=this;e.prototype.render.call(this);var i=s.div({class:[c.bk_caret,d.bk_down]});if(this.model.is_split){var n=this._render_button(i);n.classList.add(a.bk_dropdown_toggle),n.addEventListener("click",function(){return t._toggle_menu()}),this.group_el.appendChild(n)}else this.button_el.appendChild(i);var o=this.model.menu.map(function(e,i){if(null==e)return s.div({class:c.bk_divider});var n=u.isString(e)?e:e[0],o=s.div({},n);return o.addEventListener("click",function(){return t._item_click(i)}),o});this.menu=s.div({class:[c.bk_menu,d.bk_below]},o),this.el.appendChild(this.menu),s.undisplay(this.menu)},t.prototype._show_menu=function(){var e=this;if(!this._open){this._open=!0,s.display(this.menu);var t=function(i){var n=i.target;n instanceof HTMLElement&&!e.el.contains(n)&&(document.removeEventListener("click",t),e._hide_menu())};document.addEventListener("click",t)}},t.prototype._hide_menu=function(){this._open&&(this._open=!1,s.undisplay(this.menu))},t.prototype._toggle_menu=function(){this._open?this._hide_menu():this._show_menu()},t.prototype.click=function(){this.model.is_split?(this._hide_menu(),this.model.trigger_event(new l.ButtonClick),this.model.value=this.model.default_value,null!=this.model.callback&&this.model.callback.execute(this.model),e.prototype.click.call(this)):this._toggle_menu()},t.prototype._item_click=function(e){this._hide_menu();var t=this.model.menu[e];if(null!=t){var i=u.isString(t)?t:t[1];u.isString(i)?(this.model.trigger_event(new l.MenuItemClick(i)),this.model.value=i,null!=this.model.callback&&this.model.callback.execute(this.model)):(i.execute(this.model,{index:e}),null!=this.model.callback&&this.model.callback.execute(this.model))}},t}(o.AbstractButtonView);i.DropdownView=_,_.__name__="DropdownView";var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Dropdown=function(){this.prototype.default_view=_,this.define({split:[r.Boolean,!1],menu:[r.Array,[]],value:[r.String],default_value:[r.String]}),this.override({label:"Dropdown"})},Object.defineProperty(t.prototype,"is_split",{get:function(){return this.split||null!=this.default_value},enumerable:!0,configurable:!0}),t}(o.AbstractButton);i.Dropdown=h,h.__name__="Dropdown",h.init_Dropdown()},
501: function _(t,e,i){var n=t(113),l=t(121),o=t(534),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()}),this.connect(this.model.properties.width.change,function(){return e.render()})},e.prototype.render=function(){var t=this;this.dialogEl||(this.dialogEl=document.createElement("input"),this.dialogEl.type="file",this.dialogEl.multiple=!1,null!=this.model.accept&&""!=this.model.accept&&(this.dialogEl.accept=this.model.accept),this.dialogEl.style.width="{this.model.width}px",this.dialogEl.onchange=function(e){return t.load_file(e)},this.el.appendChild(this.dialogEl))},e.prototype.load_file=function(t){var e=this,i=new FileReader;this.model.filename=t.target.files[0].name,i.onload=function(t){return e.file(t)},i.readAsDataURL(t.target.files[0])},e.prototype.file=function(t){var e=t.target.result.split(","),i=e[1],n=e[0].split(":")[1].split(";")[0];this.model.value=i,this.model.mime_type=n},e}(o.WidgetView);i.FileInputView=a,a.__name__="FileInputView";var r=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_FileInput=function(){this.prototype.default_view=a,this.define({value:[l.String,""],mime_type:[l.String,""],filename:[l.String,""],accept:[l.String,""]})},e}(o.Widget);i.FileInput=r,r.__name__="FileInput",r.init_FileInput()},
502: function _(e,t,n){var i=e(113),r=e(163),l=e(109),o=e(117),s=e(121),c=e(480),u=e(481),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.value.change,function(){return t.render_selection()}),this.connect(this.model.properties.options.change,function(){return t.render()}),this.connect(this.model.properties.name.change,function(){return t.render()}),this.connect(this.model.properties.title.change,function(){return t.render()}),this.connect(this.model.properties.size.change,function(){return t.render()}),this.connect(this.model.properties.disabled.change,function(){return t.render()})},t.prototype.render=function(){var t=this;e.prototype.render.call(this);var n=this.model.options.map(function(e){var t,n;return l.isString(e)?t=n=e:(t=e[0],n=e[1]),r.option({value:t},n)});this.select_el=r.select({multiple:!0,class:u.bk_input,name:this.model.name,disabled:this.model.disabled},n),this.select_el.addEventListener("change",function(){return t.change_input()}),this.group_el.appendChild(this.select_el),this.render_selection()},t.prototype.render_selection=function(){for(var e=new o.Set(this.model.value),t=0,n=Array.from(this.el.querySelectorAll("option"));t<n.length;t++){var i=n[t];i.selected=e.has(i.value)}this.select_el.size=this.model.size},t.prototype.change_input=function(){for(var t=null!=this.el.querySelector("select:focus"),n=[],i=0,r=Array.from(this.el.querySelectorAll("option"));i<r.length;i++){var l=r[i];l.selected&&n.push(l.value)}this.model.value=n,e.prototype.change_input.call(this),t&&this.select_el.focus()},t}(c.InputWidgetView);n.MultiSelectView=h,h.__name__="MultiSelectView";var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_MultiSelect=function(){this.prototype.default_view=h,this.define({value:[s.Array,[]],options:[s.Array,[]],size:[s.Number,4]})},t}(c.InputWidget);n.MultiSelect=a,a.__name__="MultiSelect",a.init_MultiSelect()},
503: function _(r,t,a){var n=r(113),e=r(498),i=r(163),p=function(r){function t(){return null!==r&&r.apply(this,arguments)||this}return n.__extends(t,r),t.prototype.render=function(){r.prototype.render.call(this);var t=i.p({style:{margin:0}},this.model.text);this.markup_el.appendChild(t)},t}(e.MarkupView);a.ParagraphView=p,p.__name__="ParagraphView";var _=function(r){function t(t){return r.call(this,t)||this}return n.__extends(t,r),t.init_Paragraph=function(){this.prototype.default_view=p},t}(e.Markup);a.Paragraph=_,_.__name__="Paragraph",_.init_Paragraph()},
504: function _(t,n,e){var r=t(113),i=t(479),s=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n.prototype.render=function(){t.prototype.render.call(this),this.input_el.type="password"},n}(i.TextInputView);e.PasswordInputView=s,s.__name__="PasswordInputView";var u=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.init_PasswordInput=function(){this.prototype.default_view=s},n}(i.TextInput);e.PasswordInput=u,u.__name__="PasswordInput",u.init_PasswordInput()},
505: function _(e,t,r){var n=e(113),i=e(498),o=e(163),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.render=function(){e.prototype.render.call(this);var t=o.pre({style:{overflow:"auto"}},this.model.text);this.markup_el.appendChild(t)},t}(i.MarkupView);r.PreTextView=u,u.__name__="PreTextView";var _=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_PreText=function(){this.prototype.default_view=u},t}(i.Markup);r.PreText=_,_.__name__="PreText",_.init_PreText()},
506: function _(t,o,i){var n=t(113),e=t(484),u=t(163),a=t(121),c=t(240),r=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(o,t),o.prototype.change_active=function(t){this.model.active!==t&&(this.model.active=t,null!=this.model.callback&&this.model.callback.execute(this.model))},o.prototype._update_active=function(){var t=this.model.active;this._buttons.forEach(function(o,i){u.classes(o).toggle(c.bk_active,t===i)})},o}(e.ButtonGroupView);i.RadioButtonGroupView=r,r.__name__="RadioButtonGroupView";var l=function(t){function o(o){return t.call(this,o)||this}return n.__extends(o,t),o.init_RadioButtonGroup=function(){this.prototype.default_view=r,this.define({active:[a.Any,null]})},o}(e.ButtonGroup);i.RadioButtonGroup=l,l.__name__="RadioButtonGroup",l.init_RadioButtonGroup()},
507: function _(e,i,n){var t=e(113),a=e(163),o=e(127),l=e(121),r=e(486),u=e(240),d=e(481),c=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return t.__extends(i,e),i.prototype.render=function(){var i=this;e.prototype.render.call(this);var n=a.div({class:[d.bk_input_group,this.model.inline?u.bk_inline:null]});this.el.appendChild(n);for(var t=o.uniqueId(),l=this.model,r=l.active,c=l.labels,p=function(e){var o=a.input({type:"radio",name:t,value:""+e});o.addEventListener("change",function(){return i.change_active(e)}),s.model.disabled&&(o.disabled=!0),e==r&&(o.checked=!0);var l=a.label({},o,a.span({},c[e]));n.appendChild(l)},s=this,h=0;h<c.length;h++)p(h)},i.prototype.change_active=function(e){this.model.active=e,null!=this.model.callback&&this.model.callback.execute(this.model)},i}(r.InputGroupView);n.RadioGroupView=c,c.__name__="RadioGroupView";var p=function(e){function i(i){return e.call(this,i)||this}return t.__extends(i,e),i.init_RadioGroup=function(){this.prototype.default_view=c,this.define({active:[l.Number],labels:[l.Array,[]],inline:[l.Boolean,!1],callback:[l.Any]})},i}(r.InputGroup);n.RadioGroup=p,p.__name__="RadioGroup",p.init_RadioGroup()},
508: function _(e,t,n){var r=e(113),i=e(255),a=e(492),o=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t}(a.AbstractRangeSliderView);n.RangeSliderView=o,o.__name__="RangeSliderView";var _=function(e){function t(t){var n=e.call(this,t)||this;return n.behaviour="drag",n.connected=[!1,!0,!1],n}return r.__extends(t,e),t.init_RangeSlider=function(){this.prototype.default_view=o,this.override({format:"0[.]00"})},t.prototype._formatter=function(e,t){return i.format(e,t)},t}(a.AbstractSlider);n.RangeSlider=_,_.__name__="RangeSlider",_.init_RangeSlider()},
509: function _(t,e,i){var n=t(113),o=t(163),l=t(109),s=t(167),r=t(121),a=t(480),c=t(481),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()})},e.prototype.build_options=function(t){var e=this;return t.map(function(t){var i,n;l.isString(t)?i=n=t:(i=t[0],n=t[1]);var s=e.model.value==i;return o.option({selected:s,value:i},n)})},e.prototype.render=function(){var e,i=this;if(t.prototype.render.call(this),l.isArray(this.model.options))e=this.build_options(this.model.options);else{e=[];var n=this.model.options;for(var s in n){var r=n[s];e.push(o.optgroup({label:s},this.build_options(r)))}}this.select_el=o.select({class:c.bk_input,id:this.model.id,name:this.model.name,disabled:this.model.disabled},e),this.select_el.addEventListener("change",function(){return i.change_input()}),this.group_el.appendChild(this.select_el)},e.prototype.change_input=function(){var e=this.select_el.value;s.logger.debug("selectbox: value = "+e),this.model.value=e,t.prototype.change_input.call(this)},e}(a.InputWidgetView);i.SelectView=u,u.__name__="SelectView";var p=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Select=function(){this.prototype.default_view=u,this.define({value:[r.String,""],options:[r.Any,[]]})},e}(a.InputWidget);i.Select=p,p.__name__="Select",p.init_Select()},
510: function _(t,e,r){var i=t(113),n=t(255),o=t(492),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e}(o.AbstractSliderView);r.SliderView=_,_.__name__="SliderView";var a=function(t){function e(e){var r=t.call(this,e)||this;return r.behaviour="tap",r.connected=[!0,!1],r}return i.__extends(e,t),e.init_Slider=function(){this.prototype.default_view=_,this.override({format:"0[.]00"})},e.prototype._formatter=function(t,e){return n.format(t,e)},e}(o.AbstractSlider);r.Slider=a,a.__name__="Slider",a.init_Slider()},
511: function _(e,t,n){var i=e(113),l=e(480),o=e(163),s=e(121),h=e(481),p=Math.floor,u=Math.max,r=Math.min;function a(e){return p(e)!==e?e.toString().replace("/0+$/","").split(".")[1].length:0}var d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.low.change,function(){var e=t.model.low;null!=e&&(t.input_el.min=e.toFixed(16))}),this.connect(this.model.properties.high.change,function(){var e=t.model.high;null!=e&&(t.input_el.max=e.toFixed(16))}),this.connect(this.model.properties.step.change,function(){var e=t.model.step;t.input_el.step=e.toFixed(16)}),this.connect(this.model.properties.value.change,function(){var e=t.model,n=e.value,i=e.step;t.input_el.value=n.toFixed(a(i)).replace(/(\.[0-9]*[1-9])0+$|\.0*$/,"$1")}),this.connect(this.model.properties.disabled.change,function(){t.input_el.disabled=t.model.disabled})},t.prototype.render=function(){var t=this;e.prototype.render.call(this),this.input_el=o.input({type:"number",class:h.bk_input,name:this.model.name,min:this.model.low,max:this.model.high,value:this.model.value,step:this.model.step,disabled:this.model.disabled}),this.input_el.addEventListener("change",function(){return t.change_input()}),this.group_el.appendChild(this.input_el)},t.prototype.change_input=function(){if(this.input_el.value){var t=this.model.step,n=Number(this.input_el.value);null!=this.model.low&&(n=u(n,this.model.low)),null!=this.model.high&&(n=r(n,this.model.high)),this.model.value=Number(n.toFixed(a(t))),e.prototype.change_input.call(this)}},t}(l.InputWidgetView);n.SpinnerView=d,d.__name__="SpinnerView";var c=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Spinner=function(){this.prototype.default_view=d,this.define({value:[s.Number,0],low:[s.Number,null],high:[s.Number,null],step:[s.Number,1]})},t}(l.InputWidget);n.Spinner=c,c.__name__="Spinner",c.init_Spinner()},
512: function _(e,t,n){var i=e(113),o=e(479),l=e(480),r=e(163),s=e(121),u=e(481),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,function(){return t.input_el.name=t.model.name||""}),this.connect(this.model.properties.value.change,function(){return t.input_el.value=t.model.value}),this.connect(this.model.properties.disabled.change,function(){return t.input_el.disabled=t.model.disabled}),this.connect(this.model.properties.placeholder.change,function(){return t.input_el.placeholder=t.model.placeholder}),this.connect(this.model.properties.rows.change,function(){return t.input_el.rows=t.model.rows}),this.connect(this.model.properties.cols.change,function(){return t.input_el.cols=t.model.cols}),this.connect(this.model.properties.max_length.change,function(){return t.input_el.maxLength=t.model.max_length})},t.prototype.render=function(){var t=this;e.prototype.render.call(this),this.input_el=r.textarea({class:u.bk_input,name:this.model.name,disabled:this.model.disabled,placeholder:this.model.placeholder,cols:this.model.cols,rows:this.model.rows,maxLength:this.model.max_length}),this.input_el.textContent=this.model.value,this.input_el.addEventListener("change",function(){return t.change_input()}),this.group_el.appendChild(this.input_el)},t.prototype.change_input=function(){this.model.value=this.input_el.value,e.prototype.change_input.call(this)},t}(l.InputWidgetView);n.TextAreaInputView=a,a.__name__="TextAreaInputView";var c=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_TextAreaInput=function(){this.prototype.default_view=a,this.define({cols:[s.Number,20],rows:[s.Number,2],max_length:[s.Number,500]})},t}(o.TextInput);n.TextAreaInput=c,c.__name__="TextAreaInput",c.init_TextAreaInput()},
513: function _(t,e,i){var n=t(113),o=t(474),c=t(163),l=t(121),a=t(240),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){return e._update_active()})},e.prototype.render=function(){t.prototype.render.call(this),this._update_active()},e.prototype.click=function(){this.model.active=!this.model.active,t.prototype.click.call(this)},e.prototype._update_active=function(){c.classes(this.button_el).toggle(a.bk_active,this.model.active)},e}(o.AbstractButtonView);i.ToggleView=r,r.__name__="ToggleView";var s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Toggle=function(){this.prototype.default_view=r,this.define({active:[l.Boolean,!1]}),this.override({label:"Toggle"})},e}(o.AbstractButton);i.Toggle=s,s.__name__="Toggle",s.init_Toggle()},
}, 472, {"models/widgets/main":472,"models/widgets/index":473,"models/widgets/abstract_button":474,"models/widgets/control":475,"models/widgets/widget":534,"models/widgets/abstract_icon":477,"models/widgets/autocomplete_input":478,"models/widgets/text_input":479,"models/widgets/input_widget":480,"styles/widgets/inputs":481,"models/widgets/button":482,"models/widgets/checkbox_button_group":483,"models/widgets/button_group":484,"models/widgets/checkbox_group":485,"models/widgets/input_group":486,"models/widgets/color_picker":487,"models/widgets/date_picker":488,"styles/widgets/pikaday":490,"models/widgets/date_range_slider":491,"models/widgets/abstract_slider":492,"styles/widgets/sliders":494,"styles/widgets/nouislider":495,"models/widgets/date_slider":496,"models/widgets/div":497,"models/widgets/markup":498,"styles/clearfix":499,"models/widgets/dropdown":500,"models/widgets/file_input":501,"models/widgets/multiselect":502,"models/widgets/paragraph":503,"models/widgets/password_input":504,"models/widgets/pretext":505,"models/widgets/radio_button_group":506,"models/widgets/radio_group":507,"models/widgets/range_slider":508,"models/widgets/selectbox":509,"models/widgets/slider":510,"models/widgets/spinner":511,"models/widgets/textarea_input":512,"models/widgets/toggle":513}, {});
})

//# sourceMappingURL=bokeh-widgets.min.js.map
