/*!
 * Copyright (c) 2012 - 2019, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  root["Bokeh"] = factory();
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (parent_require && externals[id]) {
              try {
                mod = {exports: parent_require(id)};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;
          modules[id].call(mod.exports, require, mod, mod.exports);
        } else
          cache[name] = mod;
      }

      return mod.exports;
    }

    var main = require(entry);
    main.require = require;

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
function _(n,o,r){!function(n){for(var o in n)r.hasOwnProperty(o)||(r[o]=n[o])}(n(1))},
function _(e,s,o){var t=e(2);o.version=t.version;const n=e(3);o.embed=n;var l=e(3);o.index=l.index;const r=e(348);o.protocol=r;const v=e(349);o._testing=v;var a=e(65);o.logger=a.logger,o.set_log_level=a.set_log_level;var g=e(26);o.settings=g.settings;var i=e(6);o.Models=i.Models;var c=e(4);o.documents=c.documents;var d=e(350);o.safely=d.safely},
function _(n,i,o){o.version="1.4.0"},
function _(e,o,n){const s=e(4),d=e(65),t=e(16),r=e(25),i=e(7),_=e(339),c=e(341),l=e(340);var m=e(339);n.add_document_standalone=m.add_document_standalone,n.index=m.index;var u=e(341);n.add_document_from_session=u.add_document_from_session;var a=e(346);n.embed_items_notebook=a.embed_items_notebook,n.kernels=a.kernels;var f=e(340);function g(e,o,n,t){i.isString(e)&&(e=JSON.parse(r.unescape(e)));const m={};for(const o in e){const n=e[o];m[o]=s.Document.from_json(n)}for(const e of o){const o=l._resolve_element(e),s=l._resolve_root_elements(e);if(null!=e.docid)_.add_document_standalone(m[e.docid],o,s,e.use_for_title);else{if(null==e.sessionid)throw new Error("Error rendering Bokeh items: either 'docid' or 'sessionid' was expected.");{const r=c._get_ws_url(n,t);d.logger.debug(`embed: computed ws url: ${r}`),c.add_document_from_session(r,e.sessionid,o,s,e.use_for_title).then(()=>{console.log("Bokeh items were rendered successfully")},e=>{console.log("Error rendering Bokeh items:",e)})}}}}n.BOKEH_ROOT=f.BOKEH_ROOT,n.embed_item=function(e,o){const n={},s=r.uuid4();n[s]=e.doc,null==o&&(o=e.target_id);const d=document.getElementById(o);null!=d&&d.classList.add(l.BOKEH_ROOT);const i={roots:{[e.root_id]:o},docid:s};t.defer(()=>g(n,[i]))},n.embed_items=function(e,o,n,s){t.defer(()=>g(e,o,n,s))}},
function _(n,o,r){function f(n){for(var o in n)r.hasOwnProperty(o)||(r[o]=n[o])}f(n(5)),f(n(97))},
function _(e,t,o){const n=e(6),s=e(2),i=e(65),r=e(274),_=e(12),l=e(13),a=e(24),c=e(94),d=e(14),h=e(8),u=e(22),f=e(15),m=e(7),v=e(237),g=e(68),p=e(64),w=e(97);class b{constructor(e){this.document=e,this.session=null,this.subscribed_models=new d.Set}send_event(e){null!=this.session&&this.session.send_event(e)}trigger(e){for(const t of this.subscribed_models.values){if(null!=e.origin&&e.origin.id!==t)continue;const o=this.document._all_models[t];null!=o&&o instanceof p.Model&&o._process_event(e)}}}o.EventManager=b,b.__name__="EventManager",o.documents=[],o.DEFAULT_TITLE="Bokeh Application";class y{constructor(){o.documents.push(this),this._init_timestamp=Date.now(),this._title=o.DEFAULT_TITLE,this._roots=[],this._all_models={},this._all_models_by_name=new d.MultiDict,this._all_models_freeze_count=0,this._callbacks=[],this.event_manager=new b(this),this.idle=new l.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}get layoutables(){return this._roots.filter(e=>e instanceof v.LayoutDOM)}get is_idle(){for(const e of this.layoutables)if(!this._idle_roots.has(e))return!1;return!0}notify_idle(e){this._idle_roots.set(e,!0),this.is_idle&&(i.logger.info(`document idle at ${Date.now()-this._init_timestamp} ms`),this.idle.emit())}clear(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}}interactive_start(e){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new r.LODStart)),this._interactive_timestamp=Date.now()}interactive_stop(e){null!=this._interactive_plot&&this._interactive_plot.id===e.id&&this._interactive_plot.trigger_event(new r.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null}interactive_duration(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp}destructively_move(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();const t=h.copy(this._roots);this.clear();for(const e of t)if(null!=e.document)throw new Error(`Somehow we didn't detach ${e}`);if(0!==Object.keys(this._all_models).length)throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);for(const o of t)e.add_root(o);e.set_title(this._title)}_push_all_models_freeze(){this._all_models_freeze_count+=1}_pop_all_models_freeze(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()}_invalidate_all_models(){i.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()}_recompute_all_models(){let e=new d.Set;for(const t of this._roots)e=e.union(t.references());const t=new d.Set(u.values(this._all_models)),o=t.diff(e),n=e.diff(t),s={};for(const t of e.values)s[t.id]=t;for(const e of o.values)e.detach_document(),e instanceof p.Model&&null!=e.name&&this._all_models_by_name.remove_value(e.name,e);for(const e of n.values)e.attach_document(this),e instanceof p.Model&&null!=e.name&&this._all_models_by_name.add_value(e.name,e);this._all_models=s}roots(){return this._roots}add_root(e,t){if(i.logger.debug(`Adding root: ${e}`),!h.includes(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new w.RootAddedEvent(this,e,t))}}remove_root(e,t){const o=this._roots.indexOf(e);if(!(o<0)){this._push_all_models_freeze();try{this._roots.splice(o,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new w.RootRemovedEvent(this,e,t))}}title(){return this._title}set_title(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new w.TitleChangedEvent(this,e,t)))}get_model_by_id(e){return e in this._all_models?this._all_models[e]:null}get_model_by_name(e){return this._all_models_by_name.get_one(e,`Multiple models are named '${e}'`)}on_change(e){h.includes(this._callbacks,e)||this._callbacks.push(e)}remove_on_change(e){const t=this._callbacks.indexOf(e);t>=0&&this._callbacks.splice(t,1)}_trigger_on_change(e){for(const t of this._callbacks)t(e)}_notify_change(e,t,o,n,s){"name"===t&&(this._all_models_by_name.remove_value(o,e),null!=n&&this._all_models_by_name.add_value(n,e));const i=null!=s?s.setter_id:void 0,r=null!=s?s.hint:void 0;this._trigger_on_change(new w.ModelChangedEvent(this,e,t,o,n,i,r))}static _references_json(e,t=!0){const o=[];for(const n of e){const e=n.ref();e.attributes=n.attributes_as_json(t),delete e.attributes.id,o.push(e)}return o}static _instantiate_object(e,t,o){const s=Object.assign(Object.assign({},o),{id:e,__deferred__:!0});return new(n.Models(t))(s)}static _instantiate_references_json(e,t){const o={};for(const n of e){const e=n.id,s=n.type,i=n.attributes||{};let r;e in t?r=t[e]:(r=y._instantiate_object(e,s,i),null!=n.subtype&&r.set_subtype(n.subtype)),o[r.id]=r}return o}static _resolve_refs(e,t,o){function n(e){if(a.is_ref(e)){if(e.id in t)return t[e.id];if(e.id in o)return o[e.id];throw new Error(`reference ${JSON.stringify(e)} isn't known (not in Document?)`)}return m.isArray(e)?function(e){const t=[];for(const o of e)t.push(n(o));return t}(e):m.isPlainObject(e)?function(e){const t={};for(const o in e){const s=e[o];t[o]=n(s)}return t}(e):e}return n(e)}static _initialize_references_json(e,t,o){const n={};for(const s of e){const e=s.id,i=s.attributes,r=!(e in t),_=r?o[e]:t[e],l=y._resolve_refs(i,t,o);n[_.id]=[_,l,r]}function s(e,t){const o={};function n(s){if(s instanceof _.HasProps){if(!(s.id in o)&&s.id in e){o[s.id]=!0;const[,i,r]=e[s.id];for(const e in i){n(i[e])}t(s,i,r)}}else if(m.isArray(s))for(const e of s)n(e);else if(m.isPlainObject(s))for(const e in s){n(s[e])}}for(const t in e){const[o,,]=e[t];n(o)}}s(n,function(e,t,o){o&&e.setv(t,{silent:!0})}),s(n,function(e,t,o){o&&e.finalize()})}static _event_for_attribute_change(e,t,o,n,s){if(n.get_model_by_id(e.id).attribute_is_serializable(t)){const i={kind:"ModelChanged",model:{id:e.id,type:e.type},attr:t,new:o};return _.HasProps._json_record_references(n,o,s,!0),i}return null}static _events_to_sync_objects(e,t,o,n){const s=Object.keys(e.attributes),r=Object.keys(t.attributes),_=h.difference(s,r),l=h.difference(r,s),a=h.intersection(s,r),c=[];for(const e of _)i.logger.warn(`Server sent key ${e} but we don't seem to have it in our JSON`);for(const s of l){const i=t.attributes[s];c.push(y._event_for_attribute_change(e,s,i,o,n))}for(const s of a){const i=e.attributes[s],r=t.attributes[s];null==i&&null==r||(null==i||null==r?c.push(y._event_for_attribute_change(e,s,r,o,n)):f.isEqual(i,r)||c.push(y._event_for_attribute_change(e,s,r,o,n)))}return c.filter(e=>null!=e)}static _compute_patch_since_json(e,t){const o=t.to_json(!1);function n(e){const t={};for(const o of e.roots.references)t[o.id]=o;return t}const s=n(e),i={},r=[];for(const t of e.roots.root_ids)i[t]=s[t],r.push(t);const _=n(o),l={},a=[];for(const e of o.roots.root_ids)l[e]=_[e],a.push(e);if(r.sort(),a.sort(),h.difference(r,a).length>0||h.difference(a,r).length>0)throw new Error("Not implemented: computing add/remove of document roots");const c={};let d=[];for(const e in t._all_models)if(e in s){const o=y._events_to_sync_objects(s[e],_[e],t,c);d=d.concat(o)}return{references:y._references_json(u.values(c),!1),events:d}}to_json_string(e=!0){return JSON.stringify(this.to_json(e))}to_json(e=!0){const t=this._roots.map(e=>e.id),o=u.values(this._all_models);return{version:s.version,title:this._title,roots:{root_ids:t,references:y._references_json(o,e)}}}static from_json_string(e){const t=JSON.parse(e);return y.from_json(t)}static from_json(e){i.logger.debug("Creating Document from JSON");const t=e.version,o=-1!==t.indexOf("+")||-1!==t.indexOf("-"),n=`Library versions: JS (${s.version}) / Python (${t})`;o||s.version===t?i.logger.debug(n):(i.logger.warn("JS/Python version mismatch"),i.logger.warn(n));const r=e.roots,_=r.root_ids,l=r.references,a=y._instantiate_references_json(l,{});y._initialize_references_json(l,{},a);const c=new y;for(const e of _)c.add_root(a[e]);return c.set_title(e.title),c}replace_with_json(e){y.from_json(e).destructively_move(this)}create_json_patch_string(e){return JSON.stringify(this.create_json_patch(e))}create_json_patch(e){const t={},o=[];for(const n of e){if(n.document!==this)throw i.logger.warn("Cannot create a patch using events from a different document, event had ",n.document," we are ",this),new Error("Cannot create a patch using events from a different document");o.push(n.json(t))}return{events:o,references:y._references_json(u.values(t))}}apply_json_patch(e,t=[],o){const n=e.references,s=e.events,r=y._instantiate_references_json(n,this._all_models);for(const e of s)switch(e.kind){case"RootAdded":case"RootRemoved":case"ModelChanged":{const t=e.model.id;if(t in this._all_models)r[t]=this._all_models[t];else if(!(t in r))throw i.logger.warn("Got an event for unknown model ",e.model),new Error("event model wasn't known");break}}const _={},l={};for(const e in r){const t=r[e];e in this._all_models?_[e]=t:l[e]=t}y._initialize_references_json(n,_,l);for(const e of s)switch(e.kind){case"ModelChanged":{const n=e.model.id;if(!(n in this._all_models))throw new Error(`Cannot apply patch to ${n} which is not in the document`);const s=this._all_models[n],i=e.attr,r=e.model.type;if("data"===i&&"ColumnDataSource"===r){const[n,i]=c.decode_column_data(e.new,t);s.setv({_shapes:i,data:n},{setter_id:o})}else{const t=y._resolve_refs(e.new,_,l);s.setv({[i]:t},{setter_id:o})}break}case"ColumnDataChanged":{const n=e.column_source.id;if(!(n in this._all_models))throw new Error(`Cannot stream to ${n} which is not in the document`);const s=this._all_models[n],[i,r]=c.decode_column_data(e.new,t);if(null!=e.cols){for(const e in s.data)e in i||(i[e]=s.data[e]);for(const e in s._shapes)e in r||(r[e]=s._shapes[e])}s.setv({_shapes:r,data:i},{setter_id:o,check_eq:!1});break}case"ColumnsStreamed":{const t=e.column_source.id;if(!(t in this._all_models))throw new Error(`Cannot stream to ${t} which is not in the document`);const n=this._all_models[t];if(!(n instanceof g.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");const s=e.data,i=e.rollover;n.stream(s,i,o);break}case"ColumnsPatched":{const t=e.column_source.id;if(!(t in this._all_models))throw new Error(`Cannot patch ${t} which is not in the document`);const n=this._all_models[t];if(!(n instanceof g.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");const s=e.patches;n.patch(s,o);break}case"RootAdded":{const t=r[e.model.id];this.add_root(t,o);break}case"RootRemoved":{const t=r[e.model.id];this.remove_root(t,o);break}case"TitleChanged":this.set_title(e.title,o);break;default:throw new Error("Unknown patch event "+JSON.stringify(e))}}}o.Document=y,y.__name__="Document"},
function _(e,s,r){const o=e(7),t=e(12);r.overrides={};const i=new Map;function n(e){return o.isObject(e)&&e.prototype instanceof t.HasProps}r.Models=(e=>{const s=r.overrides[e]||i.get(e);if(null==s)throw new Error(`Model '${e}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`);return s}),r.Models.register=((e,s)=>{r.overrides[e]=s}),r.Models.unregister=(e=>{delete r.overrides[e]}),r.Models.register_models=((e,s=!1,r)=>{if(null!=e)for(const o in e){const t=e[o];if(n(t)){const e=t.__qualified__;s||!i.has(e)?i.set(e,t):null!=r?r(e):console.warn(`Model '${e}' was already registered`)}}}),r.register_models=r.Models.register_models,r.Models.registered_names=(()=>Array.from(i.keys()));const d=e(27);r.register_models(d)},
function _(n,t,r){const e=n(8),i=Object.prototype.toString;function o(n){return"[object Number]"===i.call(n)}function c(n){const t=typeof n;return"function"===t||"object"===t&&!!n}r.isBoolean=function(n){return!0===n||!1===n||"[object Boolean]"===i.call(n)},r.isNumber=o,r.isInteger=function(n){return o(n)&&isFinite(n)&&Math.floor(n)===n},r.isString=function(n){return"[object String]"===i.call(n)},r.isStrictNaN=function(n){return o(n)&&n!==+n},r.isFunction=function(n){return"[object Function]"===i.call(n)},r.isArray=function(n){return Array.isArray(n)},r.isArrayOf=function(n,t){return e.every(n,t)},r.isArrayableOf=function(n,t){for(let r=0,e=n.length;r<e;r++)if(!t(n[r]))return!1;return!0},r.isTypedArray=function(n){return null!=n&&n.buffer instanceof ArrayBuffer},r.isObject=c,r.isPlainObject=function(n){return c(n)&&(null==n.constructor||n.constructor===Object)}},
function _(n,t,e){const r=n(9),o=n(10),i=n(11);e.map=i.map,e.reduce=i.reduce,e.min=i.min,e.min_by=i.min_by,e.max=i.max,e.max_by=i.max_by,e.sum=i.sum,e.cumsum=i.cumsum,e.every=i.every,e.some=i.some,e.find=i.find,e.find_last=i.find_last,e.find_index=i.find_index,e.find_last_index=i.find_last_index,e.sorted_index=i.sorted_index;const u=Array.prototype.slice;function c(n){return u.call(n)}function f(n){return[].concat(...n)}function s(n,t){return-1!==n.indexOf(t)}function a(n,t,e=1){o.assert(e>0,"'step' must be a positive number"),null==t&&(t=n,n=0);const{max:r,ceil:i,abs:u}=Math,c=n<=t?e:-e,f=r(i(u(t-n)/e),0),s=Array(f);for(let t=0;t<f;t++,n+=c)s[t]=n;return s}function l(n){const t=[];for(const e of n)s(t,e)||t.push(e);return t}e.head=function(n){return n[0]},e.tail=function(n){return n[n.length-1]},e.last=function(n){return n[n.length-1]},e.copy=c,e.concat=f,e.includes=s,e.contains=s,e.nth=function(n,t){return n[t>=0?t:n.length+t]},e.zip=function(...n){if(0==n.length)return[];const t=i.min(n.map(n=>n.length)),e=n.length,r=new Array(t);for(let o=0;o<t;o++){r[o]=new Array(e);for(let t=0;t<e;t++)r[o][t]=n[t][o]}return r},e.unzip=function(n){const t=n.length,e=i.min(n.map(n=>n.length)),r=Array(e);for(let n=0;n<e;n++)r[n]=new Array(t);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r[t][o]=n[o][t];return r},e.range=a,e.linspace=function(n,t,e=100){const r=(t-n)/(e-1),o=new Array(e);for(let t=0;t<e;t++)o[t]=n+r*t;return o},e.transpose=function(n){const t=n.length,e=n[0].length,r=[];for(let o=0;o<e;o++){r[o]=[];for(let e=0;e<t;e++)r[o][e]=n[e][o]}return r},e.argmin=function(n){return i.min_by(a(n.length),t=>n[t])},e.argmax=function(n){return i.max_by(a(n.length),t=>n[t])},e.sort_by=function(n,t){const e=n.map((n,e)=>({value:n,index:e,key:t(n)}));return e.sort((n,t)=>{const e=n.key,r=t.key;if(e!==r){if(e>r||void 0===e)return 1;if(e<r||void 0===r)return-1}return n.index-t.index}),e.map(n=>n.value)},e.uniq=l,e.uniq_by=function(n,t){const e=[],r=[];for(const o of n){const n=t(o);s(r,n)||(r.push(n),e.push(o))}return e},e.union=function(...n){return l(f(n))},e.intersection=function(n,...t){const e=[];n:for(const r of n)if(!s(e,r)){for(const n of t)if(!s(n,r))continue n;e.push(r)}return e},e.difference=function(n,...t){const e=f(t);return n.filter(n=>!s(e,n))},e.remove_at=function(n,t){const e=c(n);return e.splice(t,1),e},e.remove_by=function(n,t){for(let e=0;e<n.length;)t(n[e])?n.splice(e,1):e++},e.shuffle=function(n){const t=n.length,e=new Array(t);for(let o=0;o<t;o++){const t=r.randomIn(0,o);t!==o&&(e[o]=e[t]),e[t]=n[o]}return e},e.pairwise=function(n,t){const e=n.length,r=new Array(e-1);for(let o=0;o<e-1;o++)r[o]=t(n[o],n[o+1]);return r},e.reversed=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++)e[t-r-1]=n[r];return e},e.repeat=function(n,t){const e=new Array(t);for(let r=0;r<t;r++)e[r]=n;return e}},
function _(n,t,r){function a(n){if(0==n)return 0;for(;n<=0;)n+=2*Math.PI;for(;n>2*Math.PI;)n-=2*Math.PI;return n}function o(n,t){return a(n-t)}function u(){return Math.random()}r.angle_norm=a,r.angle_dist=o,r.angle_between=function(n,t,r,u){const e=o(t,r);if(0==e)return!1;if(e==2*Math.PI)return!0;const f=a(n),i=o(t,f)<=e&&o(f,r)<=e;return 0==u?i:!i},r.random=u,r.randomIn=function(n,t){return null==t&&(t=n,n=0),n+Math.floor(Math.random()*(t-n+1))},r.atan2=function(n,t){return Math.atan2(t[1]-n[1],t[0]-n[0])},r.rnorm=function(n,t){let r,a;for(;r=u(),a=(2*(a=u())-1)*Math.sqrt(1/Math.E*2),!(-4*r*r*Math.log(r)>=a*a););let o=a/r;return o=n+t*o},r.clamp=function(n,t,r){return n>r?r:n<t?t:n}},
function _(r,s,n){class e extends Error{}n.AssertionError=e,e.__name__="AssertionError",n.assert=function(r,s){if(!(!0===r||!1!==r&&r()))throw new e(s||"Assertion failed")}},
function _(n,t,r){function e(n,t,r,...e){const o=n.length;t<0&&(t+=o),t<0?t=0:t>o&&(t=o),null==r||r>o-t?r=o-t:r<0&&(r=0);const u=o-r+e.length,i=new n.constructor(u);let f=0;for(;f<t;f++)i[f]=n[f];for(const n of e)i[f++]=n;for(let e=t+r;e<o;e++)i[f++]=n[e];return i}function o(n,t){return e(n,t,n.length-t)}function u(n,t,r){const e=n.length;if(void 0===r&&0==e)throw new Error("can't reduce an empty array without an initial value");let o,u;for(void 0===r?(o=n[0],u=1):(o=r,u=0);u<e;u++)o=t(o,n[u],u,n);return o}function i(n){return function(t,r){const e=t.length;let o=n>0?0:e-1;for(;o>=0&&o<e;o+=n)if(r(t[o]))return o;return-1}}r.splice=e,r.head=o,r.insert=function(n,t,r){return e(n,r,0,t)},r.append=function(n,t){return e(n,n.length,0,t)},r.prepend=function(n,t){return e(n,0,0,t)},r.indexOf=function(n,t){for(let r=0,e=n.length;r<e;r++)if(n[r]===t)return r;return-1},r.map=function(n,t){const r=n.length,e=new n.constructor(r);for(let o=0;o<r;o++)e[o]=t(n[o],o,n);return e},r.filter=function(n,t){const r=n.length,e=new n.constructor(r);let u=0;for(let o=0;o<r;o++){const r=n[o];t(r,o,n)&&(e[u++]=r)}return o(e,u)},r.reduce=u,r.min=function(n){let t,r=1/0;for(let e=0,o=n.length;e<o;e++)(t=n[e])<r&&(r=t);return r},r.min_by=function(n,t){if(0==n.length)throw new Error("min_by() called with an empty array");let r=n[0],e=t(r);for(let o=1,u=n.length;o<u;o++){const u=n[o],i=t(u);i<e&&(r=u,e=i)}return r},r.max=function(n){let t,r=-1/0;for(let e=0,o=n.length;e<o;e++)(t=n[e])>r&&(r=t);return r},r.max_by=function(n,t){if(0==n.length)throw new Error("max_by() called with an empty array");let r=n[0],e=t(r);for(let o=1,u=n.length;o<u;o++){const u=n[o],i=t(u);i>e&&(r=u,e=i)}return r},r.sum=function(n){let t=0;for(let r=0,e=n.length;r<e;r++)t+=n[r];return t},r.cumsum=function(n){const t=new n.constructor(n.length);return u(n,(n,r,e)=>t[e]=n+r,0),t},r.every=function(n,t){for(let r=0,e=n.length;r<e;r++)if(!t(n[r]))return!1;return!0},r.some=function(n,t){for(let r=0,e=n.length;r<e;r++)if(t(n[r]))return!0;return!1},r.index_of=function(n,t){for(let r=0,e=n.length;r<e;r++)if(n[r]===t)return r;return-1},r.find_index=i(1),r.find_last_index=i(-1),r.find=function(n,t){const e=r.find_index(n,t);return-1==e?void 0:n[e]},r.find_last=function(n,t){const e=r.find_last_index(n,t);return-1==e?void 0:n[e]},r.sorted_index=function(n,t){let r=0,e=n.length;for(;r<e;){const o=Math.floor((r+e)/2);n[o]<t?r=o+1:e=o}return r}},
function _(t,e,s){const i=t(13),n=t(17),r=t(24),o=t(18),c=t(25),a=t(8),_=t(22),l=t(7),h=t(15);class f extends(i.Signalable()){constructor(t={}){super(),this._subtype=void 0,this.document=null,this.destroyed=new i.Signal0(this,"destroyed"),this.change=new i.Signal0(this,"change"),this.transformchange=new i.Signal0(this,"transformchange"),this.attributes={},this.properties={},this._set_after_defaults={},this._pending=!1,this._changing=!1;for(const t in this.props){const{type:e,default_value:s}=this.props[t];if(null==e)throw new Error(`undefined property type for ${this.type}.${t}`);this.properties[t]=new e(this,t,s)}null==t.id&&this.setv({id:c.uniqueId()},{silent:!0});const e=t.__deferred__||!1;e&&delete(t=_.clone(t)).__deferred__,this.setv(t,{silent:!0}),e||this.finalize()}set type(t){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=t}get type(){return this.constructor.__qualified__}static get __qualified__(){const{__module__:t,__name__:e}=this;return null!=t?`${t}.${e}`:e}static init_HasProps(){this.prototype.props={},this.prototype.mixins=[],this.define({id:[o.Any]})}static _fix_default(t,e){return void 0===t?void 0:l.isFunction(t)?t:l.isObject(t)?l.isArray(t)?()=>a.copy(t):()=>_.clone(t):()=>t}static define(t){for(const e in t){const s=t[e];if(null!=this.prototype.props[e])throw new Error(`attempted to redefine property '${this.prototype.type}.${e}'`);if(null!=this.prototype[e])throw new Error(`attempted to redefine attribute '${this.prototype.type}.${e}'`);Object.defineProperty(this.prototype,e,{get(){return this.getv(e)},set(t){return this.setv({[e]:t}),this},configurable:!1,enumerable:!0});const[i,n,r]=s,o={type:i,default_value:this._fix_default(n,e),internal:r||!1},c=_.clone(this.prototype.props);c[e]=o,this.prototype.props=c}}static internal(t){const e={};for(const s in t){const i=t[s],[n,r]=i;e[s]=[n,r,!0]}this.define(e)}static mixin(...t){this.define(n.create(t));const e=this.prototype.mixins.concat(t);this.prototype.mixins=e}static mixins(t){this.mixin(...t)}static override(t){for(const e in t){const s=this._fix_default(t[e],e),i=this.prototype.props[e];if(null==i)throw new Error(`attempted to override nonexistent '${this.prototype.type}.${e}'`);const n=_.clone(this.prototype.props);n[e]=Object.assign(Object.assign({},i),{default_value:s}),this.prototype.props=n}}toString(){return`${this.type}(${this.id})`}finalize(){for(const t in this.properties){const e=this.properties[t];e.update(),null!=e.spec.transform&&this.connect(e.spec.transform.change,()=>this.transformchange.emit())}this.initialize(),this.connect_signals()}initialize(){}connect_signals(){}disconnect_signals(){i.Signal.disconnectReceiver(this)}destroy(){this.disconnect_signals(),this.destroyed.emit()}clone(){return new this.constructor(this.attributes)}_setv(t,e){const s=e.check_eq,i=e.silent,n=[],r=this._changing;this._changing=!0;const o=this.attributes;for(const e in t){const i=t[e];!1!==s&&h.isEqual(o[e],i)||n.push(e),o[e]=i}if(!i){n.length>0&&(this._pending=!0);for(let t=0;t<n.length;t++)this.properties[n[t]].change.emit()}if(!r){if(!i&&!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}}setv(t,e={}){for(const s in t){if(!t.hasOwnProperty(s))continue;const i=s;if(null==this.props[i])throw new Error(`property ${this.type}.${i} wasn't declared`);null!=e&&e.defaults||(this._set_after_defaults[s]=!0)}if(!_.isEmpty(t)){const s={};for(const e in t)s[e]=this.getv(e);this._setv(t,e);const i=e.silent;if(null==i||!i)for(const i in t)this._tell_document_about_change(i,s[i],this.getv(i),e)}}getv(t){if(null==this.props[t])throw new Error(`property ${this.type}.${t} wasn't declared`);return this.attributes[t]}ref(){return r.create_ref(this)}set_subtype(t){this._subtype=t}attribute_is_serializable(t){const e=this.props[t];if(null==e)throw new Error(`${this.type}.attribute_is_serializable('${t}'): ${t} wasn't declared`);return!e.internal}serializable_attributes(){const t={};for(const e in this.attributes){const s=this.attributes[e];this.attribute_is_serializable(e)&&(t[e]=s)}return t}static _value_to_json(t,e,s){if(e instanceof f)return e.ref();if(l.isArray(e)){const t=[];for(let s=0;s<e.length;s++){const i=e[s];t.push(f._value_to_json(s.toString(),i,e))}return t}if(l.isPlainObject(e)){const t={};for(const s in e)e.hasOwnProperty(s)&&(t[s]=f._value_to_json(s,e[s],e));return t}return e}attributes_as_json(t=!0,e=f._value_to_json){const s=this.serializable_attributes(),i={};for(const e in s)if(s.hasOwnProperty(e)){const n=s[e];t?i[e]=n:e in this._set_after_defaults&&(i[e]=n)}return e("attributes",i,this)}static _json_record_references(t,e,s,i){if(null==e);else if(r.is_ref(e)){if(!(e.id in s)){const n=t.get_model_by_id(e.id);f._value_record_references(n,s,i)}}else if(l.isArray(e))for(const n of e)f._json_record_references(t,n,s,i);else if(l.isPlainObject(e))for(const n in e)if(e.hasOwnProperty(n)){const r=e[n];f._json_record_references(t,r,s,i)}}static _value_record_references(t,e,s){if(null==t);else if(t instanceof f){if(!(t.id in e)&&(e[t.id]=t,s)){const s=t._immediate_references();for(const t of s)f._value_record_references(t,e,!0)}}else if(t.buffer instanceof ArrayBuffer);else if(l.isArray(t))for(const i of t)f._value_record_references(i,e,s);else if(l.isPlainObject(t))for(const i in t)if(t.hasOwnProperty(i)){const n=t[i];f._value_record_references(n,e,s)}}_immediate_references(){const t={},e=this.serializable_attributes();for(const s in e){const i=e[s];f._value_record_references(i,t,!1)}return _.values(t)}references(){const t={};return f._value_record_references(this,t,!0),_.values(t)}_doc_attached(){}attach_document(t){if(null!=this.document&&this.document!=t)throw new Error("models must be owned by only a single document");this.document=t,this._doc_attached()}detach_document(){this.document=null}_tell_document_about_change(t,e,s,i){if(this.attribute_is_serializable(t)&&null!=this.document){const n={};f._value_record_references(s,n,!1);const r={};f._value_record_references(e,r,!1);let o=!1;for(const t in n)if(!(t in r)){o=!0;break}if(!o)for(const t in r)if(!(t in n)){o=!0;break}o&&this.document._invalidate_all_models(),this.document._notify_change(this,t,e,s,i)}}materialize_dataspecs(t){const e={};for(const s in this.properties){const i=this.properties[s];if(!(i instanceof o.VectorSpec))continue;if(i.optional&&null==i.spec.value&&!(s in this._set_after_defaults))continue;const n=i.array(t);e[`_${s}`]=n,null!=i.spec.field&&i.spec.field in t._shapes&&(e[`_${s}_shape`]=t._shapes[i.spec.field]),i instanceof o.DistanceSpec&&(e[`max_${s}`]=a.max(n))}return e}}s.HasProps=f,f.init_HasProps()},
function _(n,t,e){const s=n(14),l=n(16),c=n(8);class i{constructor(n,t){this.sender=n,this.name=t}connect(n,t=null){r.has(this.sender)||r.set(this.sender,[]);const e=r.get(this.sender);if(null!=a(e,this,n,t))return!1;const s=t||n;u.has(s)||u.set(s,[]);const l=u.get(s),c={signal:this,slot:n,context:t};return e.push(c),l.push(c),!0}disconnect(n,t=null){const e=r.get(this.sender);if(null==e||0===e.length)return!1;const s=a(e,this,n,t);if(null==s)return!1;const l=t||n,c=u.get(l);return s.signal=null,f(e),f(c),!0}emit(n){const t=r.get(this.sender)||[];for(const{signal:e,slot:s,context:l}of t)e===this&&s.call(l,n,this.sender)}}e.Signal=i,i.__name__="Signal";class o extends i{emit(){super.emit(void 0)}}e.Signal0=o,o.__name__="Signal0",function(n){n.disconnectBetween=function(n,t){const e=r.get(n);if(null==e||0===e.length)return;const s=u.get(t);if(null!=s&&0!==s.length){for(const t of s){if(null==t.signal)return;t.signal.sender===n&&(t.signal=null)}f(e),f(s)}},n.disconnectSender=function(n){const t=r.get(n);if(null!=t&&0!==t.length){for(const n of t){if(null==n.signal)return;const t=n.context||n.slot;n.signal=null,f(u.get(t))}f(t)}},n.disconnectReceiver=function(n){const t=u.get(n);if(null!=t&&0!==t.length){for(const n of t){if(null==n.signal)return;const t=n.signal.sender;n.signal=null,f(r.get(t))}f(t)}},n.disconnectAll=function(n){const t=r.get(n);if(null!=t&&0!==t.length){for(const n of t)n.signal=null;f(t)}const e=u.get(n);if(null!=e&&0!==e.length){for(const n of e)n.signal=null;f(e)}}}(i=e.Signal||(e.Signal={})),e.Signalable=function(n){return null!=n?class extends n{connect(n,t){return n.connect(t,this)}disconnect(n,t){return n.disconnect(t,this)}}:class{connect(n,t){return n.connect(t,this)}disconnect(n,t){return n.disconnect(t,this)}}},function(n){n.connect=function(n,t){return n.connect(t,this)},n.disconnect=function(n,t){return n.disconnect(t,this)}}(e._Signalable||(e._Signalable={}));const r=new WeakMap,u=new WeakMap;function a(n,t,e,s){return c.find(n,n=>n.signal===t&&n.slot===e&&n.context===s)}const g=new s.Set;function f(n){0===g.size&&l.defer(h),g.add(n)}function h(){g.forEach(n=>{c.remove_by(n,n=>null==n.signal)}),g.clear()}},
function _(t,s,e){const i=t(8),n=t(15),r=t(7);class o{constructor(){this._dict={}}_existing(t){return t in this._dict?this._dict[t]:null}add_value(t,s){const e=this._existing(t);null==e?this._dict[t]=s:r.isArray(e)?e.push(s):this._dict[t]=[e,s]}remove_value(t,s){const e=this._existing(t);if(r.isArray(e)){const n=i.difference(e,[s]);n.length>0?this._dict[t]=n:delete this._dict[t]}else n.isEqual(e,s)&&delete this._dict[t]}get_one(t,s){const e=this._existing(t);if(r.isArray(e)){if(1===e.length)return e[0];throw new Error(s)}return e}}e.MultiDict=o,o.__name__="MultiDict";class a{constructor(t){if(null==t)this._values=[];else if(t instanceof a)this._values=i.copy(t._values);else{this._values=[];for(const s of t)this.add(s)}}get values(){return i.copy(this._values).sort()}toString(){return`Set([${this.values.join(",")}])`}get size(){return this._values.length}has(t){return-1!==this._values.indexOf(t)}add(t){this.has(t)||this._values.push(t)}remove(t){const s=this._values.indexOf(t);-1!==s&&this._values.splice(s,1)}toggle(t){const s=this._values.indexOf(t);-1===s?this._values.push(t):this._values.splice(s,1)}clear(){this._values=[]}union(t){return t=new a(t),new a(this._values.concat(t._values))}intersect(t){t=new a(t);const s=new a;for(const e of t._values)this.has(e)&&t.has(e)&&s.add(e);return s}diff(t){t=new a(t);const s=new a;for(const e of this._values)t.has(e)||s.add(e);return s}forEach(t,s){for(const e of this._values)t.call(s||this,e,e,this)}}e.Set=a,a.__name__="Set";class h{constructor(t,s,e){this.nrows=t,this.ncols=s,this._matrix=new Array(t);for(let i=0;i<t;i++){this._matrix[i]=new Array(s);for(let t=0;t<s;t++)this._matrix[i][t]=e(i,t)}}at(t,s){return this._matrix[t][s]}map(t){return new h(this.nrows,this.ncols,(s,e)=>t(this.at(s,e),s,e))}apply(t){const s=h.from(t),{nrows:e,ncols:i}=this;if(e==s.nrows&&i==s.ncols)return new h(e,i,(t,e)=>s.at(t,e)(this.at(t,e),t,e));throw new Error("dimensions don't match")}to_sparse(){const t=[];for(let s=0;s<this.nrows;s++)for(let e=0;e<this.ncols;e++){const i=this._matrix[s][e];t.push([i,s,e])}return t}static from(t){if(t instanceof h)return t;{const s=t.length,e=i.min(t.map(t=>t.length));return new h(s,e,(s,e)=>t[s][e])}}}e.Matrix=h,h.__name__="Matrix"},
function _(t,e,n){const r=t(7),o=Object.prototype.toString;n.isEqual=function(t,e){return function t(e,n,c,u){if(e===n)return 0!==e||1/e==1/n;if(null==e||null==n)return e===n;const i=o.call(e);if(i!==o.call(n))return!1;switch(i){case"[object RegExp]":case"[object String]":return""+e==""+n;case"[object Number]":return+e!=+e?+n!=+n:0==+e?1/+e==1/n:+e==+n;case"[object Date]":case"[object Boolean]":return+e==+n}const s="[object Array]"===i;if(!s){if("object"!=typeof e||"object"!=typeof n)return!1;const t=e.constructor,o=n.constructor;if(t!==o&&!(r.isFunction(t)&&t instanceof t&&r.isFunction(o)&&o instanceof o)&&"constructor"in e&&"constructor"in n)return!1}u=u||[];let f=(c=c||[]).length;for(;f--;)if(c[f]===e)return u[f]===n;if(c.push(e),u.push(n),s){if((f=e.length)!==n.length)return!1;for(;f--;)if(!t(e[f],n[f],c,u))return!1}else{const r=Object.keys(e);let o;if(f=r.length,Object.keys(n).length!==f)return!1;for(;f--;)if(o=r[f],!n.hasOwnProperty(o)||!t(e[o],n[o],c,u))return!1}return c.pop(),u.pop(),!0}(t,e)}},
function _(n,t,e){e.delay=function(n,t){return setTimeout(n,t)};const u="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;e.defer=function(n){return u(n)},e.throttle=function(n,t,e={}){let u,o,i,l=null,r=0;const c=function(){r=!1===e.leading?0:Date.now(),l=null,i=n.apply(u,o),l||(u=o=null)};return function(){const a=Date.now();r||!1!==e.leading||(r=a);const f=t-(a-r);return u=this,o=arguments,f<=0||f>t?(l&&(clearTimeout(l),l=null),r=a,i=n.apply(u,o),l||(u=o=null)):l||!1===e.trailing||(l=setTimeout(c,f)),i}},e.once=function(n){let t,e=!1;return function(){return e||(e=!0,t=n()),t}}},
function _(e,t,n){const c=e(18),l=e(22);function o(e,t){const n={};for(const c in e){const l=e[c];n[t+c]=l}return n}const a={line_color:[c.ColorSpec,"black"],line_width:[c.NumberSpec,1],line_alpha:[c.NumberSpec,1],line_join:[c.LineJoin,"bevel"],line_cap:[c.LineCap,"butt"],line_dash:[c.Array,[]],line_dash_offset:[c.Number,0]};n.line=((e="")=>o(a,e));const r={fill_color:[c.ColorSpec,"gray"],fill_alpha:[c.NumberSpec,1]};n.fill=((e="")=>o(r,e));const i={hatch_color:[c.ColorSpec,"black"],hatch_alpha:[c.NumberSpec,1],hatch_scale:[c.NumberSpec,12],hatch_pattern:[c.StringSpec,null],hatch_weight:[c.NumberSpec,1],hatch_extra:[c.Any,{}]};n.hatch=((e="")=>o(i,e));const h={text_font:[c.Font,"helvetica"],text_font_size:[c.FontSizeSpec,"12pt"],text_font_style:[c.FontStyle,"normal"],text_color:[c.ColorSpec,"#444444"],text_alpha:[c.NumberSpec,1],text_align:[c.TextAlign,"left"],text_baseline:[c.TextBaseline,"bottom"],text_line_height:[c.Number,1.2]};n.text=((e="")=>o(h,e)),n.create=function(e){const t={};for(const c of e){const[e,o]=c.split(":");let a;switch(e){case"line":a=n.line;break;case"fill":a=n.fill;break;case"hatch":a=n.hatch;break;case"text":a=n.text;break;default:throw new Error(`Unknown property mixin kind '${e}'`)}l.extend(t,a(o))}return t}},
function _(e,t,n){const i=e(13),s=e(19),a=e(8),r=e(11),o=e(20),l=e(7);function c(e){try{return JSON.stringify(e)}catch(t){return e.toString()}}function _(e){return l.isPlainObject(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}i.Signal,n.isSpec=_;class u extends(i.Signalable()){constructor(e,t,n){super(),this.obj=e,this.attr=t,this.default_value=n,this.optional=!1,this.change=new i.Signal0(this.obj,"change"),this._init(),this.connect(this.change,()=>this._init())}update(){this._init()}init(){}transform(e){return e}validate(e){if(!this.valid(e))throw new Error(`${this.obj.type}.${this.attr} given invalid value: ${c(e)}`)}valid(e){return!0}value(e=!0){if(void 0===this.spec.value)throw new Error("attempted to retrieve property value for property without value specification");let t=this.transform([this.spec.value])[0];return null!=this.spec.transform&&e&&(t=this.spec.transform.compute(t)),t}_init(){const e=this.obj,t=this.attr;let n=e.getv(t);if(void 0===n){const i=this.default_value;n=void 0!==i?i(e):null,e.setv({[t]:n},{silent:!0,defaults:!0})}l.isArray(n)?this.spec={value:n}:_(n)?this.spec=n:this.spec={value:n},null!=this.spec.value&&this.validate(this.spec.value),this.init()}toString(){return`Prop(${this.obj}.${this.attr}, spec: ${c(this.spec)})`}}n.Property=u,u.__name__="Property";class d extends u{}n.Any=d,d.__name__="Any";class p extends u{valid(e){return l.isArray(e)||e instanceof Float64Array}}n.Array=p,p.__name__="Array";class h extends u{valid(e){return l.isBoolean(e)}}n.Boolean=h,h.__name__="Boolean";class m extends u{valid(e){return l.isString(e)&&o.is_color(e)}}n.Color=m,m.__name__="Color";class S extends u{}n.Instance=S,S.__name__="Instance";class g extends u{valid(e){return l.isNumber(e)}}n.Number=g,g.__name__="Number";class v extends g{valid(e){return l.isNumber(e)&&(0|e)==e}}n.Int=v,v.__name__="Int";class x extends g{}n.Angle=x,x.__name__="Angle";class f extends g{valid(e){return l.isNumber(e)&&0<=e&&e<=1}}n.Percent=f,f.__name__="Percent";class y extends u{valid(e){return l.isString(e)}}n.String=y,y.__name__="String";class P extends y{}n.FontSize=P,P.__name__="FontSize";class L extends y{}n.Font=L,L.__name__="Font";class T extends u{valid(e){return l.isString(e)&&a.includes(this.enum_values,e)}}function A(e){return class extends T{get enum_values(){return e}}}n.EnumProperty=T,T.__name__="EnumProperty",n.Enum=A;class b extends T{get enum_values(){return s.Direction}transform(e){const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)switch(e[n]){case"clock":t[n]=0;break;case"anticlock":t[n]=1}return t}}n.Direction=b,b.__name__="Direction",n.Anchor=A(s.Anchor),n.AngleUnits=A(s.AngleUnits),n.BoxOrigin=A(s.BoxOrigin),n.ButtonType=A(s.ButtonType),n.Dimension=A(s.Dimension),n.Dimensions=A(s.Dimensions),n.Distribution=A(s.Distribution),n.FontStyle=A(s.FontStyle),n.HatchPatternType=A(s.HatchPatternType),n.HTTPMethod=A(s.HTTPMethod),n.HexTileOrientation=A(s.HexTileOrientation),n.HoverMode=A(s.HoverMode),n.LatLon=A(s.LatLon),n.LegendClickPolicy=A(s.LegendClickPolicy),n.LegendLocation=A(s.LegendLocation),n.LineCap=A(s.LineCap),n.LineJoin=A(s.LineJoin),n.LinePolicy=A(s.LinePolicy),n.Location=A(s.Location),n.Logo=A(s.Logo),n.MarkerType=A(s.MarkerType),n.Orientation=A(s.Orientation),n.OutputBackend=A(s.OutputBackend),n.PaddingUnits=A(s.PaddingUnits),n.Place=A(s.Place),n.PointPolicy=A(s.PointPolicy),n.RadiusDimension=A(s.RadiusDimension),n.RenderLevel=A(s.RenderLevel),n.RenderMode=A(s.RenderMode),n.ResetPolicy=A(s.ResetPolicy),n.RoundingFunction=A(s.RoundingFunction),n.Side=A(s.Side),n.SizingMode=A(s.SizingMode),n.SliderCallbackPolicy=A(s.SliderCallbackPolicy),n.Sort=A(s.Sort),n.SpatialUnits=A(s.SpatialUnits),n.StartEnd=A(s.StartEnd),n.StepMode=A(s.StepMode),n.TapBehavior=A(s.TapBehavior),n.TextAlign=A(s.TextAlign),n.TextBaseline=A(s.TextBaseline),n.TextureRepetition=A(s.TextureRepetition),n.TickLabelOrientation=A(s.TickLabelOrientation),n.TooltipAttachment=A(s.TooltipAttachment),n.UpdateMode=A(s.UpdateMode),n.VerticalAlign=A(s.VerticalAlign);class M extends u{}n.ScalarSpec=M,M.__name__="ScalarSpec";class k extends u{array(e){let t;if(null!=this.spec.field){if(null==(t=this.transform(e.get_column(this.spec.field))))throw new Error(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`)}else if(null!=this.spec.expr)t=this.transform(this.spec.expr.v_compute(e));else{let n=e.get_length();null==n&&(n=1);const i=this.value(!1);t=a.repeat(i,n)}return null!=this.spec.transform&&(t=this.spec.transform.v_compute(t)),t}}n.VectorSpec=k,k.__name__="VectorSpec";class B extends k{}n.DataSpec=B,B.__name__="DataSpec";class D extends k{init(){null==this.spec.units&&(this.spec.units=this.default_units);const e=this.spec.units;if(!a.includes(this.valid_units,e))throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${e}`)}get units(){return this.spec.units}set units(e){this.spec.units=e}}n.UnitsSpec=D,D.__name__="UnitsSpec";class C extends D{get default_units(){return"rad"}get valid_units(){return s.AngleUnits}transform(e){return"deg"==this.spec.units&&(e=r.map(e,e=>e*Math.PI/180)),e=r.map(e,e=>-e),super.transform(e)}}n.AngleSpec=C,C.__name__="AngleSpec";class U extends B{}n.BooleanSpec=U,U.__name__="BooleanSpec";class w extends B{}n.ColorSpec=w,w.__name__="ColorSpec";class O extends B{}n.CoordinateSpec=O,O.__name__="CoordinateSpec";class R extends B{}n.CoordinateSeqSpec=R,R.__name__="CoordinateSeqSpec";class F extends D{get default_units(){return"data"}get valid_units(){return s.SpatialUnits}}n.DistanceSpec=F,F.__name__="DistanceSpec";class N extends B{}n.FontSizeSpec=N,N.__name__="FontSizeSpec";class E extends B{}n.MarkerSpec=E,E.__name__="MarkerSpec";class $ extends B{}n.NumberSpec=$,$.__name__="NumberSpec";class H extends B{}n.StringSpec=H,H.__name__="StringSpec";class j extends B{}n.NullStringSpec=j,j.__name__="NullStringSpec"},
function _(e,t,n){n.Align=["start","center","end"],n.Anchor=["top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"],n.AngleUnits=["deg","rad"],n.BoxOrigin=["corner","center"],n.ButtonType=["default","primary","success","warning","danger"],n.Dimension=["width","height"],n.Dimensions=["width","height","both"],n.Direction=["clock","anticlock"],n.Distribution=["uniform","normal"],n.FontStyle=["normal","italic","bold","bold italic"],n.HatchPatternType=["blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"],n.HTTPMethod=["POST","GET"],n.HexTileOrientation=["pointytop","flattop"],n.HoverMode=["mouse","hline","vline"],n.LatLon=["lat","lon"],n.LegendClickPolicy=["none","hide","mute"],n.LegendLocation=n.Anchor,n.LineCap=["butt","round","square"],n.LineJoin=["miter","round","bevel"],n.LinePolicy=["prev","next","nearest","interp","none"],n.Location=["above","below","left","right"],n.Logo=["normal","grey"],n.MarkerType=["asterisk","circle","circle_cross","circle_x","cross","dash","diamond","diamond_cross","hex","inverted_triangle","square","square_cross","square_x","triangle","x"],n.Orientation=["vertical","horizontal"],n.OutputBackend=["canvas","svg","webgl"],n.PaddingUnits=["percent","absolute"],n.Place=["above","below","left","right","center"],n.PointPolicy=["snap_to_data","follow_mouse","none"],n.RadiusDimension=["x","y","max","min"],n.RenderLevel=["image","underlay","glyph","annotation","overlay"],n.RenderMode=["canvas","css"],n.ResetPolicy=["standard","event_only"],n.RoundingFunction=["round","nearest","floor","rounddown","ceil","roundup"],n.Side=["above","below","left","right"],n.SizingMode=["stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"],n.SliderCallbackPolicy=["continuous","throttle","mouseup"],n.Sort=["ascending","descending"],n.SpatialUnits=["screen","data"],n.StartEnd=["start","end"],n.StepMode=["after","before","center"],n.TapBehavior=["select","inspect"],n.TextAlign=["left","right","center"],n.TextBaseline=["top","middle","bottom","alphabetic","hanging","ideographic"],n.TextureRepetition=["repeat","repeat_x","repeat_y","no_repeat"],n.TickLabelOrientation=["vertical","horizontal","parallel","normal"],n.TooltipAttachment=["horizontal","vertical","left","right","above","below"],n.UpdateMode=["replace","append"],n.VerticalAlign=["top","middle","bottom"]},
function _(e,r,t){const n=e(21),o=e(8);function l(e){const r=Number(e).toString(16);return 1==r.length?`0${r}`:r}function a(e){if(0==(e+="").indexOf("#"))return e;if(n.is_svg_color(e))return n.svg_colors[e];if(0==e.indexOf("rgb")){const r=e.replace(/^rgba?\(|\s+|\)$/g,"").split(",");let t=r.slice(0,3).map(l).join("");return 4==r.length&&(t+=l(Math.floor(255*parseFloat(r[3])))),`#${t.slice(0,8)}`}return e}function c(e){let r;switch(e.substring(0,4)){case"rgba":r={start:"rgba(",len:4,alpha:!0};break;case"rgb(":r={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(e))throw new Error(`color expects integers for rgb in rgb/rgba tuple, received ${e}`);const t=e.replace(r.start,"").replace(")","").split(",").map(parseFloat);if(t.length!=r.len)throw new Error(`color expects rgba ${r.len}-tuple, received ${e}`);if(r.alpha&&!(0<=t[3]&&t[3]<=1))throw new Error("color expects rgba 4-tuple to have alpha value between 0 and 1");if(o.includes(t.slice(0,3).map(e=>0<=e&&e<=255),!1))throw new Error("color expects rgb to have value between 0 and 255");return!0}t.is_color=function(e){return n.is_svg_color(e.toLowerCase())||"#"==e.substring(0,1)||c(e)},t.rgb2hex=function(e,r,t){return`#${l(255&e)}${l(255&r)}${l(255&t)}`},t.color2hex=a,t.color2rgba=function(e,r=1){if(!e)return[0,0,0,0];let t=a(e);(t=t.replace(/ |#/g,"")).length<=4&&(t=t.replace(/(.)/g,"$1$1"));const n=t.match(/../g).map(e=>parseInt(e,16)/255);for(;n.length<3;)n.push(0);return n.length<4&&n.push(r),n.slice(0,4)},t.valid_rgb=c},
function _(F,e,r){r.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},r.is_svg_color=function(F){return F in r.svg_colors}},
function _(n,t,e){const c=n(23),r=n(8);function o(n,t){return c.__assign(n,t)}function s(n){return Object.keys(n).length}e.keys=Object.keys,e.values=function(n){const t=Object.keys(n),e=t.length,c=new Array(e);for(let r=0;r<e;r++)c[r]=n[t[r]];return c},e.extend=o,e.clone=function(n){return o({},n)},e.merge=function(n,t){const e=Object.create(Object.prototype),c=r.concat([Object.keys(n),Object.keys(t)]);for(const o of c){const c=n.hasOwnProperty(o)?n[o]:[],s=t.hasOwnProperty(o)?t[o]:[];e[o]=r.union(c,s)}return e},e.size=s,e.isEmpty=function(n){return 0===s(n)}},
function _(t,e,n){
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0
    
    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.
    
    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
var r,o,a,c,u,i,f,l,s,y,p,_,b,h,v,d,w,m,O,j;!function(t){var n="object"==typeof global?global:"object"==typeof self?self:"object"==typeof this?this:{};function r(t,e){return t!==n&&("function"==typeof Object.create?Object.defineProperty(t,"__esModule",{value:!0}):t.__esModule=!0),function(n,r){return t[n]=e?e(n,r):r}}"function"==typeof define&&define.amd?define("tslib",["exports"],function(e){t(r(n,r(e)))}):"object"==typeof e&&"object"==typeof e.exports?t(r(n,r(e.exports))):t(r(n))}(function(t){var e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])};r=function(t,n){function r(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(r.prototype=n.prototype,new r)},o=Object.assign||function(t){for(var e,n=1,r=arguments.length;n<r;n++)for(var o in e=arguments[n])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},a=function(t,e){var n={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(n[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(t);o<r.length;o++)e.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(t,r[o])&&(n[r[o]]=t[r[o]])}return n},c=function(t,e,n,r){var o,a=arguments.length,c=a<3?e:null===r?r=Object.getOwnPropertyDescriptor(e,n):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)c=Reflect.decorate(t,e,n,r);else for(var u=t.length-1;u>=0;u--)(o=t[u])&&(c=(a<3?o(c):a>3?o(e,n,c):o(e,n))||c);return a>3&&c&&Object.defineProperty(e,n,c),c},u=function(t,e){return function(n,r){e(n,r,t)}},i=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},f=function(t,e,n,r){return new(n||(n=Promise))(function(o,a){function c(t){try{i(r.next(t))}catch(t){a(t)}}function u(t){try{i(r.throw(t))}catch(t){a(t)}}function i(t){t.done?o(t.value):new n(function(e){e(t.value)}).then(c,u)}i((r=r.apply(t,e||[])).next())})},l=function(t,e){var n,r,o,a,c={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:u(0),throw:u(1),return:u(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function u(a){return function(u){return function(a){if(n)throw new TypeError("Generator is already executing.");for(;c;)try{if(n=1,r&&(o=2&a[0]?r.return:a[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,a[1])).done)return o;switch(r=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return c.label++,{value:a[1],done:!1};case 5:c.label++,r=a[1],a=[0];continue;case 7:a=c.ops.pop(),c.trys.pop();continue;default:if(!(o=(o=c.trys).length>0&&o[o.length-1])&&(6===a[0]||2===a[0])){c=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){c.label=a[1];break}if(6===a[0]&&c.label<o[1]){c.label=o[1],o=a;break}if(o&&c.label<o[2]){c.label=o[2],c.ops.push(a);break}o[2]&&c.ops.pop(),c.trys.pop();continue}a=e.call(t,c)}catch(t){a=[6,t],r=0}finally{n=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,u])}}},s=function(t,e){for(var n in t)e.hasOwnProperty(n)||(e[n]=t[n])},y=function(t){var e="function"==typeof Symbol&&t[Symbol.iterator],n=0;return e?e.call(t):{next:function(){return t&&n>=t.length&&(t=void 0),{value:t&&t[n++],done:!t}}}},p=function(t,e){var n="function"==typeof Symbol&&t[Symbol.iterator];if(!n)return t;var r,o,a=n.call(t),c=[];try{for(;(void 0===e||e-- >0)&&!(r=a.next()).done;)c.push(r.value)}catch(t){o={error:t}}finally{try{r&&!r.done&&(n=a.return)&&n.call(a)}finally{if(o)throw o.error}}return c},_=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(p(arguments[e]));return t},b=function(){for(var t=0,e=0,n=arguments.length;e<n;e++)t+=arguments[e].length;var r=Array(t),o=0;for(e=0;e<n;e++)for(var a=arguments[e],c=0,u=a.length;c<u;c++,o++)r[o]=a[c];return r},h=function(t){return this instanceof h?(this.v=t,this):new h(t)},v=function(t,e,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=n.apply(t,e||[]),a=[];return r={},c("next"),c("throw"),c("return"),r[Symbol.asyncIterator]=function(){return this},r;function c(t){o[t]&&(r[t]=function(e){return new Promise(function(n,r){a.push([t,e,n,r])>1||u(t,e)})})}function u(t,e){try{(n=o[t](e)).value instanceof h?Promise.resolve(n.value.v).then(i,f):l(a[0][2],n)}catch(t){l(a[0][3],t)}var n}function i(t){u("next",t)}function f(t){u("throw",t)}function l(t,e){t(e),a.shift(),a.length&&u(a[0][0],a[0][1])}},d=function(t){var e,n;return e={},r("next"),r("throw",function(t){throw t}),r("return"),e[Symbol.iterator]=function(){return this},e;function r(r,o){e[r]=t[r]?function(e){return(n=!n)?{value:h(t[r](e)),done:"return"===r}:o?o(e):e}:o}},w=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,n=t[Symbol.asyncIterator];return n?n.call(t):(t=y(t),e={},r("next"),r("throw"),r("return"),e[Symbol.asyncIterator]=function(){return this},e);function r(n){e[n]=t[n]&&function(e){return new Promise(function(r,o){(function(t,e,n,r){Promise.resolve(r).then(function(e){t({value:e,done:n})},e)})(r,o,(e=t[n](e)).done,e.value)})}}},m=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t},O=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)Object.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e.default=t,e},j=function(t){return t&&t.__esModule?t:{default:t}},t("__extends",r),t("__assign",o),t("__rest",a),t("__decorate",c),t("__param",u),t("__metadata",i),t("__awaiter",f),t("__generator",l),t("__exportStar",s),t("__values",y),t("__read",p),t("__spread",_),t("__spreadArrays",b),t("__await",h),t("__asyncGenerator",v),t("__asyncDelegator",d),t("__asyncValues",w),t("__makeTemplateObject",m),t("__importStar",O),t("__importDefault",j)})},
function _(t,e,n){const i=t(7);n.create_ref=function(t){const e={type:t.type,id:t.id};return null!=t._subtype&&(e.subtype=t._subtype),e},n.is_ref=function(t){if(i.isObject(t)){const e=Object.keys(t).sort();if(2==e.length)return"id"==e[0]&&"type"==e[1];if(3==e.length)return"id"==e[0]&&"subtype"==e[1]&&"type"==e[2]}return!1}},
function _(t,r,e){const n=t(26);function u(){const t=new Array(32);for(let r=0;r<32;r++)t[r]="0123456789ABCDEF".substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]="0123456789ABCDEF".substr(3&t[16].charCodeAt(0)|8,1),t.join("")}e.startsWith=function(t,r,e=0){return t.substr(e,r.length)==r},e.uuid4=u;let s=1e3;e.uniqueId=function(t){const r=n.settings.dev?`j${s++}`:u();return null!=t?`${t}-${r}`:r},e.escape=function(t){return t.replace(/(?:[&<>"'`])/g,t=>{switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}})},e.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,(t,r)=>{switch(r){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return r}})},e.use_strict=function(t){return`'use strict';\n${t}`}},
function _(t,e,s){class n{constructor(){this._dev=!1}set dev(t){this._dev=t}get dev(){return this._dev}}s.Settings=n,n.__name__="Settings",s.settings=new n},
function _(n,o,r){function f(n){for(var o in n)r.hasOwnProperty(o)||(r[o]=n[o])}f(n(28)),f(n(140)),f(n(167)),f(n(171)),f(n(186)),f(n(190)),f(n(196)),f(n(200)),f(n(230)),f(n(233)),f(n(235)),f(n(248)),f(n(115)),f(n(254)),f(n(258)),f(n(281)),f(n(282)),f(n(283)),f(n(284)),f(n(285)),f(n(291)),f(n(293)),f(n(303)),f(n(307))},
function _(a,e,o){var r=a(29);o.Annotation=r.Annotation;var n=a(66);o.Arrow=n.Arrow;var t=a(67);o.ArrowHead=t.ArrowHead;var v=a(67);o.OpenHead=v.OpenHead;var l=a(67);o.NormalHead=l.NormalHead;var d=a(67);o.TeeHead=d.TeeHead;var i=a(67);o.VeeHead=i.VeeHead;var A=a(98);o.Band=A.Band;var H=a(99);o.BoxAnnotation=H.BoxAnnotation;var T=a(101);o.ColorBar=T.ColorBar;var p=a(125);o.Label=p.Label;var L=a(127);o.LabelSet=L.LabelSet;var b=a(128);o.Legend=b.Legend;var B=a(129);o.LegendItem=B.LegendItem;var S=a(131);o.PolyAnnotation=S.PolyAnnotation;var g=a(132);o.Slope=g.Slope;var m=a(133);o.Span=m.Span;var w=a(126);o.TextAnnotation=w.TextAnnotation;var x=a(134);o.Title=x.Title;var P=a(135);o.ToolbarPanel=P.ToolbarPanel;var h=a(136);o.Tooltip=h.Tooltip;var k=a(139);o.Whisker=k.Whisker},
function _(t,e,n){const s=t(30),i=t(22),o=t(58);class _ extends o.RendererView{get panel(){return this.layout}get_size(){if(this.model.visible){const{width:t,height:e}=this._get_size();return{width:Math.round(t),height:Math.round(e)}}return{width:0,height:0}}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.visible,()=>this.plot_view.request_layout())}_get_size(){throw new Error("not implemented")}get ctx(){return this.plot_view.canvas_view.ctx}set_data(t){const e=this.model.materialize_dataspecs(t);if(i.extend(this,e),this.plot_model.use_map){const t=this;null!=t._x&&([t._x,t._y]=s.project_xy(t._x,t._y)),null!=t._xs&&([t._xs,t._ys]=s.project_xsys(t._xs,t._ys))}}get needs_clip(){return null==this.layout}serializable_state(){const t=super.serializable_state();return null==this.layout?t:Object.assign(Object.assign({},t),{bbox:this.layout.bbox.box})}}n.AnnotationView=_,_.__name__="AnnotationView";class a extends o.Renderer{constructor(t){super(t)}static init_Annotation(){this.override({level:"annotation"})}}n.Annotation=a,a.__name__="Annotation",a.init_Annotation()},
function _(n,t,r){const o=n(31),e=n(32),c=new e("GOOGLE"),a=new e("WGS84");r.wgs84_mercator=o(a,c);const s={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},l={lon:[-180,180],lat:[-85.06,85.06]};function i(n,t){const o=Math.min(n.length,t.length),e=new Array(o),c=new Array(o);for(let a=0;a<o;a++){const[o,s]=r.wgs84_mercator.forward([n[a],t[a]]);e[a]=o,c[a]=s}return[e,c]}r.clip_mercator=function(n,t,r){const[o,e]=s[r];return[Math.max(n,o),Math.min(t,e)]},r.in_bounds=function(n,t){return n>l[t][0]&&n<l[t][1]},r.project_xy=i,r.project_xsys=function(n,t){const r=Math.min(n.length,t.length),o=new Array(r),e=new Array(r);for(let c=0;c<r;c++){const[r,a]=i(n[c],t[c]);o[c]=r,e[c]=a}return[o,e]}},
function _(r,n,o){var t=r(32),i=r(53),u=t("WGS84");function e(r,n,o){var t;return Array.isArray(o)?(t=i(r,n,o),3===o.length?[t.x,t.y,t.z]:[t.x,t.y]):i(r,n,o)}function a(r){return r instanceof t?r:r.oProj?r.oProj:t(r)}n.exports=function(r,n,o){r=a(r);var t,i=!1;return void 0===n?(n=r,r=u,i=!0):(void 0!==n.x||Array.isArray(n))&&(o=n,n=r,r=u,i=!0),n=a(n),o?e(r,n,o):(t={forward:function(o){return e(r,n,o)},inverse:function(o){return e(n,r,o)}},i&&(t.oProj=n),t)}},
function _(e,t,s){var a=e(33),i=e(40),r=e(41),o=e(49),n=e(51),p=e(52);function u(e,t){if(!(this instanceof u))return new u(e);t=t||function(e){if(e)throw e};var s=a(e);if("object"==typeof s){var r=u.projections.get(s.projName);if(r){if(s.datumCode&&"none"!==s.datumCode){var h=n[s.datumCode];h&&(s.datum_params=h.towgs84?h.towgs84.split(","):null,s.ellps=h.ellipse,s.datumName=h.datumName?h.datumName:s.datumCode)}s.k0=s.k0||1,s.axis=s.axis||"enu";var m=o.sphere(s.a,s.b,s.rf,s.ellps,s.sphere),d=o.eccentricity(m.a,m.b,m.rf,s.R_A),f=s.datum||p(s.datumCode,s.datum_params,m.a,m.b,d.es,d.ep2);i(this,s),i(this,r),this.a=m.a,this.b=m.b,this.rf=m.rf,this.sphere=m.sphere,this.es=d.es,this.e=d.e,this.ep2=d.ep2,this.datum=f,this.init(),t(null,this)}else t(e)}else t(e)}u.projections=r,u.projections.start(),t.exports=u},
function _(n,r,t){var u=n(34),i=n(39),o=n(36);var e=["GEOGCS","GEOCCS","PROJCS","LOCAL_CS"];r.exports=function(n){return function(n){return"string"==typeof n}(n)?function(n){return n in u}(n)?u[n]:function(n){return e.some(function(r){return n.indexOf(r)>-1})}(n)?i(n):function(n){return"+"===n[0]}(n)?o(n):void 0:n}},
function _(r,n,i){var t=r(35),e=r(36),a=r(39);function f(r){var n=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?f[r]=e(arguments[1]):f[r]=a(arguments[1]):f[r]=i}else if(1===arguments.length){if(Array.isArray(r))return r.map(function(r){Array.isArray(r)?f.apply(n,r):f(r)});if("string"==typeof r){if(r in f)return f[r]}else"EPSG"in r?f["EPSG:"+r.EPSG]=r:"ESRI"in r?f["ESRI:"+r.ESRI]=r:"IAU2000"in r?f["IAU2000:"+r.IAU2000]=r:console.log(r);return}}t(f),n.exports=f},
function _(t,l,G){l.exports=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(n,t,o){var a=.017453292519943295,u=n(37),e=n(38);t.exports=function(n){var t,o,r,i={},f=n.split("+").map(function(n){return n.trim()}).filter(function(n){return n}).reduce(function(n,t){var o=t.split("=");return o.push(!0),n[o[0].toLowerCase()]=o[1],n},{}),s={proj:"projName",datum:"datumCode",rf:function(n){i.rf=parseFloat(n)},lat_0:function(n){i.lat0=n*a},lat_1:function(n){i.lat1=n*a},lat_2:function(n){i.lat2=n*a},lat_ts:function(n){i.lat_ts=n*a},lon_0:function(n){i.long0=n*a},lon_1:function(n){i.long1=n*a},lon_2:function(n){i.long2=n*a},alpha:function(n){i.alpha=parseFloat(n)*a},lonc:function(n){i.longc=n*a},x_0:function(n){i.x0=parseFloat(n)},y_0:function(n){i.y0=parseFloat(n)},k_0:function(n){i.k0=parseFloat(n)},k:function(n){i.k0=parseFloat(n)},a:function(n){i.a=parseFloat(n)},b:function(n){i.b=parseFloat(n)},r_a:function(){i.R_A=!0},zone:function(n){i.zone=parseInt(n,10)},south:function(){i.utmSouth=!0},towgs84:function(n){i.datum_params=n.split(",").map(function(n){return parseFloat(n)})},to_meter:function(n){i.to_meter=parseFloat(n)},units:function(n){i.units=n,e[n]&&(i.to_meter=e[n].to_meter)},from_greenwich:function(n){i.from_greenwich=n*a},pm:function(n){i.from_greenwich=(u[n]?u[n]:parseFloat(n))*a},nadgrids:function(n){"@null"===n?i.datumCode="none":i.nadgrids=n},axis:function(n){3===n.length&&-1!=="ewnsud".indexOf(n.substr(0,1))&&-1!=="ewnsud".indexOf(n.substr(1,1))&&-1!=="ewnsud".indexOf(n.substr(2,1))&&(i.axis=n)}};for(t in f)o=f[t],t in s?"function"==typeof(r=s[t])?r(o):i[r]=o:i[t]=o;return"string"==typeof i.datumCode&&"WGS84"!==i.datumCode&&(i.datumCode=i.datumCode.toLowerCase()),i}},
function _(o,r,s){s.greenwich=0,s.lisbon=-9.131906111111,s.paris=2.337229166667,s.bogota=-74.080916666667,s.madrid=-3.687938888889,s.rome=12.452333333333,s.bern=7.439583333333,s.jakarta=106.807719444444,s.ferro=-17.666666666667,s.brussels=4.367975,s.stockholm=18.058277777778,s.athens=23.7163375,s.oslo=10.722916666667},
function _(t,e,f){f.ft={to_meter:.3048},f["us-ft"]={to_meter:1200/3937}},
function _(e,a,t){var r=.017453292519943295,n=e(40);function o(e,a,t){e[a]=t.map(function(e){var a={};return l(e,a),a}).reduce(function(e,a){return n(e,a)},{})}function l(e,a){var t;Array.isArray(e)?("PARAMETER"===(t=e.shift())&&(t=e.shift()),1===e.length?Array.isArray(e[0])?(a[t]={},l(e[0],a[t])):a[t]=e[0]:e.length?"TOWGS84"===t?a[t]=e:(a[t]={},["UNIT","PRIMEM","VERT_DATUM"].indexOf(t)>-1?(a[t]={name:e[0].toLowerCase(),convert:e[1]},3===e.length&&(a[t].auth=e[2])):"SPHEROID"===t?(a[t]={name:e[0],a:e[1],rf:e[2]},4===e.length&&(a[t].auth=e[3])):["GEOGCS","GEOCCS","DATUM","VERT_CS","COMPD_CS","LOCAL_CS","FITTED_CS","LOCAL_DATUM"].indexOf(t)>-1?(e[0]=["name",e[0]],o(a,t,e)):e.every(function(e){return Array.isArray(e)})?o(a,t,e):l(e,a[t])):a[t]=!0):a[e]=!0}function i(e){return e*r}a.exports=function(e,a){var t=JSON.parse((","+e).replace(/\s*\,\s*([A-Z_0-9]+?)(\[)/g,',["$1",').slice(1).replace(/\s*\,\s*([A-Z_0-9]+?)\]/g,',"$1"]').replace(/,\["VERTCS".+/,"")),r=t.shift(),o=t.shift();t.unshift(["name",o]),t.unshift(["type",r]),t.unshift("output");var _={};return l(t,_),function(e){function a(a){var t=e.to_meter||1;return parseFloat(a,10)*t}"GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=parseFloat(e.UNIT.convert,10)*e.DATUM.SPHEROID.a):e.to_meter=parseFloat(e.UNIT.convert,10))),e.GEOGCS&&(e.GEOGCS.DATUM?e.datumCode=e.GEOGCS.DATUM.name.toLowerCase():e.datumCode=e.GEOGCS.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"===e.datumCode&&("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),e.GEOGCS.DATUM&&e.GEOGCS.DATUM.SPHEROID&&(e.ellps=e.GEOGCS.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=e.GEOGCS.DATUM.SPHEROID.a,e.rf=parseFloat(e.GEOGCS.DATUM.SPHEROID.rf,10)),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",i],["longitude_of_center","Longitude_Of_Center"],["longc","longitude_of_center",i],["x0","false_easting",a],["y0","false_northing",a],["long0","central_meridian",i],["lat0","latitude_of_origin",i],["lat0","standard_parallel_1",i],["lat1","standard_parallel_1",i],["lat2","standard_parallel_2",i],["alpha","azimuth",i],["srsCode","name"]].forEach(function(a){return t=e,n=(r=a)[0],o=r[1],void(!(n in t)&&o in t&&(t[n]=t[o],3===r.length&&(t[n]=r[2](t[n]))));var t,r,n,o}),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=i(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(_.output),n(a,_.output)}},
function _(n,r,i){r.exports=function(n,r){var i,o;if(n=n||{},!r)return n;for(o in r)void 0!==(i=r[o])&&(n[o]=i);return n}},
function _(n,o,t){var r=[n(42),n(48)],e={},a=[];function i(n,o){var t=a.length;return n.names?(a[t]=n,n.names.forEach(function(n){e[n.toLowerCase()]=t}),this):(console.log(o),!0)}t.add=i,t.get=function(n){if(!n)return!1;var o=n.toLowerCase();return void 0!==e[o]&&a[e[o]]?a[e[o]]:void 0},t.start=function(){r.forEach(i)}},
function _(t,s,i){var h=t(43),a=Math.PI/2,e=57.29577951308232,r=t(44),n=Math.PI/4,l=t(46),o=t(47);i.init=function(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=h(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)},i.forward=function(t){var s,i,h=t.x,o=t.y;if(o*e>90&&o*e<-90&&h*e>180&&h*e<-180)return null;if(Math.abs(Math.abs(o)-a)<=1e-10)return null;if(this.sphere)s=this.x0+this.a*this.k0*r(h-this.long0),i=this.y0+this.a*this.k0*Math.log(Math.tan(n+.5*o));else{var M=Math.sin(o),u=l(this.e,o,M);s=this.x0+this.a*this.k0*r(h-this.long0),i=this.y0-this.a*this.k0*Math.log(u)}return t.x=s,t.y=i,t},i.inverse=function(t){var s,i,h=t.x-this.x0,e=t.y-this.y0;if(this.sphere)i=a-2*Math.atan(Math.exp(-e/(this.a*this.k0)));else{var n=Math.exp(-e/(this.a*this.k0));if(-9999===(i=o(this.e,n)))return null}return s=r(this.long0+h/(this.a*this.k0)),t.x=s,t.y=i,t},i.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"]},
function _(t,n,r){n.exports=function(t,n,r){var o=t*n;return r/Math.sqrt(1-o*o)}},
function _(t,n,a){var r=2*Math.PI,o=t(45);n.exports=function(t){return Math.abs(t)<=3.14159265359?t:t-o(t)*r}},
function _(n,t,o){t.exports=function(n){return n<0?-1:1}},
function _(t,a,n){var r=Math.PI/2;a.exports=function(t,a,n){var o=t*n,h=.5*t;return o=Math.pow((1-o)/(1+o),h),Math.tan(.5*(r-a))/o}},
function _(a,t,n){var r=Math.PI/2;t.exports=function(a,t){for(var n,h,M=.5*a,o=r-2*Math.atan(t),e=0;e<=15;e++)if(n=a*Math.sin(o),o+=h=r-2*Math.atan(t*Math.pow((1-n)/(1+n),M))-o,Math.abs(h)<=1e-10)return o;return-9999}},
function _(n,i,t){function e(n){return n}t.init=function(){},t.forward=e,t.inverse=e,t.names=["longlat","identity"]},
function _(r,e,t){var n=r(50);t.eccentricity=function(r,e,t,n){var a=r*r,c=e*e,f=(a-c)/a,i=0;return n?(a=(r*=1-f*(.16666666666666666+f*(.04722222222222222+.022156084656084655*f)))*r,f=0):i=Math.sqrt(f),{es:f,e:i,ep2:(a-c)/c}},t.sphere=function(r,e,t,a,c){if(!r){var f=n[a];f||(f=n.WGS84),r=f.a,e=f.b,t=f.rf}return t&&!e&&(e=(1-1/t)*r),(0===t||Math.abs(r-e)<1e-10)&&(c=!0,e=r),{a:r,b:e,rf:t,sphere:c}}},
function _(e,a,l){l.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},l.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},l.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},l.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},l.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},l.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},l.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},l.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},l.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},l.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},l.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},l.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},l.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},l.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},l.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},l.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},l.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},l.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},l.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},l.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},l.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},l.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},l.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},l.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},l.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},l.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},l.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},l.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},l.hough={a:6378270,rf:297,ellipseName:"Hough"},l.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},l.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},l.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},l.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},l.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},l.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},l.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},l.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},l.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},l.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},l.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},l.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},l.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s){s.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},s.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},s.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},s.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},s.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},s.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},s.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},s.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},s.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},s.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},s.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},s.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},s.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},s.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},s.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},s.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,t){var p=1,u=2,r=4,_=5,d=484813681109536e-20;m.exports=function(a,m,t,s,e,n){var o={};return o.datum_type=r,a&&"none"===a&&(o.datum_type=_),m&&(o.datum_params=m.map(parseFloat),0===o.datum_params[0]&&0===o.datum_params[1]&&0===o.datum_params[2]||(o.datum_type=p),o.datum_params.length>3&&(0===o.datum_params[3]&&0===o.datum_params[4]&&0===o.datum_params[5]&&0===o.datum_params[6]||(o.datum_type=u,o.datum_params[3]*=d,o.datum_params[4]*=d,o.datum_params[5]*=d,o.datum_params[6]=o.datum_params[6]/1e6+1))),o.a=t,o.b=s,o.es=e,o.ep2=n,o}},
function _(t,e,r){var m=.017453292519943295,a=57.29577951308232,o=1,u=2,n=t(54),d=t(56),y=t(32),_=t(57);e.exports=function t(e,r,x){var i;return Array.isArray(x)&&(x=_(x)),e.datum&&r.datum&&function(t,e){return(t.datum.datum_type===o||t.datum.datum_type===u)&&"WGS84"!==e.datumCode||(e.datum.datum_type===o||e.datum.datum_type===u)&&"WGS84"!==t.datumCode}(e,r)&&(x=t(e,i=new y("WGS84"),x),e=i),"enu"!==e.axis&&(x=d(e,!1,x)),"longlat"===e.projName?x={x:x.x*m,y:x.y*m}:(e.to_meter&&(x={x:x.x*e.to_meter,y:x.y*e.to_meter}),x=e.inverse(x)),e.from_greenwich&&(x.x+=e.from_greenwich),x=n(e.datum,r.datum,x),r.from_greenwich&&(x={x:x.x-r.grom_greenwich,y:x.y}),"longlat"===r.projName?x={x:x.x*a,y:x.y*a}:(x=r.forward(x),r.to_meter&&(x={x:x.x/r.to_meter,y:x.y/r.to_meter})),"enu"!==r.axis?d(r,!0,x):x}},
function _(t,e,a){var u=1,m=2,o=t(55);function c(t){return t===u||t===m}e.exports=function(t,e,a){return o.compareDatums(t,e)?a:5===t.datum_type||5===e.datum_type?a:t.es!==e.es||t.a!==e.a||c(t.datum_type)||c(e.datum_type)?(a=o.geodeticToGeocentric(a,t.es,t.a),c(t.datum_type)&&(a=o.geocentricToWgs84(a,t.datum_type,t.datum_params)),c(e.datum_type)&&(a=o.geocentricFromWgs84(a,e.datum_type,e.datum_params)),o.geocentricToGeodetic(a,e.es,e.a,e.b)):a}},
function _(a,t,r){var m=Math.PI/2;r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(this.es-t.es)>5e-11)&&(1===a.datum_type?this.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:2!==a.datum_type||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var s,u,e,n,d=a.x,i=a.y,p=a.z?a.z:0;if(i<-m&&i>-1.001*m)i=-m;else if(i>m&&i<1.001*m)i=m;else if(i<-m||i>m)return null;return d>Math.PI&&(d-=2*Math.PI),u=Math.sin(i),n=Math.cos(i),e=u*u,{x:((s=r/Math.sqrt(1-t*e))+p)*n*Math.cos(d),y:(s+p)*n*Math.sin(d),z:(s*(1-t)+p)*u}},r.geocentricToGeodetic=function(a,t,r,s){var u,e,n,d,i,p,_,h,o,y,c,z,M,x,f,g=a.x,l=a.y,q=a.z?a.z:0;if(u=Math.sqrt(g*g+l*l),e=Math.sqrt(g*g+l*l+q*q),u/r<1e-12){if(x=0,e/r<1e-12)return m,f=-s,{x:a.x,y:a.y,z:a.z}}else x=Math.atan2(l,g);n=q/e,h=(d=u/e)*(1-t)*(i=1/Math.sqrt(1-t*(2-t)*d*d)),o=n*i,M=0;do{M++,p=t*(_=r/Math.sqrt(1-t*o*o))/(_+(f=u*h+q*o-_*(1-t*o*o))),z=(c=n*(i=1/Math.sqrt(1-p*(2-p)*d*d)))*h-(y=d*(1-p)*i)*o,h=y,o=c}while(z*z>1e-24&&M<30);return{x:x,y:Math.atan(c/Math.abs(y)),z:f}},r.geocentricToWgs84=function(a,t,r){if(1===t)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(2===t){var m=r[0],s=r[1],u=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+s,z:i*(-n*a.x+e*a.y+a.z)+u}}},r.geocentricFromWgs84=function(a,t,r){if(1===t)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(2===t){var m=r[0],s=r[1],u=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,_=(a.y-s)/i,h=(a.z-u)/i;return{x:p+d*_-n*h,y:-d*p+_+e*h,z:n*p-e*_+h}}}},
function _(e,a,r){a.exports=function(e,a,r){var s,c,i,n=r.x,o=r.y,t=r.z||0,u={};for(i=0;i<3;i++)if(!a||2!==i||void 0!==r.z)switch(0===i?(s=n,c="x"):1===i?(s=o,c="y"):(s=t,c="z"),e.axis[i]){case"e":u[c]=s;break;case"w":u[c]=-s;break;case"n":u[c]=s;break;case"s":u[c]=-s;break;case"u":void 0!==r[c]&&(u.z=s);break;case"d":void 0!==r[c]&&(u.z=-s);break;default:return null}return u}},
function _(n,t,e){t.exports=function(n){var t={x:n[0],y:n[1]};return n.length>2&&(t.z=n[2]),n.length>3&&(t.m=n[3]),t}},
function _(e,i,t){const n=e(59),r=e(63),s=e(18),_=e(64);class l extends n.DOMView{initialize(){super.initialize(),this.visuals=new r.Visuals(this.model),this._has_finished=!0}get plot_view(){return this.parent}get plot_model(){return this.parent.model}request_render(){this.plot_view.request_render()}map_to_screen(e,i){return this.plot_view.map_to_screen(e,i,this.model.x_range_name,this.model.y_range_name)}get needs_clip(){return!1}notify_finished(){this.plot_view.notify_finished()}get has_webgl(){return!1}}t.RendererView=l,l.__name__="RendererView";class d extends _.Model{constructor(e){super(e)}static init_Renderer(){this.define({level:[s.RenderLevel],visible:[s.Boolean,!0]})}}t.Renderer=d,d.__name__="Renderer",d.init_Renderer()},
function _(e,t,s){const i=e(60),r=e(61),n=e(62);class a extends i.View{initialize(){super.initialize(),this._has_finished=!1,this.el=this._createElement()}remove(){r.removeElement(this.el),super.remove()}css_classes(){return[]}cursor(e,t){return null}render(){}renderTo(e){e.appendChild(this.el),this.render()}has_finished(){return this._has_finished}get _root_element(){return r.parent(this.el,`.${n.bk_root}`)||document.body}get is_idle(){return this.has_finished()}_createElement(){return r.createElement(this.tagName,{class:this.css_classes()})}}s.DOMView=a,a.__name__="DOMView",a.prototype.tagName="div"},
function _(t,e,i){const n=t(13),o=t(7),r=t(25);class s extends(n.Signalable()){constructor(t){if(super(),this.removed=new n.Signal0(this,"removed"),null==t.model)throw new Error("model of a view wasn't configured");this.model=t.model,this._parent=t.parent,this.id=t.id||r.uniqueId(),this.initialize(),!1!==t.connect_signals&&this.connect_signals()}initialize(){}remove(){this._parent=void 0,this.disconnect_signals(),this.removed.emit()}toString(){return`${this.model.type}View(${this.id})`}serializable_state(){return{type:this.model.type}}get parent(){if(void 0!==this._parent)return this._parent;throw new Error("parent of a view wasn't configured")}get is_root(){return null===this.parent}get root(){return this.is_root?this:this.parent.root}assert_root(){if(!this.is_root)throw new Error(`${this.toString()} is not a root layout`)}connect_signals(){}disconnect_signals(){n.Signal.disconnectReceiver(this)}on_change(t,e){for(const i of o.isArray(t)?t:[t])this.connect(i.change,e)}}i.View=s,s.__name__="View"},
function _(t,e,n){const i=t(7),s=t=>(e={},...n)=>{const s=document.createElement(t);s.classList.add("bk");for(const t in e){let n=e[t];if(null!=n&&(!i.isBoolean(n)||n))if("class"===t&&(i.isString(n)&&(n=n.split(/\s+/)),i.isArray(n)))for(const t of n)null!=t&&s.classList.add(t);else if("style"===t&&i.isPlainObject(n))for(const t in n)s.style[t]=n[t];else if("data"===t&&i.isPlainObject(n))for(const t in n)s.dataset[t]=n[t];else s.setAttribute(t,n)}function o(t){if(t instanceof HTMLElement)s.appendChild(t);else if(i.isString(t))s.appendChild(document.createTextNode(t));else if(null!=t&&!1!==t)throw new Error(`expected an HTMLElement, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if(i.isArray(t))for(const e of t)o(e);else o(t);return s};function o(t,...e){const n=t.firstChild;for(const i of e)t.insertBefore(i,n)}function l(t,e){const n=Element.prototype;return(n.matches||n.webkitMatchesSelector||n.mozMatchesSelector||n.msMatchesSelector).call(t,e)}function r(t){return parseFloat(t)||0}function c(t){const e=getComputedStyle(t);return{border:{top:r(e.borderTopWidth),bottom:r(e.borderBottomWidth),left:r(e.borderLeftWidth),right:r(e.borderRightWidth)},margin:{top:r(e.marginTop),bottom:r(e.marginBottom),left:r(e.marginLeft),right:r(e.marginRight)},padding:{top:r(e.paddingTop),bottom:r(e.paddingBottom),left:r(e.paddingLeft),right:r(e.paddingRight)}}}function a(t){const e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}function h(t){return Array.from(t.children)}n.createElement=function(t,e,...n){return s(t)(e,...n)},n.div=s("div"),n.span=s("span"),n.canvas=s("canvas"),n.link=s("link"),n.style=s("style"),n.a=s("a"),n.p=s("p"),n.i=s("i"),n.pre=s("pre"),n.button=s("button"),n.label=s("label"),n.input=s("input"),n.select=s("select"),n.option=s("option"),n.optgroup=s("optgroup"),n.textarea=s("textarea"),n.nbsp=function(){return document.createTextNode(" ")},n.removeElement=function(t){const e=t.parentNode;null!=e&&e.removeChild(t)},n.replaceWith=function(t,e){const n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=o,n.empty=function(t){let e;for(;e=t.firstChild;)t.removeChild(e)},n.display=function(t){t.style.display=""},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset=function(t){const e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},n.matches=l,n.parent=function(t,e){let n=t;for(;n=n.parentElement;)if(l(n,e))return n;return null},n.extents=c,n.size=a,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){const{margin:{left:e,right:n,top:i,bottom:s}}=c(t),{width:o,height:l}=a(t);return{width:Math.ceil(o+e+n),height:Math.ceil(l+i+s)}},n.content_size=function(t){const{left:e,top:n}=t.getBoundingClientRect(),{padding:i}=c(t);let s=0,o=0;for(const l of h(t)){const t=l.getBoundingClientRect();s=Math.max(s,Math.ceil(t.left-e-i.left+t.width)),o=Math.max(o,Math.ceil(t.top-n-i.top+t.height))}return{width:s,height:o}},n.position=function(t,e,n){const{style:i}=t;if(i.left=`${e.x}px`,i.top=`${e.y}px`,i.width=`${e.width}px`,i.height=`${e.height}px`,null==n)i.margin="";else{const{top:t,right:e,bottom:s,left:o}=n;i.margin=`${t}px ${e}px ${s}px ${o}px`}},n.children=h;class d{constructor(t){this.el=t,this.classList=t.classList}get values(){const t=[];for(let e=0;e<this.classList.length;e++){const n=this.classList.item(e);null!=n&&t.push(n)}return t}has(t){return this.classList.contains(t)}add(...t){for(const e of t)this.classList.add(e);return this}remove(...t){for(const e of t)this.classList.remove(e);return this}clear(){for(const t of this.values)"bk"!=t&&this.classList.remove(t);return this}toggle(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this}}function u(t,e,n){const{width:i,height:s,position:o,display:l}=t.style;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?`${e.width}px`:"auto",t.style.height=null!=e.height&&e.height!=1/0?`${e.height}px`:"auto";try{return n()}finally{t.style.position=o,t.style.display=l,t.style.width=i,t.style.height=s}}n.ClassList=d,d.__name__="ClassList",n.classes=function(t){return new d(t)},function(t){t[t.Backspace=8]="Backspace",t[t.Tab=9]="Tab",t[t.Enter=13]="Enter",t[t.Esc=27]="Esc",t[t.PageUp=33]="PageUp",t[t.PageDown=34]="PageDown",t[t.Left=37]="Left",t[t.Up=38]="Up",t[t.Right=39]="Right",t[t.Down=40]="Down",t[t.Delete=46]="Delete"}(n.Keys||(n.Keys={})),n.undisplayed=function(t,e){const{display:n}=t.style;t.style.display="none";try{return e()}finally{t.style.display=n}},n.unsized=function(t,e){return u(t,{},e)},n.sized=u;class p{constructor(){this.style=n.style({type:"text/css"}),o(document.head,this.style)}append(t){this.style.appendChild(document.createTextNode(t))}}n.StyleSheet=p,p.__name__="StyleSheet",n.styles=new p},
function _(n,o,i){n(61).styles.append(".bk-root {\n  position: relative;\n  width: auto;\n  height: auto;\n  z-index: 0;\n  box-sizing: border-box;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: 10pt;\n}\n.bk-root .bk,\n.bk-root .bk:before,\n.bk-root .bk:after {\n  box-sizing: inherit;\n  margin: 0;\n  border: 0;\n  padding: 0;\n  background-image: none;\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.42857143;\n}\n.bk-root pre.bk {\n  font-family: Courier, monospace;\n}\n"),i.bk_root="bk-root"},
function _(e,t,a){const s=e(17),l=e(20);function c(e,t,a){e.moveTo(0,a+.5),e.lineTo(t,a+.5),e.stroke()}function i(e,t,a){e.moveTo(a+.5,0),e.lineTo(a+.5,t),e.stroke()}function h(e,t){e.moveTo(0,t),e.lineTo(t,0),e.stroke(),e.moveTo(0,0),e.lineTo(t,t),e.stroke()}function o(e,t,a,s){const l=a,o=l/2,n=o/2,r=function(e){const t=document.createElement("canvas");return t.width=e,t.height=e,t}(a),_=r.getContext("2d");switch(_.strokeStyle=t,_.lineCap="square",_.fillStyle=t,_.lineWidth=s,e){case" ":case"blank":break;case".":case"dot":_.arc(o,o,o/2,0,2*Math.PI,!0),_.fill();break;case"o":case"ring":_.arc(o,o,o/2,0,2*Math.PI,!0),_.stroke();break;case"-":case"horizontal_line":c(_,l,o);break;case"|":case"vertical_line":i(_,l,o);break;case"+":case"cross":c(_,l,o),i(_,l,o);break;case'"':case"horizontal_dash":c(_,o,o);break;case":":case"vertical_dash":i(_,o,o);break;case"@":case"spiral":const a=l/30;_.moveTo(o,o);for(let e=0;e<360;e++){const t=.1*e,s=o+a*t*Math.cos(t),l=o+a*t*Math.sin(t);_.lineTo(s,l)}_.stroke();break;case"/":case"right_diagonal_line":_.moveTo(.5-n,l),_.lineTo(n+.5,0),_.stroke(),_.moveTo(n+.5,l),_.lineTo(3*n+.5,0),_.stroke(),_.moveTo(3*n+.5,l),_.lineTo(5*n+.5,0),_.stroke(),_.stroke();break;case"\\":case"left_diagonal_line":_.moveTo(n+.5,l),_.lineTo(.5-n,0),_.stroke(),_.moveTo(3*n+.5,l),_.lineTo(n+.5,0),_.stroke(),_.moveTo(5*n+.5,l),_.lineTo(3*n+.5,0),_.stroke(),_.stroke();break;case"x":case"diagonal_cross":h(_,l);break;case",":case"right_diagonal_dash":_.moveTo(n+.5,3*n+.5),_.lineTo(3*n+.5,n+.5),_.stroke();break;case"`":case"left_diagonal_dash":_.moveTo(n+.5,n+.5),_.lineTo(3*n+.5,3*n+.5),_.stroke();break;case"v":case"horizontal_wave":_.moveTo(0,n),_.lineTo(o,3*n),_.lineTo(l,n),_.stroke();break;case">":case"vertical_wave":_.moveTo(n,0),_.lineTo(3*n,o),_.lineTo(n,l),_.stroke();break;case"*":case"criss_cross":h(_,l),c(_,l,o),i(_,l,o)}return r}class n{constructor(e,t=""){this.obj=e,this.prefix=t,this.cache={};for(const a of this.attrs)this[a]=e.properties[t+a]}warm_cache(e){for(const t of this.attrs){const a=this.obj.properties[this.prefix+t];if(void 0!==a.spec.value)this.cache[t]=a.spec.value;else{if(null==e)throw new Error("source is required with a vectorized visual property");this.cache[t+"_array"]=a.array(e)}}}cache_select(e,t){const a=this.obj.properties[this.prefix+e];let s;return void 0!==a.spec.value?this.cache[e]=s=a.spec.value:this.cache[e]=s=this.cache[e+"_array"][t],s}set_vectorize(e,t){null!=this.all_indices?this._set_vectorize(e,this.all_indices[t]):this._set_vectorize(e,t)}}a.ContextProperties=n,n.__name__="ContextProperties";class r extends n{set_value(e){e.strokeStyle=this.line_color.value(),e.globalAlpha=this.line_alpha.value(),e.lineWidth=this.line_width.value(),e.lineJoin=this.line_join.value(),e.lineCap=this.line_cap.value(),e.setLineDash(this.line_dash.value()),e.setLineDashOffset(this.line_dash_offset.value())}get doit(){return!(null===this.line_color.spec.value||0==this.line_alpha.spec.value||0==this.line_width.spec.value)}_set_vectorize(e,t){this.cache_select("line_color",t),e.strokeStyle!==this.cache.line_color&&(e.strokeStyle=this.cache.line_color),this.cache_select("line_alpha",t),e.globalAlpha!==this.cache.line_alpha&&(e.globalAlpha=this.cache.line_alpha),this.cache_select("line_width",t),e.lineWidth!==this.cache.line_width&&(e.lineWidth=this.cache.line_width),this.cache_select("line_join",t),e.lineJoin!==this.cache.line_join&&(e.lineJoin=this.cache.line_join),this.cache_select("line_cap",t),e.lineCap!==this.cache.line_cap&&(e.lineCap=this.cache.line_cap),this.cache_select("line_dash",t),e.getLineDash()!==this.cache.line_dash&&e.setLineDash(this.cache.line_dash),this.cache_select("line_dash_offset",t),e.getLineDashOffset()!==this.cache.line_dash_offset&&e.setLineDashOffset(this.cache.line_dash_offset)}color_value(){const[e,t,a,s]=l.color2rgba(this.line_color.value(),this.line_alpha.value());return`rgba(${255*e},${255*t},${255*a},${s})`}}a.Line=r,r.__name__="Line",r.prototype.attrs=Object.keys(s.line());class _ extends n{set_value(e){e.fillStyle=this.fill_color.value(),e.globalAlpha=this.fill_alpha.value()}get doit(){return!(null===this.fill_color.spec.value||0==this.fill_alpha.spec.value)}_set_vectorize(e,t){this.cache_select("fill_color",t),e.fillStyle!==this.cache.fill_color&&(e.fillStyle=this.cache.fill_color),this.cache_select("fill_alpha",t),e.globalAlpha!==this.cache.fill_alpha&&(e.globalAlpha=this.cache.fill_alpha)}color_value(){const[e,t,a,s]=l.color2rgba(this.fill_color.value(),this.fill_alpha.value());return`rgba(${255*e},${255*t},${255*a},${s})`}}a.Fill=_,_.__name__="Fill",_.prototype.attrs=Object.keys(s.fill());class p extends n{cache_select(e,t){let a;if("pattern"==e){this.cache_select("hatch_color",t),this.cache_select("hatch_scale",t),this.cache_select("hatch_pattern",t),this.cache_select("hatch_weight",t);const{hatch_color:e,hatch_scale:a,hatch_pattern:s,hatch_weight:l,hatch_extra:c}=this.cache;if(null!=c&&c.hasOwnProperty(s)){const t=c[s];this.cache.pattern=t.get_pattern(e,a,l)}else this.cache.pattern=(t=>{const c=o(s,e,a,l);return t.createPattern(c,"repeat")})}else a=super.cache_select(e,t);return a}_try_defer(e){const{hatch_pattern:t,hatch_extra:a}=this.cache;if(null!=a&&a.hasOwnProperty(t)){a[t].onload(e)}}get doit(){return!(null===this.hatch_color.spec.value||0==this.hatch_alpha.spec.value||" "==this.hatch_pattern.spec.value||"blank"==this.hatch_pattern.spec.value||null===this.hatch_pattern.spec.value)}doit2(e,t,a,s){if(!this.doit)return;this.cache_select("pattern",t),null==this.cache.pattern(e)?this._try_defer(s):(this.set_vectorize(e,t),a())}_set_vectorize(e,t){this.cache_select("pattern",t),e.fillStyle=this.cache.pattern(e),this.cache_select("hatch_alpha",t),e.globalAlpha!==this.cache.hatch_alpha&&(e.globalAlpha=this.cache.hatch_alpha)}color_value(){const[e,t,a,s]=l.color2rgba(this.hatch_color.value(),this.hatch_alpha.value());return`rgba(${255*e},${255*t},${255*a},${s})`}}a.Hatch=p,p.__name__="Hatch",p.prototype.attrs=Object.keys(s.hatch());class u extends n{cache_select(e,t){let a;if("font"==e){super.cache_select("text_font_style",t),super.cache_select("text_font_size",t),super.cache_select("text_font",t);const{text_font_style:e,text_font_size:s,text_font:l}=this.cache;this.cache.font=a=`${e} ${s} ${l}`}else a=super.cache_select(e,t);return a}font_value(){const e=this.text_font.value(),t=this.text_font_size.value();return this.text_font_style.value()+" "+t+" "+e}color_value(){const[e,t,a,s]=l.color2rgba(this.text_color.value(),this.text_alpha.value());return`rgba(${255*e},${255*t},${255*a},${s})`}set_value(e){e.font=this.font_value(),e.fillStyle=this.text_color.value(),e.globalAlpha=this.text_alpha.value(),e.textAlign=this.text_align.value(),e.textBaseline=this.text_baseline.value()}get doit(){return!(null===this.text_color.spec.value||0==this.text_alpha.spec.value)}_set_vectorize(e,t){this.cache_select("font",t),e.font!==this.cache.font&&(e.font=this.cache.font),this.cache_select("text_color",t),e.fillStyle!==this.cache.text_color&&(e.fillStyle=this.cache.text_color),this.cache_select("text_alpha",t),e.globalAlpha!==this.cache.text_alpha&&(e.globalAlpha=this.cache.text_alpha),this.cache_select("text_align",t),e.textAlign!==this.cache.text_align&&(e.textAlign=this.cache.text_align),this.cache_select("text_baseline",t),e.textBaseline!==this.cache.text_baseline&&(e.textBaseline=this.cache.text_baseline)}}a.Text=u,u.__name__="Text",u.prototype.attrs=Object.keys(s.text());class f{constructor(e){for(const t of e.mixins){const[a,s=""]=t.split(":");let l;switch(a){case"line":l=r;break;case"fill":l=_;break;case"hatch":l=p;break;case"text":l=u;break;default:throw new Error(`unknown visual: ${a}`)}this[s+a]=new l(e,s)}}warm_cache(e){for(const t in this)if(this.hasOwnProperty(t)){const a=this[t];a instanceof n&&a.warm_cache(e)}}set_all_indices(e){for(const t in this)if(this.hasOwnProperty(t)){const a=this[t];a instanceof n&&(a.all_indices=e)}}}a.Visuals=f,f.__name__="Visuals"},
function _(e,t,s){const n=e(12),c=e(18),a=e(7),i=e(22),r=e(65);class o extends n.HasProps{constructor(e){super(e)}static init_Model(){this.define({tags:[c.Array,[]],name:[c.String],js_property_callbacks:[c.Any,{}],js_event_callbacks:[c.Any,{}],subscribed_events:[c.Array,[]]})}connect_signals(){super.connect_signals(),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,()=>this._update_property_callbacks()),this.connect(this.properties.js_event_callbacks.change,()=>this._update_event_callbacks()),this.connect(this.properties.subscribed_events.change,()=>this._update_event_callbacks())}_process_event(e){for(const t of this.js_event_callbacks[e.event_name]||[])t.execute(e);null!=this.document&&this.subscribed_events.some(t=>t==e.event_name)&&this.document.event_manager.send_event(e)}trigger_event(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))}_update_event_callbacks(){null!=this.document?this.document.event_manager.subscribed_models.add(this.id):r.logger.warn("WARNING: Document not defined for updating event callbacks")}_update_property_callbacks(){const e=e=>{const[t,s=null]=e.split(":");return null!=s?this.properties[s][t]:this[t]};for(const t in this._js_callbacks){const s=this._js_callbacks[t],n=e(t);for(const e of s)this.disconnect(n,e)}this._js_callbacks={};for(const t in this.js_property_callbacks){const s=this.js_property_callbacks[t].map(e=>()=>e.execute(this));this._js_callbacks[t]=s;const n=e(t);for(const e of s)this.connect(n,e)}}_doc_attached(){i.isEmpty(this.js_event_callbacks)&&i.isEmpty(this.subscribed_events)||this._update_event_callbacks()}select(e){if(a.isString(e))return this.references().filter(t=>t instanceof o&&t.name===e);if(e.prototype instanceof n.HasProps)return this.references().filter(t=>t instanceof e);throw new Error("invalid selector")}select_one(e){const t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}}}s.Model=o,o.__name__="Model",o.init_Model()},
function _(e,l,o){const n=e(7),t={};class s{constructor(e,l){this.name=e,this.level=l}}o.LogLevel=s,s.__name__="LogLevel";class g{constructor(e,l=g.INFO){this._name=e,this.set_level(l)}static get levels(){return Object.keys(g.log_levels)}static get(e,l=g.INFO){if(e.length>0){let o=t[e];return null==o&&(t[e]=o=new g(e,l)),o}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")}get level(){return this.get_level()}get_level(){return this._log_level}set_level(e){if(e instanceof s)this._log_level=e;else{if(!n.isString(e)||null==g.log_levels[e])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=g.log_levels[e]}const l=`[${this._name}]`;for(const e in g.log_levels){g.log_levels[e].level<this._log_level.level||this._log_level.level===g.OFF.level?this[e]=function(){}:this[e]=r(e,l)}}trace(...e){}debug(...e){}info(...e){}warn(...e){}error(...e){}}function r(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}o.Logger=g,g.__name__="Logger",g.TRACE=new s("trace",0),g.DEBUG=new s("debug",1),g.INFO=new s("info",2),g.WARN=new s("warn",6),g.ERROR=new s("error",7),g.FATAL=new s("fatal",8),g.OFF=new s("off",9),g.log_levels={trace:g.TRACE,debug:g.DEBUG,info:g.INFO,warn:g.WARN,error:g.ERROR,fatal:g.FATAL,off:g.OFF},o.logger=g.get("bokeh"),o.set_log_level=function(e){null==g.log_levels[e]?(console.log(`[bokeh] unrecognized logging level '${e}' passed to Bokeh.set_log_level(), ignoring`),console.log(`[bokeh] valid log levels are: ${g.levels.join(", ")}`)):(console.log(`[bokeh] setting log level to: '${e}'`),o.logger.set_level(e))}},
function _(t,e,s){const i=t(29),a=t(67),n=t(68),r=t(18),o=t(9);class _ extends i.AnnotationView{initialize(){super.initialize(),null==this.model.source&&(this.model.source=new n.ColumnDataSource),this.set_data(this.model.source)}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.set_data(this.model.source)),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source))}set_data(t){super.set_data(t),this.visuals.warm_cache(t),this.plot_view.request_render()}_map_data(){const{frame:t}=this.plot_view;let e,s,i,a;return"data"==this.model.start_units?(e=t.xscales[this.model.x_range_name].v_compute(this._x_start),s=t.yscales[this.model.y_range_name].v_compute(this._y_start)):(e=t.xview.v_compute(this._x_start),s=t.yview.v_compute(this._y_start)),"data"==this.model.end_units?(i=t.xscales[this.model.x_range_name].v_compute(this._x_end),a=t.yscales[this.model.y_range_name].v_compute(this._y_end)):(i=t.xview.v_compute(this._x_end),a=t.yview.v_compute(this._y_end)),[[e,s],[i,a]]}render(){if(!this.model.visible)return;const{ctx:t}=this.plot_view.canvas_view;t.save();const[e,s]=this._map_data();null!=this.model.end&&this._arrow_head(t,"render",this.model.end,e,s),null!=this.model.start&&this._arrow_head(t,"render",this.model.start,s,e),t.beginPath();const{x:i,y:a,width:n,height:r}=this.plot_view.layout.bbox;t.rect(i,a,n,r),null!=this.model.end&&this._arrow_head(t,"clip",this.model.end,e,s),null!=this.model.start&&this._arrow_head(t,"clip",this.model.start,s,e),t.closePath(),t.clip(),this._arrow_body(t,e,s),t.restore()}_arrow_head(t,e,s,i,a){for(let n=0,r=this._x_start.length;n<r;n++){const r=Math.PI/2+o.atan2([i[0][n],i[1][n]],[a[0][n],a[1][n]]);t.save(),t.translate(a[0][n],a[1][n]),t.rotate(r),"render"==e?s.render(t,n):"clip"==e&&s.clip(t,n),t.restore()}}_arrow_body(t,e,s){if(this.visuals.line.doit)for(let i=0,a=this._x_start.length;i<a;i++)this.visuals.line.set_vectorize(t,i),t.beginPath(),t.moveTo(e[0][i],e[1][i]),t.lineTo(s[0][i],s[1][i]),t.stroke()}}s.ArrowView=_,_.__name__="ArrowView";class l extends i.Annotation{constructor(t){super(t)}static init_Arrow(){this.prototype.default_view=_,this.mixins(["line"]),this.define({x_start:[r.NumberSpec],y_start:[r.NumberSpec],start_units:[r.SpatialUnits,"data"],start:[r.Instance,null],x_end:[r.NumberSpec],y_end:[r.NumberSpec],end_units:[r.SpatialUnits,"data"],end:[r.Instance,()=>new a.OpenHead({})],source:[r.Instance],x_range_name:[r.String,"default"],y_range_name:[r.String,"default"]})}}s.Arrow=l,l.__name__="Arrow",l.init_Arrow()},
function _(i,e,s){const t=i(29),l=i(63),n=i(18);class o extends t.Annotation{constructor(i){super(i)}static init_ArrowHead(){this.define({size:[n.Number,25]})}initialize(){super.initialize(),this.visuals=new l.Visuals(this)}}s.ArrowHead=o,o.__name__="ArrowHead",o.init_ArrowHead();class h extends o{constructor(i){super(i)}static init_OpenHead(){this.mixins(["line"])}clip(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,0),i.lineTo(.5*this.size,this.size)}render(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.stroke())}}s.OpenHead=h,h.__name__="OpenHead",h.init_OpenHead();class a extends o{constructor(i){super(i)}static init_NormalHead(){this.mixins(["line","fill"]),this.override({fill_color:"black"})}clip(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(.5*this.size,this.size)}render(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._normal(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._normal(i,e),i.stroke())}_normal(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.closePath()}}s.NormalHead=a,a.__name__="NormalHead",a.init_NormalHead();class r extends o{constructor(i){super(i)}static init_VeeHead(){this.mixins(["line","fill"]),this.override({fill_color:"black"})}clip(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.lineTo(.5*this.size,this.size)}render(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._vee(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._vee(i,e),i.stroke())}_vee(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.closePath()}}s.VeeHead=r,r.__name__="VeeHead",r.init_VeeHead();class z extends o{constructor(i){super(i)}static init_TeeHead(){this.mixins(["line"])}render(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,0),i.lineTo(-.5*this.size,0),i.stroke())}clip(i,e){}}s.TeeHead=z,z.__name__="TeeHead",z.init_TeeHead()},
function _(t,n,e){const s=t(69),a=t(12),o=t(18),i=t(14),l=t(94),r=t(7),c=t(96),u=t(22),h=t(97);function _(t,n,e){if(r.isArray(t)){const s=t.concat(n);return null!=e&&s.length>e?s.slice(-e):s}if(r.isTypedArray(t)){const s=t.length+n.length;if(null!=e&&s>e){const a=s-e,o=t.length;let i;t.length<e?(i=new t.constructor(e)).set(t,0):i=t;for(let t=a,n=o;t<n;t++)i[t-a]=i[t];for(let t=0,e=n.length;t<e;t++)i[t+(o-a)]=n[t];return i}{const e=new t.constructor(n);return c.concat(t,e)}}throw new Error("unsupported array types")}function d(t,n){let e,s,a;return r.isNumber(t)?(e=t,a=t+1,s=1):(e=null!=t.start?t.start:0,a=null!=t.stop?t.stop:n,s=null!=t.step?t.step:1),[e,a,s]}function f(t,n,e){const s=new i.Set;let a=!1;for(const[o,i]of n){let n,l,c,u;if(r.isArray(o)){const[a]=o;s.add(a),l=e[a],n=t[a],u=i,2===o.length?(l=[1,l[0]],c=[o[0],0,o[1]]):c=o}else r.isNumber(o)?(u=[i],s.add(o)):(u=i,a=!0),c=[0,0,o],l=[1,t.length],n=t;let h=0;const[_,f,m]=d(c[1],l[0]),[p,g,y]=d(c[2],l[1]);for(let t=_;t<f;t+=m)for(let e=p;e<g;e+=y)a&&s.add(e),n[t*l[1]+e]=u[h],h++}return s}e.stream_to_column=_,e.slice=d,e.patch_to_column=f;class m extends s.ColumnarDataSource{constructor(t){super(t)}static init_ColumnDataSource(){this.define({data:[o.Any,{}]})}initialize(){super.initialize(),[this.data,this._shapes]=l.decode_column_data(this.data)}attributes_as_json(t=!0,n=m._value_to_json){const e={},s=this.serializable_attributes();for(const n of u.keys(s)){let a=s[n];"data"===n&&(a=l.encode_column_data(a,this._shapes)),t?e[n]=a:n in this._set_after_defaults&&(e[n]=a)}return n("attributes",e,this)}static _value_to_json(t,n,e){return r.isPlainObject(n)&&"data"===t?l.encode_column_data(n,e._shapes):a.HasProps._value_to_json(t,n,e)}stream(t,n,e){const{data:s}=this;for(const e in t)s[e]=_(s[e],t[e],n);if(this.setv({data:s},{silent:!0}),this.streaming.emit(),null!=this.document){const s=new h.ColumnsStreamedEvent(this.document,this.ref(),t,n);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:s})}}patch(t,n){const{data:e}=this;let s=new i.Set;for(const n in t){const a=t[n];s=s.union(f(e[n],a,this._shapes[n]))}if(this.setv({data:e},{silent:!0}),this.patching.emit(s.values),null!=this.document){const e=new h.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:n,hint:e})}}}e.ColumnDataSource=m,m.__name__="ColumnDataSource",m.init_ColumnDataSource()},
function _(t,n,e){const a=t(70),s=t(13),i=t(65),r=t(72),c=t(18),l=t(7),o=t(8),u=t(22),h=t(71),g=t(93);class _ extends a.DataSource{constructor(t){super(t)}get_array(t){let n=this.data[t];return null==n?this.data[t]=n=[]:l.isArray(n)||(this.data[t]=n=Array.from(n)),n}static init_ColumnarDataSource(){this.define({selection_policy:[c.Instance,()=>new g.UnionRenderers]}),this.internal({selection_manager:[c.Instance,t=>new r.SelectionManager({source:t})],inspected:[c.Instance,()=>new h.Selection],_shapes:[c.Any,{}]})}initialize(){super.initialize(),this._select=new s.Signal0(this,"select"),this.inspect=new s.Signal(this,"inspect"),this.streaming=new s.Signal0(this,"streaming"),this.patching=new s.Signal(this,"patching")}get_column(t){const n=this.data[t];return null!=n?n:null}columns(){return u.keys(this.data)}get_length(t=!0){const n=o.uniq(u.values(this.data).map(t=>t.length));switch(n.length){case 0:return null;case 1:return n[0];default:{const e="data source has columns of inconsistent lengths";if(t)return i.logger.warn(e),n.sort()[0];throw new Error(e)}}}get_indices(){const t=this.get_length();return o.range(0,null!=t?t:1)}clear(){const t={};for(const n of this.columns())t[n]=new this.data[n].constructor(0);this.data=t}}e.ColumnarDataSource=_,_.__name__="ColumnarDataSource",_.init_ColumnarDataSource()},
function _(e,c,t){const n=e(64),a=e(71),s=e(18);class i extends n.Model{constructor(e){super(e)}static init_DataSource(){this.define({selected:[s.Instance,()=>new a.Selection],callback:[s.Any]})}connect_signals(){super.connect_signals(),this.connect(this.selected.change,()=>{null!=this.callback&&this.callback.execute(this)})}}t.DataSource=i,i.__name__="DataSource",i.init_DataSource()},
function _(i,e,s){const t=i(64),n=i(18),h=i(8),l=i(22);class c extends t.Model{constructor(i){super(i)}static init_Selection(){this.define({indices:[n.Array,[]],line_indices:[n.Array,[]],multiline_indices:[n.Any,{}]}),this.internal({final:[n.Boolean],selected_glyphs:[n.Array,[]],get_view:[n.Any],image_indices:[n.Array,[]]})}initialize(){super.initialize(),this["0d"]={glyph:null,indices:[],flag:!1,get_view:()=>null},this["1d"]={indices:this.indices},this["2d"]={indices:{}},this.get_view=(()=>null),this.connect(this.properties.indices.change,()=>this["1d"].indices=this.indices),this.connect(this.properties.line_indices.change,()=>{this["0d"].indices=this.line_indices,this["0d"].flag=0!=this.line_indices.length}),this.connect(this.properties.selected_glyphs.change,()=>this["0d"].glyph=this.selected_glyph),this.connect(this.properties.get_view.change,()=>this["0d"].get_view=this.get_view),this.connect(this.properties.multiline_indices.change,()=>this["2d"].indices=this.multiline_indices)}get selected_glyph(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null}add_to_selected_glyphs(i){this.selected_glyphs.push(i)}update(i,e,s){this.final=e,s?this.update_through_union(i):(this.indices=i.indices,this.line_indices=i.line_indices,this.selected_glyphs=i.selected_glyphs,this.get_view=i.get_view,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices)}clear(){this.final=!0,this.indices=[],this.line_indices=[],this.multiline_indices={},this.get_view=(()=>null),this.selected_glyphs=[]}is_empty(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length}update_through_union(i){this.indices=h.union(i.indices,this.indices),this.selected_glyphs=h.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=h.union(i.line_indices,this.line_indices),this.get_view()||(this.get_view=i.get_view),this.multiline_indices=l.merge(i.multiline_indices,this.multiline_indices)}update_through_intersection(i){this.indices=h.intersection(i.indices,this.indices),this.selected_glyphs=h.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=h.union(i.line_indices,this.line_indices),this.get_view()||(this.get_view=i.get_view),this.multiline_indices=l.merge(i.multiline_indices,this.multiline_indices)}}s.Selection=c,c.__name__="Selection",c.init_Selection()},
function _(e,t,s){const i=e(12),n=e(71),o=e(73),c=e(90),r=e(18);class l extends i.HasProps{constructor(e){super(e),this.inspectors={}}static init_SelectionManager(){this.internal({source:[r.Any]})}select(e,t,s,i=!1){const n=[],r=[];for(const t of e)t instanceof o.GlyphRendererView?n.push(t):t instanceof c.GraphRendererView&&r.push(t);let l=!1;for(const e of r){const n=e.model.selection_policy.hit_test(t,e);l=l||e.model.selection_policy.do_selection(n,e.model,s,i)}if(n.length>0){const e=this.source.selection_policy.hit_test(t,n);l=l||this.source.selection_policy.do_selection(e,this.source,s,i)}return l}inspect(e,t){let s=!1;if(e instanceof o.GlyphRendererView){const i=e.hit_test(t);if(null!=i){s=!i.is_empty();const n=this.get_or_create_inspector(e.model);n.update(i,!0,!1),this.source.setv({inspected:n},{silent:!0}),this.source.inspect.emit([e,{geometry:t}])}}else if(e instanceof c.GraphRendererView){const i=e.model.inspection_policy.hit_test(t,e);s=s||e.model.inspection_policy.do_inspection(i,t,e,!1,!1)}return s}clear(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()}get_or_create_inspector(e){return null==this.inspectors[e.id]&&(this.inspectors[e.id]=new n.Selection),this.inspectors[e.id]}}s.SelectionManager=l,l.__name__="SelectionManager",l.init_SelectionManager()},
function _(e,t,i){const s=e(74),l=e(75),n=e(85),h=e(86),o=e(88),a=e(89),d=e(65),c=e(18),r=e(11),_=e(8),g=e(22),p=e(82),y={fill:{},line:{}},u={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},m={fill:{fill_alpha:.2},line:{}};class f extends s.DataRendererView{initialize(){super.initialize();const e=this.model.glyph,t=_.includes(e.mixins,"fill"),i=_.includes(e.mixins,"line"),s=g.clone(e.attributes);function l(l){const n=g.clone(s);return t&&g.extend(n,l.fill),i&&g.extend(n,l.line),new e.constructor(n)}delete s.id,this.glyph=this.build_glyph_view(e);let{selection_glyph:n}=this.model;null==n?n=l({fill:{},line:{}}):"auto"===n&&(n=l(y)),this.selection_glyph=this.build_glyph_view(n);let{nonselection_glyph:h}=this.model;null==h?h=l({fill:{},line:{}}):"auto"===h&&(h=l(m)),this.nonselection_glyph=this.build_glyph_view(h);const{hover_glyph:o}=this.model;null!=o&&(this.hover_glyph=this.build_glyph_view(o));const{muted_glyph:a}=this.model;null!=a&&(this.muted_glyph=this.build_glyph_view(a));const d=l(u);this.decimated_glyph=this.build_glyph_view(d),this.xscale=this.plot_view.frame.xscales[this.model.x_range_name],this.yscale=this.plot_view.frame.yscales[this.model.y_range_name],this.set_data(!1)}build_glyph_view(e){return new e.default_view({model:e,parent:this})}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render()),this.connect(this.model.glyph.change,()=>this.set_data()),this.connect(this.model.data_source.change,()=>this.set_data()),this.connect(this.model.data_source.streaming,()=>this.set_data()),this.connect(this.model.data_source.patching,e=>this.set_data(!0,e)),this.connect(this.model.data_source.selected.change,()=>this.request_render()),this.connect(this.model.data_source._select,()=>this.request_render()),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,()=>this.request_render()),this.connect(this.model.properties.view.change,()=>this.set_data()),this.connect(this.model.view.change,()=>this.set_data()),this.connect(this.model.properties.visible.change,()=>this.plot_view.update_dataranges());const{x_ranges:e,y_ranges:t}=this.plot_view.frame;for(const t in e){const i=e[t];i instanceof p.FactorRange&&this.connect(i.change,()=>this.set_data())}for(const e in t){const i=t[e];i instanceof p.FactorRange&&this.connect(i.change,()=>this.set_data())}this.connect(this.model.glyph.transformchange,()=>this.set_data())}have_selection_glyphs(){return null!=this.selection_glyph&&null!=this.nonselection_glyph}set_data(e=!0,t=null){const i=Date.now(),s=this.model.data_source;this.all_indices=this.model.view.indices,this.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.glyph.set_data(s,this.all_indices,t),this.glyph.set_visuals(s),this.decimated_glyph.set_visuals(s),this.have_selection_glyphs()&&(this.selection_glyph.set_visuals(s),this.nonselection_glyph.set_visuals(s)),null!=this.hover_glyph&&this.hover_glyph.set_visuals(s),null!=this.muted_glyph&&this.muted_glyph.set_visuals(s);const{lod_factor:l}=this.plot_model;this.decimated=[];for(let e=0,t=Math.floor(this.all_indices.length/l);e<t;e++)this.decimated.push(e*l);const n=Date.now()-i;d.logger.debug(`${this.glyph.model.type} GlyphRenderer (${this.model.id}): set_data finished in ${n}ms`),this.set_data_timestamp=Date.now(),e&&this.request_render()}get has_webgl(){return null!=this.glyph.glglyph}render(){if(!this.model.visible)return;const e=Date.now(),t=this.has_webgl;this.glyph.map_data();const i=Date.now()-e,s=Date.now();let a=this.glyph.mask_data(this.all_indices);a.length===this.all_indices.length&&(a=_.range(0,this.all_indices.length));const c=Date.now()-s,{ctx:g}=this.plot_view.canvas_view;g.save();const{selected:p}=this.model.data_source;let y;y=!p||p.is_empty()?[]:this.glyph instanceof l.LineView&&p.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(a):p.indices;const{inspected:u}=this.model.data_source,m=new Set((()=>!u||u.is_empty()?[]:u["0d"].glyph?this.model.view.convert_indices_from_subset(a):u["1d"].indices.length>0?u["1d"].indices:r.map(Object.keys(u["2d"].indices),e=>parseInt(e)))()),f=r.filter(a,e=>m.has(this.all_indices[e])),{lod_threshold:v}=this.plot_model;let w,b,x;null!=this.model.document&&this.model.document.interactive_duration()>0&&!t&&null!=v&&this.all_indices.length>v?(a=this.decimated,w=this.decimated_glyph,b=this.decimated_glyph,x=this.selection_glyph):(w=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,b=this.nonselection_glyph,x=this.selection_glyph),null!=this.hover_glyph&&f.length&&(a=_.difference(a,f));let D,R=null;if(y.length&&this.have_selection_glyphs()){const e=Date.now(),t={};for(const e of y)t[e]=!0;const i=new Array,s=new Array;if(this.glyph instanceof l.LineView)for(const e of this.all_indices)null!=t[e]?i.push(e):s.push(e);else for(const e of a)null!=t[this.all_indices[e]]?i.push(e):s.push(e);R=Date.now()-e,D=Date.now(),b.render(g,s,this.glyph),x.render(g,i,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof l.LineView?this.hover_glyph.render(g,this.model.view.convert_indices_from_subset(f),this.glyph):this.hover_glyph.render(g,f,this.glyph))}else if(D=Date.now(),this.glyph instanceof l.LineView)this.hover_glyph&&f.length?this.hover_glyph.render(g,this.model.view.convert_indices_from_subset(f),this.glyph):w.render(g,this.all_indices,this.glyph);else if(this.glyph instanceof n.PatchView||this.glyph instanceof h.HAreaView||this.glyph instanceof o.VAreaView)if(0==u.selected_glyphs.length||null==this.hover_glyph)w.render(g,this.all_indices,this.glyph);else for(const e of u.selected_glyphs)e.id==this.glyph.model.id&&this.hover_glyph.render(g,this.all_indices,this.glyph);else w.render(g,a,this.glyph),this.hover_glyph&&f.length&&this.hover_glyph.render(g,f,this.glyph);const V=Date.now()-D;this.last_dtrender=V;const $=Date.now()-e;d.logger.debug(`${this.glyph.model.type} GlyphRenderer (${this.model.id}): render finished in ${$}ms`),d.logger.trace(` - map_data finished in       : ${i}ms`),d.logger.trace(` - mask_data finished in      : ${c}ms`),null!=R&&d.logger.trace(` - selection mask finished in : ${R}ms`),d.logger.trace(` - glyph renders finished in  : ${V}ms`),g.restore()}draw_legend(e,t,i,s,l,n,h,o){null==o&&(o=this.model.get_reference_point(n,h)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:l},o)}hit_test(e){if(!this.model.visible)return null;const t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)}}i.GlyphRendererView=f,f.__name__="GlyphRendererView";class v extends s.DataRenderer{constructor(e){super(e)}static init_GlyphRenderer(){this.prototype.default_view=f,this.define({data_source:[c.Instance],view:[c.Instance,()=>new a.CDSView],glyph:[c.Instance],hover_glyph:[c.Instance],nonselection_glyph:[c.Any,"auto"],selection_glyph:[c.Any,"auto"],muted_glyph:[c.Instance],muted:[c.Boolean,!1]})}initialize(){super.initialize(),null==this.view.source&&(this.view.source=this.data_source,this.view.compute_indices())}get_reference_point(e,t){let i=0;if(null!=e){const s=this.data_source.get_column(e);if(null!=s){const e=r.indexOf(s,t);-1!=e&&(i=e)}}return i}get_selection_manager(){return this.data_source.selection_manager}}i.GlyphRenderer=v,v.__name__="GlyphRenderer",v.init_GlyphRenderer()},
function _(e,n,r){const a=e(58),t=e(18);class i extends a.RendererView{}r.DataRendererView=i,i.__name__="DataRendererView";class _ extends a.Renderer{constructor(e){super(e)}static init_DataRenderer(){this.define({x_range_name:[t.String,"default"],y_range_name:[t.String,"default"]}),this.override({level:"glyph"})}}r.DataRenderer=_,_.__name__="DataRenderer",_.init_DataRenderer()},
function _(e,t,i){const s=e(76),n=e(84),_=e(81);class l extends s.XYGlyphView{_render(e,t,{sx:i,sy:s}){let n=!1,_=null;this.visuals.line.set_value(e);for(const l of t){if(n){if(!isFinite(i[l]+s[l])){e.stroke(),e.beginPath(),n=!1,_=l;continue}null!=_&&l-_>1&&(e.stroke(),n=!1)}n?e.lineTo(i[l],s[l]):(e.beginPath(),e.moveTo(i[l],s[l]),n=!0),_=l}n&&e.stroke()}_hit_point(e){const t=_.create_empty_hit_test_result(),i={x:e.sx,y:e.sy};let s=9999;const n=Math.max(2,this.visuals.line.line_width.value()/2);for(let e=0,l=this.sx.length-1;e<l;e++){const l={x:this.sx[e],y:this.sy[e]},h={x:this.sx[e+1],y:this.sy[e+1]},r=_.dist_to_segment(i,l,h);r<n&&r<s&&(s=r,t.add_to_selected_glyphs(this.model),t.get_view=(()=>this),t.line_indices=[e])}return t}_hit_span(e){const{sx:t,sy:i}=e,s=_.create_empty_hit_test_result();let n,l;"v"==e.direction?(n=this.renderer.yscale.invert(i),l=this._y):(n=this.renderer.xscale.invert(t),l=this._x);for(let e=0,t=l.length-1;e<t;e++)(l[e]<=n&&n<=l[e+1]||l[e+1]<=n&&n<=l[e])&&(s.add_to_selected_glyphs(this.model),s.get_view=(()=>this),s.line_indices.push(e));return s}get_interpolation_hit(e,t){const[i,s,_,l]=[this._x[e],this._y[e],this._x[e+1],this._y[e+1]];return n.line_interpolation(this.renderer,t,i,s,_,l)}draw_legend_for_index(e,t,i){n.generic_line_legend(this.visuals,e,t,i)}}i.LineView=l,l.__name__="LineView";class h extends s.XYGlyph{constructor(e){super(e)}static init_Line(){this.prototype.default_view=l,this.mixins(["line"])}}i.Line=h,h.__name__="Line",h.init_Line()},
function _(t,s,e){const i=t(77),n=t(80);class h extends n.GlyphView{_index_data(){const t=[];for(let s=0,e=this._x.length;s<e;s++){const e=this._x[s],i=this._y[s];!isNaN(e+i)&&isFinite(e+i)&&t.push({x0:e,y0:i,x1:e,y1:i,i:s})}return new i.SpatialIndex(t)}scenterx(t){return this.sx[t]}scentery(t){return this.sy[t]}}e.XYGlyphView=h,h.__name__="XYGlyphView";class _ extends n.Glyph{constructor(t){super(t)}static init_XYGlyph(){this.coords([["x","y"]])}}e.XYGlyph=_,_.__name__="XYGlyph",_.init_XYGlyph()},
function _(n,i,t){const e=n(78),s=n(79);class x{constructor(n){if(this.points=n,this.index=null,n.length>0){this.index=new e(n.length);for(const i of n){const{x0:n,y0:t,x1:e,y1:s}=i;this.index.add(n,t,e,s)}this.index.finish()}}_normalize(n){let{x0:i,y0:t,x1:e,y1:s}=n;return i>e&&([i,e]=[e,i]),t>s&&([t,s]=[s,t]),{x0:i,y0:t,x1:e,y1:s}}get bbox(){if(null==this.index)return s.empty();{const{minX:n,minY:i,maxX:t,maxY:e}=this.index;return{x0:n,y0:i,x1:t,y1:e}}}search(n){if(null==this.index)return[];{const{x0:i,y0:t,x1:e,y1:s}=this._normalize(n);return this.index.search(i,t,e,s).map(n=>this.points[n])}}indices(n){return this.search(n).map(({i:n})=>n)}}t.SpatialIndex=x,x.__name__="SpatialIndex"},
function _(t,s,i){var e,h;e=this,h=function(){"use strict";var t=function(){this.ids=[],this.values=[],this.length=0};t.prototype.clear=function(){this.length=this.ids.length=this.values.length=0},t.prototype.push=function(t,s){this.ids.push(t),this.values.push(s);for(var i=this.length++;i>0;){var e=i-1>>1,h=this.values[e];if(s>=h)break;this.ids[i]=this.ids[e],this.values[i]=h,i=e}this.ids[i]=t,this.values[i]=s},t.prototype.pop=function(){if(0!==this.length){var t=this.ids[0];if(this.length--,this.length>0){for(var s=this.ids[0]=this.ids[this.length],i=this.values[0]=this.values[this.length],e=this.length>>1,h=0;h<e;){var r=1+(h<<1),n=r+1,o=this.ids[r],a=this.values[r],u=this.values[n];if(n<this.length&&u<a&&(r=n,o=this.ids[n],a=u),a>=i)break;this.ids[h]=o,this.values[h]=a,h=r}this.ids[h]=s,this.values[h]=i}return this.ids.pop(),this.values.pop(),t}},t.prototype.peek=function(){return this.ids[0]},t.prototype.peekValue=function(){return this.values[0]};var s=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array],i=function(i,e,h,r){if(void 0===e&&(e=16),void 0===h&&(h=Float64Array),void 0===i)throw new Error("Missing required argument: numItems.");if(isNaN(i)||i<=0)throw new Error("Unpexpected numItems value: "+i+".");this.numItems=+i,this.nodeSize=Math.min(Math.max(+e,2),65535);var n=i,o=n;this._levelBounds=[4*n];do{o+=n=Math.ceil(n/this.nodeSize),this._levelBounds.push(4*o)}while(1!==n);this.ArrayType=h||Float64Array,this.IndexArrayType=o<16384?Uint16Array:Uint32Array;var a=s.indexOf(this.ArrayType),u=4*o*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error("Unexpected typed array class: "+h+".");r&&r instanceof ArrayBuffer?(this.data=r,this._boxes=new this.ArrayType(this.data,8,4*o),this._indices=new this.IndexArrayType(this.data,8+u,o),this._pos=4*o,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+u+o*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*o),this._indices=new this.IndexArrayType(this.data,8+u,o),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=i),this._queue=new t};function e(t,s,i){return t<s?s-t:t<=i?0:t-i}function h(t,s){for(var i=0,e=s.length-1;i<e;){var h=i+e>>1;s[h]>t?e=h:i=h+1}return s[i]}function r(t,s,i,e,h){var r=t[e];t[e]=t[h],t[h]=r;var n=4*e,o=4*h,a=s[n],u=s[n+1],p=s[n+2],d=s[n+3];s[n]=s[o],s[n+1]=s[o+1],s[n+2]=s[o+2],s[n+3]=s[o+3],s[o]=a,s[o+1]=u,s[o+2]=p,s[o+3]=d;var _=i[e];i[e]=i[h],i[h]=_}function n(t,s){var i=t^s,e=65535^i,h=65535^(t|s),r=t&(65535^s),n=i|e>>1,o=i>>1^i,a=h>>1^e&r>>1^h,u=i&h>>1^r>>1^r;o=(i=n)&(e=o)>>2^e&(i^e)>>2,a^=i&(h=a)>>2^e&(r=u)>>2,u^=e&h>>2^(i^e)&r>>2,o=(i=n=i&i>>2^e&e>>2)&(e=o)>>4^e&(i^e)>>4,a^=i&(h=a)>>4^e&(r=u)>>4,u^=e&h>>4^(i^e)&r>>4,a^=(i=n=i&i>>4^e&e>>4)&(h=a)>>8^(e=o)&(r=u)>>8;var p=t^s,d=(e=(u^=e&h>>8^(i^e)&r>>8)^u>>1)|65535^(p|(i=a^a>>1));return((d=1431655765&((d=858993459&((d=252645135&((d=16711935&(d|d<<8))|d<<4))|d<<2))|d<<1))<<1|(p=1431655765&((p=858993459&((p=252645135&((p=16711935&(p|p<<8))|p<<4))|p<<2))|p<<1)))>>>0}return i.from=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");var e=new Uint8Array(t,0,2),h=e[0],r=e[1];if(251!==h)throw new Error("Data does not appear to be in a Flatbush format.");if(r>>4!=3)throw new Error("Got v"+(r>>4)+" data when expected v3.");var n=new Uint16Array(t,2,1)[0],o=new Uint32Array(t,4,1)[0];return new i(o,n,s[15&r],t)},i.prototype.add=function(t,s,i,e){var h=this._pos>>2;this._indices[h]=h,this._boxes[this._pos++]=t,this._boxes[this._pos++]=s,this._boxes[this._pos++]=i,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),s<this.minY&&(this.minY=s),i>this.maxX&&(this.maxX=i),e>this.maxY&&(this.maxY=e)},i.prototype.finish=function(){if(this._pos>>2!==this.numItems)throw new Error("Added "+(this._pos>>2)+" items when expected "+this.numItems+".");for(var t=this.maxX-this.minX,s=this.maxY-this.minY,i=new Uint32Array(this.numItems),e=0;e<this.numItems;e++){var h=4*e,o=this._boxes[h++],a=this._boxes[h++],u=this._boxes[h++],p=this._boxes[h++],d=Math.floor(65535*((o+u)/2-this.minX)/t),_=Math.floor(65535*((a+p)/2-this.minY)/s);i[e]=n(d,_)}!function t(s,i,e,h,n){if(h>=n)return;var o=s[h+n>>1];var a=h-1;var u=n+1;for(;;){do{a++}while(s[a]<o);do{u--}while(s[u]>o);if(a>=u)break;r(s,i,e,a,u)}t(s,i,e,h,u);t(s,i,e,u+1,n)}(i,this._boxes,this._indices,0,this.numItems-1);for(var f=0,l=0;f<this._levelBounds.length-1;f++)for(var v=this._levelBounds[f];l<v;){for(var x=1/0,y=1/0,m=-1/0,c=-1/0,b=l,w=0;w<this.nodeSize&&l<v;w++){var A=this._boxes[l++],g=this._boxes[l++],E=this._boxes[l++],I=this._boxes[l++];A<x&&(x=A),g<y&&(y=g),E>m&&(m=E),I>c&&(c=I)}this._indices[this._pos>>2]=b,this._boxes[this._pos++]=x,this._boxes[this._pos++]=y,this._boxes[this._pos++]=m,this._boxes[this._pos++]=c}},i.prototype.search=function(t,s,i,e,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var r=this._boxes.length-4,n=this._levelBounds.length-1,o=[],a=[];void 0!==r;){for(var u=Math.min(r+4*this.nodeSize,this._levelBounds[n]),p=r;p<u;p+=4){var d=0|this._indices[p>>2];i<this._boxes[p]||(e<this._boxes[p+1]||t>this._boxes[p+2]||s>this._boxes[p+3]||(r<4*this.numItems?(void 0===h||h(d))&&a.push(d):(o.push(d),o.push(n-1))))}n=o.pop(),r=o.pop()}return a},i.prototype.neighbors=function(t,s,i,r,n){if(void 0===i&&(i=1/0),void 0===r&&(r=1/0),this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var o=this._boxes.length-4,a=this._queue,u=[],p=r*r;void 0!==o;){for(var d=Math.min(o+4*this.nodeSize,h(o,this._levelBounds)),_=o;_<d;_+=4){var f=0|this._indices[_>>2],l=e(t,this._boxes[_],this._boxes[_+2]),v=e(s,this._boxes[_+1],this._boxes[_+3]),x=l*l+v*v;o<4*this.numItems?(void 0===n||n(f))&&a.push(-f-1,x):a.push(f,x)}for(;a.length&&a.peek()<0;){if(a.peekValue()>p)return a.clear(),u;if(u.push(-a.pop()-1),u.length===i)return a.clear(),u}o=a.pop()}return a.clear(),u},i},"object"==typeof i&&void 0!==s?s.exports=h():"function"==typeof define&&define.amd?define(h):(e=e||self).Flatbush=h()},
function _(t,i,e){const{min:h,max:r}=Math;e.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},e.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},e.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},e.union=function(t,i){return{x0:h(t.x0,i.x0),x1:r(t.x1,i.x1),y0:h(t.y0,i.y0),y1:r(t.y1,i.y1)}};class s{constructor(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){const{x0:i,y0:e,x1:h,y1:r}=t;if(!(i<=h&&e<=r))throw new Error(`invalid bbox {x0: ${i}, y0: ${e}, x1: ${h}, y1: ${r}}`);this.x0=i,this.y0=e,this.x1=h,this.y1=r}else if("x"in t){const{x:i,y:e,width:h,height:r}=t;if(!(h>=0&&r>=0))throw new Error(`invalid bbox {x: ${i}, y: ${e}, width: ${h}, height: ${r}}`);this.x0=i,this.y0=e,this.x1=i+h,this.y1=e+r}else{let i,e,h,r;if("width"in t)if("left"in t)e=(i=t.left)+t.width;else if("right"in t)i=(e=t.right)-t.width;else{const h=t.width/2;i=t.hcenter-h,e=t.hcenter+h}else i=t.left,e=t.right;if("height"in t)if("top"in t)r=(h=t.top)+t.height;else if("bottom"in t)h=(r=t.bottom)-t.height;else{const i=t.height/2;h=t.vcenter-i,r=t.vcenter+i}else h=t.top,r=t.bottom;if(!(i<=e&&h<=r))throw new Error(`invalid bbox {left: ${i}, top: ${h}, right: ${e}, bottom: ${r}}`);this.x0=i,this.y0=h,this.x1=e,this.y1=r}}toString(){return`BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`}get left(){return this.x0}get top(){return this.y0}get right(){return this.x1}get bottom(){return this.y1}get p0(){return[this.x0,this.y0]}get p1(){return[this.x1,this.y1]}get x(){return this.x0}get y(){return this.y0}get width(){return this.x1-this.x0}get height(){return this.y1-this.y0}get rect(){return{x0:this.x0,y0:this.y0,x1:this.x1,y1:this.y1}}get box(){return{x:this.x,y:this.y,width:this.width,height:this.height}}get h_range(){return{start:this.x0,end:this.x1}}get v_range(){return{start:this.y0,end:this.y1}}get ranges(){return[this.h_range,this.v_range]}get aspect(){return this.width/this.height}get hcenter(){return(this.left+this.right)/2}get vcenter(){return(this.top+this.bottom)/2}contains(t,i){return t>=this.x0&&t<=this.x1&&i>=this.y0&&i<=this.y1}clip(t,i){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),i<this.y0?i=this.y0:i>this.y1&&(i=this.y1),[t,i]}union(t){return new s({x0:h(this.x0,t.x0),y0:h(this.y0,t.y0),x1:r(this.x1,t.x1),y1:r(this.y1,t.y1)})}equals(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1}get xview(){return{compute:t=>this.left+t,v_compute:t=>{const i=new Float64Array(t.length),e=this.left;for(let h=0;h<t.length;h++)i[h]=e+t[h];return i}}}get yview(){return{compute:t=>this.bottom-t,v_compute:t=>{const i=new Float64Array(t.length),e=this.bottom;for(let h=0;h<t.length;h++)i[h]=e-t[h];return i}}}}e.BBox=s,s.__name__="BBox"},
function _(t,e,s){const n=t(81),i=t(18),r=t(79),a=t(30),_=t(63),o=t(60),l=t(64),h=t(65),c=t(11),d=t(22),y=t(7),p=t(75),u=t(82);class x extends o.View{constructor(){super(...arguments),this._nohit_warned={}}get renderer(){return this.parent}initialize(){super.initialize(),this._nohit_warned={},this.visuals=new _.Visuals(this.model);const{gl:e}=this.renderer.plot_view;if(null!=e){let s=null;try{s=t(352)}catch(t){if("MODULE_NOT_FOUND"!==t.code)throw t;h.logger.warn("WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering.")}if(null!=s){const t=s[this.model.type+"GLGlyph"];null!=t&&(this.glglyph=new t(e.ctx,this))}}}set_visuals(t){this.visuals.warm_cache(t),null!=this.glglyph&&this.glglyph.set_visuals_changed()}render(t,e,s){t.beginPath(),null!=this.glglyph&&this.glglyph.render(t,e,s)||this._render(t,e,s)}has_finished(){return!0}notify_finished(){this.renderer.notify_finished()}_bounds(t){return t}bounds(){return this._bounds(this.index.bbox)}log_bounds(){const t=r.empty(),e=this.index.search(r.positive_x());for(const s of e)s.x0<t.x0&&(t.x0=s.x0),s.x1>t.x1&&(t.x1=s.x1);const s=this.index.search(r.positive_y());for(const e of s)e.y0<t.y0&&(t.y0=e.y0),e.y1>t.y1&&(t.y1=e.y1);return this._bounds(t)}get_anchor_point(t,e,[s,n]){switch(t){case"center":return{x:this.scenterx(e,s,n),y:this.scentery(e,s,n)};default:return null}}sdist(t,e,s,n="edge",i=!1){let r,a;const _=e.length;if("center"==n){const t=c.map(s,t=>t/2);r=new Float64Array(_);for(let s=0;s<_;s++)r[s]=e[s]-t[s];a=new Float64Array(_);for(let s=0;s<_;s++)a[s]=e[s]+t[s]}else{r=e,a=new Float64Array(_);for(let t=0;t<_;t++)a[t]=r[t]+s[t]}const o=t.v_compute(r),l=t.v_compute(a);return i?c.map(o,(t,e)=>Math.ceil(Math.abs(l[e]-o[e]))):c.map(o,(t,e)=>Math.abs(l[e]-o[e]))}draw_legend_for_index(t,e,s){}hit_test(t){let e=null;const s=`_hit_${t.type}`;return null!=this[s]?e=this[s](t):null==this._nohit_warned[t.type]&&(h.logger.debug(`'${t.type}' selection not available for ${this.model.type}`),this._nohit_warned[t.type]=!0),e}_hit_rect_against_index(t){const{sx0:e,sx1:s,sy0:i,sy1:r}=t,[a,_]=this.renderer.xscale.r_invert(e,s),[o,l]=this.renderer.yscale.r_invert(i,r),h=n.create_empty_hit_test_result();return h.indices=this.index.indices({x0:a,x1:_,y0:o,y1:l}),h}set_data(t,e,s){let n=this.model.materialize_dataspecs(t);if(this.visuals.set_all_indices(e),e&&!(this instanceof p.LineView)){const t={};for(const s in n){const i=n[s];"_"===s.charAt(0)?t[s]=e.map(t=>i[t]):t[s]=i}n=t}const i=this;if(d.extend(i,n),this.renderer.plot_view.model.use_map&&(null!=i._x&&([i._x,i._y]=a.project_xy(i._x,i._y)),null!=i._xs&&([i._xs,i._ys]=a.project_xsys(i._xs,i._ys)),null!=i._x0&&([i._x0,i._y0]=a.project_xy(i._x0,i._y0)),null!=i._x1&&([i._x1,i._y1]=a.project_xy(i._x1,i._y1))),null!=this.renderer.plot_view.frame.x_ranges){const t=this.renderer.plot_view.frame.x_ranges[this.model.x_range_name],e=this.renderer.plot_view.frame.y_ranges[this.model.y_range_name];for(let[s,n]of this.model._coords)s=`_${s}`,n=`_${n}`,null!=i._xs?(t instanceof u.FactorRange&&(i[s]=c.map(i[s],e=>t.v_synthetic(e))),e instanceof u.FactorRange&&(i[n]=c.map(i[n],t=>e.v_synthetic(t)))):(t instanceof u.FactorRange&&(i[s]=t.v_synthetic(i[s])),e instanceof u.FactorRange&&(i[n]=e.v_synthetic(i[n])))}null!=this.glglyph&&this.glglyph.set_data_changed(i._x.length),this._set_data(s),this.index_data()}_set_data(t){}index_data(){this.index=this._index_data()}mask_data(t){return null!=this.glglyph||null==this._mask_data?t:this._mask_data()}map_data(){const t=this;for(let[e,s]of this.model._coords){const n=`s${e}`,i=`s${s}`;if(e=`_${e}`,s=`_${s}`,null!=t[e]&&(y.isArray(t[e][0])||y.isTypedArray(t[e][0]))){const r=t[e].length;t[n]=new Array(r),t[i]=new Array(r);for(let a=0;a<r;a++){const[r,_]=this.map_to_screen(t[e][a],t[s][a]);t[n][a]=r,t[i][a]=_}}else[t[n],t[i]]=this.map_to_screen(t[e],t[s])}this._map_data()}_map_data(){}map_to_screen(t,e){return this.renderer.plot_view.map_to_screen(t,e,this.model.x_range_name,this.model.y_range_name)}}s.GlyphView=x,x.__name__="GlyphView";class g extends l.Model{constructor(t){super(t)}static init_Glyph(){this.prototype._coords=[],this.internal({x_range_name:[i.String,"default"],y_range_name:[i.String,"default"]})}static coords(t){const e=this.prototype._coords.concat(t);this.prototype._coords=e;const s={};for(const[e,n]of t)s[e]=[i.CoordinateSpec],s[n]=[i.CoordinateSpec];this.define(s)}}s.Glyph=g,g.__name__="Glyph",g.init_Glyph()},
function _(t,n,e){const o=t(8),i=t(71);function s(t){return t*t}function r(t,n){return s(t.x-n.x)+s(t.y-n.y)}function c(t,n,e){const o=r(n,e);if(0==o)return r(t,n);const i=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/o;return r(t,i<0?n:i>1?e:{x:n.x+i*(e.x-n.x),y:n.y+i*(e.y-n.y)})}e.point_in_poly=function(t,n,e,o){let i=!1,s=e[e.length-1],r=o[o.length-1];for(let c=0;c<e.length;c++){const u=e[c],_=o[c];r<n!=_<n&&s+(n-r)/(_-r)*(u-s)<t&&(i=!i),s=u,r=_}return i},e.point_in_ellipse=function(t,n,e,o,i,s,r){const c=Math.pow(Math.cos(e)/i,2)+Math.pow(Math.sin(e)/o,2),u=2*Math.cos(e)*Math.sin(e)*(Math.pow(1/i,2)-Math.pow(1/o,2)),_=Math.pow(Math.cos(e)/o,2)+Math.pow(Math.sin(e)/i,2);return c*Math.pow(t-s,2)+u*(t-s)*(n-r)+_*Math.pow(n-r,2)<=1},e.create_empty_hit_test_result=function(){return new i.Selection},e.create_hit_test_result_from_hits=function(t){const n=new i.Selection;return n.indices=o.sort_by(t,([t,n])=>n).map(([t,n])=>t),n},e.dist_2_pts=r,e.dist_to_segment_squared=c,e.dist_to_segment=function(t,n,e){return Math.sqrt(c(t,n,e))},e.check_2_segments_intersect=function(t,n,e,o,i,s,r,c){const u=(c-s)*(e-t)-(r-i)*(o-n);if(0==u)return{hit:!1,x:null,y:null};{let _=n-s,h=t-i;const a=(r-i)*_-(c-s)*h;return h=((e-t)*_-(o-n)*h)/u,{hit:(_=a/u)>0&&_<1&&h>0&&h<1,x:t+_*(e-t),y:n+_*(o-n)}}}},
function _(t,n,i){const s=t(83),e=t(18),r=t(11),a=t(8),o=t(7);function p(t,n,i=0){const s={};for(let e=0;e<t.length;e++){const r=t[e];if(r in s)throw new Error(`duplicate factor or subfactor: ${r}`);s[r]={value:.5+e*(1+n)+i}}return[s,(t.length-1)*n]}function h(t,n,i,s=0){const e={},r={},o=[];for(const[n,i]of t)n in r||(r[n]=[],o.push(n)),r[n].push(i);let h=s,g=0;for(const t of o){const s=r[t].length,[o,c]=p(r[t],i,h);g+=c;const u=a.sum(r[t].map(t=>o[t].value));e[t]={value:u/s,mapping:o},h+=s+n+c}return[e,o,(o.length-1)*n+g]}function g(t,n,i,s,e=0){const r={},o={},p=[];for(const[n,i,s]of t)n in o||(o[n]=[],p.push(n)),o[n].push([i,s]);const g=[];let c=e,u=0;for(const t of p){const e=o[t].length,[p,l,d]=h(o[t],i,s,c);for(const n of l)g.push([t,n]);u+=d;const _=a.sum(o[t].map(([t])=>p[t].value));r[t]={value:_/e,mapping:p},c+=e+n+d}return[r,p,g,(p.length-1)*n+u]}i.map_one_level=p,i.map_two_levels=h,i.map_three_levels=g;class c extends s.Range{constructor(t){super(t)}static init_FactorRange(){this.define({factors:[e.Array,[]],factor_padding:[e.Number,0],subgroup_padding:[e.Number,.8],group_padding:[e.Number,1.4],range_padding:[e.Number,0],range_padding_units:[e.PaddingUnits,"percent"],start:[e.Number],end:[e.Number]}),this.internal({levels:[e.Number],mids:[e.Array],tops:[e.Array],tops_groups:[e.Array]})}get min(){return this.start}get max(){return this.end}initialize(){super.initialize(),this._init(!0)}connect_signals(){super.connect_signals(),this.connect(this.properties.factors.change,()=>this.reset()),this.connect(this.properties.factor_padding.change,()=>this.reset()),this.connect(this.properties.group_padding.change,()=>this.reset()),this.connect(this.properties.subgroup_padding.change,()=>this.reset()),this.connect(this.properties.range_padding.change,()=>this.reset()),this.connect(this.properties.range_padding_units.change,()=>this.reset())}reset(){this._init(!1),this.change.emit()}_lookup(t){if(1==t.length){const n=this._mapping;return n.hasOwnProperty(t[0])?n[t[0]].value:NaN}if(2==t.length){const n=this._mapping;return n.hasOwnProperty(t[0])&&n[t[0]].mapping.hasOwnProperty(t[1])?n[t[0]].mapping[t[1]].value:NaN}if(3==t.length){const n=this._mapping;return n.hasOwnProperty(t[0])&&n[t[0]].mapping.hasOwnProperty(t[1])&&n[t[0]].mapping[t[1]].mapping.hasOwnProperty(t[2])?n[t[0]].mapping[t[1]].mapping[t[2]].value:NaN}throw new Error("unreachable code")}synthetic(t){if(o.isNumber(t))return t;if(o.isString(t))return this._lookup([t]);let n=0;const i=t[t.length-1];return o.isNumber(i)&&(n=i,t=t.slice(0,-1)),this._lookup(t)+n}v_synthetic(t){return r.map(t,t=>this.synthetic(t))}_init(t){let n,i;if(a.every(this.factors,o.isString))n=1,[this._mapping,i]=p(this.factors,this.factor_padding);else if(a.every(this.factors,t=>o.isArray(t)&&2==t.length&&o.isString(t[0])&&o.isString(t[1])))n=2,[this._mapping,this.tops,i]=h(this.factors,this.group_padding,this.factor_padding);else{if(!a.every(this.factors,t=>o.isArray(t)&&3==t.length&&o.isString(t[0])&&o.isString(t[1])&&o.isString(t[2])))throw new Error("???");n=3,[this._mapping,this.tops,this.mids,i]=g(this.factors,this.group_padding,this.subgroup_padding,this.factor_padding)}let s=0,e=this.factors.length+i;if("percent"==this.range_padding_units){const t=(e-s)*this.range_padding/2;s-=t,e+=t}else s-=this.range_padding,e+=this.range_padding;this.setv({start:s,end:e,levels:n},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[s,e]},{silent:!0})}}i.FactorRange=c,c.__name__="FactorRange",c.init_FactorRange()},
function _(t,n,e){const i=t(64),a=t(18),s=t(7);class c extends i.Model{constructor(t){super(t),this.have_updated_interactively=!1}static init_Range(){this.define({callback:[a.Any],bounds:[a.Any],min_interval:[a.Any],max_interval:[a.Any]}),this.internal({plots:[a.Array,[]]})}connect_signals(){super.connect_signals(),this.connect(this.change,()=>this._emit_callback())}_emit_callback(){null!=this.callback&&(s.isFunction(this.callback)?this.callback(this):this.callback.execute(this,{}))}get is_reversed(){return this.start>this.end}}e.Range=c,c.__name__="Range",c.init_Range()},
function _(e,t,i){const n=e(81);i.generic_line_legend=function(e,t,{x0:i,x1:n,y0:c,y1:l},o){t.save(),t.beginPath(),t.moveTo(i,(c+l)/2),t.lineTo(n,(c+l)/2),e.line.doit&&(e.line.set_vectorize(t,o),t.stroke()),t.restore()},i.generic_area_legend=function(e,t,{x0:i,x1:n,y0:c,y1:l},o){const r=.1*Math.abs(n-i),a=.1*Math.abs(l-c),s=i+r,_=n-r,h=c+a,v=l-a;e.fill.doit&&(e.fill.set_vectorize(t,o),t.fillRect(s,h,_-s,v-h)),null!=e.hatch&&e.hatch.doit&&(e.hatch.set_vectorize(t,o),t.fillRect(s,h,_-s,v-h)),e.line&&e.line.doit&&(t.beginPath(),t.rect(s,h,_-s,v-h),e.line.set_vectorize(t,o),t.stroke())},i.line_interpolation=function(e,t,i,c,l,o){const{sx:r,sy:a}=t;let s,_,h,v;"point"==t.type?([h,v]=e.yscale.r_invert(a-1,a+1),[s,_]=e.xscale.r_invert(r-1,r+1)):"v"==t.direction?([h,v]=e.yscale.r_invert(a,a),[s,_]=[Math.min(i-1,l-1),Math.max(i+1,l+1)]):([s,_]=e.xscale.r_invert(r,r),[h,v]=[Math.min(c-1,o-1),Math.max(c+1,o+1)]);const{x:x,y:y}=n.check_2_segments_intersect(s,h,_,v,i,c,l,o);return[x,y]}},
function _(t,i,e){const s=t(76),l=t(84),_=t(81);class n extends s.XYGlyphView{_inner_loop(t,i,e,s,l){for(const _ of i)0!=_?isNaN(e[_]+s[_])?(t.closePath(),l.apply(t),t.beginPath()):t.lineTo(e[_],s[_]):(t.beginPath(),t.moveTo(e[_],s[_]));t.closePath(),l.call(t)}_render(t,i,{sx:e,sy:s}){this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner_loop(t,i,e,s,t.fill)),this.visuals.hatch.doit2(t,0,()=>this._inner_loop(t,i,e,s,t.fill),()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_value(t),this._inner_loop(t,i,e,s,t.stroke))}draw_legend_for_index(t,i,e){l.generic_area_legend(this.visuals,t,i,e)}_hit_point(t){const i=_.create_empty_hit_test_result();return _.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(i.add_to_selected_glyphs(this.model),i.get_view=(()=>this)),i}}e.PatchView=n,n.__name__="PatchView";class h extends s.XYGlyph{constructor(t){super(t)}static init_Patch(){this.prototype.default_view=n,this.mixins(["line","fill","hatch"])}}e.Patch=h,h.__name__="Patch",h.init_Patch()},
function _(e,t,s){const i=e(87),r=e(77),n=e(81),a=e(18);class h extends i.AreaView{_index_data(){const e=[];for(let t=0,s=this._x1.length;t<s;t++){const s=this._x1[t],i=this._x2[t],r=this._y[t];!isNaN(s+i+r)&&isFinite(s+i+r)&&e.push({x0:Math.min(s,i),y0:r,x1:Math.max(s,i),y1:r,i:t})}return new r.SpatialIndex(e)}_inner(e,t,s,i,r){e.beginPath();for(let s=0,r=t.length;s<r;s++)e.lineTo(t[s],i[s]);for(let t=s.length-1;t>=0;t--)e.lineTo(s[t],i[t]);e.closePath(),r.call(e)}_render(e,t,{sx1:s,sx2:i,sy:r}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner(e,s,i,r,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner(e,s,i,r,e.fill),()=>this.renderer.request_render())}_hit_point(e){const t=n.create_empty_hit_test_result(),s=this.sy.length,i=new Float64Array(2*s),r=new Float64Array(2*s);for(let e=0,t=s;e<t;e++)i[e]=this.sx1[e],r[e]=this.sy[e],i[s+e]=this.sx2[s-e-1],r[s+e]=this.sy[s-e-1];return n.point_in_poly(e.sx,e.sy,i,r)&&(t.add_to_selected_glyphs(this.model),t.get_view=(()=>this)),t}scenterx(e){return(this.sx1[e]+this.sx2[e])/2}scentery(e){return this.sy[e]}_map_data(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)}}s.HAreaView=h,h.__name__="HAreaView";class _ extends i.Area{constructor(e){super(e)}static init_HArea(){this.prototype.default_view=h,this.define({x1:[a.CoordinateSpec],x2:[a.CoordinateSpec],y:[a.CoordinateSpec]})}}s.HArea=_,_.__name__="HArea",_.init_HArea()},
function _(e,i,a){const _=e(80),n=e(84);class s extends _.GlyphView{draw_legend_for_index(e,i,a){n.generic_area_legend(this.visuals,e,i,a)}}a.AreaView=s,s.__name__="AreaView";class r extends _.Glyph{constructor(e){super(e)}static init_Area(){this.mixins(["fill","hatch"])}}a.Area=r,r.__name__="Area",r.init_Area()},
function _(e,t,s){const i=e(87),r=e(77),n=e(81),a=e(18);class h extends i.AreaView{_index_data(){const e=[];for(let t=0,s=this._x.length;t<s;t++){const s=this._x[t],i=this._y1[t],r=this._y2[t];!isNaN(s+i+r)&&isFinite(s+i+r)&&e.push({x0:s,y0:Math.min(i,r),x1:s,y1:Math.max(i,r),i:t})}return new r.SpatialIndex(e)}_inner(e,t,s,i,r){e.beginPath();for(let i=0,r=s.length;i<r;i++)e.lineTo(t[i],s[i]);for(let s=i.length-1;s>=0;s--)e.lineTo(t[s],i[s]);e.closePath(),r.call(e)}_render(e,t,{sx:s,sy1:i,sy2:r}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner(e,s,i,r,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner(e,s,i,r,e.fill),()=>this.renderer.request_render())}scenterx(e){return this.sx[e]}scentery(e){return(this.sy1[e]+this.sy2[e])/2}_hit_point(e){const t=n.create_empty_hit_test_result(),s=this.sx.length,i=new Float64Array(2*s),r=new Float64Array(2*s);for(let e=0,t=s;e<t;e++)i[e]=this.sx[e],r[e]=this.sy1[e],i[s+e]=this.sx[s-e-1],r[s+e]=this.sy2[s-e-1];return n.point_in_poly(e.sx,e.sy,i,r)&&(t.add_to_selected_glyphs(this.model),t.get_view=(()=>this)),t}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)}}s.VAreaView=h,h.__name__="VAreaView";class _ extends i.Area{constructor(e){super(e)}static init_VArea(){this.prototype.default_view=h,this.define({x:[a.CoordinateSpec],y1:[a.CoordinateSpec],y2:[a.CoordinateSpec]})}}s.VArea=_,_.__name__="VArea",_.init_VArea()},
function _(i,e,s){const t=i(64),n=i(18),c=i(71),o=i(8),r=i(69);class h extends t.Model{constructor(i){super(i)}static init_CDSView(){this.define({filters:[n.Array,[]],source:[n.Instance]}),this.internal({indices:[n.Array,[]],indices_map:[n.Any,{}]})}initialize(){super.initialize(),this.compute_indices()}connect_signals(){super.connect_signals(),this.connect(this.properties.filters.change,()=>{this.compute_indices(),this.change.emit()});const i=()=>{const i=()=>this.compute_indices();null!=this.source&&(this.connect(this.source.change,i),this.source instanceof r.ColumnarDataSource&&(this.connect(this.source.streaming,i),this.connect(this.source.patching,i)))};let e=null!=this.source;e?i():this.connect(this.properties.source.change,()=>{e||(i(),e=!0)})}compute_indices(){const i=this.filters.map(i=>i.compute_indices(this.source)).filter(i=>null!=i);i.length>0?this.indices=o.intersection.apply(this,i):this.source instanceof r.ColumnarDataSource&&(this.indices=this.source.get_indices()),this.indices_map_to_subset()}indices_map_to_subset(){this.indices_map={};for(let i=0;i<this.indices.length;i++)this.indices_map[this.indices[i]]=i}convert_selection_from_subset(i){const e=new c.Selection;e.update_through_union(i);const s=i.indices.map(i=>this.indices[i]);return e.indices=s,e.image_indices=i.image_indices,e}convert_selection_to_subset(i){const e=new c.Selection;e.update_through_union(i);const s=i.indices.map(i=>this.indices_map[i]);return e.indices=s,e.image_indices=i.image_indices,e}convert_indices_from_subset(i){return i.map(i=>this.indices[i])}}s.CDSView=h,h.__name__="CDSView",h.init_CDSView()},
function _(e,t,n){const s=e(74),r=e(91),a=e(18),i=e(92);class d extends s.DataRendererView{initialize(){super.initialize(),this.xscale=this.plot_view.frame.xscales.default,this.yscale=this.plot_view.frame.yscales.default,this._renderer_views={},[this.node_view,this.edge_view]=i.build_views(this._renderer_views,[this.model.node_renderer,this.model.edge_renderer],{parent:this.parent}),this.set_data()}connect_signals(){super.connect_signals(),this.connect(this.model.layout_provider.change,()=>this.set_data()),this.connect(this.model.node_renderer.data_source._select,()=>this.set_data()),this.connect(this.model.node_renderer.data_source.inspect,()=>this.set_data()),this.connect(this.model.node_renderer.data_source.change,()=>this.set_data()),this.connect(this.model.edge_renderer.data_source._select,()=>this.set_data()),this.connect(this.model.edge_renderer.data_source.inspect,()=>this.set_data()),this.connect(this.model.edge_renderer.data_source.change,()=>this.set_data());const{x_ranges:e,y_ranges:t}=this.plot_view.frame;for(const t in e){const n=e[t];this.connect(n.change,()=>this.set_data())}for(const e in t){const n=t[e];this.connect(n.change,()=>this.set_data())}}set_data(e=!0){this.node_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.edge_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0});const t=this.node_view.glyph;[t._x,t._y]=this.model.layout_provider.get_node_coordinates(this.model.node_renderer.data_source);const n=this.edge_view.glyph;[n._xs,n._ys]=this.model.layout_provider.get_edge_coordinates(this.model.edge_renderer.data_source),t.index_data(),n.index_data(),e&&this.request_render()}render(){this.edge_view.render(),this.node_view.render()}}n.GraphRendererView=d,d.__name__="GraphRendererView";class _ extends s.DataRenderer{constructor(e){super(e)}static init_GraphRenderer(){this.prototype.default_view=d,this.define({layout_provider:[a.Instance],node_renderer:[a.Instance],edge_renderer:[a.Instance],selection_policy:[a.Instance,()=>new r.NodesOnly],inspection_policy:[a.Instance,()=>new r.NodesOnly]})}get_selection_manager(){return this.node_renderer.data_source.selection_manager}}n.GraphRenderer=_,_.__name__="GraphRenderer",_.init_GraphRenderer()},
function _(e,t,n){const d=e(64),s=e(11),o=e(8),_=e(81);class i extends d.Model{constructor(e){super(e)}_hit_test_nodes(e,t){if(!t.model.visible)return null;const n=t.node_view.glyph.hit_test(e);return null==n?null:t.node_view.model.view.convert_selection_from_subset(n)}_hit_test_edges(e,t){if(!t.model.visible)return null;const n=t.edge_view.glyph.hit_test(e);return null==n?null:t.edge_view.model.view.convert_selection_from_subset(n)}}n.GraphHitTestPolicy=i,i.__name__="GraphHitTestPolicy";class r extends i{constructor(e){super(e)}hit_test(e,t){return this._hit_test_nodes(e,t)}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;return s.update(e,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.model.get_selection_manager().get_or_create_inspector(n.node_view.model);return o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!o.is_empty()}}n.NodesOnly=r,r.__name__="NodesOnly";class c extends i{constructor(e){super(e)}hit_test(e,t){return this._hit_test_nodes(e,t)}get_linked_edges(e,t,n){let d=[];"selection"==n?d=e.selected.indices.map(t=>e.data.index[t]):"inspection"==n&&(d=e.inspected.indices.map(t=>e.data.index[t]));const s=[];for(let e=0;e<t.data.start.length;e++)(o.contains(d,t.data.start[e])||o.contains(d,t.data.end[e]))&&s.push(e);const i=_.create_empty_hit_test_result();for(const e of s)i.multiline_indices[e]=[0];return i.indices=s,i}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,n,d);const o=t.edge_renderer.data_source.selected,_=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(_,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0});const _=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),i=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return _.update(i,d,s),n.edge_view.model.data_source.setv({inspected:_},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!o.is_empty()}}n.NodesAndLinkedEdges=c,c.__name__="NodesAndLinkedEdges";class a extends i{constructor(e){super(e)}hit_test(e,t){return this._hit_test_edges(e,t)}get_linked_nodes(e,t,n){let d=[];"selection"==n?d=t.selected.indices:"inspection"==n&&(d=t.inspected.indices);const i=[];for(const e of d)i.push(t.data.start[e]),i.push(t.data.end[e]);const r=o.uniq(i).map(t=>s.indexOf(e.data.index,t)),c=_.create_empty_hit_test_result();return c.indices=r,c}do_selection(e,t,n,d){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;s.update(e,n,d);const o=t.node_renderer.data_source.selected,_=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(_,n,d),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);o.update(e,d,s),n.edge_view.model.data_source.setv({inspected:o},{silent:!0});const _=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),i=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return _.update(i,d,s),n.node_view.model.data_source.setv({inspected:_},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view,{geometry:t}]),!o.is_empty()}}n.EdgesAndLinkedNodes=a,a.__name__="EdgesAndLinkedNodes"},
function _(e,n,o){const t=e(8);o.build_views=function(e,n,o,s=(e=>e.default_view)){const c=t.difference(Object.keys(e),n.map(e=>e.id));for(const n of c)e[n].remove(),delete e[n];const i=[],f=n.filter(n=>null==e[n.id]);for(const n of f){const t=new(s(n))(Object.assign(Object.assign({},o),{model:n,connect_signals:!1}));e[n.id]=t,i.push(t)}for(const e of i)e.connect_signals();return i},o.remove_views=function(e){for(const n in e)e[n].remove(),delete e[n]}},
function _(e,t,n){const s=e(64);class o extends s.Model{do_selection(e,t,n,s){return null!==e&&(t.selected.update(e,n,s),t._select.emit(),!t.selected.is_empty())}}n.SelectionPolicy=o,o.__name__="SelectionPolicy";class r extends o{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!==t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_intersection(t);return e}return null}}n.IntersectRenderers=r,r.__name__="IntersectRenderers";class c extends o{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!==t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_union(t);return e}return null}}n.UnionRenderers=c,c.__name__="UnionRenderers"},
function _(r,n,t){const e=r(7),a=r(95);function o(r){const n=new Uint8Array(r.buffer,r.byteOffset,2*r.length);for(let r=0,t=n.length;r<t;r+=2){const t=n[r];n[r]=n[r+1],n[r+1]=t}}function i(r){const n=new Uint8Array(r.buffer,r.byteOffset,4*r.length);for(let r=0,t=n.length;r<t;r+=4){let t=n[r];n[r]=n[r+3],n[r+3]=t,t=n[r+1],n[r+1]=n[r+2],n[r+2]=t}}function s(r){const n=new Uint8Array(r.buffer,r.byteOffset,8*r.length);for(let r=0,t=n.length;r<t;r+=8){let t=n[r];n[r]=n[r+7],n[r+7]=t,t=n[r+1],n[r+1]=n[r+6],n[r+6]=t,t=n[r+2],n[r+2]=n[r+5],n[r+5]=t,t=n[r+3],n[r+3]=n[r+4],n[r+4]=t}}function c(r,n){const e=r.order!==t.BYTE_ORDER,{shape:a}=r;let c=null;for(const t of n){if(JSON.parse(t[0]).id===r.__buffer__){c=t[1];break}}const f=new t.ARRAY_TYPES[r.dtype](c);return e&&(2===f.BYTES_PER_ELEMENT?o(f):4===f.BYTES_PER_ELEMENT?i(f):8===f.BYTES_PER_ELEMENT&&s(f)),[f,a]}function f(r,n){return e.isObject(r)&&"__ndarray__"in r?A(r):e.isObject(r)&&"__buffer__"in r?c(r,n):e.isArray(r)||e.isTypedArray(r)?[r,[]]:void 0}function u(r){const n=new Uint8Array(r),t=Array.from(n).map(r=>String.fromCharCode(r));return btoa(t.join(""))}function y(r){const n=atob(r),t=n.length,e=new Uint8Array(t);for(let r=0,a=t;r<a;r++)e[r]=n.charCodeAt(r);return e.buffer}function A(r){const n=y(r.__ndarray__),e=r.dtype,a=r.shape;let o;if(!(e in t.ARRAY_TYPES))throw new Error(`unknown dtype: ${e}`);return[o=new t.ARRAY_TYPES[e](n),a]}function l(r,n){const e=u(r.buffer),a=function(r){if("name"in r.constructor)return r.constructor.name;switch(!0){case r instanceof Uint8Array:return"Uint8Array";case r instanceof Int8Array:return"Int8Array";case r instanceof Uint16Array:return"Uint16Array";case r instanceof Int16Array:return"Int16Array";case r instanceof Uint32Array:return"Uint32Array";case r instanceof Int32Array:return"Int32Array";case r instanceof Float32Array:return"Float32Array";case r instanceof Float64Array:return"Float64Array";default:throw new Error("unsupported typed array")}}(r);let o;if(!(a in t.DTYPES))throw new Error(`unknown array type: ${a}`);return{__ndarray__:e,shape:n,dtype:o=t.DTYPES[a]}}function _(r,n){if(0==r.length||!e.isObject(r[0])&&!e.isArray(r[0]))return[r,[]];const t=[],a=[];for(const o of r){const[r,i]=e.isArray(o)?_(o,n):f(o,n);t.push(r),a.push(i)}return[t,a.map(r=>r.filter(r=>0!=r.length))]}function d(r,n){const t=[];for(let a=0,o=r.length;a<o;a++){const o=r[a];if(e.isTypedArray(o)){const r=n[a]?n[a]:void 0;t.push(l(o,r))}else e.isArray(o)?t.push(d(o,n?n[a]:[])):t.push(o)}return t}t.ARRAY_TYPES={uint8:Uint8Array,int8:Int8Array,uint16:Uint16Array,int16:Int16Array,uint32:Uint32Array,int32:Int32Array,float32:Float32Array,float64:Float64Array},t.DTYPES={Uint8Array:"uint8",Int8Array:"int8",Uint16Array:"uint16",Int16Array:"int16",Uint32Array:"uint32",Int32Array:"int32",Float32Array:"float32",Float64Array:"float64"},t.BYTE_ORDER=a.is_little_endian?"little":"big",t.swap16=o,t.swap32=i,t.swap64=s,t.process_buffer=c,t.process_array=f,t.arrayBufferToBase64=u,t.base64ToArrayBuffer=y,t.decode_base64=A,t.encode_base64=l,t.decode_column_data=function(r,n=[]){const t={},a={};for(const o in r){const i=r[o];if(e.isArray(i)){if(0==i.length||!e.isObject(i[0])&&!e.isArray(i[0])){t[o]=i;continue}const[r,s]=_(i,n);t[o]=r,a[o]=s}else{const[r,e]=f(i,n);t[o]=r,a[o]=e}}return[t,a]},t.encode_column_data=function(r,n){const t={};for(const a in r){const o=r[a],i=null!=n?n[a]:void 0;let s;s=e.isTypedArray(o)?l(o,i):e.isArray(o)?d(o,i||[]):o,t[a]=s}return t}},
function _(n,e,i){i.is_ie=(()=>{const n="undefined"!=typeof navigator?navigator.userAgent:"";return n.indexOf("MSIE")>=0||n.indexOf("Trident")>0||n.indexOf("Edge")>0})(),i.is_mobile=(()=>"undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0))(),i.is_little_endian=(()=>{const n=new ArrayBuffer(4),e=new Uint8Array(n);new Uint32Array(n)[1]=168496141;let i=!0;return 10==e[4]&&11==e[5]&&12==e[6]&&13==e[7]&&(i=!1),i})()},
function _(t,n,o){o.concat=function(t,...n){let o=t.length;for(const t of n)o+=t.length;const e=new t.constructor(o);e.set(t,0);let c=t.length;for(const t of n)e.set(t,c),c+=t.length;return e}},
function _(e,t,s){const n=e(12);class o{constructor(e){this.document=e}}s.DocumentChangedEvent=o,o.__name__="DocumentChangedEvent";class r extends o{constructor(e,t,s,n,o,r,d){super(e),this.model=t,this.attr=s,this.old=n,this.new_=o,this.setter_id=r,this.hint=d}json(e){if("id"===this.attr)throw new Error("'id' field should never change, whatever code just set it is wrong");if(null!=this.hint)return this.hint.json(e);const t=this.new_,s=n.HasProps._value_to_json(this.attr,t,this.model),o={};n.HasProps._value_record_references(t,o,!0),this.model.id in o&&this.model!==t&&delete o[this.model.id];for(const t in o)e[t]=o[t];return{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:s}}}s.ModelChangedEvent=r,r.__name__="ModelChangedEvent";class d extends o{constructor(e,t,s){super(e),this.column_source=t,this.patches=s}json(e){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}}}s.ColumnsPatchedEvent=d,d.__name__="ColumnsPatchedEvent";class i extends o{constructor(e,t,s,n){super(e),this.column_source=t,this.data=s,this.rollover=n}json(e){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}}}s.ColumnsStreamedEvent=i,i.__name__="ColumnsStreamedEvent";class h extends o{constructor(e,t,s){super(e),this.title=t,this.setter_id=s}json(e){return{kind:"TitleChanged",title:this.title}}}s.TitleChangedEvent=h,h.__name__="TitleChangedEvent";class l extends o{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}json(e){return n.HasProps._value_record_references(this.model,e,!0),{kind:"RootAdded",model:this.model.ref()}}}s.RootAddedEvent=l,l.__name__="RootAddedEvent";class c extends o{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}json(e){return{kind:"RootRemoved",model:this.model.ref()}}}s.RootRemovedEvent=c,c.__name__="RootRemovedEvent"},
function _(e,s,t){const i=e(29),_=e(68),o=e(18);class l extends i.AnnotationView{initialize(){super.initialize(),this.set_data(this.model.source)}connect_signals(){super.connect_signals(),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source)),this.connect(this.model.source.change,()=>this.set_data(this.model.source))}set_data(e){super.set_data(e),this.visuals.warm_cache(e),this.plot_view.request_render()}_map_data(){const{frame:e}=this.plot_view,s=this.model.dimension,t=e.xscales[this.model.x_range_name],i=e.yscales[this.model.y_range_name],_="height"==s?i:t,o="height"==s?t:i,l="height"==s?e.yview:e.xview,n="height"==s?e.xview:e.yview;let a,h,r;a="data"==this.model.properties.lower.units?_.v_compute(this._lower):l.v_compute(this._lower),h="data"==this.model.properties.upper.units?_.v_compute(this._upper):l.v_compute(this._upper),r="data"==this.model.properties.base.units?o.v_compute(this._base):n.v_compute(this._base);const[c,p]="height"==s?[1,0]:[0,1],u=[a,r],d=[h,r];this._lower_sx=u[c],this._lower_sy=u[p],this._upper_sx=d[c],this._upper_sy=d[p]}render(){if(!this.model.visible)return;this._map_data();const{ctx:e}=this.plot_view.canvas_view;e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,t=this._lower_sx.length;s<t;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);for(let s=this._upper_sx.length-1;s>=0;s--)e.lineTo(this._upper_sx[s],this._upper_sy[s]);e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(e),e.fill()),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,t=this._lower_sx.length;s<t;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke()),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(let s=0,t=this._upper_sx.length;s<t;s++)e.lineTo(this._upper_sx[s],this._upper_sy[s]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke())}}t.BandView=l,l.__name__="BandView";class n extends i.Annotation{constructor(e){super(e)}static init_Band(){this.prototype.default_view=l,this.mixins(["line","fill"]),this.define({lower:[o.DistanceSpec],upper:[o.DistanceSpec],base:[o.DistanceSpec],dimension:[o.Dimension,"height"],source:[o.Instance,()=>new _.ColumnDataSource],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}}t.Band=n,n.__name__="Band",n.init_Band()},
function _(t,e,i){const s=t(29),l=t(13),o=t(61),n=t(18),h=t(79),a=t(100);i.EDGE_TOLERANCE=2.5;class r extends s.AnnotationView{initialize(){super.initialize(),this.plot_view.canvas_overlays.appendChild(this.el),this.el.classList.add(a.bk_shading),o.undisplay(this.el)}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?(this.connect(this.model.change,()=>this.render()),this.connect(this.model.data_update,()=>this.render())):(this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.data_update,()=>this.plot_view.request_render()))}render(){if(this.model.visible||"css"!=this.model.render_mode||o.undisplay(this.el),!this.model.visible)return;if(null==this.model.left&&null==this.model.right&&null==this.model.top&&null==this.model.bottom)return void o.undisplay(this.el);const{frame:t}=this.plot_view,e=t.xscales[this.model.x_range_name],i=t.yscales[this.model.y_range_name],s=(t,e,i,s,l)=>{let o;return o=null!=t?this.model.screen?t:"data"==e?i.compute(t):s.compute(t):l};this.sleft=s(this.model.left,this.model.left_units,e,t.xview,t._left.value),this.sright=s(this.model.right,this.model.right_units,e,t.xview,t._right.value),this.stop=s(this.model.top,this.model.top_units,i,t.yview,t._top.value),this.sbottom=s(this.model.bottom,this.model.bottom_units,i,t.yview,t._bottom.value),("css"==this.model.render_mode?this._css_box.bind(this):this._canvas_box.bind(this))(this.sleft,this.sright,this.sbottom,this.stop)}_css_box(t,e,i,s){const l=this.model.properties.line_width.value(),n=Math.floor(e-t)-l,h=Math.floor(i-s)-l;this.el.style.left=`${t}px`,this.el.style.width=`${n}px`,this.el.style.top=`${s}px`,this.el.style.height=`${h}px`,this.el.style.borderWidth=`${l}px`,this.el.style.borderColor=this.model.properties.line_color.value(),this.el.style.backgroundColor=this.model.properties.fill_color.value(),this.el.style.opacity=this.model.properties.fill_alpha.value();const a=this.model.properties.line_dash.value().length<2?"solid":"dashed";this.el.style.borderStyle=a,o.display(this.el)}_canvas_box(t,e,i,s){const{ctx:l}=this.plot_view.canvas_view;l.save(),l.beginPath(),l.rect(t,s,e-t,i-s),this.visuals.fill.set_value(l),l.fill(),this.visuals.line.set_value(l),l.stroke(),l.restore()}interactive_bbox(){const t=this.model.properties.line_width.value()+i.EDGE_TOLERANCE;return new h.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})}interactive_hit(t,e){if(null==this.model.in_cursor)return!1;return this.interactive_bbox().contains(t,e)}cursor(t,e){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(e-this.sbottom)<3||Math.abs(e-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&e>this.stop&&e<this.sbottom?this.model.in_cursor:null}}i.BoxAnnotationView=r,r.__name__="BoxAnnotationView";class d extends s.Annotation{constructor(t){super(t)}static init_BoxAnnotation(){this.prototype.default_view=r,this.mixins(["line","fill"]),this.define({render_mode:[n.RenderMode,"canvas"],x_range_name:[n.String,"default"],y_range_name:[n.String,"default"],top:[n.Number,null],top_units:[n.SpatialUnits,"data"],bottom:[n.Number,null],bottom_units:[n.SpatialUnits,"data"],left:[n.Number,null],left_units:[n.SpatialUnits,"data"],right:[n.Number,null],right_units:[n.SpatialUnits,"data"]}),this.internal({screen:[n.Boolean,!1],ew_cursor:[n.String,null],ns_cursor:[n.String,null],in_cursor:[n.String,null]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}initialize(){super.initialize(),this.data_update=new l.Signal0(this,"data_update")}update({left:t,right:e,top:i,bottom:s}){this.setv({left:t,right:e,top:i,bottom:s,screen:!0},{silent:!0}),this.data_update.emit()}}i.BoxAnnotation=d,d.__name__="BoxAnnotation",d.init_BoxAnnotation()},
function _(n,o,a){n(62),n(61).styles.append(".bk-root .bk-shading {\n  position: absolute;\n  display: block;\n  border: 1px dashed green;\n}\n"),a.bk_annotation="bk-annotation",a.bk_shading="bk-shading",a.bk_annotation_child="bk-annotation-child"},
function _(t,e,i){const o=t(29),r=t(102),a=t(106),l=t(108),s=t(113),n=t(122),_=t(123),h=t(18),m=t(124),d=t(8),c=t(11),u=t(22),g=t(7),p=25,b=.3,f=.8;class w extends o.AnnotationView{initialize(){super.initialize(),this._set_canvas_image()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.visible.change,()=>this.plot_view.request_render()),this.connect(this.model.ticker.change,()=>this.plot_view.request_render()),this.connect(this.model.formatter.change,()=>this.plot_view.request_render()),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,()=>{this._set_canvas_image(),this.plot_view.request_render()})}_get_size(){if(null==this.model.color_mapper)return{width:0,height:0};{const{width:t,height:e}=this.compute_legend_dimensions();return{width:t,height:e}}}_set_canvas_image(){if(null==this.model.color_mapper)return;let t,e,{palette:i}=this.model.color_mapper;switch("vertical"==this.model.orientation&&(i=d.reversed(i)),this.model.orientation){case"vertical":[t,e]=[1,i.length];break;case"horizontal":[t,e]=[i.length,1];break;default:throw new Error("unreachable code")}const o=document.createElement("canvas");o.width=t,o.height=e;const r=o.getContext("2d"),a=r.getImageData(0,0,t,e),s=new l.LinearColorMapper({palette:i}).rgba_mapper.v_compute(d.range(0,i.length));a.data.set(s),r.putImageData(a,0,0),this.image=o}compute_legend_dimensions(){const t=this._computed_image_dimensions(),[e,i]=[t.height,t.width],o=this._get_label_extent(),r=this._title_extent(),a=this._tick_extent(),{padding:l}=this.model;let s,n;switch(this.model.orientation){case"vertical":s=e+r+2*l,n=i+a+o+2*l;break;case"horizontal":s=e+r+a+o+2*l,n=i+2*l;break;default:throw new Error("unreachable code")}return{width:n,height:s}}compute_legend_location(){const t=this.compute_legend_dimensions(),[e,i]=[t.height,t.width],o=this.model.margin,r=null!=this.panel?this.panel:this.plot_view.frame,[a,l]=r.bbox.ranges,{location:s}=this.model;let n,_;if(g.isString(s))switch(s){case"top_left":n=a.start+o,_=l.start+o;break;case"top_center":n=(a.end+a.start)/2-i/2,_=l.start+o;break;case"top_right":n=a.end-o-i,_=l.start+o;break;case"bottom_right":n=a.end-o-i,_=l.end-o-e;break;case"bottom_center":n=(a.end+a.start)/2-i/2,_=l.end-o-e;break;case"bottom_left":n=a.start+o,_=l.end-o-e;break;case"center_left":n=a.start+o,_=(l.end+l.start)/2-e/2;break;case"center":n=(a.end+a.start)/2-i/2,_=(l.end+l.start)/2-e/2;break;case"center_right":n=a.end-o-i,_=(l.end+l.start)/2-e/2;break;default:throw new Error("unreachable code")}else{if(!g.isArray(s)||2!=s.length)throw new Error("unreachable code");{const[t,i]=s;n=r.xview.compute(t),_=r.yview.compute(i)-e}}return{sx:n,sy:_}}render(){if(!this.model.visible||null==this.model.color_mapper)return;const{ctx:t}=this.plot_view.canvas_view;t.save();const{sx:e,sy:i}=this.compute_legend_location();t.translate(e,i),this._draw_bbox(t);const o=this._get_image_offset();if(t.translate(o.x,o.y),this._draw_image(t),null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high){const e=this.tick_info();this._draw_major_ticks(t,e),this._draw_minor_ticks(t,e),this._draw_major_labels(t,e)}this.model.title&&this._draw_title(t),t.restore()}_draw_bbox(t){const e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()}_draw_image(t){const e=this._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()}_draw_major_ticks(t,e){if(!this.visuals.major_tick_line.doit)return;const[i,o]=this._normals(),r=this._computed_image_dimensions(),[a,l]=[r.width*i,r.height*o],[s,n]=e.coords.major,_=this.model.major_tick_in,h=this.model.major_tick_out;t.save(),t.translate(a,l),this.visuals.major_tick_line.set_value(t);for(let e=0,r=s.length;e<r;e++)t.beginPath(),t.moveTo(Math.round(s[e]+i*h),Math.round(n[e]+o*h)),t.lineTo(Math.round(s[e]-i*_),Math.round(n[e]-o*_)),t.stroke();t.restore()}_draw_minor_ticks(t,e){if(!this.visuals.minor_tick_line.doit)return;const[i,o]=this._normals(),r=this._computed_image_dimensions(),[a,l]=[r.width*i,r.height*o],[s,n]=e.coords.minor,_=this.model.minor_tick_in,h=this.model.minor_tick_out;t.save(),t.translate(a,l),this.visuals.minor_tick_line.set_value(t);for(let e=0,r=s.length;e<r;e++)t.beginPath(),t.moveTo(Math.round(s[e]+i*h),Math.round(n[e]+o*h)),t.lineTo(Math.round(s[e]-i*_),Math.round(n[e]-o*_)),t.stroke();t.restore()}_draw_major_labels(t,e){if(!this.visuals.major_label_text.doit)return;const[i,o]=this._normals(),r=this._computed_image_dimensions(),[a,l]=[r.width*i,r.height*o],s=this.model.label_standoff+this._tick_extent(),[n,_]=[s*i,s*o],[h,m]=e.coords.major,d=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(a+n,l+_);for(let e=0,r=h.length;e<r;e++)t.fillText(d[e],Math.round(h[e]+i*this.model.label_standoff),Math.round(m[e]+o*this.model.label_standoff));t.restore()}_draw_title(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())}_get_label_extent(){const t=this.tick_info().labels.major;let e;if(null==this.model.color_mapper.low||null==this.model.color_mapper.high||u.isEmpty(t))e=0;else{const{ctx:i}=this.plot_view.canvas_view;switch(i.save(),this.visuals.major_label_text.set_value(i),this.model.orientation){case"vertical":e=d.max(t.map(t=>i.measureText(t.toString()).width));break;case"horizontal":e=m.measure_font(this.visuals.major_label_text.font_value()).height;break;default:throw new Error("unreachable code")}e+=this.model.label_standoff,i.restore()}return e}_get_image_offset(){return{x:this.model.padding,y:this.model.padding+this._title_extent()}}_normals(){return"vertical"==this.model.orientation?[1,0]:[0,1]}_title_extent(){const t=this.model.title_text_font+" "+this.model.title_text_font_size+" "+this.model.title_text_font_style;return this.model.title?m.measure_font(t).height+this.model.title_standoff:0}_tick_extent(){return null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high?d.max([this.model.major_tick_out,this.model.minor_tick_out]):0}_computed_image_dimensions(){const t=this.plot_view.frame._height.value,e=this.plot_view.frame._width.value,i=this._title_extent();let o,r;switch(this.model.orientation){case"vertical":"auto"==this.model.height?null!=this.panel?o=t-2*this.model.padding-i:(o=d.max([this.model.color_mapper.palette.length*p,t*b]),o=d.min([o,t*f-2*this.model.padding-i])):o=this.model.height,r="auto"==this.model.width?p:this.model.width;break;case"horizontal":o="auto"==this.model.height?p:this.model.height,"auto"==this.model.width?null!=this.panel?r=e-2*this.model.padding:(r=d.max([this.model.color_mapper.palette.length*p,e*b]),r=d.min([r,e*f-2*this.model.padding])):r=this.model.width;break;default:throw new Error("unreachable code")}return{width:r,height:o}}_tick_coordinate_scale(t){const e={source_range:new _.Range1d({start:this.model.color_mapper.low,end:this.model.color_mapper.high}),target_range:new _.Range1d({start:0,end:t})};switch(this.model.color_mapper.type){case"LinearColorMapper":return new s.LinearScale(e);case"LogColorMapper":return new n.LogScale(e);default:throw new Error("unreachable code")}}_format_major_labels(t,e){const i=this.model.formatter.doFormat(t,null);for(let t=0,o=e.length;t<o;t++)e[t]in this.model.major_label_overrides&&(i[t]=this.model.major_label_overrides[e[t]]);return i}tick_info(){const t=this._computed_image_dimensions();let e;switch(this.model.orientation){case"vertical":e=t.height;break;case"horizontal":e=t.width;break;default:throw new Error("unreachable code")}const i=this._tick_coordinate_scale(e),[o,r]=this._normals(),[a,l]=[this.model.color_mapper.low,this.model.color_mapper.high],s=this.model.ticker.get_ticks(a,l,null,null,this.model.ticker.desired_num_ticks),n=s.major,_=s.minor,h=[[],[]],m=[[],[]];for(let t=0,e=n.length;t<e;t++)n[t]<a||n[t]>l||(h[o].push(n[t]),h[r].push(0));for(let t=0,e=_.length;t<e;t++)_[t]<a||_[t]>l||(m[o].push(_[t]),m[r].push(0));const d={major:this._format_major_labels(h[o],n)},u={major:[[],[]],minor:[[],[]]};return u.major[o]=i.v_compute(h[o]),u.minor[o]=i.v_compute(m[o]),u.major[r]=h[r],u.minor[r]=m[r],"vertical"==this.model.orientation&&(u.major[o]=c.map(u.major[o],t=>e-t),u.minor[o]=c.map(u.minor[o],t=>e-t)),{coords:u,labels:d}}}i.ColorBarView=w,w.__name__="ColorBarView";class v extends o.Annotation{constructor(t){super(t)}static init_ColorBar(){this.prototype.default_view=w,this.mixins(["text:major_label_","text:title_","line:major_tick_","line:minor_tick_","line:border_","line:bar_","fill:background_"]),this.define({location:[h.Any,"top_right"],orientation:[h.Orientation,"vertical"],title:[h.String],title_standoff:[h.Number,2],width:[h.Any,"auto"],height:[h.Any,"auto"],scale_alpha:[h.Number,1],ticker:[h.Instance,()=>new r.BasicTicker],formatter:[h.Instance,()=>new a.BasicTickFormatter],major_label_overrides:[h.Any,{}],color_mapper:[h.Instance],label_standoff:[h.Number,5],margin:[h.Number,30],padding:[h.Number,10],major_tick_in:[h.Number,5],major_tick_out:[h.Number,0],minor_tick_in:[h.Number,0],minor_tick_out:[h.Number,0]}),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"8pt",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"10pt",title_text_font_style:"italic"})}}i.ColorBar=v,v.__name__="ColorBar",v.init_ColorBar()},
function _(c,e,s){const i=c(103);class n extends i.AdaptiveTicker{constructor(c){super(c)}}s.BasicTicker=n,n.__name__="BasicTicker"},
function _(t,i,a){const s=t(104),e=t(8),n=t(18);class r extends s.ContinuousTicker{constructor(t){super(t)}static init_AdaptiveTicker(){this.define({base:[n.Number,10],mantissas:[n.Array,[1,2,5]],min_interval:[n.Number,0],max_interval:[n.Number]})}initialize(){super.initialize();const t=e.nth(this.mantissas,-1)/this.base,i=e.nth(this.mantissas,0)*this.base;this.extended_mantissas=[t,...this.mantissas,i],this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()}get_interval(t,i,a){const s=i-t,n=this.get_ideal_interval(t,i,a),r=Math.floor(function(t,i=Math.E){return Math.log(t)/Math.log(i)}(n/this.base_factor,this.base)),h=Math.pow(this.base,r)*this.base_factor,_=this.extended_mantissas,m=_.map(t=>Math.abs(a-s/(t*h))),c=_[e.argmin(m)];return o=c*h,l=this.get_min_interval(),v=this.get_max_interval(),Math.max(l,Math.min(v,o));var o,l,v}}a.AdaptiveTicker=r,r.__name__="AdaptiveTicker",r.init_AdaptiveTicker()},
function _(t,i,n){const e=t(105),s=t(18),r=t(8),o=t(7);class _ extends e.Ticker{constructor(t){super(t)}static init_ContinuousTicker(){this.define({num_minor_ticks:[s.Number,5],desired_num_ticks:[s.Number,6]})}get_ticks(t,i,n,e,s){return this.get_ticks_no_defaults(t,i,e,this.desired_num_ticks)}get_ticks_no_defaults(t,i,n,e){const s=this.get_interval(t,i,e),_=Math.floor(t/s),c=Math.ceil(i/s);let u;const a=(u=o.isStrictNaN(_)||o.isStrictNaN(c)?[]:r.range(_,c+1)).map(t=>t*s).filter(n=>t<=n&&n<=i),l=this.num_minor_ticks,m=[];if(l>0&&a.length>0){const n=s/l,e=r.range(0,l).map(t=>t*n);for(const n of e.slice(1)){const e=a[0]-n;t<=e&&e<=i&&m.push(e)}for(const n of a)for(const s of e){const e=n+s;t<=e&&e<=i&&m.push(e)}}return{major:a,minor:m}}get_min_interval(){return this.min_interval}get_max_interval(){return null!=this.max_interval?this.max_interval:1/0}get_ideal_interval(t,i,n){return(i-t)/n}}n.ContinuousTicker=_,_.__name__="ContinuousTicker",_.init_ContinuousTicker()},
function _(c,e,n){const s=c(64);class o extends s.Model{constructor(c){super(c)}}n.Ticker=o,o.__name__="Ticker"},
function _(i,t,e){const r=i(107),s=i(18),o=i(7);class l extends r.TickFormatter{constructor(i){super(i),this.last_precision=3}static init_BasicTickFormatter(){this.define({precision:[s.Any,"auto"],use_scientific:[s.Boolean,!0],power_limit_high:[s.Number,5],power_limit_low:[s.Number,-3]})}get scientific_limit_low(){return Math.pow(10,this.power_limit_low)}get scientific_limit_high(){return Math.pow(10,this.power_limit_high)}doFormat(i,t){if(0==i.length)return[];let e=0;i.length>=2&&(e=Math.abs(i[1]-i[0])/1e4);let r=!1;if(this.use_scientific)for(const t of i){const i=Math.abs(t);if(i>e&&(i>=this.scientific_limit_high||i<=this.scientific_limit_low)){r=!0;break}}const s=new Array(i.length),{precision:l}=this;if(null==l||o.isNumber(l))if(r)for(let t=0,e=i.length;t<e;t++)s[t]=i[t].toExponential(l||void 0);else for(let t=0,e=i.length;t<e;t++)s[t]=i[t].toFixed(l||void 0).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");else for(let t=this.last_precision,e=this.last_precision<=15;e?t<=15:t>=15;e?t++:t--){let e=!0;if(r){for(let r=0,o=i.length;r<o;r++)if(s[r]=i[r].toExponential(t),r>0&&s[r]===s[r-1]){e=!1;break}if(e)break}else{for(let r=0,o=i.length;r<o;r++)if(s[r]=i[r].toFixed(t).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,""),r>0&&s[r]==s[r-1]){e=!1;break}if(e)break}if(e){this.last_precision=t;break}}return s}}e.BasicTickFormatter=l,l.__name__="BasicTickFormatter",l.init_BasicTickFormatter()},
function _(t,c,e){const o=t(64);class r extends o.Model{constructor(t){super(t)}}e.TickFormatter=r,r.__name__="TickFormatter"},
function _(o,n,l){const t=o(109),i=o(11);class e extends t.ContinuousColorMapper{constructor(o){super(o)}_v_compute(o,n,l,t){const{nan_color:e,low_color:r,high_color:s}=t,c=null!=this.low?this.low:i.min(o),h=null!=this.high?this.high:i.max(o),u=l.length-1,a=1/(h-c),_=1/l.length;for(let t=0,i=o.length;t<i;t++){const i=o[t];if(isNaN(i)){n[t]=e;continue}if(i==h){n[t]=l[u];continue}const p=(i-c)*a,g=Math.floor(p/_);n[t]=g<0?null!=r?r:l[0]:g>u?null!=s?s:l[u]:l[g]}}}l.LinearColorMapper=e,e.__name__="LinearColorMapper"},
function _(o,r,l){const i=o(110),s=o(18);class n extends i.ColorMapper{constructor(o){super(o)}static init_ContinuousColorMapper(){this.define({high:[s.Number],low:[s.Number],high_color:[s.Color],low_color:[s.Color]})}_colors(o){return Object.assign(Object.assign({},super._colors(o)),{low_color:null!=this.low_color?o(this.low_color):void 0,high_color:null!=this.high_color?o(this.high_color):void 0})}}l.ContinuousColorMapper=n,n.__name__="ContinuousColorMapper",n.init_ContinuousColorMapper()},
function _(t,e,n){const r=t(111),o=t(18),i=t(7),c=t(20),l=t(95);function _(t){return i.isNumber(t)?t:("#"!=t[0]&&(t=c.color2hex(t)),9!=t.length&&(t+="ff"),parseInt(t.slice(1),16))}function s(t){const e=new Uint32Array(t.length);for(let n=0,r=t.length;n<r;n++)e[n]=_(t[n]);return e}function a(t){if(l.is_little_endian){const e=new DataView(t.buffer);for(let n=0,r=t.length;n<r;n++)e.setUint32(4*n,t[n])}return new Uint8Array(t.buffer)}n._convert_color=_,n._convert_palette=s,n._uint32_to_rgba=a;class p extends r.Mapper{constructor(t){super(t)}static init_ColorMapper(){this.define({palette:[o.Any],nan_color:[o.Color,"gray"]})}v_compute(t){const e=new Array(t.length);return this._v_compute(t,e,this.palette,this._colors(t=>t)),e}get rgba_mapper(){const t=this,e=s(this.palette),n=this._colors(_);return{v_compute(r){const o=new Uint32Array(r.length);return t._v_compute(r,o,e,n),a(o)}}}_colors(t){return{nan_color:t(this.nan_color)}}}n.ColorMapper=p,p.__name__="ColorMapper",p.init_ColorMapper()},
function _(r,e,n){const s=r(112);class o extends s.Transform{constructor(r){super(r)}compute(r){throw new Error("mapping single values is not supported")}}n.Mapper=o,o.__name__="Mapper"},
function _(n,s,o){const r=n(64);class c extends r.Model{constructor(n){super(n)}}o.Transform=c,c.__name__="Transform"},
function _(t,e,r){const n=t(114);class s extends n.Scale{constructor(t){super(t)}compute(t){const[e,r]=this._compute_state();return e*t+r}v_compute(t){const[e,r]=this._compute_state(),n=new Float64Array(t.length);for(let s=0;s<t.length;s++)n[s]=e*t[s]+r;return n}invert(t){const[e,r]=this._compute_state();return(t-r)/e}v_invert(t){const[e,r]=this._compute_state(),n=new Float64Array(t.length);for(let s=0;s<t.length;s++)n[s]=(t[s]-r)/e;return n}_compute_state(){const t=this.source_range.start,e=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(e-t);return[n,-n*t+r]}}r.LinearScale=s,s.__name__="LinearScale"},
function _(t,e,r){const i=t(115),n=t(18);class s extends i.Transform{constructor(t){super(t)}static init_Scale(){this.internal({source_range:[n.Any],target_range:[n.Any]})}r_compute(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]}r_invert(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]}}r.Scale=s,s.__name__="Scale",s.init_Scale()},
function _(r,o,t){var a=r(116);t.CustomJSTransform=a.CustomJSTransform;var e=r(117);t.Dodge=e.Dodge;var n=r(118);t.Interpolator=n.Interpolator;var p=r(119);t.Jitter=p.Jitter;var v=r(120);t.LinearInterpolator=v.LinearInterpolator;var l=r(121);t.StepInterpolator=l.StepInterpolator;var m=r(112);t.Transform=m.Transform},
function _(t,s,r){const n=t(112),e=t(18),a=t(22),o=t(25);class u extends n.Transform{constructor(t){super(t)}static init_CustomJSTransform(){this.define({args:[e.Any,{}],func:[e.String,""],v_func:[e.String,""],use_strict:[e.Boolean,!1]})}get names(){return a.keys(this.args)}get values(){return a.values(this.args)}_make_transform(t,s){const r=this.use_strict?o.use_strict(s):s;return new Function(...this.names,t,"require","exports",r)}get scalar_transform(){return this._make_transform("x",this.func)}get vector_transform(){return this._make_transform("xs",this.v_func)}compute(s){return this.scalar_transform(...this.values,s,t,{})}v_compute(s){return this.vector_transform(...this.values,s,t,{})}}r.CustomJSTransform=u,u.__name__="CustomJSTransform",u.init_CustomJSTransform()},
function _(e,t,n){const r=e(112),s=e(82),i=e(18),o=e(7);class c extends r.Transform{constructor(e){super(e)}static init_Dodge(){this.define({value:[i.Number,0],range:[i.Instance]})}v_compute(e){let t;if(this.range instanceof s.FactorRange)t=this.range.v_synthetic(e);else{if(!o.isArrayableOf(e,o.isNumber))throw new Error("unexpected");t=e}const n=new Float64Array(t.length);for(let e=0;e<t.length;e++){const r=t[e];n[e]=this._compute(r)}return n}compute(e){if(this.range instanceof s.FactorRange)return this._compute(this.range.synthetic(e));if(o.isNumber(e))return this._compute(e);throw new Error("unexpected")}_compute(e){return e+this.value}}n.Dodge=c,c.__name__="Dodge",c.init_Dodge()},
function _(t,r,e){const s=t(112),o=t(18),n=t(8),i=t(7);class a extends s.Transform{constructor(t){super(t),this._sorted_dirty=!0}static init_Interpolator(){this.define({x:[o.Any],y:[o.Any],data:[o.Any],clip:[o.Boolean,!0]})}connect_signals(){super.connect_signals(),this.connect(this.change,()=>this._sorted_dirty=!0)}v_compute(t){const r=new Float64Array(t.length);for(let e=0;e<t.length;e++){const s=t[e];r[e]=this.compute(s)}return r}sort(t=!1){if(!this._sorted_dirty)return;let r,e;if(i.isString(this.x)&&i.isString(this.y)&&null!=this.data){const t=this.data.columns();if(!n.includes(t,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!n.includes(t,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");r=this.data.get_column(this.x),e=this.data.get_column(this.y)}else{if(!i.isArray(this.x)||!i.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");r=this.x,e=this.y}if(r.length!==e.length)throw new Error("The length for x and y do not match");if(r.length<2)throw new Error("x and y must have at least two elements to support interpolation");const s=[];for(const t in r)s.push({x:r[t],y:e[t]});t?s.sort((t,r)=>t.x>r.x?-1:t.x==r.x?0:1):s.sort((t,r)=>t.x<r.x?-1:t.x==r.x?0:1),this._x_sorted=[],this._y_sorted=[];for(const{x:t,y:r}of s)this._x_sorted.push(t),this._y_sorted.push(r);this._sorted_dirty=!1}}e.Interpolator=a,a.__name__="Interpolator",a.init_Interpolator()},
function _(t,e,i){const r=t(112),n=t(82),s=t(7),u=t(18),o=t(9);class a extends r.Transform{constructor(t){super(t)}static init_Jitter(){this.define({mean:[u.Number,0],width:[u.Number,1],distribution:[u.Distribution,"uniform"],range:[u.Instance]}),this.internal({previous_values:[u.Array]})}v_compute(t){if(null!=this.previous_values&&this.previous_values.length==t.length)return this.previous_values;let e;if(this.range instanceof n.FactorRange)e=this.range.v_synthetic(t);else{if(!s.isArrayableOf(t,s.isNumber))throw new Error("unexpected");e=t}const i=new Float64Array(e.length);for(let t=0;t<e.length;t++){const r=e[t];i[t]=this._compute(r)}return this.previous_values=i,i}compute(t){if(this.range instanceof n.FactorRange)return this._compute(this.range.synthetic(t));if(s.isNumber(t))return this._compute(t);throw new Error("unexpected")}_compute(t){switch(this.distribution){case"uniform":return t+this.mean+(o.random()-.5)*this.width;case"normal":return t+o.rnorm(this.mean,this.width)}}}i.Jitter=a,a.__name__="Jitter",a.init_Jitter()},
function _(t,s,_){const r=t(8),e=t(118);class i extends e.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];const s=r.find_last_index(this._x_sorted,s=>s<t),_=this._x_sorted[s],e=this._x_sorted[s+1],i=this._y_sorted[s],o=this._y_sorted[s+1];return i+(t-_)/(e-_)*(o-i)}}_.LinearInterpolator=i,i.__name__="LinearInterpolator"},
function _(t,e,s){const r=t(118),o=t(18),i=t(8);class _ extends r.Interpolator{constructor(t){super(t)}static init_StepInterpolator(){this.define({mode:[o.StepMode,"after"]})}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}let e;switch(this.mode){case"after":e=i.find_last_index(this._x_sorted,e=>t>=e);break;case"before":e=i.find_index(this._x_sorted,e=>t<=e);break;case"center":{const s=this._x_sorted.map(e=>Math.abs(e-t)),r=i.min(s);e=i.find_index(s,t=>r===t);break}default:throw new Error(`unknown mode: ${this.mode}`)}return-1!=e?this._y_sorted[e]:NaN}}s.StepInterpolator=_,_.__name__="StepInterpolator",_.init_StepInterpolator()},
function _(t,e,a){const o=t(114);class s extends o.Scale{constructor(t){super(t)}compute(t){const[e,a,o,s]=this._compute_state();let n;if(0==o)n=0;else{const r=(Math.log(t)-s)/o;n=isFinite(r)?r*e+a:NaN}return n}v_compute(t){const[e,a,o,s]=this._compute_state(),n=new Float64Array(t.length);if(0==o)for(let e=0;e<t.length;e++)n[e]=0;else for(let r=0;r<t.length;r++){const l=(Math.log(t[r])-s)/o;let h;h=isFinite(l)?l*e+a:NaN,n[r]=h}return n}invert(t){const[e,a,o,s]=this._compute_state(),n=(t-a)/e;return Math.exp(o*n+s)}v_invert(t){const[e,a,o,s]=this._compute_state(),n=new Float64Array(t.length);for(let r=0;r<t.length;r++){const l=(t[r]-a)/e;n[r]=Math.exp(o*l+s)}return n}_get_safe_factor(t,e){let a=t<0?0:t,o=e<0?0:e;if(a==o)if(0==a)[a,o]=[1,10];else{const t=Math.log(a)/Math.log(10);a=Math.pow(10,Math.floor(t)),o=Math.ceil(t)!=Math.floor(t)?Math.pow(10,Math.ceil(t)):Math.pow(10,Math.ceil(t)+1)}return[a,o]}_compute_state(){const t=this.source_range.start,e=this.source_range.end,a=this.target_range.start,o=this.target_range.end-a,[s,n]=this._get_safe_factor(t,e);let r,l;return 0==s?(r=Math.log(n),l=0):(r=Math.log(n)-Math.log(s),l=Math.log(s)),[o,a,r,l]}}a.LogScale=s,s.__name__="LogScale"},
function _(t,s,e){const i=t(83),n=t(18);class r extends i.Range{constructor(t){super(t)}static init_Range1d(){this.define({start:[n.Number,0],end:[n.Number,1],reset_start:[n.Number],reset_end:[n.Number]})}_set_auto_bounds(){if("auto"==this.bounds){const t=Math.min(this.reset_start,this.reset_end),s=Math.max(this.reset_start,this.reset_end);this.setv({bounds:[t,s]},{silent:!0})}}initialize(){super.initialize(),null==this.reset_start&&(this.reset_start=this.start),null==this.reset_end&&(this.reset_end=this.end),this._set_auto_bounds()}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}reset(){this._set_auto_bounds(),this.start!=this.reset_start||this.end!=this.reset_end?this.setv({start:this.reset_start,end:this.reset_end}):this.change.emit()}}e.Range1d=r,r.__name__="Range1d",r.init_Range1d()},
function _(t,e,n){const o=t(61),i={};n.measure_font=function(t){if(null!=i[t])return i[t];const e=o.span({style:{font:t}},"Hg"),n=o.div({style:{display:"inline-block",width:"1px",height:"0px"}}),l=o.div({},e,n);document.body.appendChild(l);try{n.style.verticalAlign="baseline";const s=o.offset(n).top-o.offset(e).top;n.style.verticalAlign="bottom";const d=o.offset(n).top-o.offset(e).top,c={height:d,ascent:s,descent:d-s};return i[t]=c,c}finally{document.body.removeChild(l)}};const l={};n.measure_text=function(t,e){const n=l[e];if(null!=n){const e=n[t];if(null!=e)return e}else l[e]={};const i=o.div({style:{display:"inline-block","white-space":"nowrap",font:e}},t);document.body.appendChild(i);try{const{width:n,height:o}=i.getBoundingClientRect();return l[e][t]={width:n,height:o},{width:n,height:o}}finally{document.body.removeChild(i)}}},
function _(e,t,i){const s=e(126),a=e(61),l=e(18);class n extends s.TextAnnotationView{initialize(){super.initialize(),this.visuals.warm_cache()}_get_size(){const{ctx:e}=this.plot_view.canvas_view;this.visuals.text.set_value(e);const{width:t,ascent:i}=e.measureText(this.model.text);return{width:t,height:i}}render(){if(this.model.visible||"css"!=this.model.render_mode||a.undisplay(this.el),!this.model.visible)return;let e;switch(this.model.angle_units){case"rad":e=-this.model.angle;break;case"deg":e=-this.model.angle*Math.PI/180;break;default:throw new Error("unreachable code")}const t=null!=this.panel?this.panel:this.plot_view.frame,i=this.plot_view.frame.xscales[this.model.x_range_name],s=this.plot_view.frame.yscales[this.model.y_range_name];let l="data"==this.model.x_units?i.compute(this.model.x):t.xview.compute(this.model.x),n="data"==this.model.y_units?s.compute(this.model.y):t.yview.compute(this.model.y);l+=this.model.x_offset,n-=this.model.y_offset,("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.plot_view.canvas_view.ctx,this.model.text,l,n,e)}}i.LabelView=n,n.__name__="LabelView";class o extends s.TextAnnotation{constructor(e){super(e)}static init_Label(){this.prototype.default_view=n,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[l.Number],x_units:[l.SpatialUnits,"data"],y:[l.Number],y_units:[l.SpatialUnits,"data"],text:[l.String],angle:[l.Angle,0],angle_units:[l.AngleUnits,"rad"],x_offset:[l.Number,0],y_offset:[l.Number,0],x_range_name:[l.String,"default"],y_range_name:[l.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})}}i.Label=o,o.__name__="Label",o.init_Label()},
function _(e,t,s){const i=e(29),l=e(61),a=e(18),n=e(124),o=e(100);class r extends i.AnnotationView{constructor(){super(...arguments),this.rotate=!0}initialize(){super.initialize(),"css"==this.model.render_mode&&(this.el.classList.add(o.bk_annotation),this.plot_view.canvas_overlays.appendChild(this.el))}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?this.connect(this.model.change,()=>this.render()):this.connect(this.model.change,()=>this.plot_view.request_render())}_calculate_text_dimensions(e,t){const{width:s}=e.measureText(t),{height:i}=n.measure_font(this.visuals.text.font_value());return[s,i]}_calculate_bounding_box_dimensions(e,t){const[s,i]=this._calculate_text_dimensions(e,t);let l,a;switch(e.textAlign){case"left":l=0;break;case"center":l=-s/2;break;case"right":l=-s;break;default:throw new Error("unreachable code")}switch(e.textBaseline){case"top":a=0;break;case"middle":a=-.5*i;break;case"bottom":a=-1*i;break;case"alphabetic":a=-.8*i;break;case"hanging":a=-.17*i;break;case"ideographic":a=-.83*i;break;default:throw new Error("unreachable code")}return[l,a,s,i]}_canvas_text(e,t,s,i,l){this.visuals.text.set_value(e);const a=this._calculate_bounding_box_dimensions(e,t);e.save(),e.beginPath(),e.translate(s,i),l&&e.rotate(l),e.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(e),e.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(e),e.fillText(t,0,0)),e.restore()}_css_text(e,t,s,i,a){l.undisplay(this.el),this.visuals.text.set_value(e);const n=this._calculate_bounding_box_dimensions(e,t),o=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_value(e),this.visuals.background_fill.set_value(e),this.el.style.position="absolute",this.el.style.left=`${s+n[0]}px`,this.el.style.top=`${i+n[1]}px`,this.el.style.color=`${this.visuals.text.text_color.value()}`,this.el.style.opacity=`${this.visuals.text.text_alpha.value()}`,this.el.style.font=`${this.visuals.text.font_value()}`,this.el.style.lineHeight="normal",a&&(this.el.style.transform=`rotate(${a}rad)`),this.visuals.background_fill.doit&&(this.el.style.backgroundColor=`${this.visuals.background_fill.color_value()}`),this.visuals.border_line.doit&&(this.el.style.borderStyle=`${o}`,this.el.style.borderWidth=`${this.visuals.border_line.line_width.value()}px`,this.el.style.borderColor=`${this.visuals.border_line.color_value()}`),this.el.textContent=t,l.display(this.el)}}s.TextAnnotationView=r,r.__name__="TextAnnotationView";class h extends i.Annotation{constructor(e){super(e)}static init_TextAnnotation(){this.define({render_mode:[a.RenderMode,"canvas"]})}}s.TextAnnotation=h,h.__name__="TextAnnotation",h.init_TextAnnotation()},
function _(t,e,s){const i=t(126),l=t(68),o=t(61),a=t(18),n=t(100);class r extends i.TextAnnotationView{initialize(){if(super.initialize(),this.set_data(this.model.source),"css"==this.model.render_mode)for(let t=0,e=this._text.length;t<e;t++){const t=o.div({class:n.bk_annotation_child,style:{display:"none"}});this.el.appendChild(t)}}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?(this.connect(this.model.change,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.streaming,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.patching,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.change,()=>{this.set_data(this.model.source),this.render()})):(this.connect(this.model.change,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.streaming,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.patching,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.change,()=>{this.set_data(this.model.source),this.plot_view.request_render()}))}set_data(t){super.set_data(t),this.visuals.warm_cache(t)}_map_data(){const t=this.plot_view.frame.xscales[this.model.x_range_name],e=this.plot_view.frame.yscales[this.model.y_range_name],s=null!=this.panel?this.panel:this.plot_view.frame;return["data"==this.model.x_units?t.v_compute(this._x):s.xview.v_compute(this._x),"data"==this.model.y_units?e.v_compute(this._y):s.yview.v_compute(this._y)]}render(){if(this.model.visible||"css"!=this.model.render_mode||o.undisplay(this.el),!this.model.visible)return;const t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),{ctx:e}=this.plot_view.canvas_view,[s,i]=this._map_data();for(let l=0,o=this._text.length;l<o;l++)t(e,l,this._text[l],s[l]+this._x_offset[l],i[l]-this._y_offset[l],this._angle[l])}_get_size(){const{ctx:t}=this.plot_view.canvas_view;this.visuals.text.set_value(t);const{width:e,ascent:s}=t.measureText(this._text[0]);return{width:e,height:s}}_v_canvas_text(t,e,s,i,l,o){this.visuals.text.set_vectorize(t,e);const a=this._calculate_bounding_box_dimensions(t,s);t.save(),t.beginPath(),t.translate(i,l),t.rotate(o),t.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(s,0,0)),t.restore()}_v_css_text(t,e,s,i,l,a){const n=this.el.children[e];n.textContent=s,this.visuals.text.set_vectorize(t,e);const r=this._calculate_bounding_box_dimensions(t,s),_=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),n.style.position="absolute",n.style.left=`${i+r[0]}px`,n.style.top=`${l+r[1]}px`,n.style.color=`${this.visuals.text.text_color.value()}`,n.style.opacity=`${this.visuals.text.text_alpha.value()}`,n.style.font=`${this.visuals.text.font_value()}`,n.style.lineHeight="normal",a&&(n.style.transform=`rotate(${a}rad)`),this.visuals.background_fill.doit&&(n.style.backgroundColor=`${this.visuals.background_fill.color_value()}`),this.visuals.border_line.doit&&(n.style.borderStyle=`${_}`,n.style.borderWidth=`${this.visuals.border_line.line_width.value()}px`,n.style.borderColor=`${this.visuals.border_line.color_value()}`),o.display(n)}}s.LabelSetView=r,r.__name__="LabelSetView";class _ extends i.TextAnnotation{constructor(t){super(t)}static init_LabelSet(){this.prototype.default_view=r,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[a.NumberSpec],y:[a.NumberSpec],x_units:[a.SpatialUnits,"data"],y_units:[a.SpatialUnits,"data"],text:[a.StringSpec,{field:"text"}],angle:[a.AngleSpec,0],x_offset:[a.NumberSpec,{value:0}],y_offset:[a.NumberSpec,{value:0}],source:[a.Instance,()=>new l.ColumnDataSource],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})}}s.LabelSet=_,_.__name__="LabelSet",_.init_LabelSet()},
function _(t,e,i){const s=t(29),l=t(18),n=t(13),h=t(124),a=t(79),o=t(8),_=t(22),r=t(7);class d extends s.AnnotationView{cursor(t,e){return"none"==this.model.click_policy?null:"pointer"}get legend_padding(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.item_change,()=>this.plot_view.request_render())}compute_legend_bbox(){const t=this.model.get_legend_names(),{glyph_height:e,glyph_width:i}=this.model,{label_height:s,label_width:l}=this.model;this.max_label_height=o.max([h.measure_font(this.visuals.label_text.font_value()).height,s,e]);const{ctx:n}=this.plot_view.canvas_view;n.save(),this.visuals.label_text.set_value(n),this.text_widths={};for(const e of t)this.text_widths[e]=o.max([n.measureText(e).width,l]);this.visuals.title_text.set_value(n),this.title_height=this.model.title?h.measure_font(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?n.measureText(this.model.title).width:0,n.restore();const d=Math.max(o.max(_.values(this.text_widths)),0),c=this.model.margin,{legend_padding:g}=this,m=this.model.spacing,{label_standoff:b}=this.model;let f,u;if("vertical"==this.model.orientation)f=t.length*this.max_label_height+Math.max(t.length-1,0)*m+2*g+this.title_height,u=o.max([d+i+b+2*g,this.title_width+2*g]);else{let e=2*g+Math.max(t.length-1,0)*m;for(const t in this.text_widths){const s=this.text_widths[t];e+=o.max([s,l])+i+b}u=o.max([this.title_width+2*g,e]),f=this.max_label_height+this.title_height+2*g}const x=null!=this.panel?this.panel:this.plot_view.frame,[p,w]=x.bbox.ranges,{location:v}=this.model;let y,k;if(r.isString(v))switch(v){case"top_left":y=p.start+c,k=w.start+c;break;case"top_center":y=(p.end+p.start)/2-u/2,k=w.start+c;break;case"top_right":y=p.end-c-u,k=w.start+c;break;case"bottom_right":y=p.end-c-u,k=w.end-c-f;break;case"bottom_center":y=(p.end+p.start)/2-u/2,k=w.end-c-f;break;case"bottom_left":y=p.start+c,k=w.end-c-f;break;case"center_left":y=p.start+c,k=(w.end+w.start)/2-f/2;break;case"center":y=(p.end+p.start)/2-u/2,k=(w.end+w.start)/2-f/2;break;case"center_right":y=p.end-c-u,k=(w.end+w.start)/2-f/2;break;default:throw new Error("unreachable code")}else{if(!r.isArray(v)||2!=v.length)throw new Error("unreachable code");{const[t,e]=v;y=x.xview.compute(t),k=x.yview.compute(e)-f}}return new a.BBox({left:y,top:k,width:u,height:f})}interactive_bbox(){return this.compute_legend_bbox()}interactive_hit(t,e){return this.interactive_bbox().contains(t,e)}on_hit(t,e){let i;const{glyph_width:s}=this.model,{legend_padding:l}=this,n=this.model.spacing,{label_standoff:h}=this.model;let o=i=l;const _=this.compute_legend_bbox(),r="vertical"==this.model.orientation;for(const d of this.model.items){const c=d.get_labels_list_from_label_prop();for(const g of c){const c=_.x+o,m=_.y+i+this.title_height;let b,f;if([b,f]=r?[_.width-2*l,this.max_label_height]:[this.text_widths[g]+s+h,this.max_label_height],new a.BBox({left:c,top:m,width:b,height:f}).contains(t,e)){switch(this.model.click_policy){case"hide":for(const t of d.renderers)t.visible=!t.visible;break;case"mute":for(const t of d.renderers)t.muted=!t.muted}return!0}r?i+=this.max_label_height+n:o+=this.text_widths[g]+s+h+n}}return!1}render(){if(!this.model.visible)return;if(0==this.model.items.length)return;for(const t of this.model.items)t.legend=this.model;const{ctx:t}=this.plot_view.canvas_view,e=this.compute_legend_bbox();t.save(),this._draw_legend_box(t,e),this._draw_legend_items(t,e),this.model.title&&this._draw_title(t,e),t.restore()}_draw_legend_box(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.set_value(t),t.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke())}_draw_legend_items(t,e){const{glyph_width:i,glyph_height:s}=this.model,{legend_padding:l}=this,n=this.model.spacing,{label_standoff:h}=this.model;let a=l,_=l;const r="vertical"==this.model.orientation;for(const d of this.model.items){const c=d.get_labels_list_from_label_prop(),g=d.get_field_from_label_prop();if(0==c.length)continue;const m=(()=>{switch(this.model.click_policy){case"none":return!0;case"hide":return o.every(d.renderers,t=>t.visible);case"mute":return o.every(d.renderers,t=>!t.muted)}})();for(const o of c){const c=e.x+a,b=e.y+_+this.title_height,f=c+i,u=b+s;r?_+=this.max_label_height+n:a+=this.text_widths[o]+i+h+n,this.visuals.label_text.set_value(t),t.fillText(o,f+h,b+this.max_label_height/2);for(const e of d.renderers){this.plot_view.renderer_views[e.id].draw_legend(t,c,f,b,u,g,o,d.index)}if(!m){let s,n;[s,n]=r?[e.width-2*l,this.max_label_height]:[this.text_widths[o]+i+h,this.max_label_height],t.beginPath(),t.rect(c,b,s,n),this.visuals.inactive_fill.set_value(t),t.fill()}}}}_draw_title(t,e){this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(this.model.title,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())}_get_size(){const{width:t,height:e}=this.compute_legend_bbox();return{width:t+2*this.model.margin,height:e+2*this.model.margin}}}i.LegendView=d,d.__name__="LegendView";class c extends s.Annotation{constructor(t){super(t)}initialize(){super.initialize(),this.item_change=new n.Signal0(this,"item_change")}static init_Legend(){this.prototype.default_view=d,this.mixins(["text:label_","text:title_","fill:inactive_","line:border_","fill:background_"]),this.define({orientation:[l.Orientation,"vertical"],location:[l.Any,"top_right"],title:[l.String],title_standoff:[l.Number,5],label_standoff:[l.Number,5],glyph_height:[l.Number,20],glyph_width:[l.Number,20],label_height:[l.Number,20],label_width:[l.Number,20],margin:[l.Number,10],padding:[l.Number,10],spacing:[l.Number,3],items:[l.Array,[]],click_policy:[l.Any,"none"]}),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"10pt",label_text_baseline:"middle",title_text_font_size:"10pt",title_text_font_style:"italic"})}get_legend_names(){const t=[];for(const e of this.items){const i=e.get_labels_list_from_label_prop();t.push(...i)}return t}}i.Legend=c,c.__name__="Legend",c.init_Legend()},
function _(e,r,n){const l=e(64),t=e(69),s=e(130),i=e(18),o=e(65),_=e(8);class a extends l.Model{constructor(e){super(e)}static init_LegendItem(){this.define({label:[i.StringSpec,null],renderers:[i.Array,[]],index:[i.Number,null]})}_check_data_sources_on_renderers(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;const e=this.renderers[0].data_source;if(null!=e)for(const r of this.renderers)if(r.data_source!=e)return!1}return!0}_check_field_label_on_data_source(){const e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;const r=this.renderers[0].data_source;if(null!=r&&!_.includes(r.columns(),e))return!1}return!0}initialize(){super.initialize(),this.legend=null,this.connect(this.change,()=>{null!=this.legend&&this.legend.item_change.emit()}),this._check_data_sources_on_renderers()||o.logger.error("Non matching data sources on legend item renderers"),this._check_field_label_on_data_source()||o.logger.error(`Bad column name on label: ${this.label}`)}get_field_from_label_prop(){const{label:e}=this;return s.isField(e)?e.field:null}get_labels_list_from_label_prop(){if(s.isValue(this.label)){const{value:e}=this.label;return null!=e?[e]:[]}const e=this.get_field_from_label_prop();if(null!=e){let r;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if((r=this.renderers[0].data_source)instanceof t.ColumnarDataSource){const n=r.get_column(e);return null!=n?_.uniq(Array.from(n)):["Invalid field"]}}return[]}}n.LegendItem=a,a.__name__="LegendItem",a.init_LegendItem()},
function _(i,n,e){const t=i(7);e.isValue=function(i){return t.isPlainObject(i)&&"value"in i},e.isField=function(i){return t.isPlainObject(i)&&"field"in i}},
function _(t,e,i){const n=t(29),s=t(13),l=t(18);class o extends n.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.data_update,()=>this.plot_view.request_render())}render(){if(!this.model.visible)return;const{xs:t,ys:e}=this.model;if(t.length!=e.length)return;if(t.length<3||e.length<3)return;const{frame:i}=this.plot_view,{ctx:n}=this.plot_view.canvas_view;for(let s=0,l=t.length;s<l;s++){let l,o;if("screen"!=this.model.xs_units)throw new Error("not implemented");if(l=this.model.screen?t[s]:i.xview.compute(t[s]),"screen"!=this.model.ys_units)throw new Error("not implemented");o=this.model.screen?e[s]:i.yview.compute(e[s]),0==s?(n.beginPath(),n.moveTo(l,o)):n.lineTo(l,o)}n.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(n),n.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(n),n.fill())}}i.PolyAnnotationView=o,o.__name__="PolyAnnotationView";class a extends n.Annotation{constructor(t){super(t)}static init_PolyAnnotation(){this.prototype.default_view=o,this.mixins(["line","fill"]),this.define({xs:[l.Array,[]],xs_units:[l.SpatialUnits,"data"],ys:[l.Array,[]],ys_units:[l.SpatialUnits,"data"],x_range_name:[l.String,"default"],y_range_name:[l.String,"default"]}),this.internal({screen:[l.Boolean,!1]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}initialize(){super.initialize(),this.data_update=new s.Signal0(this,"data_update")}update({xs:t,ys:e}){this.setv({xs:t,ys:e,screen:!0},{silent:!0}),this.data_update.emit()}}i.PolyAnnotation=a,a.__name__="PolyAnnotation",a.init_PolyAnnotation()},
function _(e,t,i){const n=e(29),s=e(18);class l extends n.AnnotationView{initialize(){super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render())}render(){this.model.visible&&this._draw_slope()}_draw_slope(){const e=this.model.gradient,t=this.model.y_intercept;if(null==e||null==t)return;const{frame:i}=this.plot_view,n=i.xscales[this.model.x_range_name],s=i.yscales[this.model.y_range_name],l=i._top.value,o=l+i._height.value,a=(s.invert(l)-t)/e,_=(s.invert(o)-t)/e,r=n.compute(a),c=n.compute(_),{ctx:u}=this.plot_view.canvas_view;u.save(),u.beginPath(),this.visuals.line.set_value(u),u.moveTo(r,l),u.lineTo(c,o),u.stroke(),u.restore()}}i.SlopeView=l,l.__name__="SlopeView";class o extends n.Annotation{constructor(e){super(e)}static init_Slope(){this.prototype.default_view=l,this.mixins(["line"]),this.define({gradient:[s.Number,null],y_intercept:[s.Number,null],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.override({line_color:"black"})}}i.Slope=o,o.__name__="Slope",o.init_Slope()},
function _(e,i,t){const s=e(29),o=e(61),n=e(18);class l extends s.AnnotationView{initialize(){super.initialize(),this.plot_view.canvas_overlays.appendChild(this.el),this.el.style.position="absolute",o.undisplay(this.el)}connect_signals(){super.connect_signals(),this.model.for_hover?this.connect(this.model.properties.computed_location.change,()=>this._draw_span()):"canvas"==this.model.render_mode?(this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.properties.location.change,()=>this.plot_view.request_render())):(this.connect(this.model.change,()=>this.render()),this.connect(this.model.properties.location.change,()=>this._draw_span()))}render(){this.model.visible||"css"!=this.model.render_mode||o.undisplay(this.el),this.model.visible&&this._draw_span()}_draw_span(){const e=this.model.for_hover?this.model.computed_location:this.model.location;if(null==e)return void o.undisplay(this.el);const{frame:i}=this.plot_view,t=i.xscales[this.model.x_range_name],s=i.yscales[this.model.y_range_name],n=(i,t)=>this.model.for_hover?this.model.computed_location:"data"==this.model.location_units?i.compute(e):t.compute(e);let l,a,h,d;if("width"==this.model.dimension?(h=n(s,i.yview),a=i._left.value,d=i._width.value,l=this.model.properties.line_width.value()):(h=i._top.value,a=n(t,i.xview),d=this.model.properties.line_width.value(),l=i._height.value),"css"==this.model.render_mode)this.el.style.top=`${h}px`,this.el.style.left=`${a}px`,this.el.style.width=`${d}px`,this.el.style.height=`${l}px`,this.el.style.backgroundColor=this.model.properties.line_color.value(),this.el.style.opacity=this.model.properties.line_alpha.value(),o.display(this.el);else if("canvas"==this.model.render_mode){const{ctx:e}=this.plot_view.canvas_view;e.save(),e.beginPath(),this.visuals.line.set_value(e),e.moveTo(a,h),"width"==this.model.dimension?e.lineTo(a+d,h):e.lineTo(a,h+l),e.stroke(),e.restore()}}}t.SpanView=l,l.__name__="SpanView";class a extends s.Annotation{constructor(e){super(e)}static init_Span(){this.prototype.default_view=l,this.mixins(["line"]),this.define({render_mode:[n.RenderMode,"canvas"],x_range_name:[n.String,"default"],y_range_name:[n.String,"default"],location:[n.Number,null],location_units:[n.SpatialUnits,"data"],dimension:[n.Dimension,"width"]}),this.override({line_color:"black"}),this.internal({for_hover:[n.Boolean,!1],computed_location:[n.Number,null]})}}t.Span=a,a.__name__="Span",a.init_Span()},
function _(e,t,i){const l=e(126),a=e(61),r=e(63),s=e(18);class n extends l.TextAnnotationView{initialize(){super.initialize(),this.visuals.text=new r.Text(this.model)}_get_location(){const e=this.panel,t=this.model.offset;let i,l;switch(e.side){case"above":case"below":switch(this.model.vertical_align){case"top":l=e._top.value+5;break;case"middle":l=e._vcenter.value;break;case"bottom":l=e._bottom.value-5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":i=e._left.value+t;break;case"center":i=e._hcenter.value;break;case"right":i=e._right.value-t;break;default:throw new Error("unreachable code")}break;case"left":switch(this.model.vertical_align){case"top":i=e._left.value-5;break;case"middle":i=e._hcenter.value;break;case"bottom":i=e._right.value+5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":l=e._bottom.value-t;break;case"center":l=e._vcenter.value;break;case"right":l=e._top.value+t;break;default:throw new Error("unreachable code")}break;case"right":switch(this.model.vertical_align){case"top":i=e._right.value-5;break;case"middle":i=e._hcenter.value;break;case"bottom":i=e._left.value+5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":l=e._top.value+t;break;case"center":l=e._vcenter.value;break;case"right":l=e._bottom.value-t;break;default:throw new Error("unreachable code")}break;default:throw new Error("unreachable code")}return[i,l]}render(){if(!this.model.visible)return void("css"==this.model.render_mode&&a.undisplay(this.el));const{text:e}=this.model;if(null==e||0==e.length)return;this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;const[t,i]=this._get_location(),l=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.plot_view.canvas_view.ctx,e,t,i,l)}_get_size(){const{text:e}=this.model;if(null==e||0==e.length)return{width:0,height:0};{this.visuals.text.set_value(this.ctx);const{width:t,ascent:i}=this.ctx.measureText(e);return{width:t,height:i*this.visuals.text.text_line_height.value()+10}}}}i.TitleView=n,n.__name__="TitleView";class o extends l.TextAnnotation{constructor(e){super(e)}static init_Title(){this.prototype.default_view=n,this.mixins(["line:border_","fill:background_"]),this.define({text:[s.String],text_font:[s.Font,"helvetica"],text_font_size:[s.FontSizeSpec,"10pt"],text_font_style:[s.FontStyle,"bold"],text_color:[s.ColorSpec,"#444444"],text_alpha:[s.NumberSpec,1],text_line_height:[s.Number,1],vertical_align:[s.VerticalAlign,"bottom"],align:[s.TextAlign,"left"],offset:[s.Number,0]}),this.override({background_fill_color:null,border_line_color:null}),this.internal({text_align:[s.TextAlign,"left"],text_baseline:[s.TextBaseline,"bottom"]})}}i.Title=o,o.__name__="Title",o.init_Title()},
function _(e,i,t){const o=e(29),s=e(92),l=e(61),n=e(18);class a extends o.AnnotationView{constructor(){super(...arguments),this.rotate=!0}initialize(){super.initialize(),this.plot_view.canvas_events.appendChild(this.el),this._toolbar_views={},s.build_views(this._toolbar_views,[this.model.toolbar],{parent:this});const e=this._toolbar_views[this.model.toolbar.id];this.plot_view.visibility_callbacks.push(i=>e.set_visibility(i))}remove(){s.remove_views(this._toolbar_views),super.remove()}render(){if(super.render(),!this.model.visible)return void l.undisplay(this.el);this.el.style.position="absolute",this.el.style.overflow="hidden",l.position(this.el,this.panel.bbox);const e=this._toolbar_views[this.model.toolbar.id];e.render(),l.empty(this.el),this.el.appendChild(e.el),l.display(this.el)}_get_size(){const{tools:e,logo:i}=this.model.toolbar;return{width:30*e.length+(null!=i?25:0),height:30}}}t.ToolbarPanelView=a,a.__name__="ToolbarPanelView";class r extends o.Annotation{constructor(e){super(e)}static init_ToolbarPanel(){this.prototype.default_view=a,this.define({toolbar:[n.Instance]})}}t.ToolbarPanel=r,r.__name__="ToolbarPanel",r.init_ToolbarPanel()},
function _(t,e,s){const i=t(29),l=t(61),o=t(18),a=t(137),h=t(138);function n(t,e,s,i,l){switch(t){case"horizontal":return e<i?"right":"left";case"vertical":return s<l?"below":"above";default:return t}}s.compute_side=n;class c extends i.AnnotationView{initialize(){super.initialize(),this.plot_view.canvas_overlays.appendChild(this.el),l.undisplay(this.el)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,()=>this._draw_tips())}css_classes(){return super.css_classes().concat(a.bk_tooltip)}render(){this.model.visible&&this._draw_tips()}_draw_tips(){const{data:t}=this.model;if(l.empty(this.el),l.undisplay(this.el),this.model.custom?this.el.classList.add(a.bk_tooltip_custom):this.el.classList.remove(a.bk_tooltip_custom),0==t.length)return;const{frame:e}=this.plot_view;for(const[s,i,o]of t){if(this.model.inner_only&&!e.bbox.contains(s,i))continue;const t=l.div({},o);this.el.appendChild(t)}const[s,i]=t[t.length-1],o=n(this.model.attachment,s,i,e._hcenter.value,e._vcenter.value);this.el.classList.remove(h.bk_right),this.el.classList.remove(h.bk_left),this.el.classList.remove(h.bk_above),this.el.classList.remove(h.bk_below);let c,r;switch(l.display(this.el),o){case"right":this.el.classList.add(h.bk_left),c=s+(this.el.offsetWidth-this.el.clientWidth)+10,r=i-this.el.offsetHeight/2;break;case"left":this.el.classList.add(h.bk_right),c=s-this.el.offsetWidth-10,r=i-this.el.offsetHeight/2;break;case"below":this.el.classList.add(h.bk_above),r=i+(this.el.offsetHeight-this.el.clientHeight)+10,c=Math.round(s-this.el.offsetWidth/2);break;case"above":this.el.classList.add(h.bk_below),r=i-this.el.offsetHeight-10,c=Math.round(s-this.el.offsetWidth/2);break;default:throw new Error("unreachable code")}this.model.show_arrow&&this.el.classList.add(a.bk_tooltip_arrow),this.el.childNodes.length>0?(this.el.style.top=`${r}px`,this.el.style.left=`${c}px`):l.undisplay(this.el)}}s.TooltipView=c,c.__name__="TooltipView";class r extends i.Annotation{constructor(t){super(t)}static init_Tooltip(){this.prototype.default_view=c,this.define({attachment:[o.TooltipAttachment,"horizontal"],inner_only:[o.Boolean,!0],show_arrow:[o.Boolean,!0]}),this.override({level:"overlay"}),this.internal({data:[o.Any,[]],custom:[o.Any]})}clear(){this.data=[]}add(t,e,s){this.data=this.data.concat([[t,e,s]])}}s.Tooltip=r,r.__name__="Tooltip",r.init_Tooltip()},
function _(o,t,n){o(62),o(61).styles.append('.bk-root {\n  /* Same border color used everywhere */\n  /* Gray of icons */\n}\n.bk-root .bk-tooltip {\n  font-weight: 300;\n  font-size: 12px;\n  position: absolute;\n  padding: 5px;\n  border: 1px solid #e5e5e5;\n  color: #2f2f2f;\n  background-color: white;\n  pointer-events: none;\n  opacity: 0.95;\n  z-index: 100;\n}\n.bk-root .bk-tooltip > div:not(:first-child) {\n  /* gives space when multiple elements are being hovered over */\n  margin-top: 5px;\n  border-top: #e5e5e5 1px dashed;\n}\n.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-left::before {\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right::after {\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-above::before {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  top: -10px;\n  border-bottom-width: 10px;\n  border-bottom-color: #909599;\n}\n.bk-root .bk-tooltip.bk-below::after {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  bottom: -10px;\n  border-top-width: 10px;\n  border-top-color: #909599;\n}\n.bk-root .bk-tooltip-row-label {\n  text-align: right;\n  color: #26aae1;\n  /* blue from toolbar highlighting */\n}\n.bk-root .bk-tooltip-row-value {\n  color: default;\n  /* seems to be necessary for notebook */\n}\n.bk-root .bk-tooltip-color-block {\n  width: 12px;\n  height: 12px;\n  margin-left: 5px;\n  margin-right: 5px;\n  outline: #dddddd solid 1px;\n  display: inline-block;\n}\n'),n.bk_tooltip="bk-tooltip",n.bk_tooltip_arrow="bk-tooltip-arrow",n.bk_tooltip_custom="bk-tooltip-custom",n.bk_tooltip_row_label="bk-tooltip-row-label",n.bk_tooltip_row_value="bk-tooltip-row-value",n.bk_tooltip_color_block="bk-tooltip-color-block"},
function _(b,e,k){b(61).styles.append(""),k.bk_active="bk-active",k.bk_inline="bk-inline",k.bk_left="bk-left",k.bk_right="bk-right",k.bk_above="bk-above",k.bk_below="bk-below",k.bk_up="bk-up",k.bk_down="bk-down",k.bk_side=function(b){switch(b){case"above":return k.bk_above;case"below":return k.bk_below;case"left":return k.bk_left;case"right":return k.bk_right}}},
function _(e,t,s){const i=e(29),r=e(68),n=e(67),a=e(18);class h extends i.AnnotationView{initialize(){super.initialize(),this.set_data(this.model.source)}connect_signals(){super.connect_signals(),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source)),this.connect(this.model.source.change,()=>this.set_data(this.model.source))}set_data(e){super.set_data(e),this.visuals.warm_cache(e),this.plot_view.request_render()}_map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,s=e.xscales[this.model.x_range_name],i=e.yscales[this.model.y_range_name],r="height"==t?i:s,n="height"==t?s:i,a="height"==t?e.yview:e.xview,h="height"==t?e.xview:e.yview;let o,_,l;o="data"==this.model.properties.lower.units?r.v_compute(this._lower):a.v_compute(this._lower),_="data"==this.model.properties.upper.units?r.v_compute(this._upper):a.v_compute(this._upper),l="data"==this.model.properties.base.units?n.v_compute(this._base):h.v_compute(this._base);const[d,p]="height"==t?[1,0]:[0,1],c=[o,l],u=[_,l];this._lower_sx=c[d],this._lower_sy=c[p],this._upper_sx=u[d],this._upper_sy=u[p]}render(){if(!this.model.visible)return;this._map_data();const{ctx:e}=this.plot_view.canvas_view;if(this.visuals.line.doit)for(let t=0,s=this._lower_sx.length;t<s;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();const t="height"==this.model.dimension?0:Math.PI/2;if(null!=this.model.lower_head)for(let s=0,i=this._lower_sx.length;s<i;s++)e.save(),e.translate(this._lower_sx[s],this._lower_sy[s]),e.rotate(t+Math.PI),this.model.lower_head.render(e,s),e.restore();if(null!=this.model.upper_head)for(let s=0,i=this._upper_sx.length;s<i;s++)e.save(),e.translate(this._upper_sx[s],this._upper_sy[s]),e.rotate(t),this.model.upper_head.render(e,s),e.restore()}}s.WhiskerView=h,h.__name__="WhiskerView";class o extends i.Annotation{constructor(e){super(e)}static init_Whisker(){this.prototype.default_view=h,this.mixins(["line"]),this.define({lower:[a.DistanceSpec],lower_head:[a.Instance,()=>new n.TeeHead({level:"underlay",size:10})],upper:[a.DistanceSpec],upper_head:[a.Instance,()=>new n.TeeHead({level:"underlay",size:10})],base:[a.DistanceSpec],dimension:[a.Dimension,"height"],source:[a.Instance,()=>new r.ColumnDataSource],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({level:"underlay"})}}s.Whisker=o,o.__name__="Whisker",o.init_Whisker()},
function _(i,a,s){var r=i(141);s.Axis=r.Axis;var x=i(143);s.CategoricalAxis=x.CategoricalAxis;var A=i(146);s.ContinuousAxis=A.ContinuousAxis;var o=i(147);s.DatetimeAxis=o.DatetimeAxis;var t=i(148);s.LinearAxis=t.LinearAxis;var e=i(161);s.LogAxis=e.LogAxis;var n=i(164);s.MercatorAxis=n.MercatorAxis},
function _(e,t,i){const s=e(142),a=e(18),l=e(8),n=e(7),o=e(82),{abs:r,min:_,max:h}=Math;class c extends s.GuideRendererView{constructor(){super(...arguments),this.rotate=!0}get panel(){return this.layout}render(){if(!this.model.visible)return;const e={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},t=this.tick_coords,i=this.plot_view.canvas_view.ctx;i.save(),this._draw_rule(i,e),this._draw_major_ticks(i,e,t),this._draw_minor_ticks(i,e,t),this._draw_major_labels(i,e,t),this._draw_axis_label(i,e,t),null!=this._render&&this._render(i,e,t),i.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_paint());const e=this.model.properties;this.on_change(e.visible,()=>this.plot_view.request_layout())}get_size(){if(this.model.visible&&null==this.model.fixed_location){const e=this._get_size();return{width:0,height:Math.round(e)}}return{width:0,height:0}}_get_size(){return this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()}get needs_clip(){return null!=this.model.fixed_location}_draw_rule(e,t){if(!this.visuals.axis_line.doit)return;const[i,s]=this.rule_coords,[a,l]=this.plot_view.map_to_screen(i,s,this.model.x_range_name,this.model.y_range_name),[n,o]=this.normals,[r,_]=this.offsets;this.visuals.axis_line.set_value(e),e.beginPath(),e.moveTo(Math.round(a[0]+n*r),Math.round(l[0]+o*_));for(let t=1;t<a.length;t++){const i=Math.round(a[t]+n*r),s=Math.round(l[t]+o*_);e.lineTo(i,s)}e.stroke()}_draw_major_ticks(e,t,i){const s=this.model.major_tick_in,a=this.model.major_tick_out,l=this.visuals.major_tick_line;this._draw_ticks(e,i.major,s,a,l)}_draw_minor_ticks(e,t,i){const s=this.model.minor_tick_in,a=this.model.minor_tick_out,l=this.visuals.minor_tick_line;this._draw_ticks(e,i.minor,s,a,l)}_draw_major_labels(e,t,i){const s=i.major,a=this.compute_labels(s[this.dimension]),l=this.model.major_label_orientation,n=t.tick+this.model.major_label_standoff,o=this.visuals.major_label_text;this._draw_oriented_labels(e,a,s,l,this.panel.side,n,o)}_draw_axis_label(e,t,i){if(null==this.model.axis_label||0==this.model.axis_label.length||null!=this.model.fixed_location)return;let s,a;switch(this.panel.side){case"above":s=this.panel._hcenter.value,a=this.panel._bottom.value;break;case"below":s=this.panel._hcenter.value,a=this.panel._top.value;break;case"left":s=this.panel._right.value,a=this.panel._vcenter.value;break;case"right":s=this.panel._left.value,a=this.panel._vcenter.value;break;default:throw new Error(`unknown side: ${this.panel.side}`)}const n=[[s],[a]],o=t.tick+l.sum(t.tick_label)+this.model.axis_label_standoff,r=this.visuals.axis_label_text;this._draw_oriented_labels(e,[this.model.axis_label],n,"parallel",this.panel.side,o,r,"screen")}_draw_ticks(e,t,i,s,a){if(!a.doit)return;const[l,n]=t,[o,r]=this.plot_view.map_to_screen(l,n,this.model.x_range_name,this.model.y_range_name),[_,h]=this.normals,[c,m]=this.offsets,[d,u]=[_*(c-i),h*(m-i)],[b,x]=[_*(c+s),h*(m+s)];a.set_value(e);for(let t=0;t<o.length;t++){const i=Math.round(o[t]+b),s=Math.round(r[t]+x),a=Math.round(o[t]+d),l=Math.round(r[t]+u);e.beginPath(),e.moveTo(i,s),e.lineTo(a,l),e.stroke()}}_draw_oriented_labels(e,t,i,s,a,l,o,r="data"){if(!o.doit||0==t.length)return;let _,h,c,m;if("screen"==r)[_,h]=i,[c,m]=[0,0];else{const[e,t]=i;[_,h]=this.plot_view.map_to_screen(e,t,this.model.x_range_name,this.model.y_range_name),[c,m]=this.offsets}const[d,u]=this.normals,b=d*(c+l),x=u*(m+l);let f;o.set_value(e),this.panel.apply_label_text_heuristics(e,s),f=n.isString(s)?this.panel.get_label_angle_heuristic(s):-s;for(let i=0;i<_.length;i++){const s=Math.round(_[i]+b),a=Math.round(h[i]+x);e.translate(s,a),e.rotate(f),e.fillText(t[i],0,0),e.rotate(-f),e.translate(-s,-a)}}_axis_label_extent(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;const e=this.model.axis_label_standoff,t=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.panel.side,e,t)}_tick_extent(){return this.model.major_tick_out}_tick_label_extent(){return l.sum(this._tick_label_extents())}_tick_label_extents(){const e=this.tick_coords.major,t=this.compute_labels(e[this.dimension]),i=this.model.major_label_orientation,s=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(t,i,this.panel.side,s,a)]}_oriented_labels_extent(e,t,i,s,a){if(0==e.length)return 0;const l=this.plot_view.canvas_view.ctx;let o,r;a.set_value(l),n.isString(t)?(o=1,r=this.panel.get_label_angle_heuristic(t)):(o=2,r=-t),r=Math.abs(r);const _=Math.cos(r),h=Math.sin(r);let c=0;for(let t=0;t<e.length;t++){const s=1.1*l.measureText(e[t]).width,a=.9*l.measureText(e[t]).ascent;let n;(n="above"==i||"below"==i?s*h+a/o*_:s*_+a/o*h)>c&&(c=n)}return c>0&&(c+=s),c}get normals(){return this.panel.normals}get dimension(){return this.panel.dimension}compute_labels(e){const t=this.model.formatter.doFormat(e,this);for(let i=0;i<e.length;i++)e[i]in this.model.major_label_overrides&&(t[i]=this.model.major_label_overrides[e[i]]);return t}get offsets(){if(null!=this.model.fixed_location)return[0,0];const{frame:e}=this.plot_view;let[t,i]=[0,0];switch(this.panel.side){case"below":i=r(this.panel._top.value-e._bottom.value);break;case"above":i=r(this.panel._bottom.value-e._top.value);break;case"right":t=r(this.panel._left.value-e._right.value);break;case"left":t=r(this.panel._right.value-e._left.value)}return[t,i]}get ranges(){const e=this.dimension,t=(e+1)%2,{frame:i}=this.plot_view,s=[i.x_ranges[this.model.x_range_name],i.y_ranges[this.model.y_range_name]];return[s[e],s[t]]}get computed_bounds(){const[e]=this.ranges,t=this.model.bounds,i=[e.min,e.max];if("auto"==t)return[e.min,e.max];if(n.isArray(t)){let e,s;const[a,l]=t,[n,o]=i;return r(a-l)>r(n-o)?(e=h(_(a,l),n),s=_(h(a,l),o)):(e=_(a,l),s=h(a,l)),[e,s]}throw new Error(`user bounds '${t}' not understood`)}get rule_coords(){const e=this.dimension,t=(e+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,l=[new Array(2),new Array(2)];return l[e][0]=Math.max(s,i.min),l[e][1]=Math.min(a,i.max),l[e][0]>l[e][1]&&(l[e][0]=l[e][1]=NaN),l[t][0]=this.loc,l[t][1]=this.loc,l}get tick_coords(){const e=this.dimension,t=(e+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,l=this.model.ticker.get_ticks(s,a,i,this.loc,{}),n=l.major,o=l.minor,r=[[],[]],_=[[],[]],[h,c]=[i.min,i.max];for(let i=0;i<n.length;i++)n[i]<h||n[i]>c||(r[e].push(n[i]),r[t].push(this.loc));for(let i=0;i<o.length;i++)o[i]<h||o[i]>c||(_[e].push(o[i]),_[t].push(this.loc));return{major:r,minor:_}}get loc(){const{fixed_location:e}=this.model;if(null!=e){if(n.isNumber(e))return e;const[,t]=this.ranges;if(t instanceof o.FactorRange)return t.synthetic(e);throw new Error("unexpected")}const[,t]=this.ranges;switch(this.panel.side){case"left":case"below":return t.start;case"right":case"above":return t.end}}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box})}}i.AxisView=c,c.__name__="AxisView";class m extends s.GuideRenderer{constructor(e){super(e)}static init_Axis(){this.prototype.default_view=c,this.mixins(["line:axis_","line:major_tick_","line:minor_tick_","text:major_label_","text:axis_label_"]),this.define({bounds:[a.Any,"auto"],ticker:[a.Instance],formatter:[a.Instance],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"],axis_label:[a.String,""],axis_label_standoff:[a.Int,5],major_label_standoff:[a.Int,5],major_label_orientation:[a.Any,"horizontal"],major_label_overrides:[a.Any,{}],major_tick_in:[a.Number,2],major_tick_out:[a.Number,6],minor_tick_in:[a.Number,0],minor_tick_out:[a.Number,4],fixed_location:[a.Any,null]}),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"8pt",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"10pt",axis_label_text_font_style:"italic"})}}i.Axis=m,m.__name__="Axis",m.init_Axis()},
function _(e,r,n){const d=e(58);class i extends d.RendererView{}n.GuideRendererView=i,i.__name__="GuideRendererView";class s extends d.Renderer{constructor(e){super(e)}static init_GuideRenderer(){this.override({level:"overlay"})}}n.GuideRenderer=s,s.__name__="GuideRenderer",s.init_GuideRenderer()},
function _(t,s,o){const e=t(141),i=t(144),r=t(145),a=t(18);class l extends e.AxisView{_render(t,s,o){this._draw_group_separators(t,s,o)}_draw_group_separators(t,s,o){const[e]=this.ranges,[i,r]=this.computed_bounds;if(!e.tops||e.tops.length<2||!this.visuals.separator_line.doit)return;const a=this.dimension,l=(a+1)%2,_=[[],[]];let n=0;for(let t=0;t<e.tops.length-1;t++){let s,o;for(let i=n;i<e.factors.length;i++)if(e.factors[i][0]==e.tops[t+1]){[s,o]=[e.factors[i-1],e.factors[i]],n=i;break}const h=(e.synthetic(s)+e.synthetic(o))/2;h>i&&h<r&&(_[a].push(h),_[l].push(this.loc))}const h=this._tick_label_extent();this._draw_ticks(t,_,-3,h-6,this.visuals.separator_line)}_draw_major_labels(t,s,o){const e=this._get_factor_info();let i=s.tick+this.model.major_label_standoff;for(let o=0;o<e.length;o++){const[r,a,l,_]=e[o];this._draw_oriented_labels(t,r,a,l,this.panel.side,i,_),i+=s.tick_label[o]}}_tick_label_extents(){const t=this._get_factor_info(),s=[];for(const[o,,e,i]of t){const t=this._oriented_labels_extent(o,e,this.panel.side,this.model.major_label_standoff,i);s.push(t)}return s}_get_factor_info(){const[t]=this.ranges,[s,o]=this.computed_bounds,e=this.loc,i=this.model.ticker.get_ticks(s,o,t,e,{}),r=this.tick_coords,a=[];if(1==t.levels){const t=i.major,s=this.model.formatter.doFormat(t,this);a.push([s,r.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){const t=i.major.map(t=>t[1]),s=this.model.formatter.doFormat(t,this);a.push([s,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([i.tops,r.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){const t=i.major.map(t=>t[2]),s=this.model.formatter.doFormat(t,this),o=i.mids.map(t=>t[1]);a.push([s,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([o,r.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),a.push([i.tops,r.tops,this.model.group_label_orientation,this.visuals.group_text])}return a}get tick_coords(){const t=this.dimension,s=(t+1)%2,[o]=this.ranges,[e,i]=this.computed_bounds,r=this.model.ticker.get_ticks(e,i,o,this.loc,{}),a={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return a.major[t]=r.major,a.major[s]=r.major.map(t=>this.loc),3==o.levels&&(a.mids[t]=r.mids,a.mids[s]=r.mids.map(t=>this.loc)),o.levels>1&&(a.tops[t]=r.tops,a.tops[s]=r.tops.map(t=>this.loc)),a}}o.CategoricalAxisView=l,l.__name__="CategoricalAxisView";class _ extends e.Axis{constructor(t){super(t)}static init_CategoricalAxis(){this.prototype.default_view=l,this.mixins(["line:separator_","text:group_","text:subgroup_"]),this.define({group_label_orientation:[a.Any,"parallel"],subgroup_label_orientation:[a.Any,"parallel"]}),this.override({ticker:()=>new i.CategoricalTicker,formatter:()=>new r.CategoricalTickFormatter,separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"8pt",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"8pt"})}}o.CategoricalAxis=_,_.__name__="CategoricalAxis",_.init_CategoricalAxis()},
function _(t,c,o){const s=t(105);class e extends s.Ticker{constructor(t){super(t)}get_ticks(t,c,o,s,e){return{major:this._collect(o.factors,o,t,c),minor:[],tops:this._collect(o.tops||[],o,t,c),mids:this._collect(o.mids||[],o,t,c)}}_collect(t,c,o,s){const e=[];for(const r of t){const t=c.synthetic(r);t>o&&t<s&&e.push(r)}return e}}o.CategoricalTicker=e,e.__name__="CategoricalTicker"},
function _(t,r,o){const c=t(107),a=t(8);class e extends c.TickFormatter{constructor(t){super(t)}doFormat(t,r){return a.copy(t)}}o.CategoricalTickFormatter=e,e.__name__="CategoricalTickFormatter"},
function _(s,n,o){const t=s(141);class u extends t.Axis{constructor(s){super(s)}}o.ContinuousAxis=u,u.__name__="ContinuousAxis"},
function _(e,t,i){const s=e(148),a=e(149),n=e(154);class r extends s.LinearAxisView{}i.DatetimeAxisView=r,r.__name__="DatetimeAxisView";class m extends s.LinearAxis{constructor(e){super(e)}static init_DatetimeAxis(){this.prototype.default_view=r,this.override({ticker:()=>new n.DatetimeTicker,formatter:()=>new a.DatetimeTickFormatter})}}i.DatetimeAxis=m,m.__name__="DatetimeAxis",m.init_DatetimeAxis()},
function _(i,e,s){const t=i(141),n=i(146),r=i(106),a=i(102);class c extends t.AxisView{}s.LinearAxisView=c,c.__name__="LinearAxisView";class _ extends n.ContinuousAxis{constructor(i){super(i)}static init_LinearAxis(){this.prototype.default_view=c,this.override({ticker:()=>new a.BasicTicker,formatter:()=>new r.BasicTickFormatter})}}s.LinearAxis=_,_.__name__="LinearAxis",_.init_LinearAxis()},
function _(s,t,e){const r=s(150),i=s(107),n=s(65),o=s(18),a=s(151),c=s(8),m=s(7);function u(s){return r(s,"%Y %m %d %H %M %S").split(/\s+/).map(s=>parseInt(s,10))}function h(s,t){if(m.isFunction(t))return t(s);{const e=a.sprintf("$1%06d",function(s){return Math.round(s/1e3%1*1e6)}(s));return-1==(t=t.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?t:r(s,t)}}const d=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"];class l extends i.TickFormatter{constructor(s){super(s),this.strip_leading_zeros=!0}static init_DatetimeTickFormatter(){this.define({microseconds:[o.Array,["%fus"]],milliseconds:[o.Array,["%3Nms","%S.%3Ns"]],seconds:[o.Array,["%Ss"]],minsec:[o.Array,[":%M:%S"]],minutes:[o.Array,[":%M","%Mm"]],hourmin:[o.Array,["%H:%M"]],hours:[o.Array,["%Hh","%H:%M"]],days:[o.Array,["%m/%d","%a%d"]],months:[o.Array,["%m/%Y","%b %Y"]],years:[o.Array,["%Y"]]})}initialize(){super.initialize(),this._update_width_formats()}_update_width_formats(){const s=+r(new Date),t=function(t){const e=t.map(t=>h(s,t).length),r=c.sort_by(c.zip(e,t),([s])=>s);return c.unzip(r)};this._width_formats={microseconds:t(this.microseconds),milliseconds:t(this.milliseconds),seconds:t(this.seconds),minsec:t(this.minsec),minutes:t(this.minutes),hourmin:t(this.hourmin),hours:t(this.hours),days:t(this.days),months:t(this.months),years:t(this.years)}}_get_resolution_str(s,t){const e=1.1*s;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return t>=60?"minsec":"seconds";case!(e<3600):return t>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}}doFormat(s,t){if(0==s.length)return[];const e=Math.abs(s[s.length-1]-s[0])/1e3,r=e/(s.length-1),i=this._get_resolution_str(r,e),[,[o]]=this._width_formats[i],a=[],c=d.indexOf(i),m={};for(const s of d)m[s]=0;m.seconds=5,m.minsec=4,m.minutes=4,m.hourmin=3,m.hours=3;for(const t of s){let s,e;try{e=u(t),s=h(t,o)}catch(s){n.logger.warn(`unable to format tick for timestamp value ${t}`),n.logger.warn(` - ${s}`),a.push("ERR");continue}let r=!1,l=c;for(;0==e[m[d[l]]];){let n;if((l+=1)==d.length)break;if(("minsec"==i||"hourmin"==i)&&!r){if("minsec"==i&&0==e[4]&&0!=e[5]||"hourmin"==i&&0==e[3]&&0!=e[4]){s=h(t,n=this._width_formats[d[c-1]][1][0]);break}r=!0}s=h(t,n=this._width_formats[d[l]][1][0])}if(this.strip_leading_zeros){let t=s.replace(/^0+/g,"");t!=s&&isNaN(parseInt(t))&&(t=`0${t}`),a.push(t)}else a.push(s)}return a}}e.DatetimeTickFormatter=l,l.__name__="DatetimeTickFormatter",l.init_DatetimeTickFormatter()},
function _(e,t,n){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}(function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort(function(e,t){return e.sort-t.sort}),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.22";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e})):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,function(e){a[e].pad=2}),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}})},
function _(r,n,e){const t=r(152),i=r(153),u=r(150),a=r(25),f=r(7);function o(r,...n){return t.sprintf(r,...n)}function l(r,n,e){if(f.isNumber(r)){return o((()=>{switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}})(),r)}return`${r}`}function s(r,n,t,i){if(null==t)return l;if(null!=i&&(r in i||n in i)){const t=i[n in i?n:r];if(f.isString(t)){if(t in e.DEFAULT_FORMATTERS)return e.DEFAULT_FORMATTERS[t];throw new Error(`Unknown tooltip field formatter type '${t}'`)}return function(r,n,e){return t.format(r,n,e)}}return e.DEFAULT_FORMATTERS.numeral}function c(r,n,e,t){if("$"==r[0]){if(r.substring(1)in t)return t[r.substring(1)];throw new Error(`Unknown special variable '${r}'`)}const i=n.get_column(r);if(null==i)return null;if(f.isNumber(e))return i[e];const u=i[e.index];if(f.isTypedArray(u)||f.isArray(u)){if(f.isArray(u[0])){return u[e.dim2][e.dim1]}return u[e.flat_index]}return u}e.sprintf=o,e.DEFAULT_FORMATTERS={numeral:(r,n,e)=>i.format(r,n),datetime:(r,n,e)=>u(r,n),printf:(r,n,e)=>o(n,r)},e.basic_formatter=l,e.get_formatter=s,e.get_value=c,e.replace_placeholders=function(r,n,e,t,i={}){const u=r.replace(/(?:^|[^@])([@|\$](?:\w+|{[^{}]+}))(?:{[^{}]+})?/g,(r,n,e)=>`${n}`);return r=(r=(r=r.replace(/@\$name/g,r=>`@{${i.name}}`)).replace(/(^|[^\$])\$(\w+)/g,(r,n,e)=>`${n}@$${e}`)).replace(/(^|[^@])@(?:(\$?\w+)|{([^{}]+)})(?:{([^{}]+)})?/g,(r,f,o,l,$)=>{const m=c(o=null!=l?l:o,n,e,i);if(null==m)return`${f}${a.escape("???")}`;if("safe"==$)return`${f}${m}`;const p=s(o,u,$,t);return`${f}${a.escape(p(m,$,i))}`})}},
function _(e,n,t){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(t){return function(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}(function(n){if(i[n])return i[n];var t,r=n,s=[],a=0;for(;r;){if(null!==(t=e.text.exec(r)))s.push(t[0]);else if(null!==(t=e.modulo.exec(r)))s.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");s.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return i[n]=s}(t),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}var i=Object.create(null);void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define(function(){return{sprintf:n,vsprintf:r}}))}()},
function _(e,n,t){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var r,i={},a=i,o="en-US",l=null,u="0,0";void 0!==n&&n.exports;function c(e){this._value=e}function s(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function f(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+s(i-r.length),n>0&&(a+="."+s(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function d(e,n,t){return n.indexOf("$")>-1?function(e,n,t){var r,a,l=n,u=l.indexOf("$"),c=l.indexOf("("),s=l.indexOf("+"),f=l.indexOf("-"),d="",p="";-1===l.indexOf("$")?"infix"===i[o].currency.position?(p=i[o].currency.symbol,i[o].currency.spaceSeparated&&(p=" "+p+" ")):i[o].currency.spaceSeparated&&(d=" "):l.indexOf(" $")>-1?(d=" ",l=l.replace(" $","")):l.indexOf("$ ")>-1?(d=" ",l=l.replace("$ ","")):l=l.replace("$","");if(a=h(e,l,t,p),-1===n.indexOf("$"))switch(i[o].currency.position){case"postfix":a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;break;case"infix":break;case"prefix":a.indexOf("(")>-1||a.indexOf("-")>-1?(a=a.split(""),r=Math.max(c,f)+1,a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else u<=1?a.indexOf("(")>-1||a.indexOf("+")>-1||a.indexOf("-")>-1?(a=a.split(""),r=1,(u<c||u<s||u<f)&&(r=0),a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a:a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;return a}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=h(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):h(e,n,t)}function h(e,n,t,r){var a,u,c,s,d,h,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==l)return l;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(d=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(h=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,d)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===h?0:3*~~(h/3)-h)<0?M+3:M,a=0;a<M;a++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=i[o].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=i[o].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=i[o].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=i[o].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(u=Math.pow(1024,s),c=Math.pow(1024,s+1),e>=u&&e<c){C+=K[s],u>0&&(e/=u);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(u=Math.pow(1e3,s),c=Math.pow(1e3,s+1),e>=u&&e<c){C+=G[s],u>0&&(e/=u);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),i[o].ordinal&&(L+=i[o].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?f(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?f(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):f(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:i[o].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=f(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+i[o].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function p(e,n){i[e]=n}function m(e){o=e;var n=i[e].defaults;n&&n.format&&r.defaultFormat(n.format),n&&n.currencyFormat&&r.defaultCurrencyFormat(n.currencyFormat)}(r=function(e){return r.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=r.fn.unformat(e)),new c(Number(e))}).version="1.6.2",r.isNumbro=function(e){return e instanceof c},r.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;a[t]||(Object.keys(a).forEach(function(e){i||e.split("-")[0]!==r||(i=e)}),t=i||n||"en-US"),m(t)},r.setCulture=function(e,n){var t=e,r=e.split("-")[1],a=null;i[t]||(r&&Object.keys(i).forEach(function(e){a||e.split("-")[1]!==r||(a=e)}),t=a||n||"en-US"),m(t)},r.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return o;if(e&&!n){if(!a[e])throw new Error("Unknown language : "+e);m(e)}return!n&&a[e]||p(e,n),r},r.culture=function(e,n){if(!e)return o;if(e&&!n){if(!i[e])throw new Error("Unknown culture : "+e);m(e)}return!n&&i[e]||p(e,n),r},r.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return a[o];if(!a[e])throw new Error("Unknown language : "+e);return a[e]},r.cultureData=function(e){if(!e)return i[o];if(!i[e])throw new Error("Unknown culture : "+e);return i[e]},r.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),r.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),a},r.cultures=function(){return i},r.zeroFormat=function(e){l="string"==typeof e?e:null},r.defaultFormat=function(e){u="string"==typeof e?e:"0.0"},r.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},r.validate=function(e,n){var t,i,a,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=r.cultureData(n)}catch(e){c=r.cultureData(r.culture())}return a=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,i="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===a))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(i+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,i){return null!=t&&t!==r.culture()&&r.setCulture(t),d(Number(e),null!=n?n:u,null==i?Math.round:i)}}},
function _(e,i,n){const t=e(8),a=e(103),s=e(155),r=e(156),c=e(159),m=e(160),_=e(158);class k extends s.CompositeTicker{constructor(e){super(e)}static init_DatetimeTicker(){this.override({num_minor_ticks:0,tickers:()=>[new a.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*_.ONE_MILLI,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:_.ONE_SECOND,max_interval:30*_.ONE_MINUTE,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:_.ONE_HOUR,max_interval:12*_.ONE_HOUR,num_minor_ticks:0}),new r.DaysTicker({days:t.range(1,32)}),new r.DaysTicker({days:t.range(1,31,3)}),new r.DaysTicker({days:[1,8,15,22]}),new r.DaysTicker({days:[1,15]}),new c.MonthsTicker({months:t.range(0,12,1)}),new c.MonthsTicker({months:t.range(0,12,2)}),new c.MonthsTicker({months:t.range(0,12,4)}),new c.MonthsTicker({months:t.range(0,12,6)}),new m.YearsTicker({})]})}}n.DatetimeTicker=k,k.__name__="DatetimeTicker",k.init_DatetimeTicker()},
function _(t,e,i){const s=t(104),r=t(18),n=t(8),_=t(22);class a extends s.ContinuousTicker{constructor(t){super(t)}static init_CompositeTicker(){this.define({tickers:[r.Array,[]]})}get min_intervals(){return this.tickers.map(t=>t.get_min_interval())}get max_intervals(){return this.tickers.map(t=>t.get_max_interval())}get min_interval(){return this.min_intervals[0]}get max_interval(){return this.max_intervals[0]}get_best_ticker(t,e,i){const s=e-t,r=this.get_ideal_interval(t,e,i),a=[n.sorted_index(this.min_intervals,r)-1,n.sorted_index(this.max_intervals,r)],c=[this.min_intervals[a[0]],this.max_intervals[a[1]]].map(t=>Math.abs(i-s/t));let l;if(_.isEmpty(c.filter(t=>!isNaN(t))))l=this.tickers[0];else{const t=a[n.argmin(c)];l=this.tickers[t]}return l}get_interval(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)}get_ticks_no_defaults(t,e,i,s){return this.get_best_ticker(t,e,s).get_ticks_no_defaults(t,e,i,s)}}i.CompositeTicker=a,a.__name__="CompositeTicker",a.init_CompositeTicker()},
function _(t,e,n){const i=t(157),s=t(158),a=t(18),o=t(8);class r extends i.SingleIntervalTicker{constructor(t){super(t)}static init_DaysTicker(){this.define({days:[a.Array,[]]}),this.override({num_minor_ticks:0})}initialize(){super.initialize();const t=this.days;t.length>1?this.interval=(t[1]-t[0])*s.ONE_DAY:this.interval=31*s.ONE_DAY}get_ticks_no_defaults(t,e,n,i){const a=function(t,e){const n=s.last_month_no_later_than(new Date(t)),i=s.last_month_no_later_than(new Date(e));i.setUTCMonth(i.getUTCMonth()+1);const a=[],o=n;for(;a.push(s.copy_date(o)),o.setUTCMonth(o.getUTCMonth()+1),!(o>i););return a}(t,e),r=this.days,c=this.interval;return{major:o.concat(a.map(t=>((t,e)=>{const n=t.getUTCMonth(),i=[];for(const a of r){const o=s.copy_date(t);o.setUTCDate(a),new Date(o.getTime()+e/2).getUTCMonth()==n&&i.push(o)}return i})(t,c))).map(t=>t.getTime()).filter(n=>t<=n&&n<=e),minor:[]}}}n.DaysTicker=r,r.__name__="DaysTicker",r.init_DaysTicker()},
function _(e,t,n){const i=e(104),r=e(18);class l extends i.ContinuousTicker{constructor(e){super(e)}static init_SingleIntervalTicker(){this.define({interval:[r.Number]})}get_interval(e,t,n){return this.interval}get min_interval(){return this.interval}get max_interval(){return this.interval}}n.SingleIntervalTicker=l,l.__name__="SingleIntervalTicker",l.init_SingleIntervalTicker()},
function _(t,n,e){function _(t){return new Date(t.getTime())}function E(t){const n=_(t);return n.setUTCDate(1),n.setUTCHours(0),n.setUTCMinutes(0),n.setUTCSeconds(0),n.setUTCMilliseconds(0),n}e.ONE_MILLI=1,e.ONE_SECOND=1e3,e.ONE_MINUTE=60*e.ONE_SECOND,e.ONE_HOUR=60*e.ONE_MINUTE,e.ONE_DAY=24*e.ONE_HOUR,e.ONE_MONTH=30*e.ONE_DAY,e.ONE_YEAR=365*e.ONE_DAY,e.copy_date=_,e.last_month_no_later_than=E,e.last_year_no_later_than=function(t){const n=E(t);return n.setUTCMonth(0),n}},
function _(t,e,n){const i=t(157),s=t(158),r=t(18),a=t(8);class o extends i.SingleIntervalTicker{constructor(t){super(t)}static init_MonthsTicker(){this.define({months:[r.Array,[]]})}initialize(){super.initialize();const t=this.months;t.length>1?this.interval=(t[1]-t[0])*s.ONE_MONTH:this.interval=12*s.ONE_MONTH}get_ticks_no_defaults(t,e,n,i){const r=function(t,e){const n=s.last_year_no_later_than(new Date(t)),i=s.last_year_no_later_than(new Date(e));i.setUTCFullYear(i.getUTCFullYear()+1);const r=[],a=n;for(;r.push(s.copy_date(a)),a.setUTCFullYear(a.getUTCFullYear()+1),!(a>i););return r}(t,e),o=this.months;return{major:a.concat(r.map(t=>o.map(e=>{const n=s.copy_date(t);return n.setUTCMonth(e),n}))).map(t=>t.getTime()).filter(n=>t<=n&&n<=e),minor:[]}}}n.MonthsTicker=o,o.__name__="MonthsTicker",o.init_MonthsTicker()},
function _(e,t,a){const i=e(102),r=e(157),n=e(158);class _ extends r.SingleIntervalTicker{constructor(e){super(e)}initialize(){super.initialize(),this.interval=n.ONE_YEAR,this.basic_ticker=new i.BasicTicker({num_minor_ticks:0})}get_ticks_no_defaults(e,t,a,i){const r=n.last_year_no_later_than(new Date(e)).getUTCFullYear(),_=n.last_year_no_later_than(new Date(t)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,_,a,i).major.map(e=>Date.UTC(e,0,1)).filter(a=>e<=a&&a<=t),minor:[]}}}a.YearsTicker=_,_.__name__="YearsTicker"},
function _(i,e,s){const t=i(141),o=i(146),n=i(162),r=i(163);class _ extends t.AxisView{}s.LogAxisView=_,_.__name__="LogAxisView";class c extends o.ContinuousAxis{constructor(i){super(i)}static init_LogAxis(){this.prototype.default_view=_,this.override({ticker:()=>new r.LogTicker,formatter:()=>new n.LogTickFormatter})}}s.LogAxis=c,c.__name__="LogAxis",c.init_LogAxis()},
function _(t,i,e){const r=t(107),o=t(106),a=t(65),n=t(18);class c extends r.TickFormatter{constructor(t){super(t)}static init_LogTickFormatter(){this.define({ticker:[n.Instance,null]})}initialize(){super.initialize(),this.basic_formatter=new o.BasicTickFormatter,null==this.ticker&&a.logger.warn("LogTickFormatter not configured with a ticker, using default base of 10 (labels will be incorrect if ticker base is not 10)")}doFormat(t,i){if(0==t.length)return[];const e=null!=this.ticker?this.ticker.base:10;let r=!1;const o=new Array(t.length);for(let i=0,a=t.length;i<a;i++)if(o[i]=`${e}^${Math.round(Math.log(t[i])/Math.log(e))}`,i>0&&o[i]==o[i-1]){r=!0;break}return r?this.basic_formatter.doFormat(t,i):o}}e.LogTickFormatter=c,c.__name__="LogTickFormatter",c.init_LogTickFormatter()},
function _(t,o,e){const i=t(103),s=t(8);class n extends i.AdaptiveTicker{constructor(t){super(t)}static init_LogTicker(){this.override({mantissas:[1,5]})}get_ticks_no_defaults(t,o,e,i){const n=this.num_minor_ticks,r=[],a=this.base,c=Math.log(t)/Math.log(a),f=Math.log(o)/Math.log(a),h=f-c;let l;if(isFinite(h))if(h<2){const e=this.get_interval(t,o,i),a=Math.floor(t/e),c=Math.ceil(o/e);if(l=s.range(a,c+1).filter(t=>0!=t).map(t=>t*e).filter(e=>t<=e&&e<=o),n>0&&l.length>0){const t=e/n,o=s.range(0,n).map(o=>o*t);for(const t of o.slice(1))r.push(l[0]-t);for(const t of l)for(const e of o)r.push(t+e)}}else{const t=Math.ceil(.999999*c),o=Math.floor(1.000001*f),e=Math.ceil((o-t)/9);if(l=s.range(t-1,o+1,e).map(t=>Math.pow(a,t)),n>0&&l.length>0){const t=Math.pow(a,e)/n,o=s.range(1,n+1).map(o=>o*t);for(const t of o)r.push(l[0]/t);r.push(l[0]);for(const t of l)for(const e of o)r.push(t*e)}}else l=[];return{major:l.filter(e=>t<=e&&e<=o),minor:r.filter(e=>t<=e&&e<=o)}}}e.LogTicker=n,n.__name__="LogTicker",n.init_LogTicker()},
function _(e,t,i){const r=e(141),s=e(148),a=e(165),o=e(166);class c extends r.AxisView{}i.MercatorAxisView=c,c.__name__="MercatorAxisView";class n extends s.LinearAxis{constructor(e){super(e)}static init_MercatorAxis(){this.prototype.default_view=c,this.override({ticker:()=>new o.MercatorTicker({dimension:"lat"}),formatter:()=>new a.MercatorTickFormatter({dimension:"lat"})})}}i.MercatorAxis=n,n.__name__="MercatorAxis",n.init_MercatorAxis()},
function _(r,t,e){const o=r(106),n=r(18),i=r(30);class c extends o.BasicTickFormatter{constructor(r){super(r)}static init_MercatorTickFormatter(){this.define({dimension:[n.LatLon]})}doFormat(r,t){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==r.length)return[];const e=r.length,o=new Array(e);if("lon"==this.dimension)for(let n=0;n<e;n++){const[e]=i.wgs84_mercator.inverse([r[n],t.loc]);o[n]=e}else for(let n=0;n<e;n++){const[,e]=i.wgs84_mercator.inverse([t.loc,r[n]]);o[n]=e}return super.doFormat(o,t)}}e.MercatorTickFormatter=c,c.__name__="MercatorTickFormatter",c.init_MercatorTickFormatter()},
function _(r,o,n){const s=r(102),i=r(18),e=r(30);class t extends s.BasicTicker{constructor(r){super(r)}static init_MercatorTicker(){this.define({dimension:[i.LatLon]})}get_ticks_no_defaults(r,o,n,s){if(null==this.dimension)throw new Error("MercatorTicker.dimension not configured");let i,t,c;[r,o]=e.clip_mercator(r,o,this.dimension),"lon"===this.dimension?([i,c]=e.wgs84_mercator.inverse([r,n]),[t,c]=e.wgs84_mercator.inverse([o,n])):([c,i]=e.wgs84_mercator.inverse([n,r]),[c,t]=e.wgs84_mercator.inverse([n,o]));const a=super.get_ticks_no_defaults(i,t,n,s),_=[],f=[];if("lon"===this.dimension){for(const r of a.major)if(e.in_bounds(r,"lon")){const[o]=e.wgs84_mercator.forward([r,c]);_.push(o)}for(const r of a.minor)if(e.in_bounds(r,"lon")){const[o]=e.wgs84_mercator.forward([r,c]);f.push(o)}}else{for(const r of a.major)if(e.in_bounds(r,"lat")){const[,o]=e.wgs84_mercator.forward([c,r]);_.push(o)}for(const r of a.minor)if(e.in_bounds(r,"lat")){const[,o]=e.wgs84_mercator.forward([c,r]);f.push(o)}}return{major:_,minor:f}}}n.MercatorTicker=t,t.__name__="MercatorTicker",t.init_MercatorTicker()},
function _(n,o,t){var u=n(168);t.CustomJS=u.CustomJS;var a=n(170);t.OpenURL=a.OpenURL},
function _(t,s,e){const n=t(169),c=t(18),i=t(22),u=t(25);class r extends n.Callback{constructor(t){super(t)}static init_CustomJS(){this.define({args:[c.Any,{}],code:[c.String,""],use_strict:[c.Boolean,!1]})}get names(){return i.keys(this.args)}get values(){return i.values(this.args)}get func(){const t=this.use_strict?u.use_strict(this.code):this.code;return new Function(...this.names,"cb_obj","cb_data","require","exports",t)}execute(s,e={}){return this.func.apply(s,this.values.concat(s,e,t,{}))}}e.CustomJS=r,r.__name__="CustomJS",r.init_CustomJS()},
function _(c,a,l){const n=c(64);class s extends n.Model{constructor(c){super(c)}}l.Callback=s,s.__name__="Callback"},
function _(e,n,t){const o=e(169),s=e(151),c=e(18);class i extends o.Callback{constructor(e){super(e)}static init_OpenURL(){this.define({url:[c.String,"http://"],same_tab:[c.Boolean,!1]})}execute(e,{source:n}){const t=e=>{const t=s.replace_placeholders(this.url,n,e);this.same_tab?window.location.href=t:window.open(t)},{selected:o}=n;for(const e of o.indices)t(e);for(const e of o.line_indices)t(e)}}t.OpenURL=i,i.__name__="OpenURL",i.init_OpenURL()},
function _(a,n,r){var e=a(172);r.Canvas=e.Canvas;var s=a(176);r.CartesianFrame=s.CartesianFrame},
function _(t,e,s){const i=t(12),a=t(59),n=t(65),l=t(18),h=t(61),c=t(79),o=t(95),_=t(173),d=t(174);o.is_ie&&"undefined"!=typeof CanvasPixelArray&&(CanvasPixelArray.prototype.set=function(t){for(let e=0;e<this.length;e++)this[e]=t[e]});const p=t(175);class r extends a.DOMView{get ctx(){return this._ctx}initialize(){super.initialize(),this.map_el=this.model.map?this.el.appendChild(h.div({class:d.bk_canvas_map})):null;const t={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};switch(this.model.output_backend){case"canvas":case"webgl":{this.canvas_el=this.el.appendChild(h.canvas({class:d.bk_canvas,style:t}));const e=this.canvas_el.getContext("2d");if(null==e)throw new Error("unable to obtain 2D rendering context");this._ctx=e;break}case"svg":{const t=new p;this._ctx=t,this.canvas_el=this.el.appendChild(t.getSvg());break}}this.overlays_el=this.el.appendChild(h.div({class:d.bk_canvas_overlays,style:t})),this.events_el=this.el.appendChild(h.div({class:d.bk_canvas_events,style:t})),_.fixup_ctx(this._ctx),n.logger.debug("CanvasView initialized")}get_canvas_element(){return this.canvas_el}prepare_canvas(t,e){this.bbox=new c.BBox({left:0,top:0,width:t,height:e}),this.el.style.width=`${t}px`,this.el.style.height=`${e}px`;const s=_.get_scale_ratio(this.ctx,this.model.use_hidpi,this.model.output_backend);this.model.pixel_ratio=s,this.canvas_el.style.width=`${t}px`,this.canvas_el.style.height=`${e}px`,this.canvas_el.setAttribute("width",`${t*s}`),this.canvas_el.setAttribute("height",`${e*s}`),n.logger.debug(`Rendering CanvasView with width: ${t}, height: ${e}, pixel ratio: ${s}`)}}s.CanvasView=r,r.__name__="CanvasView";class v extends i.HasProps{constructor(t){super(t)}static init_Canvas(){this.prototype.default_view=r,this.internal({map:[l.Boolean,!1],use_hidpi:[l.Boolean,!0],pixel_ratio:[l.Number,1],output_backend:[l.OutputBackend,"canvas"]})}}s.Canvas=v,v.__name__="Canvas",v.init_Canvas()},
function _(e,t,i){i.fixup_ctx=function(e){!function(e){e.setLineDash||(e.setLineDash=(t=>{e.mozDash=t,e.webkitLineDash=t})),e.getLineDash||(e.getLineDash=(()=>e.mozDash))}(e),function(e){e.setLineDashOffset=(t=>{e.lineDashOffset=t,e.mozDashOffset=t,e.webkitLineDashOffset=t}),e.getLineDashOffset=(()=>e.mozDashOffset)}(e),function(e){e.setImageSmoothingEnabled=(t=>{e.imageSmoothingEnabled=t,e.mozImageSmoothingEnabled=t,e.oImageSmoothingEnabled=t,e.webkitImageSmoothingEnabled=t,e.msImageSmoothingEnabled=t}),e.getImageSmoothingEnabled=(()=>{const t=e.imageSmoothingEnabled;return null==t||t})}(e),function(e){e.measureText&&null==e.html5MeasureText&&(e.html5MeasureText=e.measureText,e.measureText=(t=>{const i=e.html5MeasureText(t);return i.ascent=1.6*e.html5MeasureText("m").width,i}))}(e),function(e){e.ellipse||(e.ellipse=function(t,i,n,o,a,s,r,m=!1){const l=.551784;e.translate(t,i),e.rotate(a);let u=n,g=o;m&&(u=-n,g=-o),e.moveTo(-u,0),e.bezierCurveTo(-u,g*l,-u*l,g,0,g),e.bezierCurveTo(u*l,g,u,g*l,u,0),e.bezierCurveTo(u,-g*l,u*l,-g,0,-g),e.bezierCurveTo(-u*l,-g,-u,-g*l,-u,0),e.rotate(-a),e.translate(-t,-i)})}(e)},i.get_scale_ratio=function(e,t,i){if("svg"==i)return 1;if(t)return(window.devicePixelRatio||1)/(e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.msBackingStorePixelRatio||e.oBackingStorePixelRatio||e.backingStorePixelRatio||1);return 1}},
function _(a,n,s){a(62),s.bk_canvas="bk-canvas",s.bk_canvas_map="bk-canvas-map",s.bk_canvas_overlays="bk-canvas-overlays",s.bk_canvas_events="bk-canvas-events"},
function _(t,e,r){!function(){"use strict";var t,r,i,n,s;function a(t,e){var r,i=Object.keys(e);for(r=0;r<i.length;r++)t=t.replace(new RegExp("\\{"+i[r]+"\\}","gi"),e[i[r]]);return t}function o(t){var e,r,i;if(!t)throw new Error("cannot create a random attribute name for an undefined object");e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz",r="";do{for(r="",i=0;i<12;i++)r+=e[Math.floor(Math.random()*e.length)]}while(t[r]);return r}function h(t){var e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return e[t]||e.alphabetic}s=function(t,e){var r,i,n,s={};for(t=t.split(","),e=e||10,r=0;r<t.length;r+=2)i="&"+t[r+1]+";",n=parseInt(t[r],e),s[i]="&#"+n+";";return s["\\xa0"]="&#160;",s}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),t={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}},(i=function(t,e){this.__root=t,this.__ctx=e}).prototype.addColorStop=function(t,e){var r,i=this.__ctx.__createElement("stop");i.setAttribute("offset",t),-1!==e.indexOf("rgba")?(r=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),i.setAttribute("stop-color",a("rgb({r},{g},{b})",{r:r[1],g:r[2],b:r[3]})),i.setAttribute("stop-opacity",r[4])):i.setAttribute("stop-color",e),this.__root.appendChild(i)},n=function(t,e){this.__root=t,this.__ctx=e},(r=function(t){var e,i={width:500,height:500,enableMirroring:!1};if(arguments.length>1?((e=i).width=arguments[0],e.height=arguments[1]):e=t||i,!(this instanceof r))return new r(e);this.width=e.width||i.width,this.height=e.height||i.height,this.enableMirroring=void 0!==e.enableMirroring?e.enableMirroring:i.enableMirroring,this.canvas=this,this.__document=e.document||document,e.ctx?this.__ctx=e.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[this.__getStyleState()],this.__groupStack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version",1.1),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.__root.setAttribute("width",this.width),this.__root.setAttribute("height",this.height),this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs),this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g"),this.__root.appendChild(this.__currentElement)}).prototype.__createElement=function(t,e,r){void 0===e&&(e={});var i,n,s=this.__document.createElementNS("http://www.w3.org/2000/svg",t),a=Object.keys(e);for(r&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none")),i=0;i<a.length;i++)n=a[i],s.setAttribute(n,e[n]);return s},r.prototype.__setDefaultStyles=function(){var e,r,i=Object.keys(t);for(e=0;e<i.length;e++)this[r=i[e]]=t[r].canvas},r.prototype.__applyStyleState=function(t){var e,r,i=Object.keys(t);for(e=0;e<i.length;e++)this[r=i[e]]=t[r]},r.prototype.__getStyleState=function(){var e,r,i={},n=Object.keys(t);for(e=0;e<n.length;e++)i[r=n[e]]=this[r];return i},r.prototype.__applyStyleToCurrentElement=function(e){var r=this.__currentElement,s=this.__currentElementsToStyle;s&&(r.setAttribute(e,""),r=s.element,s.children.forEach(function(t){t.setAttribute(e,"")}));var o,h,l,c,p,_=Object.keys(t);for(o=0;o<_.length;o++)if(h=t[_[o]],l=this[_[o]],h.apply)if(l instanceof n){if(l.__ctx)for(;l.__ctx.__defs.childNodes.length;)c=l.__ctx.__defs.childNodes[0].getAttribute("id"),this.__ids[c]=c,this.__defs.appendChild(l.__ctx.__defs.childNodes[0]);r.setAttribute(h.apply,a("url(#{id})",{id:l.__root.getAttribute("id")}))}else if(l instanceof i)r.setAttribute(h.apply,a("url(#{id})",{id:l.__root.getAttribute("id")}));else if(-1!==h.apply.indexOf(e)&&h.svg!==l)if("stroke"!==h.svgAttr&&"fill"!==h.svgAttr||-1===l.indexOf("rgba")){var u=h.svgAttr;if("globalAlpha"===_[o]&&(u=e+"-"+h.svgAttr,r.getAttribute(u)))continue;r.setAttribute(u,l)}else{p=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(l),r.setAttribute(h.svgAttr,a("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var d=p[4],g=this.globalAlpha;null!=g&&(d*=g),r.setAttribute(h.svgAttr+"-opacity",d)}},r.prototype.__closestGroupOrSvg=function(t){return"g"===(t=t||this.__currentElement).nodeName||"svg"===t.nodeName?t:this.__closestGroupOrSvg(t.parentNode)},r.prototype.getSerializedSvg=function(t){var e,r,i,n,a,o=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(o)&&(o=o.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)for(e=Object.keys(s),r=0;r<e.length;r++)i=e[r],n=s[i],(a=new RegExp(i,"gi")).test(o)&&(o=o.replace(a,n));return o},r.prototype.getSvg=function(){return this.__root},r.prototype.save=function(){var t=this.__createElement("g"),e=this.__closestGroupOrSvg();this.__groupStack.push(e),e.appendChild(t),this.__currentElement=t,this.__stack.push(this.__getStyleState())},r.prototype.restore=function(){this.__currentElement=this.__groupStack.pop(),this.__currentElementsToStyle=null,this.__currentElement||(this.__currentElement=this.__root.childNodes[1]);var t=this.__stack.pop();this.__applyStyleState(t)},r.prototype.__addTransform=function(t){var e=this.__closestGroupOrSvg();if(e.childNodes.length>0){"path"===this.__currentElement.nodeName&&(this.__currentElementsToStyle||(this.__currentElementsToStyle={element:e,children:[]}),this.__currentElementsToStyle.children.push(this.__currentElement),this.__applyCurrentDefaultPath());var r=this.__createElement("g");e.appendChild(r),this.__currentElement=r}var i=this.__currentElement.getAttribute("transform");i?i+=" ":i="",i+=t,this.__currentElement.setAttribute("transform",i)},r.prototype.scale=function(t,e){void 0===e&&(e=t),this.__addTransform(a("scale({x},{y})",{x:t,y:e}))},r.prototype.rotate=function(t){var e=180*t/Math.PI;this.__addTransform(a("rotate({angle},{cx},{cy})",{angle:e,cx:0,cy:0}))},r.prototype.translate=function(t,e){this.__addTransform(a("translate({x},{y})",{x:t,y:e}))},r.prototype.transform=function(t,e,r,i,n,s){this.__addTransform(a("matrix({a},{b},{c},{d},{e},{f})",{a:t,b:e,c:r,d:i,e:n,f:s}))},r.prototype.beginPath=function(){var t;this.__currentDefaultPath="",this.__currentPosition={},t=this.__createElement("path",{},!0),this.__closestGroupOrSvg().appendChild(t),this.__currentElement=t},r.prototype.__applyCurrentDefaultPath=function(){var t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)},r.prototype.__addPathCommand=function(t){this.__currentDefaultPath+=" ",this.__currentDefaultPath+=t},r.prototype.moveTo=function(t,e){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.__currentPosition={x:t,y:e},this.__addPathCommand(a("M {x} {y}",{x:t,y:e}))},r.prototype.closePath=function(){this.__currentDefaultPath&&this.__addPathCommand("Z")},r.prototype.lineTo=function(t,e){this.__currentPosition={x:t,y:e},this.__currentDefaultPath.indexOf("M")>-1?this.__addPathCommand(a("L {x} {y}",{x:t,y:e})):this.__addPathCommand(a("M {x} {y}",{x:t,y:e}))},r.prototype.bezierCurveTo=function(t,e,r,i,n,s){this.__currentPosition={x:n,y:s},this.__addPathCommand(a("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:t,cp1y:e,cp2x:r,cp2y:i,x:n,y:s}))},r.prototype.quadraticCurveTo=function(t,e,r,i){this.__currentPosition={x:r,y:i},this.__addPathCommand(a("Q {cpx} {cpy} {x} {y}",{cpx:t,cpy:e,x:r,y:i}))};var l=function(t){var e=Math.sqrt(t[0]*t[0]+t[1]*t[1]);return[t[0]/e,t[1]/e]};r.prototype.arcTo=function(t,e,r,i,n){var s=this.__currentPosition&&this.__currentPosition.x,a=this.__currentPosition&&this.__currentPosition.y;if(void 0!==s&&void 0!==a){if(n<0)throw new Error("IndexSizeError: The radius provided ("+n+") is negative.");if(s===t&&a===e||t===r&&e===i||0===n)this.lineTo(t,e);else{var o=l([s-t,a-e]),h=l([r-t,i-e]);if(o[0]*h[1]!=o[1]*h[0]){var c=o[0]*h[0]+o[1]*h[1],p=Math.acos(Math.abs(c)),_=l([o[0]+h[0],o[1]+h[1]]),u=n/Math.sin(p/2),d=t+u*_[0],g=e+u*_[1],m=[-o[1],o[0]],f=[h[1],-h[0]],y=function(t){var e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)},v=y(m),b=y(f);this.lineTo(d+m[0]*n,g+m[1]*n),this.arc(d,g,n,v,b)}else this.lineTo(t,e)}}},r.prototype.stroke=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill stroke markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke")},r.prototype.fill=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke fill markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill")},r.prototype.rect=function(t,e,r,i){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+r,e),this.lineTo(t+r,e+i),this.lineTo(t,e+i),this.lineTo(t,e),this.closePath()},r.prototype.fillRect=function(t,e,r,i){var n;n=this.__createElement("rect",{x:t,y:e,width:r,height:i},!0),this.__closestGroupOrSvg().appendChild(n),this.__currentElement=n,this.__applyStyleToCurrentElement("fill")},r.prototype.strokeRect=function(t,e,r,i){var n;n=this.__createElement("rect",{x:t,y:e,width:r,height:i},!0),this.__closestGroupOrSvg().appendChild(n),this.__currentElement=n,this.__applyStyleToCurrentElement("stroke")},r.prototype.__clearCanvas=function(){for(var t=this.__closestGroupOrSvg().getAttribute("transform"),e=this.__root.childNodes[1],r=e.childNodes,i=r.length-1;i>=0;i--)r[i]&&e.removeChild(r[i]);this.__currentElement=e,this.__groupStack=[],t&&this.__addTransform(t)},r.prototype.clearRect=function(t,e,r,i){if(0!==t||0!==e||r!==this.width||i!==this.height){var n,s=this.__closestGroupOrSvg();n=this.__createElement("rect",{x:t,y:e,width:r,height:i,fill:"#FFFFFF"},!0),s.appendChild(n)}else this.__clearCanvas()},r.prototype.createLinearGradient=function(t,e,r,n){var s=this.__createElement("linearGradient",{id:o(this.__ids),x1:t+"px",x2:r+"px",y1:e+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(s),new i(s,this)},r.prototype.createRadialGradient=function(t,e,r,n,s,a){var h=this.__createElement("radialGradient",{id:o(this.__ids),cx:n+"px",cy:s+"px",r:a+"px",fx:t+"px",fy:e+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(h),new i(h,this)},r.prototype.__parseFont=function(){var t=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),e={style:t[1]||"normal",size:t[4]||"10px",family:t[6]||"sans-serif",weight:t[3]||"normal",decoration:t[2]||"normal",href:null};return"underline"===this.__fontUnderline&&(e.decoration="underline"),this.__fontHref&&(e.href=this.__fontHref),e},r.prototype.__wrapTextLink=function(t,e){if(t.href){var r=this.__createElement("a");return r.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),r.appendChild(e),r}return e},r.prototype.__applyText=function(t,e,r,i){var n,s,a=this.__parseFont(),o=this.__closestGroupOrSvg(),l=this.__createElement("text",{"font-family":a.family,"font-size":a.size,"font-style":a.style,"font-weight":a.weight,"text-decoration":a.decoration,x:e,y:r,"text-anchor":(n=this.textAlign,s={left:"start",right:"end",center:"middle",start:"start",end:"end"},s[n]||s.start),"dominant-baseline":h(this.textBaseline)},!0);l.appendChild(this.__document.createTextNode(t)),this.__currentElement=l,this.__applyStyleToCurrentElement(i),o.appendChild(this.__wrapTextLink(a,l))},r.prototype.fillText=function(t,e,r){this.__applyText(t,e,r,"fill")},r.prototype.strokeText=function(t,e,r){this.__applyText(t,e,r,"stroke")},r.prototype.measureText=function(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)},r.prototype.arc=function(t,e,r,i,n,s){if(i!==n){(i%=2*Math.PI)===(n%=2*Math.PI)&&(n=(n+2*Math.PI-.001*(s?-1:1))%(2*Math.PI));var o=t+r*Math.cos(n),h=e+r*Math.sin(n),l=t+r*Math.cos(i),c=e+r*Math.sin(i),p=s?0:1,_=0,u=n-i;u<0&&(u+=2*Math.PI),_=s?u>Math.PI?0:1:u>Math.PI?1:0,this.lineTo(l,c),this.__addPathCommand(a("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:r,ry:r,xAxisRotation:0,largeArcFlag:_,sweepFlag:p,endX:o,endY:h})),this.__currentPosition={x:o,y:h}}},r.prototype.clip=function(){var t=this.__closestGroupOrSvg(),e=this.__createElement("clipPath"),r=o(this.__ids),i=this.__createElement("g");this.__applyCurrentDefaultPath(),t.removeChild(this.__currentElement),e.setAttribute("id",r),e.appendChild(this.__currentElement),this.__defs.appendChild(e),t.setAttribute("clip-path",a("url(#{id})",{id:r})),t.appendChild(i),this.__currentElement=i},r.prototype.drawImage=function(){var t,e,i,n,s,a,o,h,l,c,p,_,u,d,g=Array.prototype.slice.call(arguments),m=g[0],f=0,y=0;if(3===g.length)t=g[1],e=g[2],i=s=m.width,n=a=m.height;else if(5===g.length)t=g[1],e=g[2],i=g[3],n=g[4],s=m.width,a=m.height;else{if(9!==g.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);f=g[1],y=g[2],s=g[3],a=g[4],t=g[5],e=g[6],i=g[7],n=g[8]}o=this.__closestGroupOrSvg(),this.__currentElement;var v="translate("+t+", "+e+")";if(m instanceof r){if((h=m.getSvg().cloneNode(!0)).childNodes&&h.childNodes.length>1){for(l=h.childNodes[0];l.childNodes.length;)d=l.childNodes[0].getAttribute("id"),this.__ids[d]=d,this.__defs.appendChild(l.childNodes[0]);if(c=h.childNodes[1]){var b,w=c.getAttribute("transform");b=w?w+" "+v:v,c.setAttribute("transform",b),o.appendChild(c)}}}else"IMG"===m.nodeName?((p=this.__createElement("image")).setAttribute("width",i),p.setAttribute("height",n),p.setAttribute("preserveAspectRatio","none"),(f||y||s!==m.width||a!==m.height)&&((_=this.__document.createElement("canvas")).width=i,_.height=n,(u=_.getContext("2d")).drawImage(m,f,y,s,a,0,0,i,n),m=_),p.setAttribute("transform",v),p.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===m.nodeName?m.toDataURL():m.getAttribute("src")),o.appendChild(p)):"CANVAS"===m.nodeName&&((p=this.__createElement("image")).setAttribute("width",i),p.setAttribute("height",n),p.setAttribute("preserveAspectRatio","none"),(_=this.__document.createElement("canvas")).width=i,_.height=n,(u=_.getContext("2d")).imageSmoothingEnabled=!1,u.mozImageSmoothingEnabled=!1,u.oImageSmoothingEnabled=!1,u.webkitImageSmoothingEnabled=!1,u.drawImage(m,f,y,s,a,0,0,i,n),m=_,p.setAttribute("transform",v),p.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.toDataURL()),o.appendChild(p))},r.prototype.createPattern=function(t,e){var i,s=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),a=o(this.__ids);return s.setAttribute("id",a),s.setAttribute("width",t.width),s.setAttribute("height",t.height),"CANVAS"===t.nodeName||"IMG"===t.nodeName?((i=this.__document.createElementNS("http://www.w3.org/2000/svg","image")).setAttribute("width",t.width),i.setAttribute("height",t.height),i.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===t.nodeName?t.toDataURL():t.getAttribute("src")),s.appendChild(i),this.__defs.appendChild(s)):t instanceof r&&(s.appendChild(t.__root.childNodes[1]),this.__defs.appendChild(s)),new n(s,this)},r.prototype.setLineDash=function(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null},r.prototype.drawFocusRing=function(){},r.prototype.createImageData=function(){},r.prototype.getImageData=function(){},r.prototype.putImageData=function(){},r.prototype.globalCompositeOperation=function(){},r.prototype.setTransform=function(){},"object"==typeof window&&(window.C2S=r),"object"==typeof e&&"object"==typeof e.exports&&(e.exports=r)}()},
function _(e,t,s){const a=e(177),_=e(113),n=e(122),r=e(123),i=e(178),c=e(82),g=e(180);class o extends g.LayoutItem{constructor(e,t,s,a,_={},n={}){super(),this.x_scale=e,this.y_scale=t,this.x_range=s,this.y_range=a,this.extra_x_ranges=_,this.extra_y_ranges=n,this._configure_scales()}map_to_screen(e,t,s="default",a="default"){return[this.xscales[s].v_compute(e),this.yscales[a].v_compute(t)]}_get_ranges(e,t){const s={};if(s.default=e,null!=t)for(const e in t)s[e]=t[e];return s}_get_scales(e,t,s){const g={};for(const o in t){const h=t[o];if(h instanceof i.DataRange1d||h instanceof r.Range1d){if(!(e instanceof n.LogScale||e instanceof _.LinearScale))throw new Error(`Range ${h.type} is incompatible is Scale ${e.type}`);if(e instanceof a.CategoricalScale)throw new Error(`Range ${h.type} is incompatible is Scale ${e.type}`)}if(h instanceof c.FactorRange&&!(e instanceof a.CategoricalScale))throw new Error(`Range ${h.type} is incompatible is Scale ${e.type}`);e instanceof n.LogScale&&h instanceof i.DataRange1d&&(h.scale_hint="log");const l=e.clone();l.setv({source_range:h,target_range:s}),g[o]=l}return g}_configure_frame_ranges(){this._h_target=new r.Range1d({start:this._left.value,end:this._right.value}),this._v_target=new r.Range1d({start:this._bottom.value,end:this._top.value})}_configure_scales(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._xscales=this._get_scales(this.x_scale,this._x_ranges,this._h_target),this._yscales=this._get_scales(this.y_scale,this._y_ranges,this._v_target)}_update_scales(){this._configure_frame_ranges();for(const e in this._xscales){this._xscales[e].target_range=this._h_target}for(const e in this._yscales){this._yscales[e].target_range=this._v_target}}_set_geometry(e,t){super._set_geometry(e,t),this._update_scales()}get x_ranges(){return this._x_ranges}get y_ranges(){return this._y_ranges}get xscales(){return this._xscales}get yscales(){return this._yscales}}s.CartesianFrame=o,o.__name__="CartesianFrame"},
function _(e,t,c){const r=e(113);class s extends r.LinearScale{constructor(e){super(e)}compute(e){return super.compute(this.source_range.synthetic(e))}v_compute(e){return super.v_compute(this.source_range.v_synthetic(e))}}c.CategoricalScale=s,s.__name__="CategoricalScale"},
function _(t,i,n){const e=t(179),a=t(73),s=t(65),l=t(18),_=t(79),o=t(8);class r extends e.DataRange{constructor(t){super(t),this._plot_bounds={},this.have_updated_interactively=!1}static init_DataRange1d(){this.define({start:[l.Number],end:[l.Number],range_padding:[l.Number,.1],range_padding_units:[l.PaddingUnits,"percent"],flipped:[l.Boolean,!1],follow:[l.StartEnd],follow_interval:[l.Number],default_span:[l.Number,2],only_visible:[l.Boolean,!1]}),this.internal({scale_hint:[l.String,"auto"]})}initialize(){super.initialize(),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}computed_renderers(){const t=this.names;let i=this.renderers;if(0==i.length)for(const t of this.plots){const n=t.renderers.filter(t=>t instanceof a.GlyphRenderer);i=i.concat(n)}t.length>0&&(i=i.filter(i=>o.includes(t,i.name))),s.logger.debug(`computed ${i.length} renderers for DataRange1d ${this.id}`);for(const t of i)s.logger.trace(` - ${t.type} ${t.id}`);return i}_compute_plot_bounds(t,i){let n=_.empty();for(const e of t)null==i[e.id]||!e.visible&&this.only_visible||(n=_.union(n,i[e.id]));return n}adjust_bounds_for_aspect(t,i){const n=_.empty();let e=t.x1-t.x0;e<=0&&(e=1);let a=t.y1-t.y0;a<=0&&(a=1);const s=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return e<i*a?e=i*a:a=e/i,n.x1=s+.5*e,n.x0=s-.5*e,n.y1=l+.5*a,n.y0=l-.5*a,n}_compute_min_max(t,i){let n,e,a=_.empty();for(const i in t){const n=t[i];a=_.union(a,n)}return[n,e]=0==i?[a.x0,a.x1]:[a.y0,a.y1],[n,e]}_compute_range(t,i){const n=this.range_padding;let e,a;if("log"==this.scale_hint){let l,_;if((isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,s.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${t}`)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,s.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${i}`)),i==t)_=this.default_span+.001,l=Math.log(t)/Math.log(10);else{let e,a;"percent"==this.range_padding_units?(e=Math.log(t)/Math.log(10),_=((a=Math.log(i)/Math.log(10))-e)*(1+n)):(e=Math.log(t-n)/Math.log(10),_=(a=Math.log(i+n)/Math.log(10))-e),l=(e+a)/2}e=Math.pow(10,l-_/2),a=Math.pow(10,l+_/2)}else{let s;const l=(i+t)/2;e=l-(s=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+n):i-t+2*n)/2,a=l+s/2}let l=1;this.flipped&&([e,a]=[a,e],l=-1);const _=this.follow_interval;return null!=_&&Math.abs(e-a)>_&&("start"==this.follow?a=e+l*_:"end"==this.follow&&(e=a-l*_)),[e,a]}update(t,i,n,e){if(this.have_updated_interactively)return;const a=this.computed_renderers();let s=this._compute_plot_bounds(a,t);null!=e&&(s=this.adjust_bounds_for_aspect(s,e)),this._plot_bounds[n]=s;const[l,_]=this._compute_min_max(this._plot_bounds,i);let[o,r]=this._compute_range(l,_);null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(o=this._initial_start):o=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(r=this._initial_end):r=this._initial_end);const[d,h]=[this.start,this.end];if(o!=d||r!=h){const t={};o!=d&&(t.start=o),r!=h&&(t.end=r),this.setv(t)}"auto"==this.bounds&&this.setv({bounds:[o,r]},{silent:!0}),this.change.emit()}reset(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()}}n.DataRange1d=r,r.__name__="DataRange1d",r.init_DataRange1d()},
function _(a,n,e){const t=a(83),r=a(18);class s extends t.Range{constructor(a){super(a)}static init_DataRange(){this.define({names:[r.Array,[]],renderers:[r.Array,[]]})}}e.DataRange=s,s.__name__="DataRange",s.init_DataRange()},
function _(a,o,t){var r=a(181);t.Sizeable=r.Sizeable;var e=a(182);t.Layoutable=e.Layoutable,t.LayoutItem=e.LayoutItem;var n=a(183);t.HStack=n.HStack,t.VStack=n.VStack,t.AnchorLayout=n.AnchorLayout;var c=a(184);t.Grid=c.Grid,t.Row=c.Row,t.Column=c.Column;var i=a(185);t.ContentBox=i.ContentBox,t.VariadicBox=i.VariadicBox},
function _(h,t,i){const{min:e,max:w}=Math;class s{constructor(h={}){this.width=null!=h.width?h.width:0,this.height=null!=h.height?h.height:0}bounded_to({width:h,height:t}){return new s({width:this.width==1/0&&null!=h?h:this.width,height:this.height==1/0&&null!=t?t:this.height})}expanded_to({width:h,height:t}){return new s({width:h!=1/0?w(this.width,h):this.width,height:t!=1/0?w(this.height,t):this.height})}expand_to({width:h,height:t}){this.width=w(this.width,h),this.height=w(this.height,t)}narrowed_to({width:h,height:t}){return new s({width:e(this.width,h),height:e(this.height,t)})}narrow_to({width:h,height:t}){this.width=e(this.width,h),this.height=e(this.height,t)}grow_by({left:h,right:t,top:i,bottom:e}){const w=this.width+h+t,d=this.height+i+e;return new s({width:w,height:d})}shrink_by({left:h,right:t,top:i,bottom:e}){const d=w(this.width-h-t,0),n=w(this.height-i-e,0);return new s({width:d,height:n})}map(h,t){return new s({width:h(this.width),height:(null!=t?t:h)(this.height)})}}i.Sizeable=s,s.__name__="Sizeable"},
function _(i,t,h){const e=i(181),s=i(79),{min:n,max:g,round:r}=Math;class l{constructor(){this._bbox=new s.BBox,this._inner_bbox=new s.BBox;const i=this;this._top={get value(){return i.bbox.top}},this._left={get value(){return i.bbox.left}},this._width={get value(){return i.bbox.width}},this._height={get value(){return i.bbox.height}},this._right={get value(){return i.bbox.right}},this._bottom={get value(){return i.bbox.bottom}},this._hcenter={get value(){return i.bbox.hcenter}},this._vcenter={get value(){return i.bbox.vcenter}}}get bbox(){return this._bbox}get inner_bbox(){return this._inner_bbox}get sizing(){return this._sizing}set_sizing(i){const t=i.width_policy||"fit",h=i.width,e=null!=i.min_width?i.min_width:0,s=null!=i.max_width?i.max_width:1/0,n=i.height_policy||"fit",g=i.height,r=null!=i.min_height?i.min_height:0,l=null!=i.max_height?i.max_height:1/0,_=i.aspect,a=i.margin||{top:0,right:0,bottom:0,left:0},o=!1!==i.visible,d=i.halign||"start",w=i.valign||"start";this._sizing={width_policy:t,min_width:e,width:h,max_width:s,height_policy:n,min_height:r,height:g,max_height:l,aspect:_,margin:a,visible:o,halign:d,valign:w,size:{width:h,height:g},min_size:{width:e,height:r},max_size:{width:s,height:l}},this._init()}_init(){}_set_geometry(i,t){this._bbox=i,this._inner_bbox=t}set_geometry(i,t){this._set_geometry(i,t||i)}is_width_expanding(){return"max"==this.sizing.width_policy}is_height_expanding(){return"max"==this.sizing.height_policy}apply_aspect(i,{width:t,height:h}){const{aspect:e}=this.sizing;if(null!=e){const{width_policy:s,height_policy:n}=this.sizing,g=(i,t)=>{const h={max:4,fit:3,min:2,fixed:1};return h[i]>h[t]};if("fixed"!=s&&"fixed"!=n)if(s==n){const s=t,n=r(t/e),g=r(h*e),l=h;Math.abs(i.width-s)+Math.abs(i.height-n)<=Math.abs(i.width-g)+Math.abs(i.height-l)?(t=s,h=n):(t=g,h=l)}else g(s,n)?h=r(t/e):t=r(h*e);else"fixed"==s?h=r(t/e):"fixed"==n&&(t=r(h*e))}return{width:t,height:h}}measure(i){if(!this.sizing.visible)return{width:0,height:0};const t=i=>"fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:i,h=i=>"fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:i,s=new e.Sizeable(i).shrink_by(this.sizing.margin).map(t,h),n=this._measure(s),g=this.clip_size(n),r=t(g.width),l=h(g.height),_=this.apply_aspect(s,{width:r,height:l});return Object.assign(Object.assign({},n),_)}compute(i={}){const t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),{width:h,height:e}=t,n=new s.BBox({left:0,top:0,width:h,height:e});let g=void 0;if(null!=t.inner){const{left:i,top:n,right:r,bottom:l}=t.inner;g=new s.BBox({left:i,top:n,right:h-r,bottom:e-l})}this.set_geometry(n,g)}get xview(){return this.bbox.xview}get yview(){return this.bbox.yview}clip_width(i){return g(this.sizing.min_width,n(i,this.sizing.max_width))}clip_height(i){return g(this.sizing.min_height,n(i,this.sizing.max_height))}clip_size({width:i,height:t}){return{width:this.clip_width(i),height:this.clip_height(t)}}}h.Layoutable=l,l.__name__="Layoutable";class _ extends l{_measure(i){const{width_policy:t,height_policy:h}=this.sizing;let e,s;if(i.width==1/0)e=null!=this.sizing.width?this.sizing.width:0;else if("fixed"==t)e=null!=this.sizing.width?this.sizing.width:0;else if("min"==t)e=null!=this.sizing.width?n(i.width,this.sizing.width):0;else if("fit"==t)e=null!=this.sizing.width?n(i.width,this.sizing.width):i.width;else{if("max"!=t)throw new Error("unrechable");e=null!=this.sizing.width?g(i.width,this.sizing.width):i.width}if(i.height==1/0)s=null!=this.sizing.height?this.sizing.height:0;else if("fixed"==h)s=null!=this.sizing.height?this.sizing.height:0;else if("min"==h)s=null!=this.sizing.height?n(i.height,this.sizing.height):0;else if("fit"==h)s=null!=this.sizing.height?n(i.height,this.sizing.height):i.height;else{if("max"!=h)throw new Error("unrechable");s=null!=this.sizing.height?g(i.height,this.sizing.height):i.height}return{width:e,height:s}}}h.LayoutItem=_,_.__name__="LayoutItem";class a extends l{_measure(i){const t=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(t);return{width:(()=>{switch(this.sizing.width_policy){case"fixed":return null!=this.sizing.width?this.sizing.width:t.width;case"min":return t.width;case"fit":return h.width;case"max":return Math.max(t.width,h.width);default:throw new Error("unexpected")}})(),height:(()=>{switch(this.sizing.height_policy){case"fixed":return null!=this.sizing.height?this.sizing.height:t.height;case"min":return t.height;case"fit":return h.height;case"max":return Math.max(t.height,h.height);default:throw new Error("unexpected")}})()}}}h.ContentLayoutable=a,a.__name__="ContentLayoutable"},
function _(t,e,h){const o=t(182),r=t(79);class i extends o.Layoutable{constructor(){super(...arguments),this.children=[]}}h.Stack=i,i.__name__="Stack";class s extends i{_measure(t){let e=0,h=0;for(const t of this.children){const o=t.measure({width:0,height:0});e+=o.width,h=Math.max(h,o.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const{top:h,bottom:o}=t;let{left:i}=t;for(const t of this.children){const{width:e}=t.measure({width:0,height:0});t.set_geometry(new r.BBox({left:i,width:e,top:h,bottom:o})),i+=e}}}h.HStack=s,s.__name__="HStack";class n extends i{_measure(t){let e=0,h=0;for(const t of this.children){const o=t.measure({width:0,height:0});e=Math.max(e,o.width),h+=o.height}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const{left:h,right:o}=t;let{top:i}=t;for(const t of this.children){const{height:e}=t.measure({width:0,height:0});t.set_geometry(new r.BBox({top:i,height:e,left:h,right:o})),i+=e}}}h.VStack=n,n.__name__="VStack";class c extends o.Layoutable{constructor(){super(...arguments),this.children=[]}_measure(t){let e=0,h=0;for(const{layout:o}of this.children){const r=o.measure(t);e=Math.max(e,r.width),h=Math.max(h,r.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);for(const{layout:e,anchor:h,margin:o}of this.children){const{left:i,right:s,top:n,bottom:c,hcenter:a,vcenter:_}=t,{width:g,height:m}=e.measure(t);let w;switch(h){case"top_left":w=new r.BBox({left:i+o,top:n+o,width:g,height:m});break;case"top_center":w=new r.BBox({hcenter:a,top:n+o,width:g,height:m});break;case"top_right":w=new r.BBox({right:s-o,top:n+o,width:g,height:m});break;case"bottom_right":w=new r.BBox({right:s-o,bottom:c-o,width:g,height:m});break;case"bottom_center":w=new r.BBox({hcenter:a,bottom:c-o,width:g,height:m});break;case"bottom_left":w=new r.BBox({left:i+o,bottom:c-o,width:g,height:m});break;case"center_left":w=new r.BBox({left:i+o,vcenter:_,width:g,height:m});break;case"center":w=new r.BBox({hcenter:a,vcenter:_,width:g,height:m});break;case"center_right":w=new r.BBox({right:s-o,vcenter:_,width:g,height:m});break;default:throw new Error("unreachable")}e.set_geometry(w)}}}h.AnchorLayout=c,c.__name__="AnchorLayout"},
function _(t,i,s){const e=t(181),o=t(182),n=t(7),r=t(79),h=t(8),{max:l,round:c}=Math;class a{constructor(t){this.def=t,this._map=new Map}get(t){let i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i}apply(t,i){const s=this.get(t);this._map.set(t,i(s))}}a.__name__="DefaultMap";class g{constructor(){this._items=[],this._nrows=0,this._ncols=0}get nrows(){return this._nrows}get ncols(){return this._ncols}add(t,i){const{r1:s,c1:e}=t;this._nrows=l(this._nrows,s+1),this._ncols=l(this._ncols,e+1),this._items.push({span:t,data:i})}at(t,i){return this._items.filter(({span:s})=>s.r0<=t&&t<=s.r1&&s.c0<=i&&i<=s.c1).map(({data:t})=>t)}row(t){return this._items.filter(({span:i})=>i.r0<=t&&t<=i.r1).map(({data:t})=>t)}col(t){return this._items.filter(({span:i})=>i.c0<=t&&t<=i.c1).map(({data:t})=>t)}foreach(t){for(const{span:i,data:s}of this._items)t(i,s)}map(t){const i=new g;for(const{span:s,data:e}of this._items)i.add(s,t(s,e));return i}}g.__name__="Container";class p extends o.Layoutable{constructor(t=[]){super(),this.items=t,this.rows="auto",this.cols="auto",this.spacing=0,this.absolute=!1}is_width_expanding(){if(super.is_width_expanding())return!0;if("fixed"==this.sizing.width_policy)return!1;const{cols:t}=this._state;return h.some(t,t=>"max"==t.policy)}is_height_expanding(){if(super.is_height_expanding())return!0;if("fixed"==this.sizing.height_policy)return!1;const{rows:t}=this._state;return h.some(t,t=>"max"==t.policy)}_init(){super._init();const t=new g;for(const{layout:i,row:s,col:e,row_span:o,col_span:n}of this.items)if(i.sizing.visible){const r=s,h=e,l=s+(null!=o?o:1)-1,c=e+(null!=n?n:1)-1;t.add({r0:r,c0:h,r1:l,c1:c},i)}const{nrows:i,ncols:s}=t,e=new Array(i);for(let s=0;s<i;s++){const i=(()=>{const t=n.isPlainObject(this.rows)?this.rows[s]||this.rows["*"]:this.rows;return null==t?{policy:"auto"}:n.isNumber(t)?{policy:"fixed",height:t}:n.isString(t)?{policy:t}:t})(),o=i.align||"auto";if("fixed"==i.policy)e[s]={policy:"fixed",height:i.height,align:o};else if("min"==i.policy)e[s]={policy:"min",align:o};else if("fit"==i.policy||"max"==i.policy)e[s]={policy:i.policy,flex:i.flex||1,align:o};else{if("auto"!=i.policy)throw new Error("unrechable");h.some(t.row(s),t=>t.is_height_expanding())?e[s]={policy:"max",flex:1,align:o}:e[s]={policy:"min",align:o}}}const o=new Array(s);for(let i=0;i<s;i++){const s=(()=>{const t=n.isPlainObject(this.cols)?this.cols[i]||this.cols["*"]:this.cols;return null==t?{policy:"auto"}:n.isNumber(t)?{policy:"fixed",width:t}:n.isString(t)?{policy:t}:t})(),e=s.align||"auto";if("fixed"==s.policy)o[i]={policy:"fixed",width:s.width,align:e};else if("min"==s.policy)o[i]={policy:"min",align:e};else if("fit"==s.policy||"max"==s.policy)o[i]={policy:s.policy,flex:s.flex||1,align:e};else{if("auto"!=s.policy)throw new Error("unrechable");h.some(t.col(i),t=>t.is_width_expanding())?o[i]={policy:"max",flex:1,align:e}:o[i]={policy:"min",align:e}}}const[r,l]=n.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing;this._state={items:t,nrows:i,ncols:s,rows:e,cols:o,rspacing:r,cspacing:l}}_measure_totals(t,i){const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state;return{height:h.sum(t)+(s-1)*o,width:h.sum(i)+(e-1)*n}}_measure_cells(t){const{items:i,nrows:s,ncols:o,rows:n,cols:r,rspacing:h,cspacing:a}=this._state,p=new Array(s);for(let t=0;t<s;t++){const i=n[t];p[t]="fixed"==i.policy?i.height:0}const f=new Array(o);for(let t=0;t<o;t++){const i=r[t];f[t]="fixed"==i.policy?i.width:0}const _=new g;return i.foreach((i,s)=>{const{r0:o,c0:g,r1:d,c1:w}=i,u=(d-o)*h,m=(w-g)*a;let y=0;for(let i=o;i<=d;i++)y+=t(i,g).height;y+=u;let x=0;for(let i=g;i<=w;i++)x+=t(o,i).width;x+=m;const b=s.measure({width:x,height:y});_.add(i,{layout:s,size_hint:b});const z=new e.Sizeable(b).grow_by(s.sizing.margin);z.height-=u,z.width-=m;const j=[];for(let t=o;t<=d;t++){const i=n[t];"fixed"==i.policy?z.height-=i.height:j.push(t)}if(z.height>0){const t=c(z.height/j.length);for(const i of j)p[i]=l(p[i],t)}const B=[];for(let t=g;t<=w;t++){const i=r[t];"fixed"==i.policy?z.width-=i.width:B.push(t)}if(z.width>0){const t=c(z.width/B.length);for(const i of B)f[i]=l(f[i],t)}}),{size:this._measure_totals(p,f),row_heights:p,col_widths:f,size_hints:_}}_measure_grid(t){const{nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:r}=this._state,h=this._measure_cells((t,i)=>{const s=e[t],n=o[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==s.policy?s.height:1/0}});let a;a="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:h.size.height;let g,p=0;for(let t=0;t<i;t++){const i=e[t];"fit"==i.policy||"max"==i.policy?p+=i.flex:a-=h.row_heights[t]}if(a-=(i-1)*n,0!=p&&a>0)for(let t=0;t<i;t++){const i=e[t];if("fit"==i.policy||"max"==i.policy){const s=c(a*(i.flex/p));a-=s,h.row_heights[t]=s,p-=i.flex}}else if(a<0){let t=0;for(let s=0;s<i;s++){"fixed"!=e[s].policy&&t++}let s=-a;for(let o=0;o<i;o++){if("fixed"!=e[o].policy){const i=h.row_heights[o],e=c(s/t);h.row_heights[o]=l(i-e,0),s-=e>i?i:e,t--}}}g="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:h.size.width;let f=0;for(let t=0;t<s;t++){const i=o[t];"fit"==i.policy||"max"==i.policy?f+=i.flex:g-=h.col_widths[t]}if(g-=(s-1)*r,0!=f&&g>0)for(let t=0;t<s;t++){const i=o[t];if("fit"==i.policy||"max"==i.policy){const s=c(g*(i.flex/f));g-=s,h.col_widths[t]=s,f-=i.flex}}else if(g<0){let t=0;for(let i=0;i<s;i++){"fixed"!=o[i].policy&&t++}let i=-g;for(let e=0;e<s;e++){if("fixed"!=o[e].policy){const s=h.col_widths[e],o=c(i/t);h.col_widths[e]=l(s-o,0),i-=o>s?s:o,t--}}}const{row_heights:_,col_widths:d,size_hints:w}=this._measure_cells((t,i)=>({width:h.col_widths[i],height:h.row_heights[t]}));return{size:this._measure_totals(_,d),row_heights:_,col_widths:d,size_hints:w}}_measure(t){const{size:i}=this._measure_grid(t);return i}_set_geometry(t,i){super._set_geometry(t,i);const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state,{row_heights:h,col_widths:g,size_hints:p}=this._measure_grid(t),f=this._state.rows.map((t,i)=>Object.assign(Object.assign({},t),{top:0,height:h[i],get bottom(){return this.top+this.height}})),_=this._state.cols.map((t,i)=>Object.assign(Object.assign({},t),{left:0,width:g[i],get right(){return this.left+this.width}})),d=p.map((t,i)=>Object.assign(Object.assign({},i),{outer:new r.BBox,inner:new r.BBox}));for(let i=0,e=this.absolute?t.top:0;i<s;i++){const t=f[i];t.top=e,e+=t.height+o}for(let i=0,s=this.absolute?t.left:0;i<e;i++){const t=_[i];t.left=s,s+=t.width+n}d.foreach(({r0:t,c0:i,r1:s,c1:e},h)=>{const{layout:l,size_hint:a}=h,{sizing:g}=l,{width:p,height:d}=a,w=function(t,i){let s=(i-t)*n;for(let e=t;e<=i;e++)s+=_[e].width;return s}(i,e),u=function(t,i){let s=(i-t)*o;for(let e=t;e<=i;e++)s+=f[e].height;return s}(t,s),m=i==e&&"auto"!=_[i].align?_[i].align:g.halign,y=t==s&&"auto"!=f[t].align?f[t].align:g.valign;let x=_[i].left;"start"==m?x+=g.margin.left:"center"==m?x+=c((w-p)/2):"end"==m&&(x+=w-g.margin.right-p);let b=f[t].top;"start"==y?b+=g.margin.top:"center"==y?b+=c((u-d)/2):"end"==y&&(b+=u-g.margin.bottom-d),h.outer=new r.BBox({left:x,top:b,width:p,height:d})});const w=f.map(()=>({start:new a(()=>0),end:new a(()=>0)})),u=_.map(()=>({start:new a(()=>0),end:new a(()=>0)}));d.foreach(({r0:t,c0:i,r1:s,c1:e},{size_hint:o,outer:n})=>{const{inner:r}=o;null!=r&&(w[t].start.apply(n.top,t=>l(t,r.top)),w[s].end.apply(f[s].bottom-n.bottom,t=>l(t,r.bottom)),u[i].start.apply(n.left,t=>l(t,r.left)),u[e].end.apply(_[e].right-n.right,t=>l(t,r.right)))}),d.foreach(({r0:t,c0:i,r1:s,c1:e},o)=>{const{size_hint:n,outer:h}=o;function l({left:t,right:i,top:s,bottom:e}){const o=h.width-t-i,n=h.height-s-e;return new r.BBox({left:t,top:s,width:o,height:n})}if(null!=n.inner){let r=l(n.inner);if(!1!==n.align){const o=w[t].start.get(h.top),n=w[s].end.get(f[s].bottom-h.bottom),c=u[i].start.get(h.left),a=u[e].end.get(_[e].right-h.right);try{r=l({top:o,bottom:n,left:c,right:a})}catch(t){}}o.inner=r}else o.inner=h}),d.foreach((t,{layout:i,outer:s,inner:e})=>{i.set_geometry(s,e)})}}s.Grid=p,p.__name__="Grid";class f extends p{constructor(t){super(),this.items=t.map((t,i)=>({layout:t,row:0,col:i})),this.rows="fit"}}s.Row=f,f.__name__="Row";class _ extends p{constructor(t){super(),this.items=t.map((t,i)=>({layout:t,row:i,col:0})),this.cols="fit"}}s.Column=_,_.__name__="Column"},
function _(e,t,n){const s=e(182),i=e(181),o=e(61);class a extends s.ContentLayoutable{constructor(e){super(),this.content_size=o.unsized(e,()=>new i.Sizeable(o.size(e)))}_content_size(){return this.content_size}}n.ContentBox=a,a.__name__="ContentBox";class r extends s.Layoutable{constructor(e){super(),this.el=e}_measure(e){const t=new i.Sizeable(e).bounded_to(this.sizing.size);return o.sized(this.el,t,()=>{const e=new i.Sizeable(o.content_size(this.el)),{border:t,padding:n}=o.extents(this.el);return e.grow_by(t).grow_by(n).map(Math.ceil)})}}n.VariadicBox=r,r.__name__="VariadicBox"},
function _(a,r,u){var m=a(187);u.Expression=m.Expression;var n=a(188);u.Stack=n.Stack;var s=a(189);u.CumSum=s.CumSum},
function _(t,e,i){const s=t(64);class n extends s.Model{constructor(t){super(t),this._connected={},this._result={}}initialize(){super.initialize(),this._connected={},this._result={}}v_compute(t){null==this._connected[t.id]&&(this.connect(t.change,()=>delete this._result[t.id]),this.connect(t.patching,()=>delete this._result[t.id]),this.connect(t.streaming,()=>delete this._result[t.id]),this._connected[t.id]=!0);let e=this._result[t.id];return null==e&&(this._result[t.id]=e=this._v_compute(t)),e}}i.Expression=n,n.__name__="Expression"},
function _(t,n,e){const s=t(187),c=t(18);class i extends s.Expression{constructor(t){super(t)}static init_Stack(){this.define({fields:[c.Array,[]]})}_v_compute(t){const n=t.get_length()||0,e=new Float64Array(n);for(const s of this.fields){const c=t.data[s];if(null!=c)for(let t=0,s=Math.min(n,c.length);t<s;t++)e[t]+=c[t]}return e}}e.Stack=i,i.__name__="Stack",i.init_Stack()},
function _(e,t,n){const i=e(187),u=e(18);class o extends i.Expression{constructor(e){super(e)}static init_CumSum(){this.define({field:[u.String],include_zero:[u.Boolean,!1]})}_v_compute(e){const t=new Float64Array(e.get_length()||0),n=e.data[this.field],i=this.include_zero?1:0;t[0]=this.include_zero?0:n[0];for(let e=1;e<t.length;e++)t[e]=t[e-1]+n[e-i];return t}}n.CumSum=o,o.__name__="CumSum",o.init_CumSum()},
function _(r,e,t){var l=r(191);t.BooleanFilter=l.BooleanFilter;var i=r(193);t.CustomJSFilter=i.CustomJSFilter;var F=r(192);t.Filter=F.Filter;var o=r(194);t.GroupFilter=o.GroupFilter;var a=r(195);t.IndexFilter=a.IndexFilter},
function _(e,n,l){const o=e(192),t=e(18),i=e(65),a=e(8),r=e(7);class s extends o.Filter{constructor(e){super(e)}static init_BooleanFilter(){this.define({booleans:[t.Array,null]})}compute_indices(e){const n=this.booleans;return null!=n&&n.length>0?a.every(n,r.isBoolean)?(n.length!==e.get_length()&&i.logger.warn(`BooleanFilter ${this.id}: length of booleans doesn't match data source`),a.range(0,n.length).filter(e=>!0===n[e])):(i.logger.warn(`BooleanFilter ${this.id}: booleans should be array of booleans, defaulting to no filtering`),null):(null!=n&&0==n.length?i.logger.warn(`BooleanFilter ${this.id}: booleans is empty, defaulting to no filtering`):i.logger.warn(`BooleanFilter ${this.id}: booleans was not set, defaulting to no filtering`),null)}}l.BooleanFilter=s,s.__name__="BooleanFilter",s.init_BooleanFilter()},
function _(e,t,i){const r=e(64),n=e(18),l=e(7),o=e(8),s=e(65);class a extends r.Model{constructor(e){super(e)}static init_Filter(){this.define({filter:[n.Array,null]})}compute_indices(e){const t=this.filter;return null!=t&&t.length>=0?l.isArrayOf(t,l.isBoolean)?o.range(0,t.length).filter(e=>!0===t[e]):l.isArrayOf(t,l.isInteger)?t:(s.logger.warn(`Filter ${this.id}: filter should either be array of only booleans or only integers, defaulting to no filtering`),null):(s.logger.warn(`Filter ${this.id}: filter was not set to be an array, defaulting to no filtering`),null)}}i.Filter=a,a.__name__="Filter",a.init_Filter()},
function _(t,e,s){const i=t(192),r=t(18),n=t(22),u=t(25);class c extends i.Filter{constructor(t){super(t)}static init_CustomJSFilter(){this.define({args:[r.Any,{}],code:[r.String,""],use_strict:[r.Boolean,!1]})}get names(){return n.keys(this.args)}get values(){return n.values(this.args)}get func(){const t=this.use_strict?u.use_strict(this.code):this.code;return new Function(...this.names,"source","require","exports",t)}compute_indices(e){return this.filter=this.func(...this.values,e,t,{}),super.compute_indices(e)}}s.CustomJSFilter=c,c.__name__="CustomJSFilter",c.init_CustomJSFilter()},
function _(n,i,t){const e=n(192),r=n(18),o=n(65),u=n(8);class l extends e.Filter{constructor(n){super(n),this.indices=null}static init_GroupFilter(){this.define({column_name:[r.String],group:[r.String]})}compute_indices(n){const i=n.get_column(this.column_name);return null==i?(o.logger.warn("group filter: groupby column not found in data source"),null):(this.indices=u.range(0,n.get_length()||0).filter(n=>i[n]===this.group),0===this.indices.length&&o.logger.warn(`group filter: group '${this.group}' did not match any values in column '${this.column_name}'`),this.indices)}}t.GroupFilter=l,l.__name__="GroupFilter",l.init_GroupFilter()},
function _(i,e,n){const t=i(192),s=i(18),r=i(65),l=i(7),d=i(8);class c extends t.Filter{constructor(i){super(i)}static init_IndexFilter(){this.define({indices:[s.Array,null]})}compute_indices(i){return null!=this.indices&&this.indices.length>=0?d.every(this.indices,l.isInteger)?this.indices:(r.logger.warn(`IndexFilter ${this.id}: indices should be array of integers, defaulting to no filtering`),null):(r.logger.warn(`IndexFilter ${this.id}: indices was not set, defaulting to no filtering`),null)}}n.IndexFilter=c,c.__name__="IndexFilter",c.init_IndexFilter()},
function _(r,t,a){var e=r(106);a.BasicTickFormatter=e.BasicTickFormatter;var c=r(145);a.CategoricalTickFormatter=c.CategoricalTickFormatter;var i=r(149);a.DatetimeTickFormatter=i.DatetimeTickFormatter;var o=r(197);a.FuncTickFormatter=o.FuncTickFormatter;var m=r(162);a.LogTickFormatter=m.LogTickFormatter;var F=r(165);a.MercatorTickFormatter=F.MercatorTickFormatter;var k=r(198);a.NumeralTickFormatter=k.NumeralTickFormatter;var T=r(199);a.PrintfTickFormatter=T.PrintfTickFormatter;var v=r(107);a.TickFormatter=v.TickFormatter},
function _(t,e,s){const r=t(107),i=t(18),n=t(22),c=t(25);class a extends r.TickFormatter{constructor(t){super(t)}static init_FuncTickFormatter(){this.define({args:[i.Any,{}],code:[i.String,""],use_strict:[i.Boolean,!1]})}get names(){return n.keys(this.args)}get values(){return n.values(this.args)}_make_func(){const t=this.use_strict?c.use_strict(this.code):this.code;return new Function("tick","index","ticks",...this.names,"require","exports",t)}doFormat(e,s){const r=this._make_func().bind({});return e.map((e,s,i)=>r(e,s,i,...this.values,t,{}))}}s.FuncTickFormatter=a,a.__name__="FuncTickFormatter",a.init_FuncTickFormatter()},
function _(r,n,t){const e=r(153),a=r(107),o=r(18);class i extends a.TickFormatter{constructor(r){super(r)}static init_NumeralTickFormatter(){this.define({format:[o.String,"0,0"],language:[o.String,"en"],rounding:[o.RoundingFunction,"round"]})}get _rounding_fn(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}doFormat(r,n){const{format:t,language:a,_rounding_fn:o}=this;return r.map(r=>e.format(r,t,a,o))}}t.NumeralTickFormatter=i,i.__name__="NumeralTickFormatter",i.init_NumeralTickFormatter()},
function _(t,r,i){const n=t(107),o=t(151),a=t(18);class e extends n.TickFormatter{constructor(t){super(t)}static init_PrintfTickFormatter(){this.define({format:[a.String,"%s"]})}doFormat(t,r){return t.map(t=>o.sprintf(this.format,t))}}i.PrintfTickFormatter=e,e.__name__="PrintfTickFormatter",e.init_PrintfTickFormatter()},
function _(a,e,r){var v=a(201);r.AnnularWedge=v.AnnularWedge;var l=a(202);r.Annulus=l.Annulus;var t=a(203);r.Arc=t.Arc;var i=a(204);r.Bezier=i.Bezier;var n=a(205);r.Circle=n.Circle;var u=a(206);r.CenterRotatable=u.CenterRotatable;var g=a(207);r.Ellipse=g.Ellipse;var c=a(208);r.EllipseOval=c.EllipseOval;var A=a(80);r.Glyph=A.Glyph;var p=a(86);r.HArea=p.HArea;var s=a(209);r.HBar=s.HBar;var R=a(211);r.HexTile=R.HexTile;var d=a(212);r.Image=d.Image;var h=a(214);r.ImageRGBA=h.ImageRGBA;var m=a(215);r.ImageURL=m.ImageURL;var y=a(75);r.Line=y.Line;var B=a(217);r.MultiLine=B.MultiLine;var o=a(218);r.MultiPolygons=o.MultiPolygons;var G=a(219);r.Oval=G.Oval;var H=a(85);r.Patch=H.Patch;var I=a(220);r.Patches=I.Patches;var L=a(221);r.Quad=L.Quad;var P=a(222);r.Quadratic=P.Quadratic;var x=a(223);r.Ray=x.Ray;var C=a(224);r.Rect=C.Rect;var E=a(225);r.Segment=E.Segment;var M=a(226);r.Step=M.Step;var O=a(227);r.Text=O.Text;var Q=a(88);r.VArea=Q.VArea;var S=a(228);r.VBar=S.VBar;var T=a(229);r.Wedge=T.Wedge;var V=a(76);r.XYGlyph=V.XYGlyph},
function _(e,t,s){const i=e(76),r=e(84),n=e(81),a=e(18),_=e(9);class h extends i.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new Float32Array(this._start_angle.length);for(let e=0,t=this._start_angle.length;e<t;e++)this._angle[e]=this._end_angle[e]-this._start_angle[e]}_render(e,t,{sx:s,sy:i,_start_angle:r,_angle:n,sinner_radius:a,souter_radius:_}){const h=this.model.properties.direction.value();for(const o of t)isNaN(s[o]+i[o]+a[o]+_[o]+r[o]+n[o])||(e.translate(s[o],i[o]),e.rotate(r[o]),e.moveTo(_[o],0),e.beginPath(),e.arc(0,0,_[o],0,n[o],h),e.rotate(n[o]),e.lineTo(a[o],0),e.arc(0,0,a[o],0,-n[o],!h),e.closePath(),e.rotate(-n[o]-r[o]),e.translate(-s[o],-i[o]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,o),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,o),e.stroke()))}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s);let a,h,o,u;if("data"==this.model.properties.outer_radius.units)a=i-this.max_outer_radius,o=i+this.max_outer_radius,h=r-this.max_outer_radius,u=r+this.max_outer_radius;else{const e=t-this.max_outer_radius,i=t+this.max_outer_radius;[a,o]=this.renderer.xscale.r_invert(e,i);const r=s-this.max_outer_radius,n=s+this.max_outer_radius;[h,u]=this.renderer.yscale.r_invert(r,n)}const l=[];for(const e of this.index.indices({x0:a,x1:o,y0:h,y1:u})){const t=Math.pow(this.souter_radius[e],2),s=Math.pow(this.sinner_radius[e],2),[n,a]=this.renderer.xscale.r_compute(i,this._x[e]),[_,h]=this.renderer.yscale.r_compute(r,this._y[e]),o=Math.pow(n-a,2)+Math.pow(_-h,2);o<=t&&o>=s&&l.push([e,o])}const d=this.model.properties.direction.value(),c=[];for(const[e,i]of l){const r=Math.atan2(s-this.sy[e],t-this.sx[e]);_.angle_between(-r,-this._start_angle[e],-this._end_angle[e],d)&&c.push([e,i])}return n.create_hit_test_result_from_hits(c)}draw_legend_for_index(e,t,s){r.generic_area_legend(this.visuals,e,t,s)}_scenterxy(e){const t=(this.sinner_radius[e]+this.souter_radius[e])/2,s=(this._start_angle[e]+this._end_angle[e])/2;return{x:this.sx[e]+t*Math.cos(s),y:this.sy[e]+t*Math.sin(s)}}scenterx(e){return this._scenterxy(e).x}scentery(e){return this._scenterxy(e).y}}s.AnnularWedgeView=h,h.__name__="AnnularWedgeView";class o extends i.XYGlyph{constructor(e){super(e)}static init_AnnularWedge(){this.prototype.default_view=h,this.mixins(["line","fill"]),this.define({direction:[a.Direction,"anticlock"],inner_radius:[a.DistanceSpec],outer_radius:[a.DistanceSpec],start_angle:[a.AngleSpec],end_angle:[a.AngleSpec]})}}s.AnnularWedge=o,o.__name__="AnnularWedge",o.init_AnnularWedge()},
function _(s,i,t){const e=s(76),r=s(81),a=s(18),n=s(95);class _ extends e.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius}_render(s,i,{sx:t,sy:e,sinner_radius:r,souter_radius:a}){for(const _ of i)if(!isNaN(t[_]+e[_]+r[_]+a[_])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(s,_),s.beginPath(),n.is_ie)for(const i of[!1,!0])s.arc(t[_],e[_],r[_],0,Math.PI,i),s.arc(t[_],e[_],a[_],Math.PI,0,!i);else s.arc(t[_],e[_],r[_],0,2*Math.PI,!0),s.arc(t[_],e[_],a[_],2*Math.PI,0,!1);s.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,_),s.beginPath(),s.arc(t[_],e[_],r[_],0,2*Math.PI),s.moveTo(t[_]+a[_],e[_]),s.arc(t[_],e[_],a[_],0,2*Math.PI),s.stroke())}}_hit_point(s){const{sx:i,sy:t}=s,e=this.renderer.xscale.invert(i),a=this.renderer.yscale.invert(t);let n,_,u,h;if("data"==this.model.properties.outer_radius.units)n=e-this.max_outer_radius,u=e+this.max_outer_radius,_=a-this.max_outer_radius,h=a+this.max_outer_radius;else{const s=i-this.max_outer_radius,e=i+this.max_outer_radius;[n,u]=this.renderer.xscale.r_invert(s,e);const r=t-this.max_outer_radius,a=t+this.max_outer_radius;[_,h]=this.renderer.yscale.r_invert(r,a)}const o=[];for(const s of this.index.indices({x0:n,x1:u,y0:_,y1:h})){const i=Math.pow(this.souter_radius[s],2),t=Math.pow(this.sinner_radius[s],2),[r,n]=this.renderer.xscale.r_compute(e,this._x[s]),[_,u]=this.renderer.yscale.r_compute(a,this._y[s]),h=Math.pow(r-n,2)+Math.pow(_-u,2);h<=i&&h>=t&&o.push([s,h])}return r.create_hit_test_result_from_hits(o)}draw_legend_for_index(s,{x0:i,y0:t,x1:e,y1:r},a){const n=a+1,_=new Array(n);_[a]=(i+e)/2;const u=new Array(n);u[a]=(t+r)/2;const h=.5*Math.min(Math.abs(e-i),Math.abs(r-t)),o=new Array(n);o[a]=.4*h;const d=new Array(n);d[a]=.8*h,this._render(s,[a],{sx:_,sy:u,sinner_radius:o,souter_radius:d})}}t.AnnulusView=_,_.__name__="AnnulusView";class u extends e.XYGlyph{constructor(s){super(s)}static init_Annulus(){this.prototype.default_view=_,this.mixins(["line","fill"]),this.define({inner_radius:[a.DistanceSpec],outer_radius:[a.DistanceSpec]})}}t.Annulus=u,u.__name__="Annulus",u.init_Annulus()},
function _(i,e,s){const t=i(76),n=i(84),r=i(18);class a extends t.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius}_render(i,e,{sx:s,sy:t,sradius:n,_start_angle:r,_end_angle:a}){if(this.visuals.line.doit){const _=this.model.properties.direction.value();for(const c of e)isNaN(s[c]+t[c]+n[c]+r[c]+a[c])||(i.beginPath(),i.arc(s[c],t[c],n[c],r[c],a[c],_),this.visuals.line.set_vectorize(i,c),i.stroke())}}draw_legend_for_index(i,e,s){n.generic_line_legend(this.visuals,i,e,s)}}s.ArcView=a,a.__name__="ArcView";class _ extends t.XYGlyph{constructor(i){super(i)}static init_Arc(){this.prototype.default_view=a,this.mixins(["line"]),this.define({direction:[r.Direction,"anticlock"],radius:[r.DistanceSpec],start_angle:[r.AngleSpec],end_angle:[r.AngleSpec]})}}s.Arc=_,_.__name__="Arc",_.init_Arc()},
function _(t,e,i){const s=t(77),n=t(80),c=t(84);function o(t,e,i,s,n,c,o,h){const r=[],_=[[],[]];for(let _=0;_<=2;_++){let a,x,l;if(0===_?(x=6*t-12*i+6*n,a=-3*t+9*i-9*n+3*o,l=3*i-3*t):(x=6*e-12*s+6*c,a=-3*e+9*s-9*c+3*h,l=3*s-3*e),Math.abs(a)<1e-12){if(Math.abs(x)<1e-12)continue;const t=-l/x;0<t&&t<1&&r.push(t);continue}const y=x*x-4*l*a,u=Math.sqrt(y);if(y<0)continue;const d=(-x+u)/(2*a);0<d&&d<1&&r.push(d);const f=(-x-u)/(2*a);0<f&&f<1&&r.push(f)}let a=r.length;const x=a;for(;a--;){const x=r[a],l=1-x,y=l*l*l*t+3*l*l*x*i+3*l*x*x*n+x*x*x*o;_[0][a]=y;const u=l*l*l*e+3*l*l*x*s+3*l*x*x*c+x*x*x*h;_[1][a]=u}return _[0][x]=t,_[1][x]=e,_[0][x+1]=o,_[1][x+1]=h,[Math.min(..._[0]),Math.max(..._[1]),Math.max(..._[0]),Math.min(..._[1])]}class h extends n.GlyphView{_index_data(){const t=[];for(let e=0,i=this._x0.length;e<i;e++){if(isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx0[e]+this._cy0[e]+this._cx1[e]+this._cy1[e]))continue;const[i,s,n,c]=o(this._x0[e],this._y0[e],this._x1[e],this._y1[e],this._cx0[e],this._cy0[e],this._cx1[e],this._cy1[e]);t.push({x0:i,y0:s,x1:n,y1:c,i:e})}return new s.SpatialIndex(t)}_render(t,e,{sx0:i,sy0:s,sx1:n,sy1:c,scx0:o,scy0:h,scx1:r,scy1:_}){if(this.visuals.line.doit)for(const a of e)isNaN(i[a]+s[a]+n[a]+c[a]+o[a]+h[a]+r[a]+_[a])||(t.beginPath(),t.moveTo(i[a],s[a]),t.bezierCurveTo(o[a],h[a],r[a],_[a],n[a],c[a]),this.visuals.line.set_vectorize(t,a),t.stroke())}draw_legend_for_index(t,e,i){c.generic_line_legend(this.visuals,t,e,i)}scenterx(){throw new Error("not implemented")}scentery(){throw new Error("not implemented")}}i.BezierView=h,h.__name__="BezierView";class r extends n.Glyph{constructor(t){super(t)}static init_Bezier(){this.prototype.default_view=h,this.coords([["x0","y0"],["x1","y1"],["cx0","cy0"],["cx1","cy1"]]),this.mixins(["line"])}}i.Bezier=r,r.__name__="Bezier",r.init_Bezier()},
function _(s,i,e){const t=s(76),r=s(81),a=s(18),n=s(8),h=s(11);class d extends t.XYGlyphView{_map_data(){if(null!=this._radius)if("data"==this.model.properties.radius.spec.units){switch(this.model.properties.radius_dimension.spec.value){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius);break;case"max":{const s=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=h.map(s,(s,e)=>Math.max(s,i[e]));break}case"min":{const s=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=h.map(s,(s,e)=>Math.min(s,i[e]));break}}}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=h.map(this._size,s=>s/2)}_mask_data(){const[s,i]=this.renderer.plot_view.frame.bbox.ranges;let e,t,r,a;if(null!=this._radius&&"data"==this.model.properties.radius.units){const n=s.start,h=s.end;[e,r]=this.renderer.xscale.r_invert(n,h),e-=this.max_radius,r+=this.max_radius;const d=i.start,_=i.end;[t,a]=this.renderer.yscale.r_invert(d,_),t-=this.max_radius,a+=this.max_radius}else{const n=s.start-this.max_size,h=s.end+this.max_size;[e,r]=this.renderer.xscale.r_invert(n,h);const d=i.start-this.max_size,_=i.end+this.max_size;[t,a]=this.renderer.yscale.r_invert(d,_)}return this.index.indices({x0:e,x1:r,y0:t,y1:a})}_render(s,i,{sx:e,sy:t,sradius:r}){for(const a of i)isNaN(e[a]+t[a]+r[a])||(s.beginPath(),s.arc(e[a],t[a],r[a],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(s,a),s.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,a),s.stroke()))}_hit_point(s){let i,e,t,a,n,h,d,_,l,c;const{sx:u,sy:o}=s,x=this.renderer.xscale.invert(u),m=this.renderer.yscale.invert(o);null!=this._radius&&"data"==this.model.properties.radius.units?(d=x-this.max_radius,_=x+this.max_radius,l=m-this.max_radius,c=m+this.max_radius):(t=u-this.max_size,a=u+this.max_size,[d,_]=this.renderer.xscale.r_invert(t,a),[d,_]=[Math.min(d,_),Math.max(d,_)],n=o-this.max_size,h=o+this.max_size,[l,c]=this.renderer.yscale.r_invert(n,h),[l,c]=[Math.min(l,c),Math.max(l,c)]);const p=this.index.indices({x0:d,x1:_,y0:l,y1:c}),y=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)for(const s of p)e=Math.pow(this.sradius[s],2),[t,a]=this.renderer.xscale.r_compute(x,this._x[s]),[n,h]=this.renderer.yscale.r_compute(m,this._y[s]),(i=Math.pow(t-a,2)+Math.pow(n-h,2))<=e&&y.push([s,i]);else for(const s of p)e=Math.pow(this.sradius[s],2),(i=Math.pow(this.sx[s]-u,2)+Math.pow(this.sy[s]-o,2))<=e&&y.push([s,i]);return r.create_hit_test_result_from_hits(y)}_hit_span(s){const{sx:i,sy:e}=s,t=this.bounds(),a=r.create_empty_hit_test_result();let n,h,d,_;if("h"==s.direction){let s,e;if(d=t.y0,_=t.y1,null!=this._radius&&"data"==this.model.properties.radius.units)s=i-this.max_radius,e=i+this.max_radius,[n,h]=this.renderer.xscale.r_invert(s,e);else{const t=this.max_size/2;s=i-t,e=i+t,[n,h]=this.renderer.xscale.r_invert(s,e)}}else{let s,i;if(n=t.x0,h=t.x1,null!=this._radius&&"data"==this.model.properties.radius.units)s=e-this.max_radius,i=e+this.max_radius,[d,_]=this.renderer.yscale.r_invert(s,i);else{const t=this.max_size/2;s=e-t,i=e+t,[d,_]=this.renderer.yscale.r_invert(s,i)}}const l=this.index.indices({x0:n,x1:h,y0:d,y1:_});return a.indices=l,a}_hit_rect(s){const{sx0:i,sx1:e,sy0:t,sy1:a}=s,[n,h]=this.renderer.xscale.r_invert(i,e),[d,_]=this.renderer.yscale.r_invert(t,a),l=r.create_empty_hit_test_result();return l.indices=this.index.indices({x0:n,x1:h,y0:d,y1:_}),l}_hit_poly(s){const{sx:i,sy:e}=s,t=n.range(0,this.sx.length),a=[];for(let s=0,n=t.length;s<n;s++){const n=t[s];r.point_in_poly(this.sx[s],this.sy[s],i,e)&&a.push(n)}const h=r.create_empty_hit_test_result();return h.indices=a,h}draw_legend_for_index(s,{x0:i,y0:e,x1:t,y1:r},a){const n=a+1,h=new Array(n);h[a]=(i+t)/2;const d=new Array(n);d[a]=(e+r)/2;const _=new Array(n);_[a]=.2*Math.min(Math.abs(t-i),Math.abs(r-e)),this._render(s,[a],{sx:h,sy:d,sradius:_})}}e.CircleView=d,d.__name__="CircleView";class _ extends t.XYGlyph{constructor(s){super(s)}static init_Circle(){this.prototype.default_view=d,this.mixins(["line","fill"]),this.define({angle:[a.AngleSpec,0],size:[a.DistanceSpec,{units:"screen",value:4}],radius:[a.DistanceSpec],radius_dimension:[a.RadiusDimension,"x"]})}initialize(){super.initialize(),this.properties.radius.optional=!0}}e.Circle=_,_.__name__="Circle",_.init_Circle()},
function _(e,t,n){const a=e(76),i=e(18);class l extends a.XYGlyphView{}n.CenterRotatableView=l,l.__name__="CenterRotatableView";class s extends a.XYGlyph{constructor(e){super(e)}static init_CenterRotatable(){this.mixins(["line","fill"]),this.define({angle:[i.AngleSpec,0],width:[i.DistanceSpec],height:[i.DistanceSpec]})}}n.CenterRotatable=s,s.__name__="CenterRotatable",s.init_CenterRotatable()},
function _(e,l,i){const s=e(208);class t extends s.EllipseOvalView{}i.EllipseView=t,t.__name__="EllipseView";class _ extends s.EllipseOval{constructor(e){super(e)}static init_Ellipse(){this.prototype.default_view=t}}i.Ellipse=_,_.__name__="Ellipse",_.init_Ellipse()},
function _(t,s,i){const e=t(206),h=t(81);class a extends e.CenterRotatableView{_set_data(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)}_map_data(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height}_render(t,s,{sx:i,sy:e,sw:h,sh:a,_angle:r}){for(const _ of s)isNaN(i[_]+e[_]+h[_]+a[_]+r[_])||(t.beginPath(),t.ellipse(i[_],e[_],h[_]/2,a[_]/2,r[_],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,_),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,_),t.stroke()))}_hit_point(t){let s,i,e,a,r,_,n,l,d,o;const{sx:x,sy:m}=t,w=this.renderer.xscale.invert(x),c=this.renderer.yscale.invert(m);"data"==this.model.properties.width.units?(s=w-this.max_width,i=w+this.max_width):(n=x-this.max_width,l=x+this.max_width,[s,i]=this.renderer.xscale.r_invert(n,l)),"data"==this.model.properties.height.units?(e=c-this.max_height,a=c+this.max_height):(d=m-this.max_height,o=m+this.max_height,[e,a]=this.renderer.yscale.r_invert(d,o));const p=this.index.indices({x0:s,x1:i,y0:e,y1:a}),y=[];for(const t of p)(r=h.point_in_ellipse(x,m,this._angle[t],this.sh[t]/2,this.sw[t]/2,this.sx[t],this.sy[t]))&&([n,l]=this.renderer.xscale.r_compute(w,this._x[t]),[d,o]=this.renderer.yscale.r_compute(c,this._y[t]),_=Math.pow(n-l,2)+Math.pow(d-o,2),y.push([t,_]));return h.create_hit_test_result_from_hits(y)}draw_legend_for_index(t,{x0:s,y0:i,x1:e,y1:h},a){const r=a+1,_=new Array(r);_[a]=(s+e)/2;const n=new Array(r);n[a]=(i+h)/2;const l=this.sw[a]/this.sh[a],d=.8*Math.min(Math.abs(e-s),Math.abs(h-i)),o=new Array(r),x=new Array(r);l>1?(o[a]=d,x[a]=d/l):(o[a]=d*l,x[a]=d),this._render(t,[a],{sx:_,sy:n,sw:o,sh:x,_angle:[0]})}_bounds({x0:t,x1:s,y0:i,y1:e}){return{x0:t-this.max_w2,x1:s+this.max_w2,y0:i-this.max_h2,y1:e+this.max_h2}}}i.EllipseOvalView=a,a.__name__="EllipseOvalView";class r extends e.CenterRotatable{constructor(t){super(t)}}i.EllipseOval=r,r.__name__="EllipseOval"},
function _(t,s,e){const i=t(210),h=t(18);class r extends i.BoxView{scenterx(t){return(this.sleft[t]+this.sright[t])/2}scentery(t){return this.sy[t]}_index_data(){return this._index_box(this._y.length)}_lrtb(t){return[Math.min(this._left[t],this._right[t]),Math.max(this._left[t],this._right[t]),this._y[t]+.5*this._height[t],this._y[t]-.5*this._height[t]]}_map_data(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);const t=this.sy.length;this.stop=new Float64Array(t),this.sbottom=new Float64Array(t);for(let s=0;s<t;s++)this.stop[s]=this.sy[s]-this.sh[s]/2,this.sbottom[s]=this.sy[s]+this.sh[s]/2;this._clamp_viewport()}}e.HBarView=r,r.__name__="HBarView";class _ extends i.Box{constructor(t){super(t)}static init_HBar(){this.prototype.default_view=r,this.coords([["left","y"]]),this.define({height:[h.NumberSpec],right:[h.CoordinateSpec]}),this.override({left:0})}}e.HBar=_,_.__name__="HBar",_.init_HBar()},
function _(t,e,s){const i=t(77),r=t(80),n=t(84),h=t(81);class a extends r.GlyphView{get_anchor_point(t,e,s){const i=Math.min(this.sleft[e],this.sright[e]),r=Math.max(this.sright[e],this.sleft[e]),n=Math.min(this.stop[e],this.sbottom[e]),h=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:i,y:n};case"top_center":return{x:(i+r)/2,y:n};case"top_right":return{x:r,y:n};case"bottom_left":return{x:i,y:h};case"bottom_center":return{x:(i+r)/2,y:h};case"bottom_right":return{x:r,y:h};case"center_left":return{x:i,y:(n+h)/2};case"center":return{x:(i+r)/2,y:(n+h)/2};case"center_right":return{x:r,y:(n+h)/2};default:return null}}_index_box(t){const e=[];for(let s=0;s<t;s++){const[t,i,r,n]=this._lrtb(s);!isNaN(t+i+r+n)&&isFinite(t+i+r+n)&&e.push({x0:Math.min(t,i),y0:Math.min(r,n),x1:Math.max(i,t),y1:Math.max(r,n),i:s})}return new i.SpatialIndex(e)}_render(t,e,{sleft:s,sright:i,stop:r,sbottom:n}){for(const h of e)isNaN(s[h]+r[h]+i[h]+n[h])||(t.rect(s[h],r[h],i[h]-s[h],n[h]-r[h]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,h),t.beginPath(),t.rect(s[h],r[h],i[h]-s[h],n[h]-r[h]),t.fill()),this.visuals.hatch.doit2(t,h,()=>{t.beginPath(),t.rect(s[h],r[h],i[h]-s[h],n[h]-r[h]),t.fill()},()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,h),t.beginPath(),t.rect(s[h],r[h],i[h]-s[h],n[h]-r[h]),t.stroke()))}_clamp_viewport(){const t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,s=this.stop.length;for(let i=0;i<s;i++)this.stop[i]=Math.max(this.stop[i],e.start),this.sbottom[i]=Math.min(this.sbottom[i],e.end),this.sleft[i]=Math.max(this.sleft[i],t.start),this.sright[i]=Math.min(this.sright[i],t.end)}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const{sx:e,sy:s}=t,i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(s),n=this.index.indices({x0:i,y0:r,x1:i,y1:r}),a=h.create_empty_hit_test_result();return a.indices=n,a}_hit_span(t){const{sx:e,sy:s}=t;let i;if("v"==t.direction){const t=this.renderer.yscale.invert(s),e=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(e.start,e.end);i=this.index.indices({x0:r,y0:t,x1:n,y1:t})}else{const t=this.renderer.xscale.invert(e),s=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(s.start,s.end);i=this.index.indices({x0:t,y0:r,x1:t,y1:n})}const r=h.create_empty_hit_test_result();return r.indices=i,r}draw_legend_for_index(t,e,s){n.generic_area_legend(this.visuals,t,e,s)}}s.BoxView=a,a.__name__="BoxView";class o extends r.Glyph{constructor(t){super(t)}static init_Box(){this.mixins(["line","fill","hatch"])}}s.Box=o,o.__name__="Box",o.init_Box()},
function _(e,t,s){const i=e(80),r=e(81),n=e(18),h=e(77),a=e(84);class l extends i.GlyphView{scenterx(e){return this.sx[e]}scentery(e){return this.sy[e]}_set_data(){const e=this._q.length,t=this.model.size,s=this.model.aspect_scale;if(this._x=new Float64Array(e),this._y=new Float64Array(e),"pointytop"==this.model.orientation)for(let i=0;i<e;i++)this._x[i]=t*Math.sqrt(3)*(this._q[i]+this._r[i]/2)/s,this._y[i]=3*-t/2*this._r[i];else for(let i=0;i<e;i++)this._x[i]=3*t/2*this._q[i],this._y[i]=-t*Math.sqrt(3)*(this._r[i]+this._q[i]/2)*s}_index_data(){let e=this.model.size,t=Math.sqrt(3)*e/2;"flattop"==this.model.orientation?([t,e]=[e,t],e*=this.model.aspect_scale):t/=this.model.aspect_scale;const s=[];for(let i=0;i<this._x.length;i++){const r=this._x[i],n=this._y[i];!isNaN(r+n)&&isFinite(r+n)&&s.push({x0:r-t,y0:n-e,x1:r+t,y1:n+e,i:i})}return new h.SpatialIndex(s)}map_data(){[this.sx,this.sy]=this.map_to_screen(this._x,this._y),[this.svx,this.svy]=this._get_unscaled_vertices()}_get_unscaled_vertices(){const e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){const s=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t,h=r/2;return[[0,-n,-n,0,n,n],[r,h,-h,-r,-h,h]]}{const s=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t,h=r/2;return[[r,h,-h,-r,-h,h],[0,-n,-n,0,n,n]]}}_render(e,t,{sx:s,sy:i,svx:r,svy:n,_scale:h}){for(const a of t)if(!isNaN(s[a]+i[a]+h[a])){e.translate(s[a],i[a]),e.beginPath();for(let t=0;t<6;t++)e.lineTo(r[t]*h[a],n[t]*h[a]);e.closePath(),e.translate(-s[a],-i[a]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,a),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,a),e.stroke())}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),h=this.index.indices({x0:i,y0:n,x1:i,y1:n}),a=[];for(const e of h)r.point_in_poly(t-this.sx[e],s-this.sy[e],this.svx,this.svy)&&a.push(e);const l=r.create_empty_hit_test_result();return l.indices=a,l}_hit_span(e){const{sx:t,sy:s}=e;let i;if("v"==e.direction){const e=this.renderer.yscale.invert(s),t=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(t.start,t.end);i=this.index.indices({x0:r,y0:e,x1:n,y1:e})}else{const e=this.renderer.xscale.invert(t),s=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(s.start,s.end);i=this.index.indices({x0:e,y0:r,x1:e,y1:n})}const n=r.create_empty_hit_test_result();return n.indices=i,n}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,[h,a]=this.renderer.xscale.r_invert(t,s),[l,o]=this.renderer.yscale.r_invert(i,n),_=r.create_empty_hit_test_result();return _.indices=this.index.indices({x0:h,x1:a,y0:l,y1:o}),_}draw_legend_for_index(e,t,s){a.generic_area_legend(this.visuals,e,t,s)}}s.HexTileView=l,l.__name__="HexTileView";class o extends i.Glyph{constructor(e){super(e)}static init_HexTile(){this.prototype.default_view=l,this.coords([["r","q"]]),this.mixins(["line","fill"]),this.define({size:[n.Number,1],aspect_scale:[n.Number,1],scale:[n.NumberSpec,1],orientation:[n.HexTileOrientation,"pointytop"]}),this.override({line_color:null})}}s.HexTile=o,o.__name__="HexTile",o.init_HexTile()},
function _(e,t,a){const i=e(213),s=e(108),n=e(18),_=e(8);class h extends i.ImageBaseView{initialize(){super.initialize(),this.connect(this.model.color_mapper.change,()=>this._update_image()),this.connect(this.model.properties.global_alpha.change,()=>this.renderer.request_render())}_update_image(){null!=this.image_data&&(this._set_data(),this.renderer.plot_view.request_render())}_set_data(){this._set_width_heigh_data();const e=this.model.color_mapper.rgba_mapper;for(let t=0,a=this._image.length;t<a;t++){let a;if(null!=this._image_shape&&this._image_shape[t].length>0){a=this._image[t];const e=this._image_shape[t];this._height[t]=e[0],this._width[t]=e[1]}else{const e=this._image[t];a=_.concat(e),this._height[t]=e.length,this._width[t]=e[0].length}const i=e.v_compute(a);this._set_image_data_from_buffer(t,i)}}_render(e,t,{image_data:a,sx:i,sy:s,sw:n,sh:_}){const h=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;for(const h of t){if(null==a[h])continue;if(isNaN(i[h]+s[h]+n[h]+_[h]))continue;const t=s[h];e.translate(0,t),e.scale(1,-1),e.translate(0,-t),e.drawImage(a[h],0|i[h],0|s[h],n[h],_[h]),e.translate(0,t),e.scale(1,-1),e.translate(0,-t)}e.setImageSmoothingEnabled(h)}}a.ImageView=h,h.__name__="ImageView";const o=()=>["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"];class l extends i.ImageBase{constructor(e){super(e)}static init_Image(){this.prototype.default_view=h,this.define({color_mapper:[n.Instance,()=>new s.LinearColorMapper({palette:o()})]})}}a.Image=l,l.__name__="Image",l.init_Image()},
function _(e,t,i){const s=e(76),h=e(18),a=e(81),_=e(77);class r extends s.XYGlyphView{_render(e,t,i){}_index_data(){const e=[];for(let t=0,i=this._x.length;t<i;t++){const[i,s,h,a]=this._lrtb(t);!isNaN(i+s+h+a)&&isFinite(i+s+h+a)&&e.push({x0:i,y0:a,x1:s,y1:h,i:t})}return new _.SpatialIndex(e)}_lrtb(e){const t=this.renderer.xscale.source_range,i=this._x[e],s=t.is_reversed?i-this._dw[e]:i+this._dw[e],h=this.renderer.yscale.source_range,a=this._y[e],_=h.is_reversed?a-this._dh[e]:a+this._dh[e],[r,n]=i<s?[i,s]:[s,i],[d,g]=a<_?[a,_]:[_,a];return[r,n,g,d]}_set_width_heigh_data(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new Array(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new Array(this._image.length))}_get_or_create_canvas(e){const t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;{const t=document.createElement("canvas");return t.width=this._width[e],t.height=this._height[e],t}}_set_image_data_from_buffer(e,t){const i=this._get_or_create_canvas(e),s=i.getContext("2d"),h=s.getImageData(0,0,this._width[e],this._height[e]);h.data.set(t),s.putImageData(h,0,0),this.image_data[e]=i}_map_data(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}}_image_index(e,t,i){const[s,h,a,_]=this._lrtb(e),r=this._width[e],n=this._height[e],d=(h-s)/r,g=(a-_)/n;let l=Math.floor((t-s)/d),c=Math.floor((i-_)/g);return this.renderer.xscale.source_range.is_reversed&&(l=r-l-1),this.renderer.yscale.source_range.is_reversed&&(c=n-c-1),{index:e,dim1:l,dim2:c,flat_index:c*r+l}}_hit_point(e){const{sx:t,sy:i}=e,s=this.renderer.xscale.invert(t),h=this.renderer.yscale.invert(i),_=this.index.indices({x0:s,x1:s,y0:h,y1:h}),r=a.create_empty_hit_test_result();r.image_indices=[];for(const e of _)t!=1/0&&i!=1/0&&r.image_indices.push(this._image_index(e,s,h));return r}}i.ImageBaseView=r,r.__name__="ImageBaseView";class n extends s.XYGlyph{constructor(e){super(e)}static init_ImageBase(){this.prototype.default_view=r,this.define({image:[h.NumberSpec],dw:[h.DistanceSpec],dh:[h.DistanceSpec],dilate:[h.Boolean,!1],global_alpha:[h.Number,1]})}}i.ImageBase=n,n.__name__="ImageBase",n.init_ImageBase()},
function _(e,t,a){const i=e(213),s=e(8);class n extends i.ImageBaseView{initialize(){super.initialize(),this.connect(this.model.properties.global_alpha.change,()=>this.renderer.request_render())}_set_data(e){this._set_width_heigh_data();for(let t=0,a=this._image.length;t<a;t++){if(null!=e&&e.indexOf(t)<0)continue;let a;if(null!=this._image_shape&&this._image_shape[t].length>0){a=this._image[t].buffer;const e=this._image_shape[t];this._height[t]=e[0],this._width[t]=e[1]}else{const e=this._image[t],i=s.concat(e);a=new ArrayBuffer(4*i.length);const n=new Uint32Array(a);for(let e=0,t=i.length;e<t;e++)n[e]=i[e];this._height[t]=e.length,this._width[t]=e[0].length}const i=new Uint8Array(a);this._set_image_data_from_buffer(t,i)}}_render(e,t,{image_data:a,sx:i,sy:s,sw:n,sh:h}){const _=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;for(const _ of t){if(isNaN(i[_]+s[_]+n[_]+h[_]))continue;const t=s[_];e.translate(0,t),e.scale(1,-1),e.translate(0,-t),e.drawImage(a[_],0|i[_],0|s[_],n[_],h[_]),e.translate(0,t),e.scale(1,-1),e.translate(0,-t)}e.setImageSmoothingEnabled(_)}}a.ImageRGBAView=n,n.__name__="ImageRGBAView";class h extends i.ImageBase{constructor(e){super(e)}static init_ImageRGBA(){this.prototype.default_view=n}}a.ImageRGBA=h,h.__name__="ImageRGBA",h.init_ImageRGBA()},
function _(e,t,s){const i=e(76),r=e(18),a=e(11),n=e(77),h=e(216);class _ extends i.XYGlyphView{constructor(){super(...arguments),this._images_rendered=!1}initialize(){super.initialize(),this.connect(this.model.properties.global_alpha.change,()=>this.renderer.request_render())}_index_data(){return new n.SpatialIndex([])}_set_data(){null!=this.image&&this.image.length==this._url.length||(this.image=a.map(this._url,()=>null));const{retry_attempts:e,retry_timeout:t}=this.model;for(let s=0,i=this._url.length;s<i;s++){const i=this._url[s];null!=i&&""!=i&&new h.ImageLoader(i,{loaded:e=>{this.image[s]=e,this.renderer.request_render()},attempts:e+1,timeout:t})}const s="data"==this.model.properties.w.units,i="data"==this.model.properties.h.units,r=this._x.length,n=new Array(s?2*r:r),_=new Array(i?2*r:r);for(let e=0;e<r;e++)n[e]=this._x[e],_[e]=this._y[e];if(s)for(let e=0;e<r;e++)n[r+e]=this._x[e]+this._w[e];if(i)for(let e=0;e<r;e++)_[r+e]=this._y[e]+this._h[e];const l=a.min(n),o=a.max(n),d=a.min(_),c=a.max(_);this._bounds_rect={x0:l,x1:o,y0:d,y1:c}}has_finished(){return super.has_finished()&&1==this._images_rendered}_map_data(){const e=null!=this.model.w?this._w:a.map(this._x,()=>NaN),t=null!=this.model.h?this._h:a.map(this._x,()=>NaN);switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,e,"edge",this.model.dilate);break;case"screen":this.sw=e}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,t,"edge",this.model.dilate);break;case"screen":this.sh=t}}_render(e,t,{image:s,sx:i,sy:r,sw:a,sh:n,_angle:h}){const{frame:_}=this.renderer.plot_view;e.rect(_._left.value+1,_._top.value+1,_._width.value-2,_._height.value-2),e.clip();let l=!0;for(const _ of t){if(isNaN(i[_]+r[_]+h[_]))continue;const t=s[_];null!=t?this._render_image(e,_,t,i,r,a,n,h):l=!1}l&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())}_final_sx_sy(e,t,s,i,r){switch(e){case"top_left":return[t,s];case"top_center":return[t-i/2,s];case"top_right":return[t-i,s];case"center_right":return[t-i,s-r/2];case"bottom_right":return[t-i,s-r];case"bottom_center":return[t-i/2,s-r];case"bottom_left":return[t,s-r];case"center_left":return[t,s-r/2];case"center":return[t-i/2,s-r/2]}}_render_image(e,t,s,i,r,a,n,h){isNaN(a[t])&&(a[t]=s.width),isNaN(n[t])&&(n[t]=s.height);const{anchor:_}=this.model,[l,o]=this._final_sx_sy(_,i[t],r[t],a[t],n[t]);e.save(),e.globalAlpha=this.model.global_alpha,h[t]?(e.translate(l,o),e.rotate(h[t]),e.drawImage(s,0,0,a[t],n[t]),e.rotate(-h[t]),e.translate(-l,-o)):e.drawImage(s,l,o,a[t],n[t]),e.restore()}bounds(){return this._bounds_rect}}s.ImageURLView=_,_.__name__="ImageURLView";class l extends i.XYGlyph{constructor(e){super(e)}static init_ImageURL(){this.prototype.default_view=_,this.define({url:[r.StringSpec],anchor:[r.Anchor,"top_left"],global_alpha:[r.Number,1],angle:[r.AngleSpec,0],w:[r.DistanceSpec],h:[r.DistanceSpec],dilate:[r.Boolean,!1],retry_attempts:[r.Number,0],retry_timeout:[r.Number,0]})}}s.ImageURL=l,l.__name__="ImageURL",l.init_ImageURL()},
function _(i,e,t){const s=i(65);class a{constructor(i,e={}){this._image=new Image,this._finished=!1;const{attempts:t=1,timeout:a=1}=e;this.promise=new Promise((o,n)=>{this._image.crossOrigin="anonymous";let r=0;this._image.onerror=(()=>{if(++r==t){const a=`unable to load ${i} image after ${t} attempts`;s.logger.warn(a),null!=this._image.crossOrigin?(s.logger.warn(`attempting to load ${i} without a cross origin policy`),this._image.crossOrigin=null,r=0):null!=e.failed&&e.failed()}setTimeout(()=>this._image.src=i,a)}),this._image.onload=(()=>{this._finished=!0,null!=e.loaded&&e.loaded(this._image),o(this._image)}),this._image.src=i})}get finished(){return this._finished}get image(){return this._image}}t.ImageLoader=a,a.__name__="ImageLoader"},
function _(t,e,s){const i=t(77),n=t(81),l=t(22),r=t(8),o=t(7),h=t(80),_=t(84);class c extends h.GlyphView{_index_data(){const t=[];for(let e=0,s=this._xs.length;e<s;e++){if(null==this._xs[e]||0===this._xs[e].length)continue;const s=this._xs[e],i=[];for(let t=0,e=s.length;t<e;t++){const e=s[t];o.isStrictNaN(e)||i.push(e)}const n=this._ys[e],l=[];for(let t=0,e=n.length;t<e;t++){const e=n[t];o.isStrictNaN(e)||l.push(e)}const[h,_]=[r.min(i),r.max(i)],[c,a]=[r.min(l),r.max(l)];t.push({x0:h,y0:c,x1:_,y1:a,i:e})}return new i.SpatialIndex(t)}_render(t,e,{sxs:s,sys:i}){for(const n of e){const[e,l]=[s[n],i[n]];this.visuals.line.set_vectorize(t,n);for(let s=0,i=e.length;s<i;s++)0!=s?isNaN(e[s])||isNaN(l[s])?(t.stroke(),t.beginPath()):t.lineTo(e[s],l[s]):(t.beginPath(),t.moveTo(e[s],l[s]));t.stroke()}}_hit_point(t){const e=n.create_empty_hit_test_result(),s={x:t.sx,y:t.sy};let i=9999;const r={};for(let t=0,e=this.sxs.length;t<e;t++){const e=Math.max(2,this.visuals.line.cache_select("line_width",t)/2);let l=null;for(let r=0,o=this.sxs[t].length-1;r<o;r++){const o={x:this.sxs[t][r],y:this.sys[t][r]},h={x:this.sxs[t][r+1],y:this.sys[t][r+1]},_=n.dist_to_segment(s,o,h);_<e&&_<i&&(i=_,l=[r])}l&&(r[t]=l)}return e.indices=l.keys(r).map(t=>parseInt(t,10)),e.multiline_indices=r,e}_hit_span(t){const{sx:e,sy:s}=t,i=n.create_empty_hit_test_result();let r,o;"v"===t.direction?(r=this.renderer.yscale.invert(s),o=this._ys):(r=this.renderer.xscale.invert(e),o=this._xs);const h={};for(let t=0,e=o.length;t<e;t++){const e=[];for(let s=0,i=o[t].length-1;s<i;s++)o[t][s]<=r&&r<=o[t][s+1]&&e.push(s);e.length>0&&(h[t]=e)}return i.indices=l.keys(h).map(t=>parseInt(t,10)),i.multiline_indices=h,i}get_interpolation_hit(t,e,s){const[i,n,l,r]=[this._xs[t][e],this._ys[t][e],this._xs[t][e+1],this._ys[t][e+1]];return _.line_interpolation(this.renderer,s,i,n,l,r)}draw_legend_for_index(t,e,s){_.generic_line_legend(this.visuals,t,e,s)}scenterx(){throw new Error("not implemented")}scentery(){throw new Error("not implemented")}}s.MultiLineView=c,c.__name__="MultiLineView";class a extends h.Glyph{constructor(t){super(t)}static init_MultiLine(){this.prototype.default_view=c,this.coords([["xs","ys"]]),this.mixins(["line"])}}s.MultiLine=a,a.__name__="MultiLine",a.init_MultiLine()},
function _(t,e,s){const i=t(77),n=t(80),o=t(84),r=t(8),l=t(11),h=t(81),_=t(7);class a extends n.GlyphView{_index_data(){const t=[];for(let e=0,s=this._xs.length;e<s;e++)for(let s=0,i=this._xs[e].length;s<i;s++){const i=this._xs[e][s][0],n=this._ys[e][s][0];0!=i.length&&t.push({x0:r.min(i),y0:r.min(n),x1:r.max(i),y1:r.max(n),i:e})}return this.hole_index=this._index_hole_data(),new i.SpatialIndex(t)}_index_hole_data(){const t=[];for(let e=0,s=this._xs.length;e<s;e++)for(let s=0,i=this._xs[e].length;s<i;s++)if(this._xs[e][s].length>1)for(let i=1,n=this._xs[e][s].length;i<n;i++){const n=this._xs[e][s][i],o=this._ys[e][s][i];0!=n.length&&t.push({x0:r.min(n),y0:r.min(o),x1:r.max(n),y1:r.max(o),i:e})}return new i.SpatialIndex(t)}_mask_data(){const t=this.renderer.plot_view.frame.x_ranges.default,[e,s]=[t.min,t.max],i=this.renderer.plot_view.frame.y_ranges.default,[n,o]=[i.min,i.max];return this.index.indices({x0:e,x1:s,y0:n,y1:o}).sort((t,e)=>t-e).filter((t,e,s)=>0===e||t!==s[e-1])}_inner_loop(t,e,s){t.beginPath();for(let i=0,n=e.length;i<n;i++)for(let n=0,o=e[i].length;n<o;n++){const o=e[i][n],r=s[i][n];for(let e=0,s=o.length;e<s;e++)0!=e?t.lineTo(o[e],r[e]):t.moveTo(o[e],r[e]);t.closePath()}}_render(t,e,{sxs:s,sys:i}){if(this.visuals.fill.doit||this.visuals.line.doit)for(const n of e){const[e,o]=[s[n],i[n]];this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,n),this._inner_loop(t,e,o),t.fill("evenodd")),this.visuals.hatch.doit2(t,n,()=>{this._inner_loop(t,e,o),t.fill("evenodd")},()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,n),this._inner_loop(t,e,o),t.stroke())}}_hit_point(t){const{sx:e,sy:s}=t,i=this.renderer.xscale.invert(e),n=this.renderer.yscale.invert(s),o=this.index.indices({x0:i,y0:n,x1:i,y1:n}),r=this.hole_index.indices({x0:i,y0:n,x1:i,y1:n}),l=[];for(let t=0,i=o.length;t<i;t++){const i=o[t],n=this.sxs[i],_=this.sys[i];for(let t=0,o=n.length;t<o;t++){const o=n[t].length;if(h.point_in_poly(e,s,n[t][0],_[t][0]))if(1==o)l.push(i);else if(-1==r.indexOf(i))l.push(i);else if(o>1){let r=!1;for(let i=1;i<o;i++){const o=n[t][i],l=_[t][i];if(h.point_in_poly(e,s,o,l)){r=!0;break}}r||l.push(i)}}}const _=h.create_empty_hit_test_result();return _.indices=l,_}_get_snap_coord(t){return l.sum(t)/t.length}scenterx(t,e,s){if(1==this.sxs[t].length)return this._get_snap_coord(this.sxs[t][0][0]);{const i=this.sxs[t],n=this.sys[t];for(let t=0,o=i.length;t<o;t++)if(h.point_in_poly(e,s,i[t][0],n[t][0]))return this._get_snap_coord(i[t][0])}throw new Error("unreachable code")}scentery(t,e,s){if(1==this.sys[t].length)return this._get_snap_coord(this.sys[t][0][0]);{const i=this.sxs[t],n=this.sys[t];for(let t=0,o=i.length;t<o;t++)if(h.point_in_poly(e,s,i[t][0],n[t][0]))return this._get_snap_coord(n[t][0])}throw new Error("unreachable code")}map_data(){const t=this;for(let[e,s]of this.model._coords){const i=`s${e}`,n=`s${s}`;if(e=`_${e}`,s=`_${s}`,null!=t[e]&&(_.isArray(t[e][0])||_.isTypedArray(t[e][0]))){const o=t[e].length;t[i]=new Array(o),t[n]=new Array(o);for(let r=0;r<o;r++){const o=t[e][r].length;t[i][r]=new Array(o),t[n][r]=new Array(o);for(let l=0;l<o;l++){const o=t[e][r][l].length;t[i][r][l]=new Array(o),t[n][r][l]=new Array(o);for(let h=0;h<o;h++){const[o,_]=this.map_to_screen(t[e][r][l][h],t[s][r][l][h]);t[i][r][l][h]=o,t[n][r][l][h]=_}}}}}}draw_legend_for_index(t,e,s){o.generic_area_legend(this.visuals,t,e,s)}}s.MultiPolygonsView=a,a.__name__="MultiPolygonsView";class c extends n.Glyph{constructor(t){super(t)}static init_MultiPolygons(){this.prototype.default_view=a,this.coords([["xs","ys"]]),this.mixins(["line","fill","hatch"])}}s.MultiPolygons=c,c.__name__="MultiPolygons",c.init_MultiPolygons()},
function _(t,s,i){const e=t(208);class h extends e.EllipseOvalView{_map_data(){let t;const s=this._x.length;this.sw=new Float64Array(s),t="data"==this.model.properties.width.units?this.sdist(this.renderer.xscale,this._x,this._width,"center"):this._width;for(let i=0;i<s;i++)this.sw[i]=.75*t[i];"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height}}i.OvalView=h,h.__name__="OvalView";class a extends e.EllipseOval{constructor(t){super(t)}static init_Oval(){this.prototype.default_view=h}}i.Oval=a,a.__name__="Oval",a.init_Oval()},
function _(s,t,e){const i=s(77),n=s(80),o=s(84),r=s(8),_=s(11),h=s(7),l=s(81);class c extends n.GlyphView{_build_discontinuous_object(s){const t=[];for(let e=0,i=s.length;e<i;e++){t[e]=[];let i=r.copy(s[e]);for(;i.length>0;){const s=r.find_last_index(i,s=>h.isStrictNaN(s));let n;s>=0?n=i.splice(s):(n=i,i=[]);const o=n.filter(s=>!h.isStrictNaN(s));t[e].push(o)}}return t}_index_data(){const s=this._build_discontinuous_object(this._xs),t=this._build_discontinuous_object(this._ys),e=[];for(let i=0,n=this._xs.length;i<n;i++)for(let n=0,o=s[i].length;n<o;n++){const o=s[i][n],_=t[i][n];0!=o.length&&e.push({x0:r.min(o),y0:r.min(_),x1:r.max(o),y1:r.max(_),i:i})}return new i.SpatialIndex(e)}_mask_data(){const s=this.renderer.plot_view.frame.x_ranges.default,[t,e]=[s.min,s.max],i=this.renderer.plot_view.frame.y_ranges.default,[n,o]=[i.min,i.max];return this.index.indices({x0:t,x1:e,y0:n,y1:o}).sort((s,t)=>s-t)}_inner_loop(s,t,e,i){for(let n=0,o=t.length;n<o;n++)0!=n?isNaN(t[n]+e[n])?(s.closePath(),i.apply(s),s.beginPath()):s.lineTo(t[n],e[n]):(s.beginPath(),s.moveTo(t[n],e[n]));s.closePath(),i.call(s)}_render(s,t,{sxs:e,sys:i}){this.sxss=this._build_discontinuous_object(e),this.syss=this._build_discontinuous_object(i);for(const n of t){const[t,o]=[e[n],i[n]];this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(s,n),this._inner_loop(s,t,o,s.fill)),this.visuals.hatch.doit2(s,n,()=>this._inner_loop(s,t,o,s.fill),()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,n),this._inner_loop(s,t,o,s.stroke))}}_hit_point(s){const{sx:t,sy:e}=s,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(e),o=this.index.indices({x0:i,y0:n,x1:i,y1:n}),r=[];for(let s=0,i=o.length;s<i;s++){const i=o[s],n=this.sxss[i],_=this.syss[i];for(let s=0,o=n.length;s<o;s++)l.point_in_poly(t,e,n[s],_[s])&&r.push(i)}const _=l.create_empty_hit_test_result();return _.indices=r,_}_get_snap_coord(s){return _.sum(s)/s.length}scenterx(s,t,e){if(1==this.sxss[s].length)return this._get_snap_coord(this.sxs[s]);{const i=this.sxss[s],n=this.syss[s];for(let s=0,o=i.length;s<o;s++)if(l.point_in_poly(t,e,i[s],n[s]))return this._get_snap_coord(i[s])}throw new Error("unreachable code")}scentery(s,t,e){if(1==this.syss[s].length)return this._get_snap_coord(this.sys[s]);{const i=this.sxss[s],n=this.syss[s];for(let s=0,o=i.length;s<o;s++)if(l.point_in_poly(t,e,i[s],n[s]))return this._get_snap_coord(n[s])}throw new Error("unreachable code")}draw_legend_for_index(s,t,e){o.generic_area_legend(this.visuals,s,t,e)}}e.PatchesView=c,c.__name__="PatchesView";class a extends n.Glyph{constructor(s){super(s)}static init_Patches(){this.prototype.default_view=c,this.coords([["xs","ys"]]),this.mixins(["line","fill","hatch"])}}e.Patches=a,a.__name__="Patches",a.init_Patches()},
function _(t,s,i){const e=t(210);class _ extends e.BoxView{scenterx(t){return(this.sleft[t]+this.sright[t])/2}scentery(t){return(this.stop[t]+this.sbottom[t])/2}_index_data(){return this._index_box(this._right.length)}_lrtb(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]}}i.QuadView=_,_.__name__="QuadView";class o extends e.Box{constructor(t){super(t)}static init_Quad(){this.prototype.default_view=_,this.coords([["right","bottom"],["left","top"]])}}i.Quad=o,o.__name__="Quad",o.init_Quad()},
function _(t,i,e){const s=t(77),n=t(80),r=t(84);function a(t,i,e){if(i==(t+e)/2)return[t,e];{const s=(t-i)/(t-2*i+e),n=t*Math.pow(1-s,2)+2*i*(1-s)*s+e*Math.pow(s,2);return[Math.min(t,e,n),Math.max(t,e,n)]}}class _ extends n.GlyphView{_index_data(){const t=[];for(let i=0,e=this._x0.length;i<e;i++){if(isNaN(this._x0[i]+this._x1[i]+this._y0[i]+this._y1[i]+this._cx[i]+this._cy[i]))continue;const[e,s]=a(this._x0[i],this._cx[i],this._x1[i]),[n,r]=a(this._y0[i],this._cy[i],this._y1[i]);t.push({x0:e,y0:n,x1:s,y1:r,i:i})}return new s.SpatialIndex(t)}_render(t,i,{sx0:e,sy0:s,sx1:n,sy1:r,scx:a,scy:_}){if(this.visuals.line.doit)for(const c of i)isNaN(e[c]+s[c]+n[c]+r[c]+a[c]+_[c])||(t.beginPath(),t.moveTo(e[c],s[c]),t.quadraticCurveTo(a[c],_[c],n[c],r[c]),this.visuals.line.set_vectorize(t,c),t.stroke())}draw_legend_for_index(t,i,e){r.generic_line_legend(this.visuals,t,i,e)}scenterx(){throw new Error("not implemented")}scentery(){throw new Error("not implemented")}}e.QuadraticView=_,_.__name__="QuadraticView";class c extends n.Glyph{constructor(t){super(t)}static init_Quadratic(){this.prototype.default_view=_,this.coords([["x0","y0"],["x1","y1"],["cx","cy"]]),this.mixins(["line"])}}e.Quadratic=c,c.__name__="Quadratic",c.init_Quadratic()},
function _(e,t,i){const s=e(76),n=e(84),a=e(18);class l extends s.XYGlyphView{_map_data(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length}_render(e,t,{sx:i,sy:s,slength:n,_angle:a}){if(this.visuals.line.doit){const l=2*(this.renderer.plot_view.frame._width.value+this.renderer.plot_view.frame._height.value);for(let e=0,t=n.length;e<t;e++)0==n[e]&&(n[e]=l);for(const l of t)isNaN(i[l]+s[l]+a[l]+n[l])||(e.translate(i[l],s[l]),e.rotate(a[l]),e.beginPath(),e.moveTo(0,0),e.lineTo(n[l],0),this.visuals.line.set_vectorize(e,l),e.stroke(),e.rotate(-a[l]),e.translate(-i[l],-s[l]))}}draw_legend_for_index(e,t,i){n.generic_line_legend(this.visuals,e,t,i)}}i.RayView=l,l.__name__="RayView";class h extends s.XYGlyph{constructor(e){super(e)}static init_Ray(){this.prototype.default_view=l,this.mixins(["line"]),this.define({length:[a.DistanceSpec],angle:[a.AngleSpec]})}}i.Ray=h,h.__name__="Ray",h.init_Ray()},
function _(t,s,e){const i=t(206),h=t(84),a=t(81),r=t(18),n=t(11);class _ extends i.CenterRotatableView{_set_data(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)}_map_data(){if("data"==this.model.properties.width.units)[this.sw,this.sx0]=this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale);else{this.sw=this._width;const t=this.sx.length;this.sx0=new Float64Array(t);for(let s=0;s<t;s++)this.sx0[s]=this.sx[s]-this.sw[s]/2}if("data"==this.model.properties.height.units)[this.sh,this.sy1]=this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale);else{this.sh=this._height;const t=this.sy.length;this.sy1=new Float64Array(t);for(let s=0;s<t;s++)this.sy1[s]=this.sy[s]-this.sh[s]/2}const t=this.sw.length;this.ssemi_diag=new Float64Array(t);for(let s=0;s<t;s++)this.ssemi_diag[s]=Math.sqrt(this.sw[s]/2*this.sw[s]/2+this.sh[s]/2*this.sh[s]/2)}_render(t,s,{sx:e,sy:i,sx0:h,sy1:a,sw:r,sh:n,_angle:_}){if(this.visuals.fill.doit)for(const l of s)isNaN(e[l]+i[l]+h[l]+a[l]+r[l]+n[l]+_[l])||(this.visuals.fill.set_vectorize(t,l),_[l]?(t.translate(e[l],i[l]),t.rotate(_[l]),t.fillRect(-r[l]/2,-n[l]/2,r[l],n[l]),t.rotate(-_[l]),t.translate(-e[l],-i[l])):t.fillRect(h[l],a[l],r[l],n[l]));if(this.visuals.line.doit){t.beginPath();for(const l of s)isNaN(e[l]+i[l]+h[l]+a[l]+r[l]+n[l]+_[l])||0!=r[l]&&0!=n[l]&&(_[l]?(t.translate(e[l],i[l]),t.rotate(_[l]),t.rect(-r[l]/2,-n[l]/2,r[l],n[l]),t.rotate(-_[l]),t.translate(-e[l],-i[l])):t.rect(h[l],a[l],r[l],n[l]),this.visuals.line.set_vectorize(t,l),t.stroke(),t.beginPath());t.stroke()}}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){let{sx:s,sy:e}=t;const i=this.renderer.xscale.invert(s),h=this.renderer.yscale.invert(e),r=[];for(let t=0,s=this.sx0.length;t<s;t++)r.push(this.sx0[t]+this.sw[t]/2);const _=[];for(let t=0,s=this.sy1.length;t<s;t++)_.push(this.sy1[t]+this.sh[t]/2);const l=n.max(this._ddist(0,r,this.ssemi_diag)),o=n.max(this._ddist(1,_,this.ssemi_diag)),d=i-l,c=i+l,x=h-o,y=h+o,f=[];for(const t of this.index.indices({x0:d,x1:c,y0:x,y1:y})){let i,h;if(this._angle[t]){const a=Math.sin(-this._angle[t]),r=Math.cos(-this._angle[t]),n=r*(s-this.sx[t])-a*(e-this.sy[t])+this.sx[t],_=a*(s-this.sx[t])+r*(e-this.sy[t])+this.sy[t];s=n,e=_,h=Math.abs(this.sx[t]-s)<=this.sw[t]/2,i=Math.abs(this.sy[t]-e)<=this.sh[t]/2}else h=s-this.sx0[t]<=this.sw[t]&&s-this.sx0[t]>=0,i=e-this.sy1[t]<=this.sh[t]&&e-this.sy1[t]>=0;i&&h&&f.push(t)}const g=a.create_empty_hit_test_result();return g.indices=f,g}_map_dist_corner_for_data_side_length(t,s,e){const i=t.length,h=new Float64Array(i),a=new Float64Array(i);for(let e=0;e<i;e++)h[e]=Number(t[e])-s[e]/2,a[e]=Number(t[e])+s[e]/2;const r=e.v_compute(h),n=e.v_compute(a),_=this.sdist(e,h,s,"edge",this.model.dilate);let l=r;for(let t=0,s=r.length;t<s;t++)if(r[t]!=n[t]){l=r[t]<n[t]?r:n;break}return[_,l]}_ddist(t,s,e){const i=0==t?this.renderer.xscale:this.renderer.yscale,h=s,a=h.length,r=new Float64Array(a);for(let t=0;t<a;t++)r[t]=h[t]+e[t];const n=i.v_invert(h),_=i.v_invert(r),l=n.length,o=new Float64Array(l);for(let t=0;t<l;t++)o[t]=Math.abs(_[t]-n[t]);return o}draw_legend_for_index(t,s,e){h.generic_area_legend(this.visuals,t,s,e)}_bounds({x0:t,x1:s,y0:e,y1:i}){return{x0:t-this.max_w2,x1:s+this.max_w2,y0:e-this.max_h2,y1:i+this.max_h2}}}e.RectView=_,_.__name__="RectView";class l extends i.CenterRotatable{constructor(t){super(t)}static init_Rect(){this.prototype.default_view=_,this.define({dilate:[r.Boolean,!1]})}}e.Rect=l,l.__name__="Rect",l.init_Rect()},
function _(e,t,s){const i=e(81),n=e(77),r=e(80),h=e(84);class _ extends r.GlyphView{_index_data(){const e=[];for(let t=0,s=this._x0.length;t<s;t++){const s=this._x0[t],i=this._x1[t],n=this._y0[t],r=this._y1[t];isNaN(s+i+n+r)||e.push({x0:Math.min(s,i),y0:Math.min(n,r),x1:Math.max(s,i),y1:Math.max(n,r),i:t})}return new n.SpatialIndex(e)}_render(e,t,{sx0:s,sy0:i,sx1:n,sy1:r}){if(this.visuals.line.doit)for(const h of t)isNaN(s[h]+i[h]+n[h]+r[h])||(e.beginPath(),e.moveTo(s[h],i[h]),e.lineTo(n[h],r[h]),this.visuals.line.set_vectorize(e,h),e.stroke())}_hit_point(e){const{sx:t,sy:s}=e,n={x:t,y:s},r=[],[h,_]=this.renderer.xscale.r_invert(t-2,t+2),[a,x]=this.renderer.yscale.r_invert(s-2,s+2),c=this.index.indices({x0:h,y0:a,x1:_,y1:x});for(const e of c){const t=Math.pow(Math.max(2,this.visuals.line.cache_select("line_width",e)/2),2),s={x:this.sx0[e],y:this.sy0[e]},h={x:this.sx1[e],y:this.sy1[e]};i.dist_to_segment_squared(n,s,h)<t&&r.push(e)}const o=i.create_empty_hit_test_result();return o.indices=r,o}_hit_span(e){const[t,s]=this.renderer.plot_view.frame.bbox.ranges,{sx:n,sy:r}=e;let h,_,a;"v"==e.direction?(a=this.renderer.yscale.invert(r),[h,_]=[this._y0,this._y1]):(a=this.renderer.xscale.invert(n),[h,_]=[this._x0,this._x1]);const x=[],[c,o]=this.renderer.xscale.r_invert(t.start,t.end),[d,l]=this.renderer.yscale.r_invert(s.start,s.end),y=this.index.indices({x0:c,y0:d,x1:o,y1:l});for(const e of y)(h[e]<=a&&a<=_[e]||_[e]<=a&&a<=h[e])&&x.push(e);const m=i.create_empty_hit_test_result();return m.indices=x,m}scenterx(e){return(this.sx0[e]+this.sx1[e])/2}scentery(e){return(this.sy0[e]+this.sy1[e])/2}draw_legend_for_index(e,t,s){h.generic_line_legend(this.visuals,e,t,s)}}s.SegmentView=_,_.__name__="SegmentView";class a extends r.Glyph{constructor(e){super(e)}static init_Segment(){this.prototype.default_view=_,this.coords([["x0","y0"],["x1","y1"]]),this.mixins(["line"])}}s.Segment=a,a.__name__="Segment",a.init_Segment()},
function _(e,t,i){const n=e(76),s=e(84),o=e(18);class l extends n.XYGlyphView{_render(e,t,{sx:i,sy:n}){let s=!1,o=null;this.visuals.line.set_value(e);const l=t.length;if(!(l<2)){e.beginPath(),e.moveTo(i[0],n[0]);for(const l of t){let t,r,a,_;switch(this.model.mode){case"before":[t,a]=[i[l-1],n[l]],[r,_]=[i[l],n[l]];break;case"after":[t,a]=[i[l],n[l-1]],[r,_]=[i[l],n[l]];break;case"center":{const e=(i[l-1]+i[l])/2;[t,a]=[e,n[l-1]],[r,_]=[e,n[l]];break}default:throw new Error("unexpected")}if(s){if(!isFinite(i[l]+n[l])){e.stroke(),e.beginPath(),s=!1,o=l;continue}null!=o&&l-o>1&&(e.stroke(),s=!1)}s?(e.lineTo(t,a),e.lineTo(r,_)):(e.beginPath(),e.moveTo(i[l],n[l]),s=!0),o=l}e.lineTo(i[l-1],n[l-1]),e.stroke()}}draw_legend_for_index(e,t,i){s.generic_line_legend(this.visuals,e,t,i)}}i.StepView=l,l.__name__="StepView";class r extends n.XYGlyph{constructor(e){super(e)}static init_Step(){this.prototype.default_view=l,this.mixins(["line"]),this.define({mode:[o.StepMode,"before"]})}}i.Step=r,r.__name__="Step",r.init_Step()},
function _(t,s,e){const i=t(76),n=t(81),_=t(18),h=t(124);class o extends i.XYGlyphView{_rotate_point(t,s,e,i,n){return[(t-e)*Math.cos(n)-(s-i)*Math.sin(n)+e,(t-e)*Math.sin(n)+(s-i)*Math.cos(n)+i]}_text_bounds(t,s,e,i){return[[t,t+e,t+e,t,t],[s,s,s-i,s-i,s]]}_render(t,s,{sx:e,sy:i,_x_offset:n,_y_offset:_,_angle:o,_text:r}){this._sys=[],this._sxs=[];for(const x of s)if(!isNaN(e[x]+i[x]+n[x]+_[x]+o[x])&&null!=r[x]&&(this._sxs[x]=[],this._sys[x]=[],this.visuals.text.doit)){const s=`${r[x]}`;t.save(),t.translate(e[x]+n[x],i[x]+_[x]),t.rotate(o[x]),this.visuals.text.set_vectorize(t,x);const l=this.visuals.text.cache_select("font",x),{height:a}=h.measure_font(l),c=this.visuals.text.text_line_height.value()*a;if(-1==s.indexOf("\n")){t.fillText(s,0,0);const h=e[x]+n[x],o=i[x]+_[x],r=t.measureText(s).width,[l,a]=this._text_bounds(h,o,r,c);this._sxs[x].push(l),this._sys[x].push(a)}else{const h=s.split("\n"),o=c*h.length,r=this.visuals.text.cache_select("text_baseline",x);let l;switch(r){case"top":l=0;break;case"middle":l=-o/2+c/2;break;case"bottom":l=-o+c;break;default:l=0,console.warn(`'${r}' baseline not supported with multi line text`)}for(const s of h){t.fillText(s,0,l);const h=e[x]+n[x],o=l+i[x]+_[x],r=t.measureText(s).width,[a,u]=this._text_bounds(h,o,r,c);this._sxs[x].push(a),this._sys[x].push(u),l+=c}}t.restore()}}_hit_point(t){const{sx:s,sy:e}=t,i=[];for(let t=0;t<this._sxs.length;t++){const _=this._sxs[t],h=this._sys[t],o=_.length;for(let r=0,x=o;r<x;r++){const[x,l]=this._rotate_point(s,e,_[o-1][0],h[o-1][0],-this._angle[t]);n.point_in_poly(x,l,_[r],h[r])&&i.push(t)}}const _=n.create_empty_hit_test_result();return _.indices=i,_}_scenterxy(t){const s=this._sxs[t][0][0],e=this._sys[t][0][0],i=(this._sxs[t][0][2]+s)/2,n=(this._sys[t][0][2]+e)/2,[_,h]=this._rotate_point(i,n,s,e,this._angle[t]);return{x:_,y:h}}scenterx(t){return this._scenterxy(t).x}scentery(t){return this._scenterxy(t).y}}e.TextView=o,o.__name__="TextView";class r extends i.XYGlyph{constructor(t){super(t)}static init_Text(){this.prototype.default_view=o,this.mixins(["text"]),this.define({text:[_.NullStringSpec,{field:"text"}],angle:[_.AngleSpec,0],x_offset:[_.NumberSpec,0],y_offset:[_.NumberSpec,0]})}}e.Text=r,r.__name__="Text",r.init_Text()},
function _(t,s,i){const e=t(210),h=t(18);class r extends e.BoxView{scenterx(t){return this.sx[t]}scentery(t){return(this.stop[t]+this.sbottom[t])/2}_index_data(){return this._index_box(this._x.length)}_lrtb(t){return[this._x[t]-this._width[t]/2,this._x[t]+this._width[t]/2,Math.max(this._top[t],this._bottom[t]),Math.min(this._top[t],this._bottom[t])]}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);const t=this.sx.length;this.sleft=new Float64Array(t),this.sright=new Float64Array(t);for(let s=0;s<t;s++)this.sleft[s]=this.sx[s]-this.sw[s]/2,this.sright[s]=this.sx[s]+this.sw[s]/2;this._clamp_viewport()}}i.VBarView=r,r.__name__="VBarView";class o extends e.Box{constructor(t){super(t)}static init_VBar(){this.prototype.default_view=r,this.coords([["x","bottom"]]),this.define({width:[h.NumberSpec],top:[h.CoordinateSpec]}),this.override({bottom:0})}}i.VBar=o,o.__name__="VBar",o.init_VBar()},
function _(e,s,t){const i=e(76),r=e(84),n=e(81),a=e(18),_=e(9);class h extends i.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius}_render(e,s,{sx:t,sy:i,sradius:r,_start_angle:n,_end_angle:a}){const _=this.model.properties.direction.value();for(const h of s)isNaN(t[h]+i[h]+r[h]+n[h]+a[h])||(e.beginPath(),e.arc(t[h],i[h],r[h],n[h],a[h],_),e.lineTo(t[h],i[h]),e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,h),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,h),e.stroke()))}_hit_point(e){let s,t,i,r,a,h,d,l,o;const{sx:c,sy:u}=e,p=this.renderer.xscale.invert(c),x=this.renderer.yscale.invert(u),g=2*this.max_radius;"data"===this.model.properties.radius.units?(h=p-g,d=p+g,l=x-g,o=x+g):(t=c-g,i=c+g,[h,d]=this.renderer.xscale.r_invert(t,i),r=u-g,a=u+g,[l,o]=this.renderer.yscale.r_invert(r,a));const y=[];for(const e of this.index.indices({x0:h,x1:d,y0:l,y1:o})){const n=Math.pow(this.sradius[e],2);[t,i]=this.renderer.xscale.r_compute(p,this._x[e]),[r,a]=this.renderer.yscale.r_compute(x,this._y[e]),(s=Math.pow(t-i,2)+Math.pow(r-a,2))<=n&&y.push([e,s])}const f=this.model.properties.direction.value(),v=[];for(const[e,s]of y){const t=Math.atan2(u-this.sy[e],c-this.sx[e]);_.angle_between(-t,-this._start_angle[e],-this._end_angle[e],f)&&v.push([e,s])}return n.create_hit_test_result_from_hits(v)}draw_legend_for_index(e,s,t){r.generic_area_legend(this.visuals,e,s,t)}_scenterxy(e){const s=this.sradius[e]/2,t=(this._start_angle[e]+this._end_angle[e])/2;return{x:this.sx[e]+s*Math.cos(t),y:this.sy[e]+s*Math.sin(t)}}scenterx(e){return this._scenterxy(e).x}scentery(e){return this._scenterxy(e).y}}t.WedgeView=h,h.__name__="WedgeView";class d extends i.XYGlyph{constructor(e){super(e)}static init_Wedge(){this.prototype.default_view=h,this.mixins(["line","fill"]),this.define({direction:[a.Direction,"anticlock"],radius:[a.DistanceSpec],start_angle:[a.AngleSpec],end_angle:[a.AngleSpec]})}}t.Wedge=d,d.__name__="Wedge",d.init_Wedge()},
function _(n,o,r){function f(n){for(var o in n)r.hasOwnProperty(o)||(r[o]=n[o])}f(n(91)),f(n(231)),f(n(232))},
function _(o,e,r){const t=o(64);class n extends t.Model{constructor(o){super(o)}}r.LayoutProvider=n,n.__name__="LayoutProvider"},
function _(t,a,o){const s=t(231),e=t(18);class n extends s.LayoutProvider{constructor(t){super(t)}static init_StaticLayoutProvider(){this.define({graph_layout:[e.Any,{}]})}get_node_coordinates(t){const a=[],o=[],s=t.data.index;for(let t=0,e=s.length;t<e;t++){const e=this.graph_layout[s[t]],[n,r]=null!=e?e:[NaN,NaN];a.push(n),o.push(r)}return[a,o]}get_edge_coordinates(t){const a=[],o=[],s=t.data.start,e=t.data.end,n=null!=t.data.xs&&null!=t.data.ys;for(let r=0,u=s.length;r<u;r++){const u=null!=this.graph_layout[s[r]]&&null!=this.graph_layout[e[r]];if(n&&u)a.push(t.data.xs[r]),o.push(t.data.ys[r]);else{let t,n;[n,t]=u?[this.graph_layout[s[r]],this.graph_layout[e[r]]]:[[NaN,NaN],[NaN,NaN]],a.push([n[0],t[0]]),o.push([n[1],t[1]])}}return[a,o]}}o.StaticLayoutProvider=n,n.__name__="StaticLayoutProvider",n.init_StaticLayoutProvider()},
function _(i,r,d){var n=i(234);d.Grid=n.Grid},
function _(e,i,n){const t=e(142),s=e(18),r=e(7);class _ extends t.GuideRendererView{get _x_range_name(){return this.model.x_range_name}get _y_range_name(){return this.model.y_range_name}render(){if(!this.model.visible)return;const e=this.plot_view.canvas_view.ctx;e.save(),this._draw_regions(e),this._draw_minor_grids(e),this._draw_grids(e),e.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render())}_draw_regions(e){if(!this.visuals.band_fill.doit&&!this.visuals.band_hatch.doit)return;this.visuals.band_fill.set_value(e);const[i,n]=this.grid_coords("major",!1);for(let t=0;t<i.length-1;t++){if(t%2!=1)continue;const[s,r]=this.plot_view.map_to_screen(i[t],n[t],this._x_range_name,this._y_range_name),[_,a]=this.plot_view.map_to_screen(i[t+1],n[t+1],this._x_range_name,this._y_range_name);this.visuals.band_fill.doit&&e.fillRect(s[0],r[0],_[1]-s[0],a[1]-r[0]),this.visuals.band_hatch.doit2(e,t,()=>{e.fillRect(s[0],r[0],_[1]-s[0],a[1]-r[0])},()=>this.request_render())}}_draw_grids(e){if(!this.visuals.grid_line.doit)return;const[i,n]=this.grid_coords("major");this._draw_grid_helper(e,this.visuals.grid_line,i,n)}_draw_minor_grids(e){if(!this.visuals.minor_grid_line.doit)return;const[i,n]=this.grid_coords("minor");this._draw_grid_helper(e,this.visuals.minor_grid_line,i,n)}_draw_grid_helper(e,i,n,t){i.set_value(e);for(let i=0;i<n.length;i++){const[s,r]=this.plot_view.map_to_screen(n[i],t[i],this._x_range_name,this._y_range_name);e.beginPath(),e.moveTo(Math.round(s[0]),Math.round(r[0]));for(let i=1;i<s.length;i++)e.lineTo(Math.round(s[i]),Math.round(r[i]));e.stroke()}}ranges(){const e=this.model.dimension,i=(e+1)%2,n=this.plot_view.frame,t=[n.x_ranges[this.model.x_range_name],n.y_ranges[this.model.y_range_name]];return[t[e],t[i]]}computed_bounds(){const[e]=this.ranges(),i=this.model.bounds,n=[e.min,e.max];let t,s;if(r.isArray(i))t=Math.min(i[0],i[1]),s=Math.max(i[0],i[1]),t<n[0]&&(t=n[0]),s>n[1]&&(s=n[1]);else{[t,s]=n;for(const e of this.plot_view.axis_views)e.dimension==this.model.dimension&&e.model.x_range_name==this.model.x_range_name&&e.model.y_range_name==this.model.y_range_name&&([t,s]=e.computed_bounds)}return[t,s]}grid_coords(e,i=!0){const n=this.model.dimension,t=(n+1)%2,[s,r]=this.ranges();let[_,a]=this.computed_bounds();[_,a]=[Math.min(_,a),Math.max(_,a)];const o=this.model.ticker.get_ticks(_,a,s,r.min,{})[e],d=s.min,l=s.max,h=r.min,m=r.max,g=[[],[]];i||(o[0]!=d&&o.splice(0,0,d),o[o.length-1]!=l&&o.push(l));for(let e=0;e<o.length;e++){if((o[e]==d||o[e]==l)&&i)continue;const s=[],r=[],_=2;for(let i=0;i<_;i++){const n=h+(m-h)/(_-1)*i;s.push(o[e]),r.push(n)}g[n].push(s),g[t].push(r)}return g}}n.GridView=_,_.__name__="GridView";class a extends t.GuideRenderer{constructor(e){super(e)}static init_Grid(){this.prototype.default_view=_,this.mixins(["line:grid_","line:minor_grid_","fill:band_","hatch:band_"]),this.define({bounds:[s.Any,"auto"],dimension:[s.Any,0],ticker:[s.Instance],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})}}n.Grid=a,a.__name__="Grid",a.init_Grid()},
function _(a,o,r){var v=a(236);r.Box=v.Box;var x=a(238);r.Column=x.Column;var B=a(239);r.GridBox=B.GridBox;var e=a(240);r.HTMLBox=e.HTMLBox;var n=a(237);r.LayoutDOM=n.LayoutDOM;var i=a(241);r.Row=i.Row;var t=a(242);r.Spacer=t.Spacer;var u=a(243);r.Panel=u.Panel,r.Tabs=u.Tabs;var d=a(247);r.WidgetBox=d.WidgetBox},
function _(e,n,i){const s=e(237),t=e(18);class c extends s.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,()=>this.rebuild())}get child_models(){return this.model.children}}i.BoxView=c,c.__name__="BoxView";class o extends s.LayoutDOM{constructor(e){super(e)}static init_Box(){this.define({children:[t.Array,[]],spacing:[t.Number,0]})}}i.Box=o,o.__name__="Box",o.init_Box()},
function _(t,i,e){const s=t(64),o=t(61),l=t(65),h=t(7),n=t(18),a=t(92),r=t(59),_=t(62);class d extends r.DOMView{constructor(){super(...arguments),this._idle_notified=!1,this._offset_parent=null,this._viewport={}}initialize(){super.initialize(),this.el.style.position=this.is_root?"relative":"absolute",this._child_views={},this.build_child_views()}remove(){for(const t of this.child_views)t.remove();this._child_views={},super.remove()}connect_signals(){super.connect_signals(),this.is_root&&(this._on_resize=(()=>this.resize_layout()),window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval(()=>{const t=this.el.offsetParent;this._offset_parent!=t&&(this._offset_parent=t,null!=t&&(this.compute_viewport(),this.invalidate_layout()))},250));const t=this.model.properties;this.on_change([t.width,t.height,t.min_width,t.min_height,t.max_width,t.max_height,t.margin,t.width_policy,t.height_policy,t.sizing_mode,t.aspect_ratio,t.visible],()=>this.invalidate_layout()),this.on_change([t.background,t.css_classes],()=>this.invalidate_render())}disconnect_signals(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),super.disconnect_signals()}css_classes(){return super.css_classes().concat(this.model.css_classes)}get child_views(){return this.child_models.map(t=>this._child_views[t.id])}build_child_views(){a.build_views(this._child_views,this.child_models,{parent:this})}render(){super.render(),o.empty(this.el);const{background:t}=this.model;this.el.style.backgroundColor=null!=t?t:"",o.classes(this.el).clear().add(...this.css_classes());for(const t of this.child_views)this.el.appendChild(t.el),t.render()}update_layout(){for(const t of this.child_views)t.update_layout();this._update_layout()}update_position(){this.el.style.display=this.model.visible?"block":"none";const t=this.is_root?this.layout.sizing.margin:void 0;o.position(this.el,this.layout.bbox,t);for(const t of this.child_views)t.update_position()}after_layout(){for(const t of this.child_views)t.after_layout();this._has_finished=!0}compute_viewport(){this._viewport=this._viewport_size()}renderTo(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()}build(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this}rebuild(){this.build_child_views(),this.invalidate_render()}compute_layout(){const t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),l.logger.debug(`layout computed in ${Date.now()-t} ms`),this.notify_finished()}resize_layout(){this.root.compute_viewport(),this.root.compute_layout()}invalidate_layout(){this.root.update_layout(),this.root.compute_layout()}invalidate_render(){this.render(),this.invalidate_layout()}has_finished(){if(!super.has_finished())return!1;for(const t of this.child_views)if(!t.has_finished())return!1;return!0}notify_finished(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()}_width_policy(){return null!=this.model.width?"fixed":"fit"}_height_policy(){return null!=this.model.height?"fixed":"fit"}box_sizing(){let{width_policy:t,height_policy:i,aspect_ratio:e}=this.model;"auto"==t&&(t=this._width_policy()),"auto"==i&&(i=this._height_policy());const{sizing_mode:s}=this.model;if(null!=s)if("fixed"==s)t=i="fixed";else if("stretch_both"==s)t=i="max";else if("stretch_width"==s)t="max";else if("stretch_height"==s)i="max";else switch(null==e&&(e="auto"),s){case"scale_width":t="max",i="min";break;case"scale_height":t="min",i="max";break;case"scale_both":t="max",i="max";break;default:throw new Error("unreachable")}const o={width_policy:t,height_policy:i},{min_width:l,min_height:n}=this.model;null!=l&&(o.min_width=l),null!=n&&(o.min_height=n);const{width:a,height:r}=this.model;null!=a&&(o.width=a),null!=r&&(o.height=r);const{max_width:_,max_height:d}=this.model;null!=_&&(o.max_width=_),null!=d&&(o.max_height=d),"auto"==e&&null!=a&&null!=r?o.aspect=a/r:h.isNumber(e)&&(o.aspect=e);const{margin:u}=this.model;if(null!=u)if(h.isNumber(u))o.margin={top:u,right:u,bottom:u,left:u};else if(2==u.length){const[t,i]=u;o.margin={top:t,right:i,bottom:t,left:i}}else{const[t,i,e,s]=u;o.margin={top:t,right:i,bottom:e,left:s}}o.visible=this.model.visible;const{align:c}=this.model;return h.isArray(c)?[o.halign,o.valign]=c:o.halign=o.valign=c,o}_viewport_size(){return o.undisplayed(this.el,()=>{let t=this.el;for(;t=t.parentElement;){if(t.classList.contains(_.bk_root))continue;if(t==document.body){const{margin:{left:t,right:i,top:e,bottom:s}}=o.extents(document.body);return{width:Math.ceil(document.documentElement.clientWidth-t-i),height:Math.ceil(document.documentElement.clientHeight-e-s)}}const{padding:{left:i,right:e,top:s,bottom:l}}=o.extents(t),{width:h,height:n}=t.getBoundingClientRect(),a=Math.ceil(h-i-e),r=Math.ceil(n-s-l);if(a>0||r>0)return{width:a>0?a:void 0,height:r>0?r:void 0}}return{}})}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box,children:this.child_views.map(t=>t.serializable_state())})}}e.LayoutDOMView=d,d.__name__="LayoutDOMView";class u extends s.Model{constructor(t){super(t)}static init_LayoutDOM(){this.define({width:[n.Number,null],height:[n.Number,null],min_width:[n.Number,null],min_height:[n.Number,null],max_width:[n.Number,null],max_height:[n.Number,null],margin:[n.Any,[0,0,0,0]],width_policy:[n.Any,"auto"],height_policy:[n.Any,"auto"],aspect_ratio:[n.Any,null],sizing_mode:[n.SizingMode,null],visible:[n.Boolean,!0],disabled:[n.Boolean,!1],align:[n.Any,"start"],background:[n.Color,null],css_classes:[n.Array,[]]})}}e.LayoutDOM=u,u.__name__="LayoutDOM",u.init_LayoutDOM()},
function _(t,s,i){const o=t(236),n=t(184),e=t(18);class l extends o.BoxView{_update_layout(){const t=this.child_views.map(t=>t.layout);this.layout=new n.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())}}i.ColumnView=l,l.__name__="ColumnView";class u extends o.Box{constructor(t){super(t)}static init_Column(){this.prototype.default_view=l,this.define({rows:[e.Any,"auto"]})}}i.Column=u,u.__name__="Column",u.init_Column()},
function _(i,t,s){const o=i(237),e=i(184),n=i(18);class l extends o.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,()=>this.rebuild())}get child_models(){return this.model.children.map(([i])=>i)}_update_layout(){this.layout=new e.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;for(const[i,t,s,o,e]of this.model.children){const n=this._child_views[i.id];this.layout.items.push({layout:n.layout,row:t,col:s,row_span:o,col_span:e})}this.layout.set_sizing(this.box_sizing())}}s.GridBoxView=l,l.__name__="GridBoxView";class a extends o.LayoutDOM{constructor(i){super(i)}static init_GridBox(){this.prototype.default_view=l,this.define({children:[n.Array,[]],rows:[n.Any,"auto"],cols:[n.Any,"auto"],spacing:[n.Any,0]})}}s.GridBox=a,a.__name__="GridBox",a.init_GridBox()},
function _(t,e,o){const s=t(237),n=t(180);class _ extends s.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new n.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())}}o.HTMLBoxView=_,_.__name__="HTMLBoxView";class i extends s.LayoutDOM{constructor(t){super(t)}}o.HTMLBox=i,i.__name__="HTMLBox"},
function _(t,s,i){const o=t(236),e=t(184),n=t(18);class a extends o.BoxView{_update_layout(){const t=this.child_views.map(t=>t.layout);this.layout=new e.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())}}i.RowView=a,a.__name__="RowView";class _ extends o.Box{constructor(t){super(t)}static init_Row(){this.prototype.default_view=a,this.define({cols:[n.Any,"auto"]})}}i.Row=_,_.__name__="Row",_.init_Row()},
function _(t,e,a){const i=t(237),s=t(180);class _ extends i.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new s.LayoutItem,this.layout.set_sizing(this.box_sizing())}}a.SpacerView=_,_.__name__="SpacerView";class c extends i.LayoutDOM{constructor(t){super(t)}static init_Spacer(){this.prototype.default_view=_}}a.Spacer=c,c.__name__="Spacer",c.init_Spacer()},
function _(e,t,s){const i=e(180),l=e(61),a=e(8),h=e(18),o=e(237),c=e(64),d=e(138),n=e(244),r=e(245),_=e(246);class b extends o.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.tabs.change,()=>this.rebuild()),this.connect(this.model.properties.active.change,()=>this.on_active_change())}get child_models(){return this.model.tabs.map(e=>e.child)}_update_layout(){const e=this.model.tabs_location,t="above"==e||"below"==e,{scroll_el:s,headers_el:h}=this;this.header=new class extends i.ContentBox{_measure(e){const i=l.size(s),o=l.children(h).slice(0,3).map(e=>l.size(e)),{width:c,height:d}=super._measure(e);if(t){const t=i.width+a.sum(o.map(e=>e.width));return{width:e.width!=1/0?e.width:t,height:d}}{const t=i.height+a.sum(o.map(e=>e.height));return{width:c,height:e.height!=1/0?e.height:t}}}}(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});let o=1,c=1;switch(e){case"above":o-=1;break;case"below":o+=1;break;case"left":c-=1;break;case"right":c+=1}const d={layout:this.header,row:o,col:c},n=this.child_views.map(e=>({layout:e.layout,row:1,col:1}));this.layout=new i.Grid([d,...n]),this.layout.set_sizing(this.box_sizing())}update_position(){super.update_position(),this.header_el.style.position="absolute",l.position(this.header_el,this.header.bbox);const e=this.model.tabs_location,t="above"==e||"below"==e,s=l.size(this.scroll_el),i=l.scroll_size(this.headers_el);if(t){const{width:e}=this.header.bbox;i.width>e?(this.wrapper_el.style.maxWidth=`${e-s.width}px`,l.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",l.undisplay(this.scroll_el))}else{const{height:e}=this.header.bbox;i.height>e?(this.wrapper_el.style.maxHeight=`${e-s.height}px`,l.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",l.undisplay(this.scroll_el))}const{child_views:a}=this;for(const e of a)l.hide(e.el);const h=a[this.model.active];null!=h&&l.show(h.el)}render(){super.render();const{active:e}=this.model,t=this.model.tabs_location,s="above"==t||"below"==t,i=this.model.tabs.map((t,s)=>{const i=l.div({class:[n.bk_tab,s==e?d.bk_active:null]},t.title);if(i.addEventListener("click",e=>{e.target==e.currentTarget&&this.change_active(s)}),t.closable){const e=l.div({class:n.bk_close});e.addEventListener("click",e=>{if(e.target==e.currentTarget){this.model.tabs=a.remove_at(this.model.tabs,s);const e=this.model.tabs.length;this.model.active>e-1&&(this.model.active=e-1)}}),i.appendChild(e)}return i});this.headers_el=l.div({class:[n.bk_headers]},i),this.wrapper_el=l.div({class:n.bk_headers_wrapper},this.headers_el);const h=l.div({class:[r.bk_btn,r.bk_btn_default],disabled:""},l.div({class:[_.bk_caret,d.bk_left]})),o=l.div({class:[r.bk_btn,r.bk_btn_default]},l.div({class:[_.bk_caret,d.bk_right]}));let c=0;const b=e=>()=>{const t=this.model.tabs.length;0==(c="left"==e?Math.max(c-1,0):Math.min(c+1,t-1))?h.setAttribute("disabled",""):h.removeAttribute("disabled"),c==t-1?o.setAttribute("disabled",""):o.removeAttribute("disabled");const i=l.children(this.headers_el).slice(0,c).map(e=>e.getBoundingClientRect());if(s){const e=-a.sum(i.map(e=>e.width));this.headers_el.style.left=`${e}px`}else{const e=-a.sum(i.map(e=>e.height));this.headers_el.style.top=`${e}px`}};h.addEventListener("click",b("left")),o.addEventListener("click",b("right")),this.scroll_el=l.div({class:r.bk_btn_group},h,o),this.header_el=l.div({class:[n.bk_tabs_header,d.bk_side(t)]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)}change_active(e){e!=this.model.active&&(this.model.active=e,null!=this.model.callback&&this.model.callback.execute(this.model))}on_active_change(){const e=this.model.active,t=l.children(this.headers_el);for(const e of t)e.classList.remove(d.bk_active);t[e].classList.add(d.bk_active);const{child_views:s}=this;for(const e of s)l.hide(e.el);l.show(s[e].el)}}s.TabsView=b,b.__name__="TabsView";class p extends o.LayoutDOM{constructor(e){super(e)}static init_Tabs(){this.prototype.default_view=b,this.define({tabs:[h.Array,[]],tabs_location:[h.Location,"above"],active:[h.Number,0],callback:[h.Any]})}}s.Tabs=p,p.__name__="Tabs",p.init_Tabs();class m extends c.Model{constructor(e){super(e)}static init_Panel(){this.define({title:[h.String,""],child:[h.Instance],closable:[h.Boolean,!1]})}}s.Panel=m,m.__name__="Panel",m.init_Panel()},
function _(e,r,n){e(62),e(61).styles.append('.bk-root .bk-tabs-header {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  overflow: hidden;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-tabs-header .bk-btn-group {\n  height: auto;\n  margin-right: 5px;\n}\n.bk-root .bk-tabs-header .bk-btn-group > .bk-btn {\n  flex-grow: 0;\n  -webkit-flex-grow: 0;\n  height: auto;\n  padding: 4px 4px;\n}\n.bk-root .bk-tabs-header .bk-headers-wrapper {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  overflow: hidden;\n  color: #666666;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper {\n  border-bottom: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper {\n  border-left: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper {\n  border-top: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper {\n  border-right: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-above,\n.bk-root .bk-tabs-header.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers,\n.bk-root .bk-tabs-header.bk-below .bk-headers {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-left,\n.bk-root .bk-tabs-header.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers,\n.bk-root .bk-tabs-header.bk-right .bk-headers {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header .bk-headers {\n  position: relative;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n}\n.bk-root .bk-tabs-header .bk-tab {\n  padding: 4px 8px;\n  border: solid transparent;\n  white-space: nowrap;\n  cursor: pointer;\n}\n.bk-root .bk-tabs-header .bk-tab:hover {\n  background-color: #f2f2f2;\n}\n.bk-root .bk-tabs-header .bk-tab.bk-active {\n  color: #4d4d4d;\n  background-color: white;\n  border-color: #e6e6e6;\n}\n.bk-root .bk-tabs-header .bk-tab .bk-close {\n  margin-left: 10px;\n}\n.bk-root .bk-tabs-header.bk-above .bk-tab {\n  border-width: 3px 1px 0px 1px;\n  border-radius: 4px 4px 0 0;\n}\n.bk-root .bk-tabs-header.bk-right .bk-tab {\n  border-width: 1px 3px 1px 0px;\n  border-radius: 0 4px 4px 0;\n}\n.bk-root .bk-tabs-header.bk-below .bk-tab {\n  border-width: 0px 1px 3px 1px;\n  border-radius: 0 0 4px 4px;\n}\n.bk-root .bk-tabs-header.bk-left .bk-tab {\n  border-width: 1px 0px 1px 3px;\n  border-radius: 4px 0 0 4px;\n}\n.bk-root .bk-close {\n  display: inline-block;\n  width: 10px;\n  height: 10px;\n  vertical-align: middle;\n  background-image: url(\'data:image/svg+xml;utf8,\\\n      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">\\\n        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>\\\n        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>\\\n      </svg>\');\n}\n.bk-root .bk-close:hover {\n  background-image: url(\'data:image/svg+xml;utf8,\\\n      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">\\\n        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>\\\n        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>\\\n      </svg>\');\n}\n'),n.bk_tabs_header="bk-tabs-header",n.bk_headers_wrapper="bk-headers-wrapper",n.bk_headers="bk-headers",n.bk_tab="bk-tab",n.bk_close="bk-close"},
function _(n,b,o){n(62),n(61).styles.append(".bk-root .bk-btn {\n  height: 100%;\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  white-space: nowrap;\n  cursor: pointer;\n  padding: 6px 12px;\n  font-size: 12px;\n  border: 1px solid transparent;\n  border-radius: 4px;\n  outline: 0;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-btn:hover,\n.bk-root .bk-btn:focus {\n  text-decoration: none;\n}\n.bk-root .bk-btn:active,\n.bk-root .bk-btn.bk-active {\n  background-image: none;\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.bk-root .bk-btn[disabled] {\n  cursor: not-allowed;\n  pointer-events: none;\n  opacity: 0.65;\n  box-shadow: none;\n}\n.bk-root .bk-btn-default {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-default:hover {\n  background-color: #f5f5f5;\n  border-color: #b8b8b8;\n}\n.bk-root .bk-btn-default.bk-active {\n  background-color: #ebebeb;\n  border-color: #adadad;\n}\n.bk-root .bk-btn-default[disabled],\n.bk-root .bk-btn-default[disabled]:hover,\n.bk-root .bk-btn-default[disabled]:focus,\n.bk-root .bk-btn-default[disabled]:active,\n.bk-root .bk-btn-default[disabled].bk-active {\n  background-color: #e6e6e6;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-primary {\n  color: #fff;\n  background-color: #428bca;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-primary:hover {\n  background-color: #3681c1;\n  border-color: #2c699e;\n}\n.bk-root .bk-btn-primary.bk-active {\n  background-color: #3276b1;\n  border-color: #285e8e;\n}\n.bk-root .bk-btn-primary[disabled],\n.bk-root .bk-btn-primary[disabled]:hover,\n.bk-root .bk-btn-primary[disabled]:focus,\n.bk-root .bk-btn-primary[disabled]:active,\n.bk-root .bk-btn-primary[disabled].bk-active {\n  background-color: #506f89;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-success:hover {\n  background-color: #4eb24e;\n  border-color: #409240;\n}\n.bk-root .bk-btn-success.bk-active {\n  background-color: #47a447;\n  border-color: #398439;\n}\n.bk-root .bk-btn-success[disabled],\n.bk-root .bk-btn-success[disabled]:hover,\n.bk-root .bk-btn-success[disabled]:focus,\n.bk-root .bk-btn-success[disabled]:active,\n.bk-root .bk-btn-success[disabled].bk-active {\n  background-color: #667b66;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-warning:hover {\n  background-color: #eea43b;\n  border-color: #e89014;\n}\n.bk-root .bk-btn-warning.bk-active {\n  background-color: #ed9c28;\n  border-color: #d58512;\n}\n.bk-root .bk-btn-warning[disabled],\n.bk-root .bk-btn-warning[disabled]:hover,\n.bk-root .bk-btn-warning[disabled]:focus,\n.bk-root .bk-btn-warning[disabled]:active,\n.bk-root .bk-btn-warning[disabled].bk-active {\n  background-color: #c89143;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-danger:hover {\n  background-color: #d5433e;\n  border-color: #bd2d29;\n}\n.bk-root .bk-btn-danger.bk-active {\n  background-color: #d2322d;\n  border-color: #ac2925;\n}\n.bk-root .bk-btn-danger[disabled],\n.bk-root .bk-btn-danger[disabled]:hover,\n.bk-root .bk-btn-danger[disabled]:focus,\n.bk-root .bk-btn-danger[disabled]:active,\n.bk-root .bk-btn-danger[disabled].bk-active {\n  background-color: #a55350;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-group {\n  height: 100%;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-btn-group > .bk-btn {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n}\n.bk-root .bk-btn-group > .bk-btn + .bk-btn {\n  margin-left: -1px;\n}\n.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child) {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.bk-root .bk-btn-group .bk-dropdown-toggle {\n  flex: 0 0 0;\n  -webkit-flex: 0 0 0;\n  padding: 6px 6px;\n}\n"),o.bk_btn="bk-btn",o.bk_btn_group="bk-btn-group",o.bk_btn_default="bk-btn-default",o.bk_btn_primary="bk-btn-primary",o.bk_btn_success="bk-btn-success",o.bk_btn_warning="bk-btn-warning",o.bk_btn_danger="bk-btn-danger",o.bk_btn_type=function(n){switch(n){case"default":return o.bk_btn_default;case"primary":return o.bk_btn_primary;case"success":return o.bk_btn_success;case"warning":return o.bk_btn_warning;case"danger":return o.bk_btn_danger}},o.bk_dropdown_toggle="bk-dropdown-toggle"},
function _(n,o,r){n(62),n(61).styles.append(".bk-root .bk-menu {\n  position: absolute;\n  left: 0;\n  width: 100%;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-menu.bk-above {\n  bottom: 100%;\n}\n.bk-root .bk-menu.bk-below {\n  top: 100%;\n}\n.bk-root .bk-menu > .bk-divider {\n  height: 1px;\n  margin: 7.5px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-menu > :not(.bk-divider) {\n  padding: 6px 12px;\n}\n.bk-root .bk-menu > :not(.bk-divider):hover,\n.bk-root .bk-menu > :not(.bk-divider).bk-active {\n  background-color: #e6e6e6;\n}\n.bk-root .bk-caret {\n  display: inline-block;\n  vertical-align: middle;\n  width: 0;\n  height: 0;\n  margin: 0 5px;\n}\n.bk-root .bk-caret.bk-down {\n  border-top: 4px solid;\n}\n.bk-root .bk-caret.bk-up {\n  border-bottom: 4px solid;\n}\n.bk-root .bk-caret.bk-down,\n.bk-root .bk-caret.bk-up {\n  border-right: 4px solid transparent;\n  border-left: 4px solid transparent;\n}\n.bk-root .bk-caret.bk-left {\n  border-right: 4px solid;\n}\n.bk-root .bk-caret.bk-right {\n  border-left: 4px solid;\n}\n.bk-root .bk-caret.bk-left,\n.bk-root .bk-caret.bk-right {\n  border-top: 4px solid transparent;\n  border-bottom: 4px solid transparent;\n}\n"),r.bk_menu="bk-menu",r.bk_caret="bk-caret",r.bk_divider="bk-divider"},
function _(t,e,i){const o=t(238);class n extends o.ColumnView{}i.WidgetBoxView=n,n.__name__="WidgetBoxView";class _ extends o.Column{constructor(t){super(t)}static init_WidgetBox(){this.prototype.default_view=n}}i.WidgetBox=_,_.__name__="WidgetBox",_.init_WidgetBox()},
function _(r,a,o){var p=r(249);o.CategoricalColorMapper=p.CategoricalColorMapper;var e=r(251);o.CategoricalMarkerMapper=e.CategoricalMarkerMapper;var C=r(252);o.CategoricalPatternMapper=C.CategoricalPatternMapper;var l=r(109);o.ContinuousColorMapper=l.ContinuousColorMapper;var M=r(110);o.ColorMapper=M.ColorMapper;var t=r(108);o.LinearColorMapper=t.LinearColorMapper;var i=r(253);o.LogColorMapper=i.LogColorMapper},
function _(r,t,o){const a=r(250),e=r(110),c=r(18);class i extends e.ColorMapper{constructor(r){super(r)}static init_CategoricalColorMapper(){this.define({factors:[c.Array],start:[c.Number,0],end:[c.Number]})}_v_compute(r,t,o,{nan_color:e}){a.cat_v_compute(r,this.factors,o,t,this.start,this.end,e)}}o.CategoricalColorMapper=i,i.__name__="CategoricalColorMapper",i.init_CategoricalColorMapper()},
function _(n,e,t){const l=n(11),i=n(7);function u(n,e){if(n.length!=e.length)return!1;for(let t=0,l=n.length;t<l;t++)if(n[t]!==e[t])return!1;return!0}t._cat_equals=u,t.cat_v_compute=function(n,e,t,c,f,o,r){for(let _=0,g=n.length;_<g;_++){let g,h,s=n[_];i.isString(s)?g=l.index_of(e,s):(null!=f?s=null!=o?s.slice(f,o):s.slice(f):null!=o&&(s=s.slice(0,o)),g=1==s.length?l.index_of(e,s[0]):l.find_index(e,n=>u(n,s))),h=g<0||g>=t.length?r:t[g],c[_]=h}}},
function _(r,e,a){const t=r(250),s=r(111),c=r(18);class i extends s.Mapper{constructor(r){super(r)}static init_CategoricalMarkerMapper(){this.define({factors:[c.Array],markers:[c.Array],start:[c.Number,0],end:[c.Number],default_value:[c.MarkerType,"circle"]})}v_compute(r){const e=new Array(r.length);return t.cat_v_compute(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e}}a.CategoricalMarkerMapper=i,i.__name__="CategoricalMarkerMapper",i.init_CategoricalMarkerMapper()},
function _(t,a,e){const r=t(250),n=t(111),s=t(18);class c extends n.Mapper{constructor(t){super(t)}static init_CategoricalPatternMapper(){this.define({factors:[s.Array],patterns:[s.Array],start:[s.Number,0],end:[s.Number],default_value:[s.HatchPatternType," "]})}v_compute(t){const a=new Array(t.length);return r.cat_v_compute(t,this.factors,this.patterns,a,this.start,this.end,this.default_value),a}}e.CategoricalPatternMapper=c,c.__name__="CategoricalPatternMapper",c.init_CategoricalPatternMapper()},
function _(o,n,l){const t=o(109),i=o(11),e=null!=Math.log1p?Math.log1p:o=>Math.log(1+o);class h extends t.ContinuousColorMapper{constructor(o){super(o)}_v_compute(o,n,l,t){const{nan_color:h,low_color:c,high_color:s}=t,u=l.length,r=null!=this.low?this.low:i.min(o),a=null!=this.high?this.high:i.max(o),g=u/(e(a)-e(r)),p=l.length-1;for(let t=0,i=o.length;t<i;t++){const i=o[t];if(isNaN(i)){n[t]=h;continue}if(i>a){n[t]=null!=s?s:l[p];continue}if(i==a){n[t]=l[p];continue}if(i<r){n[t]=null!=c?c:l[0];continue}const u=e(i)-e(r);let _=Math.floor(u*g);_>p&&(_=p),n[t]=l[_]}}}l.LogColorMapper=h,h.__name__="LogColorMapper"},
function _(r,a,t){!function(r){for(var a in r)t.hasOwnProperty(a)||(t[a]=r[a])}(r(255));var n=r(256);t.Marker=n.Marker;var e=r(257);t.Scatter=e.Scatter},
function _(e,t,o){const i=e(256),s=Math.sqrt(3);function r(e,t){e.moveTo(-t,t),e.lineTo(t,-t),e.moveTo(-t,-t),e.lineTo(t,t)}function n(e,t){e.moveTo(0,t),e.lineTo(0,-t),e.moveTo(-t,0),e.lineTo(t,0)}function c(e,t){e.moveTo(0,t),e.lineTo(t/1.5,0),e.lineTo(0,-t),e.lineTo(-t/1.5,0),e.closePath()}function l(e,t){const o=t*s,i=o/3;e.moveTo(-t,i),e.lineTo(t,i),e.lineTo(0,i-o),e.closePath()}function a(e,t,o,i,s){const c=.65*o;n(e,o),r(e,c),i.doit&&(i.set_vectorize(e,t),e.stroke())}function d(e,t,o,i,s){e.arc(0,0,o,0,2*Math.PI,!1),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),n(e,o),e.stroke())}function _(e,t,o,i,s){e.arc(0,0,o,0,2*Math.PI,!1),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),r(e,o),e.stroke())}function v(e,t,o,i,s){n(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function f(e,t,o,i,s){c(e,o),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function u(e,t,o,i,s){c(e,o),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),n(e,o),e.stroke())}function T(e,t,o,i,r){!function(e,t){const o=t/2,i=s*o;e.moveTo(t,0),e.lineTo(o,-i),e.lineTo(-o,-i),e.lineTo(-t,0),e.lineTo(-o,i),e.lineTo(o,i),e.closePath()}(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function z(e,t,o,i,s){e.rotate(Math.PI),l(e,o),e.rotate(-Math.PI),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function k(e,t,o,i,s){const r=2*o;e.rect(-o,-o,r,r),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function m(e,t,o,i,s){const r=2*o;e.rect(-o,-o,r,r),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),n(e,o),e.stroke())}function C(e,t,o,i,s){const n=2*o;e.rect(-o,-o,n,n),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),r(e,o),e.stroke())}function h(e,t,o,i,s){l(e,o),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function q(e,t,o,i,s){!function(e,t){e.moveTo(-t,0),e.lineTo(t,0)}(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function x(e,t,o,i,s){r(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function M(e,t){var o;const s=class extends i.MarkerView{static initClass(){this.prototype._render_one=t}};s.initClass();const r=((o=class extends i.Marker{static initClass(){this.prototype.default_view=s}}).__name__=e,o);return r.initClass(),r}o.Asterisk=M("Asterisk",a),o.CircleCross=M("CircleCross",d),o.CircleX=M("CircleX",_),o.Cross=M("Cross",v),o.Dash=M("Dash",q),o.Diamond=M("Diamond",f),o.DiamondCross=M("DiamondCross",u),o.Hex=M("Hex",T),o.InvertedTriangle=M("InvertedTriangle",z),o.Square=M("Square",k),o.SquareCross=M("SquareCross",m),o.SquareX=M("SquareX",C),o.Triangle=M("Triangle",h),o.X=M("X",x),o.marker_funcs={asterisk:a,circle:function(e,t,o,i,s){e.arc(0,0,o,0,2*Math.PI,!1),s.doit&&(s.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())},circle_cross:d,circle_x:_,cross:v,diamond:f,diamond_cross:u,hex:T,inverted_triangle:z,square:k,square_cross:m,square_x:C,triangle:h,dash:q,x:x}},
function _(e,s,t){const i=e(76),r=e(81),n=e(18),a=e(8);class _ extends i.XYGlyphView{_render(e,s,{sx:t,sy:i,_size:r,_angle:n}){for(const a of s){if(isNaN(t[a]+i[a]+r[a]+n[a]))continue;const s=r[a]/2;e.beginPath(),e.translate(t[a],i[a]),n[a]&&e.rotate(n[a]),this._render_one(e,a,s,this.visuals.line,this.visuals.fill),n[a]&&e.rotate(-n[a]),e.translate(-t[a],-i[a])}}_mask_data(){const e=this.renderer.plot_view.frame.bbox.h_range,s=e.start-this.max_size,t=e.end+this.max_size,[i,r]=this.renderer.xscale.r_invert(s,t),n=this.renderer.plot_view.frame.bbox.v_range,a=n.start-this.max_size,_=n.end+this.max_size,[h,c]=this.renderer.yscale.r_invert(a,_);return this.index.indices({x0:i,x1:r,y0:h,y1:c})}_hit_point(e){const{sx:s,sy:t}=e,i=s-this.max_size,n=s+this.max_size,[a,_]=this.renderer.xscale.r_invert(i,n),h=t-this.max_size,c=t+this.max_size,[x,o]=this.renderer.yscale.r_invert(h,c),l=this.index.indices({x0:a,x1:_,y0:x,y1:o}),y=[];for(const e of l){const i=this._size[e]/2,r=Math.abs(this.sx[e]-s)+Math.abs(this.sy[e]-t);Math.abs(this.sx[e]-s)<=i&&Math.abs(this.sy[e]-t)<=i&&y.push([e,r])}return r.create_hit_test_result_from_hits(y)}_hit_span(e){const{sx:s,sy:t}=e,i=this.bounds(),n=this.max_size/2,a=r.create_empty_hit_test_result();let _,h,c,x;if("h"==e.direction){c=i.y0,x=i.y1;const e=s-n,t=s+n;[_,h]=this.renderer.xscale.r_invert(e,t)}else{_=i.x0,h=i.x1;const e=t-n,s=t+n;[c,x]=this.renderer.yscale.r_invert(e,s)}const o=this.index.indices({x0:_,x1:h,y0:c,y1:x});return a.indices=o,a}_hit_rect(e){const{sx0:s,sx1:t,sy0:i,sy1:n}=e,[a,_]=this.renderer.xscale.r_invert(s,t),[h,c]=this.renderer.yscale.r_invert(i,n),x=r.create_empty_hit_test_result();return x.indices=this.index.indices({x0:a,x1:_,y0:h,y1:c}),x}_hit_poly(e){const{sx:s,sy:t}=e,i=a.range(0,this.sx.length),n=[];for(let e=0,a=i.length;e<a;e++){const a=i[e];r.point_in_poly(this.sx[e],this.sy[e],s,t)&&n.push(a)}const _=r.create_empty_hit_test_result();return _.indices=n,_}draw_legend_for_index(e,{x0:s,x1:t,y0:i,y1:r},n){const a=n+1,_=new Array(a);_[n]=(s+t)/2;const h=new Array(a);h[n]=(i+r)/2;const c=new Array(a);c[n]=.4*Math.min(Math.abs(t-s),Math.abs(r-i));const x=new Array(a);x[n]=0,this._render(e,[n],{sx:_,sy:h,_size:c,_angle:x})}}t.MarkerView=_,_.__name__="MarkerView";class h extends i.XYGlyph{constructor(e){super(e)}static init_Marker(){this.mixins(["line","fill"]),this.define({size:[n.DistanceSpec,{units:"screen",value:4}],angle:[n.AngleSpec,0]})}}t.Marker=h,h.__name__="Marker",h.init_Marker()},
function _(e,t,r){const a=e(256),s=e(255),n=e(18);class i extends a.MarkerView{_render(e,t,{sx:r,sy:a,_size:n,_angle:i,_marker:c}){for(const _ of t){if(isNaN(r[_]+a[_]+n[_]+i[_])||null==c[_])continue;const t=n[_]/2;e.beginPath(),e.translate(r[_],a[_]),i[_]&&e.rotate(i[_]),s.marker_funcs[c[_]](e,_,t,this.visuals.line,this.visuals.fill),i[_]&&e.rotate(-i[_]),e.translate(-r[_],-a[_])}}draw_legend_for_index(e,{x0:t,x1:r,y0:a,y1:s},n){const i=n+1,c=new Array(i);c[n]=(t+r)/2;const _=new Array(i);_[n]=(a+s)/2;const o=new Array(i);o[n]=.4*Math.min(Math.abs(r-t),Math.abs(s-a));const l=new Array(i);l[n]=0;const h=new Array(i);h[n]=this._marker[n],this._render(e,[n],{sx:c,sy:_,_size:o,_angle:l,_marker:h})}}r.ScatterView=i,i.__name__="ScatterView";class c extends a.Marker{constructor(e){super(e)}static init_Scatter(){this.prototype.default_view=i,this.define({marker:[n.MarkerSpec,{value:"circle"}]})}}r.Scatter=c,c.__name__="Scatter",c.init_Scatter()},
function _(a,p,o){var t=a(259);o.MapOptions=t.MapOptions;var n=a(259);o.GMapOptions=n.GMapOptions;var M=a(259);o.GMapPlot=M.GMapPlot;var i=a(260);o.Plot=i.Plot},
function _(t,i,e){const o=t(65),n=t(260),a=t(18),s=t(64),p=t(123),r=t(280);e.GMapPlotView=r.GMapPlotView;class _ extends s.Model{constructor(t){super(t)}static init_MapOptions(){this.define({lat:[a.Number],lng:[a.Number],zoom:[a.Number,12]})}}e.MapOptions=_,_.__name__="MapOptions",_.init_MapOptions();class l extends _{constructor(t){super(t)}static init_GMapOptions(){this.define({map_type:[a.String,"roadmap"],scale_control:[a.Boolean,!1],styles:[a.String],tilt:[a.Int,45]})}}e.GMapOptions=l,l.__name__="GMapOptions",l.init_GMapOptions();class c extends n.Plot{constructor(t){super(t)}static init_GMapPlot(){this.prototype.default_view=r.GMapPlotView,this.define({map_options:[a.Instance],api_key:[a.String]}),this.override({x_range:()=>new p.Range1d,y_range:()=>new p.Range1d})}initialize(){super.initialize(),this.use_map=!0,this.api_key||o.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")}}e.GMapPlot=c,c.__name__="GMapPlot",c.init_GMapPlot()},
function _(e,t,r){const n=e(18),o=e(13),i=e(8),a=e(22),l=e(7),s=e(237),_=e(134),h=e(113),c=e(261),u=e(68),d=e(73),b=e(178),g=e(273);r.PlotView=g.PlotView;class m extends s.LayoutDOM{constructor(e){super(e)}static init_Plot(){this.prototype.default_view=g.PlotView,this.mixins(["line:outline_","fill:background_","fill:border_"]),this.define({toolbar:[n.Instance,()=>new c.Toolbar],toolbar_location:[n.Location,"right"],toolbar_sticky:[n.Boolean,!0],plot_width:[n.Number,600],plot_height:[n.Number,600],frame_width:[n.Number,null],frame_height:[n.Number,null],title:[n.Any,()=>new _.Title({text:""})],title_location:[n.Location,"above"],above:[n.Array,[]],below:[n.Array,[]],left:[n.Array,[]],right:[n.Array,[]],center:[n.Array,[]],renderers:[n.Array,[]],x_range:[n.Instance,()=>new b.DataRange1d],extra_x_ranges:[n.Any,{}],y_range:[n.Instance,()=>new b.DataRange1d],extra_y_ranges:[n.Any,{}],x_scale:[n.Instance,()=>new h.LinearScale],y_scale:[n.Instance,()=>new h.LinearScale],lod_factor:[n.Number,10],lod_interval:[n.Number,300],lod_threshold:[n.Number,2e3],lod_timeout:[n.Number,500],hidpi:[n.Boolean,!0],output_backend:[n.OutputBackend,"canvas"],min_border:[n.Number,5],min_border_top:[n.Number,null],min_border_left:[n.Number,null],min_border_bottom:[n.Number,null],min_border_right:[n.Number,null],inner_width:[n.Number],inner_height:[n.Number],outer_width:[n.Number],outer_height:[n.Number],match_aspect:[n.Boolean,!1],aspect_scale:[n.Number,1],reset_policy:[n.ResetPolicy,"standard"]}),this.override({outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})}get width(){const e=this.getv("width");return null!=e?e:this.plot_width}get height(){const e=this.getv("height");return null!=e?e:this.plot_height}_doc_attached(){super._doc_attached(),this._tell_document_about_change("inner_height",null,this.inner_height,{}),this._tell_document_about_change("inner_width",null,this.inner_width,{})}initialize(){super.initialize(),this.reset=new o.Signal0(this,"reset");for(const e of a.values(this.extra_x_ranges).concat(this.x_range)){let t=e.plots;l.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}for(const e of a.values(this.extra_y_ranges).concat(this.y_range)){let t=e.plots;l.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}}add_layout(e,t="center"){this.getv(t).push(e)}remove_layout(e){const t=t=>{i.remove_by(t,t=>t==e)};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)}add_renderers(...e){this.renderers=this.renderers.concat(e)}add_glyph(e,t=new u.ColumnDataSource,r={}){const n=Object.assign(Object.assign({},r),{data_source:t,glyph:e}),o=new d.GlyphRenderer(n);return this.add_renderers(o),o}add_tools(...e){this.toolbar.tools=this.toolbar.tools.concat(e)}get panels(){return this.side_panels.concat(this.center)}get side_panels(){const{above:e,below:t,left:r,right:n}=this;return i.concat([e,t,r,n])}}r.Plot=m,m.__name__="Plot",m.init_Plot()},
function _(t,s,i){const e=t(18),c=t(7),n=t(8),o=t(262),a=t(267),l=t=>{switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null},r=t=>"tap"==t||"pan"==t;class _ extends a.ToolbarBase{constructor(t){super(t)}static init_Toolbar(){this.prototype.default_view=a.ToolbarBaseView,this.define({active_drag:[e.Any,"auto"],active_inspect:[e.Any,"auto"],active_scroll:[e.Any,"auto"],active_tap:[e.Any,"auto"],active_multi:[e.Any,null]})}connect_signals(){super.connect_signals(),this.connect(this.properties.tools.change,()=>this._init_tools())}_init_tools(){if(super._init_tools(),"auto"==this.active_inspect);else if(this.active_inspect instanceof o.InspectTool){let t=!1;for(const s of this.inspectors)s!=this.active_inspect?s.active=!1:t=!0;t||(this.active_inspect=null)}else if(c.isArray(this.active_inspect)){const t=n.intersection(this.active_inspect,this.inspectors);t.length!=this.active_inspect.length&&(this.active_inspect=t);for(const t of this.inspectors)n.includes(this.active_inspect,t)||(t.active=!1)}else if(null==this.active_inspect)for(const t of this.inspectors)t.active=!1;const t=t=>{t.active?this._active_change(t):t.active=!0};for(const t in this.gestures){const s=this.gestures[t];s.tools=n.sort_by(s.tools,t=>t.default_order);for(const t of s.tools)this.connect(t.properties.active.change,this._active_change.bind(this,t))}for(const s in this.gestures){const i=l(s);if(i){const e=this[i];if("auto"==e){const i=this.gestures[s];0!=i.tools.length&&r(s)&&t(i.tools[0])}else null!=e&&(n.includes(this.tools,e)?t(e):this[i]=null)}}}}i.Toolbar=_,_.__name__="Toolbar",_.init_Toolbar()},
function _(t,e,o){const n=t(263),s=t(266),i=t(18);class c extends n.ButtonToolView{}o.InspectToolView=c,c.__name__="InspectToolView";class l extends n.ButtonTool{constructor(t){super(t),this.event_type="move"}static init_InspectTool(){this.prototype.button_view=s.OnOffButtonView,this.define({toggleable:[i.Boolean,!0]}),this.override({active:!0})}}o.InspectTool=l,l.__name__="InspectTool",l.init_InspectTool()},
function _(t,e,o){const i=t(59),s=t(264),n=t(61),l=t(18),c=t(25),a=t(7),r=t(265);class u extends i.DOMView{initialize(){super.initialize(),this.connect(this.model.change,()=>this.render()),this.el.addEventListener("click",()=>this._clicked()),this.render()}css_classes(){return super.css_classes().concat(r.bk_toolbar_button)}render(){n.empty(this.el);const t=this.model.computed_icon;a.isString(t)&&(c.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip}}o.ButtonToolButtonView=u,u.__name__="ButtonToolButtonView";class _ extends s.ToolView{}o.ButtonToolView=_,_.__name__="ButtonToolView";class d extends s.Tool{constructor(t){super(t)}static init_ButtonTool(){this.internal({disabled:[l.Boolean,!1]})}get tooltip(){return this.tool_name}get computed_icon(){return this.icon}}o.ButtonTool=d,d.__name__="ButtonTool",d.init_ButtonTool()},
function _(t,e,i){const n=t(18),s=t(60),a=t(8),o=t(64);class r extends s.View{get plot_view(){return this.parent}get plot_model(){return this.parent.model}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>{this.model.active?this.activate():this.deactivate()})}activate(){}deactivate(){}}i.ToolView=r,r.__name__="ToolView";class c extends o.Model{constructor(t){super(t)}static init_Tool(){this.internal({active:[n.Boolean,!1]})}get synthetic_renderers(){return[]}_get_dim_tooltip(t,e){switch(e){case"width":return`${t} (x-axis)`;case"height":return`${t} (y-axis)`;case"both":return t}}_get_dim_limits([t,e],[i,n],s,o){const r=s.bbox.h_range;let c;"width"==o||"both"==o?(c=[a.min([t,i]),a.max([t,i])],c=[a.max([c[0],r.start]),a.min([c[1],r.end])]):c=[r.start,r.end];const _=s.bbox.v_range;let l;return"height"==o||"both"==o?(l=[a.min([e,n]),a.max([e,n])],l=[a.max([l[0],_.start]),a.min([l[1],_.end])]):l=[_.start,_.end],[c,l]}}i.Tool=c,c.__name__="Tool",c.init_Tool()},
function _(o,b,t){o(62),o(61).styles.append('.bk-root .bk-toolbar-hidden {\n  visibility: hidden;\n  opacity: 0;\n  transition: visibility 0.3s linear, opacity 0.3s linear;\n}\n.bk-root .bk-toolbar,\n.bk-root .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-toolbar .bk-logo {\n  flex-shrink: 0;\n  -webkit-flex-shrink: 0;\n}\n.bk-root .bk-toolbar.bk-above,\n.bk-root .bk-toolbar.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n  justify-content: flex-end;\n  -webkit-justify-content: flex-end;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar,\n.bk-root .bk-toolbar.bk-below .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-toolbar.bk-above .bk-logo,\n.bk-root .bk-toolbar.bk-below .bk-logo {\n  order: 1;\n  -webkit-order: 1;\n  margin-left: 5px;\n  margin-right: 0px;\n}\n.bk-root .bk-toolbar.bk-left,\n.bk-root .bk-toolbar.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  justify-content: flex-start;\n  -webkit-justify-content: flex-start;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar,\n.bk-root .bk-toolbar.bk-right .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-toolbar.bk-left .bk-logo,\n.bk-root .bk-toolbar.bk-right .bk-logo {\n  order: 0;\n  -webkit-order: 0;\n  margin-bottom: 5px;\n  margin-top: 0px;\n}\n.bk-root .bk-toolbar-button {\n  width: 30px;\n  height: 30px;\n  background-size: 60%;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-toolbar-button:hover {\n  background-color: #f9f9f9;\n}\n.bk-root .bk-toolbar-button:focus {\n  outline: none;\n}\n.bk-root .bk-toolbar-button::-moz-focus-inner {\n  border: 0;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button {\n  border-bottom: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active {\n  border-bottom-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button {\n  border-top: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active {\n  border-top-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button {\n  border-left: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active {\n  border-left-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button {\n  border-right: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active {\n  border-right-color: #26aae1;\n}\n.bk-root .bk-button-bar + .bk-button-bar:before {\n  content: " ";\n  display: inline-block;\n  background-color: lightgray;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before {\n  height: 10px;\n  width: 1px;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before {\n  height: 1px;\n  width: 10px;\n}\n'),t.bk_toolbar="bk-toolbar",t.bk_toolbar_hidden="bk-toolbar-hidden",t.bk_toolbar_button="bk-toolbar-button",t.bk_button_bar="bk-button-bar",t.bk_toolbar_button_custom_action="bk-toolbar-button-custom-action"},
function _(e,t,i){const s=e(263),n=e(138);class c extends s.ButtonToolButtonView{render(){super.render(),this.model.active?this.el.classList.add(n.bk_active):this.el.classList.remove(n.bk_active)}_clicked(){const e=this.model.active;this.model.active=!e}}i.OnOffButtonView=c,c.__name__="OnOffButtonView"},
function _(t,o,e){const i=t(65),s=t(61),l=t(92),n=t(18),a=t(59),r=t(8),_=t(14),c=t(7),h=t(64),u=t(268),d=t(269),v=t(270),p=t(262),b=t(265),g=t(272),m=t(138);class f extends h.Model{constructor(t){super(t)}static init_ToolbarViewModel(){this.define({_visible:[n.Any,null],autohide:[n.Boolean,!1]})}get visible(){return!this.autohide||null!=this._visible&&this._visible}}e.ToolbarViewModel=f,f.__name__="ToolbarViewModel",f.init_ToolbarViewModel();class w extends a.DOMView{initialize(){super.initialize(),this._tool_button_views={},this._build_tool_button_views(),this._toolbar_view_model=new f({autohide:this.model.autohide})}connect_signals(){super.connect_signals(),this.connect(this.model.properties.tools.change,()=>{this._build_tool_button_views(),this.render()}),this.connect(this.model.properties.autohide.change,()=>{this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change()}),this.connect(this._toolbar_view_model.properties._visible.change,()=>this._on_visible_change())}remove(){l.remove_views(this._tool_button_views),super.remove()}_build_tool_button_views(){const t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools;l.build_views(this._tool_button_views,t,{parent:this},t=>t.button_view)}set_visibility(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)}_on_visible_change(){const t=this._toolbar_view_model.visible,o=b.bk_toolbar_hidden;this.el.classList.contains(o)&&t?this.el.classList.remove(o):t||this.el.classList.add(o)}render(){if(s.empty(this.el),this.el.classList.add(b.bk_toolbar),this.el.classList.add(m.bk_side(this.model.toolbar_location)),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){const t="grey"===this.model.logo?g.bk_grey:null,o=s.a({href:"https://bokeh.org/",target:"_blank",class:[g.bk_logo,g.bk_logo_small,t]});this.el.appendChild(o)}const t=[],o=t=>this._tool_button_views[t.id].el,{gestures:e}=this.model;for(const i in e)t.push(e[i].tools.map(o));t.push(this.model.actions.map(o)),t.push(this.model.inspectors.filter(t=>t.toggleable).map(o)),t.push(this.model.help.map(o));for(const o of t)if(0!==o.length){const t=s.div({class:b.bk_button_bar},o);this.el.appendChild(t)}}update_layout(){}update_position(){}after_layout(){this._has_finished=!0}}function y(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}e.ToolbarBaseView=w,w.__name__="ToolbarBaseView";class T extends h.Model{constructor(t){super(t)}static init_ToolbarBase(){this.prototype.default_view=w,this.define({tools:[n.Array,[]],logo:[n.Logo,"normal"],autohide:[n.Boolean,!1]}),this.internal({gestures:[n.Any,y],actions:[n.Array,[]],inspectors:[n.Array,[]],help:[n.Array,[]],toolbar_location:[n.Location,"right"]})}initialize(){super.initialize(),this._init_tools()}_init_tools(){const t=function(t,o){if(t.length!=o.length)return!0;const e=new _.Set(o.map(t=>t.id));return r.some(t,t=>!e.has(t.id))},o=this.tools.filter(t=>t instanceof p.InspectTool);t(this.inspectors,o)&&(this.inspectors=o);const e=this.tools.filter(t=>t instanceof v.HelpTool);t(this.help,e)&&(this.help=e);const s=this.tools.filter(t=>t instanceof d.ActionTool);t(this.actions,s)&&(this.actions=s);const l=(t,o)=>{t in this.gestures||i.logger.warn(`Toolbar: unknown event type '${t}' for tool: ${o.type} (${o.id})`)},n={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};for(const t of this.tools)if(t instanceof u.GestureTool&&t.event_type)if(c.isString(t.event_type))n[t.event_type].tools.push(t),l(t.event_type,t);else{n.multi.tools.push(t);for(const o of t.event_type)l(o,t)}for(const o of Object.keys(n)){const e=this.gestures[o];t(e.tools,n[o].tools)&&(e.tools=n[o].tools),e.active&&r.every(e.tools,t=>t.id!=e.active.id)&&(e.active=null)}}get horizontal(){return"above"===this.toolbar_location||"below"===this.toolbar_location}get vertical(){return"left"===this.toolbar_location||"right"===this.toolbar_location}_active_change(t){const{event_type:o}=t;if(null==o)return;const e=c.isString(o)?[o]:o;for(const o of e)if(t.active){const e=this.gestures[o].active;null!=e&&t!=e&&(i.logger.debug(`Toolbar: deactivating tool: ${e.type} (${e.id}) for event type '${o}'`),e.active=!1),this.gestures[o].active=t,i.logger.debug(`Toolbar: activating tool: ${t.type} (${t.id}) for event type '${o}'`)}else this.gestures[o].active=null}}e.ToolbarBase=T,T.__name__="ToolbarBase",T.init_ToolbarBase()},
function _(e,o,t){const s=e(263),n=e(266);class u extends s.ButtonToolView{}t.GestureToolView=u,u.__name__="GestureToolView";class _ extends s.ButtonTool{constructor(e){super(e),this.button_view=n.OnOffButtonView}}t.GestureTool=_,_.__name__="GestureTool"},
function _(o,t,n){const i=o(263),e=o(13);class s extends i.ButtonToolButtonView{_clicked(){this.model.do.emit()}}n.ActionToolButtonView=s,s.__name__="ActionToolButtonView";class c extends i.ButtonToolView{connect_signals(){super.connect_signals(),this.connect(this.model.do,()=>this.doit())}}n.ActionToolView=c,c.__name__="ActionToolView";class l extends i.ButtonTool{constructor(o){super(o),this.button_view=s,this.do=new e.Signal0(this,"do")}}n.ActionTool=l,l.__name__="ActionTool"},
function _(o,t,e){const l=o(269),i=o(18),n=o(271);class s extends l.ActionToolView{doit(){window.open(this.model.redirect)}}e.HelpToolView=s,s.__name__="HelpToolView";class p extends l.ActionTool{constructor(o){super(o),this.tool_name="Help",this.icon=n.bk_tool_icon_help}static init_HelpTool(){this.prototype.default_view=s,this.define({help_tooltip:[i.String,"Click the question mark to learn more about Bokeh plot tools."],redirect:[i.String,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]})}get tooltip(){return this.help_tooltip}}e.HelpTool=p,p.__name__="HelpTool",p.init_HelpTool()},
function _(A,g,o){A(62),A(61).styles.append('.bk-root .bk-tool-icon-box-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-box-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-zoom-in {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-zoom-out {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-help {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-hover {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-crosshair {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-lasso-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-pan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-xpan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-ypan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-range {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-polygon-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-redo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-reset {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-save {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-tap-select {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-undo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-wheel-pan {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-wheel-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-box-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-freehand-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-point-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");\n}\n'),o.bk_tool_icon_box_select="bk-tool-icon-box-select",o.bk_tool_icon_box_zoom="bk-tool-icon-box-zoom",o.bk_tool_icon_zoom_in="bk-tool-icon-zoom-in",o.bk_tool_icon_zoom_out="bk-tool-icon-zoom-out",o.bk_tool_icon_help="bk-tool-icon-help",o.bk_tool_icon_hover="bk-tool-icon-hover",o.bk_tool_icon_crosshair="bk-tool-icon-crosshair",o.bk_tool_icon_lasso_select="bk-tool-icon-lasso-select",o.bk_tool_icon_pan="bk-tool-icon-pan",o.bk_tool_icon_xpan="bk-tool-icon-xpan",o.bk_tool_icon_ypan="bk-tool-icon-ypan",o.bk_tool_icon_range="bk-tool-icon-range",o.bk_tool_icon_polygon_select="bk-tool-icon-polygon-select",o.bk_tool_icon_redo="bk-tool-icon-redo",o.bk_tool_icon_reset="bk-tool-icon-reset",o.bk_tool_icon_save="bk-tool-icon-save",o.bk_tool_icon_tap_select="bk-tool-icon-tap-select",o.bk_tool_icon_undo="bk-tool-icon-undo",o.bk_tool_icon_wheel_pan="bk-tool-icon-wheel-pan",o.bk_tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",o.bk_tool_icon_box_edit="bk-tool-icon-box-edit",o.bk_tool_icon_freehand_draw="bk-tool-icon-freehand-draw",o.bk_tool_icon_poly_draw="bk-tool-icon-poly-draw",o.bk_tool_icon_point_draw="bk-tool-icon-point-draw",o.bk_tool_icon_poly_edit="bk-tool-icon-poly-edit"},
function _(o,l,g){o(62),o(61).styles.append(".bk-root .bk-logo {\n  margin: 5px;\n  position: relative;\n  display: block;\n  background-repeat: no-repeat;\n}\n.bk-root .bk-logo.bk-grey {\n  filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\\'http://www.w3.org/2000/svg\\'><filter id=\\'grayscale\\'><feColorMatrix type=\\'matrix\\' values=\\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\\'/></filter></svg>#grayscale\");\n  /* Firefox 10+, Firefox on Android */\n  filter: gray;\n  /* IE6-9 */\n  -webkit-filter: grayscale(100%);\n  /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n.bk-root .bk-logo-small {\n  width: 20px;\n  height: 20px;\n  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);\n}\n.bk-root .bk-logo-notebook {\n  display: inline-block;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n"),g.bk_logo="bk-logo",g.bk_logo_notebook="bk-logo-notebook",g.bk_logo_small="bk-logo-small",g.bk_grey="bk-grey"},
function _(t,e,i){var s=this&&this.__rest||function(t,e){var i={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&e.indexOf(s)<0&&(i[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(s=Object.getOwnPropertySymbols(t);n<s.length;n++)e.indexOf(s[n])<0&&Object.prototype.propertyIsEnumerable.call(t,s[n])&&(i[s[n]]=t[s[n]])}return i};const n=t(176),a=t(172),o=t(178),r=t(73),l=t(237),h=t(134),_=t(141),d=t(135),c=t(274),u=t(13),p=t(92),g=t(63),m=t(65),b=t(275),f=t(7),v=t(8),w=t(22),y=t(180),x=t(183),k=t(276),O=t(184),S=t(79);let z=null;class R extends y.Layoutable{constructor(){super(...arguments),this.min_border={left:0,top:0,right:0,bottom:0}}_measure(t){t=new y.Sizeable(t).bounded_to(this.sizing.size);const e=this.left_panel.measure({width:0,height:t.height}),i=Math.max(e.width,this.min_border.left),s=this.right_panel.measure({width:0,height:t.height}),n=Math.max(s.width,this.min_border.right),a=this.top_panel.measure({width:t.width,height:0}),o=Math.max(a.height,this.min_border.top),r=this.bottom_panel.measure({width:t.width,height:0}),l=Math.max(r.height,this.min_border.bottom),h=new y.Sizeable(t).shrink_by({left:i,right:n,top:o,bottom:l}),_=this.center_panel.measure(h);return{width:i+_.width+n,height:o+_.height+l,inner:{left:i,right:n,top:o,bottom:l},align:(()=>{const{width_policy:t,height_policy:e}=this.center_panel.sizing;return"fixed"!=t&&"fixed"!=e})()}}_set_geometry(t,e){super._set_geometry(t,e),this.center_panel.set_geometry(e);const i=this.left_panel.measure({width:0,height:t.height}),s=this.right_panel.measure({width:0,height:t.height}),n=this.top_panel.measure({width:t.width,height:0}),a=this.bottom_panel.measure({width:t.width,height:0}),{left:o,top:r,right:l,bottom:h}=e;this.top_panel.set_geometry(new S.BBox({left:o,right:l,bottom:r,height:n.height})),this.bottom_panel.set_geometry(new S.BBox({left:o,right:l,top:h,height:a.height})),this.left_panel.set_geometry(new S.BBox({top:r,bottom:h,right:o,width:i.width})),this.right_panel.set_geometry(new S.BBox({top:r,bottom:h,left:l,width:s.width}))}}i.PlotLayout=R,R.__name__="PlotLayout";class B extends l.LayoutDOMView{constructor(){super(...arguments),this._outer_bbox=new S.BBox,this._inner_bbox=new S.BBox,this._needs_paint=!0,this._needs_layout=!1}get canvas_overlays(){return this.canvas_view.overlays_el}get canvas_events(){return this.canvas_view.events_el}get is_paused(){return null!=this._is_paused&&0!==this._is_paused}get child_models(){return[]}pause(){null==this._is_paused?this._is_paused=1:this._is_paused+=1}unpause(t=!1){if(null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||t||this.request_paint()}request_render(){this.request_paint()}request_paint(){this.is_paused||this.throttled_paint()}request_layout(){this._needs_layout=!0,this.request_paint()}reset(){"standard"==this.model.reset_policy&&(this.clear_state(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new c.Reset)}remove(){this.ui_event_bus.destroy(),p.remove_views(this.renderer_views),p.remove_views(this.tool_views),this.canvas_view.remove(),super.remove()}render(){super.render(),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()}initialize(){this.pause(),super.initialize(),this.force_paint=new u.Signal0(this,"force_paint"),this.state_changed=new u.Signal0(this,"state_changed"),this.lod_started=!1,this.visuals=new g.Visuals(this.model),this._initial_state_info={selection:{},dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.state={history:[],index:-1},this.canvas=new a.Canvas({map:this.model.use_map||!1,use_hidpi:this.model.hidpi,output_backend:this.model.output_backend}),this.frame=new n.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this.canvas_view=new this.canvas.default_view({model:this.canvas,parent:this}),"webgl"==this.model.output_backend&&this.init_webgl(),this.throttled_paint=b.throttle(()=>this.force_paint.emit(),15);const{UIEvents:e}=t(277);this.ui_event_bus=new e(this,this.model.toolbar,this.canvas_view.events_el);const{title_location:i,title:s}=this.model;null!=i&&null!=s&&(this._title=s instanceof h.Title?s:new h.Title({text:s}));const{toolbar_location:o,toolbar:r}=this.model;null!=o&&null!=r&&(this._toolbar=new d.ToolbarPanel({toolbar:r}),r.toolbar_location=o),this.renderer_views={},this.tool_views={},this.build_renderer_views(),this.build_tool_views(),this.update_dataranges(),this.unpause(!0),m.logger.debug("PlotView initialized")}_width_policy(){return null==this.model.frame_width?super._width_policy():"min"}_height_policy(){return null==this.model.frame_height?super._height_policy():"min"}_update_layout(){this.layout=new R,this.layout.set_sizing(this.box_sizing());const{frame_width:t,frame_height:e}=this.model;this.layout.center_panel=this.frame,this.layout.center_panel.set_sizing(Object.assign(Object.assign({},null!=t?{width_policy:"fixed",width:t}:{width_policy:"fit"}),null!=e?{height_policy:"fixed",height:e}:{height_policy:"fit"}));const i=v.copy(this.model.above),s=v.copy(this.model.below),n=v.copy(this.model.left),a=v.copy(this.model.right),o=t=>{switch(t){case"above":return i;case"below":return s;case"left":return n;case"right":return a}},{title_location:r,title:l}=this.model;null!=r&&null!=l&&o(r).push(this._title);const{toolbar_location:_,toolbar:c}=this.model;if(null!=_&&null!=c){const t=o(_);let e=!0;if(this.model.toolbar_sticky)for(let i=0;i<t.length;i++){const s=t[i];if(s instanceof h.Title){t[i]="above"==_||"below"==_?[s,this._toolbar]:[this._toolbar,s],e=!1;break}}e&&t.push(this._toolbar)}const u=(t,e)=>{const i=this.renderer_views[e.id];return i.layout=new k.SidePanel(t,i)},p=(t,e)=>{const i="above"==t||"below"==t,s=[];for(const n of e)if(f.isArray(n)){const e=n.map(e=>{const s=u(t,e);if(e instanceof d.ToolbarPanel){const t=i?"width_policy":"height_policy";s.set_sizing(Object.assign(Object.assign({},s.sizing),{[t]:"min"}))}return s});let a;i?(a=new O.Row(e)).set_sizing({width_policy:"max",height_policy:"min"}):(a=new O.Column(e)).set_sizing({width_policy:"min",height_policy:"max"}),a.absolute=!0,s.push(a)}else s.push(u(t,n));return s},g=null!=this.model.min_border?this.model.min_border:0;this.layout.min_border={left:null!=this.model.min_border_left?this.model.min_border_left:g,top:null!=this.model.min_border_top?this.model.min_border_top:g,right:null!=this.model.min_border_right?this.model.min_border_right:g,bottom:null!=this.model.min_border_bottom?this.model.min_border_bottom:g};const m=new x.VStack,b=new x.VStack,w=new x.HStack,y=new x.HStack;m.children=v.reversed(p("above",i)),b.children=p("below",s),w.children=v.reversed(p("left",n)),y.children=p("right",a),m.set_sizing({width_policy:"fit",height_policy:"min"}),b.set_sizing({width_policy:"fit",height_policy:"min"}),w.set_sizing({width_policy:"min",height_policy:"fit"}),y.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.top_panel=m,this.layout.bottom_panel=b,this.layout.left_panel=w,this.layout.right_panel=y}get axis_views(){const t=[];for(const e in this.renderer_views){const i=this.renderer_views[e];i instanceof _.AxisView&&t.push(i)}return t}set_cursor(t="default"){this.canvas_view.el.style.cursor=t}set_toolbar_visibility(t){for(const e of this.visibility_callbacks)e(t)}init_webgl(){if(null==z){const t=document.createElement("canvas"),e=t.getContext("webgl",{premultipliedAlpha:!0});null!=e&&(z={canvas:t,ctx:e})}null!=z?this.gl=z:m.logger.warn("WebGL is not supported, falling back to 2D canvas.")}prepare_webgl(t,e){if(null!=this.gl){const i=this.canvas_view.get_canvas_element();this.gl.canvas.width=i.width,this.gl.canvas.height=i.height;const{ctx:s}=this.gl;s.enable(s.SCISSOR_TEST);const[n,a,o,r]=e,{xview:l,yview:h}=this.canvas_view.bbox,_=l.compute(n),d=h.compute(a+r);s.scissor(t*_,t*d,t*o,t*r),s.enable(s.BLEND),s.blendFuncSeparate(s.SRC_ALPHA,s.ONE_MINUS_SRC_ALPHA,s.ONE_MINUS_DST_ALPHA,s.ONE)}}clear_webgl(){if(null!=this.gl){const{ctx:t}=this.gl;t.viewport(0,0,this.gl.canvas.width,this.gl.canvas.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT||t.DEPTH_BUFFER_BIT)}}blit_webgl(){const{ctx:t}=this.canvas_view;if(null!=this.gl){m.logger.debug("drawing with WebGL"),t.restore(),t.drawImage(this.gl.canvas,0,0),t.save();const e=this.canvas.pixel_ratio;t.scale(e,e),t.translate(.5,.5)}}update_dataranges(){const t={},e={};let i=!1;for(const t of w.values(this.frame.x_ranges).concat(w.values(this.frame.y_ranges)))t instanceof o.DataRange1d&&"log"==t.scale_hint&&(i=!0);for(const s in this.renderer_views){const n=this.renderer_views[s];if(n instanceof r.GlyphRendererView){const a=n.glyph.bounds();if(null!=a&&(t[s]=a),i){const t=n.glyph.log_bounds();null!=t&&(e[s]=t)}}}let s=!1,n=!1;const{width:a,height:l}=this.frame.bbox;let h;!1!==this.model.match_aspect&&0!=a&&0!=l&&(h=1/this.model.aspect_scale*(a/l));for(const i of w.values(this.frame.x_ranges)){if(i instanceof o.DataRange1d){const n="log"==i.scale_hint?e:t;i.update(n,0,this.model.id,h),i.follow&&(s=!0)}null!=i.bounds&&(n=!0)}for(const i of w.values(this.frame.y_ranges)){if(i instanceof o.DataRange1d){const n="log"==i.scale_hint?e:t;i.update(n,1,this.model.id,h),i.follow&&(s=!0)}null!=i.bounds&&(n=!0)}if(s&&n){m.logger.warn("Follow enabled so bounds are unset.");for(const t of w.values(this.frame.x_ranges))t.bounds=null;for(const t of w.values(this.frame.y_ranges))t.bounds=null}this.range_update_timestamp=Date.now()}map_to_screen(t,e,i="default",s="default"){return this.frame.map_to_screen(t,e,i,s)}push_state(t,e){const{history:i,index:s}=this.state,n=null!=i[s]?i[s].info:{},a=Object.assign(Object.assign(Object.assign({},this._initial_state_info),n),e);this.state.history=this.state.history.slice(0,this.state.index+1),this.state.history.push({type:t,info:a}),this.state.index=this.state.history.length-1,this.state_changed.emit()}clear_state(){this.state={history:[],index:-1},this.state_changed.emit()}can_undo(){return this.state.index>=0}can_redo(){return this.state.index<this.state.history.length-1}undo(){this.can_undo()&&(this.state.index-=1,this._do_state_change(this.state.index),this.state_changed.emit())}redo(){this.can_redo()&&(this.state.index+=1,this._do_state_change(this.state.index),this.state_changed.emit())}_do_state_change(t){const e=null!=this.state.history[t]?this.state.history[t].info:this._initial_state_info;null!=e.range&&this.update_range(e.range),null!=e.selection&&this.update_selection(e.selection)}get_selection(){const t={};for(const e of this.model.renderers)if(e instanceof r.GlyphRenderer){const{selected:i}=e.data_source;t[e.id]=i}return t}update_selection(t){for(const e of this.model.renderers){if(!(e instanceof r.GlyphRenderer))continue;const i=e.data_source;null!=t?null!=t[e.id]&&i.selected.update(t[e.id],!0,!1):i.selection_manager.clear()}}reset_selection(){this.update_selection(null)}_update_ranges_together(t){let e=1;for(const[i,s]of t)e=Math.min(e,this._get_weight_to_constrain_interval(i,s));if(e<1)for(const[i,s]of t)s.start=e*s.start+(1-e)*i.start,s.end=e*s.end+(1-e)*i.end}_update_ranges_individually(t,e,i,s){let n=!1;for(const[s,a]of t){if(!i){const t=this._get_weight_to_constrain_interval(s,a);t<1&&(a.start=t*a.start+(1-t)*s.start,a.end=t*a.end+(1-t)*s.end)}if(null!=s.bounds&&"auto"!=s.bounds){const[t,o]=s.bounds,r=Math.abs(a.end-a.start);s.is_reversed?(null!=t&&t>=a.end&&(n=!0,a.end=t,(e||i)&&(a.start=t+r)),null!=o&&o<=a.start&&(n=!0,a.start=o,(e||i)&&(a.end=o-r))):(null!=t&&t>=a.start&&(n=!0,a.start=t,(e||i)&&(a.end=t+r)),null!=o&&o<=a.end&&(n=!0,a.end=o,(e||i)&&(a.start=o-r)))}}if(!(i&&n&&s))for(const[e,i]of t)e.have_updated_interactively=!0,e.start==i.start&&e.end==i.end||e.setv(i)}_get_weight_to_constrain_interval(t,e){const{min_interval:i}=t;let{max_interval:s}=t;if(null!=t.bounds&&"auto"!=t.bounds){const[e,i]=t.bounds;if(null!=e&&null!=i){const t=Math.abs(i-e);s=null!=s?Math.min(s,t):t}}let n=1;if(null!=i||null!=s){const a=Math.abs(t.end-t.start),o=Math.abs(e.end-e.start);i>0&&o<i&&(n=(a-i)/(a-o)),s>0&&o>s&&(n=(s-a)/(o-a)),n=Math.max(0,Math.min(1,n))}return n}update_range(t,e=!1,i=!1,s=!0){this.pause();const{x_ranges:n,y_ranges:a}=this.frame;if(null==t){for(const t in n){n[t].reset()}for(const t in a){a[t].reset()}this.update_dataranges()}else{const o=[];for(const e in n){const i=n[e];o.push([i,t.xrs[e]])}for(const e in a){const i=a[e];o.push([i,t.yrs[e]])}i&&this._update_ranges_together(o),this._update_ranges_individually(o,e,i,s)}this.unpause()}reset_range(){this.update_range(null)}_invalidate_layout(){(()=>{for(const t of this.model.side_panels)if(this.renderer_views[t.id].layout.has_size_changed())return!0;return!1})()&&this.root.compute_layout()}build_renderer_views(){this.computed_renderers=[],this.computed_renderers.push(...this.model.above),this.computed_renderers.push(...this.model.below),this.computed_renderers.push(...this.model.left),this.computed_renderers.push(...this.model.right),this.computed_renderers.push(...this.model.center),this.computed_renderers.push(...this.model.renderers),null!=this._title&&this.computed_renderers.push(this._title),null!=this._toolbar&&this.computed_renderers.push(this._toolbar);for(const t of this.model.toolbar.tools)null!=t.overlay&&this.computed_renderers.push(t.overlay),this.computed_renderers.push(...t.synthetic_renderers);p.build_views(this.renderer_views,this.computed_renderers,{parent:this})}get_renderer_views(){return this.computed_renderers.map(t=>this.renderer_views[t.id])}build_tool_views(){const t=this.model.toolbar.tools;p.build_views(this.tool_views,t,{parent:this}).map(t=>this.ui_event_bus.register_tool(t))}connect_signals(){super.connect_signals(),this.connect(this.force_paint,()=>this.repaint());const{x_ranges:t,y_ranges:e}=this.frame;for(const e in t){const i=t[e];this.connect(i.change,()=>{this._needs_layout=!0,this.request_paint()})}for(const t in e){const i=e[t];this.connect(i.change,()=>{this._needs_layout=!0,this.request_paint()})}this.connect(this.model.properties.renderers.change,()=>this.build_renderer_views()),this.connect(this.model.toolbar.properties.tools.change,()=>{this.build_renderer_views(),this.build_tool_views()}),this.connect(this.model.change,()=>this.request_paint()),this.connect(this.model.reset,()=>this.reset())}set_initial_range(){let t=!0;const{x_ranges:e,y_ranges:i}=this.frame,s={},n={};for(const i in e){const{start:n,end:a}=e[i];if(null==n||null==a||f.isStrictNaN(n+a)){t=!1;break}s[i]={start:n,end:a}}if(t)for(const e in i){const{start:s,end:a}=i[e];if(null==s||null==a||f.isStrictNaN(s+a)){t=!1;break}n[e]={start:s,end:a}}t?(this._initial_state_info.range={xrs:s,yrs:n},m.logger.debug("initial ranges set")):m.logger.warn("could not set initial ranges")}has_finished(){if(!super.has_finished())return!1;for(const t in this.renderer_views){if(!this.renderer_views[t].has_finished())return!1}return!0}after_layout(){if(super.after_layout(),this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame._width.value),inner_height:Math.round(this.frame._height.value),outer_width:Math.round(this.layout._width.value),outer_height:Math.round(this.layout._height.value)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){const{width:t,height:e}=this.layout.bbox;this.canvas_view.prepare_canvas(t,e),this._outer_bbox=this.layout.bbox,this._needs_paint=!0}this._inner_bbox.equals(this.frame.inner_bbox)||(this._inner_bbox=this.layout.inner_bbox,this._needs_paint=!0),this._needs_paint&&(this._needs_paint=!1,this.paint())}repaint(){this._needs_layout&&this._invalidate_layout(),this.paint()}paint(){if(this.is_paused)return;m.logger.trace(`PlotView.paint() for ${this.model.id}`);const{document:t}=this.model;if(null!=t){const e=t.interactive_duration();e>=0&&e<this.model.lod_interval?setTimeout(()=>{t.interactive_duration()>this.model.lod_timeout&&t.interactive_stop(this.model),this.request_paint()},this.model.lod_timeout):t.interactive_stop(this.model)}for(const t in this.renderer_views){const e=this.renderer_views[t];if(null==this.range_update_timestamp||e instanceof r.GlyphRendererView&&e.set_data_timestamp>this.range_update_timestamp){this.update_dataranges();break}}const{ctx:e}=this.canvas_view,i=this.canvas.pixel_ratio;e.save(),e.scale(i,i),e.translate(.5,.5);const s=[this.frame._left.value,this.frame._top.value,this.frame._width.value,this.frame._height.value];if(this._map_hook(e,s),this._paint_empty(e,s),this.prepare_webgl(i,s),this.clear_webgl(),this.visuals.outline_line.doit){e.save(),this.visuals.outline_line.set_value(e);let[t,i,n,a]=s;t+n==this.layout._width.value&&(n-=1),i+a==this.layout._height.value&&(a-=1),e.strokeRect(t,i,n,a),e.restore()}this._paint_levels(e,["image","underlay","glyph"],s,!0),this._paint_levels(e,["annotation"],s,!1),this._paint_levels(e,["overlay"],s,!1),null==this._initial_state_info.range&&this.set_initial_range(),e.restore()}_paint_levels(t,e,i,s){for(const n of e)for(const e of this.computed_renderers){if(e.level!=n)continue;const a=this.renderer_views[e.id];t.save(),(s||a.needs_clip)&&(t.beginPath(),t.rect(...i),t.clip()),a.render(),t.restore(),a.has_webgl&&(this.blit_webgl(),this.clear_webgl())}}_map_hook(t,e){}_paint_empty(t,e){const[i,s,n,a]=[0,0,this.layout._width.value,this.layout._height.value],[o,r,l,h]=e;t.clearRect(i,s,n,a),this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(t),t.fillRect(i,s,n,a),t.clearRect(o,r,l,h)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(o,r,l,h))}save(t){switch(this.model.output_backend){case"canvas":case"webgl":{const e=this.canvas_view.get_canvas_element();if(null!=e.msToBlob){const i=e.msToBlob();window.navigator.msSaveBlob(i,t)}else{const i=document.createElement("a");i.href=e.toDataURL("image/png"),i.download=t+".png",i.target="_blank",i.dispatchEvent(new MouseEvent("click"))}break}case"svg":{const e=this.canvas_view._ctx.getSerializedSvg(!0),i=new Blob([e],{type:"text/plain"}),s=document.createElement("a");s.download=t+".svg",s.innerHTML="Download svg",s.href=window.URL.createObjectURL(i),s.onclick=(t=>document.body.removeChild(t.target)),s.style.display="none",document.body.appendChild(s),s.click();break}}}serializable_state(){const t=super.serializable_state(),{children:e}=t,i=s(t,["children"]),n=this.get_renderer_views().map(t=>t.serializable_state()).filter(t=>"bbox"in t);return Object.assign(Object.assign({},i),{children:[...e,...n]})}}i.PlotView=B,B.__name__="PlotView"},
function _(e,t,s){var n=this&&this.__decorate||function(e,t,s,n){var _,a=arguments.length,o=a<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)o=Reflect.decorate(e,t,s,n);else for(var c=e.length-1;c>=0;c--)(_=e[c])&&(o=(a<3?_(o):a>3?_(t,s,o):_(t,s))||o);return a>3&&o&&Object.defineProperty(t,s,o),o};function _(e){return function(t){t.prototype.event_name=e}}class a{to_json(){const{event_name:e}=this;return{event_name:e,event_values:this._to_json()}}_to_json(){const{origin:e}=this;return{model_id:null!=e?e.id:null}}}s.BokehEvent=a,a.__name__="BokehEvent";let o=class extends a{};o.__name__="ButtonClick",o=n([_("button_click")],o),s.ButtonClick=o;let c=class extends a{constructor(e){super(),this.item=e}_to_json(){const{item:e}=this;return Object.assign(Object.assign({},super._to_json()),{item:e})}};c.__name__="MenuItemClick",c=n([_("menu_item_click")],c),s.MenuItemClick=c;class r extends a{}s.UIEvent=r,r.__name__="UIEvent";let i=class extends r{};i.__name__="LODStart",i=n([_("lodstart")],i),s.LODStart=i;let l=class extends r{};l.__name__="LODEnd",l=n([_("lodend")],l),s.LODEnd=l;let u=class extends r{constructor(e,t){super(),this.geometry=e,this.final=t}_to_json(){const{geometry:e,final:t}=this;return Object.assign(Object.assign({},super._to_json()),{geometry:e,final:t})}};u.__name__="SelectionGeometry",u=n([_("selectiongeometry")],u),s.SelectionGeometry=u;let d=class extends r{};d.__name__="Reset",d=n([_("reset")],d),s.Reset=d;class h extends r{constructor(e,t,s,n){super(),this.sx=e,this.sy=t,this.x=s,this.y=n}_to_json(){const{sx:e,sy:t,x:s,y:n}=this;return Object.assign(Object.assign({},super._to_json()),{sx:e,sy:t,x:s,y:n})}}s.PointEvent=h,h.__name__="PointEvent";let m=class extends h{constructor(e,t,s,n,_,a){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta_x=_,this.delta_y=a}_to_json(){const{delta_x:e,delta_y:t}=this;return Object.assign(Object.assign({},super._to_json()),{delta_x:e,delta_y:t})}};m.__name__="Pan",m=n([_("pan")],m),s.Pan=m;let x=class extends h{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.scale=_}_to_json(){const{scale:e}=this;return Object.assign(Object.assign({},super._to_json()),{scale:e})}};x.__name__="Pinch",x=n([_("pinch")],x),s.Pinch=x;let p=class extends h{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.rotation=_}_to_json(){const{rotation:e}=this;return Object.assign(Object.assign({},super._to_json()),{rotation:e})}};p.__name__="Rotate",p=n([_("rotate")],p),s.Rotate=p;let j=class extends h{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta=_}_to_json(){const{delta:e}=this;return Object.assign(Object.assign({},super._to_json()),{delta:e})}};j.__name__="MouseWheel",j=n([_("wheel")],j),s.MouseWheel=j;let y=class extends h{};y.__name__="MouseMove",y=n([_("mousemove")],y),s.MouseMove=y;let g=class extends h{};g.__name__="MouseEnter",g=n([_("mouseenter")],g),s.MouseEnter=g;let b=class extends h{};b.__name__="MouseLeave",b=n([_("mouseleave")],b),s.MouseLeave=b;let O=class extends h{};O.__name__="Tap",O=n([_("tap")],O),s.Tap=O;let v=class extends h{};v.__name__="DoubleTap",v=n([_("doubletap")],v),s.DoubleTap=v;let P=class extends h{};P.__name__="Press",P=n([_("press")],P),s.Press=P;let f=class extends h{};f.__name__="PressUp",f=n([_("pressup")],f),s.PressUp=f;let E=class extends h{};E.__name__="PanStart",E=n([_("panstart")],E),s.PanStart=E;let M=class extends h{};M.__name__="PanEnd",M=n([_("panend")],M),s.PanEnd=M;let R=class extends h{};R.__name__="PinchStart",R=n([_("pinchstart")],R),s.PinchStart=R;let S=class extends h{};S.__name__="PinchEnd",S=n([_("pinchend")],S),s.PinchEnd=S;let k=class extends h{};k.__name__="RotateStart",k=n([_("rotatestart")],k),s.RotateStart=k;let D=class extends h{};D.__name__="RotateEnd",D=n([_("rotateend")],D),s.RotateEnd=D},
function _(n,e,o){const t=("undefined"!=typeof window?window.requestAnimationFrame:void 0)||("undefined"!=typeof window?window.webkitRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.mozRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.msRequestAnimationFrame:void 0)||function(n){return n(Date.now()),-1};o.throttle=function(n,e){let o=null,i=0,d=!1;const u=function(){i=Date.now(),o=null,d=!1,n()};return function(){const n=Date.now(),w=e-(n-i);w<=0&&!d?(null!=o&&clearTimeout(o),d=!0,t(u)):o||d||(o=setTimeout(()=>t(u),w))}}},
function _(i,t,e){const l=i(181),a=i(182),r=i(7),h=Math.PI/2,o="left",s="center",n={above:{parallel:0,normal:-h,horizontal:0,vertical:-h},below:{parallel:0,normal:h,horizontal:0,vertical:h},left:{parallel:-h,normal:0,horizontal:0,vertical:-h},right:{parallel:h,normal:0,horizontal:0,vertical:h}},d={above:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"alphabetic",vertical:"middle"},below:{justified:"bottom",parallel:"hanging",normal:"middle",horizontal:"hanging",vertical:"middle"},left:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"},right:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"}},_={above:{justified:s,parallel:s,normal:o,horizontal:s,vertical:o},below:{justified:s,parallel:s,normal:o,horizontal:s,vertical:o},left:{justified:s,parallel:s,normal:"right",horizontal:"right",vertical:s},right:{justified:s,parallel:s,normal:o,horizontal:o,vertical:s}},c={above:"right",below:o,left:"right",right:o},m={above:o,below:"right",left:"right",right:o};class g extends a.ContentLayoutable{constructor(i,t){switch(super(),this.side=i,this.obj=t,this.side){case"above":this._dim=0,this._normals=[0,-1];break;case"below":this._dim=0,this._normals=[0,1];break;case"left":this._dim=1,this._normals=[-1,0];break;case"right":this._dim=1,this._normals=[1,0];break;default:throw new Error("unreachable")}this.is_horizontal?this.set_sizing({width_policy:"max",height_policy:"fixed"}):this.set_sizing({width_policy:"fixed",height_policy:"max"})}_content_size(){return new l.Sizeable(this.get_oriented_size())}get_oriented_size(){const{width:i,height:t}=this.obj.get_size();return!this.obj.rotate||this.is_horizontal?{width:i,height:t}:{width:t,height:i}}has_size_changed(){const{width:i,height:t}=this.get_oriented_size();return this.is_horizontal?this.bbox.height!=t:this.bbox.width!=i}get dimension(){return this._dim}get normals(){return this._normals}get is_horizontal(){return 0==this._dim}get is_vertical(){return 1==this._dim}apply_label_text_heuristics(i,t){const e=this.side;let l,a;r.isString(t)?(l=d[e][t],a=_[e][t]):0===t?(l="whatever",a="whatever"):t<0?(l="middle",a=c[e]):(l="middle",a=m[e]),i.textBaseline=l,i.textAlign=a}get_label_angle_heuristic(i){return n[this.side][i]}}e.SidePanel=g,g.__name__="SidePanel"},
function _(t,e,s){const n=t(278),i=t(13),r=t(65),a=t(61),h=t(279),_=t(8),o=t(22),c=t(7),l=t(95),p=t(274);class u{constructor(t,e,s){this.plot_view=t,this.toolbar=e,this.hit_area=s,this.pan_start=new i.Signal(this,"pan:start"),this.pan=new i.Signal(this,"pan"),this.pan_end=new i.Signal(this,"pan:end"),this.pinch_start=new i.Signal(this,"pinch:start"),this.pinch=new i.Signal(this,"pinch"),this.pinch_end=new i.Signal(this,"pinch:end"),this.rotate_start=new i.Signal(this,"rotate:start"),this.rotate=new i.Signal(this,"rotate"),this.rotate_end=new i.Signal(this,"rotate:end"),this.tap=new i.Signal(this,"tap"),this.doubletap=new i.Signal(this,"doubletap"),this.press=new i.Signal(this,"press"),this.pressup=new i.Signal(this,"pressup"),this.move_enter=new i.Signal(this,"move:enter"),this.move=new i.Signal(this,"move"),this.move_exit=new i.Signal(this,"move:exit"),this.scroll=new i.Signal(this,"scroll"),this.keydown=new i.Signal(this,"keydown"),this.keyup=new i.Signal(this,"keyup"),this.hammer=new n(this.hit_area,{touchAction:"auto"}),this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",t=>this._mouse_move(t)),this.hit_area.addEventListener("mouseenter",t=>this._mouse_enter(t)),this.hit_area.addEventListener("mouseleave",t=>this._mouse_exit(t)),this.hit_area.addEventListener("wheel",t=>this._mouse_wheel(t)),document.addEventListener("keydown",this),document.addEventListener("keyup",this)}destroy(){this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)}handleEvent(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)}_configure_hammerjs(){this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",t=>this._doubletap(t)),this.hammer.on("tap",t=>this._tap(t)),this.hammer.on("press",t=>this._press(t)),this.hammer.on("pressup",t=>this._pressup(t)),this.hammer.get("pan").set({direction:n.DIRECTION_ALL}),this.hammer.on("panstart",t=>this._pan_start(t)),this.hammer.on("pan",t=>this._pan(t)),this.hammer.on("panend",t=>this._pan_end(t)),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",t=>this._pinch_start(t)),this.hammer.on("pinch",t=>this._pinch(t)),this.hammer.on("pinchend",t=>this._pinch_end(t)),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",t=>this._rotate_start(t)),this.hammer.on("rotate",t=>this._rotate(t)),this.hammer.on("rotateend",t=>this._rotate_end(t))}register_tool(t){const e=t.model.event_type;null!=e&&(c.isString(e)?this._register_tool(t,e):e.forEach((e,s)=>this._register_tool(t,e,s<1)))}_register_tool(t,e,s=!0){const n=t,{id:i}=n.model,a=t=>e=>{e.id==i&&t(e.e)},h=t=>e=>{t(e.e)};switch(e){case"pan":null!=n._pan_start&&n.connect(this.pan_start,a(n._pan_start.bind(n))),null!=n._pan&&n.connect(this.pan,a(n._pan.bind(n))),null!=n._pan_end&&n.connect(this.pan_end,a(n._pan_end.bind(n)));break;case"pinch":null!=n._pinch_start&&n.connect(this.pinch_start,a(n._pinch_start.bind(n))),null!=n._pinch&&n.connect(this.pinch,a(n._pinch.bind(n))),null!=n._pinch_end&&n.connect(this.pinch_end,a(n._pinch_end.bind(n)));break;case"rotate":null!=n._rotate_start&&n.connect(this.rotate_start,a(n._rotate_start.bind(n))),null!=n._rotate&&n.connect(this.rotate,a(n._rotate.bind(n))),null!=n._rotate_end&&n.connect(this.rotate_end,a(n._rotate_end.bind(n)));break;case"move":null!=n._move_enter&&n.connect(this.move_enter,a(n._move_enter.bind(n))),null!=n._move&&n.connect(this.move,a(n._move.bind(n))),null!=n._move_exit&&n.connect(this.move_exit,a(n._move_exit.bind(n)));break;case"tap":null!=n._tap&&n.connect(this.tap,a(n._tap.bind(n)));break;case"press":null!=n._press&&n.connect(this.press,a(n._press.bind(n))),null!=n._pressup&&n.connect(this.pressup,a(n._pressup.bind(n)));break;case"scroll":null!=n._scroll&&n.connect(this.scroll,a(n._scroll.bind(n)));break;default:throw new Error(`unsupported event_type: ${e}`)}s&&(null!=n._doubletap&&n.connect(this.doubletap,h(n._doubletap.bind(n))),null!=n._keydown&&n.connect(this.keydown,h(n._keydown.bind(n))),null!=n._keyup&&n.connect(this.keyup,h(n._keyup.bind(n))),l.is_mobile&&null!=n._scroll&&"pinch"==e&&(r.logger.debug("Registering scroll on touch screen"),n.connect(this.scroll,a(n._scroll.bind(n)))))}_hit_test_renderers(t,e){const s=this.plot_view.get_renderer_views();for(const n of _.reversed(s)){const{level:s}=n.model;if(("annotation"==s||"overlay"==s)&&null!=n.interactive_hit&&n.interactive_hit(t,e))return n}return null}_hit_test_frame(t,e){return this.plot_view.frame.bbox.contains(t,e)}_hit_test_canvas(t,e){return this.plot_view.layout.bbox.contains(t,e)}_trigger(t,e,s){const n=this.toolbar.gestures;let i=t.name;const r=i.split(":")[0],a=this._hit_test_renderers(e.sx,e.sy),h=this._hit_test_canvas(e.sx,e.sy);switch(r){case"move":{const s=n[r].active;null!=s&&this.trigger(t,e,s.id);const _=this.toolbar.inspectors.filter(t=>t.active);let c="default";null!=a?(c=a.cursor(e.sx,e.sy)||c,o.isEmpty(_)||(i=(t=this.move_exit).name)):this._hit_test_frame(e.sx,e.sy)&&(o.isEmpty(_)||(c="crosshair")),this.plot_view.set_cursor(c),this.plot_view.set_toolbar_visibility(h),_.map(s=>this.trigger(t,e,s.id));break}case"tap":{const{target:i}=s;if(null!=i&&i!=this.hit_area)return;null!=a&&null!=a.on_hit&&a.on_hit(e.sx,e.sy);const h=n[r].active;null!=h&&this.trigger(t,e,h.id);break}case"scroll":{const i=n[l.is_mobile?"pinch":"scroll"].active;null!=i&&(s.preventDefault(),s.stopPropagation(),this.trigger(t,e,i.id));break}case"pan":{const i=n[r].active;null!=i&&(s.preventDefault(),this.trigger(t,e,i.id));break}default:{const s=n[r].active;null!=s&&this.trigger(t,e,s.id)}}this._trigger_bokeh_event(e)}trigger(t,e,s=null){t.emit({id:s,e:e})}_trigger_bokeh_event(t){const e=(()=>{const e=this.plot_view.frame.xscales.default,s=this.plot_view.frame.yscales.default,{sx:n,sy:i}=t,r=e.invert(n),a=s.invert(i);switch(t.type){case"wheel":return new p.MouseWheel(n,i,r,a,t.delta);case"mousemove":return new p.MouseMove(n,i,r,a);case"mouseenter":return new p.MouseEnter(n,i,r,a);case"mouseleave":return new p.MouseLeave(n,i,r,a);case"tap":return new p.Tap(n,i,r,a);case"doubletap":return new p.DoubleTap(n,i,r,a);case"press":return new p.Press(n,i,r,a);case"pressup":return new p.PressUp(n,i,r,a);case"pan":return new p.Pan(n,i,r,a,t.deltaX,t.deltaY);case"panstart":return new p.PanStart(n,i,r,a);case"panend":return new p.PanEnd(n,i,r,a);case"pinch":return new p.Pinch(n,i,r,a,t.scale);case"pinchstart":return new p.PinchStart(n,i,r,a);case"pinchend":return new p.PinchEnd(n,i,r,a);case"rotate":return new p.Rotate(n,i,r,a,t.rotation);case"rotatestart":return new p.RotateStart(n,i,r,a);case"rotateend":return new p.RotateEnd(n,i,r,a);default:return}})();null!=e&&this.plot_view.model.trigger_event(e)}_get_sxy(t){const{pageX:e,pageY:s}=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,{left:n,top:i}=a.offset(this.hit_area);return{sx:e-n,sy:s-i}}_pan_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey})}_pinch_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey})}_rotate_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey})}_tap_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey})}_move_event(t){return Object.assign({type:t.type},this._get_sxy(t))}_scroll_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:h.getDeltaY(t)})}_key_event(t){return{type:t.type,keyCode:t.keyCode}}_pan_start(t){const e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)}_pan(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)}_pan_end(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)}_pinch_start(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)}_pinch(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)}_pinch_end(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)}_rotate_start(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)}_rotate(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)}_rotate_end(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)}_tap(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)}_doubletap(t){const e=this._tap_event(t);this._trigger_bokeh_event(e),this.trigger(this.doubletap,e)}_press(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)}_pressup(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)}_mouse_enter(t){this._trigger(this.move_enter,this._move_event(t),t)}_mouse_move(t){this._trigger(this.move,this._move_event(t),t)}_mouse_exit(t){this._trigger(this.move_exit,this._move_event(t),t)}_mouse_wheel(t){this._trigger(this.scroll,this._scroll_event(t),t)}_key_down(t){this.trigger(this.keydown,this._key_event(t))}_key_up(t){this.trigger(this.keyup,this._key_event(t))}}s.UIEvents=u,u.__name__="UIEvents"},
function _(t,e,i){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,i,n,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=i.createElement("div"),h="function",u=Math.round,c=Math.abs,l=Date.now;function p(t,e,i){return setTimeout(y(t,i),e)}function f(t,e,i){return!!Array.isArray(t)&&(v(t,i[e],i),!0)}function v(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==r)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function d(e,i,n){var r="DEPRECATED METHOD: "+i+"\n"+n+" AT \n";return function(){var i=new Error("get-stack-trace"),n=i&&i.stack?i.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,n),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==r&&null!==n)for(var s in n)n.hasOwnProperty(s)&&(e[s]=n[s])}return e}:Object.assign;var m=d(function(t,e,i){for(var n=Object.keys(e),s=0;s<n.length;)(!i||i&&t[n[s]]===r)&&(t[n[s]]=e[n[s]]),s++;return t},"extend","Use `assign`."),g=d(function(t,e){return m(t,e,!0)},"merge","Use `assign`.");function T(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&s(n,i)}function y(t,e){return function(){return t.apply(e,arguments)}}function E(t,e){return typeof t==h?t.apply(e&&e[0]||r,e):t}function I(t,e){return t===r?e:t}function A(t,e,i){v(b(e),function(e){t.addEventListener(e,i,!1)})}function _(t,e,i){v(b(e),function(e){t.removeEventListener(e,i,!1)})}function C(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function S(t,e){return t.indexOf(e)>-1}function b(t){return t.trim().split(/\s+/g)}function P(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function D(t){return Array.prototype.slice.call(t,0)}function x(t,e,i){for(var n=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];P(r,o)<0&&n.push(t[s]),r[s]=o,s++}return i&&(n=e?n.sort(function(t,i){return t[e]>i[e]}):n.sort()),n}function w(t,e){for(var i,n,s=e[0].toUpperCase()+e.slice(1),a=0;a<o.length;){if((n=(i=o[a])?i+s:e)in t)return n;a++}return r}var O=1;function R(e){var i=e.ownerDocument||e;return i.defaultView||i.parentWindow||t}var M="ontouchstart"in t,z=w(t,"PointerEvent")!==r,N=M&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),X=25,Y=1,F=2,W=4,q=8,k=1,H=2,L=4,U=8,V=16,j=H|L,G=U|V,Z=j|G,B=["x","y"],$=["clientX","clientY"];function J(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){E(t.options.enable,[t])&&i.handler(e)},this.init()}function K(t,e,i){var n=i.pointers.length,s=i.changedPointers.length,o=e&Y&&n-s==0,a=e&(W|q)&&n-s==0;i.isFirst=!!o,i.isFinal=!!a,o&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,s=n.length;i.firstInput||(i.firstInput=Q(e));s>1&&!i.firstMultiple?i.firstMultiple=Q(e):1===s&&(i.firstMultiple=!1);var o=i.firstInput,a=i.firstMultiple,h=a?a.center:o.center,u=e.center=tt(n);e.timeStamp=l(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=rt(h,u),e.distance=nt(h,u),function(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};e.eventType!==Y&&s.eventType!==W||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y});e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}(i,e),e.offsetDirection=it(e.deltaX,e.deltaY);var p=et(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=p.x,e.overallVelocityY=p.y,e.overallVelocity=c(p.x)>c(p.y)?p.x:p.y,e.scale=a?(f=a.pointers,v=n,nt(v[0],v[1],$)/nt(f[0],f[1],$)):1,e.rotation=a?function(t,e){return rt(e[1],e[0],$)+rt(t[1],t[0],$)}(a.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,s,o,a=t.lastInterval||e,h=e.timeStamp-a.timeStamp;if(e.eventType!=q&&(h>X||a.velocity===r)){var u=e.deltaX-a.deltaX,l=e.deltaY-a.deltaY,p=et(h,u,l);n=p.x,s=p.y,i=c(p.x)>c(p.y)?p.x:p.y,o=it(u,l),t.lastInterval=e}else i=a.velocity,n=a.velocityX,s=a.velocityY,o=a.direction;e.velocity=i,e.velocityX=n,e.velocityY=s,e.direction=o}(i,e);var f,v;var d=t.element;C(e.srcEvent.target,d)&&(d=e.srcEvent.target);e.target=d}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function Q(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:u(t.pointers[i].clientX),clientY:u(t.pointers[i].clientY)},i++;return{timeStamp:l(),pointers:e,center:tt(e),deltaX:t.deltaX,deltaY:t.deltaY}}function tt(t){var e=t.length;if(1===e)return{x:u(t[0].clientX),y:u(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:u(i/e),y:u(n/e)}}function et(t,e,i){return{x:e/t||0,y:i/t||0}}function it(t,e){return t===e?k:c(t)>=c(e)?t<0?H:L:e<0?U:V}function nt(t,e,i){i||(i=B);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function rt(t,e,i){i||(i=B);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}J.prototype={handler:function(){},init:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(R(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&_(this.element,this.evEl,this.domHandler),this.evTarget&&_(this.target,this.evTarget,this.domHandler),this.evWin&&_(R(this.element),this.evWin,this.domHandler)}};var st={mousedown:Y,mousemove:F,mouseup:W},ot="mousedown",at="mousemove mouseup";function ht(){this.evEl=ot,this.evWin=at,this.pressed=!1,J.apply(this,arguments)}T(ht,J,{handler:function(t){var e=st[t.type];e&Y&&0===t.button&&(this.pressed=!0),e&F&&1!==t.which&&(e=W),this.pressed&&(e&W&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))}});var ut={pointerdown:Y,pointermove:F,pointerup:W,pointercancel:q,pointerout:q},ct={2:"touch",3:"pen",4:"mouse",5:"kinect"},lt="pointerdown",pt="pointermove pointerup pointercancel";function ft(){this.evEl=lt,this.evWin=pt,J.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(lt="MSPointerDown",pt="MSPointerMove MSPointerUp MSPointerCancel"),T(ft,J,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=ut[n],s=ct[t.pointerType]||t.pointerType,o="touch"==s,a=P(e,t.pointerId,"pointerId");r&Y&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):r&(W|q)&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))}});var vt={touchstart:Y,touchmove:F,touchend:W,touchcancel:q},dt="touchstart",mt="touchstart touchmove touchend touchcancel";function gt(){this.evTarget=dt,this.evWin=mt,this.started=!1,J.apply(this,arguments)}T(gt,J,{handler:function(t){var e=vt[t.type];if(e===Y&&(this.started=!0),this.started){var i=function(t,e){var i=D(t.touches),n=D(t.changedTouches);e&(W|q)&&(i=x(i.concat(n),"identifier",!0));return[i,n]}.call(this,t,e);e&(W|q)&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:"touch",srcEvent:t})}}});var Tt={touchstart:Y,touchmove:F,touchend:W,touchcancel:q},yt="touchstart touchmove touchend touchcancel";function Et(){this.evTarget=yt,this.targetIds={},J.apply(this,arguments)}T(Et,J,{handler:function(t){var e=Tt[t.type],i=function(t,e){var i=D(t.touches),n=this.targetIds;if(e&(Y|F)&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,s,o=D(t.changedTouches),a=[],h=this.target;if(s=i.filter(function(t){return C(t.target,h)}),e===Y)for(r=0;r<s.length;)n[s[r].identifier]=!0,r++;r=0;for(;r<o.length;)n[o[r].identifier]&&a.push(o[r]),e&(W|q)&&delete n[o[r].identifier],r++;if(!a.length)return;return[x(s.concat(a),"identifier",!0),a]}.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:"touch",srcEvent:t})}});var It=2500,At=25;function _t(){J.apply(this,arguments);var t=y(this.handler,this);this.touch=new Et(this.manager,t),this.mouse=new ht(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function Ct(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout(function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)},It)}}T(_t,J,{handler:function(t,e,i){var n="touch"==i.pointerType,r="mouse"==i.pointerType;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)(function(t,e){t&Y?(this.primaryTouch=e.changedPointers[0].identifier,Ct.call(this,e)):t&(W|q)&&Ct.call(this,e)}).call(this,e,i);else if(r&&function(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],s=Math.abs(e-r.x),o=Math.abs(i-r.y);if(s<=At&&o<=At)return!0}return!1}.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var St=w(a.style,"touchAction"),bt=St!==r,Pt="auto",Dt="manipulation",xt="none",wt="pan-x",Ot="pan-y",Rt=function(){if(!bt)return!1;var e={},i=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach(function(n){e[n]=!i||t.CSS.supports("touch-action",n)}),e}();function Mt(t,e){this.manager=t,this.set(e)}Mt.prototype={set:function(t){"compute"==t&&(t=this.compute()),bt&&this.manager.element.style&&Rt[t]&&(this.manager.element.style[St]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return v(this.manager.recognizers,function(e){E(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))}),function(t){if(S(t,xt))return xt;var e=S(t,wt),i=S(t,Ot);if(e&&i)return xt;if(e||i)return e?wt:Ot;if(S(t,Dt))return Dt;return Pt}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=S(n,xt)&&!Rt[xt],s=S(n,Ot)&&!Rt[Ot],o=S(n,wt)&&!Rt[wt];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&i&j||o&&i&G?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var zt=1,Nt=2,Xt=4,Yt=8,Ft=Yt,Wt=16;function qt(t){this.options=s({},this.defaults,t||{}),this.id=O++,this.manager=null,this.options.enable=I(this.options.enable,!0),this.state=zt,this.simultaneous={},this.requireFail=[]}function kt(t){return t&Wt?"cancel":t&Yt?"end":t&Xt?"move":t&Nt?"start":""}function Ht(t){return t==V?"down":t==U?"up":t==H?"left":t==L?"right":""}function Lt(t,e){var i=e.manager;return i?i.get(t):t}function Ut(){qt.apply(this,arguments)}function Vt(){Ut.apply(this,arguments),this.pX=null,this.pY=null}function jt(){Ut.apply(this,arguments)}function Gt(){qt.apply(this,arguments),this._timer=null,this._input=null}function Zt(){Ut.apply(this,arguments)}function Bt(){Ut.apply(this,arguments)}function $t(){qt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Jt(t,e){return(e=e||{}).recognizers=I(e.recognizers,Jt.defaults.preset),new Kt(t,e)}qt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(f(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=Lt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return f(t,"dropRecognizeWith",this)?this:(t=Lt(t,this),delete this.simultaneous[t.id],this)},requireFailure:function(t){if(f(t,"requireFailure",this))return this;var e=this.requireFail;return-1===P(e,t=Lt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(f(t,"dropRequireFailure",this))return this;t=Lt(t,this);var e=P(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<Yt&&n(e.options.event+kt(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=Yt&&n(e.options.event+kt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=32},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(this.requireFail[t].state&(32|zt)))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!E(this.options.enable,[this,e]))return this.reset(),void(this.state=32);this.state&(Ft|Wt|32)&&(this.state=zt),this.state=this.process(e),this.state&(Nt|Xt|Yt|Wt)&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},T(Ut,qt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=e&(Nt|Xt),r=this.attrTest(t);return n&&(i&q||!r)?e|Wt:n||r?i&W?e|Yt:e&Nt?e|Xt:Nt:32}}),T(Vt,Ut,{defaults:{event:"pan",threshold:10,pointers:1,direction:Z},getTouchAction:function(){var t=this.options.direction,e=[];return t&j&&e.push(Ot),t&G&&e.push(wt),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(e.direction&j?(r=0===s?k:s<0?H:L,i=s!=this.pX,n=Math.abs(t.deltaX)):(r=0===o?k:o<0?U:V,i=o!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Ut.prototype.attrTest.call(this,t)&&(this.state&Nt||!(this.state&Nt)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=Ht(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),T(jt,Ut,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[xt]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||this.state&Nt)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),T(Gt,qt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[Pt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||t.eventType&(W|q)&&!r)this.reset();else if(t.eventType&Y)this.reset(),this._timer=p(function(){this.state=Ft,this.tryEmit()},e.time,this);else if(t.eventType&W)return Ft;return 32},reset:function(){clearTimeout(this._timer)},emit:function(t){this.state===Ft&&(t&&t.eventType&W?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=l(),this.manager.emit(this.options.event,this._input)))}}),T(Zt,Ut,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[xt]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||this.state&Nt)}}),T(Bt,Ut,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:j|G,pointers:1},getTouchAction:function(){return Vt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return i&(j|G)?e=t.overallVelocity:i&j?e=t.overallVelocityX:i&G&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&c(e)>this.options.velocity&&t.eventType&W},emit:function(t){var e=Ht(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),T($t,qt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Dt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),t.eventType&Y&&0===this.count)return this.failTimeout();if(n&&r&&i){if(t.eventType!=W)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||nt(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=p(function(){this.state=Ft,this.tryEmit()},e.interval,this),Nt):Ft}return 32},failTimeout:function(){return this._timer=p(function(){this.state=32},this.options.interval,this),32},reset:function(){clearTimeout(this._timer)},emit:function(){this.state==Ft&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Jt.VERSION="2.0.7",Jt.defaults={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,preset:[[Zt,{enable:!1}],[jt,{enable:!1},["rotate"]],[Bt,{direction:j}],[Vt,{direction:j},["swipe"]],[$t],[$t,{event:"doubletap",taps:2},["tap"]],[Gt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Kt(t,e){var i;this.options=s({},Jt.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(z?ft:N?Et:M?_t:ht))(i,K),this.touchAction=new Mt(this,this.options.touchAction),Qt(this,!0),v(this.options.recognizers,function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])},this)}function Qt(t,e){var i,n=t.element;n.style&&(v(t.options.cssProps,function(r,s){i=w(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""}),e||(t.oldCssProps={}))}Kt.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&r.state&Ft)&&(r=e.curRecognizer=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&i.state&(Nt|Xt|Yt)&&(r=e.curRecognizer=i),s++}},get:function(t){if(t instanceof qt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(f(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(f(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=P(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var i=this.handlers;return v(b(t),function(t){i[t]=i[t]||[],i[t].push(e)}),this}},off:function(t,e){if(t!==r){var i=this.handlers;return v(b(t),function(t){e?i[t]&&i[t].splice(P(i[t],e),1):delete i[t]}),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var n=i.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<n.length;)n[r](e),r++}},destroy:function(){this.element&&Qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(Jt,{INPUT_START:Y,INPUT_MOVE:F,INPUT_END:W,INPUT_CANCEL:q,STATE_POSSIBLE:zt,STATE_BEGAN:Nt,STATE_CHANGED:Xt,STATE_ENDED:Yt,STATE_RECOGNIZED:Ft,STATE_CANCELLED:Wt,STATE_FAILED:32,DIRECTION_NONE:k,DIRECTION_LEFT:H,DIRECTION_RIGHT:L,DIRECTION_UP:U,DIRECTION_DOWN:V,DIRECTION_HORIZONTAL:j,DIRECTION_VERTICAL:G,DIRECTION_ALL:Z,Manager:Kt,Input:J,TouchAction:Mt,TouchInput:Et,MouseInput:ht,PointerEventInput:ft,TouchMouseInput:_t,SingleTouchInput:gt,Recognizer:qt,AttrRecognizer:Ut,Tap:$t,Pan:Vt,Swipe:Bt,Pinch:jt,Rotate:Zt,Press:Gt,on:A,off:_,each:v,merge:g,extend:m,assign:s,inherit:T,bindFn:y,prefixed:w}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=Jt,"function"==typeof define&&define.amd?define(function(){return Jt}):void 0!==e&&e.exports?e.exports=Jt:t.Hammer=Jt}(window,document)},
function _(t,e,n){function a(t){const e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}n.getDeltaY=function(t){let e=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:e*=a((n=t.target).offsetParent||document.body)||a(n)||16;break;case t.DOM_DELTA_PAGE:e*=function(t){return t.clientHeight}(t.target)}var n;return e}},
function _(t,e,s){const i=t(13),o=t(30),a=t(273),n=new i.Signal0({},"gmaps_ready"),p=function(t){window._bokeh_gmaps_callback=(()=>n.emit());const e=document.createElement("script");e.type="text/javascript",e.src=`https://maps.googleapis.com/maps/api/js?v=3.36&key=${t}&callback=_bokeh_gmaps_callback`,document.body.appendChild(e)};class l extends a.PlotView{initialize(){this.pause(),super.initialize(),this._tiles_loaded=!1,this.zoom_count=0;const{zoom:t,lat:e,lng:s}=this.model.map_options;this.initial_zoom=t,this.initial_lat=e,this.initial_lng=s,this.canvas_view.map_el.style.position="absolute","undefined"!=typeof google&&null!=google.maps||(void 0===window._bokeh_gmaps_callback&&p(this.model.api_key),n.connect(()=>this.request_render())),this.unpause()}update_range(t){if(null==t)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),super.update_range(null);else if(null!=t.sdx||null!=t.sdy)this.map.panBy(t.sdx||0,t.sdy||0),super.update_range(t);else if(null!=t.factor){let e;if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),super.update_range(t),e=t.factor<0?-1:1;const s=this.map.getZoom(),i=s+e;if(i>=2){this.map.setZoom(i);const[t,e,,]=this._get_projected_bounds();e-t<0&&this.map.setZoom(s)}this.unpause()}this._set_bokeh_ranges()}_build_map(){const{maps:t}=google;this.map_types={satellite:t.MapTypeId.SATELLITE,terrain:t.MapTypeId.TERRAIN,roadmap:t.MapTypeId.ROADMAP,hybrid:t.MapTypeId.HYBRID};const e=this.model.map_options,s={center:new t.LatLng(e.lat,e.lng),zoom:e.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[e.map_type],scaleControl:e.scale_control,tilt:e.tilt};null!=e.styles&&(s.styles=JSON.parse(e.styles)),this.map=new t.Map(this.canvas_view.map_el,s),t.event.addListener(this.map,"idle",()=>this._set_bokeh_ranges()),t.event.addListener(this.map,"bounds_changed",()=>this._set_bokeh_ranges()),t.event.addListenerOnce(this.map,"tilesloaded",()=>this._render_finished()),this.connect(this.model.properties.map_options.change,()=>this._update_options()),this.connect(this.model.map_options.properties.styles.change,()=>this._update_styles()),this.connect(this.model.map_options.properties.lat.change,()=>this._update_center("lat")),this.connect(this.model.map_options.properties.lng.change,()=>this._update_center("lng")),this.connect(this.model.map_options.properties.zoom.change,()=>this._update_zoom()),this.connect(this.model.map_options.properties.map_type.change,()=>this._update_map_type()),this.connect(this.model.map_options.properties.scale_control.change,()=>this._update_scale_control()),this.connect(this.model.map_options.properties.tilt.change,()=>this._update_tilt())}_render_finished(){this._tiles_loaded=!0,this.notify_finished()}has_finished(){return super.has_finished()&&!0===this._tiles_loaded}_get_latlon_bounds(){const t=this.map.getBounds(),e=t.getNorthEast(),s=t.getSouthWest();return[s.lng(),e.lng(),s.lat(),e.lat()]}_get_projected_bounds(){const[t,e,s,i]=this._get_latlon_bounds(),[a,n]=o.wgs84_mercator.forward([t,s]),[p,l]=o.wgs84_mercator.forward([e,i]);return[a,p,n,l]}_set_bokeh_ranges(){const[t,e,s,i]=this._get_projected_bounds();this.frame.x_range.setv({start:t,end:e}),this.frame.y_range.setv({start:s,end:i})}_update_center(t){const e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()}_update_map_type(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})}_update_scale_control(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})}_update_tilt(){this.map.setOptions({tilt:this.model.map_options.tilt})}_update_options(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()}_update_styles(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})}_update_zoom(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()}_map_hook(t,e){const[s,i,o,a]=e;this.canvas_view.map_el.style.top=`${i}px`,this.canvas_view.map_el.style.left=`${s}px`,this.canvas_view.map_el.style.width=`${o}px`,this.canvas_view.map_el.style.height=`${a}px`,null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map()}_paint_empty(t,e){const s=this.layout._width.value,i=this.layout._height.value,[o,a,n,p]=e;t.clearRect(0,0,s,i),t.beginPath(),t.moveTo(0,0),t.lineTo(0,i),t.lineTo(s,i),t.lineTo(s,0),t.lineTo(0,0),t.moveTo(o,a),t.lineTo(o+n,a),t.lineTo(o+n,a+p),t.lineTo(o,a+p),t.lineTo(o,a),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=this.model.border_fill_color,t.fill())}}s.GMapPlotView=l,l.__name__="GMapPlotView"},
function _(a,n,e){var g=a(179);e.DataRange=g.DataRange;var R=a(178);e.DataRange1d=R.DataRange1d;var r=a(82);e.FactorRange=r.FactorRange;var t=a(83);e.Range=t.Range;var v=a(123);e.Range1d=v.Range1d},
function _(e,r,d){var n=e(73);d.GlyphRenderer=n.GlyphRenderer;var R=e(90);d.GraphRenderer=R.GraphRenderer;var a=e(142);d.GuideRenderer=a.GuideRenderer;var G=e(58);d.Renderer=G.Renderer},
function _(a,e,c){var l=a(177);c.CategoricalScale=l.CategoricalScale;var r=a(113);c.LinearScale=r.LinearScale;var S=a(122);c.LogScale=S.LogScale;var i=a(114);c.Scale=i.Scale},
function _(n,o,e){!function(n){for(var o in n)e.hasOwnProperty(o)||(e[o]=n[o])}(n(93));var i=n(71);e.Selection=i.Selection},
function _(a,e,r){var o=a(286);r.ServerSentDataSource=o.ServerSentDataSource;var S=a(288);r.AjaxDataSource=S.AjaxDataSource;var t=a(68);r.ColumnDataSource=t.ColumnDataSource;var u=a(69);r.ColumnarDataSource=u.ColumnarDataSource;var D=a(89);r.CDSView=D.CDSView;var c=a(70);r.DataSource=c.DataSource;var v=a(290);r.GeoJSONDataSource=v.GeoJSONDataSource;var n=a(289);r.RemoteDataSource=n.RemoteDataSource},
function _(e,t,i){const a=e(287);class s extends a.WebDataSource{constructor(e){super(e),this.initialized=!1}destroy(){super.destroy()}setup(){if(!this.initialized){this.initialized=!0,new EventSource(this.data_url).onmessage=(e=>{this.load_data(JSON.parse(e.data),this.mode,this.max_size)})}}}i.ServerSentDataSource=s,s.__name__="ServerSentDataSource"},
function _(t,a,e){const s=t(68),i=t(18);class n extends s.ColumnDataSource{constructor(t){super(t)}get_column(t){const a=this.data[t];return null!=a?a:[]}initialize(){super.initialize(),this.setup()}load_data(t,a,e){const{adapter:s}=this;let i;switch(i=null!=s?s.execute(this,{response:t}):t,a){case"replace":this.data=i;break;case"append":{const t=this.data;for(const a of this.columns()){const s=Array.from(t[a]),n=Array.from(i[a]);i[a]=s.concat(n).slice(-e)}this.data=i;break}}}static init_WebDataSource(){this.define({mode:[i.UpdateMode,"replace"],max_size:[i.Number],adapter:[i.Any,null],data_url:[i.String]})}}e.WebDataSource=n,n.__name__="WebDataSource",n.init_WebDataSource()},
function _(t,e,i){const s=t(289),a=t(65),o=t(18);class r extends s.RemoteDataSource{constructor(t){super(t),this.initialized=!1}static init_AjaxDataSource(){this.define({content_type:[o.String,"application/json"],http_headers:[o.Any,{}],method:[o.HTTPMethod,"POST"],if_modified:[o.Boolean,!1]})}destroy(){null!=this.interval&&clearInterval(this.interval),super.destroy()}setup(){if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),this.polling_interval)){const t=()=>this.get_data(this.mode,this.max_size,this.if_modified);this.interval=setInterval(t,this.polling_interval)}}get_data(t,e=0,i=!1){const s=this.prepare_request();s.addEventListener("load",()=>this.do_load(s,t,e)),s.addEventListener("error",()=>this.do_error(s)),s.send()}prepare_request(){const t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);const e=this.http_headers;for(const i in e){const s=e[i];t.setRequestHeader(i,s)}return t}do_load(t,e,i){if(200===t.status){const s=JSON.parse(t.responseText);this.load_data(s,e,i)}}do_error(t){a.logger.error(`Failed to fetch JSON from ${this.data_url} with code ${t.status}`)}}i.AjaxDataSource=r,r.__name__="AjaxDataSource",r.init_AjaxDataSource()},
function _(t,e,i){const a=t(287),n=t(18);class o extends a.WebDataSource{constructor(t){super(t)}get_column(t){const e=this.data[t];return null!=e?e:[]}initialize(){super.initialize(),this.setup()}static init_RemoteDataSource(){this.define({polling_interval:[n.Number]})}}i.RemoteDataSource=o,o.__name__="RemoteDataSource",o.init_RemoteDataSource()},
function _(e,t,o){const r=e(69),n=e(65),s=e(18),a=e(8);function i(e){return null!=e?e:NaN}class l extends r.ColumnarDataSource{constructor(e){super(e)}static init_GeoJSONDataSource(){this.define({geojson:[s.Any]}),this.internal({data:[s.Any,{}]})}initialize(){super.initialize(),this._update_data()}connect_signals(){super.connect_signals(),this.connect(this.properties.geojson.change,()=>this._update_data())}_update_data(){this.data=this.geojson_to_column_data()}_get_new_list_array(e){return a.range(0,e).map(e=>[])}_get_new_nan_array(e){return a.range(0,e).map(e=>NaN)}_add_properties(e,t,o,r){const n=e.properties||{};for(const e in n)t.hasOwnProperty(e)||(t[e]=this._get_new_nan_array(r)),t[e][o]=i(n[e])}_add_geometry(e,t,o){function r(e,t){return e.concat([[NaN,NaN,NaN]]).concat(t)}switch(e.type){case"Point":{const[r,n,s]=e.coordinates;t.x[o]=r,t.y[o]=n,t.z[o]=i(s);break}case"LineString":{const{coordinates:r}=e;for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=i(a)}break}case"Polygon":{e.coordinates.length>1&&n.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");const r=e.coordinates[0];for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=i(a)}break}case"MultiPoint":n.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":{const n=e.coordinates.reduce(r);for(let e=0;e<n.length;e++){const[r,s,a]=n[e];t.xs[o][e]=r,t.ys[o][e]=s,t.zs[o][e]=i(a)}break}case"MultiPolygon":{const s=[];for(const t of e.coordinates)t.length>1&&n.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),s.push(t[0]);const a=s.reduce(r);for(let e=0;e<a.length;e++){const[r,n,s]=a[e];t.xs[o][e]=r,t.ys[o][e]=n,t.zs[o][e]=i(s)}break}default:throw new Error(`Invalid GeoJSON geometry type: ${e.type}`)}}geojson_to_column_data(){const e=JSON.parse(this.geojson);let t;switch(e.type){case"GeometryCollection":if(null==e.geometries)throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if(null==e.features)throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}let o=0;for(const e of t){const t="Feature"===e.type?e.geometry:e;"GeometryCollection"==t.type?o+=t.geometries.length:o+=1}const r={x:this._get_new_nan_array(o),y:this._get_new_nan_array(o),z:this._get_new_nan_array(o),xs:this._get_new_list_array(o),ys:this._get_new_list_array(o),zs:this._get_new_list_array(o)};let n=0;for(const e of t){const t="Feature"==e.type?e.geometry:e;if("GeometryCollection"==t.type)for(const s of t.geometries)this._add_geometry(s,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1;else this._add_geometry(t,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1}return r}}o.GeoJSONDataSource=l,l.__name__="GeoJSONDataSource",l.init_GeoJSONDataSource()},
function _(r,e,i){var c=r(103);i.AdaptiveTicker=c.AdaptiveTicker;var a=r(102);i.BasicTicker=a.BasicTicker;var k=r(144);i.CategoricalTicker=k.CategoricalTicker;var T=r(155);i.CompositeTicker=T.CompositeTicker;var t=r(104);i.ContinuousTicker=t.ContinuousTicker;var v=r(154);i.DatetimeTicker=v.DatetimeTicker;var o=r(156);i.DaysTicker=o.DaysTicker;var n=r(292);i.FixedTicker=n.FixedTicker;var s=r(163);i.LogTicker=s.LogTicker;var g=r(166);i.MercatorTicker=g.MercatorTicker;var l=r(159);i.MonthsTicker=l.MonthsTicker;var C=r(157);i.SingleIntervalTicker=C.SingleIntervalTicker;var u=r(105);i.Ticker=u.Ticker;var d=r(160);i.YearsTicker=d.YearsTicker},
function _(i,t,e){const r=i(104),n=i(18);class s extends r.ContinuousTicker{constructor(i){super(i),this.min_interval=0,this.max_interval=0}static init_FixedTicker(){this.define({ticks:[n.Array,[]],minor_ticks:[n.Array,[]]})}get_ticks_no_defaults(i,t,e,r){return{major:this.ticks,minor:this.minor_ticks}}get_interval(i,t,e){return 0}}e.FixedTicker=s,s.__name__="FixedTicker",s.init_FixedTicker()},
function _(e,r,T){var o=e(294);T.BBoxTileSource=o.BBoxTileSource;var S=e(295);T.MercatorTileSource=S.MercatorTileSource;var c=e(298);T.QUADKEYTileSource=c.QUADKEYTileSource;var i=e(299);T.TileRenderer=i.TileRenderer;var l=e(296);T.TileSource=l.TileSource;var u=e(302);T.TMSTileSource=u.TMSTileSource;var a=e(300);T.WMTSTileSource=a.WMTSTileSource},
function _(e,t,r){const i=e(295),o=e(18);class l extends i.MercatorTileSource{constructor(e){super(e)}static init_BBoxTileSource(){this.define({use_latlon:[o.Boolean,!1]})}get_image_url(e,t,r){const i=this.string_lookup_replace(this.url,this.extra_url_vars);let o,l,n,s;return this.use_latlon?[l,s,o,n]=this.get_tile_geographic_bounds(e,t,r):[l,s,o,n]=this.get_tile_meter_bounds(e,t,r),i.replace("{XMIN}",l.toString()).replace("{YMIN}",s.toString()).replace("{XMAX}",o.toString()).replace("{YMAX}",n.toString())}}r.BBoxTileSource=l,l.__name__="BBoxTileSource",l.init_BBoxTileSource()},
function _(t,e,i){const _=t(296),s=t(18),o=t(8),r=t(297);class n extends _.TileSource{constructor(t){super(t)}static init_MercatorTileSource(){this.define({snap_to_zoom:[s.Boolean,!1],wrap_around:[s.Boolean,!0]}),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})}initialize(){super.initialize(),this._resolutions=o.range(this.min_zoom,this.max_zoom+1).map(t=>this.get_resolution(t))}_computed_initial_resolution(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size}is_valid_tile(t,e,i){return!(!this.wrap_around&&(t<0||t>=Math.pow(2,i)))&&!(e<0||e>=Math.pow(2,i))}parent_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=_.substring(0,_.length-1);return this.quadkey_to_tile_xyz(s)}get_resolution(t){return this._computed_initial_resolution()/Math.pow(2,t)}get_resolution_by_extent(t,e,i){return[(t[2]-t[0])/i,(t[3]-t[1])/e]}get_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,o=Math.max(_,s);let r=0;for(const t of this._resolutions){if(o>t){if(0==r)return 0;if(r>0)return r-1}r+=1}return r-1}get_closest_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,o=Math.max(_,s),r=this._resolutions.reduce(function(t,e){return Math.abs(e-o)<Math.abs(t-o)?e:t});return this._resolutions.indexOf(r)}snap_to_zoom_level(t,e,i,_){const[s,o,r,n]=t,l=this._resolutions[_];let a=i*l,u=e*l;if(!this.snap_to_zoom){const t=(r-s)/a,e=(n-o)/u;t>e?(a=r-s,u*=t):(a*=e,u=n-o)}const h=(a-(r-s))/2,c=(u-(n-o))/2;return[s-h,o-c,r+h,n+c]}tms_to_wmts(t,e,i){return[t,Math.pow(2,i)-1-e,i]}wmts_to_tms(t,e,i){return[t,Math.pow(2,i)-1-e,i]}pixels_to_meters(t,e,i){const _=this.get_resolution(i);return[t*_-this.x_origin_offset,e*_-this.y_origin_offset]}meters_to_pixels(t,e,i){const _=this.get_resolution(i);return[(t+this.x_origin_offset)/_,(e+this.y_origin_offset)/_]}pixels_to_tile(t,e){let i=Math.ceil(t/this.tile_size);return[i=0===i?i:i-1,Math.max(Math.ceil(e/this.tile_size)-1,0)]}pixels_to_raster(t,e,i){return[t,(this.tile_size<<i)-e]}meters_to_tile(t,e,i){const[_,s]=this.meters_to_pixels(t,e,i);return this.pixels_to_tile(_,s)}get_tile_meter_bounds(t,e,i){const[_,s]=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),[o,r]=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i);return[_,s,o,r]}get_tile_geographic_bounds(t,e,i){const _=this.get_tile_meter_bounds(t,e,i),[s,o,n,l]=r.meters_extent_to_geographic(_);return[s,o,n,l]}get_tiles_by_extent(t,e,i=1){const[_,s,o,r]=t;let[n,l]=this.meters_to_tile(_,s,e),[a,u]=this.meters_to_tile(o,r,e);n-=i,l-=i,a+=i;const h=[];for(let t=u+=i;t>=l;t--)for(let i=n;i<=a;i++)this.is_valid_tile(i,t,e)&&h.push([i,t,e,this.get_tile_meter_bounds(i,t,e)]);return this.sort_tiles_from_center(h,[n,l,a,u]),h}quadkey_to_tile_xyz(t){let e=0,i=0;const _=t.length;for(let s=_;s>0;s--){const o=1<<s-1;switch(t.charAt(_-s)){case"0":continue;case"1":e|=o;break;case"2":i|=o;break;case"3":e|=o,i|=o;break;default:throw new TypeError(`Invalid Quadkey: ${t}`)}}return[e,i,_]}tile_xyz_to_quadkey(t,e,i){let _="";for(let s=i;s>0;s--){const i=1<<s-1;let o=0;0!=(t&i)&&(o+=1),0!=(e&i)&&(o+=2),_+=o.toString()}return _}children_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=[];for(let t=0;t<=3;t++){const[e,i,o]=this.quadkey_to_tile_xyz(_+t.toString()),r=this.get_tile_meter_bounds(e,i,o);s.push([e,i,o,r])}return s}get_closest_parent_by_tile_xyz(t,e,i){const _=this.calculate_world_x_by_tile_xyz(t,e,i);[t,e,i]=this.normalize_xyz(t,e,i);let s=this.tile_xyz_to_quadkey(t,e,i);for(;s.length>0;)if(s=s.substring(0,s.length-1),[t,e,i]=this.quadkey_to_tile_xyz(s),[t,e,i]=this.denormalize_xyz(t,e,i,_),this.tiles.has(this.tile_xyz_to_key(t,e,i)))return[t,e,i];return[0,0,0]}normalize_xyz(t,e,i){if(this.wrap_around){const _=Math.pow(2,i);return[(t%_+_)%_,e,i]}return[t,e,i]}denormalize_xyz(t,e,i,_){return[t+_*Math.pow(2,i),e,i]}denormalize_meters(t,e,i,_){return[t+2*_*Math.PI*6378137,e]}calculate_world_x_by_tile_xyz(t,e,i){return Math.floor(t/Math.pow(2,i))}}i.MercatorTileSource=n,n.__name__="MercatorTileSource",n.init_MercatorTileSource()},
function _(e,t,r){const i=e(64),n=e(18);class a extends i.Model{constructor(e){super(e)}static init_TileSource(){this.define({url:[n.String,""],tile_size:[n.Number,256],max_zoom:[n.Number,30],min_zoom:[n.Number,0],extra_url_vars:[n.Any,{}],attribution:[n.String,""],x_origin_offset:[n.Number],y_origin_offset:[n.Number],initial_resolution:[n.Number]})}initialize(){super.initialize(),this.tiles=new Map,this._normalize_case()}connect_signals(){super.connect_signals(),this.connect(this.change,()=>this._clear_cache())}string_lookup_replace(e,t){let r=e;for(const e in t){const i=t[e];r=r.replace(`{${e}}`,i)}return r}_normalize_case(){const e=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=e}_clear_cache(){this.tiles=new Map}tile_xyz_to_key(e,t,r){return`${e}:${t}:${r}`}key_to_tile_xyz(e){const[t,r,i]=e.split(":").map(e=>parseInt(e));return[t,r,i]}sort_tiles_from_center(e,t){const[r,i,n,a]=t,s=(n-r)/2+r,o=(a-i)/2+i;e.sort(function(e,t){return Math.sqrt(Math.pow(s-e[0],2)+Math.pow(o-e[1],2))-Math.sqrt(Math.pow(s-t[0],2)+Math.pow(o-t[1],2))})}get_image_url(e,t,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",t.toString()).replace("{Z}",r.toString())}}r.TileSource=a,a.__name__="TileSource",a.init_TileSource()},
function _(t,e,r){const n=t(30);function o(t,e){return n.wgs84_mercator.forward([t,e])}function c(t,e){return n.wgs84_mercator.inverse([t,e])}r.geographic_to_meters=o,r.meters_to_geographic=c,r.geographic_extent_to_meters=function(t){const[e,r,n,c]=t,[_,g]=o(e,r),[i,s]=o(n,c);return[_,g,i,s]},r.meters_extent_to_geographic=function(t){const[e,r,n,o]=t,[_,g]=c(e,r),[i,s]=c(n,o);return[_,g,i,s]}},
function _(e,t,r){const s=e(295);class _ extends s.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const s=this.string_lookup_replace(this.url,this.extra_url_vars),[_,o,c]=this.tms_to_wmts(e,t,r),i=this.tile_xyz_to_quadkey(_,o,c);return s.replace("{Q}",i)}}r.QUADKEYTileSource=_,_.__name__="QUADKEYTileSource"},
function _(e,t,i){const s=e(300),_=e(74),a=e(123),n=e(61),h=e(18),r=e(216),l=e(8),o=e(7),d=e(72),m=e(68),c=e(301);class u extends _.DataRendererView{initialize(){this._tiles=[],super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render()),this.connect(this.model.tile_source.change,()=>this.request_render())}get_extent(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]}get map_plot(){return this.plot_model}get map_canvas(){return this.plot_view.canvas_view.ctx}get map_frame(){return this.plot_view.frame}get x_range(){return this.map_plot.x_range}get y_range(){return this.map_plot.y_range}_set_data(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0}_update_attribution(){null!=this.attribution_el&&n.removeElement(this.attribution_el);const{attribution:e}=this.model.tile_source;if(o.isString(e)&&e.length>0){const{layout:t,frame:i}=this.plot_view,s=t._width.value-i._right.value,_=t._height.value-i._bottom.value,a=i._width.value;this.attribution_el=n.div({class:c.bk_tile_attribution,style:{position:"absolute",right:`${s}px`,bottom:`${_}px`,"max-width":`${a-4}px`,padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"7pt","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.events_el.appendChild(this.attribution_el),this.attribution_el.innerHTML=e,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}}_map_data(){this.initial_extent=this.get_extent();const e=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value),t=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value,e);this.x_range.start=t[0],this.y_range.start=t[1],this.x_range.end=t[2],this.y_range.end=t[3],this.x_range instanceof a.Range1d&&(this.x_range.reset_start=t[0],this.x_range.reset_end=t[2]),this.y_range instanceof a.Range1d&&(this.y_range.reset_start=t[1],this.y_range.reset_end=t[3]),this._update_attribution()}_create_tile(e,t,i,s,_=!1){const[a,n,h]=this.model.tile_source.normalize_xyz(e,t,i),l={img:void 0,tile_coords:[e,t,i],normalized_coords:[a,n,h],quadkey:this.model.tile_source.tile_xyz_to_quadkey(e,t,i),cache_key:this.model.tile_source.tile_xyz_to_key(e,t,i),bounds:s,loaded:!1,finished:!1,x_coord:s[0],y_coord:s[3]},o=this.model.tile_source.get_image_url(a,n,h);new r.ImageLoader(o,{loaded:e=>{Object.assign(l,{img:e,loaded:!0}),_?(l.finished=!0,this.notify_finished()):this.request_render()},failed(){l.finished=!0}}),this.model.tile_source.tiles.set(l.cache_key,l),this._tiles.push(l)}_enforce_aspect_ratio(){if(this._last_height!==this.map_frame._height.value||this._last_width!==this.map_frame._width.value){const e=this.get_extent(),t=this.model.tile_source.get_level_by_extent(e,this.map_frame._height.value,this.map_frame._width.value),i=this.model.tile_source.snap_to_zoom_level(e,this.map_frame._height.value,this.map_frame._width.value,t);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame._height.value,this._last_width=this.map_frame._width.value}}has_finished(){if(!super.has_finished())return!1;if(0===this._tiles.length)return!1;for(const e of this._tiles)if(!e.finished)return!1;return!0}render(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()}_draw_tile(e){const t=this.model.tile_source.tiles.get(e);if(null!=t&&t.loaded){const[[e],[i]]=this.plot_view.map_to_screen([t.bounds[0]],[t.bounds[3]]),[[s],[_]]=this.plot_view.map_to_screen([t.bounds[2]],[t.bounds[1]]),a=s-e,n=_-i,h=e,r=i,l=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(t.img,h,r,a,n),this.map_canvas.setImageSmoothingEnabled(l),t.finished=!0}}_set_rect(){const e=this.plot_model.properties.outline_line_width.value(),t=this.map_frame._left.value+e/2,i=this.map_frame._top.value+e/2,s=this.map_frame._width.value-e,_=this.map_frame._height.value-e;this.map_canvas.rect(t,i,s,_),this.map_canvas.clip()}_render_tiles(e){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(const t of e)this._draw_tile(t);this.map_canvas.restore()}_prefetch_tiles(){const{tile_source:e}=this.model,t=this.get_extent(),i=this.map_frame._height.value,s=this.map_frame._width.value,_=this.model.tile_source.get_level_by_extent(t,i,s),a=this.model.tile_source.get_tiles_by_extent(t,_);for(let t=0,i=Math.min(10,a.length);t<i;t++){const[i,s,_]=a[t],n=this.model.tile_source.children_by_tile_xyz(i,s,_);for(const t of n){const[i,s,_,a]=t;e.tiles.has(e.tile_xyz_to_key(i,s,_))||this._create_tile(i,s,_,a,!0)}}}_fetch_tiles(e){for(const t of e){const[e,i,s,_]=t;this._create_tile(e,i,s,_)}}_update(){const{tile_source:e}=this.model,{min_zoom:t}=e,{max_zoom:i}=e;let s=this.get_extent();const _=this.extent[2]-this.extent[0]<s[2]-s[0],a=this.map_frame._height.value,n=this.map_frame._width.value;let h=e.get_level_by_extent(s,a,n),r=!1;h<t?(s=this.extent,h=t,r=!0):h>i&&(s=this.extent,h=i,r=!0),r&&(this.x_range.setv({x_range:{start:s[0],end:s[2]}}),this.y_range.setv({start:s[1],end:s[3]}),this.extent=s),this.extent=s;const o=e.get_tiles_by_extent(s,h),d=[],m=[],c=[],u=[];for(const t of o){const[i,s,a]=t,n=e.tile_xyz_to_key(i,s,a),h=e.tiles.get(n);if(null!=h&&h.loaded)m.push(n);else if(this.model.render_parents){const[t,n,h]=e.get_closest_parent_by_tile_xyz(i,s,a),r=e.tile_xyz_to_key(t,n,h),o=e.tiles.get(r);if(null!=o&&o.loaded&&!l.includes(c,r)&&c.push(r),_){const t=e.children_by_tile_xyz(i,s,a);for(const[i,s,_]of t){const t=e.tile_xyz_to_key(i,s,_);e.tiles.has(t)&&u.push(t)}}}null==h&&d.push(t)}this._render_tiles(c),this._render_tiles(u),this._render_tiles(m),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout(()=>this._fetch_tiles(d),65)}}i.TileRendererView=u,u.__name__="TileRendererView";class p extends _.DataRenderer{constructor(e){super(e),this._selection_manager=new d.SelectionManager({source:new m.ColumnDataSource})}static init_TileRenderer(){this.prototype.default_view=u,this.define({alpha:[h.Number,1],smoothing:[h.Boolean,!0],tile_source:[h.Instance,()=>new s.WMTSTileSource],render_parents:[h.Boolean,!0]})}get_selection_manager(){return this._selection_manager}}i.TileRenderer=p,p.__name__="TileRenderer",p.init_TileRenderer()},
function _(t,e,r){const o=t(295);class s extends o.MercatorTileSource{constructor(t){super(t)}get_image_url(t,e,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars),[s,c,i]=this.tms_to_wmts(t,e,r);return o.replace("{X}",s.toString()).replace("{Y}",c.toString()).replace("{Z}",i.toString())}}r.WMTSTileSource=s,s.__name__="WMTSTileSource"},
function _(t,i,n){t(62),t(61).styles.append(".bk-root .bk-tile-attribution a {\n  color: black;\n}\n"),n.bk_tile_attribution="bk-tile-attribution"},
function _(e,r,t){const c=e(295);class o extends c.MercatorTileSource{constructor(e){super(e)}get_image_url(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())}}t.TMSTileSource=o,o.__name__="TMSTileSource"},
function _(e,a,r){var t=e(304);r.CanvasTexture=t.CanvasTexture;var u=e(306);r.ImageURLTexture=u.ImageURLTexture;var x=e(305);r.Texture=x.Texture},
function _(t,e,n){const r=t(305),s=t(18),c=t(25);class i extends r.Texture{constructor(t){super(t)}static init_CanvasTexture(){this.define({code:[s.String]})}get func(){const t=c.use_strict(this.code);return new Function("ctx","color","scale","weight","require","exports",t)}get_pattern(e,n,r){return s=>{const c=document.createElement("canvas");c.width=n,c.height=n;const i=c.getContext("2d");return this.func.call(this,i,e,n,r,t,{}),s.createPattern(c,this.repetition)}}}n.CanvasTexture=i,i.__name__="CanvasTexture",i.init_CanvasTexture()},
function _(e,t,i){const n=e(64),r=e(18);class o extends n.Model{constructor(e){super(e)}static init_Texture(){this.define({repetition:[r.TextureRepetition,"repeat"]})}onload(e){e()}}i.Texture=o,o.__name__="Texture",o.init_Texture()},
function _(e,t,i){const r=e(305),n=e(18),a=e(216);class s extends r.Texture{constructor(e){super(e)}static init_ImageURLTexture(){this.define({url:[n.String]})}initialize(){super.initialize(),this._loader=new a.ImageLoader(this.url)}get_pattern(e,t,i){return e=>this._loader.finished?e.createPattern(this._loader.image,this.repetition):null}onload(e){this._loader.promise.then(()=>e())}}i.ImageURLTexture=s,s.__name__="ImageURLTexture",s.init_ImageURLTexture()},
function _(o,l,T){var a=o(269);T.ActionTool=a.ActionTool;var r=o(308);T.CustomAction=r.CustomAction;var e=o(270);T.HelpTool=e.HelpTool;var v=o(309);T.RedoTool=v.RedoTool;var t=o(310);T.ResetTool=t.ResetTool;var n=o(311);T.SaveTool=n.SaveTool;var s=o(312);T.UndoTool=s.UndoTool;var P=o(313);T.ZoomInTool=P.ZoomInTool;var c=o(315);T.ZoomOutTool=c.ZoomOutTool;var i=o(263);T.ButtonTool=i.ButtonTool;var d=o(316);T.EditTool=d.EditTool;var m=o(317);T.BoxEditTool=m.BoxEditTool;var x=o(318);T.FreehandDrawTool=x.FreehandDrawTool;var y=o(319);T.PointDrawTool=y.PointDrawTool;var B=o(320);T.PolyDrawTool=B.PolyDrawTool;var S=o(321);T.PolyTool=S.PolyTool;var u=o(322);T.PolyEditTool=u.PolyEditTool;var b=o(323);T.BoxSelectTool=b.BoxSelectTool;var h=o(326);T.BoxZoomTool=h.BoxZoomTool;var Z=o(268);T.GestureTool=Z.GestureTool;var p=o(327);T.LassoSelectTool=p.LassoSelectTool;var w=o(328);T.PanTool=w.PanTool;var C=o(329);T.PolySelectTool=C.PolySelectTool;var D=o(330);T.RangeTool=D.RangeTool;var E=o(324);T.SelectTool=E.SelectTool;var H=o(331);T.TapTool=H.TapTool;var R=o(332);T.WheelPanTool=R.WheelPanTool;var A=o(333);T.WheelZoomTool=A.WheelZoomTool;var I=o(334);T.CrosshairTool=I.CrosshairTool;var W=o(335);T.CustomJSHover=W.CustomJSHover;var g=o(336);T.HoverTool=g.HoverTool;var F=o(262);T.InspectTool=F.InspectTool;var G=o(264);T.Tool=G.Tool;var J=o(337);T.ToolProxy=J.ToolProxy;var L=o(261);T.Toolbar=L.Toolbar;var O=o(267);T.ToolbarBase=O.ToolbarBase;var U=o(338);T.ProxyToolbar=U.ProxyToolbar;var f=o(338);T.ToolbarBox=f.ToolbarBox},
function _(t,o,i){const n=t(269),s=t(18),c=t(265);class e extends n.ActionToolButtonView{css_classes(){return super.css_classes().concat(c.bk_toolbar_button_custom_action)}}i.CustomActionButtonView=e,e.__name__="CustomActionButtonView";class _ extends n.ActionToolView{doit(){null!=this.model.callback&&this.model.callback.execute(this.model)}}i.CustomActionView=_,_.__name__="CustomActionView";class l extends n.ActionTool{constructor(t){super(t),this.tool_name="Custom Action",this.button_view=e}static init_CustomAction(){this.prototype.default_view=_,this.define({action_tooltip:[s.String,"Perform a Custom Action"],callback:[s.Any],icon:[s.String]})}get tooltip(){return this.action_tooltip}}i.CustomAction=l,l.__name__="CustomAction",l.init_CustomAction()},
function _(o,e,t){const i=o(269),s=o(271);class n extends i.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state_changed,()=>this.model.disabled=!this.plot_view.can_redo())}doit(){this.plot_view.redo()}}t.RedoToolView=n,n.__name__="RedoToolView";class _ extends i.ActionTool{constructor(o){super(o),this.tool_name="Redo",this.icon=s.bk_tool_icon_redo}static init_RedoTool(){this.prototype.default_view=n,this.override({disabled:!0})}}t.RedoTool=_,_.__name__="RedoTool",_.init_RedoTool()},
function _(e,o,t){const s=e(269),i=e(271);class _ extends s.ActionToolView{doit(){this.plot_view.reset()}}t.ResetToolView=_,_.__name__="ResetToolView";class n extends s.ActionTool{constructor(e){super(e),this.tool_name="Reset",this.icon=i.bk_tool_icon_reset}static init_ResetTool(){this.prototype.default_view=_}}t.ResetTool=n,n.__name__="ResetTool",n.init_ResetTool()},
function _(o,e,t){const i=o(269),_=o(271);class a extends i.ActionToolView{doit(){this.plot_view.save("bokeh_plot")}}t.SaveToolView=a,a.__name__="SaveToolView";class s extends i.ActionTool{constructor(o){super(o),this.tool_name="Save",this.icon=_.bk_tool_icon_save}static init_SaveTool(){this.prototype.default_view=a}}t.SaveTool=s,s.__name__="SaveTool",s.init_SaveTool()},
function _(o,n,t){const i=o(269),e=o(271);class s extends i.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state_changed,()=>this.model.disabled=!this.plot_view.can_undo())}doit(){this.plot_view.undo()}}t.UndoToolView=s,s.__name__="UndoToolView";class _ extends i.ActionTool{constructor(o){super(o),this.tool_name="Undo",this.icon=e.bk_tool_icon_undo}static init_UndoTool(){this.prototype.default_view=s,this.override({disabled:!0})}}t.UndoTool=_,_.__name__="UndoTool",_.init_UndoTool()},
function _(o,t,i){const e=o(269),n=o(314),s=o(18),_=o(271);class l extends e.ActionToolView{doit(){const o=this.plot_view.frame,t=this.model.dimensions,i="width"==t||"both"==t,e="height"==t||"both"==t,s=n.scale_range(o,this.model.factor,i,e);this.plot_view.push_state("zoom_out",{range:s}),this.plot_view.update_range(s,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)}}i.ZoomInToolView=l,l.__name__="ZoomInToolView";class m extends e.ActionTool{constructor(o){super(o),this.tool_name="Zoom In",this.icon=_.bk_tool_icon_zoom_in}static init_ZoomInTool(){this.prototype.default_view=l,this.define({factor:[s.Percent,.1],dimensions:[s.Dimensions,"both"]})}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}i.ZoomInTool=m,m.__name__="ZoomInTool",m.init_ZoomInTool()},
function _(n,t,o){const r=n(9);function c(n,t,o){const[r,c]=[n.start,n.end],s=null!=o?o:(c+r)/2;return[r-(r-s)*t,c-(c-s)*t]}function s(n,[t,o]){const r={};for(const c in n){const s=n[c],[e,l]=s.r_invert(t,o);r[c]={start:e,end:l}}return r}o.scale_highlow=c,o.get_info=s,o.scale_range=function(n,t,o=!0,e=!0,l){t=r.clamp(t,-.9,.9);const a=o?t:0,[i,u]=c(n.bbox.h_range,a,null!=l?l.x:void 0),f=s(n.xscales,[i,u]),_=e?t:0,[g,x]=c(n.bbox.v_range,_,null!=l?l.y:void 0);return{xrs:f,yrs:s(n.yscales,[g,x]),factor:t}}},
function _(o,t,i){const e=o(269),s=o(314),n=o(18),_=o(271);class l extends e.ActionToolView{doit(){const o=this.plot_view.frame,t=this.model.dimensions,i="width"==t||"both"==t,e="height"==t||"both"==t,n=s.scale_range(o,-this.model.factor,i,e);this.plot_view.push_state("zoom_out",{range:n}),this.plot_view.update_range(n,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)}}i.ZoomOutToolView=l,l.__name__="ZoomOutToolView";class m extends e.ActionTool{constructor(o){super(o),this.tool_name="Zoom Out",this.icon=_.bk_tool_icon_zoom_out}static init_ZoomOutTool(){this.prototype.default_view=l,this.define({factor:[n.Percent,.1],dimensions:[n.Dimensions,"both"]})}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}i.ZoomOutTool=m,m.__name__="ZoomOutTool",m.init_ZoomOutTool()},
function _(t,e,s){const o=t(18),n=t(8),i=t(7),_=t(268);class r extends _.GestureToolView{constructor(){super(...arguments),this._mouse_in_frame=!0}_move_enter(t){this._mouse_in_frame=!0}_move_exit(t){this._mouse_in_frame=!1}_map_drag(t,e,s){const o=this.plot_view.frame;return o.bbox.contains(t,e)?[o.xscales[s.x_range_name].invert(t),o.yscales[s.y_range_name].invert(e)]:null}_delete_selected(t){const e=t.data_source,s=e.selected.indices;s.sort();for(const t of e.columns()){const o=e.get_array(t);for(let t=0;t<s.length;t++){const e=s[t];o.splice(e-t,1)}}this._emit_cds_changes(e)}_pop_glyphs(t,e){const s=t.columns();if(e&&s.length)for(const o of s){let s=t.get_array(o);const n=s.length-e+1;n<1||(i.isArray(s)||(s=Array.from(s),t.data[o]=s),s.splice(0,n))}}_emit_cds_changes(t,e=!0,s=!0,o=!0){s&&t.selection_manager.clear(),e&&t.change.emit(),o&&(t.data=t.data,t.properties.data.change.emit())}_drag_points(t,e){if(null==this._basepoint)return;const[s,o]=this._basepoint;for(const n of e){const e=this._map_drag(s,o,n),i=this._map_drag(t.sx,t.sy,n);if(null==i||null==e)continue;const[_,r]=i,[a,c]=e,[l,d]=[_-a,r-c],m=n.glyph,u=n.data_source,[p,h]=[m.x.field,m.y.field];for(const t of u.selected.indices)p&&(u.data[p][t]+=l),h&&(u.data[h][t]+=d);u.change.emit()}this._basepoint=[t.sx,t.sy]}_pad_empty_columns(t,e){for(const s of t.columns())n.includes(e,s)||t.get_array(s).push(this.model.empty_value)}_select_event(t,e,s){const o=this.plot_view.frame,{sx:n,sy:i}=t;if(!o.bbox.contains(n,i))return[];const _={type:"point",sx:n,sy:i},r=[];for(const t of s){const s=t.get_selection_manager(),o=t.data_source,n=[this.plot_view.renderer_views[t.id]];s.select(n,_,!0,e)&&r.push(t),o.properties.selected.change.emit()}return r}}s.EditToolView=r,r.__name__="EditToolView";class a extends _.GestureTool{constructor(t){super(t)}static init_EditTool(){this.define({custom_icon:[o.String],custom_tooltip:[o.String],empty_value:[o.Any],renderers:[o.Array,[]]})}get tooltip(){return this.custom_tooltip||this.tool_name}get computed_icon(){return this.custom_icon||this.icon}}s.EditTool=a,a.__name__="EditTool",a.init_EditTool()},
function _(e,t,s){const i=e(61),_=e(18),o=e(316),n=e(271);class a extends o.EditToolView{_tap(e){if(null!=this._draw_basepoint||null!=this._basepoint)return;const t=e.shiftKey;this._select_event(e,t,this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)if(e.keyCode===i.Keys.Backspace)this._delete_selected(t);else if(e.keyCode==i.Keys.Esc){t.data_source.selection_manager.clear()}}_set_extent([e,t],[s,i],_,o=!1){const n=this.model.renderers[0],a=this.plot_view.frame,d=n.glyph,l=n.data_source,r=a.xscales[n.x_range_name],h=a.yscales[n.y_range_name],[p,u]=r.r_invert(e,t),[c,m]=h.r_invert(s,i),[f,b]=[(p+u)/2,(c+m)/2],[x,y]=[u-p,m-c],[w,g]=[d.x.field,d.y.field],[v,E]=[d.width.field,d.height.field];if(_)this._pop_glyphs(l,this.model.num_objects),w&&l.get_array(w).push(f),g&&l.get_array(g).push(b),v&&l.get_array(v).push(x),E&&l.get_array(E).push(y),this._pad_empty_columns(l,[w,g,v,E]);else{const e=l.data[w].length-1;w&&(l.data[w][e]=f),g&&(l.data[g][e]=b),v&&(l.data[v][e]=x),E&&(l.data[E][e]=y)}this._emit_cds_changes(l,!0,!1,o)}_update_box(e,t=!1,s=!1){if(null==this._draw_basepoint)return;const i=[e.sx,e.sy],_=this.plot_view.frame,o=this.model.dimensions,n=this.model._get_dim_limits(this._draw_basepoint,i,_,o);if(null!=n){const[e,i]=n;this._set_extent(e,i,t,s)}}_doubletap(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,!0,this.model.renderers),this._update_box(e,!0,!1)))}_move(e){this._update_box(e,!1,!1)}_pan_start(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,!0,this.model.renderers),this._basepoint=[e.sx,e.sy]}}_pan(e,t=!1,s=!1){if(e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,s)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}}_pan_end(e){if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0)}}}s.BoxEditToolView=a,a.__name__="BoxEditToolView";class d extends o.EditTool{constructor(e){super(e),this.tool_name="Box Edit Tool",this.icon=n.bk_tool_icon_box_edit,this.event_type=["tap","pan","move"],this.default_order=1}static init_BoxEditTool(){this.prototype.default_view=a,this.define({dimensions:[_.Dimensions,"both"],num_objects:[_.Int,0]})}}s.BoxEditTool=d,d.__name__="BoxEditTool",d.init_BoxEditTool()},
function _(e,t,a){const s=e(61),r=e(18),o=e(7),_=e(316),i=e(271);class d extends _.EditToolView{_draw(e,t,a=!1){if(!this.model.active)return;const s=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,s);if(null==r)return;const[_,i]=r,d=s.data_source,n=s.glyph,[h,l]=[n.xs.field,n.ys.field];if("new"==t)this._pop_glyphs(d,this.model.num_objects),h&&d.get_array(h).push([_]),l&&d.get_array(l).push([i]),this._pad_empty_columns(d,[h,l]);else if("add"==t){if(h){const e=d.data[h].length-1;let t=d.get_array(h)[e];o.isArray(t)||(t=Array.from(t),d.data[h][e]=t),t.push(_)}if(l){const e=d.data[l].length-1;let t=d.get_array(l)[e];o.isArray(t)||(t=Array.from(t),d.data[l][e]=t),t.push(i)}}this._emit_cds_changes(d,!0,!0,a)}_pan_start(e){this._draw(e,"new")}_pan(e){this._draw(e,"add")}_pan_end(e){this._draw(e,"add",!0)}_tap(e){this._select_event(e,e.shiftKey,this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===s.Keys.Esc?t.data_source.selection_manager.clear():e.keyCode===s.Keys.Backspace&&this._delete_selected(t)}}a.FreehandDrawToolView=d,d.__name__="FreehandDrawToolView";class n extends _.EditTool{constructor(e){super(e),this.tool_name="Freehand Draw Tool",this.icon=i.bk_tool_icon_freehand_draw,this.event_type=["pan","tap"],this.default_order=3}static init_FreehandDrawTool(){this.prototype.default_view=d,this.define({num_objects:[r.Int,0]})}}a.FreehandDrawTool=n,n.__name__="FreehandDrawTool",n.init_FreehandDrawTool()},
function _(e,t,s){const o=e(61),i=e(18),a=e(316),n=e(271);class _ extends a.EditToolView{_tap(e){const t=e.shiftKey;if(this._select_event(e,t,this.model.renderers).length||!this.model.add)return;const s=this.model.renderers[0],o=this._map_drag(e.sx,e.sy,s);if(null==o)return;const i=s.glyph,a=s.data_source,[n,_]=[i.x.field,i.y.field],[r,d]=o;this._pop_glyphs(a,this.model.num_objects),n&&a.get_array(n).push(r),_&&a.get_array(_).push(d),this._pad_empty_columns(a,[n,_]),a.change.emit(),a.data=a.data,a.properties.data.change.emit()}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===o.Keys.Backspace?this._delete_selected(t):e.keyCode==o.Keys.Esc&&t.data_source.selection_manager.clear()}_pan_start(e){this.model.drag&&(this._select_event(e,!0,this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0);this._basepoint=null}}}s.PointDrawToolView=_,_.__name__="PointDrawToolView";class r extends a.EditTool{constructor(e){super(e),this.tool_name="Point Draw Tool",this.icon=n.bk_tool_icon_point_draw,this.event_type=["tap","pan","move"],this.default_order=2}static init_PointDrawTool(){this.prototype.default_view=_,this.define({add:[i.Boolean,!0],drag:[i.Boolean,!0],num_objects:[i.Int,0]})}}s.PointDrawTool=r,r.__name__="PointDrawTool",r.init_PointDrawTool()},
function _(e,t,s){const i=e(61),a=e(18),r=e(7),o=e(321),n=e(271);class _ extends o.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._initialized=!1}_tap(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,e.shiftKey,this.model.renderers)}_draw(e,t,s=!1){const i=this.model.renderers[0],a=this._map_drag(e.sx,e.sy,i);if(this._initialized||this.activate(),null==a)return;const[o,n]=this._snap_to_vertex(e,...a),_=i.data_source,d=i.glyph,[l,h]=[d.xs.field,d.ys.field];if("new"==t)this._pop_glyphs(_,this.model.num_objects),l&&_.get_array(l).push([o,o]),h&&_.get_array(h).push([n,n]),this._pad_empty_columns(_,[l,h]);else if("edit"==t){if(l){const e=_.data[l][_.data[l].length-1];e[e.length-1]=o}if(h){const e=_.data[h][_.data[h].length-1];e[e.length-1]=n}}else if("add"==t){if(l){const e=_.data[l].length-1;let t=_.get_array(l)[e];const s=t[t.length-1];t[t.length-1]=o,r.isArray(t)||(t=Array.from(t),_.data[l][e]=t),t.push(s)}if(h){const e=_.data[h].length-1;let t=_.get_array(h)[e];const s=t[t.length-1];t[t.length-1]=n,r.isArray(t)||(t=Array.from(t),_.data[h][e]=t),t.push(s)}}this._emit_cds_changes(_,!0,!1,s)}_show_vertices(){if(!this.model.active)return;const e=[],t=[];for(let s=0;s<this.model.renderers.length;s++){const i=this.model.renderers[s],a=i.data_source,r=i.glyph,[o,n]=[r.xs.field,r.ys.field];if(o)for(const t of a.get_array(o))Array.prototype.push.apply(e,t);if(n)for(const e of a.get_array(n))Array.prototype.push.apply(t,e);this._drawing&&s==this.model.renderers.length-1&&(e.splice(e.length-1,1),t.splice(t.length-1,1))}this._set_vertices(e,t)}_doubletap(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))}_move(e){this._drawing&&this._draw(e,"edit")}_remove(){const e=this.model.renderers[0],t=e.data_source,s=e.glyph,[i,a]=[s.xs.field,s.ys.field];if(i){const e=t.data[i].length-1,s=t.get_array(i)[e];s.splice(s.length-1,1)}if(a){const e=t.data[a].length-1,s=t.get_array(a)[e];s.splice(s.length-1,1)}this._emit_cds_changes(t)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===i.Keys.Backspace?this._delete_selected(t):e.keyCode==i.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),t.data_source.selection_manager.clear())}_pan_start(e){this.model.drag&&(this._select_event(e,!0,this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){if(null==this._basepoint||!this.model.drag)return;const[t,s]=this._basepoint;for(const i of this.model.renderers){const a=this._map_drag(t,s,i),r=this._map_drag(e.sx,e.sy,i);if(null==r||null==a)continue;const o=i.data_source,n=i.glyph,[_,d]=[n.xs.field,n.ys.field];if(!_&&!d)continue;const[l,h]=r,[c,g]=a,[p,f]=[l-c,h-g];for(const e of o.selected.indices){let t,s,i;_&&(s=o.data[_][e]),t=d?(i=o.data[d][e]).length:s.length;for(let e=0;e<t;e++)s&&(s[e]+=p),i&&(i[e]+=f)}o.change.emit()}this._basepoint=[e.sx,e.sy]}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source);this._basepoint=null}}activate(){if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(const e of this.model.renderers){const t=e.data_source;t.connect(t.properties.data.change,()=>this._show_vertices())}this._initialized=!0}}deactivate(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()}}s.PolyDrawToolView=_,_.__name__="PolyDrawToolView";class d extends o.PolyTool{constructor(e){super(e),this.tool_name="Polygon Draw Tool",this.icon=n.bk_tool_icon_poly_draw,this.event_type=["pan","tap","move"],this.default_order=3}static init_PolyDrawTool(){this.prototype.default_view=_,this.define({drag:[a.Boolean,!0],num_objects:[a.Int,0]})}}s.PolyDrawTool=d,d.__name__="PolyDrawTool",d.init_PolyDrawTool()},
function _(e,t,r){const o=e(18),s=e(7),i=e(316);class l extends i.EditToolView{_set_vertices(e,t){const r=this.model.vertex_renderer.glyph,o=this.model.vertex_renderer.data_source,[i,l]=[r.x.field,r.y.field];i&&(s.isArray(e)?o.data[i]=e:r.x={value:e}),l&&(s.isArray(t)?o.data[l]=t:r.y={value:t}),this._emit_cds_changes(o,!0,!0,!1)}_hide_vertices(){this._set_vertices([],[])}_snap_to_vertex(e,t,r){if(this.model.vertex_renderer){const o=this._select_event(e,!1,[this.model.vertex_renderer]),s=this.model.vertex_renderer.data_source,i=this.model.vertex_renderer.glyph,[l,_]=[i.x.field,i.y.field];if(o.length){const e=s.selected.indices[0];l&&(t=s.data[l][e]),_&&(r=s.data[_][e]),s.selection_manager.clear()}}return[t,r]}}r.PolyToolView=l,l.__name__="PolyToolView";class _ extends i.EditTool{constructor(e){super(e)}static init_PolyTool(){this.prototype.default_view=l,this.define({vertex_renderer:[o.Instance]})}}r.PolyTool=_,_.__name__="PolyTool",_.init_PolyTool()},
function _(e,t,s){const r=e(61),i=e(7),_=e(321),d=e(271);class n extends _.PolyToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null==t)return;const[s,r]=t,i=this._select_event(e,!1,[this.model.vertex_renderer]),_=this.model.vertex_renderer.data_source,d=this.model.vertex_renderer.glyph,[n,l]=[d.x.field,d.y.field];if(i.length&&null!=this._selected_renderer){const e=_.selected.indices[0];this._drawing?(this._drawing=!1,_.selection_manager.clear()):(_.selected.indices=[e+1],n&&_.get_array(n).splice(e+1,0,s),l&&_.get_array(l).splice(e+1,0,r),this._drawing=!0),_.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}_show_vertices(e){if(!this.model.active)return;const t=this._select_event(e,!1,this.model.renderers);if(!t.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);const s=t[0],r=s.glyph,_=s.data_source,d=_.selected.indices[0],[n,l]=[r.xs.field,r.ys.field];let a,c;n?(a=_.data[n][d],i.isArray(a)||(_.data[n][d]=a=Array.from(a))):a=r.xs.value,l?(c=_.data[l][d],i.isArray(c)||(_.data[l][d]=c=Array.from(c))):c=r.ys.value,this._selected_renderer=s,this._set_vertices(a,c)}_move(e){if(this._drawing&&null!=this._selected_renderer){const t=this.model.vertex_renderer,s=t.data_source,r=t.glyph,i=this._map_drag(e.sx,e.sy,t);if(null==i)return;let[_,d]=i;const n=s.selected.indices;[_,d]=this._snap_to_vertex(e,_,d),s.selected.indices=n;const[l,a]=[r.x.field,r.y.field],c=n[0];l&&(s.data[l][c]=_),a&&(s.data[a][c]=d),s.change.emit(),this._selected_renderer.data_source.change.emit()}}_tap(e){const t=this.model.vertex_renderer,s=this._map_drag(e.sx,e.sy,t);if(null==s)return;if(this._drawing&&this._selected_renderer){let[r,i]=s;const _=t.data_source,d=t.glyph,[n,l]=[d.x.field,d.y.field],a=_.selected.indices;[r,i]=this._snap_to_vertex(e,r,i);const c=a[0];if(_.selected.indices=[c+1],n){const e=_.get_array(n),t=e[c];e[c]=r,e.splice(c+1,0,t)}if(l){const e=_.get_array(l),t=e[c];e[c]=i,e.splice(c+1,0,t)}return _.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}const r=e.shiftKey;this._select_event(e,r,[t]),this._select_event(e,r,this.model.renderers)}_remove_vertex(){if(!this._drawing||!this._selected_renderer)return;const e=this.model.vertex_renderer,t=e.data_source,s=e.glyph,r=t.selected.indices[0],[i,_]=[s.x.field,s.y.field];i&&t.get_array(i).splice(r,1),_&&t.get_array(_).splice(r,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}_pan_start(e){this._select_event(e,!0,[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}_keyup(e){if(!this.model.active||!this._mouse_in_frame)return;let t;t=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;for(const s of t)e.keyCode===r.Keys.Backspace?(this._delete_selected(s),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==r.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),s.data_source.selection_manager.clear())}deactivate(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())}}s.PolyEditToolView=n,n.__name__="PolyEditToolView";class l extends _.PolyTool{constructor(e){super(e),this.tool_name="Poly Edit Tool",this.icon=d.bk_tool_icon_poly_edit,this.event_type=["tap","pan","move"],this.default_order=4}static init_PolyEditTool(){this.prototype.default_view=n}}s.PolyEditTool=l,l.__name__="PolyEditTool",l.init_PolyEditTool()},
function _(e,t,o){const s=e(324),l=e(99),i=e(18),n=e(271);class _ extends s.SelectToolView{_compute_limits(e){const t=this.plot_view.frame,o=this.model.dimensions;let s=this._base_point;if("center"==this.model.origin){const[t,o]=s,[l,i]=e;s=[t-(l-t),o-(i-o)]}return this.model._get_dim_limits(s,e,t,o)}_pan_start(e){const{sx:t,sy:o}=e;this._base_point=[t,o]}_pan(e){const{sx:t,sy:o}=e,s=[t,o],[l,i]=this._compute_limits(s);if(this.model.overlay.update({left:l[0],right:l[1],top:i[0],bottom:i[1]}),this.model.select_every_mousemove){const t=e.shiftKey;this._do_select(l,i,!1,t)}}_pan_end(e){const{sx:t,sy:o}=e,s=[t,o],[l,i]=this._compute_limits(s),n=e.shiftKey;this._do_select(l,i,!0,n),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.push_state("box_select",{selection:this.plot_view.get_selection()})}_do_select([e,t],[o,s],l,i=!1){const n={type:"rect",sx0:e,sx1:t,sy0:o,sy1:s};this._select(n,l,i)}_emit_callback(e){const t=this.computed_renderers[0],o=this.plot_view.frame,s=o.xscales[t.x_range_name],l=o.yscales[t.y_range_name],{sx0:i,sx1:n,sy0:_,sy1:c}=e,[a,r]=s.r_invert(i,n),[h,m]=l.r_invert(_,c),u=Object.assign({x0:a,y0:h,x1:r,y1:m},e);null!=this.model.callback&&this.model.callback.execute(this.model,{geometry:u})}}o.BoxSelectToolView=_,_.__name__="BoxSelectToolView";const c=()=>new l.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}});class a extends s.SelectTool{constructor(e){super(e),this.tool_name="Box Select",this.icon=n.bk_tool_icon_box_select,this.event_type="pan",this.default_order=30}static init_BoxSelectTool(){this.prototype.default_view=_,this.define({dimensions:[i.Dimensions,"both"],select_every_mousemove:[i.Boolean,!1],callback:[i.Any],overlay:[i.Instance,c],origin:[i.BoxOrigin,"corner"]})}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}o.BoxSelectTool=a,a.__name__="BoxSelectTool",a.init_BoxSelectTool()},
function _(e,t,s){const r=e(268),n=e(73),o=e(90),i=e(325),c=e(18),_=e(61),l=e(274);class a extends r.GestureToolView{get computed_renderers(){const e=this.model.renderers,t=this.plot_model.renderers,s=this.model.names;return i.compute_renderers(e,t,s)}_computed_renderers_by_data_source(){const e={};for(const t of this.computed_renderers){let s;if(t instanceof n.GlyphRenderer)s=t.data_source.id;else{if(!(t instanceof o.GraphRenderer))continue;s=t.node_renderer.data_source.id}s in e||(e[s]=[]),e[s].push(t)}return e}_keyup(e){if(e.keyCode==_.Keys.Esc){for(const e of this.computed_renderers)e.get_selection_manager().clear();this.plot_view.request_render()}}_select(e,t,s){const r=this._computed_renderers_by_data_source();for(const n in r){const o=r[n],i=o[0].get_selection_manager(),c=[];for(const e of o)e.id in this.plot_view.renderer_views&&c.push(this.plot_view.renderer_views[e.id]);i.select(c,e,t,s)}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)}_emit_selection_event(e,t=!0){const{frame:s}=this.plot_view,r=s.xscales.default,n=s.yscales.default;let o;switch(e.type){case"point":{const{sx:t,sy:s}=e,i=r.invert(t),c=n.invert(s);o=Object.assign(Object.assign({},e),{x:i,y:c});break}case"rect":{const{sx0:t,sx1:s,sy0:i,sy1:c}=e,[_,l]=r.r_invert(t,s),[a,d]=n.r_invert(i,c);o=Object.assign(Object.assign({},e),{x0:_,y0:a,x1:l,y1:d});break}case"poly":{const{sx:t,sy:s}=e,i=r.v_invert(t),c=n.v_invert(s);o=Object.assign(Object.assign({},e),{x:i,y:c});break}default:throw new Error(`Unrecognized selection geometry type: '${e.type}'`)}this.plot_model.trigger_event(new l.SelectionGeometry(o,t))}}s.SelectToolView=a,a.__name__="SelectToolView";class d extends r.GestureTool{constructor(e){super(e)}static init_SelectTool(){this.define({renderers:[c.Any,"auto"],names:[c.Array,[]]})}}s.SelectTool=d,d.__name__="SelectTool",d.init_SelectTool()},
function _(n,e,t){const r=n(8);t.compute_renderers=function(n,e,t){if(null==n)return[];let u="auto"==n?e:n;return t.length>0&&(u=u.filter(n=>r.includes(t,n.name))),u}},
function _(t,o,e){const s=t(268),i=t(99),n=t(18),a=t(271);class l extends s.GestureToolView{_match_aspect(t,o,e){const s=e.bbox.aspect,i=e.bbox.h_range.end,n=e.bbox.h_range.start,a=e.bbox.v_range.end,l=e.bbox.v_range.start;let _=Math.abs(t[0]-o[0]),r=Math.abs(t[1]-o[1]);const h=0==r?0:_/r,[c]=h>=s?[1,h/s]:[s/h,1];let m,p,u,d;return t[0]<=o[0]?(m=t[0],(p=t[0]+_*c)>i&&(p=i)):(p=t[0],(m=t[0]-_*c)<n&&(m=n)),_=Math.abs(p-m),t[1]<=o[1]?(d=t[1],(u=t[1]+_/s)>a&&(u=a)):(u=t[1],(d=t[1]-_/s)<l&&(d=l)),r=Math.abs(u-d),t[0]<=o[0]?p=t[0]+s*r:m=t[0]-s*r,[[m,p],[d,u]]}_compute_limits(t){const o=this.plot_view.frame,e=this.model.dimensions;let s,i,n=this._base_point;if("center"==this.model.origin){const[o,e]=n,[s,i]=t;n=[o-(s-o),e-(i-e)]}return this.model.match_aspect&&"both"==e?[s,i]=this._match_aspect(n,t,o):[s,i]=this.model._get_dim_limits(n,t,o,e),[s,i]}_pan_start(t){this._base_point=[t.sx,t.sy]}_pan(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this.model.overlay.update({left:e[0],right:e[1],top:s[0],bottom:s[1]})}_pan_end(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this._update(e,s),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null}_update([t,o],[e,s]){if(Math.abs(o-t)<=5||Math.abs(s-e)<=5)return;const{xscales:i,yscales:n}=this.plot_view.frame,a={};for(const e in i){const s=i[e],[n,l]=s.r_invert(t,o);a[e]={start:n,end:l}}const l={};for(const t in n){const o=n[t],[i,a]=o.r_invert(e,s);l[t]={start:i,end:a}}const _={xrs:a,yrs:l};this.plot_view.push_state("box_zoom",{range:_}),this.plot_view.update_range(_)}}e.BoxZoomToolView=l,l.__name__="BoxZoomToolView";const _=()=>new i.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}});class r extends s.GestureTool{constructor(t){super(t),this.tool_name="Box Zoom",this.icon=a.bk_tool_icon_box_zoom,this.event_type="pan",this.default_order=20}static init_BoxZoomTool(){this.prototype.default_view=l,this.define({dimensions:[n.Dimensions,"both"],overlay:[n.Instance,_],match_aspect:[n.Boolean,!1],origin:[n.BoxOrigin,"corner"]})}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}e.BoxZoomTool=r,r.__name__="BoxZoomTool",r.init_BoxZoomTool()},
function _(e,s,t){const l=e(324),a=e(131),o=e(61),i=e(18),_=e(271);class c extends l.SelectToolView{initialize(){super.initialize(),this.data=null}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._active_change())}_active_change(){this.model.active||this._clear_overlay()}_keyup(e){e.keyCode==o.Keys.Enter&&this._clear_overlay()}_pan_start(e){const{sx:s,sy:t}=e;this.data={sx:[s],sy:[t]}}_pan(e){const{sx:s,sy:t}=e,[l,a]=this.plot_view.frame.bbox.clip(s,t);if(this.data.sx.push(l),this.data.sy.push(a),this.model.overlay.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove){const s=e.shiftKey;this._do_select(this.data.sx,this.data.sy,!1,s)}}_pan_end(e){this._clear_overlay();const s=e.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,s),this.plot_view.push_state("lasso_select",{selection:this.plot_view.get_selection()})}_clear_overlay(){this.model.overlay.update({xs:[],ys:[]})}_do_select(e,s,t,l){const a={type:"poly",sx:e,sy:s};this._select(a,t,l)}_emit_callback(e){const s=this.computed_renderers[0],t=this.plot_view.frame,l=t.xscales[s.x_range_name],a=t.yscales[s.y_range_name],o=l.v_invert(e.sx),i=a.v_invert(e.sy),_=Object.assign({x:o,y:i},e);null!=this.model.callback&&this.model.callback.execute(this.model,{geometry:_})}}t.LassoSelectToolView=c,c.__name__="LassoSelectToolView";const n=()=>new a.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}});class h extends l.SelectTool{constructor(e){super(e),this.tool_name="Lasso Select",this.icon=_.bk_tool_icon_lasso_select,this.event_type="pan",this.default_order=12}static init_LassoSelectTool(){this.prototype.default_view=c,this.define({select_every_mousemove:[i.Boolean,!0],callback:[i.Any],overlay:[i.Instance,n]})}}t.LassoSelectTool=h,h.__name__="LassoSelectTool",h.init_LassoSelectTool()},
function _(t,s,n){const i=t(268),o=t(18),e=t(271);class a extends i.GestureToolView{_pan_start(t){this.last_dx=0,this.last_dy=0;const{sx:s,sy:n}=t,i=this.plot_view.frame.bbox;if(!i.contains(s,n)){const t=i.h_range,o=i.v_range;(s<t.start||s>t.end)&&(this.v_axis_only=!0),(n<o.start||n>o.end)&&(this.h_axis_only=!0)}null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}_pan(t){this._update(t.deltaX,t.deltaY),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}_pan_end(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.push_state("pan",{range:this.pan_info})}_update(t,s){const n=this.plot_view.frame,i=t-this.last_dx,o=s-this.last_dy,e=n.bbox.h_range,a=e.start-i,_=e.end-i,l=n.bbox.v_range,h=l.start-o,d=l.end-o,r=this.model.dimensions;let c,p,m,u,x,y;"width"!=r&&"both"!=r||this.v_axis_only?(c=e.start,p=e.end,m=0):(c=a,p=_,m=-i),"height"!=r&&"both"!=r||this.h_axis_only?(u=l.start,x=l.end,y=0):(u=h,x=d,y=-o),this.last_dx=t,this.last_dy=s;const{xscales:v,yscales:b}=n,f={};for(const t in v){const s=v[t],[n,i]=s.r_invert(c,p);f[t]={start:n,end:i}}const g={};for(const t in b){const s=b[t],[n,i]=s.r_invert(u,x);g[t]={start:n,end:i}}this.pan_info={xrs:f,yrs:g,sdx:m,sdy:y},this.plot_view.update_range(this.pan_info,!0)}}n.PanToolView=a,a.__name__="PanToolView";class _ extends i.GestureTool{constructor(t){super(t),this.tool_name="Pan",this.event_type="pan",this.default_order=10}static init_PanTool(){this.prototype.default_view=a,this.define({dimensions:[o.Dimensions,"both"]})}get tooltip(){return this._get_dim_tooltip("Pan",this.dimensions)}get icon(){switch(this.dimensions){case"both":return e.bk_tool_icon_pan;case"width":return e.bk_tool_icon_xpan;case"height":return e.bk_tool_icon_ypan}}}n.PanTool=_,_.__name__="PanTool",_.init_PanTool()},
function _(e,t,s){const l=e(324),a=e(131),i=e(61),o=e(18),c=e(8),_=e(271);class n extends l.SelectToolView{initialize(){super.initialize(),this.data={sx:[],sy:[]}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._active_change())}_active_change(){this.model.active||this._clear_data()}_keyup(e){e.keyCode==i.Keys.Enter&&this._clear_data()}_doubletap(e){const t=e.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,t),this.plot_view.push_state("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()}_clear_data(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})}_tap(e){const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)&&(this.data.sx.push(t),this.data.sy.push(s),this.model.overlay.update({xs:c.copy(this.data.sx),ys:c.copy(this.data.sy)}))}_do_select(e,t,s,l){const a={type:"poly",sx:e,sy:t};this._select(a,s,l)}_emit_callback(e){const t=this.computed_renderers[0],s=this.plot_view.frame,l=s.xscales[t.x_range_name],a=s.yscales[t.y_range_name],i=l.v_invert(e.sx),o=a.v_invert(e.sy),c=Object.assign({x:i,y:o},e);null!=this.model.callback&&this.model.callback.execute(this.model,{geometry:c})}}s.PolySelectToolView=n,n.__name__="PolySelectToolView";const h=()=>new a.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}});class y extends l.SelectTool{constructor(e){super(e),this.tool_name="Poly Select",this.icon=_.bk_tool_icon_polygon_select,this.event_type="tap",this.default_order=11}static init_PolySelectTool(){this.prototype.default_view=n,this.define({callback:[o.Any],overlay:[o.Instance,h]})}}s.PolySelectTool=y,y.__name__="PolySelectTool",y.init_PolySelectTool()},
function _(e,t,s){const i=e(99),n=e(65),l=e(18),a=e(268),r=e(271);function o(e){switch(e){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return e}}function h(e,t,s,i){if(null==t)return!1;const n=s.compute(t);return Math.abs(e-n)<i}function _(e,t,s,i,n){let l=!0;if(null!=n.left&&null!=n.right){const t=s.invert(e);(t<n.left||t>n.right)&&(l=!1)}if(null!=n.bottom&&null!=n.top){const e=i.invert(t);(e<n.bottom||e>n.top)&&(l=!1)}return l}function d(e,t,s){let i=0;return e>=s.start&&e<=s.end&&(i+=1),t>=s.start&&t<=s.end&&(i+=1),i}function u(e,t,s,i){const n=t.compute(e),l=t.invert(n+s);return l>=i.start&&l<=i.end?l:e}function c(e,t,s){return e>t.start?(t.end=e,s):(t.end=t.start,t.start=e,o(s))}function g(e,t,s){return e<t.end?(t.start=e,s):(t.start=t.end,t.end=e,o(s))}function y(e,t,s,i){const[n,l]=t.r_compute(e.start,e.end),[a,r]=t.r_invert(n+s,l+s),o=d(e.start,e.end,i);d(a,r,i)>=o&&(e.start=a,e.end=r)}s.flip_side=o,s.is_near=h,s.is_inside=_,s.sides_inside=d,s.compute_value=u,s.update_range_end_side=c,s.update_range_start_side=g,s.update_range=y;class f extends a.GestureToolView{initialize(){super.initialize(),this.side=0,this.model.update_overlay_from_ranges()}connect_signals(){super.connect_signals(),null!=this.model.x_range&&this.connect(this.model.x_range.change,()=>this.model.update_overlay_from_ranges()),null!=this.model.y_range&&this.connect(this.model.y_range.change,()=>this.model.update_overlay_from_ranges())}_pan_start(e){this.last_dx=0,this.last_dy=0;const t=this.model.x_range,s=this.model.y_range,n=this.plot_view.frame,l=n.xscales.default,a=n.yscales.default,r=this.model.overlay,{left:o,right:d,top:u,bottom:c}=r,g=this.model.overlay.properties.line_width.value()+i.EDGE_TOLERANCE;null!=t&&this.model.x_interaction&&(h(e.sx,o,l,g)?this.side=1:h(e.sx,d,l,g)?this.side=2:_(e.sx,e.sy,l,a,r)&&(this.side=3)),null!=s&&this.model.y_interaction&&(0==this.side&&h(e.sy,c,a,g)&&(this.side=4),0==this.side&&h(e.sy,u,a,g)?this.side=5:_(e.sx,e.sy,l,a,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))}_pan(e){const t=this.plot_view.frame,s=e.deltaX-this.last_dx,i=e.deltaY-this.last_dy,n=this.model.x_range,l=this.model.y_range,a=t.xscales.default,r=t.yscales.default;if(null!=n)if(3==this.side||7==this.side)y(n,a,s,t.x_range);else if(1==this.side){const e=u(n.start,a,s,t.x_range);this.side=g(e,n,this.side)}else if(2==this.side){const e=u(n.end,a,s,t.x_range);this.side=c(e,n,this.side)}if(null!=l)if(6==this.side||7==this.side)y(l,r,i,t.y_range);else if(4==this.side){const e=u(l.start,r,i,t.y_range);this.side=g(e,l,this.side)}else if(5==this.side){const e=u(l.end,r,i,t.y_range);this.side=c(e,l,this.side)}this.last_dx=e.deltaX,this.last_dy=e.deltaY}_pan_end(e){this.side=0}}s.RangeToolView=f,f.__name__="RangeToolView";const v=()=>new i.BoxAnnotation({level:"overlay",render_mode:"canvas",fill_color:"lightgrey",fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:.5},line_dash:[2,2]});class m extends a.GestureTool{constructor(e){super(e),this.tool_name="Range Tool",this.icon=r.bk_tool_icon_range,this.event_type="pan",this.default_order=1}static init_RangeTool(){this.prototype.default_view=f,this.define({x_range:[l.Instance,null],x_interaction:[l.Boolean,!0],y_range:[l.Instance,null],y_interaction:[l.Boolean,!0],overlay:[l.Instance,v]})}initialize(){super.initialize(),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null}update_overlay_from_ranges(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,n.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)}}s.RangeTool=m,m.__name__="RangeTool",m.init_RangeTool()},
function _(e,t,s){const i=e(324),o=e(18),n=e(271);class a extends i.SelectToolView{_tap(e){const{sx:t,sy:s}=e,i={type:"point",sx:t,sy:s},o=e.shiftKey;this._select(i,!0,o)}_select(e,t,s){const i=this.model.callback;if("select"==this.model.behavior){const o=this._computed_renderers_by_data_source();for(const n in o){const a=o[n],c=a[0].get_selection_manager(),_=a.map(e=>this.plot_view.renderer_views[e.id]);if(c.select(_,e,t,s)&&null!=i){const{frame:t}=this.plot_view,s=t.xscales[a[0].x_range_name],o=t.yscales[a[0].y_range_name],n=s.invert(e.sx),_=o.invert(e.sy),l={geometries:Object.assign(Object.assign({},e),{x:n,y:_}),source:c.source};i.execute(this.model,l)}}this._emit_selection_event(e),this.plot_view.push_state("tap",{selection:this.plot_view.get_selection()})}else for(const t of this.computed_renderers){const s=t.get_selection_manager();if(s.inspect(this.plot_view.renderer_views[t.id],e)&&null!=i){const{frame:o}=this.plot_view,n=o.xscales[t.x_range_name],a=o.yscales[t.y_range_name],c=n.invert(e.sx),_=a.invert(e.sy),l={geometries:Object.assign(Object.assign({},e),{x:c,y:_}),source:s.source};i.execute(this.model,l)}}}}s.TapToolView=a,a.__name__="TapToolView";class c extends i.SelectTool{constructor(e){super(e),this.tool_name="Tap",this.icon=n.bk_tool_icon_tap_select,this.event_type="tap",this.default_order=10}static init_TapTool(){this.prototype.default_view=a,this.define({behavior:[o.TapBehavior,"select"],callback:[o.Any]})}}s.TapTool=c,c.__name__="TapTool",c.init_TapTool()},
function _(e,t,s){const o=e(268),n=e(18),i=e(271);class a extends o.GestureToolView{_scroll(e){let t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)}_update_ranges(e){const{frame:t}=this.plot_view,s=t.bbox.h_range,o=t.bbox.v_range,[n,i]=[s.start,s.end],[a,l]=[o.start,o.end];let h,r,_,d;switch(this.model.dimension){case"height":{const t=Math.abs(l-a);h=n,r=i,_=a-t*e,d=l-t*e;break}case"width":{const t=Math.abs(i-n);h=n-t*e,r=i-t*e,_=a,d=l;break}default:throw new Error("this shouldn't have happened")}const{xscales:c,yscales:p}=t,m={};for(const e in c){const t=c[e],[s,o]=t.r_invert(h,r);m[e]={start:s,end:o}}const u={};for(const e in p){const t=p[e],[s,o]=t.r_invert(_,d);u[e]={start:s,end:o}}const w={xrs:m,yrs:u,factor:e};this.plot_view.push_state("wheel_pan",{range:w}),this.plot_view.update_range(w,!1,!0),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}}s.WheelPanToolView=a,a.__name__="WheelPanToolView";class l extends o.GestureTool{constructor(e){super(e),this.tool_name="Wheel Pan",this.icon=i.bk_tool_icon_wheel_pan,this.event_type="scroll",this.default_order=12}static init_WheelPanTool(){this.prototype.default_view=a,this.define({dimension:[n.Dimension,"width"]}),this.internal({speed:[n.Number,.001]})}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimension)}}s.WheelPanTool=l,l.__name__="WheelPanTool",l.init_WheelPanTool()},
function _(o,e,t){const s=o(268),i=o(314),l=o(18),n=o(95),_=o(271);class h extends s.GestureToolView{_pinch(o){const{sx:e,sy:t,scale:s}=o;let i;i=s>=1?20*(s-1):-20/s,this._scroll({type:"wheel",sx:e,sy:t,delta:i})}_scroll(o){const{frame:e}=this.plot_view,t=e.bbox.h_range,s=e.bbox.v_range,{sx:l,sy:n}=o,_=this.model.dimensions,h=("width"==_||"both"==_)&&t.start<l&&l<t.end,m=("height"==_||"both"==_)&&s.start<n&&n<s.end;if(!(h&&m||this.model.zoom_on_axis))return;const a=this.model.speed*o.delta,d=i.scale_range(e,a,h,m,{x:l,y:n});this.plot_view.push_state("wheel_zoom",{range:d}),this.plot_view.update_range(d,!1,!0,this.model.maintain_focus),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}}t.WheelZoomToolView=h,h.__name__="WheelZoomToolView";class m extends s.GestureTool{constructor(o){super(o),this.tool_name="Wheel Zoom",this.icon=_.bk_tool_icon_wheel_zoom,this.event_type=n.is_mobile?"pinch":"scroll",this.default_order=10}static init_WheelZoomTool(){this.prototype.default_view=h,this.define({dimensions:[l.Dimensions,"both"],maintain_focus:[l.Boolean,!0],zoom_on_axis:[l.Boolean,!0],speed:[l.Number,1/600]})}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}t.WheelZoomTool=m,m.__name__="WheelZoomTool",m.init_WheelZoomTool()},
function _(i,s,t){const e=i(262),o=i(133),n=i(18),l=i(22),h=i(271);class _ extends e.InspectToolView{_move(i){if(!this.model.active)return;const{sx:s,sy:t}=i;this.plot_view.frame.bbox.contains(s,t)?this._update_spans(s,t):this._update_spans(null,null)}_move_exit(i){this._update_spans(null,null)}_update_spans(i,s){const t=this.model.dimensions;"width"!=t&&"both"!=t||(this.model.spans.width.computed_location=s),"height"!=t&&"both"!=t||(this.model.spans.height.computed_location=i)}}t.CrosshairToolView=_,_.__name__="CrosshairToolView";class a extends e.InspectTool{constructor(i){super(i),this.tool_name="Crosshair",this.icon=h.bk_tool_icon_crosshair}static init_CrosshairTool(){this.prototype.default_view=_,this.define({dimensions:[n.Dimensions,"both"],line_color:[n.Color,"black"],line_width:[n.Number,1],line_alpha:[n.Number,1]}),this.internal({location_units:[n.SpatialUnits,"screen"],render_mode:[n.RenderMode,"css"],spans:[n.Any]})}get tooltip(){return this._get_dim_tooltip("Crosshair",this.dimensions)}get synthetic_renderers(){return l.values(this.spans)}initialize(){super.initialize(),this.spans={width:new o.Span({for_hover:!0,dimension:"width",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha}),height:new o.Span({for_hover:!0,dimension:"height",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha})}}}t.CrosshairTool=a,a.__name__="CrosshairTool",a.init_CrosshairTool()},
function _(e,t,s){const r=e(64),o=e(18),i=e(22),n=e(25);class u extends r.Model{constructor(e){super(e)}static init_CustomJSHover(){this.define({args:[o.Any,{}],code:[o.String,""]})}get values(){return i.values(this.args)}_make_code(e,t,s,r){return new Function(...i.keys(this.args),e,t,s,"require","exports",n.use_strict(r))}format(t,r,o){return this._make_code("value","format","special_vars",this.code)(...this.values,t,r,o,e,s)}}s.CustomJSHover=u,u.__name__="CustomJSHover",u.init_CustomJSHover()},
function _(e,t,s){const n=e(262),i=e(136),o=e(73),r=e(90),l=e(325),a=e(81),c=e(151),d=e(61),_=e(18),p=e(20),h=e(22),m=e(7),u=e(92),y=e(271),x=e(137);function f(e,t,s,n,i,o){const r={x:i[e],y:o[e]},l={x:i[e+1],y:o[e+1]};let c,d;if("span"==t.type)"h"==t.direction?(c=Math.abs(r.x-s),d=Math.abs(l.x-s)):(c=Math.abs(r.y-n),d=Math.abs(l.y-n));else{const e={x:s,y:n};c=a.dist_2_pts(r,e),d=a.dist_2_pts(l,e)}return c<d?[[r.x,r.y],e]:[[l.x,l.y],e+1]}function v(e,t,s){return[[e[s],t[s]],s]}s._nearest_line_hit=f,s._line_hit=v;class w extends n.InspectToolView{initialize(){super.initialize(),this.ttviews={}}remove(){u.remove_views(this.ttviews),super.remove()}connect_signals(){super.connect_signals();for(const e of this.computed_renderers)e instanceof o.GlyphRenderer?this.connect(e.data_source.inspect,this._update):e instanceof r.GraphRenderer&&(this.connect(e.node_renderer.data_source.inspect,this._update),this.connect(e.edge_renderer.data_source.inspect,this._update));this.connect(this.model.properties.renderers.change,()=>this._computed_renderers=this._ttmodels=null),this.connect(this.model.properties.names.change,()=>this._computed_renderers=this._ttmodels=null),this.connect(this.model.properties.tooltips.change,()=>this._ttmodels=null)}_compute_ttmodels(){const e={},t=this.model.tooltips;if(null!=t)for(const s of this.computed_renderers)if(s instanceof o.GlyphRenderer){const n=new i.Tooltip({custom:m.isString(t)||m.isFunction(t),attachment:this.model.attachment,show_arrow:this.model.show_arrow});e[s.id]=n}else if(s instanceof r.GraphRenderer){const n=new i.Tooltip({custom:m.isString(t)||m.isFunction(t),attachment:this.model.attachment,show_arrow:this.model.show_arrow});e[s.node_renderer.id]=n,e[s.edge_renderer.id]=n}return u.build_views(this.ttviews,h.values(e),{parent:this.plot_view}),e}get computed_renderers(){if(null==this._computed_renderers){const e=this.model.renderers,t=this.plot_model.renderers,s=this.model.names;this._computed_renderers=l.compute_renderers(e,t,s)}return this._computed_renderers}get ttmodels(){return null==this._ttmodels&&(this._ttmodels=this._compute_ttmodels()),this._ttmodels}_clear(){this._inspect(1/0,1/0);for(const e in this.ttmodels){this.ttmodels[e].clear()}}_move(e){if(!this.model.active)return;const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)?this._inspect(t,s):this._clear()}_move_exit(){this._clear()}_inspect(e,t){let s;if("mouse"==this.model.mode)s={type:"point",sx:e,sy:t};else{s={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t}}for(const e of this.computed_renderers){e.get_selection_manager().inspect(this.plot_view.renderer_views[e.id],s)}null!=this.model.callback&&this._emit_callback(s)}_update([e,{geometry:t}]){if(!this.model.active)return;if(!(e instanceof o.GlyphRendererView||e instanceof r.GraphRendererView))return;const{model:s}=e,n=this.ttmodels[s.id];if(null==n)return;n.clear();const i=s.get_selection_manager();let l=i.inspectors[s.id];if(s instanceof o.GlyphRenderer&&(l=s.view.convert_selection_to_subset(l)),l.is_empty())return;const a=i.source,{frame:c}=this.plot_view,{sx:d,sy:_}=t,p=c.xscales[s.x_range_name],m=c.yscales[s.y_range_name],u=p.invert(d),y=m.invert(_),x=e.glyph;for(const s of l.line_indices){let i,o,r=x._x[s+1],c=x._y[s+1],h=s;switch(this.model.line_policy){case"interp":[r,c]=x.get_interpolation_hit(s,t),i=p.compute(r),o=m.compute(c);break;case"prev":[[i,o],h]=v(x.sx,x.sy,s);break;case"next":[[i,o],h]=v(x.sx,x.sy,s+1);break;case"nearest":[[i,o],h]=f(s,t,d,_,x.sx,x.sy),r=x._x[h],c=x._y[h];break;default:[i,o]=[d,_]}const w={index:h,x:u,y:y,sx:d,sy:_,data_x:r,data_y:c,rx:i,ry:o,indices:l.line_indices,name:e.model.name};n.add(i,o,this._render_tooltips(a,h,w))}for(const e of l.image_indices){const t={index:e.index,x:u,y:y,sx:d,sy:_},s=this._render_tooltips(a,e,t);n.add(d,_,s)}for(const i of l.indices)if(h.isEmpty(l.multiline_indices)){const t=null!=x._x?x._x[i]:void 0,r=null!=x._y?x._y[i]:void 0;let c,p,h;if("snap_to_data"==this.model.point_policy){let e=x.get_anchor_point(this.model.anchor,i,[d,_]);null==e&&(e=x.get_anchor_point("center",i,[d,_])),c=e.x,p=e.y}else[c,p]=[d,_];const m={index:h=s instanceof o.GlyphRenderer?s.view.convert_indices_from_subset([i])[0]:i,x:u,y:y,sx:d,sy:_,data_x:t,data_y:r,indices:l.indices,name:e.model.name};n.add(c,p,this._render_tooltips(a,h,m))}else for(const r of l.multiline_indices[i.toString()]){let c,h,w,b=x._xs[i][r],g=x._ys[i][r],k=r;switch(this.model.line_policy){case"interp":[b,g]=x.get_interpolation_hit(i,r,t),c=p.compute(b),h=m.compute(g);break;case"prev":[[c,h],k]=v(x.sxs[i],x.sys[i],r);break;case"next":[[c,h],k]=v(x.sxs[i],x.sys[i],r+1);break;case"nearest":[[c,h],k]=f(r,t,d,_,x.sxs[i],x.sys[i]),b=x._xs[i][k],g=x._ys[i][k];break;default:throw new Error("should't have happened")}const T={index:w=s instanceof o.GlyphRenderer?s.view.convert_indices_from_subset([i])[0]:i,x:u,y:y,sx:d,sy:_,data_x:b,data_y:g,segment_index:k,indices:l.multiline_indices,name:e.model.name};n.add(c,h,this._render_tooltips(a,w,T))}}_emit_callback(e){for(const t of this.computed_renderers){const s=t.data_source.inspected,{frame:n}=this.plot_view,i=n.xscales[t.x_range_name],o=n.yscales[t.y_range_name],r=i.invert(e.sx),l=o.invert(e.sy),a=Object.assign({x:r,y:l},e);this.model.callback.execute(this.model,{index:s,geometry:a,renderer:t})}}_render_tooltips(e,t,s){const n=this.model.tooltips;if(m.isString(n)){const i=d.div();return i.innerHTML=c.replace_placeholders(n,e,t,this.model.formatters,s),i}if(m.isFunction(n))return n(e,s);{const i=d.div({style:{display:"table",borderSpacing:"2px"}});for(const[o,r]of n){const n=d.div({style:{display:"table-row"}});let l;if(i.appendChild(n),l=d.div({style:{display:"table-cell"},class:x.bk_tooltip_row_label},0!=o.length?`${o}: `:""),n.appendChild(l),l=d.div({style:{display:"table-cell"},class:x.bk_tooltip_row_value}),n.appendChild(l),r.indexOf("$color")>=0){const[,s="",n]=r.match(/\$color(\[.*\])?:(\w*)/),i=e.get_column(n);if(null==i){const e=d.span({},`${n} unknown`);l.appendChild(e);continue}const o=s.indexOf("hex")>=0,a=s.indexOf("swatch")>=0;let c=m.isNumber(t)?i[t]:null;if(null==c){const e=d.span({},"(null)");l.appendChild(e);continue}o&&(c=p.color2hex(c));let _=d.span({},c);l.appendChild(_),a&&(_=d.span({class:x.bk_tooltip_color_block,style:{backgroundColor:c}}," "),l.appendChild(_))}else{const n=d.span();n.innerHTML=c.replace_placeholders(r.replace("$~","$data_"),e,t,this.model.formatters,s),l.appendChild(n)}}return i}}}s.HoverToolView=w,w.__name__="HoverToolView";class b extends n.InspectTool{constructor(e){super(e),this.tool_name="Hover",this.icon=y.bk_tool_icon_hover}static init_HoverTool(){this.prototype.default_view=w,this.define({tooltips:[_.Any,[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[_.Any,{}],renderers:[_.Any,"auto"],names:[_.Array,[]],mode:[_.HoverMode,"mouse"],point_policy:[_.PointPolicy,"snap_to_data"],line_policy:[_.LinePolicy,"nearest"],show_arrow:[_.Boolean,!0],anchor:[_.Anchor,"center"],attachment:[_.TooltipAttachment,"horizontal"],callback:[_.Any]})}}s.HoverTool=b,b.__name__="HoverTool",b.init_HoverTool()},
function _(t,o,e){const i=t(18),s=t(13),n=t(64),c=t(262);class l extends n.Model{constructor(t){super(t)}static init_ToolProxy(){this.define({tools:[i.Array,[]],active:[i.Boolean,!1],disabled:[i.Boolean,!1]})}get button_view(){return this.tools[0].button_view}get event_type(){return this.tools[0].event_type}get tooltip(){return this.tools[0].tooltip}get tool_name(){return this.tools[0].tool_name}get icon(){return this.tools[0].computed_icon}get computed_icon(){return this.icon}get toggleable(){const t=this.tools[0];return t instanceof c.InspectTool&&t.toggleable}initialize(){super.initialize(),this.do=new s.Signal0(this,"do")}connect_signals(){super.connect_signals(),this.connect(this.do,()=>this.doit()),this.connect(this.properties.active.change,()=>this.set_active())}doit(){for(const t of this.tools)t.do.emit()}set_active(){for(const t of this.tools)t.active=this.active}}e.ToolProxy=l,l.__name__="ToolProxy",l.init_ToolProxy()},
function _(t,o,s){const i=t(18),e=t(8),n=t(267),l=t(337),c=t(237),r=t(180);class h extends n.ToolbarBase{constructor(t){super(t)}initialize(){super.initialize(),this._merge_tools()}_merge_tools(){this._proxied_tools=[];const t={},o={},s={},i=[],n=[];for(const t of this.help)e.includes(n,t.redirect)||(i.push(t),n.push(t.redirect));this._proxied_tools.push(...i),this.help=i;for(const t in this.gestures){const o=this.gestures[t];t in s||(s[t]={});for(const i of o.tools)i.type in s[t]||(s[t][i.type]=[]),s[t][i.type].push(i)}for(const o of this.inspectors)o.type in t||(t[o.type]=[]),t[o.type].push(o);for(const t of this.actions)t.type in o||(o[t.type]=[]),o[t.type].push(t);const c=(t,o=!1)=>{const s=new l.ToolProxy({tools:t,active:o});return this._proxied_tools.push(s),s};for(const t in s){const o=this.gestures[t];o.tools=[];for(const i in s[t]){const e=s[t][i];if(e.length>0)if("multi"==t)for(const t of e){const s=c([t]);o.tools.push(s),this.connect(s.properties.active.change,this._active_change.bind(this,s))}else{const t=c(e);o.tools.push(t),this.connect(t.properties.active.change,this._active_change.bind(this,t))}}}this.actions=[];for(const t in o){const s=o[t];if("CustomAction"==t)for(const t of s)this.actions.push(c([t]));else s.length>0&&this.actions.push(c(s))}this.inspectors=[];for(const o in t){const s=t[o];s.length>0&&this.inspectors.push(c(s,!0))}for(const t in this.gestures){const o=this.gestures[t];0!=o.tools.length&&(o.tools=e.sort_by(o.tools,t=>t.default_order),"pinch"!=t&&"scroll"!=t&&"multi"!=t&&(o.tools[0].active=!0))}}}s.ProxyToolbar=h,h.__name__="ProxyToolbar";class a extends c.LayoutDOMView{initialize(){this.model.toolbar.toolbar_location=this.model.toolbar_location,super.initialize()}get child_models(){return[this.model.toolbar]}_update_layout(){this.layout=new r.ContentBox(this.child_views[0].el);const{toolbar:t}=this.model;t.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})}}s.ToolbarBoxView=a,a.__name__="ToolbarBoxView";class _ extends c.LayoutDOM{constructor(t){super(t)}static init_ToolbarBox(){this.prototype.default_view=a,this.define({toolbar:[i.Instance],toolbar_location:[i.Location,"right"]})}}s.ToolbarBox=_,_.__name__="ToolbarBox",_.init_ToolbarBox()},
function _(n,e,t){const o=n(4),d=n(61),i=n(340);t.index={},t.add_document_standalone=function(n,e,c={},l=!1){const s={};function a(n){let o;n.id in c?o=c[n.id]:e.classList.contains(i.BOKEH_ROOT)?o=e:(o=d.div({class:i.BOKEH_ROOT}),e.appendChild(o));const l=function(n){const e=new n.default_view({model:n,parent:null});return t.index[n.id]=e,e}(n);l.renderTo(o),s[n.id]=l}for(const e of n.roots())a(e);return l&&(window.document.title=n.title()),n.on_change(n=>{n instanceof o.RootAddedEvent?a(n.model):n instanceof o.RootRemovedEvent?function(n){const{id:e}=n;e in s&&(s[e].remove(),delete s[e],delete t.index[e])}(n.model):l&&n instanceof o.TitleChangedEvent&&(window.document.title=n.title)}),s}},
function _(e,o,n){const t=e(61),r=e(62);function l(e){let o=document.getElementById(e);if(null==o)throw new Error(`Error rendering Bokeh model: could not find #${e} HTML tag`);if(!document.body.contains(o))throw new Error(`Error rendering Bokeh model: element #${e} must be under <body>`);if("SCRIPT"==o.tagName){const e=t.div({class:n.BOKEH_ROOT});t.replaceWith(o,e),o=e}return o}n.BOKEH_ROOT=r.bk_root,n._resolve_element=function(e){const{elementid:o}=e;return null!=o?l(o):document.body},n._resolve_root_elements=function(e){const o={};if(null!=e.roots)for(const n in e.roots)o[n]=l(e.roots[n]);return o}},
function _(n,o,t){const e=n(342),s=n(65),c=n(339);t._get_ws_url=function(n,o){let t,e="ws:";return"https:"==window.location.protocol&&(e="wss:"),null!=o?(t=document.createElement("a")).href=o:t=window.location,null!=n?"/"==n&&(n=""):n=t.pathname.replace(/\/+$/,""),e+"//"+t.host+n+"/ws"};const r={};t.add_document_from_session=function(n,o,t,l={},i=!1){const u=window.location.search.substr(1);return function(n,o,t){n in r||(r[n]={});const s=r[n];return o in s||(s[o]=e.pull_session(n,o,t)),s[o]}(n,o,u).then(n=>c.add_document_standalone(n.document,t,l,i),n=>{throw s.logger.error(`Failed to load Bokeh session ${o}: ${n}`),n})}},
function _(e,n,s){const o=e(65),t=e(4),i=e(343),r=e(344),l=e(345);s.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",s.DEFAULT_SESSION_ID="default";let _=0;class c{constructor(e=s.DEFAULT_SERVER_WEBSOCKET_URL,n=s.DEFAULT_SESSION_ID,t=null,i=null,l=null){this.url=e,this.id=n,this.args_string=t,this._on_have_session_hook=i,this._on_closed_permanently_hook=l,this._number=_++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_ack=null,this._pending_replies={},this._pending_messages=[],this._receiver=new r.Receiver,o.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`)}connect(){if(this.closed_permanently)return Promise.reject(new Error("Cannot connect() a closed ClientConnection"));if(null!=this.socket)return Promise.reject(new Error("Already connected"));this._pending_replies={},this._current_handler=null;try{let e=`${this.url}?bokeh-protocol-version=1.0&bokeh-session-id=${this.id}`;return null!=this.args_string&&this.args_string.length>0&&(e+=`&${this.args_string}`),this.socket=new WebSocket(e),new Promise((e,n)=>{this.socket.binaryType="arraybuffer",this.socket.onopen=(()=>this._on_open(e,n)),this.socket.onmessage=(e=>this._on_message(e)),this.socket.onclose=(e=>this._on_close(e)),this.socket.onerror=(()=>this._on_error(n))})}catch(e){return o.logger.error(`websocket creation failed to url: ${this.url}`),o.logger.error(` - ${e}`),Promise.reject(e)}}close(){this.closed_permanently||(o.logger.debug(`Permanently closing websocket connection ${this._number}`),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,`close method called on ClientConnection ${this._number}`),this.session._connection_closed(),null!=this._on_closed_permanently_hook&&(this._on_closed_permanently_hook(),this._on_closed_permanently_hook=null))}_schedule_reconnect(e){setTimeout(()=>{this.closed_permanently||o.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`)},e)}send(e){if(null==this.socket)throw new Error(`not connected so cannot send ${e}`);e.send(this.socket)}send_with_reply(e){return new Promise((n,s)=>{this._pending_replies[e.msgid()]=[n,s],this.send(e)}).then(e=>{if("ERROR"===e.msgtype())throw new Error(`Error reply ${e.content.text}`);return e},e=>{throw e})}_pull_doc_json(){const e=i.Message.create("PULL-DOC-REQ",{});return this.send_with_reply(e).then(e=>{if(!("doc"in e.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return e.content.doc},e=>{throw e})}_repull_session_doc(){null==this.session?o.logger.debug("Pulling session for first time"):o.logger.debug("Repulling session"),this._pull_doc_json().then(e=>{if(null==this.session)if(this.closed_permanently)o.logger.debug("Got new document after connection was already closed");else{const n=t.Document.from_json(e),s=t.Document._compute_patch_since_json(e,n);if(s.events.length>0){o.logger.debug(`Sending ${s.events.length} changes from model construction back to server`);const e=i.Message.create("PATCH-DOC",{},s);this.send(e)}this.session=new l.ClientSession(this,n,this.id);for(const e of this._pending_messages)this.session.handle(e);this._pending_messages=[],o.logger.debug("Created a new session from new pulled doc"),null!=this._on_have_session_hook&&(this._on_have_session_hook(this.session),this._on_have_session_hook=null)}else this.session.document.replace_with_json(e),o.logger.debug("Updated existing session with new pulled doc")},e=>{throw e}).catch(e=>{null!=console.trace&&console.trace(e),o.logger.error(`Failed to repull session ${e}`)})}_on_open(e,n){o.logger.info(`Websocket connection ${this._number} is now open`),this._pending_ack=[e,n],this._current_handler=(e=>{this._awaiting_ack_handler(e)})}_on_message(e){null==this._current_handler&&o.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(e.toString())}if(null==this._receiver.message)return;const n=this._receiver.message,s=n.problem();null!=s&&this._close_bad_protocol(s),this._current_handler(n)}_on_close(e){o.logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`),this.socket=null,null!=this._pending_ack&&(this._pending_ack[1](new Error(`Lost websocket connection, ${e.code} (${e.reason})`)),this._pending_ack=null);const n=()=>{for(const e in this._pending_replies){const n=this._pending_replies[e];return delete this._pending_replies[e],n}return null};let s=n();for(;null!=s;)s[1]("Disconnected"),s=n();this.closed_permanently||this._schedule_reconnect(2e3)}_on_error(e){o.logger.debug(`Websocket error on socket ${this._number}`),e(new Error("Could not open websocket"))}_close_bad_protocol(e){o.logger.error(`Closing connection: ${e}`),null!=this.socket&&this.socket.close(1002,e)}_awaiting_ack_handler(e){"ACK"===e.msgtype()?(this._current_handler=(e=>this._steady_state_handler(e)),this._repull_session_doc(),null!=this._pending_ack&&(this._pending_ack[0](this),this._pending_ack=null)):this._close_bad_protocol("First message was not an ACK")}_steady_state_handler(e){if(e.reqid()in this._pending_replies){const n=this._pending_replies[e.reqid()];delete this._pending_replies[e.reqid()],n[0](e)}else this.session?this.session.handle(e):this._pending_messages.push(e)}}s.ClientConnection=c,c.__name__="ClientConnection",s.pull_session=function(e,n,s){return new Promise((t,i)=>{new c(e,n,s,e=>{try{t(e)}catch(n){throw o.logger.error(`Promise handler threw an error, closing session ${n}`),e.close(),n}},()=>{i(new Error("Connection was closed before we successfully pulled a session"))}).connect().then(e=>void 0,e=>{throw o.logger.error(`Failed to connect to Bokeh server ${e}`),e})})}},
function _(e,s,t){const r=e(25);class n{constructor(e,s,t){this.header=e,this.metadata=s,this.content=t,this.buffers=[]}static assemble(e,s,t){const r=JSON.parse(e),i=JSON.parse(s),h=JSON.parse(t);return new n(r,i,h)}assemble_buffer(e,s){if((null!=this.header.num_buffers?this.header.num_buffers:0)<=this.buffers.length)throw new Error("too many buffers received, expecting #{nb}");this.buffers.push([e,s])}static create(e,s,t={}){const r=n.create_header(e);return new n(r,s,t)}static create_header(e){return{msgid:r.uniqueId(),msgtype:e}}complete(){return null!=this.header&&null!=this.metadata&&null!=this.content&&(!("num_buffers"in this.header)||this.buffers.length===this.header.num_buffers)}send(e){if((null!=this.header.num_buffers?this.header.num_buffers:0)>0)throw new Error("BokehJS only supports receiving buffers, not sending");const s=JSON.stringify(this.header),t=JSON.stringify(this.metadata),r=JSON.stringify(this.content);e.send(s),e.send(t),e.send(r)}msgid(){return this.header.msgid}msgtype(){return this.header.msgtype}reqid(){return this.header.reqid}problem(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"}}t.Message=n,n.__name__="Message"},
function _(e,t,s){const _=e(343);class r{constructor(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}consume(e){this._current_consumer(e)}_HEADER(e){this._assume_text(e),this.message=null,this._partial=null,this._fragments=[e],this._buf_header=null,this._current_consumer=this._METADATA}_METADATA(e){this._assume_text(e),this._fragments.push(e),this._current_consumer=this._CONTENT}_CONTENT(e){this._assume_text(e),this._fragments.push(e);const[t,s,r]=this._fragments.slice(0,3);this._partial=_.Message.assemble(t,s,r),this._check_complete()}_BUFFER_HEADER(e){this._assume_text(e),this._buf_header=e,this._current_consumer=this._BUFFER_PAYLOAD}_BUFFER_PAYLOAD(e){this._assume_binary(e),this._partial.assemble_buffer(this._buf_header,e),this._check_complete()}_assume_text(e){if(e instanceof ArrayBuffer)throw new Error("Expected text fragment but received binary fragment")}_assume_binary(e){if(!(e instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")}_check_complete(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER}}s.Receiver=r,r.__name__="Receiver"},
function _(e,t,n){const s=e(4),o=e(343),i=e(65);class _{constructor(e,t,n){this._connection=e,this.document=t,this.id=n,this._document_listener=(e=>this._document_changed(e)),this.document.on_change(this._document_listener),this.event_manager=this.document.event_manager,this.event_manager.session=this}handle(e){const t=e.msgtype();"PATCH-DOC"===t?this._handle_patch(e):"OK"===t?this._handle_ok(e):"ERROR"===t?this._handle_error(e):i.logger.debug(`Doing nothing with message ${e.msgtype()}`)}close(){this._connection.close()}send_event(e){const t=o.Message.create("EVENT",{},JSON.stringify(e.to_json()));this._connection.send(t)}_connection_closed(){this.document.remove_on_change(this._document_listener)}request_server_info(){const e=o.Message.create("SERVER-INFO-REQ",{});return this._connection.send_with_reply(e).then(e=>e.content)}force_roundtrip(){return this.request_server_info().then(e=>void 0)}_document_changed(e){if(e.setter_id===this.id)return;if(e instanceof s.ModelChangedEvent&&!(e.attr in e.model.serializable_attributes()))return;const t=o.Message.create("PATCH-DOC",{},this.document.create_json_patch([e]));this._connection.send(t)}_handle_patch(e){this.document.apply_json_patch(e.content,e.buffers,this.id)}_handle_ok(e){i.logger.trace(`Unhandled OK reply to ${e.reqid()}`)}_handle_error(e){i.logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`)}}n.ClientSession=_,_.__name__="ClientSession"},
function _(e,o,t){const n=e(4),r=e(344),s=e(65),i=e(22),c=e(339),l=e(340);function g(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);const t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function u(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){s.logger.info(`Registering Jupyter comms for target ${e}`);const t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(e,t=>{s.logger.info(`Registering Jupyter comms for target ${e}`);const n=new r.Receiver;t.on_msg(g.bind(o,n))})}catch(e){s.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if(o.roots()[0].id in t.kernels){s.logger.info(`Registering JupyterLab comms for target ${e}`);const n=t.kernels[o.roots()[0].id];try{n.registerCommTarget(e,t=>{s.logger.info(`Registering JupyterLab comms for target ${e}`);const n=new r.Receiver;t.onMsg=g.bind(o,n)})}catch(e){s.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}e(272),e(347),t.kernels={},t.embed_items_notebook=function(e,o){if(1!=i.size(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");const t=n.Document.from_json(i.values(e)[0]);for(const e of o){null!=e.notebook_comms_target&&u(e.notebook_comms_target,t);const o=l._resolve_element(e),n=l._resolve_root_elements(e);c.add_document_standalone(t,o,n)}}},
function _(e,t,o){e(62),e(61).styles.append("/* notebook specific tweaks so no black outline and matching padding\n/* can't be wrapped inside bk-root. here are the offending jupyter lines:\n/* https://github.com/jupyter/notebook/blob/master/notebook/static/notebook/less/renderedhtml.less#L59-L76 */\n.rendered_html .bk-root .bk-tooltip table,\n.rendered_html .bk-root .bk-tooltip tr,\n.rendered_html .bk-root .bk-tooltip th,\n.rendered_html .bk-root .bk-tooltip td {\n  border: none;\n  padding: 1px;\n}\n")},
function _(n,o,r){function f(n){for(var o in n)r.hasOwnProperty(o)||(r[o]=n[o])}f(n(343)),f(n(344))},
function _(e,t,s){function n(){const e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);const s=document.createElement("div");s.classList.add("bokeh-test-div"),s.style.display="none",e.insertBefore(s,e.firstChild)}s.results={},s.init=function(){n()},s.record=function(e,t){s.results[e]=t,n()},s.count=function(e){null==s.results[e]&&(s.results[e]=0),s.results[e]+=1,n()},s.clear=function(){for(const e of Object.keys(s.results))delete s.results[e];n()}},
function _(e,t,o){o.safely=function(e,t=!1){try{return e()}catch(e){if(function(e){const t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");const o=document.createElement("span");o.style.backgroundColor="#a94442",o.style.borderRadius="0px 4px 0px 0px",o.style.color="white",o.style.cursor="pointer",o.style.cssFloat="right",o.style.fontSize="0.8em",o.style.margin="-6px -6px 0px 0px",o.style.padding="2px 5px 4px 5px",o.title="close",o.setAttribute("aria-label","close"),o.appendChild(document.createTextNode("x")),o.addEventListener("click",()=>r.removeChild(t));const n=document.createElement("h3");n.style.color="#a94442",n.style.margin="8px 0px 0px 0px",n.style.padding="0px",n.appendChild(document.createTextNode("Bokeh Error"));const l=document.createElement("pre");l.style.whiteSpace="unset",l.style.overflowX="auto";const s=e instanceof Error?e.message:e;l.appendChild(document.createTextNode(s)),t.appendChild(o),t.appendChild(n),t.appendChild(l);const r=document.getElementsByTagName("body")[0];r.insertBefore(t,r.firstChild)}(e),t)return;throw e}}},
], 0, {"main":0,"index":1,"version":2,"embed/index":3,"document/index":4,"document/document":5,"base":6,"core/util/types":7,"core/util/array":8,"core/util/math":9,"core/util/assert":10,"core/util/arrayable":11,"core/has_props":12,"core/signaling":13,"core/util/data_structures":14,"core/util/eq":15,"core/util/callback":16,"core/property_mixins":17,"core/properties":18,"core/enums":19,"core/util/color":20,"core/util/svg_colors":21,"core/util/object":22,"core/util/refs":24,"core/util/string":25,"core/settings":26,"models/index":27,"models/annotations/index":28,"models/annotations/annotation":29,"core/util/projections":30,"models/renderers/renderer":58,"core/dom_view":59,"core/view":60,"core/dom":61,"styles/root":62,"core/visuals":63,"model":64,"core/logging":65,"models/annotations/arrow":66,"models/annotations/arrow_head":67,"models/sources/column_data_source":68,"models/sources/columnar_data_source":69,"models/sources/data_source":70,"models/selections/selection":71,"core/selection_manager":72,"models/renderers/glyph_renderer":73,"models/renderers/data_renderer":74,"models/glyphs/line":75,"models/glyphs/xy_glyph":76,"core/util/spatial":77,"core/util/bbox":79,"models/glyphs/glyph":80,"core/hittest":81,"models/ranges/factor_range":82,"models/ranges/range":83,"models/glyphs/utils":84,"models/glyphs/patch":85,"models/glyphs/harea":86,"models/glyphs/area":87,"models/glyphs/varea":88,"models/sources/cds_view":89,"models/renderers/graph_renderer":90,"models/graphs/graph_hit_test_policy":91,"core/build_views":92,"models/selections/interaction_policy":93,"core/util/serialization":94,"core/util/compat":95,"core/util/typed_array":96,"document/events":97,"models/annotations/band":98,"models/annotations/box_annotation":99,"styles/annotations":100,"models/annotations/color_bar":101,"models/tickers/basic_ticker":102,"models/tickers/adaptive_ticker":103,"models/tickers/continuous_ticker":104,"models/tickers/ticker":105,"models/formatters/basic_tick_formatter":106,"models/formatters/tick_formatter":107,"models/mappers/linear_color_mapper":108,"models/mappers/continuous_color_mapper":109,"models/mappers/color_mapper":110,"models/mappers/mapper":111,"models/transforms/transform":112,"models/scales/linear_scale":113,"models/scales/scale":114,"models/transforms/index":115,"models/transforms/customjs_transform":116,"models/transforms/dodge":117,"models/transforms/interpolator":118,"models/transforms/jitter":119,"models/transforms/linear_interpolator":120,"models/transforms/step_interpolator":121,"models/scales/log_scale":122,"models/ranges/range1d":123,"core/util/text":124,"models/annotations/label":125,"models/annotations/text_annotation":126,"models/annotations/label_set":127,"models/annotations/legend":128,"models/annotations/legend_item":129,"core/vectorization":130,"models/annotations/poly_annotation":131,"models/annotations/slope":132,"models/annotations/span":133,"models/annotations/title":134,"models/annotations/toolbar_panel":135,"models/annotations/tooltip":136,"styles/tooltips":137,"styles/mixins":138,"models/annotations/whisker":139,"models/axes/index":140,"models/axes/axis":141,"models/renderers/guide_renderer":142,"models/axes/categorical_axis":143,"models/tickers/categorical_ticker":144,"models/formatters/categorical_tick_formatter":145,"models/axes/continuous_axis":146,"models/axes/datetime_axis":147,"models/axes/linear_axis":148,"models/formatters/datetime_tick_formatter":149,"core/util/templating":151,"models/tickers/datetime_ticker":154,"models/tickers/composite_ticker":155,"models/tickers/days_ticker":156,"models/tickers/single_interval_ticker":157,"models/tickers/util":158,"models/tickers/months_ticker":159,"models/tickers/years_ticker":160,"models/axes/log_axis":161,"models/formatters/log_tick_formatter":162,"models/tickers/log_ticker":163,"models/axes/mercator_axis":164,"models/formatters/mercator_tick_formatter":165,"models/tickers/mercator_ticker":166,"models/callbacks/index":167,"models/callbacks/customjs":168,"models/callbacks/callback":169,"models/callbacks/open_url":170,"models/canvas/index":171,"models/canvas/canvas":172,"core/util/canvas":173,"styles/canvas":174,"models/canvas/cartesian_frame":176,"models/scales/categorical_scale":177,"models/ranges/data_range1d":178,"models/ranges/data_range":179,"core/layout/index":180,"core/layout/types":181,"core/layout/layoutable":182,"core/layout/alignments":183,"core/layout/grid":184,"core/layout/html":185,"models/expressions/index":186,"models/expressions/expression":187,"models/expressions/stack":188,"models/expressions/cumsum":189,"models/filters/index":190,"models/filters/boolean_filter":191,"models/filters/filter":192,"models/filters/customjs_filter":193,"models/filters/group_filter":194,"models/filters/index_filter":195,"models/formatters/index":196,"models/formatters/func_tick_formatter":197,"models/formatters/numeral_tick_formatter":198,"models/formatters/printf_tick_formatter":199,"models/glyphs/index":200,"models/glyphs/annular_wedge":201,"models/glyphs/annulus":202,"models/glyphs/arc":203,"models/glyphs/bezier":204,"models/glyphs/circle":205,"models/glyphs/center_rotatable":206,"models/glyphs/ellipse":207,"models/glyphs/ellipse_oval":208,"models/glyphs/hbar":209,"models/glyphs/box":210,"models/glyphs/hex_tile":211,"models/glyphs/image":212,"models/glyphs/image_base":213,"models/glyphs/image_rgba":214,"models/glyphs/image_url":215,"core/util/image":216,"models/glyphs/multi_line":217,"models/glyphs/multi_polygons":218,"models/glyphs/oval":219,"models/glyphs/patches":220,"models/glyphs/quad":221,"models/glyphs/quadratic":222,"models/glyphs/ray":223,"models/glyphs/rect":224,"models/glyphs/segment":225,"models/glyphs/step":226,"models/glyphs/text":227,"models/glyphs/vbar":228,"models/glyphs/wedge":229,"models/graphs/index":230,"models/graphs/layout_provider":231,"models/graphs/static_layout_provider":232,"models/grids/index":233,"models/grids/grid":234,"models/layouts/index":235,"models/layouts/box":236,"models/layouts/layout_dom":237,"models/layouts/column":238,"models/layouts/grid_box":239,"models/layouts/html_box":240,"models/layouts/row":241,"models/layouts/spacer":242,"models/layouts/tabs":243,"styles/tabs":244,"styles/buttons":245,"styles/menus":246,"models/layouts/widget_box":247,"models/mappers/index":248,"models/mappers/categorical_color_mapper":249,"models/mappers/categorical_mapper":250,"models/mappers/categorical_marker_mapper":251,"models/mappers/categorical_pattern_mapper":252,"models/mappers/log_color_mapper":253,"models/markers/index":254,"models/markers/defs":255,"models/markers/marker":256,"models/markers/scatter":257,"models/plots/index":258,"models/plots/gmap_plot":259,"models/plots/plot":260,"models/tools/toolbar":261,"models/tools/inspectors/inspect_tool":262,"models/tools/button_tool":263,"models/tools/tool":264,"styles/toolbar":265,"models/tools/on_off_button":266,"models/tools/toolbar_base":267,"models/tools/gestures/gesture_tool":268,"models/tools/actions/action_tool":269,"models/tools/actions/help_tool":270,"styles/icons":271,"styles/logo":272,"models/plots/plot_canvas":273,"core/bokeh_events":274,"core/util/throttle":275,"core/layout/side_panel":276,"core/ui_events":277,"core/util/wheel":279,"models/plots/gmap_plot_canvas":280,"models/ranges/index":281,"models/renderers/index":282,"models/scales/index":283,"models/selections/index":284,"models/sources/index":285,"models/sources/server_sent_data_source":286,"models/sources/web_data_source":287,"models/sources/ajax_data_source":288,"models/sources/remote_data_source":289,"models/sources/geojson_data_source":290,"models/tickers/index":291,"models/tickers/fixed_ticker":292,"models/tiles/index":293,"models/tiles/bbox_tile_source":294,"models/tiles/mercator_tile_source":295,"models/tiles/tile_source":296,"models/tiles/tile_utils":297,"models/tiles/quadkey_tile_source":298,"models/tiles/tile_renderer":299,"models/tiles/wmts_tile_source":300,"styles/tiles":301,"models/tiles/tms_tile_source":302,"models/textures/index":303,"models/textures/canvas_texture":304,"models/textures/texture":305,"models/textures/image_url_texture":306,"models/tools/index":307,"models/tools/actions/custom_action":308,"models/tools/actions/redo_tool":309,"models/tools/actions/reset_tool":310,"models/tools/actions/save_tool":311,"models/tools/actions/undo_tool":312,"models/tools/actions/zoom_in_tool":313,"core/util/zoom":314,"models/tools/actions/zoom_out_tool":315,"models/tools/edit/edit_tool":316,"models/tools/edit/box_edit_tool":317,"models/tools/edit/freehand_draw_tool":318,"models/tools/edit/point_draw_tool":319,"models/tools/edit/poly_draw_tool":320,"models/tools/edit/poly_tool":321,"models/tools/edit/poly_edit_tool":322,"models/tools/gestures/box_select_tool":323,"models/tools/gestures/select_tool":324,"models/tools/util":325,"models/tools/gestures/box_zoom_tool":326,"models/tools/gestures/lasso_select_tool":327,"models/tools/gestures/pan_tool":328,"models/tools/gestures/poly_select_tool":329,"models/tools/gestures/range_tool":330,"models/tools/gestures/tap_tool":331,"models/tools/gestures/wheel_pan_tool":332,"models/tools/gestures/wheel_zoom_tool":333,"models/tools/inspectors/crosshair_tool":334,"models/tools/inspectors/customjs_hover":335,"models/tools/inspectors/hover_tool":336,"models/tools/tool_proxy":337,"models/tools/toolbar_box":338,"embed/standalone":339,"embed/dom":340,"embed/server":341,"client/connection":342,"protocol/message":343,"protocol/receiver":344,"client/session":345,"embed/notebook":346,"styles/notebook":347,"protocol/index":348,"testing":349,"safely":350}, {});
})

//# sourceMappingURL=bokeh-es6.min.js.map
