"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelionOptions = TimelionOptions;

var _react = _interopRequireWildcard(require("react"));

var _eui = require("@elastic/eui");

var _components = require("../components");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function TimelionOptions(_ref) {
  var stateParams = _ref.stateParams,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity;
  var setInterval = (0, _react.useCallback)(function (value) {
    return setValue('interval', value);
  }, [setValue]);
  var setExpressionInput = (0, _react.useCallback)(function (value) {
    return setValue('expression', value);
  }, [setValue]);
  return _react.default.createElement(_eui.EuiPanel, {
    className: "visEditorSidebar__timelionOptions",
    paddingSize: "s"
  }, _react.default.createElement(_components.TimelionInterval, {
    value: stateParams.interval,
    setValue: setInterval,
    setValidity: setValidity
  }), _react.default.createElement(_components.TimelionExpressionInput, {
    value: stateParams.expression,
    setValue: setExpressionInput
  }));
}