"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../chart_types/xy_chart/utils/specs");
var interactions_1 = require("../chart_types/xy_chart/utils/interactions");
var spec_factory_1 = require("../state/spec_factory");
var light_theme_1 = require("../utils/themes/light_theme");
var chart_types_1 = require("../chart_types");
exports.PointerEventType = Object.freeze({
    Over: 'Over',
    Out: 'Out',
});
exports.DEFAULT_TOOLTIP_TYPE = interactions_1.TooltipType.VerticalCursor;
exports.DEFAULT_TOOLTIP_SNAP = true;
exports.DEFAULT_SETTINGS_SPEC = {
    id: '__global__settings___',
    chartType: chart_types_1.ChartTypes.Global,
    specType: specs_1.SpecTypes.Settings,
    rendering: 'canvas',
    rotation: 0,
    animateData: true,
    showLegend: false,
    resizeDebounce: 10,
    debug: false,
    tooltip: {
        type: exports.DEFAULT_TOOLTIP_TYPE,
        snap: exports.DEFAULT_TOOLTIP_SNAP,
    },
    legendPosition: specs_1.Position.Right,
    showLegendDisplayValue: true,
    hideDuplicateAxes: false,
    theme: light_theme_1.LIGHT_THEME,
};
exports.Settings = spec_factory_1.getConnect()(spec_factory_1.specComponentFactory(exports.DEFAULT_SETTINGS_SPEC));
function isPointerOutEvent(event) {
    return event !== null && event !== undefined && event.type === exports.PointerEventType.Out;
}
exports.isPointerOutEvent = isPointerOutEvent;
function isPointerOverEvent(event) {
    return event !== null && event !== undefined && event.type === exports.PointerEventType.Over;
}
exports.isPointerOverEvent = isPointerOverEvent;
//# sourceMappingURL=settings.js.map