"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_1 = require("lodash");
var commons_1 = require("../../utils/commons");
var __1 = require("../..");
var data_1 = require("./data");
var MockDataSeries = /** @class */ (function () {
    function MockDataSeries() {
    }
    MockDataSeries.default = function (partial) {
        return commons_1.mergePartial(MockDataSeries.base, partial, { mergeOptionalPartialValues: true });
    };
    MockDataSeries.fitFunction = function (options) {
        if (options === void 0) { options = { shuffle: true, ordinal: false }; }
        var ordinalData = options.ordinal
            ? data_1.fitFunctionData.map(function (d) { return (__assign(__assign({}, d), { x: String.fromCharCode(97 + d.x) })); })
            : data_1.fitFunctionData;
        var data = options.shuffle && !options.ordinal ? lodash_1.shuffle(ordinalData) : ordinalData;
        return __assign(__assign({}, MockDataSeries.base), { data: data });
    };
    MockDataSeries.withData = function (data) {
        return __assign(__assign({}, MockDataSeries.base), { data: data });
    };
    MockDataSeries.base = {
        specId: __1.getSpecId('spec1'),
        seriesKeys: ['spec1'],
        yAccessor: 'y',
        splitAccessors: new Map(),
        key: 'spec1',
        data: [],
    };
    return MockDataSeries;
}());
exports.MockDataSeries = MockDataSeries;
var MockRawDataSeries = /** @class */ (function () {
    function MockRawDataSeries() {
    }
    MockRawDataSeries.default = function (partial) {
        return commons_1.mergePartial(MockRawDataSeries.base, partial);
    };
    MockRawDataSeries.fitFunction = function (options) {
        if (options === void 0) { options = { shuffle: true, ordinal: false }; }
        var rawData = data_1.fitFunctionData.map(function (_a) {
            var initialY0 = _a.initialY0, initialY1 = _a.initialY1, filled = _a.filled, datum = __rest(_a, ["initialY0", "initialY1", "filled"]);
            return datum;
        });
        var ordinalData = options.ordinal
            ? rawData.map(function (d) { return (__assign(__assign({}, d), { x: String.fromCharCode(97 + d.x) })); })
            : rawData;
        var data = options.shuffle && !options.ordinal ? lodash_1.shuffle(ordinalData) : ordinalData;
        return __assign(__assign({}, MockRawDataSeries.base), { data: data });
    };
    MockRawDataSeries.withData = function (data) {
        return __assign(__assign({}, MockRawDataSeries.base), { data: data });
    };
    MockRawDataSeries.base = {
        specId: __1.getSpecId('spec1'),
        seriesKeys: ['spec1'],
        yAccessor: 'y',
        splitAccessors: new Map(),
        key: 'spec1',
        data: [],
    };
    return MockRawDataSeries;
}());
exports.MockRawDataSeries = MockRawDataSeries;
var MockDataSeriesDatum = /** @class */ (function () {
    function MockDataSeriesDatum() {
    }
    MockDataSeriesDatum.default = function (partial) {
        return commons_1.mergePartial(MockDataSeriesDatum.base, partial, { mergeOptionalPartialValues: true });
    };
    /**
     * Fill datum with minimal values, default missing required values to `null`
     */
    MockDataSeriesDatum.simple = function (_a) {
        var x = _a.x, _b = _a.y1, y1 = _b === void 0 ? null : _b, _c = _a.y0, y0 = _c === void 0 ? null : _c, filled = _a.filled;
        return __assign({ x: x,
            y1: y1,
            y0: y0, initialY1: y1, initialY0: y0 }, (filled && filled));
    };
    /**
     * returns "full" datum with minimal values, default missing required values to `null`
     *
     * "full" - means x and y1 values are `non-nullable`
     */
    MockDataSeriesDatum.full = function (_a) {
        var _b = _a.fittingIndex, fittingIndex = _b === void 0 ? 0 : _b, datum = __rest(_a, ["fittingIndex"]);
        return __assign(__assign({}, MockDataSeriesDatum.simple(datum)), { fittingIndex: fittingIndex });
    };
    MockDataSeriesDatum.ordinal = function (partial) {
        return commons_1.mergePartial(__assign(__assign({}, MockDataSeriesDatum.base), { x: 'a' }), partial, { mergeOptionalPartialValues: true });
    };
    MockDataSeriesDatum.base = {
        x: 1,
        y1: 1,
        y0: 1,
        initialY1: 1,
        initialY0: 1,
        datum: {},
    };
    return MockDataSeriesDatum;
}());
exports.MockDataSeriesDatum = MockDataSeriesDatum;
var MockRawDataSeriesDatum = /** @class */ (function () {
    function MockRawDataSeriesDatum() {
    }
    MockRawDataSeriesDatum.default = function (partial) {
        return commons_1.mergePartial(MockRawDataSeriesDatum.base, partial);
    };
    /**
     * Fill raw datum with minimal values, default missing required values to `null`
     */
    MockRawDataSeriesDatum.simple = function (_a) {
        var x = _a.x, _b = _a.y1, y1 = _b === void 0 ? null : _b, _c = _a.y0, y0 = _c === void 0 ? null : _c;
        return {
            x: x,
            y1: y1,
            y0: y0,
        };
    };
    MockRawDataSeriesDatum.ordinal = function (partial) {
        return commons_1.mergePartial(__assign(__assign({}, MockRawDataSeriesDatum.base), { x: 'a' }), partial);
    };
    MockRawDataSeriesDatum.base = {
        x: 1,
        y1: 1,
        y0: 1,
        datum: {},
    };
    return MockRawDataSeriesDatum;
}());
exports.MockRawDataSeriesDatum = MockRawDataSeriesDatum;
//# sourceMappingURL=series.js.map