"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importDefault(require("react"));
var fast_deep_equal_1 = require("../../utils/fast_deep_equal");
var alert_1 = require("./assets/alert");
var dot_1 = require("./assets/dot");
var empty_1 = require("./assets/empty");
var eye_1 = require("./assets/eye");
var eye_closed_1 = require("./assets/eye_closed");
var list_1 = require("./assets/list");
var question_in_circle_1 = require("./assets/question_in_circle");
var typeToIconMap = {
    alert: alert_1.AlertIcon,
    dot: dot_1.DotIcon,
    empty: empty_1.EmptyIcon,
    eye: eye_1.EyeIcon,
    eyeClosed: eye_closed_1.EyeClosedIcon,
    list: list_1.ListIcon,
    questionInCircle: question_in_circle_1.QuestionInCircle,
};
var Icon = /** @class */ (function (_super) {
    __extends(Icon, _super);
    function Icon() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Icon.prototype.shouldComponentUpdate = function (nextProps) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps);
    };
    Icon.prototype.render = function () {
        var _a = this.props, type = _a.type, color = _a.color, className = _a.className, tabIndex = _a.tabIndex, rest = __rest(_a, ["type", "color", "className", "tabIndex"]);
        var optionalCustomStyles = null;
        if (color) {
            optionalCustomStyles = { color: color };
        }
        var classes = classnames_1.default('echIcon', className);
        var Svg = (type && typeToIconMap[type]) || empty_1.EmptyIcon;
        // This is a fix for IE and Edge, which ignores tabindex="-1" on an SVG, but respects
        // focusable="false".
        //   - If there's no tab index specified, we'll default the icon to not be focusable,
        //     which is how SVGs behave in Chrome, Safari, and FF.
        //   - If tab index is -1, then the consumer wants the icon to not be focusable.
        //   - For all other values, the consumer wants the icon to be focusable.
        var focusable = tabIndex == null || tabIndex === -1 ? 'false' : 'true';
        return react_1.default.createElement(Svg, __assign({ className: classes }, optionalCustomStyles, { tabIndex: tabIndex, focusable: focusable }, rest));
    };
    return Icon;
}(react_1.default.Component));
exports.Icon = Icon;
//# sourceMappingURL=icon.js.map