"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var get_settings_specs_1 = require("../state/selectors/get_settings_specs");
var ChartStatusComponent = /** @class */ (function (_super) {
    __extends(ChartStatusComponent, _super);
    function ChartStatusComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dispatchRenderChange = function () {
            var _a = _this.props, onRenderChange = _a.onRenderChange, rendered = _a.rendered;
            if (onRenderChange) {
                onRenderChange(rendered);
            }
        };
        return _this;
    }
    ChartStatusComponent.prototype.componentDidMount = function () {
        this.dispatchRenderChange();
    };
    ChartStatusComponent.prototype.componentDidUpdate = function () {
        this.dispatchRenderChange();
    };
    ChartStatusComponent.prototype.render = function () {
        var _a = this.props, rendered = _a.rendered, renderedCount = _a.renderedCount;
        return react_1.default.createElement("div", { className: "echChartStatus", "data-ech-render-complete": rendered, "data-ech-render-count": renderedCount });
    };
    return ChartStatusComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    return {
        rendered: state.chartRendered,
        renderedCount: state.chartRenderedCount,
        onRenderChange: get_settings_specs_1.getSettingsSpecSelector(state).onRenderChange,
    };
};
exports.ChartStatus = react_redux_1.connect(mapStateToProps)(ChartStatusComponent);
//# sourceMappingURL=chart_status.js.map