"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var __1 = require("../..");
var tooltips_1 = require("../renderer/dom/tooltips");
var commons_1 = require("../../../utils/commons");
var highlighter_1 = require("../renderer/dom/highlighter");
var crosshair_1 = require("../renderer/dom/crosshair");
var annotation_tooltips_1 = require("../renderer/dom/annotation_tooltips");
var is_brush_available_1 = require("./selectors/is_brush_available");
var brush_1 = require("../renderer/dom/brush");
var is_chart_empty_1 = require("./selectors/is_chart_empty");
var reactive_chart_1 = require("../renderer/canvas/reactive_chart");
var compute_legend_1 = require("./selectors/compute_legend");
var get_legend_tooltip_values_1 = require("./selectors/get_legend_tooltip_values");
var get_cursor_pointer_1 = require("./selectors/get_cursor_pointer");
var XYAxisChartState = /** @class */ (function () {
    function XYAxisChartState() {
        this.chartType = __1.ChartTypes.XYAxis;
        this.legendId = commons_1.htmlIdGenerator()('legend');
    }
    XYAxisChartState.prototype.isBrushAvailable = function (globalState) {
        return is_brush_available_1.isBrushAvailableSelector(globalState);
    };
    XYAxisChartState.prototype.isChartEmpty = function (globalState) {
        return is_chart_empty_1.isChartEmptySelector(globalState);
    };
    XYAxisChartState.prototype.getLegendItems = function (globalState) {
        return compute_legend_1.computeLegendSelector(globalState);
    };
    XYAxisChartState.prototype.getLegendItemsValues = function (globalState) {
        return get_legend_tooltip_values_1.getLegendTooltipValuesSelector(globalState);
    };
    XYAxisChartState.prototype.chartRenderer = function (containerRef, forwardStageRef) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(crosshair_1.Crosshair, null),
            react_1.default.createElement(reactive_chart_1.ReactiveChart, { forwardStageRef: forwardStageRef }),
            react_1.default.createElement(tooltips_1.Tooltips, { getChartContainerRef: containerRef }),
            react_1.default.createElement(annotation_tooltips_1.AnnotationTooltip, { getChartContainerRef: containerRef }),
            react_1.default.createElement(highlighter_1.Highlighter, null),
            react_1.default.createElement(brush_1.BrushTool, null)));
    };
    XYAxisChartState.prototype.getPointerCursor = function (globalState) {
        return get_cursor_pointer_1.getPointerCursorSelector(globalState);
    };
    return XYAxisChartState;
}());
exports.XYAxisChartState = XYAxisChartState;
//# sourceMappingURL=chart_state.js.map