"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var react_redux_1 = require("react-redux");
var is_initialized_1 = require("../../../../state/selectors/is_initialized");
var compute_chart_transform_1 = require("../../state/selectors/compute_chart_transform");
var get_brush_area_1 = require("../../state/selectors/get_brush_area");
var is_brush_available_1 = require("../../state/selectors/is_brush_available");
var compute_chart_dimensions_1 = require("../../state/selectors/compute_chart_dimensions");
var is_brushing_1 = require("../../state/selectors/is_brushing");
var BrushToolComponent = /** @class */ (function (_super) {
    __extends(BrushToolComponent, _super);
    function BrushToolComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderBrushTool = function (brushArea) {
            if (!brushArea) {
                return null;
            }
            var top = brushArea.top, left = brushArea.left, width = brushArea.width, height = brushArea.height;
            return react_1.default.createElement(react_konva_1.Rect, { x: left, y: top, width: width, height: height, fill: "gray", opacity: 0.6 });
        };
        return _this;
    }
    BrushToolComponent.prototype.render = function () {
        var _a = this.props, initialized = _a.initialized, isBrushAvailable = _a.isBrushAvailable, isBrushing = _a.isBrushing, chartDimensions = _a.chartDimensions, chartTransform = _a.chartTransform, brushArea = _a.brushArea;
        if (!initialized || !isBrushAvailable || !isBrushing) {
            return null;
        }
        return (react_1.default.createElement(react_konva_1.Stage, { width: chartDimensions.width, height: chartDimensions.height, className: "echBrushTool", style: {
                top: chartDimensions.top + chartTransform.x,
                left: chartDimensions.left + chartTransform.y,
                width: chartDimensions.width,
                height: chartDimensions.height,
            } },
            react_1.default.createElement(react_konva_1.Layer, { hitGraphEnabled: false, listening: false }, this.renderBrushTool(brushArea))));
    };
    BrushToolComponent.displayName = 'BrushToolComponent';
    return BrushToolComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    if (!is_initialized_1.isInitialized(state)) {
        return {
            initialized: false,
            isBrushing: false,
            isBrushAvailable: false,
            brushArea: null,
            chartDimensions: {
                top: 0,
                left: 0,
                width: 0,
                height: 0,
            },
            chartTransform: {
                x: 0,
                y: 0,
                rotate: 0,
            },
        };
    }
    return {
        initialized: state.specsInitialized,
        brushArea: get_brush_area_1.getBrushAreaSelector(state),
        isBrushAvailable: is_brush_available_1.isBrushAvailableSelector(state),
        chartDimensions: compute_chart_dimensions_1.computeChartDimensionsSelector(state).chartDimensions,
        chartTransform: compute_chart_transform_1.computeChartTransformSelector(state),
        isBrushing: is_brushing_1.isBrushingSelector(state),
    };
};
exports.BrushTool = react_redux_1.connect(mapStateToProps)(BrushToolComponent);
//# sourceMappingURL=brush.js.map