"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var globals_1 = require("../../../../../components/react_canvas/globals");
/**
 * Return the style of a point.
 * The color value is used for stroke or fill if they are undefind in the PointStyle
 * @param color the series color
 * @param pointStyle the merged point style
 */
function buildPointStyleProps(color, pointStyle, geometryStateStyle) {
    var strokeWidth = pointStyle.strokeWidth, opacity = pointStyle.opacity;
    var stroke = pointStyle.stroke || color;
    var fill = pointStyle.fill || color;
    return __assign(__assign({ radius: pointStyle.radius, stroke: stroke,
        strokeWidth: strokeWidth, strokeEnabled: strokeWidth !== 0, fill: fill }, geometryStateStyle), { opacity: opacity * geometryStateStyle.opacity });
}
exports.buildPointStyleProps = buildPointStyleProps;
/**
 * Return the rendering props for a point
 * @param x the x position of the point
 * @param y the y position of the point
 * @param pointStyleProps the style props of the point
 */
function buildPointRenderProps(x, y, pointStyleProps) {
    return __assign(__assign({ x: x,
        y: y }, pointStyleProps), globals_1.GlobalKonvaElementProps);
}
exports.buildPointRenderProps = buildPointRenderProps;
/**
 * Return the rendering props for a line. The color of the line will be overwritten
 * by the stroke color of the lineStyle parameter if present
 * @param x the horizontal offset to place the line
 * @param linePath the SVG line path
 * @param color the computed color of the line for this series
 * @param lineStyle the line style
 * @param geometryStateStyle the highlight geometry style
 */
function buildLineRenderProps(x, linePath, color, lineStyle, geometryStateStyle) {
    var opacity = lineStyle.opacity * geometryStateStyle.opacity;
    return __assign(__assign(__assign({ x: x, data: linePath, stroke: lineStyle.stroke || color, strokeWidth: lineStyle.strokeWidth, lineCap: 'round', lineJoin: 'round' }, geometryStateStyle), { opacity: opacity }), globals_1.GlobalKonvaElementProps);
}
exports.buildLineRenderProps = buildLineRenderProps;
/**
 * Return the rendering props for an area. The color of the area will be overwritten
 * by the fill color of the areaStyle parameter if present
 * @param areaPath the SVG area path
 * @param x the horizontal offset to place the area
 * @param color the computed color of the line for this series
 * @param areaStyle the area style
 * @param geometryStateStyle the highlight geometry style
 */
function buildAreaRenderProps(xTransform, areaPath, color, areaStyle, geometryStateStyle) {
    var opacity = areaStyle.opacity * geometryStateStyle.opacity;
    return __assign(__assign(__assign({ x: xTransform, data: areaPath, fill: areaStyle.fill || color, lineCap: 'round', lineJoin: 'round' }, geometryStateStyle), { opacity: opacity }), globals_1.GlobalKonvaElementProps);
}
exports.buildAreaRenderProps = buildAreaRenderProps;
/**
 * Return the rendering props for a bar. The color of the bar will be overwritten
 * by the fill color of the rectStyle parameter if present
 * @param x the x position of the rect
 * @param y the y position of the rect
 * @param width the width of the rect
 * @param height the height of the rect
 * @param color the computed color of the rect for this series
 * @param rectStyle the rect style
 * @param geometryStateStyle the highlight geometry style
 */
function buildBarRenderProps(x, y, width, height, color, rectStyle, borderStyle, geometryStateStyle) {
    var opacity = rectStyle.opacity * geometryStateStyle.opacity;
    var stroke = borderStyle.stroke, visible = borderStyle.visible, strokeWidth = borderStyle.strokeWidth, _a = borderStyle.strokeOpacity, strokeOpacity = _a === void 0 ? 0 : _a;
    var offset = !visible || strokeWidth <= 0 || !stroke || strokeOpacity <= 0 || opacity <= 0 ? 0 : strokeWidth;
    return __assign(__assign(__assign({ x: x + offset, y: y + offset, width: width - 2 * offset, height: height - 2 * offset, fill: rectStyle.fill || color, strokeEnabled: false }, geometryStateStyle), { opacity: opacity }), globals_1.GlobalKonvaElementProps);
}
exports.buildBarRenderProps = buildBarRenderProps;
/**
 * Return the rendering props for a bar. The color of the bar will be overwritten
 * by the fill color of the rectStyle parameter if present
 * @param x the x position of the rect
 * @param y the y position of the rect
 * @param width the width of the rect
 * @param height the height of the rect
 * @param color the computed color of the rect for this series
 * @param rectStyle the rect style
 * @param borderStyle the border rect style
 * @param geometryStyle the highlight geometry style
 */
function buildBarBorderRenderProps(x, y, width, height, rectStyle, borderStyle, geometryStateStyle) {
    var stroke = borderStyle.stroke, visible = borderStyle.visible, strokeWidth = borderStyle.strokeWidth, _a = borderStyle.strokeOpacity, strokeOpacity = _a === void 0 ? rectStyle.opacity : _a;
    var opacity = strokeOpacity * geometryStateStyle.opacity;
    if (!visible || strokeWidth <= 0 || !stroke || opacity <= 0) {
        return null;
    }
    return __assign(__assign(__assign({ x: x + strokeWidth / 2, y: y + strokeWidth / 2, width: width - strokeWidth, height: height - strokeWidth, fillEnabled: false, strokeEnabled: true, strokeWidth: strokeWidth,
        stroke: stroke }, geometryStateStyle), { opacity: opacity }), globals_1.GlobalKonvaElementProps);
}
exports.buildBarBorderRenderProps = buildBarBorderRenderProps;
//# sourceMappingURL=rendering_props_utils.js.map