/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.lang.CompoundRuntimeException;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.Message;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusConnectionImpl;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = (bus1, bus2) -> ContainerUtil.compareLexicographically(bus1.myOrder, bus2.myOrder);
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue = MessageBusImpl.createThreadLocalQueue();
    private List<Integer> myOrder;
    private final ConcurrentMap<Topic, Object> myPublishers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscriberCache = ContainerUtil.newConcurrentMap();
    private final List<MessageBusImpl> myChildBuses = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    private final String myOwner;
    private boolean myDisposed;
    private final Disposable myConnectionDisposable;

    private MessageBusImpl(Object owner) {
        this.myOwner = owner + " of " + owner.getClass();
        this.myConnectionDisposable = Disposer.newDisposable(this.myOwner);
        this.myOrder = new ArrayList<Integer>();
    }

    @NotNull
    private RootBus getRootBus() {
        RootBus rootBus = this.myParentBus != null ? this.myParentBus.getRootBus() : this.asRoot();
        if (rootBus == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        return rootBus;
    }

    private MessageBusImpl rootBus() {
        return this.getRootBus();
    }

    private RootBus asRoot() {
        if (this instanceof RootBus) {
            return (RootBus)this;
        }
        throw new AssertionError((Object)("Accessing disposed message bus " + this));
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.myDisposed ? "; disposed" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChildBusDisposed(MessageBusImpl childBus) {
        boolean removed2;
        List<MessageBusImpl> list2 = this.myChildBuses;
        synchronized (list2) {
            removed2 = this.myChildBuses.remove(childBus);
        }
        Map map2 = (Map)this.getRootBus().myWaitingBuses.get();
        if (map2 != null) {
            map2.remove(childBus);
        }
        this.rootBus().clearSubscriberCache();
        LOG.assertTrue(removed2);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        MessageBusConnection messageBusConnection = this.connect(this.myConnectionDisposable);
        if (messageBusConnection == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        return messageBusConnection;
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(4);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(final @NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        this.checkNotDisposed();
        Object publisher = this.myPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler2 = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy2, Method method, Object[] args) {
                    if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                        return EventDispatcher.handleObjectMethod(proxy2, args, method.getName());
                    }
                    MessageBusImpl.this.sendMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler2);
            publisher = ConcurrencyUtil.cacheOrGet(this.myPublishers, topic, publisher);
        }
        Object v = publisher;
        if (v == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        return (L)v;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        this.myDisposed = true;
        for (MessageBusImpl childBus : this.myChildBuses) {
            Disposer.dispose(childBus);
        }
        Disposer.dispose(this.myConnectionDisposable);
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
            this.myParentBus = null;
        } else {
            this.asRoot().myWaitingBuses.remove();
        }
    }

    private void checkNotDisposed() {
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
    }

    private void calcSubscribers(Topic topic, List<MessageBusConnectionImpl> result2) {
        Topic.BroadcastDirection direction2;
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers != null) {
            result2.addAll(topicSubscribers);
        }
        if ((direction2 = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.calcSubscribers(topic, result2);
            }
        }
        if (direction2 == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result2);
        }
    }

    private void postMessage(Message message2) {
        this.checkNotDisposed();
        List<MessageBusConnectionImpl> topicSubscribers = this.getTopicSubscribers(message2.getTopic());
        if (!topicSubscribers.isEmpty()) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                subscriber.getBus().myMessageQueue.get().offer(new DeliveryJob(subscriber, message2));
                subscriber.getBus().notifyPendingJobChange(1);
                subscriber.scheduleMessageDelivery(message2);
            }
        }
    }

    @NotNull
    private List<MessageBusConnectionImpl> getTopicSubscribers(Topic topic) {
        SmartList<MessageBusConnectionImpl> topicSubscribers = (SmartList<MessageBusConnectionImpl>)this.mySubscriberCache.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = new SmartList<MessageBusConnectionImpl>();
            this.calcSubscribers(topic, topicSubscribers);
            this.mySubscriberCache.put(topic, topicSubscribers);
        }
        SmartList<MessageBusConnectionImpl> smartList = topicSubscribers;
        if (smartList == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count2;
        int newCount;
        ThreadLocal ref = this.getRootBus().myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map2 = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map2 == null) {
            map2 = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map2);
        }
        if ((newCount = (count2 = (countObject = (Integer)map2.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map2.put(this, newCount);
        } else if (newCount == 0) {
            map2.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(Message message2) {
        this.pumpMessages();
        this.postMessage(message2);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            Map map2 = (Map)this.asRoot().myWaitingBuses.get();
            if (map2 != null && !map2.isEmpty()) {
                SmartList<MessageBusImpl> liveBuses = null;
                for (MessageBusImpl bus : map2.keySet()) {
                    if (!MessageBusImpl.ensureAlive(map2, bus)) continue;
                    if (liveBuses == null) {
                        liveBuses = new SmartList<MessageBusImpl>();
                    }
                    liveBuses.add(bus);
                }
                if (liveBuses != null) {
                    MessageBusImpl.pumpWaitingBuses(liveBuses);
                }
            }
        }
    }

    private static void pumpWaitingBuses(List<? extends MessageBusImpl> buses) {
        List<Throwable> exceptions = null;
        for (MessageBusImpl messageBusImpl : buses) {
            if (messageBusImpl.myDisposed) continue;
            exceptions = MessageBusImpl.appendExceptions(exceptions, messageBusImpl.doPumpMessages());
        }
        MessageBusImpl.rethrowExceptions(exceptions);
    }

    private static List<Throwable> appendExceptions(List<Throwable> exceptions, List<? extends Throwable> busExceptions) {
        if (!busExceptions.isEmpty()) {
            if (exceptions == null) {
                exceptions = new SmartList<Throwable>();
            }
            exceptions.addAll(busExceptions);
        }
        return exceptions;
    }

    private static void rethrowExceptions(List<Throwable> exceptions) {
        if (exceptions == null) {
            return;
        }
        ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
        if (pce != null) {
            throw pce;
        }
        CompoundRuntimeException.throwIfNotEmpty(exceptions);
    }

    private static boolean ensureAlive(Map<MessageBusImpl, Integer> map2, MessageBusImpl bus) {
        if (bus.myDisposed) {
            map2.remove(bus);
            LOG.error("Accessing disposed message bus " + bus);
            return false;
        }
        return true;
    }

    private List<Throwable> doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        SmartList<Throwable> exceptions = null;
        while ((job = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            try {
                job.connection.deliverMessage(job.message);
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(e);
            }
        }
        return exceptions == null ? Collections.emptyList() : exceptions;
    }

    void notifyOnSubscription(@NotNull MessageBusConnectionImpl connection, @NotNull Topic<?> topic) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(10);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(11);
        }
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.rootBus().clearSubscriberCache();
    }

    private void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(MessageBusConnectionImpl connection) {
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        this.rootBus().clearSubscriberCache();
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        ThreadLocal<Queue<T>> threadLocal = ThreadLocal.withInitial(ConcurrentLinkedQueue::new);
        if (threadLocal == null) {
            MessageBusImpl.$$$reportNull$$$0(12);
        }
        return threadLocal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootBus";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopicSubscribers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createThreadLocalQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses;

        public RootBus(@NotNull Object owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            super(owner);
            this.myWaitingBuses = new ThreadLocal();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
        }
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        DeliveryJob(MessageBusConnectionImpl connection, Message message2) {
            this.connection = connection;
            this.message = message2;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection + "; message: " + this.message + " }";
        }
    }
}

