/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LoggerRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;
import org.jetbrains.kotlin.com.intellij.util.lang.CachePoolImpl;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassLoadingLocks;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

public class UrlClassLoader
extends ClassLoader {
    private static final Set<Class<?>> ourParallelCapableLoaders;
    private static final boolean ourClassPathIndexEnabled;
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final ClassLoadingLocks myClassLoadingLocks;
    private final boolean myAllowBootstrapResources;

    protected static void markParallelCapable(Class<? extends UrlClassLoader> loaderClass) {
        assert (ourParallelCapableLoaders != null);
        ourParallelCapableLoaders.add(loaderClass);
    }

    @NotNull
    protected ClassPath getClassPath() {
        ClassPath classPath2 = this.myClassPath;
        if (classPath2 == null) {
            UrlClassLoader.$$$reportNull$$$0(0);
        }
        return classPath2;
    }

    @NotNull
    public static Builder build() {
        Builder builder = new Builder();
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(1);
        }
        return builder;
    }

    protected UrlClassLoader(@NotNull Builder builder) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(3);
        }
        super(builder.myParent);
        this.myURLs = ContainerUtilRt.map2List(builder.myURLs, new Function<URL, URL>(){

            @Override
            public URL fun(URL url) {
                return UrlClassLoader.internProtocol(url);
            }
        });
        this.myClassPath = this.createClassPath(builder);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
        this.myClassLoadingLocks = ourParallelCapableLoaders != null && ourParallelCapableLoaders.contains(this.getClass()) ? new ClassLoadingLocks() : null;
    }

    @NotNull
    protected final ClassPath createClassPath(@NotNull Builder builder) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(4);
        }
        ClassPath classPath2 = new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myPreload, builder.myUsePersistentClasspathIndex, builder.myCachePool, builder.myCachingCondition, builder.myErrorOnMissingJar, builder.myLazyClassloadingCaches);
        if (classPath2 == null) {
            UrlClassLoader.$$$reportNull$$$0(5);
        }
        return classPath2;
    }

    public static URL internProtocol(@NotNull URL url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(6);
        }
        try {
            String protocol = url.getProtocol();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                return new URL(protocol.intern(), url.getHost(), url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            LoggerRt.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    public List<URL> getUrls() {
        return Collections.unmodifiableList(this.myURLs);
    }

    public boolean hasLoadedClass(String name) {
        Class<?> aClass2 = this.findLoadedClass(name);
        return aClass2 != null && aClass2.getClassLoader() == this;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class clazz2 = this._findClass(name);
        if (clazz2 == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz2;
    }

    @Nullable
    protected final Class _findClass(@NotNull String name) {
        Resource res2;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(8);
        }
        if ((res2 = this.getClassPath().getResource(name.replace('.', '/') + ".class")) == null) {
            return null;
        }
        try {
            return this.defineClass(name, res2);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class defineClass(String name, Resource res2) throws IOException {
        String pkgName;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, res2.getValue(Resource.Attribute.SPEC_TITLE), res2.getValue(Resource.Attribute.SPEC_VERSION), res2.getValue(Resource.Attribute.SPEC_VENDOR), res2.getValue(Resource.Attribute.IMPL_TITLE), res2.getValue(Resource.Attribute.IMPL_VERSION), res2.getValue(Resource.Attribute.IMPL_VENDOR), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res2.getBytes();
        return this._defineClass(name, b);
    }

    protected Class _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    public URL findResource(String name) {
        Resource res2 = this.findResourceImpl(name);
        return res2 != null ? res2.getURL() : null;
    }

    @Nullable
    private Resource findResourceImpl(String name) {
        String n = FileUtilRt.toCanonicalPath(name, '/', false);
        Resource resource = this.getClassPath().getResource(n);
        if (resource == null && n.startsWith("/")) {
            resource = this.getClassPath().getResource(n.substring(1));
        }
        return resource;
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            return super.getResourceAsStream(name);
        }
        try {
            Resource res2 = this.findResourceImpl(name);
            return res2 != null ? res2.getInputStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getClassPath().getResources(name);
    }

    @Override
    @NotNull
    protected Object getClassLoadingLock(String className2) {
        Object object = this.myClassLoadingLocks != null ? this.myClassLoadingLocks.getOrCreateLock(className2) : this;
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(9);
        }
        return object;
    }

    static {
        boolean capable;
        boolean isAtLeastJava7 = !System.getProperty("java.runtime.version", "unknown").startsWith("1.6.");
        boolean ibmJvm = System.getProperty("java.vm.vendor", "unknown").toLowerCase(Locale.US).contains("ibm");
        boolean bl = capable = isAtLeastJava7 && !ibmJvm && Boolean.parseBoolean(System.getProperty("use.parallel.class.loading", "true"));
        if (capable) {
            ourParallelCapableLoaders = Collections.synchronizedSet(new HashSet());
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                if (Boolean.TRUE.equals(registerAsParallelCapable.invoke(null, new Object[0]))) {
                    ourParallelCapableLoaders.add(UrlClassLoader.class);
                }
            }
            catch (Exception exception) {}
        } else {
            ourParallelCapableLoaders = null;
        }
        ourClassPathIndexEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachePool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createClassPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "internProtocol";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "_findClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CachingCondition {
        public boolean shouldCacheData(@NotNull URL var1);
    }

    public static final class Builder {
        private List<URL> myURLs = ContainerUtilRt.emptyList();
        private ClassLoader myParent;
        private boolean myLockJars;
        private boolean myUseCache;
        private boolean myUsePersistentClasspathIndex;
        private boolean myAcceptUnescaped;
        private boolean myPreload = true;
        private boolean myAllowBootstrapResources;
        private boolean myErrorOnMissingJar = true;
        private boolean myLazyClassloadingCaches;
        @Nullable
        private CachePoolImpl myCachePool;
        @Nullable
        private CachingCondition myCachingCondition;

        private Builder() {
        }

        @NotNull
        public Builder urls(@NotNull List<URL> urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myURLs = urls;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder allowLock() {
            this.myLockJars = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder useCache() {
            this.myUseCache = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pool";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "urls";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parent";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowLock";
                    break;
                }
                case 7: 
                case 8: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useCache";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "usePersistentClasspathIndexForLocalClassDirectories";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowUnescaped";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "noPreload";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowBootstrapResources";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLogErrorOnMissingJar";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useLazyClassloadingCaches";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "useCache";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

