/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import org.gradle.StartParameter;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskExecutionMode;
import org.gradle.api.internal.changedetection.TaskExecutionModeResolver;
import org.gradle.api.internal.project.taskfactory.AbstractIncrementalTaskAction;
import org.gradle.api.internal.tasks.InputChangesAwareTaskAction;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.api.specs.AndSpec;
import org.gradle.util.DeprecationLogger;

@NonNullApi
public class DefaultTaskExecutionModeResolver
implements TaskExecutionModeResolver {
    private final StartParameter startParameter;

    public DefaultTaskExecutionModeResolver(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TaskExecutionMode getExecutionMode(TaskInternal task, TaskProperties properties) {
        AndSpec<? super TaskInternal> upToDateSpec = task.getOutputs().getUpToDateSpec();
        if (!properties.hasDeclaredOutputs() && upToDateSpec.isEmpty()) {
            if (!task.hasTaskActions()) return TaskExecutionMode.NO_OUTPUTS_WITHOUT_ACTIONS;
            if (!DefaultTaskExecutionModeResolver.requiresInputChanges(task)) return TaskExecutionMode.NO_OUTPUTS_WITH_ACTIONS;
            DeprecationLogger.nagUserOfDeprecated((String)"Using the incremental task API without declaring any outputs", (String)"Please declare output files for your task or use `TaskOutputs.upToDateWhen()`.");
        }
        if (this.startParameter.isRerunTasks()) {
            return TaskExecutionMode.RERUN_TASKS_ENABLED;
        }
        if (upToDateSpec.isSatisfiedBy((Object)task)) return TaskExecutionMode.INCREMENTAL;
        return TaskExecutionMode.UP_TO_DATE_WHEN_FALSE;
    }

    private static boolean requiresInputChanges(TaskInternal task) {
        for (InputChangesAwareTaskAction taskAction : task.getTaskActions()) {
            if (!(taskAction instanceof AbstractIncrementalTaskAction)) continue;
            return true;
        }
        return false;
    }
}

