/* libide-3.34.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Ide", gir_namespace = "Ide", gir_version = "3.34", lower_case_cprefix = "ide_")]
namespace Ide {
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_application_get_type ()")]
	public class Application : Dazzle.Application, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		protected Application ();
		public void add_workbench (Ide.Workbench workbench);
		[Version (since = "3.34")]
		public unowned Ide.ApplicationAddin? find_addin_by_module_name (string module_name);
		[Version (since = "3.32")]
		public unowned Ide.Workbench? find_workbench_for_file (GLib.File file);
		[Version (since = "3.32")]
		public void foreach_workbench (GLib.Func callback);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.32")]
		public string[]? get_argv (GLib.ApplicationCommandLine cmdline);
		public bool get_command_line_handled (GLib.ApplicationCommandLine cmdline);
		[Version (since = "3.32")]
		public unowned GLib.DateTime get_started_at ();
		[Version (since = "3.32")]
		public async GLib.DBusProxy get_worker_async (string plugin_name, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public bool has_network ();
		public async Ide.Workbench open_project_async (Ide.ProjectInfo project_info, GLib.Type workspace_type, GLib.Cancellable? cancellable) throws GLib.Error;
		public void remove_workbench (Ide.Workbench workbench);
		public void set_command_line_handled (GLib.ApplicationCommandLine cmdline, bool handled);
		[Version (since = "3.32")]
		public void set_workspace_type (GLib.Type workspace_type);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_buffer_get_type ()")]
	public class Buffer : Gtk.SourceBuffer {
		[CCode (has_construct_function = false)]
		protected Buffer ();
		[Version (since = "3.32")]
		public unowned Ide.BufferAddin? addin_find_by_module_name (string module_name);
		[Version (since = "3.32")]
		public GLib.Bytes dup_content ();
		[Version (since = "3.32")]
		public string dup_title ();
		[Version (since = "3.32")]
		public string dup_uri ();
		[Version (since = "3.32")]
		public async bool format_selection_async (Ide.FormatterOptions options, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public uint get_change_count ();
		[Version (since = "3.32")]
		public unowned Ide.BufferChangeMonitor? get_change_monitor ();
		[Version (since = "3.32")]
		public bool get_changed_on_volume ();
		[Version (since = "3.32")]
		public unowned Ide.Diagnostics? get_diagnostics ();
		[Version (since = "3.32")]
		public bool get_failed ();
		[Version (since = "3.32")]
		public unowned GLib.Error get_failure ();
		[Version (since = "3.32")]
		public unowned GLib.File get_file ();
		[Version (since = "3.32")]
		public unowned Ide.FileSettings? get_file_settings ();
		[Version (since = "3.32")]
		public unowned Ide.Formatter? get_formatter ();
		[Version (since = "3.32")]
		public bool get_highlight_diagnostics ();
		[Version (since = "3.32")]
		public Ide.Location get_insert_location ();
		[Version (since = "3.32")]
		public bool get_is_temporary ();
		[Version (since = "3.32")]
		public void get_iter_at_location (out Gtk.TextIter iter, Ide.Location location);
		[Version (since = "3.32")]
		public Ide.Location get_iter_location (Gtk.TextIter iter);
		[Version (since = "3.32")]
		public unowned string? get_language_id ();
		[Version (since = "3.32")]
		public string? get_line_text (uint line);
		[Version (since = "3.32")]
		public bool get_loading ();
		[Version (since = "3.32")]
		public bool get_read_only ();
		[Version (since = "3.32")]
		public unowned Ide.RenameProvider? get_rename_provider ();
		[Version (since = "3.32")]
		public void get_selection_bounds (out Gtk.TextIter insert, out Gtk.TextIter selection);
		[Version (since = "3.32")]
		public Ide.Range get_selection_range ();
		[Version (since = "3.32")]
		public Ide.BufferState get_state ();
		[Version (since = "3.32")]
		public unowned string? get_style_scheme_name ();
		[Version (since = "3.32")]
		public async Ide.Symbol get_symbol_at_location_async (Gtk.TextIter location, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public GLib.GenericArray<Ide.SymbolResolver> get_symbol_resolvers ();
		[Version (since = "3.32")]
		public string get_word_at_iter (Gtk.TextIter iter);
		[Version (since = "3.32")]
		public Ide.Buffer hold ();
		[Version (since = "3.32")]
		public Ide.Context ref_context ();
		[Version (since = "3.32")]
		public void rehighlight ();
		[Version (since = "3.32")]
		public void release ();
		[Version (since = "3.32")]
		public async bool save_file_async (GLib.File? file, GLib.Cancellable? cancellable, Ide.Notification notif) throws GLib.Error;
		[Version (since = "3.32")]
		public void set_change_monitor (Ide.BufferChangeMonitor? change_monitor);
		[Version (since = "3.32")]
		public void set_diagnostics (Ide.Diagnostics? diagnostics);
		[Version (since = "3.32")]
		public void set_highlight_diagnostics (bool highlight_diagnostics);
		public void set_language_id (string language_id);
		[Version (since = "3.32")]
		public void set_style_scheme_name (string? style_scheme_name);
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public Ide.BufferManager buffer_manager { construct; }
		[Version (since = "3.32")]
		public Ide.BufferChangeMonitor change_monitor { get; set; }
		[Version (since = "3.32")]
		public bool changed_on_volume { get; }
		[Version (since = "3.32")]
		public Ide.Diagnostics diagnostics { get; set; }
		[Version (since = "3.32")]
		public bool failed { get; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public GLib.File file { owned get; set; }
		[Version (since = "3.32")]
		public Ide.FileSettings file_settings { get; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public bool has_diagnostics { get; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public bool has_symbol_resolvers { get; }
		[Version (since = "3.32")]
		public bool highlight_diagnostics { get; set; }
		[Version (since = "3.32")]
		public bool is_temporary { get; construct; }
		[Version (since = "3.32")]
		public string language_id { get; set; }
		[Version (since = "3.32")]
		public bool read_only { get; }
		[Version (since = "3.32")]
		public Ide.BufferState state { get; }
		[Version (since = "3.32")]
		public string style_scheme_name { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public string title { owned get; }
		[Version (since = "3.32")]
		public signal void change_settled ();
		[Version (since = "3.32")]
		public signal void cursor_moved (Gtk.TextIter location);
		[Version (since = "3.32")]
		public signal void line_flags_changed ();
		[Version (since = "3.32")]
		public signal void loaded ();
		[Version (since = "3.32")]
		public signal void request_scroll_to_insert ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_buffer_change_monitor_get_type ()")]
	public class BufferChangeMonitor : Ide.Object {
		[CCode (has_construct_function = false)]
		protected BufferChangeMonitor ();
		public void emit_changed ();
		[Version (since = "3.32")]
		public virtual void foreach_change (uint line_begin, uint line_end, Ide.BufferChangeMonitorForeachFunc callback);
		[Version (since = "3.32")]
		public unowned Ide.Buffer get_buffer ();
		public virtual Ide.BufferLineChange get_change (uint line);
		[NoWrapper]
		public virtual void load (Ide.Buffer buffer);
		public virtual void reload ();
		public Ide.Buffer buffer { get; construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_buffer_manager_get_type ()")]
	public class BufferManager : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected BufferManager ();
		[Version (since = "3.32")]
		public async bool apply_edits_async (owned GLib.GenericArray<Ide.TextEdit> edits, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public Ide.Buffer find_buffer (GLib.File file);
		[Version (since = "3.32")]
		public void @foreach (Ide.BufferForeachFunc foreach_func);
		[Version (since = "3.32")]
		public static unowned Ide.BufferManager from_context (Ide.Context context);
		[Version (since = "3.32")]
		public ssize_t get_max_file_size ();
		[Version (since = "3.32")]
		public bool has_file (GLib.File file);
		[Version (since = "3.32")]
		public async Ide.Buffer load_file_async (GLib.File? file, Ide.BufferOpenFlags flags, Ide.Notification? notif, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public async bool save_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_max_file_size (ssize_t max_file_size);
		[Version (since = "3.32")]
		public int64 max_file_size { get; set; }
		[Version (since = "3.32")]
		public signal void buffer_loaded (Ide.Buffer buffer);
		[Version (since = "3.32")]
		public signal void buffer_saved (Ide.Buffer buffer);
		[Version (since = "3.32")]
		public signal void buffer_unloaded (Ide.Buffer buffer);
		public signal void load_buffer (Ide.Buffer object, bool p0);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	[Compact]
	public class BuildLog {
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_build_manager_get_type ()")]
	public class BuildManager : Ide.Object, GLib.ActionGroup, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected BuildManager ();
		[Version (since = "3.32")]
		public async bool build_async (Ide.PipelinePhase phase, GLib.GenericArray<Ide.BuildTarget>? targets, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public void cancel ();
		[Version (since = "3.32")]
		public async bool clean_async (Ide.PipelinePhase phase, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public static unowned Ide.BuildManager from_context (Ide.Context context);
		[Version (since = "3.32")]
		public bool get_busy ();
		[Version (since = "3.32")]
		public bool get_can_build ();
		public uint get_error_count ();
		[Version (since = "3.32")]
		public unowned GLib.DateTime? get_last_build_time ();
		[Version (since = "3.32")]
		public string get_message ();
		[Version (since = "3.32")]
		public unowned Ide.Pipeline? get_pipeline ();
		[Version (since = "3.32")]
		public GLib.TimeSpan get_running_time ();
		public uint get_warning_count ();
		[Version (since = "3.32")]
		public void invalidate ();
		[Version (since = "3.32")]
		public async bool rebuild_async (Ide.PipelinePhase phase, GLib.GenericArray<Ide.BuildTarget>? targets, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public static Ide.BuildManager ref_from_context (Ide.Context context);
		[Version (since = "3.32")]
		public Ide.Pipeline? ref_pipeline ();
		[Version (since = "3.32")]
		public bool busy { get; }
		[Version (since = "3.32")]
		public bool can_build { get; }
		[Version (since = "3.32")]
		public uint error_count { get; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public bool has_diagnostics { get; }
		[Version (since = "3.32")]
		public GLib.DateTime last_build_time { get; }
		[Version (since = "3.32")]
		public string message { owned get; }
		[Version (since = "3.32")]
		public Ide.Pipeline pipeline { get; }
		[Version (since = "3.32")]
		public int64 running_time { get; }
		[Version (since = "3.32")]
		public uint warning_count { get; }
		[Version (since = "3.32")]
		public signal void build_failed (Ide.Pipeline pipeline);
		[Version (since = "3.32")]
		public signal void build_finished (Ide.Pipeline pipeline);
		[Version (since = "3.32")]
		public signal void build_started (Ide.Pipeline pipeline);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_cell_renderer_fancy_get_type ()")]
	public class CellRendererFancy : Gtk.CellRenderer {
		[CCode (has_construct_function = false, type = "GtkCellRenderer*")]
		public CellRendererFancy ();
		public unowned string get_body ();
		public unowned string get_title ();
		public void set_body (string body);
		public void set_title (string title);
		[Version (since = "3.32")]
		public void take_title (owned string? title);
		public string body { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_clone_surface_get_type ()")]
	public class CloneSurface : Ide.Surface, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public CloneSurface ();
		public void clone ();
		public unowned string get_uri ();
		public void set_uri (string uri);
		[Version (since = "3.32")]
		public string uri { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ide_code_index_entry_get_type ()")]
	[Compact]
	public class CodeIndexEntry {
		public Ide.CodeIndexEntry copy ();
		public void free ();
		public Ide.SymbolFlags get_flags ();
		public unowned string get_key ();
		public Ide.SymbolKind get_kind ();
		public unowned string get_name ();
		[Version (since = "3.32")]
		public void get_range (out uint begin_line, out uint begin_line_offset, out uint end_line, out uint end_line_offset);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ide_code_index_entry_builder_get_type ()")]
	[Compact]
	public class CodeIndexEntryBuilder {
		[CCode (has_construct_function = false)]
		public CodeIndexEntryBuilder ();
		[Version (since = "3.32")]
		public Ide.CodeIndexEntry build ();
		[Version (since = "3.32")]
		public Ide.CodeIndexEntryBuilder copy ();
		public void free ();
		public void set_flags (Ide.SymbolFlags flags);
		public void set_key (string key);
		public void set_kind (Ide.SymbolKind kind);
		public void set_name (string name);
		public void set_range (uint begin_line, uint begin_line_offset, uint end_line, uint end_line_offset);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_command_manager_get_type ()")]
	public class CommandManager : Ide.Object {
		[CCode (has_construct_function = false)]
		protected CommandManager ();
		[Version (since = "3.34")]
		public static unowned Ide.CommandManager from_context (Ide.Context context);
		[Version (since = "3.34")]
		public Ide.Command? get_command_by_id (Ide.Workspace workspace, string command_id);
		public async GLib.GenericArray<Ide.Command> query_async (Ide.Workspace workspace, string typed_text, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_compile_commands_get_type ()")]
	public class CompileCommands : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public CompileCommands ();
		[Version (since = "3.32")]
		public bool load (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.32")]
		public async bool load_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.32")]
		public string[]? lookup (GLib.File file, string system_includes, out GLib.File directory) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_completion_get_type ()")]
	public class Completion : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Completion ();
		[Version (since = "3.32")]
		public void add_provider (Ide.CompletionProvider provider);
		public void block_interactive ();
		public void cancel ();
		[Version (since = "3.32")]
		public static string fuzzy_highlight (string haystack, string casefold_query);
		[Version (since = "3.32")]
		public static bool fuzzy_match (string? haystack, string casefold_needle, out uint priority);
		[Version (since = "3.32")]
		public unowned Gtk.TextBuffer get_buffer ();
		[Version (since = "3.32")]
		public unowned Ide.CompletionDisplay get_display ();
		public uint get_n_rows ();
		[Version (since = "3.32")]
		public unowned Gtk.SourceView get_view ();
		[Version (since = "3.32")]
		public bool is_visible ();
		public void move_cursor (Gtk.MovementStep step, int direction);
		[Version (since = "3.32")]
		public void remove_provider (Ide.CompletionProvider provider);
		public void set_n_rows (uint n_rows);
		public void unblock_interactive ();
		[Version (since = "3.32")]
		public Gtk.TextView buffer { get; }
		[Version (since = "3.32")]
		public uint n_rows { get; set; }
		[Version (since = "3.32")]
		public Gtk.SourceView view { get; construct; }
		[HasEmitter]
		[Version (since = "3.32")]
		public signal void hide ();
		[Version (since = "3.32")]
		public signal void provider_added (Ide.CompletionProvider provider);
		[Version (since = "3.32")]
		public signal void provider_removed (Ide.CompletionProvider provider);
		[HasEmitter]
		[Version (since = "3.32")]
		public signal void show ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_completion_context_get_type ()")]
	public class CompletionContext : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected CompletionContext ();
		[Version (since = "3.32")]
		public Ide.CompletionActivation get_activation ();
		[Version (since = "3.32")]
		public bool get_bounds (out Gtk.TextIter begin, out Gtk.TextIter end);
		[Version (since = "3.32")]
		public unowned Gtk.TextBuffer? get_buffer ();
		[Version (since = "3.32")]
		public bool get_busy ();
		[Version (since = "3.32")]
		public unowned Ide.Completion? get_completion ();
		public bool get_item_full (uint position, Ide.CompletionProvider provider, Ide.CompletionProposal proposal);
		[Version (since = "3.32")]
		public unowned string? get_language ();
		[Version (since = "3.32")]
		public string get_line_text ();
		[Version (since = "3.32")]
		public bool get_start_iter (out Gtk.TextIter iter);
		[Version (since = "3.32")]
		public unowned Gtk.TextView? get_view ();
		[Version (since = "3.32")]
		public string get_word ();
		[Version (since = "3.32")]
		public bool is_empty ();
		[Version (since = "3.32")]
		public bool is_language (string language);
		[Version (since = "3.32")]
		public void set_proposals_for_provider (Ide.CompletionProvider provider, GLib.ListModel? results);
		[Version (since = "3.32")]
		public bool busy { get; }
		[Version (since = "3.32")]
		public Ide.Completion completion { get; construct; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public bool empty { get; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_completion_list_box_row_get_type ()")]
	public class CompletionListBoxRow : Gtk.ListBoxRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public CompletionListBoxRow ();
		[Version (since = "3.32")]
		public unowned Ide.CompletionProposal? get_proposal ();
		[Version (since = "3.32")]
		public void set_center (string? center);
		[Version (since = "3.32")]
		public void set_center_markup (string? center_markup);
		[Version (since = "3.32")]
		public void set_icon_name (string? icon_name);
		[Version (since = "3.32")]
		public void set_left (string? left);
		[Version (since = "3.32")]
		public void set_left_markup (string? left_markup);
		[Version (since = "3.32")]
		public void set_proposal (Ide.CompletionProposal proposal);
		[Version (since = "3.32")]
		public void set_right (string? right);
		[Version (since = "3.32")]
		public Ide.CompletionProposal proposal { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_config_get_type ()")]
	public abstract class Config : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Config ();
		public void apply_path (Ide.SubprocessLauncher launcher);
		[Version (since = "3.32")]
		public unowned string? get_app_id ();
		public unowned string get_append_path ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_build_commands ();
		[Version (since = "3.32")]
		public unowned GLib.File? get_build_commands_dir ();
		public unowned string get_config_opts ();
		public bool get_debug ();
		public bool get_dirty ();
		public unowned string get_display_name ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.32")]
		public string[] get_environ ();
		[Version (since = "3.32")]
		public unowned Ide.Environment get_environment ();
		[Version (since = "3.34")]
		public virtual GLib.GenericArray<Ide.Runtime> get_extensions ();
		public unowned string get_id ();
		public bool get_internal_boolean (string key);
		public int get_internal_int (string key);
		public int64 get_internal_int64 (string key);
		[Version (since = "3.32")]
		public unowned GLib.Object? get_internal_object (string key);
		public unowned string get_internal_string (string key);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_internal_strv (string key);
		public Ide.BuildLocality get_locality ();
		public int get_parallelism ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_post_install_commands ();
		public unowned string get_prefix ();
		public bool get_prefix_set ();
		[Version (since = "3.32")]
		public bool get_ready ();
		[Version (since = "3.32")]
		public unowned string? get_run_opts ();
		[Version (since = "3.32")]
		public virtual unowned Ide.Runtime? get_runtime ();
		public unowned string get_runtime_id ();
		[Version (since = "3.32")]
		public uint get_sequence ();
		[Version (since = "3.32")]
		public Ide.Toolchain? get_toolchain ();
		[Version (since = "3.32")]
		public unowned string? get_toolchain_id ();
		public unowned string getenv (string key);
		public void set_app_id (string app_id);
		public void set_append_path (string append_path);
		public void set_build_commands (string build_commands);
		public void set_build_commands_dir (GLib.File build_commands_dir);
		public void set_config_opts (string config_opts);
		public void set_debug (bool debug);
		public void set_dirty (bool dirty);
		public void set_display_name (string display_name);
		public void set_environment (Ide.Environment environment);
		public void set_internal_boolean (string key, bool value);
		public void set_internal_int (string key, int value);
		public void set_internal_int64 (string key, int64 value);
		[Version (since = "3.32")]
		public void set_internal_object (string key, GLib.Object? instance);
		public void set_internal_string (string key, string value);
		public void set_internal_strv (string key, string value);
		public void set_locality (Ide.BuildLocality locality);
		public void set_parallelism (int parallelism);
		public void set_post_install_commands (string post_install_commands);
		public void set_prefix (string prefix);
		public void set_prefix_set (bool prefix_set);
		[Version (since = "3.32")]
		public void set_run_opts (string? run_opts);
		public virtual void set_runtime (Ide.Runtime runtime);
		public void set_runtime_id (string runtime_id);
		[Version (since = "3.32")]
		public void set_toolchain (Ide.Toolchain? toolchain);
		[Version (since = "3.32")]
		public void set_toolchain_id (string toolchain_id);
		public void setenv (string key, string value);
		public virtual bool supports_runtime (Ide.Runtime runtime);
		public string app_id { get; set; }
		public string append_path { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] build_commands { get; set; }
		public GLib.File build_commands_dir { get; set; }
		public string config_opts { get; set; }
		public bool debug { get; set; }
		public bool dirty { get; set; }
		public string display_name { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] environ { owned get; }
		public string id { get; construct; }
		public Ide.BuildLocality locality { get; set; }
		public int parallelism { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] post_install_commands { get; set; }
		public string prefix { get; set; }
		public bool prefix_set { get; set; }
		public bool ready { get; }
		public string run_opts { get; set; }
		public Ide.Runtime runtime { get; set; }
		public string runtime_id { get; set; }
		public Ide.Toolchain toolchain { owned get; set; }
		public string toolchain_id { get; set; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_config_manager_get_type ()")]
	public class ConfigManager : Ide.Object, GLib.ActionGroup, GLib.AsyncInitable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected ConfigManager ();
		public void @delete (Ide.Config config);
		public void duplicate (Ide.Config config);
		[Version (since = "3.32")]
		public static unowned Ide.ConfigManager from_context (Ide.Context context);
		[Version (since = "3.32")]
		public unowned Ide.Config? get_config (string id);
		[Version (since = "3.32")]
		public unowned Ide.Config get_current ();
		[Version (since = "3.32")]
		public bool get_ready ();
		[Version (since = "3.32")]
		public Ide.Config ref_current ();
		[Version (since = "3.32")]
		public static Ide.ConfigManager ref_from_context (Ide.Context context);
		public async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_current (Ide.Config configuration);
		public Ide.Config current { get; set; }
		[NoAccessorMethod]
		public string current_display_name { owned get; }
		public bool ready { get; }
		[Version (since = "3.32")]
		public signal void invalidate ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_context_get_type ()")]
	public class Context : Ide.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Context ();
		[Version (since = "3.32")]
		public GLib.File build_file (string? path);
		[Version (since = "3.32")]
		public string dup_project_id ();
		[Version (since = "3.32")]
		public string dup_title ();
		[Version (since = "3.32")]
		public bool has_project ();
		[Version (since = "3.32")]
		public unowned Ide.Object? peek_child_typed (GLib.Type type);
		[Version (since = "3.32")]
		public GLib.Settings ref_project_settings ();
		[Version (since = "3.32")]
		public GLib.File ref_workdir ();
		[Version (since = "3.32")]
		public void set_project_id (string project_id);
		[Version (since = "3.32")]
		public void set_title (string? title);
		[Version (since = "3.32")]
		public void set_workdir (GLib.File workdir);
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public string project_id { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public string title { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public GLib.File workdir { owned get; set; }
		[HasEmitter]
		[Version (since = "3.32")]
		public signal void log (uint level, string domain, string message);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debug_manager_get_type ()")]
	public class DebugManager : Ide.Object {
		[CCode (has_construct_function = false)]
		protected DebugManager ();
		[Version (since = "3.32")]
		public Ide.Debugger? find_debugger (Ide.Runner runner);
		[Version (since = "3.32")]
		public static unowned Ide.DebugManager from_context (Ide.Context context);
		public bool get_active ();
		[Version (since = "3.32")]
		public Ide.DebuggerBreakpoints get_breakpoints_for_file (GLib.File file);
		[Version (since = "3.32")]
		public unowned Ide.Debugger? get_debugger ();
		[Version (since = "3.32")]
		public bool start (Ide.Runner runner) throws GLib.Error;
		public void stop ();
		[Version (since = "3.32")]
		public bool supports_language (string? language_id);
		[Version (since = "3.32")]
		public bool active { get; }
		public Ide.Debugger debugger { get; }
		[Version (since = "3.32")]
		public signal void breakpoint_added (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.32")]
		public signal void breakpoint_reached (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.32")]
		public signal void breakpoint_removed (Ide.DebuggerBreakpoint breakpoint);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_get_type ()")]
	public abstract class Debugger : Ide.Object, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		protected Debugger ();
		public static Ide.DebuggerAddress address_parse (string string);
		[Version (since = "3.32")]
		public virtual async GLib.GenericArray<Ide.DebuggerInstruction> disassemble_async (Ide.DebuggerAddressRange range, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public void emit_breakpoint_added (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.32")]
		public void emit_breakpoint_modified (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.32")]
		public void emit_breakpoint_removed (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.32")]
		public void emit_library_loaded (Ide.DebuggerLibrary library);
		[Version (since = "3.32")]
		public void emit_library_unloaded (Ide.DebuggerLibrary library);
		[Version (since = "3.32")]
		public void emit_log (Ide.DebuggerStream stream, GLib.Bytes content);
		[Version (since = "3.32")]
		public void emit_running ();
		[Version (since = "3.32")]
		public void emit_stopped (Ide.DebuggerStopReason stop_reason, Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.32")]
		public void emit_thread_added (Ide.DebuggerThread thread);
		public void emit_thread_group_added (Ide.DebuggerThreadGroup thread_group);
		public void emit_thread_group_exited (Ide.DebuggerThreadGroup thread_group);
		public void emit_thread_group_removed (Ide.DebuggerThreadGroup thread_group);
		public void emit_thread_group_started (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.32")]
		public void emit_thread_removed (Ide.DebuggerThread thread);
		[Version (since = "3.32")]
		public void emit_thread_selected (Ide.DebuggerThread thread);
		[Version (since = "3.32")]
		public unowned GLib.ListModel get_breakpoints ();
		[Version (since = "3.32")]
		public virtual bool get_can_move (Ide.DebuggerMovement movement);
		[Version (since = "3.32")]
		public unowned string get_display_name ();
		public bool get_is_running ();
		[Version (since = "3.32")]
		public unowned Ide.DebuggerThread? get_selected_thread ();
		[Version (since = "3.32")]
		public unowned GLib.ListModel get_thread_groups ();
		[Version (since = "3.32")]
		public unowned GLib.ListModel get_threads ();
		[Version (since = "3.32")]
		public virtual async bool insert_breakpoint_async (Ide.DebuggerBreakpoint breakpoint, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public virtual async bool interrupt_async (Ide.DebuggerThreadGroup? thread_group, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public virtual async GLib.GenericArray<Ide.DebuggerBreakpoint> list_breakpoints_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async GLib.GenericArray<Ide.DebuggerFrame>? list_frames_async (Ide.DebuggerThread thread, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public virtual async GLib.GenericArray<Ide.DebuggerVariable> list_locals_async (Ide.DebuggerThread thread, Ide.DebuggerFrame frame, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public virtual async GLib.GenericArray<Ide.DebuggerVariable> list_params_async (Ide.DebuggerThread thread, Ide.DebuggerFrame frame, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public virtual async GLib.GenericArray<Ide.DebuggerRegister> list_registers_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public unowned string locate_binary_at_address (Ide.DebuggerAddress address);
		[Version (since = "3.32")]
		public virtual async bool modify_breakpoint_async (Ide.DebuggerBreakpointChange change, Ide.DebuggerBreakpoint breakpoint, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public virtual async bool move_async (Ide.DebuggerMovement movement, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public virtual void prepare (Ide.Runner runner);
		[Version (since = "3.32")]
		public virtual async bool remove_breakpoint_async (Ide.DebuggerBreakpoint breakpoint, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async bool send_signal_async (int signum, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public void set_display_name (string display_name);
		[Version (since = "3.32")]
		public virtual bool supports_runner (Ide.Runner runner, out int priority);
		[Version (since = "3.32")]
		public string display_name { get; set; }
		[Version (since = "3.32")]
		public Ide.DebuggerThread selected_thread { get; }
		[Version (since = "3.32")]
		public virtual signal void breakpoint_added (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.32")]
		public virtual signal void breakpoint_modified (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.32")]
		public virtual signal void breakpoint_removed (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.32")]
		public virtual signal void library_loaded (Ide.DebuggerLibrary library);
		[Version (since = "3.32")]
		public virtual signal void library_unloaded (Ide.DebuggerLibrary library);
		[Version (since = "3.32")]
		public virtual signal void log (Ide.DebuggerStream stream, GLib.Bytes content);
		[Version (since = "3.32")]
		public virtual signal void running ();
		[Version (since = "3.32")]
		public virtual signal void stopped (Ide.DebuggerStopReason stop_reason, Ide.DebuggerBreakpoint? breakpoint);
		[Version (since = "3.32")]
		public virtual signal void thread_added (Ide.DebuggerThread thread);
		[Version (since = "3.32")]
		public virtual signal void thread_group_added (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.32")]
		public virtual signal void thread_group_exited (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.32")]
		public virtual signal void thread_group_removed (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.32")]
		public virtual signal void thread_group_started (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.32")]
		public virtual signal void thread_removed (Ide.DebuggerThread thread);
		[Version (since = "3.32")]
		public virtual signal void thread_selected (Ide.DebuggerThread thread);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ide_debugger_address_range_get_type ()")]
	[Compact]
	public class DebuggerAddressRange {
		public Ide.DebuggerAddress from;
		public Ide.DebuggerAddress to;
		public Ide.DebuggerAddressRange copy ();
		public void free ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_breakpoint_get_type ()")]
	public class DebuggerBreakpoint : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerBreakpoint (string id);
		public int compare (Ide.DebuggerBreakpoint b);
		[Version (since = "3.32")]
		public Ide.DebuggerAddress get_address ();
		[Version (since = "3.32")]
		public int64 get_count ();
		[Version (since = "3.32")]
		public Ide.DebuggerDisposition get_disposition ();
		[Version (since = "3.32")]
		public bool get_enabled ();
		[Version (since = "3.32")]
		public unowned string? get_file ();
		[Version (since = "3.32")]
		public unowned string get_function ();
		[Version (since = "3.32")]
		public unowned string get_id ();
		[Version (since = "3.32")]
		public uint get_line ();
		[Version (since = "3.32")]
		public Ide.DebuggerBreakMode get_mode ();
		[Version (since = "3.32")]
		public unowned string? get_spec ();
		[Version (since = "3.32")]
		public unowned string? get_thread ();
		[Version (since = "3.32")]
		public void set_address (Ide.DebuggerAddress address);
		[Version (since = "3.32")]
		public void set_count (int64 count);
		[Version (since = "3.32")]
		public void set_disposition (Ide.DebuggerDisposition disposition);
		[Version (since = "3.32")]
		public void set_enabled (bool enabled);
		[Version (since = "3.32")]
		public void set_file (string? file);
		[Version (since = "3.32")]
		public void set_function (string? function);
		[Version (since = "3.32")]
		public void set_line (uint line);
		[Version (since = "3.32")]
		public void set_mode (Ide.DebuggerBreakMode mode);
		[Version (since = "3.32")]
		public void set_spec (string? spec);
		[Version (since = "3.32")]
		public void set_thread (string thread);
		[Version (since = "3.32")]
		public uint64 address { get; set; }
		[Version (since = "3.32")]
		public int64 count { get; set; }
		[Version (since = "3.32")]
		public Ide.DebuggerDisposition disposition { get; set; }
		[Version (since = "3.32")]
		public bool enabled { get; set; }
		[Version (since = "3.32")]
		public string file { get; set; }
		[Version (since = "3.32")]
		public string function { get; set; }
		[Version (since = "3.32")]
		public string id { get; construct; }
		[Version (since = "3.32")]
		public uint line { get; set; }
		[Version (since = "3.32")]
		public Ide.DebuggerBreakMode mode { get; set; }
		[Version (since = "3.32")]
		public string spec { get; set; }
		[Version (since = "3.32")]
		public string thread { get; set; }
		[Version (since = "3.32")]
		public virtual signal void reset ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_breakpoints_get_type ()")]
	public class DebuggerBreakpoints : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DebuggerBreakpoints ();
		[Version (since = "3.32")]
		public void @foreach (GLib.Func func);
		[Version (since = "3.32")]
		public unowned GLib.File get_file ();
		[Version (since = "3.32")]
		public unowned Ide.DebuggerBreakpoint? get_line (uint line);
		public Ide.DebuggerBreakMode get_line_mode (uint line);
		public GLib.File file { get; construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_frame_get_type ()")]
	public class DebuggerFrame : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerFrame ();
		public Ide.DebuggerAddress get_address ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_args ();
		public uint get_depth ();
		public unowned string get_file ();
		public unowned string get_function ();
		public unowned string get_library ();
		public uint get_line ();
		public void set_address (Ide.DebuggerAddress address);
		public void set_args (string args);
		public void set_depth (uint depth);
		public void set_file (string file);
		public void set_function (string function);
		public void set_library (string library);
		public void set_line (uint line);
		public uint64 address { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] args { get; set; }
		public uint depth { get; set; }
		public string file { get; set; }
		public string function { get; set; }
		public string library { get; set; }
		public uint line { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_instruction_get_type ()")]
	public class DebuggerInstruction : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerInstruction (Ide.DebuggerAddress address);
		public Ide.DebuggerAddress get_address ();
		public unowned string get_display ();
		public unowned string get_function ();
		public void set_display (string display);
		public void set_function (string function);
		public uint64 address { get; construct; }
		public string display { get; set; }
		public string function { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_library_get_type ()")]
	public class DebuggerLibrary : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerLibrary (string id);
		[Version (since = "3.32")]
		public void add_range (Ide.DebuggerAddressRange range);
		public int compare (Ide.DebuggerLibrary b);
		public unowned string get_host_name ();
		public unowned string get_id ();
		[Version (since = "3.32")]
		public unowned GLib.GenericArray<Ide.DebuggerAddressRange> get_ranges ();
		public unowned string get_target_name ();
		public void set_host_name (string host_name);
		public void set_target_name (string target_name);
		public string host_name { get; set; }
		public string id { get; construct; }
		public string target_name { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_register_get_type ()")]
	public class DebuggerRegister : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerRegister (string id);
		public int compare (Ide.DebuggerRegister b);
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned string get_value ();
		public void set_name (string name);
		public void set_value (string value);
		public string id { get; construct; }
		public string name { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_thread_get_type ()")]
	public class DebuggerThread : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerThread (string id);
		public int compare (Ide.DebuggerThread b);
		public unowned string get_group ();
		public unowned string get_id ();
		public void set_group (string thread_group);
		public string group { get; set; }
		public string id { get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_thread_group_get_type ()")]
	public class DebuggerThreadGroup : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerThreadGroup (string id);
		public int compare (Ide.DebuggerThreadGroup b);
		public unowned string get_exit_code ();
		public unowned string get_id ();
		public unowned string get_pid ();
		public void set_exit_code (string exit_code);
		public void set_pid (string pid);
		public string exit_code { get; set; }
		public string id { get; construct; }
		public string pid { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_debugger_variable_get_type ()")]
	public class DebuggerVariable : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerVariable (string name);
		public bool get_has_children ();
		public unowned string get_name ();
		public unowned string get_type_name ();
		public unowned string get_value ();
		public void set_has_children (bool has_children);
		public void set_type_name (string type_name);
		public void set_value (string value);
		public bool has_children { get; set; }
		public string name { get; construct; }
		public string type_name { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_deploy_strategy_get_type ()")]
	public abstract class DeployStrategy : Ide.Object {
		[CCode (has_construct_function = false)]
		protected DeployStrategy ();
		[Version (since = "3.32")]
		public virtual async bool deploy_async (Ide.Pipeline pipeline, [CCode (delegate_target_pos = 2.33333, destroy_notify_pos = 2.66667)] owned GLib.FileProgressCallback? progress, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public virtual async bool load_async (Ide.Pipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_device_get_type ()")]
	public abstract class Device : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Device ();
		[Version (since = "3.32")]
		public unowned string? get_display_name ();
		[Version (since = "3.32")]
		public unowned string? get_icon_name ();
		[Version (since = "3.32")]
		public unowned string get_id ();
		[Version (since = "3.32")]
		public virtual async Ide.DeviceInfo get_info_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void prepare_configuration (Ide.Config configuration);
		public void set_display_name (string display_name);
		[Version (since = "3.32")]
		public void set_icon_name (string icon_name);
		public void set_id (string id);
		public string display_name { get; set; }
		[Version (since = "3.32")]
		public string icon_name { get; set; }
		public string id { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_device_info_get_type ()")]
	public class DeviceInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public DeviceInfo ();
		[Version (since = "3.32")]
		public unowned Ide.Triplet? get_host_triplet ();
		[Version (since = "3.32")]
		public Ide.DeviceKind get_kind ();
		[Version (since = "3.32")]
		public void set_host_triplet (Ide.Triplet host_triplet);
		[Version (since = "3.32")]
		public void set_kind (Ide.DeviceKind kind);
		public Ide.Triplet host_triplet { get; set; }
		public Ide.DeviceKind kind { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_device_manager_get_type ()")]
	public class DeviceManager : Ide.Object, GLib.ActionGroup, GLib.AsyncInitable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected DeviceManager ();
		[Version (since = "3.32")]
		public async bool deploy_async (Ide.Pipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public static unowned Ide.DeviceManager from_context (Ide.Context context);
		[Version (since = "3.32")]
		public unowned Ide.Device get_device ();
		[Version (since = "3.32")]
		public unowned Ide.Device get_device_by_id (string device_id);
		public double get_progress ();
		[Version (since = "3.32")]
		public void set_device (Ide.Device? device);
		[Version (since = "3.32")]
		public Ide.Device device { get; set; }
		[Version (since = "3.32")]
		public double progress { get; }
		public signal void deploy_finished ();
		public signal void deploy_started ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_device_provider_get_type ()")]
	public abstract class DeviceProvider : Ide.Object {
		[CCode (has_construct_function = false)]
		protected DeviceProvider ();
		[Version (since = "3.32")]
		public void emit_device_added (Ide.Device device);
		[Version (since = "3.32")]
		public void emit_device_removed (Ide.Device device);
		[Version (since = "3.32")]
		public GLib.GenericArray<Ide.Device> get_devices ();
		[Version (since = "3.32")]
		public virtual async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public virtual signal void device_added (Ide.Device device);
		[Version (since = "3.32")]
		public virtual signal void device_removed (Ide.Device device);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_diagnostic_get_type ()")]
	public class Diagnostic : Ide.Object {
		[CCode (has_construct_function = false)]
		public Diagnostic (Ide.DiagnosticSeverity severity, string message, Ide.Location location);
		[Version (since = "3.32")]
		public void add_fixit (Ide.TextEdit fixit);
		[Version (since = "3.32")]
		public void add_range (Ide.Range range);
		public bool compare (Ide.Diagnostic b);
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Diagnostic.from_variant (GLib.Variant? variant);
		[Version (since = "3.32")]
		public unowned GLib.File? get_file ();
		[Version (since = "3.32")]
		public unowned Ide.TextEdit? get_fixit (uint index);
		[Version (since = "3.32")]
		public unowned Ide.Location? get_location ();
		public uint get_n_fixits ();
		public uint get_n_ranges ();
		[Version (since = "3.32")]
		public unowned Ide.Range? get_range (uint index);
		public Ide.DiagnosticSeverity get_severity ();
		public unowned string get_text ();
		[Version (since = "3.32")]
		public string get_text_for_display ();
		public uint hash ();
		[Version (since = "3.32")]
		public void take_fixit (owned Ide.TextEdit fixit);
		[Version (since = "3.32")]
		public void take_range (owned Ide.Range range);
		[Version (since = "3.32")]
		public GLib.Variant to_variant ();
		[NoAccessorMethod]
		public string display_text { owned get; }
		public Ide.Location location { get; construct; }
		public Ide.DiagnosticSeverity severity { get; construct; }
		public string text { get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_diagnostics_get_type ()")]
	public class Diagnostics : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public Diagnostics ();
		public void add (Ide.Diagnostic diagnostic);
		[Version (since = "3.32")]
		public void foreach_line_in_range (GLib.File file, uint begin_line, uint end_line, Ide.DiagnosticsLineCallback callback);
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Diagnostics.from_array (GLib.GenericArray<Ide.Diagnostic>? array);
		[Version (since = "3.32")]
		public unowned Ide.Diagnostic? get_diagnostic_at_line (GLib.File file, uint line);
		public bool get_has_errors ();
		public bool get_has_warnings ();
		public uint get_n_errors ();
		public uint get_n_warnings ();
		public void merge (Ide.Diagnostics other);
		public void take (owned Ide.Diagnostic diagnostic);
		public bool has_errors { get; }
		public bool has_warnings { get; }
		public uint n_errors { get; }
		public uint n_warnings { get; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_diagnostics_manager_get_type ()")]
	public class DiagnosticsManager : Ide.Object {
		[CCode (has_construct_function = false)]
		protected DiagnosticsManager ();
		[Version (since = "3.32")]
		public static unowned Ide.DiagnosticsManager from_context (Ide.Context context);
		[Version (since = "3.32")]
		public bool get_busy ();
		[Version (since = "3.32")]
		public Ide.Diagnostics get_diagnostics_for_file (GLib.File file);
		public uint get_sequence_for_file (GLib.File file);
		[Version (since = "3.32")]
		public void rediagnose (Ide.Buffer buffer);
		public bool busy { get; }
		[Version (since = "3.32")]
		public signal void changed ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_directory_vcs_get_type ()")]
	public class DirectoryVcs : Ide.Object, Ide.Vcs {
		[CCode (has_construct_function = false)]
		public DirectoryVcs (GLib.File workdir);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_doap_get_type ()")]
	public class Doap : GLib.Object {
		[CCode (has_construct_function = false)]
		public Doap ();
		public static GLib.Quark error_quark ();
		public unowned string get_bug_database ();
		public unowned string get_category ();
		public unowned string get_description ();
		public unowned string get_download_page ();
		public unowned string get_homepage ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.32")]
		public unowned string[] get_languages ();
		[Version (since = "3.32")]
		public unowned GLib.List<Ide.DoapPerson> get_maintainers ();
		public unowned string get_name ();
		public unowned string get_shortdesc ();
		public bool load_from_data (string data, size_t length) throws GLib.Error;
		public bool load_from_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public string bug_database { owned get; set; }
		[NoAccessorMethod]
		public string category { owned get; set; }
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public string download_page { owned get; set; }
		[NoAccessorMethod]
		public string homepage { owned get; set; }
		[NoAccessorMethod]
		public string languages { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string shortdesc { owned get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_doap_person_get_type ()")]
	public class DoapPerson : GLib.Object {
		[CCode (has_construct_function = false)]
		public DoapPerson ();
		public unowned string get_email ();
		public unowned string get_name ();
		public void set_email (string email);
		public void set_name (string name);
		public string email { get; set; }
		public string name { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_editor_page_get_type ()")]
	public class EditorPage : Ide.Page, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected EditorPage ();
		[Version (since = "3.32")]
		public unowned Ide.EditorPageAddin? addin_find_by_module_name (string module_name);
		public bool get_auto_hide_map ();
		[Version (since = "3.32")]
		public unowned Ide.Buffer get_buffer ();
		[Version (since = "3.32")]
		public unowned GLib.File get_file ();
		[Version (since = "3.32")]
		public unowned Gtk.SourceLanguage? get_language ();
		[Version (since = "3.32")]
		public unowned string? get_language_id ();
		[Version (since = "3.32")]
		public unowned Ide.EditorSearch get_search ();
		public bool get_show_map ();
		[Version (since = "3.32")]
		public unowned Ide.SourceView get_view ();
		[Version (since = "3.32")]
		public void move_next_error ();
		[Version (since = "3.32")]
		public void move_next_search_result ();
		[Version (since = "3.32")]
		public void move_previous_error ();
		[Version (since = "3.32")]
		public void move_previous_search_result ();
		[Version (since = "3.32")]
		public void scroll_to_line (uint line);
		[Version (since = "3.32")]
		public void scroll_to_line_offset (uint line, uint line_offset);
		public void set_auto_hide_map (bool auto_hide_map);
		[Version (since = "3.32")]
		public void set_language (Gtk.SourceLanguage language);
		public void set_show_map (bool show_map);
		public bool auto_hide_map { get; set; }
		public Ide.Buffer buffer { get; construct; }
		public Ide.EditorSearch search { get; }
		public bool show_map { get; set; }
		public Ide.SourceView view { get; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_editor_search_get_type ()")]
	public class EditorSearch : GLib.Object, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public EditorSearch (Gtk.SourceView view);
		[Version (since = "3.32")]
		public void begin_interactive ();
		[Version (since = "3.32")]
		public void end_interactive ();
		[Version (since = "3.32")]
		public bool get_active ();
		[Version (since = "3.32")]
		public bool get_at_word_boundaries ();
		[Version (since = "3.32")]
		public bool get_case_sensitive ();
		[Version (since = "3.32")]
		public Ide.EditorSearchSelect get_extend_selection ();
		[Version (since = "3.32")]
		public uint get_match_count ();
		[Version (since = "3.32")]
		public uint get_match_position ();
		[Version (since = "3.32")]
		public bool get_regex_enabled ();
		[Version (since = "3.32")]
		public uint get_repeat ();
		[Version (since = "3.32")]
		public unowned string? get_replacement_text ();
		public bool get_replacement_text_invalid (uint invalid_begin, uint invalid_end);
		[Version (since = "3.32")]
		public bool get_reverse ();
		[Version (since = "3.32")]
		public unowned string? get_search_text ();
		[Version (since = "3.32")]
		public bool get_search_text_invalid (out uint invalid_begin, out uint invalid_end) throws GLib.Error;
		[Version (since = "3.32")]
		public bool get_visible ();
		[Version (since = "3.32")]
		public void move (Ide.EditorSearchDirection direction);
		[Version (since = "3.32")]
		public void replace ();
		[Version (since = "3.32")]
		public void replace_all ();
		[Version (since = "3.32")]
		public void set_at_word_boundaries (bool at_word_boundaries);
		[Version (since = "3.32")]
		public void set_case_sensitive (bool case_sensitive);
		public void set_extend_selection (Ide.EditorSearchSelect extend_selection);
		[Version (since = "3.32")]
		public void set_regex_enabled (bool regex_enabled);
		[Version (since = "3.32")]
		public void set_repeat (uint repeat);
		[Version (since = "3.32")]
		public void set_replacement_text (string? replacement_text);
		[Version (since = "3.32")]
		public void set_reverse (bool reverse);
		[Version (since = "3.32")]
		public void set_search_text (string? search_text);
		[Version (since = "3.32")]
		public void set_visible (bool visible);
		[Version (since = "3.32")]
		public bool active { get; }
		[Version (since = "3.32")]
		public bool at_word_boundaries { get; set; }
		[Version (since = "3.32")]
		public bool case_sensitive { get; set; }
		[Version (since = "3.32")]
		public Ide.EditorSearchSelect extend_selection { get; set; }
		[Version (since = "3.32")]
		public uint match_count { get; }
		[Version (since = "3.32")]
		public uint match_position { get; }
		[Version (since = "3.32")]
		public bool regex_enabled { get; set; }
		[Version (since = "3.32")]
		public uint repeat { get; set; }
		[Version (since = "3.32")]
		public string replacement_text { get; set; }
		[Version (since = "3.32")]
		public bool reverse { get; set; }
		[Version (since = "3.32")]
		public string search_text { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public Gtk.SourceView view { owned get; construct; }
		[Version (since = "3.32")]
		public string visible { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_editor_sidebar_get_type ()")]
	public class EditorSidebar : Ide.Panel, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.32")]
		public EditorSidebar ();
		[Version (since = "3.32")]
		public void add_section (string? id, string title, string icon_name, string? menu_id, string? menu_icon_name, Gtk.Widget section, int priority);
		[Version (since = "3.32")]
		public unowned string? get_section_id ();
		[Version (since = "3.32")]
		public void set_section_id (string section_id);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_editor_surface_get_type ()")]
	public class EditorSurface : Ide.Surface, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "IdeSurface*")]
		[Version (since = "3.32")]
		public EditorSurface ();
		public void focus_buffer (Ide.Buffer buffer);
		public void focus_buffer_in_current_stack (Ide.Buffer buffer);
		public void focus_location (Ide.Location location);
		[Version (since = "3.32")]
		public unowned Ide.Page? get_active_page ();
		[Version (since = "3.32")]
		public unowned Ide.Grid get_grid ();
		[Version (since = "3.32")]
		public unowned Gtk.Overlay get_overlay ();
		[Version (since = "3.32")]
		public unowned Ide.EditorSidebar get_sidebar ();
		[Version (since = "3.32")]
		public unowned Ide.TransientSidebar get_transient_sidebar ();
		[Version (since = "3.32")]
		public unowned Gtk.Widget get_utilities ();
		[NoAccessorMethod]
		public bool restore_panel { get; set construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_editor_utilities_get_type ()")]
	public class EditorUtilities : Ide.Panel, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected EditorUtilities ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_editor_workspace_get_type ()")]
	public class EditorWorkspace : Ide.Workspace, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public EditorWorkspace (Ide.Application app);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_environment_get_type ()")]
	public class Environment : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public Environment ();
		public void append (Ide.EnvironmentVariable variable);
		[Version (since = "3.32")]
		public Ide.Environment copy ();
		public void copy_into (Ide.Environment dest, bool replace);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.32")]
		public string[] get_environ ();
		public unowned string getenv (string key);
		public void remove (Ide.EnvironmentVariable variable);
		public void set_environ (string env);
		public void setenv (string key, string value);
		public signal void changed ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_environment_editor_get_type ()")]
	public class EnvironmentEditor : Gtk.ListBox, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public EnvironmentEditor ();
		public unowned Ide.Environment? get_environment ();
		public void set_environment (Ide.Environment environment);
		public Ide.Environment environment { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_environment_variable_get_type ()")]
	public class EnvironmentVariable : GLib.Object {
		[CCode (has_construct_function = false)]
		public EnvironmentVariable (string key, string value);
		public unowned string get_key ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public string key { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_extension_adapter_get_type ()")]
	public class ExtensionAdapter : Ide.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public ExtensionAdapter (Ide.Object? parent, Peas.Engine? engine, GLib.Type interface_type, string key, string? value);
		[Version (since = "3.32")]
		public unowned Peas.Engine get_engine ();
		[Version (since = "3.32")]
		public unowned GLib.Object get_extension ();
		public GLib.Type get_interface_type ();
		public unowned string get_key ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public Peas.Engine engine { get; construct; }
		public GLib.Object extension { get; }
		public GLib.Type interface_type { get; construct; }
		public string key { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_extension_set_adapter_get_type ()")]
	public class ExtensionSetAdapter : Ide.Object {
		[CCode (has_construct_function = false)]
		public ExtensionSetAdapter (Ide.Object parent, Peas.Engine engine, GLib.Type interface_type, string key, string value);
		[Version (since = "3.32")]
		public void @foreach (Ide.ExtensionSetAdapterForeachFunc foreach_func);
		[Version (since = "3.32")]
		public void foreach_by_priority (Ide.ExtensionSetAdapterForeachFunc foreach_func);
		[Version (since = "3.32")]
		public unowned Peas.Engine get_engine ();
		[Version (since = "3.32")]
		public unowned Peas.Extension? get_extension (Peas.PluginInfo plugin_info);
		public GLib.Type get_interface_type ();
		public unowned string get_key ();
		public uint get_n_extensions ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public Peas.Engine engine { get; construct; }
		public GLib.Type interface_type { get; construct; }
		public string key { get; set; }
		public string value { get; set; }
		public signal void extension_added (Peas.PluginInfo object, GLib.Object p0);
		public signal void extension_removed (Peas.PluginInfo object, GLib.Object p0);
		public signal void extensions_loaded ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_fallback_build_system_get_type ()")]
	public class FallbackBuildSystem : Ide.Object, Ide.BuildSystem {
		[CCode (has_construct_function = false)]
		protected FallbackBuildSystem ();
		[Version (since = "3.32")]
		public static Ide.BuildSystem @new ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_fancy_tree_view_get_type ()")]
	public class FancyTreeView : Gtk.TreeView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public FancyTreeView ();
		[Version (since = "3.32")]
		public void set_data_func (owned Gtk.CellLayoutDataFunc? func);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	[Compact]
	public class File {
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_file_settings_get_type ()")]
	public class FileSettings : Ide.Object {
		[CCode (has_construct_function = false)]
		public FileSettings (Ide.Object parent, GLib.File file, string language);
		[Version (since = "3.32")]
		public unowned GLib.File get_file ();
		[Version (since = "3.32")]
		public unowned string? get_language ();
		[Version (since = "3.32")]
		public bool get_settled ();
		[NoAccessorMethod]
		public bool auto_indent { get; set; }
		[NoAccessorMethod]
		public bool auto_indent_set { get; set; }
		[NoAccessorMethod]
		public string encoding { owned get; set; }
		[NoAccessorMethod]
		public bool encoding_set { get; set; }
		public GLib.File file { get; construct; }
		[NoAccessorMethod]
		public Ide.IndentStyle indent_style { get; set; }
		[NoAccessorMethod]
		public bool indent_style_set { get; set; }
		[NoAccessorMethod]
		public int indent_width { get; set; }
		[NoAccessorMethod]
		public bool indent_width_set { get; set; }
		[NoAccessorMethod]
		public bool insert_matching_brace { get; set; }
		[NoAccessorMethod]
		public bool insert_matching_brace_set { get; set; }
		[NoAccessorMethod]
		public bool insert_trailing_newline { get; set; }
		[NoAccessorMethod]
		public bool insert_trailing_newline_set { get; set; }
		public string language { get; construct; }
		[NoAccessorMethod]
		public Gtk.SourceNewlineType newline_type { get; set; }
		[NoAccessorMethod]
		public bool newline_type_set { get; set; }
		[NoAccessorMethod]
		public bool overwrite_braces { get; set; }
		[NoAccessorMethod]
		public bool overwrite_braces_set { get; set; }
		[NoAccessorMethod]
		public uint right_margin_position { get; set; }
		[NoAccessorMethod]
		public bool right_margin_position_set { get; set; }
		[NoAccessorMethod]
		public bool settled { get; set; }
		[NoAccessorMethod]
		public bool show_right_margin { get; set; }
		[NoAccessorMethod]
		public bool show_right_margin_set { get; set; }
		[NoAccessorMethod]
		public Ide.SpacesStyle spaces_style { get; set; }
		[NoAccessorMethod]
		public bool spaces_style_set { get; set; }
		[NoAccessorMethod]
		public uint tab_width { get; set; }
		[NoAccessorMethod]
		public bool tab_width_set { get; set; }
		[NoAccessorMethod]
		public bool trim_trailing_whitespace { get; set; }
		[NoAccessorMethod]
		public bool trim_trailing_whitespace_set { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_formatter_options_get_type ()")]
	public class FormatterOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public FormatterOptions ();
		public bool get_insert_spaces ();
		public uint get_tab_width ();
		public void set_insert_spaces (bool insert_spaces);
		public void set_tab_width (uint tab_width);
		public bool insert_spaces { get; set; }
		public uint tab_width { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_frame_get_type ()")]
	public class Frame : Gtk.Box, Atk.Implementor, GLib.ListModel, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Frame ();
		public void add_with_depth (Gtk.Widget widget, uint position);
		[Version (since = "3.32")]
		public unowned Ide.FrameAddin? addin_find_by_module_name (string module_name);
		public virtual async bool agree_to_close_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public void foreach_page (Gtk.Callback callback);
		[Version (since = "3.32")]
		public bool get_has_page ();
		[Version (since = "3.32")]
		public unowned Ide.FrameHeader get_titlebar ();
		[Version (since = "3.32")]
		public unowned Ide.Page? get_visible_child ();
		public void set_placeholder (Gtk.Widget placeholder);
		[Version (since = "3.32")]
		public void set_visible_child (Ide.Page page);
		public bool has_page { get; }
		public Ide.Page visible_child { get; set; }
		public signal void change_current_page (int object);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_frame_empty_state_get_type ()")]
	public class FrameEmptyState : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected FrameEmptyState ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_frame_header_get_type ()")]
	public class FrameHeader : Dazzle.PriorityBox, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public FrameHeader ();
		[Version (since = "3.32")]
		public void add_custom_title (Gtk.Widget widget, int priority);
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public Gdk.RGBA background_rgba { set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public Gdk.RGBA foreground_rgba { set; }
		[NoAccessorMethod]
		public bool modified { get; set; }
		[NoAccessorMethod]
		public bool show_close_button { get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_greeter_row_get_type ()")]
	public class GreeterRow : Gtk.ListBoxRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public GreeterRow ();
		[Version (since = "3.32")]
		public unowned Ide.ProjectInfo? get_project_info ();
		[Version (since = "3.32")]
		public string? get_search_text ();
		public bool get_selection_mode ();
		public void set_project_info (Ide.ProjectInfo project_info);
		public void set_selection_mode (bool selection_mode);
		[Version (since = "3.32")]
		public Ide.ProjectInfo project_info { get; set; }
		[NoAccessorMethod]
		public bool selected { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_greeter_workspace_get_type ()")]
	public class GreeterWorkspace : Ide.Workspace, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public GreeterWorkspace (Ide.Application app);
		public void add_button (Gtk.Widget button, int priority);
		[Version (since = "3.32")]
		public void add_section (Ide.GreeterSection section);
		[Version (since = "3.32")]
		public void begin ();
		[Version (since = "3.32")]
		public void end ();
		[Version (since = "3.32")]
		public bool get_selection_mode ();
		[Version (since = "3.32")]
		public void open_project (Ide.ProjectInfo project_info);
		[Version (since = "3.32")]
		public void remove_section (Ide.GreeterSection section);
		[Version (since = "3.32")]
		public void set_selection_mode (bool selection_mode);
		[Version (since = "3.32")]
		public bool selection_mode { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_grid_get_type ()")]
	public class Grid : Dazzle.MultiPaned, Atk.Implementor, GLib.ListModel, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.32")]
		public Grid ();
		public uint count_pages ();
		[Version (since = "3.32")]
		public unowned Ide.Page? focus_neighbor (Gtk.DirectionType dir);
		[Version (since = "3.32")]
		public void foreach_page (Gtk.Callback callback);
		[Version (since = "3.32")]
		public unowned Ide.GridColumn get_current_column ();
		[Version (since = "3.32")]
		public unowned Ide.Page get_current_page ();
		[Version (since = "3.32")]
		public unowned Ide.Frame? get_current_stack ();
		[Version (since = "3.32")]
		public unowned Ide.GridColumn get_nth_column (int nth);
		[Version (since = "3.32")]
		public void set_current_column (Ide.GridColumn? column);
		public Ide.GridColumn current_column { get; set; }
		public Ide.Page current_page { get; }
		public Ide.Frame current_stack { get; }
		[Version (since = "3.34")]
		public signal Ide.Frame create_frame ();
		[Version (since = "3.32")]
		public signal Ide.Page create_page (string uri);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_grid_column_get_type ()")]
	public class GridColumn : Dazzle.MultiPaned, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public GridColumn ();
		[Version (since = "3.32")]
		public unowned Ide.Frame? get_current_stack ();
		public void set_current_stack (Ide.Frame stack);
		public Ide.Frame current_stack { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_header_bar_get_type ()")]
	public class HeaderBar : Gtk.HeaderBar, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public HeaderBar ();
		public void add_center_left (Gtk.Widget widget);
		[Version (since = "3.32")]
		public void add_primary (Gtk.Widget widget);
		[Version (since = "3.32")]
		public void add_secondary (Gtk.Widget widget);
		[Version (since = "3.32")]
		public unowned string? get_menu_id ();
		[Version (since = "3.32")]
		public bool get_show_fullscreen_button ();
		[Version (since = "3.32")]
		public void set_menu_id (string menu_id);
		[Version (since = "3.32")]
		public void set_show_fullscreen_button (bool show_fullscreen_button);
		public string menu_id { get; set; }
		public bool show_fullscreen_button { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_highlight_engine_get_type ()")]
	public class HighlightEngine : Ide.Object {
		[CCode (has_construct_function = false)]
		public HighlightEngine (Ide.Buffer buffer);
		[Version (since = "3.32")]
		public void advance ();
		public void clear ();
		[Version (since = "3.32")]
		public unowned Ide.Buffer get_buffer ();
		[Version (since = "3.32")]
		public unowned Ide.Highlighter get_highlighter ();
		[Version (since = "3.32")]
		public unowned Gtk.TextTag get_style (string style_name);
		[Version (since = "3.32")]
		public void invalidate (Gtk.TextIter begin, Gtk.TextIter end);
		public void pause ();
		public void rebuild ();
		public void unpause ();
		public Ide.Buffer buffer { get; construct; }
		public Ide.Highlighter highlighter { get; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", ref_function = "ide_highlight_index_ref", type_id = "ide_highlight_index_get_type ()", unref_function = "ide_highlight_index_unref")]
	[Compact]
	public class HighlightIndex {
		[CCode (has_construct_function = false)]
		public HighlightIndex ();
		public void dump ();
		[CCode (has_construct_function = false)]
		public HighlightIndex.from_variant (GLib.Variant variant);
		public void insert (string word, void* tag);
		[Version (since = "3.32")]
		public void* lookup (string word);
		public unowned Ide.HighlightIndex @ref ();
		[Version (since = "3.32")]
		public GLib.Variant to_variant ();
		public void unref ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_hover_context_get_type ()")]
	public class HoverContext : GLib.Object {
		[CCode (has_construct_function = false)]
		protected HoverContext ();
		public void add_content (int priority, string title, Ide.MarkedContent content);
		public void add_widget (int priority, string title, Gtk.Widget widget);
		public bool has_content ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_line_change_gutter_renderer_get_type ()")]
	public class LineChangeGutterRenderer : Gtk.SourceGutterRenderer {
		[CCode (has_construct_function = false)]
		protected LineChangeGutterRenderer ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_local_device_get_type ()")]
	public class LocalDevice : Ide.Device {
		[CCode (has_construct_function = false)]
		protected LocalDevice ();
		[NoAccessorMethod]
		public Ide.Triplet triplet { owned get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_location_get_type ()")]
	public class Location : GLib.Object {
		[CCode (has_construct_function = false)]
		public Location (GLib.File file, int line, int line_offset);
		public bool compare (Ide.Location b);
		[Version (since = "3.32")]
		public Ide.Location dup ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Location.from_variant (GLib.Variant? variant);
		[Version (since = "3.32")]
		public unowned GLib.File? get_file ();
		[Version (since = "3.32")]
		public int get_line ();
		[Version (since = "3.32")]
		public int get_line_offset ();
		[Version (since = "3.32")]
		public int get_offset ();
		public uint hash ();
		[Version (since = "3.32")]
		public GLib.Variant to_variant ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Location.with_offset (GLib.File file, int line, int line_offset, int offset);
		public GLib.File file { get; construct; }
		public int line { get; construct; }
		public int line_offset { get; construct; }
		public int offset { get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_client_get_type ()")]
	public class LspClient : Ide.Object {
		[CCode (has_construct_function = false)]
		public LspClient (GLib.IOStream io_stream);
		public void add_language (string language_id);
		[Version (since = "3.26")]
		public async bool call_async (string method, GLib.Variant? @params, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool get_diagnostics_async (GLib.File file, GLib.Bytes content, string lang_id, GLib.Cancellable? cancellable, out Ide.Diagnostics? diagnostics) throws GLib.Error;
		[Version (since = "3.26")]
		public async bool send_notification_async (string method, GLib.Variant? @params, GLib.Cancellable? cancellable) throws GLib.Error;
		public void start ();
		public void stop ();
		[NoAccessorMethod]
		public GLib.IOStream io_stream { owned get; construct; }
		public virtual signal void notification (string method, GLib.Variant @params);
		public virtual signal void published_diagnostics (GLib.File file, Ide.Diagnostics diagnostics);
		public virtual signal bool supports_language (string language_id);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_completion_item_get_type ()")]
	public class LspCompletionItem : GLib.Object, Ide.CompletionProposal {
		[CCode (has_construct_function = false)]
		public LspCompletionItem (GLib.Variant variant);
		public unowned string get_detail ();
		public unowned string get_icon_name ();
		public string get_markup (string typed_text);
		public unowned string get_return_type ();
		[Version (since = "3.30")]
		public Ide.Snippet get_snippet ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_completion_provider_get_type ()")]
	public abstract class LspCompletionProvider : Ide.Object, Ide.CompletionProvider {
		[CCode (has_construct_function = false)]
		protected LspCompletionProvider ();
		public unowned Ide.LspClient? get_client ();
		public void set_client (Ide.LspClient client);
		public Ide.LspClient client { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_completion_results_get_type ()")]
	public class LspCompletionResults : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public LspCompletionResults (GLib.Variant results);
		public void refilter (string typed_text);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_diagnostic_provider_get_type ()")]
	public abstract class LspDiagnosticProvider : Ide.Object, Ide.DiagnosticProvider {
		[CCode (has_construct_function = false)]
		protected LspDiagnosticProvider ();
		public unowned Ide.LspClient? get_client ();
		public void set_client (Ide.LspClient client);
		public Ide.LspClient client { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_formatter_get_type ()")]
	public class LspFormatter : Ide.Object, Ide.Formatter {
		[CCode (has_construct_function = false)]
		protected LspFormatter ();
		public unowned Ide.LspClient get_client ();
		public void set_client (Ide.LspClient client);
		public Ide.LspClient client { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_highlighter_get_type ()")]
	public class LspHighlighter : Ide.Object, Ide.Highlighter {
		[CCode (has_construct_function = false)]
		protected LspHighlighter ();
		public unowned Ide.LspClient? get_client ();
		public void set_client (Ide.LspClient client);
		public Ide.LspClient client { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_hover_provider_get_type ()")]
	public abstract class LspHoverProvider : Ide.Object, Ide.HoverProvider {
		[CCode (has_construct_function = false)]
		protected LspHoverProvider ();
		[Version (since = "3.30")]
		public unowned Ide.LspClient? get_client ();
		[NoWrapper]
		public virtual void prepare ();
		[Version (since = "3.30")]
		public void set_client (Ide.LspClient client);
		[NoAccessorMethod]
		[Version (since = "3.30")]
		public string category { owned get; set; }
		[Version (since = "3.30")]
		public Ide.LspClient client { get; set; }
		[NoAccessorMethod]
		public int priority { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_rename_provider_get_type ()")]
	public abstract class LspRenameProvider : Ide.Object, Ide.RenameProvider {
		[CCode (has_construct_function = false)]
		protected LspRenameProvider ();
		public unowned Ide.LspClient? get_client ();
		public void set_client (Ide.LspClient client);
		[NoAccessorMethod]
		public Ide.Buffer buffer { set; }
		public Ide.LspClient client { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_symbol_node_get_type ()")]
	public class LspSymbolNode : Ide.SymbolNode {
		[CCode (has_construct_function = false)]
		protected LspSymbolNode ();
		public unowned string get_parent_name ();
		public bool is_parent_of (Ide.LspSymbolNode other);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_symbol_resolver_get_type ()")]
	public abstract class LspSymbolResolver : Ide.Object, Ide.SymbolResolver {
		[CCode (has_construct_function = false)]
		protected LspSymbolResolver ();
		public unowned Ide.LspClient? get_client ();
		public void set_client (Ide.LspClient client);
		public Ide.LspClient client { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_lsp_symbol_tree_get_type ()")]
	public class LspSymbolTree : GLib.Object, Ide.SymbolTree {
		[CCode (has_construct_function = false)]
		protected LspSymbolTree ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", ref_function = "ide_marked_content_ref", type_id = "ide_marked_content_get_type ()", unref_function = "ide_marked_content_unref")]
	[Compact]
	public class MarkedContent {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public MarkedContent (GLib.Bytes content, Ide.MarkedKind kind);
		[Version (since = "3.32")]
		public string? as_string ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public MarkedContent.from_data (string data, ssize_t len, Ide.MarkedKind kind);
		[Version (since = "3.32")]
		public unowned GLib.Bytes get_bytes ();
		[Version (since = "3.32")]
		public Ide.MarkedKind get_kind ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public MarkedContent.plaintext (string? plaintext);
		[Version (since = "3.32")]
		public unowned Ide.MarkedContent @ref ();
		[Version (since = "3.32")]
		public void unref ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_marked_view_get_type ()")]
	public class MarkedView : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public MarkedView (Ide.MarkedContent content);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_notification_get_type ()")]
	public class Notification : Ide.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Notification ();
		[Version (since = "3.32")]
		public void add_button (string label, GLib.Icon? icon, string detailed_action);
		[Version (since = "3.32")]
		public void add_button_with_target_value (string label, GLib.Icon? icon, string action, GLib.Variant? target);
		[Version (since = "3.32")]
		public void attach (Ide.Object object);
		public int compare (Ide.Notification b);
		[Version (since = "3.32")]
		public string dup_body ();
		[Version (since = "3.32")]
		public string dup_id ();
		[Version (since = "3.32")]
		public string dup_title ();
		[Version (since = "3.32")]
		public static void file_progress_callback (int64 current_num_bytes, int64 total_num_bytes, void* user_data);
		public static void flatpak_progress_callback (string status, uint notification, bool estimating, void* user_data);
		[Version (since = "3.32")]
		public bool get_button (uint button, out string label, out GLib.Icon icon, out string action, out GLib.Variant target);
		public bool get_default_action (string action, GLib.Variant target);
		[Version (since = "3.32")]
		public bool get_has_progress ();
		public uint get_n_buttons ();
		public int get_priority ();
		[Version (since = "3.32")]
		public double get_progress ();
		public bool get_progress_is_imprecise ();
		public bool get_urgent ();
		[Version (since = "3.32")]
		public GLib.Icon? ref_icon ();
		[Version (since = "3.32")]
		public void set_body (string? body);
		public void set_default_action (string detailed_action);
		public void set_default_action_and_target_value (string action, GLib.Variant target);
		[Version (since = "3.32")]
		public void set_has_progress (bool has_progress);
		public void set_icon (GLib.Icon icon);
		public void set_icon_name (string icon_name);
		[Version (since = "3.32")]
		public void set_id (string? id);
		public void set_priority (int priority);
		[Version (since = "3.32")]
		public void set_progress (double progress);
		public void set_progress_is_imprecise (bool progress_is_imprecise);
		[Version (since = "3.32")]
		public void set_title (string? title);
		public void set_urgent (bool urgent);
		[Version (since = "3.32")]
		public void withdraw ();
		[Version (since = "3.32")]
		public void withdraw_in_seconds (int seconds);
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public string body { owned get; set; }
		[Version (since = "3.32")]
		public bool has_progress { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public GLib.Icon icon { owned get; set; }
		[Version (since = "3.32")]
		public string icon_name { set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public string id { owned get; set; }
		[Version (since = "3.32")]
		public int priority { get; set; }
		[Version (since = "3.32")]
		public double progress { get; set; }
		[Version (since = "3.32")]
		public bool progress_is_imprecise { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public string title { owned get; set; }
		[Version (since = "3.32")]
		public bool urgent { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_notifications_get_type ()")]
	public class Notifications : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Notifications ();
		[Version (since = "3.32")]
		public void add_notification (Ide.Notification notification);
		[Version (since = "3.32")]
		public Ide.Notification? find_by_id (string id);
		[Version (since = "3.32")]
		public bool get_has_progress ();
		[Version (since = "3.32")]
		public double get_progress ();
		[Version (since = "3.32")]
		public bool get_progress_is_imprecise ();
		[Version (since = "3.32")]
		public bool has_progress { get; }
		[Version (since = "3.32")]
		public double progress { get; }
		[Version (since = "3.32")]
		public bool progress_is_imprecise { get; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_notifications_button_get_type ()")]
	public class NotificationsButton : Dazzle.ProgressMenuButton, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.32")]
		public NotificationsButton ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_object_get_type ()")]
	public class Object : GLib.Object {
		[CCode (has_construct_function = false, type = "gpointer")]
		[Version (since = "3.32")]
		public Object (GLib.Type type, Ide.Object? parent);
		[Version (since = "3.32")]
		public virtual void add (Ide.Object? sibling, Ide.Object child, Ide.ObjectLocation location);
		[Version (since = "3.32")]
		public void append (Ide.Object child);
		[Version (since = "3.32")]
		public static void destroyed (Ide.Object self);
		[Version (since = "3.32")]
		public Ide.Object? ensure_child_typed (GLib.Type type);
		[Version (since = "3.32")]
		public void @foreach (GLib.Func callback);
		[Version (since = "3.32")]
		public Ide.Object? get_child_typed (GLib.Type type);
		[Version (since = "3.32")]
		public GLib.GenericArray<Ide.Object> get_children_typed (GLib.Type type);
		[Version (since = "3.32")]
		public unowned Ide.Context? get_context ();
		[Version (since = "3.32")]
		public uint get_n_children ();
		[Version (since = "3.32")]
		public Ide.Object? get_nth_child (uint nth);
		[Version (since = "3.32")]
		public unowned Ide.Object? get_parent ();
		[Version (since = "3.32")]
		public uint get_position ();
		public bool in_destruction ();
		[Version (since = "3.32")]
		public void insert_after (Ide.Object sibling, Ide.Object child);
		[Version (since = "3.32")]
		public void insert_before (Ide.Object sibling, Ide.Object child);
		[Version (since = "3.32")]
		public void insert_sorted (Ide.Object child, GLib.CompareDataFunc func);
		[Version (since = "3.32")]
		public bool is_root ();
		[Version (since = "3.32")]
		public void @lock ();
		[Version (since = "3.32")]
		public static void notify_by_pspec (void* instance, GLib.ParamSpec pspec);
		[Version (since = "3.32")]
		public static void notify_in_main (GLib.Object instance, GLib.ParamSpec pspec);
		[NoWrapper]
		public virtual void parent_set (Ide.Object? parent);
		[Version (since = "3.32")]
		public void prepend (Ide.Object child);
		[Version (since = "3.32")]
		public unowned GLib.Cancellable ref_cancellable ();
		[Version (since = "3.32")]
		public Ide.Context? ref_context ();
		[Version (since = "3.32")]
		public Ide.Object? ref_parent ();
		[Version (since = "3.32")]
		public Ide.Object ref_root ();
		[Version (since = "3.32")]
		public virtual void remove (Ide.Object child);
		[Version (since = "3.32")]
		public virtual string repr ();
		public void set_context (Ide.Context context);
		public bool set_error_if_destroyed () throws GLib.Error;
		[Version (since = "3.32")]
		public void @unlock ();
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public GLib.Cancellable cancellable { owned get; construct; }
		[Version (since = "3.32")]
		public Ide.Object parent { get; construct; }
		[HasEmitter]
		[Version (since = "3.32")]
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_object_box_get_type ()")]
	public class ObjectBox : Ide.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public ObjectBox (GLib.Object object);
		[Version (since = "3.32")]
		public bool contains (GLib.Object? instance);
		[Version (since = "3.32")]
		public static unowned Ide.ObjectBox from_object (GLib.Object object);
		[Version (since = "3.32")]
		public GLib.Object? ref_object ();
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public GLib.Object object { owned get; construct; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public bool propagate_disposal { get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_omni_bar_get_type ()")]
	public class OmniBar : Gtk.EventBox, Atk.Implementor, GLib.ActionGroup, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public OmniBar ();
		public void add_button (Gtk.Widget widget, Gtk.PackType pack_type, int priority);
		[Version (since = "3.32")]
		public void add_popover_section (Gtk.Widget widget, int priority);
		[Version (since = "3.32")]
		public void add_status_icon (Gtk.Widget widget, int priority);
		public void set_placeholder (Gtk.Widget placeholder);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_page_get_type ()")]
	public class Page : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Page ();
		public virtual async bool agree_to_close_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_can_split ();
		public bool get_failed ();
		[Version (since = "3.32")]
		public unowned GLib.Icon? get_icon ();
		public unowned string get_icon_name ();
		public unowned string get_menu_id ();
		public bool get_modified ();
		[Version (since = "3.32")]
		public unowned Gdk.RGBA? get_primary_color_bg ();
		[Version (since = "3.32")]
		public unowned Gdk.RGBA? get_primary_color_fg ();
		public unowned string get_title ();
		[Version (since = "3.32")]
		public void mark_used ();
		public void set_can_split (bool can_split);
		public void set_failed (bool failed);
		public void set_icon (GLib.Icon icon);
		public void set_icon_name (string icon_name);
		public void set_menu_id (string menu_id);
		public void set_modified (bool modified);
		[Version (since = "3.32")]
		public void set_primary_color_bg (Gdk.RGBA? primary_color_bg);
		[Version (since = "3.32")]
		public void set_primary_color_fg (Gdk.RGBA? primary_color_fg);
		public void set_title (string title);
		public bool can_split { get; set; }
		public bool failed { get; set; }
		public GLib.Icon icon { get; set; }
		public string icon_name { get; set; }
		public string menu_id { get; set; }
		public bool modified { get; set; }
		[Version (since = "3.32")]
		public Gdk.RGBA primary_color_bg { get; set; }
		[Version (since = "3.32")]
		public Gdk.RGBA primary_color_fg { get; set; }
		public string title { get; set; }
		[HasEmitter]
		[Version (since = "3.32")]
		public virtual signal Ide.Page create_split ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_pane_get_type ()")]
	public class Pane : Dazzle.DockWidget, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.32")]
		public Pane ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_panel_get_type ()")]
	public class Panel : Dazzle.DockBinEdge, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.32")]
		public Panel ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_persistent_map_get_type ()")]
	public class PersistentMap : GLib.Object {
		[CCode (has_construct_function = false)]
		public PersistentMap ();
		public int64 builder_get_metadata_int64 (string key);
		public bool load_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool load_file_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public GLib.Variant lookup_value (string key);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_persistent_map_builder_get_type ()")]
	public class PersistentMapBuilder : GLib.Object {
		[CCode (has_construct_function = false)]
		public PersistentMapBuilder ();
		public void insert (string key, GLib.Variant value, bool replace);
		public void set_metadata_int64 (string key, int64 value);
		public bool write (GLib.File destination, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool write_async (GLib.File destination, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_pipeline_get_type ()")]
	public class Pipeline : Ide.Object, GLib.Initable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected Pipeline ();
		[Version (since = "3.32")]
		public uint add_error_format (string regex, GLib.RegexCompileFlags flags);
		public uint add_log_observer (owned Ide.BuildLogObserver observer);
		[Version (since = "3.32")]
		public uint attach (Ide.PipelinePhase phase, int priority, Ide.PipelineStage stage);
		[Version (since = "3.32")]
		public uint attach_launcher (Ide.PipelinePhase phase, int priority, Ide.SubprocessLauncher launcher);
		[Version (since = "3.32")]
		public void attach_pty (Ide.SubprocessLauncher launcher);
		[Version (since = "3.32")]
		public async bool build_async (Ide.PipelinePhase phase, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public async bool build_targets_async (Ide.PipelinePhase phase, GLib.GenericArray<Ide.BuildTarget>? targets, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool clean_async (Ide.PipelinePhase phase, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.34")]
		public bool contains_program_in_path (string name, GLib.Cancellable? cancellable = null);
		[Version (since = "3.32")]
		public Ide.SubprocessLauncher create_launcher () throws GLib.Error;
		[Version (since = "3.32")]
		public void detach (uint stage_id);
		public void emit_diagnostic (Ide.Diagnostic diagnostic);
		[Version (since = "3.32")]
		public void foreach_stage (GLib.Func stage_callback);
		public string get_arch ();
		[Version (since = "3.32")]
		public unowned string get_builddir ();
		public bool get_busy ();
		[Version (since = "3.32")]
		public bool get_can_export ();
		[Version (since = "3.32")]
		public unowned Ide.Config get_config ();
		[Version (since = "3.32")]
		public unowned Ide.Device get_device ();
		[Version (since = "3.32")]
		public unowned Ide.DeviceInfo? get_device_info ();
		[Version (since = "3.32")]
		public unowned Ide.Triplet get_host_triplet ();
		[Version (since = "3.32")]
		public string? get_message ();
		[Version (since = "3.32")]
		public Ide.PipelinePhase get_phase ();
		[Version (since = "3.32")]
		public unowned Vte.Pty? get_pty ();
		[Version (since = "3.32")]
		public Ide.PipelinePhase get_requested_phase ();
		[Version (since = "3.32")]
		public unowned Ide.Runtime? get_runtime ();
		[Version (since = "3.32")]
		public unowned string get_srcdir ();
		[Version (since = "3.32")]
		public unowned Ide.PipelineStage? get_stage_by_id (uint stage_id);
		[Version (since = "3.32")]
		public unowned Ide.Toolchain get_toolchain ();
		[Version (since = "3.32")]
		public bool has_configured ();
		[Version (since = "3.32")]
		public void invalidate_phase (Ide.PipelinePhase phases);
		[Version (since = "3.32")]
		public bool is_native ();
		[Version (since = "3.32")]
		public bool is_ready ();
		[Version (since = "3.32")]
		public async bool rebuild_async (Ide.PipelinePhase phase, GLib.GenericArray<Ide.BuildTarget>? targets, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public Ide.Toolchain? ref_toolchain ();
		[Version (since = "3.32")]
		public bool remove_error_format (uint error_format_id);
		public bool remove_log_observer (uint observer_id);
		[Version (since = "3.32")]
		public bool request_phase (Ide.PipelinePhase phase);
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public bool busy { get; set; }
		public Ide.Config config { get; construct; }
		[Version (since = "3.32")]
		public Ide.Device device { get; construct; }
		[Version (since = "3.32")]
		public string message { owned get; }
		[Version (since = "3.32")]
		public Ide.PipelinePhase phase { get; }
		[Version (since = "3.32")]
		public Vte.Pty pty { get; }
		[Version (since = "3.32")]
		public signal void diagnostic (Ide.Diagnostic diagnostic);
		[Version (since = "3.32")]
		public signal void finished (bool failed);
		[Version (since = "3.34")]
		public signal void launcher_created (Ide.SubprocessLauncher launcher);
		[Version (since = "3.32")]
		public signal void loaded ();
		[Version (since = "3.32")]
		public signal void started (Ide.PipelinePhase phase);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_pipeline_stage_get_type ()")]
	public class PipelineStage : Ide.Object {
		[CCode (has_construct_function = false)]
		protected PipelineStage ();
		[NoWrapper]
		public virtual bool build (Ide.Pipeline pipeline, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async bool build_async (Ide.Pipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async bool clean_async (Ide.Pipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
		public void emit_reap (Dazzle.DirectoryReaper reaper);
		[Version (since = "3.32")]
		public bool get_active ();
		public bool get_check_stdout ();
		public bool get_completed ();
		public bool get_disabled ();
		public unowned string get_name ();
		public unowned string get_stdout_path ();
		public bool get_transient ();
		public void log (Ide.BuildLogStream stream, string message, ssize_t message_len);
		[Version (since = "3.32")]
		public void log_subprocess (Ide.Subprocess subprocess);
		public void pause ();
		public void set_active (bool active);
		public void set_check_stdout (bool check_stdout);
		public void set_completed (bool completed);
		public void set_disabled (bool disabled);
		[Version (since = "3.32")]
		public void set_log_observer (owned Ide.BuildLogObserver observer);
		public void set_name (string name);
		public void set_stdout_path (string path);
		public void set_transient (bool transient);
		public void unpause ();
		[Version (since = "3.32")]
		public bool active { get; set; }
		[Version (since = "3.32")]
		public bool check_stdout { get; set; }
		[Version (since = "3.32")]
		public bool completed { get; set; }
		[Version (since = "3.32")]
		public bool disabled { get; set; }
		[Version (since = "3.32")]
		public string name { get; set; }
		[Version (since = "3.32")]
		public string stdout_path { get; set; }
		[Version (since = "3.32")]
		public bool transient { get; set; }
		[HasEmitter]
		public virtual signal bool chain (Ide.PipelineStage next);
		[Version (since = "3.32")]
		public signal void query (Ide.Pipeline pipeline, GLib.GenericArray<Ide.BuildTarget>? targets, GLib.Cancellable? cancellable = null);
		[Version (since = "3.32")]
		public virtual signal void reap (Dazzle.DirectoryReaper reaper);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_pipeline_stage_launcher_get_type ()")]
	public class PipelineStageLauncher : Ide.PipelineStage {
		[CCode (has_construct_function = false, type = "IdePipelineStage*")]
		[Version (since = "3.32")]
		public PipelineStageLauncher (Ide.Context context, Ide.SubprocessLauncher? launcher);
		[Version (since = "3.32")]
		public unowned Ide.SubprocessLauncher? get_clean_launcher ();
		[Version (since = "3.32")]
		public bool get_ignore_exit_status ();
		[Version (since = "3.32")]
		public unowned Ide.SubprocessLauncher get_launcher ();
		public bool get_use_pty ();
		public void set_clean_launcher (Ide.SubprocessLauncher clean_launcher);
		[Version (since = "3.32")]
		public void set_ignore_exit_status (bool ignore_exit_status);
		public void set_launcher (Ide.SubprocessLauncher launcher);
		[Version (since = "3.32")]
		public void set_use_pty (bool use_pty);
		public Ide.SubprocessLauncher clean_launcher { get; set; }
		public bool ignore_exit_status { get; set; }
		public Ide.SubprocessLauncher launcher { get; set; }
		public bool use_pty { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_pipeline_stage_mkdirs_get_type ()")]
	public class PipelineStageMkdirs : Ide.PipelineStage {
		[CCode (has_construct_function = false, type = "IdePipelineStage*")]
		public PipelineStageMkdirs (Ide.Context context);
		public void add_path (string path, bool with_parents, int mode, bool remove_on_rebuild);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_pipeline_stage_transfer_get_type ()")]
	public class PipelineStageTransfer : Ide.PipelineStage {
		[CCode (has_construct_function = false)]
		public PipelineStageTransfer (Ide.Context context, Ide.Transfer transfer);
		[NoAccessorMethod]
		public bool disable_when_metered { get; set; }
		[NoAccessorMethod]
		public Ide.Transfer transfer { owned get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_pkcon_transfer_get_type ()")]
	public class PkconTransfer : Ide.Transfer {
		[CCode (has_construct_function = false)]
		public PkconTransfer (string packages);
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] packages { owned get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_preferences_surface_get_type ()")]
	public class PreferencesSurface : Ide.Surface, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesSurface ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_preferences_window_get_type ()")]
	public class PreferencesWindow : Dazzle.ApplicationWindow, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesWindow ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_primary_workspace_get_type ()")]
	public class PrimaryWorkspace : Ide.Workspace, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PrimaryWorkspace ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_project_get_type ()")]
	public class Project : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Project ();
		[Version (since = "3.32")]
		public static unowned Ide.Project from_context (Ide.Context context);
		public async bool rename_file_async (GLib.File orig_file, GLib.File new_file, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool trash_file_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public signal void file_renamed (GLib.File object, GLib.File p0);
		public signal void file_trashed (GLib.File object);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_project_file_get_type ()")]
	public class ProjectFile : Ide.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public ProjectFile (GLib.File directory, GLib.FileInfo info);
		public int compare (Ide.ProjectFile b);
		public int compare_directories_first (Ide.ProjectFile b);
		[Version (since = "3.32")]
		public Ide.ProjectFile create_child (GLib.FileInfo info);
		[Version (since = "3.32")]
		public unowned GLib.File get_directory ();
		[Version (since = "3.32")]
		public unowned string get_display_name ();
		[Version (since = "3.32")]
		public unowned GLib.FileInfo get_info ();
		[Version (since = "3.32")]
		public unowned string get_name ();
		[Version (since = "3.32")]
		public unowned GLib.Icon? get_symbolic_icon ();
		[Version (since = "3.32")]
		public bool is_directory ();
		[Version (since = "3.32")]
		public bool is_symlink ();
		[Version (since = "3.32")]
		public async GLib.GenericArray<Ide.ProjectFile> list_children_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public GLib.File ref_file ();
		public async bool trash_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.File directory { get; construct; }
		[NoAccessorMethod]
		public GLib.File file { owned get; }
		public GLib.FileInfo info { get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_project_info_get_type ()")]
	[Version (since = "3.32")]
	public class ProjectInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public ProjectInfo ();
		public int compare (Ide.ProjectInfo info2);
		public bool equal (Ide.ProjectInfo other);
		public unowned string get_build_system_hint ();
		public unowned string get_build_system_name ();
		public unowned string get_description ();
		public unowned GLib.File? get_directory ();
		public unowned Ide.Doap? get_doap ();
		public unowned GLib.File? get_file ();
		public unowned GLib.Icon? get_icon ();
		public unowned string get_id ();
		public bool get_is_recent ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_languages ();
		public unowned GLib.DateTime? get_last_modified_at ();
		public unowned string get_name ();
		public int get_priority ();
		public unowned string? get_vcs_uri ();
		public void set_build_system_hint (string build_system_hint);
		public void set_build_system_name (string build_system_name);
		public void set_description (string description);
		public void set_directory (GLib.File directory);
		public void set_doap (Ide.Doap doap);
		public void set_file (GLib.File file);
		public void set_icon (GLib.Icon icon);
		public void set_icon_name (string icon_name);
		public void set_id (string id);
		public void set_is_recent (bool is_recent);
		public void set_languages (string languages);
		public void set_last_modified_at (GLib.DateTime modified_at);
		public void set_name (string name);
		public void set_priority (int priority);
		public void set_vcs_uri (string vcs_uri);
		public string build_system_hint { get; set; }
		public string build_system_name { get; set; }
		public string description { get; set; }
		public GLib.File directory { get; set; }
		public Ide.Doap doap { get; set; }
		public GLib.File file { get; set; }
		public GLib.Icon icon { get; set; }
		public string icon_name { set; }
		public string id { get; set; }
		public bool is_recent { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] languages { get; set; }
		public GLib.DateTime last_modified_at { get; set; }
		public string name { get; set; }
		public int priority { get; set; }
		public string vcs_uri { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_range_get_type ()")]
	public class Range : GLib.Object {
		[CCode (has_construct_function = false)]
		public Range (Ide.Location begin, Ide.Location end);
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Range.from_variant (GLib.Variant variant);
		[Version (since = "3.32")]
		public unowned Ide.Location get_begin ();
		[Version (since = "3.32")]
		public unowned Ide.Location get_end ();
		[Version (since = "3.32")]
		public GLib.Variant to_variant ();
		public Ide.Location begin { get; construct; }
		public Ide.Location end { get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_recent_projects_get_type ()")]
	public class RecentProjects : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public RecentProjects ();
		public string find_by_directory (string directory);
		[Version (since = "3.32")]
		public static unowned Ide.RecentProjects get_default ();
		[Version (since = "3.32")]
		public void remove (GLib.List<Ide.ProjectInfo> project_infos);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	[Compact]
	public class RunButton {
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_run_manager_get_type ()")]
	public class RunManager : Ide.Object, GLib.ActionGroup, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected RunManager ();
		public void add_handler (string id, string title, string icon_name, string accel, owned Ide.RunHandler run_handler);
		public void cancel ();
		public async Ide.BuildTarget discover_default_target_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public static unowned Ide.RunManager from_context (Ide.Context context);
		[Version (since = "3.32")]
		public unowned Ide.BuildTarget get_build_target ();
		public bool get_busy ();
		public unowned string get_handler ();
		public void remove_handler (string id);
		public async bool run_async (Ide.BuildTarget build_target, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_build_target (Ide.BuildTarget build_target);
		public void set_handler (string id);
		public Ide.BuildTarget build_target { get; set; }
		public bool busy { get; }
		public string handler { get; }
		[Version (since = "3.32")]
		public signal void run (Ide.Runner runner);
		[Version (since = "3.32")]
		public signal void stopped ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_runner_get_type ()")]
	public class Runner : Ide.Object {
		[CCode (has_construct_function = false)]
		public Runner (Ide.Context context);
		public void append_argv (string param);
		[NoWrapper]
		public virtual void fixup_launcher (Ide.SubprocessLauncher launcher);
		public virtual void force_quit ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.32")]
		public string[] get_argv ();
		[Version (since = "3.32")]
		public unowned Ide.BuildTarget? get_build_target ();
		public bool get_clear_env ();
		[Version (since = "3.32")]
		public unowned string? get_cwd ();
		public bool get_disable_pty ();
		[Version (since = "3.32")]
		public unowned Ide.Environment get_environment ();
		public bool get_failed ();
		public GLib.SubprocessFlags get_flags ();
		public int get_max_fd ();
		[Version (since = "3.34")]
		public unowned Vte.Pty? get_pty ();
		public bool get_run_on_host ();
		[Version (since = "3.32")]
		public virtual Ide.Runtime? get_runtime ();
		[Version (since = "3.32")]
		public virtual GLib.InputStream? get_stderr ();
		[Version (since = "3.32")]
		public virtual GLib.OutputStream? get_stdin ();
		[Version (since = "3.32")]
		public virtual GLib.InputStream? get_stdout ();
		public void prepend_argv (string param);
		[Version (since = "3.32")]
		public void push_args ([CCode (array_length = false, array_null_terminated = true)] string[]? args);
		public virtual async bool run_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_argv (string argv);
		[Version (since = "3.32")]
		public void set_build_target (Ide.BuildTarget? build_target);
		public void set_clear_env (bool clear_env);
		[Version (since = "3.32")]
		public void set_cwd (string? cwd);
		public void set_disable_pty (bool disable_pty);
		public void set_failed (bool failed);
		public void set_flags (GLib.SubprocessFlags flags);
		[Version (since = "3.32")]
		public void set_pty (Vte.Pty? pty);
		public void set_run_on_host (bool run_on_host);
		[Version (since = "3.32")]
		public int take_fd (int source_fd, int dest_fd);
		public void take_tty_fd (int tty_fd);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] argv { owned get; set; }
		[Version (since = "3.32")]
		public Ide.BuildTarget build_target { get; set; }
		public bool clear_env { get; set; }
		public string cwd { get; set; }
		public bool disable_pty { get; set; }
		public Ide.Environment environment { get; }
		[Version (since = "3.32")]
		public bool failed { get; set; }
		[Version (since = "3.32")]
		public bool run_on_host { get; set; }
		public signal void exited ();
		public signal void spawned (string object);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_runtime_get_type ()")]
	public class Runtime : Ide.Object {
		[CCode (has_construct_function = false)]
		public Runtime (string id, string title);
		public virtual bool contains_program_in_path (string program, GLib.Cancellable? cancellable = null);
		[Version (since = "3.32")]
		public virtual Ide.SubprocessLauncher create_launcher () throws GLib.Error;
		[Version (since = "3.32")]
		public virtual Ide.Runner? create_runner (Ide.BuildTarget? build_target);
		[Version (since = "3.32")]
		public string get_arch ();
		public unowned string get_category ();
		public unowned string get_display_name ();
		public unowned string get_id ();
		public unowned string get_name ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.32")]
		public virtual string[] get_system_include_dirs ();
		[Version (since = "3.32")]
		public virtual Ide.Triplet get_triplet ();
		public virtual void prepare_configuration (Ide.Config configuration);
		public void set_category (string category);
		public void set_display_name (string display_name);
		public void set_id (string id);
		public void set_name (string name);
		[Version (since = "3.32")]
		public virtual bool supports_toolchain (Ide.Toolchain toolchain);
		[Version (since = "3.32")]
		public virtual GLib.File translate_file (GLib.File file);
		public string category { get; set construct; }
		public string display_name { get; set construct; }
		public string id { get; set construct; }
		public string name { get; set construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_runtime_manager_get_type ()")]
	public class RuntimeManager : Ide.Object, GLib.Initable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected RuntimeManager ();
		public void add (Ide.Runtime runtime);
		[Version (since = "3.32")]
		public static unowned Ide.RuntimeManager from_context (Ide.Context context);
		[Version (since = "3.32")]
		public unowned Ide.Runtime get_runtime (string id);
		public void remove (Ide.Runtime runtime);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_search_button_get_type ()")]
	public class SearchButton : Dazzle.SuggestionButton, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SearchButton ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_search_engine_get_type ()")]
	public class SearchEngine : Ide.Object {
		[CCode (has_construct_function = false)]
		public SearchEngine ();
		[Version (since = "3.32")]
		public bool get_busy ();
		public async GLib.ListModel search_async (string query, uint max_results, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool busy { get; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_search_result_get_type ()")]
	public class SearchResult : Dazzle.Suggestion {
		[CCode (has_construct_function = false)]
		public SearchResult ();
		[Version (since = "3.32")]
		public virtual void activate (Gtk.Widget last_focus);
		public static int compare (void* a, void* b);
		public int get_priority ();
		public float get_score ();
		public void set_icon (GLib.Icon icon);
		public void set_priority (int priority);
		public void set_score (float score);
		public int priority { get; set; }
		public float score { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_settings_get_type ()")]
	public class Settings : GLib.Object {
		[CCode (has_construct_function = false)]
		public Settings (string project_id, string schema_id, string relative_path, bool ignore_project_settings);
		public void bind (string key, void* object, string property, GLib.SettingsBindFlags flags);
		[Version (since = "3.32")]
		public void bind_with_mapping (string key, void* object, string property, GLib.SettingsBindFlags flags, GLib.SettingsBindGetMapping? get_mapping, owned GLib.SettingsBindSetMapping? set_mapping);
		public bool get_boolean (string key);
		public GLib.Variant get_default_value (string key);
		public double get_double (string key);
		public bool get_ignore_project_settings ();
		public int get_int (string key);
		public unowned string get_relative_path ();
		public unowned string get_schema_id ();
		public string get_string (string key);
		public uint get_uint (string key);
		public GLib.Variant get_user_value (string key);
		public GLib.Variant get_value (string key);
		public void set_boolean (string key, bool val);
		public void set_double (string key, double val);
		public void set_int (string key, int val);
		public void set_string (string key, string val);
		public void set_uint (string key, uint val);
		public void set_value (string key, GLib.Variant value);
		public void unbind (string property);
		public bool ignore_project_settings { get; construct; }
		[NoAccessorMethod]
		public string project_id { owned get; construct; }
		public string relative_path { get; construct; }
		public string schema_id { get; construct; }
		public signal void changed (string object);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_simple_build_system_discovery_get_type ()")]
	public class SimpleBuildSystemDiscovery : Ide.Object, Ide.BuildSystemDiscovery {
		[CCode (has_construct_function = false)]
		protected SimpleBuildSystemDiscovery ();
		public unowned string get_glob ();
		public unowned string get_hint ();
		public int get_priority ();
		public void set_glob (string glob);
		public void set_hint (string hint);
		public void set_priority (int priority);
		[Version (since = "3.32")]
		public string glob { get; set; }
		[Version (since = "3.32")]
		public string hint { get; set; }
		[Version (since = "3.32")]
		public int priority { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_simple_build_target_get_type ()")]
	public class SimpleBuildTarget : Ide.Object, Ide.BuildTarget {
		[CCode (has_construct_function = false)]
		public SimpleBuildTarget (Ide.Context context);
		public void set_argv (string argv);
		public void set_cwd (string cwd);
		public void set_install_directory (GLib.File install_directory);
		public void set_language (string language);
		public void set_name (string name);
		public void set_priority (int priority);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_simple_toolchain_get_type ()")]
	public class SimpleToolchain : Ide.Toolchain {
		[CCode (has_construct_function = false)]
		public SimpleToolchain (string id, string display_name);
		[Version (since = "3.32")]
		public void set_tool_for_language (string language, string tool_id, string tool_path);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_snippet_get_type ()")]
	public class Snippet : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Snippet (string? trigger, string? language);
		public void add_chunk (Ide.SnippetChunk chunk);
		[Version (since = "3.32")]
		public Ide.Snippet copy ();
		public void get_chunk_range (Ide.SnippetChunk chunk, Gtk.TextIter begin, Gtk.TextIter end);
		[Version (since = "3.32")]
		public unowned Ide.SnippetContext? get_context ();
		[Version (since = "3.32")]
		public unowned string get_description ();
		[Version (since = "3.32")]
		public string get_full_text ();
		[Version (since = "3.32")]
		public unowned string get_language ();
		[Version (since = "3.32")]
		public uint get_n_chunks ();
		[Version (since = "3.32")]
		public unowned Ide.SnippetChunk get_nth_chunk (uint n);
		[Version (since = "3.32")]
		public int get_tab_stop ();
		[Version (since = "3.32")]
		public unowned string? get_trigger ();
		[Version (since = "3.32")]
		public void replace_current_chunk_text (string new_text);
		[Version (since = "3.32")]
		public void set_description (string description);
		[Version (since = "3.32")]
		public void set_language (string language);
		[Version (since = "3.32")]
		public void set_trigger (string trigger);
		[NoAccessorMethod]
		public Gtk.TextBuffer buffer { owned get; }
		public string description { get; set; }
		public string language { get; set; }
		[NoAccessorMethod]
		public Gtk.TextMark mark_begin { owned get; }
		[NoAccessorMethod]
		public Gtk.TextMark mark_end { owned get; }
		public int tab_stop { get; }
		public string trigger { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_snippet_chunk_get_type ()")]
	public class SnippetChunk : GLib.Object {
		[CCode (has_construct_function = false)]
		public SnippetChunk ();
		[Version (since = "3.32")]
		public Ide.SnippetChunk copy ();
		[Version (since = "3.32")]
		public unowned Ide.SnippetContext get_context ();
		public unowned string get_spec ();
		public int get_tab_stop ();
		public unowned string get_text ();
		public bool get_text_set ();
		public void set_context (Ide.SnippetContext context);
		public void set_spec (string spec);
		public void set_tab_stop (int tab_stop);
		public void set_text (string text);
		public void set_text_set (bool text_set);
		public Ide.SnippetContext context { get; set; }
		public string spec { get; set; }
		public int tab_stop { get; set; }
		public string text { get; set; }
		public bool text_set { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_snippet_context_get_type ()")]
	public class SnippetContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public SnippetContext ();
		public void add_shared_variable (string key, string value);
		public void add_variable (string key, string value);
		public void clear_variables ();
		public void dump ();
		public void emit_changed ();
		public string expand (string input);
		public unowned string get_variable (string key);
		public void set_line_prefix (string line_prefix);
		public void set_tab_width (int tab_size);
		public void set_use_spaces (bool use_spaces);
		public signal void changed ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_snippet_parser_get_type ()")]
	public class SnippetParser : GLib.Object {
		[CCode (has_construct_function = false)]
		public SnippetParser ();
		[Version (since = "3.32")]
		public unowned GLib.List<Ide.Snippet> get_snippets ();
		public bool load_from_data (string defalut_language, string data, ssize_t data_len) throws GLib.Error;
		public bool load_from_file (GLib.File file) throws GLib.Error;
		public signal void parsing_error (GLib.File object, uint p0, string p1);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_snippet_storage_get_type ()")]
	public class SnippetStorage : Ide.Object, GLib.AsyncInitable {
		[CCode (has_construct_function = false)]
		public SnippetStorage ();
		public void add (string default_scope, GLib.Bytes bytes);
		[Version (since = "3.32")]
		public void @foreach (Ide.SnippetStorageForeach @foreach);
		[Version (since = "3.32")]
		public static unowned Ide.SnippetStorage from_context (Ide.Context context);
		[Version (since = "3.32")]
		public void query (string lang, string? prefix, Ide.SnippetStorageForeach @foreach);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_source_view_get_type ()")]
	public class SourceView : Gtk.SourceView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false)]
		protected SourceView ();
		[NoWrapper]
		public virtual void auto_indent ();
		[Version (since = "3.32")]
		public unowned Ide.Completion get_completion ();
		public int get_count ();
		[Version (since = "3.32")]
		public unowned Ide.Snippet? get_current_snippet ();
		[Version (since = "3.32")]
		public unowned Ide.FileSettings? get_file_settings ();
		public unowned Pango.FontDescription get_font_desc ();
		public bool get_highlight_current_line ();
		public bool get_insert_matching_brace ();
		public void get_iter_at_visual_column (uint column, Gtk.TextIter location);
		public unowned string get_mode_display_name ();
		public unowned string get_mode_name ();
		public bool get_overwrite ();
		public bool get_overwrite_braces ();
		[Version (since = "3.32")]
		public Pango.FontDescription get_scaled_font_desc ();
		[Version (since = "3.32")]
		public uint get_scroll_offset ();
		public bool get_show_grid_lines ();
		public bool get_show_line_changes ();
		public bool get_show_line_diagnostics ();
		public bool get_show_line_numbers ();
		public bool get_snippet_completion ();
		public bool get_spell_checking ();
		[Version (since = "3.32")]
		public Gdk.Rectangle get_visible_rect ();
		public uint get_visual_column (Gtk.TextIter location);
		public void get_visual_position (uint line, uint line_column);
		[Version (since = "3.32")]
		public bool has_snippet ();
		[NoWrapper]
		public virtual void insert_at_cursor_and_indent (string str);
		public bool is_processing_key ();
		public bool move_mark_onscreen (Gtk.TextMark mark);
		public bool place_cursor_onscreen ();
		public void rollback_search ();
		public void save_search (string search_text);
		public void scroll_mark_onscreen (Gtk.TextMark mark, Ide.SourceScrollAlign use_align, double alignx, double aligny);
		public void scroll_to_insert ();
		public void scroll_to_iter (Gtk.TextIter iter, double within_margin, Ide.SourceScrollAlign use_align, double xalign, double yalign, bool animate_scroll);
		public void scroll_to_mark (Gtk.TextMark mark, double within_margin, Ide.SourceScrollAlign use_align, double xalign, double yalign, bool animate_scroll);
		public void set_count (int count);
		public void set_font_desc (Pango.FontDescription font_desc);
		public void set_font_name (string font_name);
		[Version (since = "3.32")]
		public void set_gutter (Ide.Gutter gutter);
		public void set_highlight_current_line (bool highlight_current_line);
		public void set_insert_matching_brace (bool insert_matching_brace);
		public void set_misspelled_word (Gtk.TextIter start, Gtk.TextIter end);
		public void set_overwrite_braces (bool overwrite_braces);
		[Version (since = "3.32")]
		public void set_scroll_offset (uint scroll_offset);
		public void set_show_grid_lines (bool show_grid_lines);
		public void set_show_line_changes (bool show_line_changes);
		public void set_show_line_diagnostics (bool show_line_diagnostics);
		public void set_show_line_numbers (bool show_line_numbers);
		public void set_snippet_completion (bool snippet_completion);
		public void set_spell_checking (bool enable);
		[NoAccessorMethod]
		public uint completion_n_rows { get; set; }
		public int count { get; set; }
		public Ide.FileSettings file_settings { get; }
		public Pango.FontDescription font_desc { get; set; }
		public string font_name { set construct; }
		[NoAccessorMethod]
		public Ide.IndentStyle indent_style { set; }
		[NoAccessorMethod]
		public Ide.Indenter indenter { owned get; }
		public bool insert_matching_brace { get; set; }
		[NoAccessorMethod]
		public bool interactive_completion { get; set; }
		public string mode_display_name { get; }
		[NoAccessorMethod]
		public int overscroll { get; set; }
		public bool overwrite_braces { get; set; }
		public uint scroll_offset { get; set; }
		public bool show_grid_lines { get; set; }
		public bool show_line_changes { get; set; }
		[Version (since = "3.32")]
		public bool show_line_diagnostics { get; set; }
		public signal void action (string object, string p0, string p1);
		public virtual signal void add_cursor (Ide.CursorType type);
		public virtual signal void append_to_count (int digit);
		[Version (since = "3.32")]
		public virtual signal void begin_macro ();
		[Version (since = "3.32")]
		public virtual signal void begin_rename ();
		public signal void begin_user_action ();
		[Version (since = "3.32")]
		public virtual signal void capture_modifier ();
		public virtual signal void clear_count ();
		public virtual signal void clear_modifier ();
		[HasEmitter]
		public virtual signal void clear_search ();
		public virtual signal void clear_selection ();
		[HasEmitter]
		public virtual signal void clear_snippets ();
		public virtual signal void copy_clipboard_extended ();
		public virtual signal void cycle_completion (Gtk.DirectionType direction);
		public virtual signal void decrease_font_size ();
		public virtual signal void delete_selection ();
		public signal void draw_bubbles (Cairo.Context object);
		public signal void duplicate_entire_line ();
		[Version (since = "3.32")]
		public virtual signal void end_macro ();
		public signal void end_user_action ();
		public signal void find_references ();
		public virtual signal void focus_location (Ide.Location location);
		public signal void format_selection ();
		public virtual signal void goto_definition ();
		public virtual signal void hide_completion ();
		public virtual signal void increase_font_size ();
		public virtual signal void indent_selection (int level);
		[Version (since = "3.32")]
		public virtual signal void insert_modifier (bool use_count);
		[HasEmitter]
		public virtual signal void jump (Gtk.TextIter from, Gtk.TextIter to);
		[Version (since = "3.32")]
		public virtual signal void move_error (Gtk.DirectionType dir);
		public virtual signal void move_search (Gtk.DirectionType dir, bool extend_selection, bool select_match, bool exclusive, bool apply_count, int at_word_boundaries);
		public virtual signal void movement (Ide.SourceViewMovement movement, bool extend_selection, bool exclusive, bool apply_count);
		public virtual signal void paste_clipboard_extended (bool smart_lines, bool after_cursor, bool place_cursor_at_original);
		[Version (since = "3.32")]
		public virtual signal void pop_selection ();
		[HasEmitter]
		[Version (since = "3.32")]
		public signal void pop_snippet ();
		[Version (since = "3.32")]
		public virtual signal void push_selection ();
		[HasEmitter]
		[Version (since = "3.32")]
		public signal void push_snippet (Ide.Snippet snippet, Gtk.TextIter? location);
		public virtual signal void rebuild_highlight ();
		public signal void reindent ();
		public virtual signal void remove_cursors ();
		public virtual signal void replay_macro (bool use_count);
		public virtual signal void request_documentation ();
		[Version (since = "3.32")]
		public signal void reset ();
		public virtual signal void reset_font_size ();
		public virtual signal void restore_insert_mark ();
		public virtual signal void save_command ();
		public virtual signal void save_insert_mark ();
		public virtual signal void save_search_char ();
		public virtual signal void select_inner (string inner_left, string inner_right, bool exclusive, bool string_mode);
		public virtual signal void select_tag (bool exclusive);
		public virtual signal void selection_theatric (Ide.SourceViewTheatric theatric);
		public virtual signal void set_mode (string mode, Ide.SourceViewModeType type);
		public virtual signal void set_overwrite (bool overwrite);
		public virtual signal void set_search_text (string search_text, bool from_selection);
		[Version (since = "3.32")]
		public virtual signal void sort (bool ignore_case, bool reverse);
		public virtual signal void swap_selection_bounds ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_subprocess_launcher_get_type ()")]
	public class SubprocessLauncher : GLib.Object {
		[CCode (has_construct_function = false)]
		public SubprocessLauncher (GLib.SubprocessFlags flags);
		public void append_path (string append_path);
		public unowned string get_arg (uint pos);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_argv ();
		public bool get_clear_env ();
		public unowned string get_cwd ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_environ ();
		public GLib.SubprocessFlags get_flags ();
		[Version (since = "3.34")]
		public int get_max_fd ();
		public bool get_needs_tty ();
		[Version (since = "3.32")]
		public bool get_run_on_host ();
		public unowned string getenv (string key);
		public void insert_argv (uint index, string arg);
		public void join_args_for_sh_c (uint start_pos);
		public void overlay_environment (Ide.Environment environment);
		public string pop_argv ();
		[Version (since = "3.32")]
		public void push_args ([CCode (array_length = false, array_null_terminated = true)] string[]? args);
		public void push_argv (string argv);
		public void replace_argv (uint index, string arg);
		public void set_argv (string argv);
		public void set_clear_env (bool clear_env);
		public void set_cwd (string cwd);
		[Version (since = "3.32")]
		public void set_environ ([CCode (array_length = false, array_null_terminated = true)] string[]? environ_);
		public void set_flags (GLib.SubprocessFlags flags);
		[Version (since = "3.32")]
		public void set_run_on_host (bool run_on_host);
		public void set_stdout_file_path (string stdout_file_path);
		public void setenv (string key, string value, bool replace);
		[Version (since = "3.32")]
		public virtual Ide.Subprocess spawn (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void take_fd (int source_fd, int dest_fd);
		public void take_stderr_fd (int stderr_fd);
		public void take_stdin_fd (int stdin_fd);
		public void take_stdout_fd (int stdout_fd);
		[NoAccessorMethod]
		public bool clean_env { get; set; }
		public string cwd { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] environ { get; set; }
		public GLib.SubprocessFlags flags { get; set construct; }
		public bool run_on_host { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_subprocess_supervisor_get_type ()")]
	public class SubprocessSupervisor : GLib.Object {
		[CCode (has_construct_function = false)]
		public SubprocessSupervisor ();
		[Version (since = "3.32")]
		public unowned Ide.SubprocessLauncher? get_launcher ();
		[Version (since = "3.32")]
		public unowned Ide.Subprocess? get_subprocess ();
		public void set_launcher (Ide.SubprocessLauncher launcher);
		public void set_subprocess (Ide.Subprocess subprocess);
		public void start ();
		public void stop ();
		public signal void exited (Ide.Subprocess object);
		public virtual signal void spawned (Ide.Subprocess subprocess);
		public signal bool supervise (Ide.SubprocessLauncher object);
		public signal bool unsupervise (Ide.SubprocessLauncher object);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_surface_get_type ()")]
	public class Surface : Dazzle.DockBin, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.32")]
		public Surface ();
		public virtual bool agree_to_shutdown ();
		[Version (since = "3.32")]
		public virtual void foreach_page (Gtk.Callback callback);
		[NoWrapper]
		public virtual void set_fullscreen (bool fullscreen);
		public void set_icon_name (string icon_name);
		public void set_title (string title);
		[NoAccessorMethod]
		public string icon_name { owned get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_surfaces_button_get_type ()")]
	public class SurfacesButton : Dazzle.MenuButton, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected SurfacesButton ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_symbol_get_type ()")]
	public class Symbol : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Symbol (string name, Ide.SymbolKind kind, Ide.SymbolFlags flags, Ide.Location? location, Ide.Location? header_location);
		[CCode (has_construct_function = false)]
		public Symbol.from_variant (GLib.Variant variant);
		public Ide.SymbolFlags get_flags ();
		[Version (since = "3.32")]
		public unowned Ide.Location? get_header_location ();
		public Ide.SymbolKind get_kind ();
		[Version (since = "3.32")]
		public unowned Ide.Location? get_location ();
		public unowned string get_name ();
		[Version (since = "3.32")]
		public GLib.Variant to_variant ();
		public Ide.SymbolFlags flags { get; construct; }
		public Ide.Location header_location { get; construct; }
		public Ide.SymbolKind kind { get; construct; }
		public Ide.Location location { get; construct; }
		public string name { get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_symbol_node_get_type ()")]
	public class SymbolNode : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SymbolNode ();
		public Ide.SymbolFlags get_flags ();
		public Ide.SymbolKind get_kind ();
		public virtual async Ide.Location? get_location_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned string get_name ();
		public bool get_use_markup ();
		[NoAccessorMethod]
		public Ide.SymbolFlags flags { get; set; }
		[NoAccessorMethod]
		public Ide.SymbolKind kind { get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public bool use_markup { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_tagged_entry_get_type ()")]
	public class TaggedEntry : Gtk.SearchEntry, Atk.Implementor, Gtk.Buildable, Gtk.CellEditable, Gtk.Editable {
		[CCode (has_construct_function = false)]
		public TaggedEntry ();
		public bool add_tag (Ide.TaggedEntryTag tag);
		public bool get_tag_button_visible ();
		public bool insert_tag (Ide.TaggedEntryTag tag, int position);
		public bool remove_tag (Ide.TaggedEntryTag tag);
		public void set_tag_button_visible (bool visible);
		[NoAccessorMethod]
		public bool tag_close_visible { set; }
		public signal void tag_button_clicked (Ide.TaggedEntryTag object);
		public signal void tag_clicked (Ide.TaggedEntryTag object);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_tagged_entry_tag_get_type ()")]
	public class TaggedEntryTag : GLib.Object {
		[CCode (has_construct_function = false)]
		public TaggedEntryTag (string label);
		public bool get_area (Cairo.RectangleInt rect);
		public bool get_has_close_button ();
		public unowned string get_label ();
		public unowned string get_style ();
		public void set_has_close_button (bool has_close_button);
		public void set_label (string label);
		public void set_style (string style);
		public bool has_close_button { get; set construct; }
		public string label { get; set construct; }
		public string style { get; set construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_task_get_type ()")]
	public class Task : GLib.Object, GLib.AsyncResult {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Task (GLib.Object? source_object, GLib.Cancellable? cancellable, [CCode (scope = "async", type = "GAsyncReadyCallback")] GLib.TaskReadyCallback callback);
		[Version (since = "3.32")]
		public void chain (Ide.Task other_task);
		[Version (since = "3.32")]
		public unowned GLib.Cancellable? get_cancellable ();
		public int get_complete_priority ();
		[Version (since = "3.32")]
		public bool get_completed ();
		public Ide.TaskKind get_kind ();
		[Version (since = "3.32")]
		public unowned string? get_name ();
		public int get_priority ();
		[Version (since = "3.32")]
		public bool get_return_on_cancel ();
		public void* get_source_tag ();
		[Version (since = "3.32")]
		public bool had_error ();
		[Version (since = "3.32")]
		public bool is_valid (void* source_object);
		public bool propagate_boolean () throws GLib.Error;
		public void* propagate_boxed () throws GLib.Error;
		public ssize_t propagate_int () throws GLib.Error;
		[Version (since = "3.32")]
		public GLib.Object propagate_object () throws GLib.Error;
		public void* propagate_pointer () throws GLib.Error;
		[Version (since = "3.32")]
		public void return_boolean (bool result);
		[Version (since = "3.32")]
		public void return_error (owned GLib.Error error);
		[Version (since = "3.32")]
		public bool return_error_if_cancelled ();
		[Version (since = "3.32")]
		public void return_int (ssize_t result);
		[Version (since = "3.32")]
		public void return_object (owned GLib.Object instance);
		[Version (since = "3.32")]
		public void set_check_cancellable (bool check_cancellable);
		public void set_complete_priority (int complete_priority);
		public void set_kind (Ide.TaskKind kind);
		[Version (since = "3.32")]
		public void set_name (string name);
		public void set_priority (int priority);
		[Version (since = "3.32")]
		public void set_release_on_propagate (bool release_on_propagate);
		[Version (since = "3.32")]
		public void set_return_on_cancel (bool return_on_cancel);
		[Version (since = "3.32")]
		public void set_source_tag (void* source_tag);
		public void set_task_data (void* task_data, GLib.DestroyNotify task_data_destroy);
		public bool completed { get; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_template_base_get_type ()")]
	public abstract class TemplateBase : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TemplateBase ();
		public void add_path (string path, GLib.File destination, Template.Scope scope, int mode);
		public void add_resource (string resource_path, GLib.File destination, Template.Scope scope, int mode);
		public async bool expand_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public unowned Template.TemplateLocator? get_locator ();
		public void reset ();
		public void set_locator (Template.TemplateLocator locator);
		[Version (since = "3.32")]
		public Template.TemplateLocator locator { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_terminal_get_type ()")]
	public class Terminal : Vte.Terminal, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Terminal ();
		public virtual signal bool copy_link_address ();
		public virtual signal bool open_link ();
		public virtual signal void populate_popup (Gtk.Widget widget);
		public virtual signal void search_reveal ();
		public virtual signal void select_all (bool all);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_terminal_launcher_get_type ()")]
	public class TerminalLauncher : GLib.Object {
		[CCode (has_construct_function = false)]
		public TerminalLauncher (Ide.Context context);
		public bool can_respawn ();
		[CCode (has_construct_function = false)]
		public TerminalLauncher.for_debug ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.34")]
		public TerminalLauncher.for_launcher (Ide.SubprocessLauncher launcher);
		[CCode (has_construct_function = false)]
		public TerminalLauncher.for_runner (Ide.Runtime runtime);
		[CCode (has_construct_function = false)]
		public TerminalLauncher.for_runtime (Ide.Runtime runtime);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_args ();
		public unowned string get_cwd ();
		public unowned string get_shell ();
		public unowned string get_title ();
		public void set_args (string args);
		public void set_cwd (string cwd);
		public void set_shell (string shell);
		public void set_title (string title);
		public async bool spawn_async (Vte.Pty pty, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] args { get; set; }
		public string cwd { get; set; }
		public string shell { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_terminal_page_get_type ()")]
	public class TerminalPage : Ide.Page, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected TerminalPage ();
		public void feed (string message);
		public unowned string get_current_directory_uri ();
		public void set_launcher (Ide.TerminalLauncher launcher);
		public void set_pty (Vte.Pty pty);
		[NoAccessorMethod]
		public bool close_on_exit { get; set; }
		[NoAccessorMethod]
		public Ide.TerminalLauncher launcher { owned get; set; }
		[NoAccessorMethod]
		public bool manage_spawn { get; construct; }
		[NoAccessorMethod]
		public Vte.Pty pty { owned get; construct; }
		[NoAccessorMethod]
		public bool respawn_on_exit { get; set; }
		public signal void text_inserted ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_terminal_popover_get_type ()")]
	public class TerminalPopover : Gtk.Popover, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public TerminalPopover ();
		[Version (since = "3.32")]
		public unowned Ide.Runtime get_runtime ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_terminal_search_get_type ()")]
	public class TerminalSearch : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected TerminalSearch ();
		[Version (since = "3.32")]
		public unowned Vte.Regex? get_regex ();
		[Version (since = "3.32")]
		public unowned Gtk.Revealer get_revealer ();
		[Version (since = "3.32")]
		public bool get_wrap_around ();
		[Version (since = "3.32")]
		public void set_terminal (Vte.Terminal terminal);
		public Vte.Regex regex { get; }
		public bool wrap_around { get; }
		public signal void search (bool object);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_terminal_surface_get_type ()")]
	public class TerminalSurface : Ide.Surface, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public TerminalSurface ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_terminal_workspace_get_type ()")]
	public class TerminalWorkspace : Ide.Workspace, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public TerminalWorkspace (Ide.Application application);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	[Compact]
	public class Test {
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	[Compact]
	public class TestManager {
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	[Compact]
	public class TestProvider {
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_text_edit_get_type ()")]
	public class TextEdit : Ide.Object {
		[CCode (has_construct_function = false)]
		public TextEdit (Ide.Range range, string text);
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public TextEdit.from_variant (GLib.Variant? variant);
		[Version (since = "3.32")]
		public unowned Ide.Range? get_range ();
		[Version (since = "3.32")]
		public unowned string? get_text ();
		public void set_range (Ide.Range range);
		public void set_text (string text);
		[Version (since = "3.32")]
		public GLib.Variant to_variant ();
		public Ide.Range range { get; set; }
		public string text { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	[Compact]
	public class ThreadPool {
		[Version (since = "3.32")]
		public static void push (Ide.ThreadPoolKind kind, [CCode (scope = "async")] Ide.ThreadFunc func);
		[Version (since = "3.32")]
		public static void push_task (Ide.ThreadPoolKind kind, GLib.Task task, [CCode (scope = "async")] GLib.TaskThreadFunc func);
		[Version (since = "3.32")]
		public static void push_with_priority (Ide.ThreadPoolKind kind, int priority, [CCode (scope = "async")] Ide.ThreadFunc func);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_toolchain_get_type ()")]
	public abstract class Toolchain : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Toolchain ();
		public unowned string get_display_name ();
		[Version (since = "3.32")]
		public Ide.Triplet get_host_triplet ();
		[Version (since = "3.32")]
		public unowned string get_id ();
		[Version (since = "3.32")]
		public virtual unowned string get_tool_for_language (string language, string tool_id);
		[Version (since = "3.32")]
		public virtual GLib.HashTable<string,string> get_tools_for_id (string tool_id);
		public void set_display_name (string display_name);
		[Version (since = "3.32")]
		public void set_host_triplet (Ide.Triplet host_triplet);
		[Version (since = "3.32")]
		public void set_id (string id);
		public string display_name { get; set; }
		public Ide.Triplet host_triplet { owned get; set; }
		public string id { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_toolchain_manager_get_type ()")]
	public class ToolchainManager : Ide.Object, GLib.AsyncInitable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected ToolchainManager ();
		[Version (since = "3.32")]
		public Ide.Toolchain get_toolchain (string id);
		[Version (since = "3.32")]
		public bool is_loaded ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_transfer_get_type ()")]
	public class Transfer : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Transfer ();
		public void cancel ();
		[Version (since = "3.32")]
		public Ide.Notification? create_notification ();
		public static GLib.Quark error_quark ();
		public virtual async bool execute_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_active ();
		public bool get_completed ();
		public unowned string get_icon_name ();
		public double get_progress ();
		public unowned string get_status ();
		public unowned string get_title ();
		public void set_icon_name (string icon_name);
		public void set_progress (double progress);
		public void set_status (string status);
		public void set_title (string title);
		public bool active { get; }
		public bool completed { get; }
		public string icon_name { get; set; }
		public double progress { get; set; }
		public string status { get; set; }
		public string title { get; set; }
		public signal void cancelled ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_transfer_button_get_type ()")]
	public class TransferButton : Dazzle.ProgressButton, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public TransferButton (Ide.Transfer transfer);
		[NoAccessorMethod]
		public Ide.Transfer transfer { owned get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_transfer_manager_get_type ()")]
	public class TransferManager : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected TransferManager ();
		public void cancel_all ();
		[Version (since = "3.32")]
		public void clear ();
		[Version (since = "3.32")]
		public async bool execute_async (Ide.Transfer transfer, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public static unowned Ide.TransferManager get_default ();
		[Version (since = "3.32")]
		public bool get_has_active ();
		public double get_progress ();
		[Version (since = "3.32")]
		public bool has_active { get; }
		[Version (since = "3.32")]
		public double progress { get; }
		[Version (since = "3.32")]
		public signal void all_transfers_completed ();
		[Version (since = "3.32")]
		public signal void transfer_completed (Ide.Transfer transfer);
		[Version (since = "3.32")]
		public signal void transfer_failed (Ide.Transfer transfer, GLib.Error reason);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_transient_sidebar_get_type ()")]
	public class TransientSidebar : Ide.Panel, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected TransientSidebar ();
		public void @lock ();
		[Version (since = "3.32")]
		public void set_page (Ide.Page? page);
		public void set_panel (Gtk.Widget panel);
		public void @unlock ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_tree_get_type ()")]
	public class Tree : Gtk.TreeView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Tree ();
		public void collapse_node (Ide.TreeNode node);
		public void expand_node (Ide.TreeNode node);
		[Version (since = "3.32")]
		public unowned Ide.TreeNode? get_selected_node ();
		public bool node_expanded (Ide.TreeNode node);
		public void select_node (Ide.TreeNode node);
		public void set_context_menu (GLib.Menu menu);
		public void show_popover_at_node (Ide.TreeNode node, Gtk.Popover popover);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_tree_model_get_type ()")]
	public class TreeModel : Ide.Object, Gtk.TreeDragDest, Gtk.TreeDragSource, Gtk.TreeModel {
		[CCode (has_construct_function = false)]
		protected TreeModel ();
		public async bool expand_async (Ide.TreeNode node, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public bool get_iter_for_node (out Gtk.TreeIter iter, Ide.TreeNode node);
		[Version (since = "3.32")]
		public unowned string? get_kind ();
		[Version (since = "3.32")]
		public unowned Ide.TreeNode? get_node (Gtk.TreeIter iter);
		[Version (since = "3.32")]
		public Gtk.TreePath? get_path_for_node (Ide.TreeNode node);
		[Version (since = "3.32")]
		public unowned Ide.TreeNode get_root ();
		[Version (since = "3.32")]
		public unowned Ide.Tree get_tree ();
		[Version (since = "3.32")]
		public void invalidate (Ide.TreeNode? node);
		[Version (since = "3.32")]
		public void set_kind (string kind);
		public void set_root (Ide.TreeNode root);
		[Version (since = "3.32")]
		public string kind { get; set; }
		[Version (since = "3.32")]
		public Ide.TreeNode root { get; set; }
		public Ide.Tree tree { get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_tree_node_get_type ()")]
	public class TreeNode : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public TreeNode ();
		public void add_emblem (GLib.Emblem emblem);
		[Version (since = "3.32")]
		public void append (Ide.TreeNode child);
		public unowned Gdk.RGBA? get_background_rgba ();
		[Version (since = "3.32")]
		public bool get_children_possible ();
		[Version (since = "3.32")]
		public unowned string? get_display_name ();
		[Version (since = "3.32")]
		public unowned GLib.Icon? get_expanded_icon ();
		public Ide.TreeNodeFlags get_flags ();
		public unowned Gdk.RGBA? get_foreground_rgba ();
		public bool get_has_error ();
		[Version (since = "3.32")]
		public unowned GLib.Icon? get_icon ();
		[Version (since = "3.32")]
		public uint get_index ();
		[Version (since = "3.32")]
		public bool get_is_header ();
		[Version (since = "3.32")]
		public unowned GLib.Object? get_item ();
		[Version (since = "3.32")]
		public uint get_n_children ();
		[Version (since = "3.32")]
		public unowned Ide.TreeNode? get_next ();
		[Version (since = "3.32")]
		public unowned Ide.TreeNode? get_nth_child (uint index_);
		[Version (since = "3.32")]
		public unowned Ide.TreeNode? get_parent ();
		[Version (since = "3.32")]
		public Gtk.TreePath? get_path ();
		[Version (since = "3.32")]
		public unowned Ide.TreeNode? get_previous ();
		[Version (since = "3.32")]
		public bool get_reset_on_collapse ();
		[Version (since = "3.32")]
		public unowned Ide.TreeNode? get_root ();
		public unowned string get_tag ();
		public bool get_use_markup ();
		[Version (since = "3.32")]
		public bool has_child ();
		[Version (since = "3.32")]
		public bool holds (GLib.Type type);
		[Version (since = "3.32")]
		public void insert_after (Ide.TreeNode child);
		[Version (since = "3.32")]
		public void insert_before (Ide.TreeNode child);
		[Version (since = "3.32")]
		public void insert_sorted (Ide.TreeNode child, Ide.TreeNodeCompare cmpfn);
		[Version (since = "3.32")]
		public bool is_empty ();
		[Version (since = "3.32")]
		public bool is_first ();
		[Version (since = "3.32")]
		public bool is_last ();
		[Version (since = "3.32")]
		public bool is_root ();
		public bool is_selected ();
		public bool is_tag (string tag);
		[Version (since = "3.32")]
		public void prepend (Ide.TreeNode child);
		[Version (since = "3.32")]
		public void remove (Ide.TreeNode child);
		public void set_background_rgba (Gdk.RGBA background_rgba);
		[Version (since = "3.32")]
		public void set_children_possible (bool children_possible);
		[Version (since = "3.32")]
		public void set_display_name (string display_name);
		[Version (since = "3.32")]
		public void set_expanded_icon (GLib.Icon? expanded_icon);
		[Version (since = "3.32")]
		public void set_expanded_icon_name (string? expanded_icon_name);
		public void set_flags (Ide.TreeNodeFlags flags);
		public void set_foreground_rgba (Gdk.RGBA foreground_rgba);
		public void set_has_error (bool has_error);
		[Version (since = "3.32")]
		public void set_icon (GLib.Icon? icon);
		[Version (since = "3.32")]
		public void set_icon_name (string? icon_name);
		[Version (since = "3.32")]
		public void set_is_header (bool header);
		public void set_item (void* item);
		[Version (since = "3.32")]
		public void set_reset_on_collapse (bool reset_on_collapse);
		public void set_tag (string tag);
		public void set_use_markup (bool use_markup);
		[Version (since = "3.32")]
		public void traverse (GLib.TraverseType traverse_type, GLib.TraverseFlags traverse_flags, int max_depth, Ide.TreeTraverseFunc traverse_func);
		[Version (since = "3.32")]
		public bool children_possible { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public bool destroy_item { get; set; }
		[Version (since = "3.32")]
		public string display_name { get; set; }
		[Version (since = "3.32")]
		public GLib.Icon expanded_icon { get; set; }
		[Version (since = "3.32")]
		public string expanded_icon_name { set; }
		[Version (since = "3.32")]
		public bool has_error { get; set; }
		[Version (since = "3.32")]
		public GLib.Icon icon { get; set; }
		[Version (since = "3.32")]
		public string icon_name { set; }
		[Version (since = "3.32")]
		public bool is_header { get; set; }
		[Version (since = "3.32")]
		public GLib.Object item { get; set; }
		[Version (since = "3.32")]
		public bool reset_on_collapse { get; set; }
		[Version (since = "3.32")]
		public string tag { get; set; }
		[Version (since = "3.32")]
		public bool use_markup { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", ref_function = "ide_triplet_ref", type_id = "ide_triplet_get_type ()", unref_function = "ide_triplet_unref")]
	[Compact]
	public class Triplet {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Triplet (string full_name);
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Triplet.from_system ();
		[Version (since = "3.32")]
		public unowned string get_arch ();
		[Version (since = "3.32")]
		public unowned string get_full_name ();
		[Version (since = "3.32")]
		public unowned string? get_kernel ();
		[Version (since = "3.32")]
		public unowned string? get_operating_system ();
		[Version (since = "3.32")]
		public unowned string? get_vendor ();
		[Version (since = "3.32")]
		public bool is_system ();
		[Version (since = "3.32")]
		public unowned Ide.Triplet @ref ();
		[Version (since = "3.32")]
		public void unref ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Triplet.with_quadruplet (string arch, string? vendor, string? kernel, string? operating_system);
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Triplet.with_triplet (string arch, string? kernel, string? operating_system);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", ref_function = "ide_unsaved_file_ref", type_id = "ide_unsaved_file_get_type ()", unref_function = "ide_unsaved_file_unref")]
	[Compact]
	public class UnsavedFile {
		[Version (since = "3.32")]
		public unowned GLib.Bytes get_content ();
		[Version (since = "3.32")]
		public unowned GLib.File get_file ();
		public int64 get_sequence ();
		public unowned string get_temp_path ();
		public bool persist (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned Ide.UnsavedFile @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_unsaved_files_get_type ()")]
	public class UnsavedFiles : Ide.Object {
		[CCode (has_construct_function = false)]
		protected UnsavedFiles ();
		public void clear ();
		public bool contains (GLib.File file);
		[Version (since = "3.32")]
		public static unowned Ide.UnsavedFiles from_context (Ide.Context context);
		public int64 get_sequence ();
		[Version (since = "3.32")]
		public Ide.UnsavedFile? get_unsaved_file (GLib.File file);
		public async bool reap_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void remove (GLib.File file);
		public async bool restore_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public GLib.GenericArray<Ide.UnsavedFile> to_array ();
		public void update (GLib.File file, GLib.Bytes content);
		[NoAccessorMethod]
		public string project_id { owned get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_vcs_file_info_get_type ()")]
	public class VcsFileInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public VcsFileInfo (GLib.File file);
		[Version (since = "3.32")]
		public unowned GLib.File get_file ();
		public Ide.VcsFileStatus get_status ();
		public void set_status (Ide.VcsFileStatus status);
		public GLib.File file { get; construct; }
		public Ide.VcsFileStatus status { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_vcs_monitor_get_type ()")]
	public class VcsMonitor : Ide.Object {
		[CCode (has_construct_function = false)]
		protected VcsMonitor ();
		[Version (since = "3.32")]
		public static unowned Ide.VcsMonitor? from_context (Ide.Context context);
		public uint64 get_sequence ();
		[Version (since = "3.32")]
		public Ide.VcsFileInfo? ref_info (GLib.File file);
		[Version (since = "3.32")]
		public GLib.File? ref_root ();
		[Version (since = "3.32")]
		public Ide.Vcs? ref_vcs ();
		public void set_root (GLib.File file);
		public void set_vcs (Ide.Vcs vcs);
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public GLib.File root { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "3.32")]
		public Ide.Vcs vcs { owned get; set; }
		[Version (since = "3.32")]
		public signal void changed (GLib.File file, GLib.File? other_file, GLib.FileMonitorEvent event);
		[Version (since = "3.32")]
		public signal void reloaded ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", ref_function = "ide_vcs_uri_ref", type_id = "ide_vcs_uri_get_type ()", unref_function = "ide_vcs_uri_unref")]
	[Compact]
	public class VcsUri {
		[CCode (has_construct_function = false)]
		public VcsUri (string uri);
		[Version (since = "3.32")]
		public string? get_clone_name ();
		public unowned string get_host ();
		public unowned string get_path ();
		public uint get_port ();
		public unowned string get_scheme ();
		public unowned string get_user ();
		public static bool is_valid (string uri_string);
		public unowned Ide.VcsUri @ref ();
		public void set_host (string host);
		public void set_path (string path);
		public void set_port (uint port);
		public void set_scheme (string scheme);
		public void set_user (string user);
		public string to_string ();
		public void unref ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_workbench_get_type ()")]
	public class Workbench : Gtk.WindowGroup, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Workbench ();
		[Version (since = "3.32")]
		public void activate ();
		[Version (since = "3.32")]
		public void add_workspace (Ide.Workspace workspace);
		[Version (since = "3.32")]
		public unowned Ide.WorkbenchAddin? addin_find_by_module_name (string module_name);
		[Version (since = "3.32")]
		public void focus_workspace (Ide.Workspace workspace);
		[CCode (has_construct_function = false)]
		[Version (since = "3.32")]
		public Workbench.for_context (Ide.Context context);
		[Version (since = "3.32")]
		public void foreach_page (Gtk.Callback callback);
		[Version (since = "3.32")]
		public void foreach_workspace (Gtk.Callback callback);
		[Version (since = "3.32")]
		public static unowned Ide.Workbench? from_widget (Gtk.Widget widget);
		[Version (since = "3.32")]
		public unowned Ide.BuildSystem? get_build_system ();
		[Version (since = "3.32")]
		public unowned Ide.Context get_context ();
		[Version (since = "3.32")]
		public unowned Ide.Workspace? get_current_workspace ();
		[Version (since = "3.32")]
		public unowned Ide.ProjectInfo? get_project_info ();
		[Version (since = "3.32")]
		public unowned Ide.SearchEngine get_search_engine ();
		[Version (since = "3.32")]
		public unowned Ide.Vcs? get_vcs ();
		[Version (since = "3.32")]
		public unowned Ide.VcsMonitor? get_vcs_monitor ();
		[Version (since = "3.32")]
		public unowned Ide.Workspace? get_workspace_by_type (GLib.Type type);
		[Version (since = "3.32")]
		public bool has_project ();
		[Version (since = "3.32")]
		public async bool load_project_async (Ide.ProjectInfo project_info, GLib.Type workspace_type, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public async void open_all_async ([CCode (array_length_cname = "n_files", array_length_pos = 1.5, array_length_type = "guint")] GLib.File[] files, string? hint, GLib.Cancellable? cancellable);
		[Version (since = "3.32")]
		public async bool open_async (GLib.File file, string? hint, Ide.BufferOpenFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public async void open_at_async (GLib.File file, string? hint, int at_line, int at_line_offset, Ide.BufferOpenFlags flags, GLib.Cancellable? cancellable);
		[Version (since = "3.32")]
		public void remove_workspace (Ide.Workspace workspace);
		[Version (since = "3.32")]
		public async GLib.File resolve_file_async (string filename, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public void set_build_system (Ide.BuildSystem? build_system);
		[Version (since = "3.32")]
		public void set_vcs (Ide.Vcs? vcs);
		[Version (since = "3.32")]
		public async bool unload_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public Ide.Context context { get; construct; }
		[Version (since = "3.32")]
		public Ide.Vcs vcs { get; set; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_id = "ide_workspace_get_type ()")]
	public abstract class Workspace : Dazzle.ApplicationWindow, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected Workspace ();
		[Version (since = "3.32")]
		public void add_surface (Ide.Surface surface);
		[NoWrapper]
		public virtual void context_set (Ide.Context context);
		[Version (since = "3.32")]
		public virtual void foreach_page (Gtk.Callback callback);
		[Version (since = "3.32")]
		public void foreach_surface (Gtk.Callback callback);
		[Version (since = "3.32")]
		public unowned GLib.Cancellable get_cancellable ();
		[Version (since = "3.32")]
		public unowned Ide.Context? get_context ();
		[Version (since = "3.32")]
		public unowned Ide.HeaderBar? get_header_bar ();
		[Version (since = "3.32")]
		public unowned Ide.Page? get_most_recent_page ();
		[Version (since = "3.32")]
		public unowned Gtk.Overlay get_overlay ();
		[Version (since = "3.32")]
		public unowned Ide.Surface? get_surface_by_name (string name);
		[Version (since = "3.32")]
		public unowned Ide.Surface? get_visible_surface ();
		[CCode (cname = "ide_workspace_class_set_kind")]
		[Version (since = "3.32")]
		public class void set_kind (string kind);
		[Version (since = "3.32")]
		public void set_visible_surface (Ide.Surface surface);
		[Version (since = "3.32")]
		public void set_visible_surface_name (string visible_surface_name);
		[Version (since = "3.32")]
		public Ide.Context context { get; }
		[Version (since = "3.32")]
		public Ide.Surface visible_surface { get; set; }
		[Version (since = "3.32")]
		public virtual signal void surface_set (Ide.Surface? surface);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeApplicationAddinInterface", type_id = "ide_application_addin_get_type ()")]
	public interface ApplicationAddin : GLib.Object {
		[Version (since = "3.32")]
		public abstract void activate (Ide.Application application);
		[Version (since = "3.32")]
		public abstract void add_option_entries (Ide.Application application);
		[Version (since = "3.32")]
		public abstract void handle_command_line (Ide.Application application, GLib.ApplicationCommandLine cmdline);
		[Version (since = "3.32")]
		public abstract void load (Ide.Application application);
		[Version (since = "3.32")]
		public abstract void open (Ide.Application application, [CCode (array_length_cname = "n_files", array_length_pos = 2.5)] GLib.File[] files, string hint);
		[Version (since = "3.32")]
		public abstract void unload (Ide.Application application);
		public abstract void workbench_added (Ide.Workbench workbench);
		public abstract void workbench_removed (Ide.Workbench workbench);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeBufferAddinInterface", type_id = "ide_buffer_addin_get_type ()")]
	public interface BufferAddin : GLib.Object {
		[Version (since = "3.32")]
		public abstract void change_settled (Ide.Buffer buffer);
		[Version (since = "3.32")]
		public abstract void file_loaded (Ide.Buffer buffer, GLib.File file);
		[Version (since = "3.32")]
		public abstract void file_saved (Ide.Buffer buffer, GLib.File file);
		[Version (since = "3.32")]
		public abstract void language_set (Ide.Buffer buffer, string language_id);
		[Version (since = "3.32")]
		public abstract void load (Ide.Buffer buffer);
		[Version (since = "3.32")]
		public abstract void save_file (Ide.Buffer buffer, GLib.File file);
		public abstract async bool settle_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract void style_scheme_changed (Ide.Buffer buffer);
		[Version (since = "3.32")]
		public abstract void unload (Ide.Buffer buffer);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeBuildSystemInterface", type_id = "ide_build_system_get_type ()")]
	public interface BuildSystem : Ide.Object {
		[Version (since = "3.32")]
		public static unowned Ide.BuildSystem? from_context (Ide.Context context);
		[CCode (array_length = false, array_null_terminated = true)]
		public abstract async string[] get_build_flags_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.HashTable<Ide.File,string[]> get_build_flags_for_dir_async (GLib.File directory, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract async GLib.HashTable<Ide.File,string[]> get_build_flags_for_files_async (GLib.GenericArray<GLib.File> files, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract string get_builddir (Ide.Pipeline pipeline);
		public abstract string get_display_name ();
		public abstract string get_id ();
		public abstract int get_priority ();
		[Version (since = "3.32")]
		public abstract string? get_project_version ();
		[Version (since = "3.32")]
		public abstract bool supports_toolchain (Ide.Toolchain toolchain);
		[NoAccessorMethod]
		public abstract GLib.File project_file { owned get; construct; }
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeBuildSystemDiscoveryInterface", type_id = "ide_build_system_discovery_get_type ()")]
	public interface BuildSystemDiscovery : GLib.Object {
		[Version (since = "3.32")]
		public abstract string discover (GLib.File project_file, GLib.Cancellable? cancellable, out int priority) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeBuildTargetInterface", type_id = "ide_build_target_get_type ()")]
	public interface BuildTarget : Ide.Object {
		public bool compare (Ide.BuildTarget right);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.32")]
		public abstract string[] get_argv ();
		[Version (since = "3.32")]
		public abstract string? get_cwd ();
		[Version (since = "3.32")]
		public abstract string? get_display_name ();
		[Version (since = "3.32")]
		public bool get_install ();
		[Version (since = "3.32")]
		public abstract GLib.File? get_install_directory ();
		[Version (since = "3.32")]
		public abstract Ide.ArtifactKind get_kind ();
		[Version (since = "3.32")]
		public abstract string get_language ();
		[Version (since = "3.32")]
		public abstract string? get_name ();
		[Version (since = "3.32")]
		public abstract int get_priority ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeBuildTargetProviderInterface", type_id = "ide_build_target_provider_get_type ()")]
	public interface BuildTargetProvider : GLib.Object {
		[Version (since = "3.32")]
		public abstract async GLib.GenericArray<Ide.BuildTarget> get_targets_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeCodeIndexEntriesInterface", type_id = "ide_code_index_entries_get_type ()")]
	public interface CodeIndexEntries : GLib.Object {
		[Version (since = "3.32")]
		public async GLib.GenericArray<Ide.CodeIndexEntry> collect_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract GLib.File get_file ();
		[Version (since = "3.32")]
		public abstract Ide.CodeIndexEntry? get_next_entry ();
		[Version (since = "3.32")]
		public abstract async GLib.GenericArray<Ide.CodeIndexEntry> next_entries_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeCodeIndexerInterface", type_id = "ide_code_indexer_get_type ()")]
	public interface CodeIndexer : Ide.Object {
		[Version (since = "3.32")]
		public abstract async string generate_key_async (Ide.Location location, [CCode (array_length = false, array_null_terminated = true)] string[]? build_flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract async Ide.CodeIndexEntries index_file_async (GLib.File file, [CCode (array_length = false, array_null_terminated = true)] string[]? build_flags, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeCommandInterface", type_id = "ide_command_get_type ()")]
	public interface Command : Ide.Object {
		[Version (since = "3.34")]
		public abstract GLib.Icon? get_icon ();
		[Version (since = "3.34")]
		public abstract int get_priority ();
		[Version (since = "3.32")]
		public abstract string get_subtitle ();
		[Version (since = "3.32")]
		public abstract string get_title ();
		[Version (since = "3.32")]
		public abstract async bool run_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeCommandProviderInterface", type_id = "ide_command_provider_get_type ()")]
	public interface CommandProvider : GLib.Object {
		[Version (since = "3.34")]
		public abstract Ide.Command? get_command_by_id (Ide.Workspace workspace, string command_id);
		public abstract void load_shortcuts (Ide.Workspace workspace);
		public abstract async GLib.GenericArray<Ide.Command> query_async (Ide.Workspace workspace, string typed_text, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unload_shortcuts (Ide.Workspace workspace);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeCompletionDisplayInterface", type_id = "ide_completion_display_get_type ()")]
	public interface CompletionDisplay : Gtk.Widget {
		public abstract void attach (Gtk.SourceView view);
		public abstract bool key_press_event (Gdk.EventKey key);
		public abstract void move_cursor (Gtk.MovementStep step, int count);
		public abstract void set_context (Ide.CompletionContext context);
		[NoWrapper]
		public abstract void set_font_desc (Pango.FontDescription font_desc);
		public abstract void set_n_rows (uint n_rows);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeCompletionProposalInterface", type_id = "ide_completion_proposal_get_type ()")]
	public interface CompletionProposal : GLib.Object {
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeCompletionProviderInterface", type_id = "ide_completion_provider_get_type ()")]
	public interface CompletionProvider : GLib.Object {
		public void activate_poposal (Ide.CompletionContext context, Ide.CompletionProposal proposal, Gdk.EventKey key);
		[NoWrapper]
		public abstract void activate_proposal (Ide.CompletionContext context, Ide.CompletionProposal proposal, Gdk.EventKey key);
		[Version (since = "3.32")]
		public abstract void display_proposal (Ide.CompletionListBoxRow row, Ide.CompletionContext context, string? typed_text, Ide.CompletionProposal proposal);
		[Version (since = "3.32")]
		public abstract string? get_comment (Ide.CompletionProposal proposal);
		[Version (since = "3.32")]
		public abstract GLib.Icon? get_icon ();
		[Version (since = "3.32")]
		public abstract int get_priority (Ide.CompletionContext context);
		[Version (since = "3.32")]
		public abstract string? get_title ();
		[Version (since = "3.32")]
		public abstract bool is_trigger (Gtk.TextIter iter, unichar ch);
		[Version (since = "3.32")]
		public abstract bool key_activates (Ide.CompletionProposal proposal, Gdk.EventKey key);
		[NoWrapper]
		public abstract void load (Ide.Context context);
		[Version (since = "3.32")]
		public abstract async GLib.ListModel populate_async (Ide.CompletionContext context, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract bool refilter (Ide.CompletionContext context, GLib.ListModel proposals);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeConfigProviderInterface", type_id = "ide_config_provider_get_type ()")]
	public interface ConfigProvider : Ide.Object {
		[Version (since = "3.32")]
		public abstract void @delete (Ide.Config config);
		[Version (since = "3.32")]
		public abstract void duplicate (Ide.Config config);
		[Version (since = "3.32")]
		public void emit_added (Ide.Config config);
		[Version (since = "3.32")]
		public void emit_removed (Ide.Config config);
		[Version (since = "3.32")]
		public abstract async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract void unload ();
		public virtual signal void added (Ide.Config config);
		public virtual signal void removed (Ide.Config config);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeConfigViewAddinInterface", type_id = "ide_config_view_addin_get_type ()")]
	public interface ConfigViewAddin : GLib.Object {
		public abstract void load (Dazzle.Preferences preferences, Ide.Config configuration);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeContextAddinInterface", type_id = "ide_context_addin_get_type ()")]
	public interface ContextAddin : GLib.Object {
		[Version (since = "3.32")]
		public abstract void load (Ide.Context context);
		[Version (since = "3.32")]
		public abstract async bool load_project_async (Ide.Context context, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract void unload (Ide.Context context);
		[HasEmitter]
		[Version (since = "3.32")]
		public virtual signal void project_loaded (Ide.Context context);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeDependencyUpdaterInterface", type_id = "ide_dependency_updater_get_type ()")]
	public interface DependencyUpdater : Ide.Object {
		public abstract async bool update_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeDiagnosticProviderInterface", type_id = "ide_diagnostic_provider_get_type ()")]
	public interface DiagnosticProvider : Ide.Object {
		[Version (since = "3.32")]
		public abstract async Ide.Diagnostics diagnose_async (GLib.File file, GLib.Bytes? contents, string? lang_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public void emit_invalidated ();
		[Version (since = "3.32")]
		public abstract void load ();
		[Version (since = "3.32")]
		public abstract void unload ();
		public signal void invalidated ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeEditorAddinInterface", type_id = "ide_editor_addin_get_type ()")]
	public interface EditorAddin : GLib.Object {
		[Version (since = "3.32")]
		public static unowned Ide.EditorAddin? find_by_module_name (Ide.EditorSurface editor, string module_name);
		[Version (since = "3.32")]
		public abstract void load (Ide.EditorSurface surface);
		[Version (since = "3.32")]
		public abstract void page_set (Ide.Page? page);
		[Version (since = "3.32")]
		public abstract void unload (Ide.EditorSurface surface);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeEditorPageAddinInterface", type_id = "ide_editor_page_addin_get_type ()")]
	public interface EditorPageAddin : GLib.Object {
		public abstract void frame_set (Ide.Frame frame);
		public abstract void language_changed (string language_id);
		public abstract void load (Ide.EditorPage page);
		public abstract void unload (Ide.EditorPage page);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeFormatterInterface", type_id = "ide_formatter_get_type ()")]
	public interface Formatter : GLib.Object {
		public abstract async bool format_async (Ide.Buffer buffer, Ide.FormatterOptions options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async bool format_range_async (Ide.Buffer buffer, Ide.FormatterOptions options, Gtk.TextIter begin, Gtk.TextIter end, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void load ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeFrameAddinInterface", type_id = "ide_frame_addin_get_type ()")]
	public interface FrameAddin : GLib.Object {
		[Version (since = "3.32")]
		public abstract void load (Ide.Frame frame);
		[Version (since = "3.32")]
		public abstract void set_page (Ide.Page? page);
		[Version (since = "3.32")]
		public abstract void unload (Ide.Frame frame);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeGreeterSectionInterface", type_id = "ide_greeter_section_get_type ()")]
	public interface GreeterSection : Gtk.Widget {
		[Version (since = "3.32")]
		public abstract bool activate_first ();
		public abstract void delete_selected ();
		public void emit_project_activated (Ide.ProjectInfo project_info);
		[Version (since = "3.32")]
		public abstract bool filter (Dazzle.PatternSpec? spec);
		[Version (since = "3.32")]
		public abstract int get_priority ();
		public abstract void purge_selected ();
		public abstract void set_selection_mode (bool selection_mode);
		[Version (since = "3.32")]
		public virtual signal void project_activated (Ide.ProjectInfo project_info);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeGutterInterface", type_id = "ide_gutter_get_type ()")]
	public interface Gutter : GLib.Object {
		public bool get_show_line_changes ();
		public bool get_show_line_diagnostics ();
		public bool get_show_line_numbers ();
		public void set_show_line_changes (bool show_line_changes);
		public void set_show_line_diagnostics (bool show_line_diagnostics);
		public void set_show_line_numbers (bool show_line_numbers);
		[ConcreteAccessor]
		public abstract bool show_line_changes { get; set; }
		[ConcreteAccessor]
		public abstract bool show_line_diagnostics { get; set; }
		[ConcreteAccessor]
		public abstract bool show_line_numbers { get; set; }
		[HasEmitter]
		public virtual signal void style_changed ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeHighlighterInterface", type_id = "ide_highlighter_get_type ()")]
	public interface Highlighter : Ide.Object {
		public abstract void load ();
		[NoWrapper]
		public abstract void set_engine (Ide.HighlightEngine engine);
		[Version (since = "3.32")]
		public abstract Gtk.TextIter update (Ide.HighlightCallback callback, Gtk.TextIter range_begin, Gtk.TextIter range_end);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeHoverProviderInterface", type_id = "ide_hover_provider_get_type ()")]
	public interface HoverProvider : GLib.Object {
		[Version (since = "3.32")]
		public abstract async bool hover_async (Ide.HoverContext context, Gtk.TextIter location, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract void load (Ide.SourceView view);
		[Version (since = "3.32")]
		public abstract void unload (Ide.SourceView view);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeIndenterInterface", type_id = "ide_indenter_get_type ()")]
	public interface Indenter : Ide.Object {
		[Version (since = "3.32")]
		public abstract string? format (Gtk.TextView text_view, Gtk.TextIter begin, Gtk.TextIter end, out int cursor_offset, Gdk.EventKey event);
		[Version (since = "3.32")]
		public abstract bool is_trigger (Gdk.EventKey event);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeOmniBarAddinInterface", type_id = "ide_omni_bar_addin_get_type ()")]
	public interface OmniBarAddin : GLib.Object {
		[Version (since = "3.32")]
		public abstract void load (Ide.OmniBar omni_bar);
		[Version (since = "3.32")]
		public abstract void unload (Ide.OmniBar omni_bar);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdePipelineAddinInterface", type_id = "ide_pipeline_addin_get_type ()")]
	public interface PipelineAddin : Ide.Object {
		public abstract void load (Ide.Pipeline pipeline);
		[Version (since = "3.34")]
		public abstract void prepare (Ide.Pipeline pipeline);
		[Version (since = "3.32")]
		public void track (uint stage_id);
		public abstract void unload (Ide.Pipeline pipeline);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdePreferencesAddinInterface", type_id = "ide_preferences_addin_get_type ()")]
	public interface PreferencesAddin : GLib.Object {
		[Version (since = "3.32")]
		public abstract void load (Dazzle.Preferences preferences);
		[Version (since = "3.32")]
		public abstract void unload (Dazzle.Preferences preferences);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeProjectTemplateInterface", type_id = "ide_project_template_get_type ()")]
	public interface ProjectTemplate : GLib.Object {
		public int compare (Ide.ProjectTemplate b);
		[Version (since = "3.32")]
		public abstract async bool expand_async (GLib.HashTable<string,GLib.Variant> @params, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract string get_description ();
		public abstract string get_icon_name ();
		public abstract string get_id ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.32")]
		public abstract string[] get_languages ();
		public abstract string get_name ();
		[Version (since = "3.32")]
		public abstract int get_priority ();
		[Version (since = "3.32")]
		public abstract unowned Gtk.Widget get_widget ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeProjectTreeAddinInterface", type_id = "ide_project_tree_addin_get_type ()")]
	public interface ProjectTreeAddin : GLib.Object {
		[Version (since = "3.32")]
		public abstract void load (Dazzle.Tree tree);
		[Version (since = "3.32")]
		public abstract void unload (Dazzle.Tree tree);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeRenameProviderInterface", type_id = "ide_rename_provider_get_type ()")]
	public interface RenameProvider : Ide.Object {
		public abstract void load ();
		[Version (since = "3.32")]
		public abstract async bool rename_async (Ide.Location location, string new_name, GLib.Cancellable? cancellable, out GLib.GenericArray<Ide.TextEdit> edits) throws GLib.Error;
		public abstract void unload ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeRunnerAddinInterface", type_id = "ide_runner_addin_get_type ()")]
	public interface RunnerAddin : GLib.Object {
		public abstract void load (Ide.Runner runner);
		public abstract async bool posthook_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async bool prehook_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unload (Ide.Runner runner);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeRuntimeProviderInterface", type_id = "ide_runtime_provider_get_type ()")]
	public interface RuntimeProvider : Ide.Object {
		[Version (since = "3.32")]
		public abstract async Ide.Runtime bootstrap_async (Ide.Pipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract bool can_install (string runtime_id);
		public abstract async bool install_async (string runtime_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void load (Ide.RuntimeManager manager);
		public abstract void unload (Ide.RuntimeManager manager);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeSearchProviderInterface", type_id = "ide_search_provider_get_type ()")]
	public interface SearchProvider : Ide.Object {
		public abstract async GLib.GenericArray<Ide.SearchResult> search_async (string query, uint max_results, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeSessionAddinInterface", type_id = "ide_session_addin_get_type ()")]
	public interface SessionAddin : Ide.Object {
		[Version (since = "3.30")]
		public abstract async bool restore_async (Ide.Workbench workbench, GLib.Variant state, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.30")]
		public abstract async GLib.Variant? save_async (Ide.Workbench workbench, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeSubprocessInterface", type_id = "ide_subprocess_get_type ()")]
	public interface Subprocess : GLib.Object {
		public bool check_exit_status () throws GLib.Error;
		public abstract bool communicate (GLib.Bytes stdin_buf, GLib.Cancellable? cancellable, GLib.Bytes stdout_buf, GLib.Bytes stderr_buf) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract async bool communicate_async (GLib.Bytes? stdin_buf, GLib.Cancellable? cancellable, out GLib.Bytes stdout_buf, out GLib.Bytes stderr_buf) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract bool communicate_utf8 (string? stdin_buf, GLib.Cancellable? cancellable, out string? stdout_buf, out string? stderr_buf) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract async bool communicate_utf8_async (string? stdin_buf, GLib.Cancellable? cancellable, out string stdout_buf, out string stderr_buf) throws GLib.Error;
		public abstract void force_exit ();
		public abstract int get_exit_status ();
		public abstract unowned string get_identifier ();
		public abstract bool get_if_exited ();
		public abstract bool get_if_signaled ();
		public abstract int get_status ();
		[Version (since = "3.32")]
		public abstract unowned GLib.InputStream get_stderr_pipe ();
		[Version (since = "3.32")]
		public abstract unowned GLib.OutputStream get_stdin_pipe ();
		[Version (since = "3.32")]
		public abstract unowned GLib.InputStream get_stdout_pipe ();
		public abstract bool get_successful ();
		public abstract int get_term_sig ();
		public abstract void send_signal (int signal_num);
		public abstract bool wait (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool wait_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool wait_check (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool wait_check_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeSymbolResolverInterface", type_id = "ide_symbol_resolver_get_type ()")]
	public interface SymbolResolver : Ide.Object {
		[Version (since = "3.32")]
		public abstract async Ide.Symbol? find_nearest_scope_async (Ide.Location location, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async GLib.GenericArray<Ide.Range> find_references_async (Ide.Location location, string? language_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract async Ide.SymbolTree? get_symbol_tree_async (GLib.File file, GLib.Bytes? contents, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void load ();
		[Version (since = "3.32")]
		public abstract async Ide.Symbol? lookup_symbol_async (Ide.Location location, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unload ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeSymbolTreeInterface", type_id = "ide_symbol_tree_get_type ()")]
	public interface SymbolTree : GLib.Object {
		[Version (since = "3.32")]
		public abstract uint get_n_children (Ide.SymbolNode? node);
		[Version (since = "3.32")]
		public abstract Ide.SymbolNode? get_nth_child (Ide.SymbolNode? node, uint nth);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeTemplateProviderInterface", type_id = "ide_template_provider_get_type ()")]
	public interface TemplateProvider : GLib.Object {
		[Version (since = "3.32")]
		public abstract GLib.List<Ide.ProjectTemplate> get_project_templates ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeToolchainProviderInterface", type_id = "ide_toolchain_provider_get_type ()")]
	public interface ToolchainProvider : Ide.Object {
		[Version (since = "3.32")]
		public void emit_added (Ide.Toolchain toolchain);
		[Version (since = "3.32")]
		public void emit_removed (Ide.Toolchain toolchain);
		[Version (since = "3.32")]
		public abstract async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unload (Ide.ToolchainManager manager);
		public virtual signal void added (Ide.Toolchain toolchain);
		public virtual signal void removed (Ide.Toolchain toolchain);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeTreeAddinInterface", type_id = "ide_tree_addin_get_type ()")]
	public interface TreeAddin : GLib.Object {
		[NoWrapper]
		public abstract void build_children (Ide.TreeNode node);
		[Version (since = "3.32")]
		public abstract async bool build_children_async (Ide.TreeNode node, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract void build_node (Ide.TreeNode node);
		public abstract void cell_data_func (Ide.TreeNode node, Gtk.CellRenderer cell);
		public abstract void load (Ide.Tree tree, Ide.TreeModel model);
		public abstract bool node_activated (Ide.Tree tree, Ide.TreeNode node);
		public abstract void node_collapsed (Ide.TreeNode node);
		public abstract bool node_draggable (Ide.TreeNode node);
		public abstract bool node_droppable (Ide.TreeNode drag_node, Ide.TreeNode drop_node, Gtk.SelectionData selection);
		public abstract async bool node_dropped_async (Ide.TreeNode drag_node, Ide.TreeNode drop_node, Gtk.SelectionData selection, Gdk.DragAction actions, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void node_expanded (Ide.TreeNode node);
		public abstract void selection_changed (Ide.TreeNode selection);
		public abstract void unload (Ide.Tree tree, Ide.TreeModel model);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeVcsInterface", type_id = "ide_vcs_get_type ()")]
	public interface Vcs : Ide.Object {
		public void emit_changed ();
		[Version (since = "3.32")]
		public static unowned Ide.Vcs from_context (Ide.Context context);
		[Version (since = "3.32")]
		public abstract string get_branch_name ();
		[Version (since = "3.32")]
		public abstract Ide.VcsConfig? get_config ();
		public abstract int get_priority ();
		[Version (since = "3.32")]
		public abstract unowned GLib.File get_workdir ();
		[Version (since = "3.32")]
		public abstract bool is_ignored (GLib.File? file) throws GLib.Error;
		public abstract async GLib.GenericArray<Ide.VcsBranch> list_branches_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract async GLib.ListModel? list_status_async (GLib.File directory_or_file, bool include_descendants, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async GLib.GenericArray<Ide.VcsBranch> list_tags_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public bool path_is_ignored (string? path) throws GLib.Error;
		public abstract async bool push_branch_async (Ide.VcsBranch branch, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public static Ide.Vcs ref_from_context (Ide.Context context);
		public abstract async bool switch_branch_async (Ide.VcsBranch branch, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract string branch_name { owned get; }
		public abstract GLib.File workdir { get; }
		[Version (since = "3.32")]
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeVcsBranchInterface", type_id = "ide_vcs_branch_get_type ()")]
	public interface VcsBranch : GLib.Object {
		[Version (since = "3.34")]
		public abstract string get_id ();
		[Version (since = "3.32")]
		public abstract string get_name ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeVcsClonerInterface", type_id = "ide_vcs_cloner_get_type ()")]
	public interface VcsCloner : Ide.Object {
		[Version (since = "3.32")]
		public abstract async bool clone_async (string uri, string destination, GLib.Variant options, Ide.Notification? progress, GLib.Cancellable? cancellable) throws GLib.Error;
		public static bool clone_simple (Ide.Context context, string module_name, string url, string branch, string destination, Ide.Notification notif, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract string get_title ();
		[Version (since = "3.32")]
		public abstract bool validate_uri (string uri, out string errmsg);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeVcsConfigInterface", type_id = "ide_vcs_config_get_type ()")]
	public interface VcsConfig : Ide.Object {
		public abstract void get_config (Ide.VcsConfigType type, GLib.Value value);
		public abstract void set_config (Ide.VcsConfigType type, GLib.Value value);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeVcsInitializerInterface", type_id = "ide_vcs_initializer_get_type ()")]
	public interface VcsInitializer : Ide.Object {
		public abstract string get_title ();
		public abstract async bool initialize_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeVcsTagInterface", type_id = "ide_vcs_tag_get_type ()")]
	public interface VcsTag : GLib.Object {
		[Version (since = "3.32")]
		public abstract string get_name ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeWorkbenchAddinInterface", type_id = "ide_workbench_addin_get_type ()")]
	public interface WorkbenchAddin : GLib.Object {
		public abstract bool can_open (GLib.File file, string content_type, int priority);
		public abstract void load (Ide.Workbench workbench);
		public abstract async bool load_project_async (Ide.ProjectInfo project_info, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async bool open_async (GLib.File file, string content_type, Ide.BufferOpenFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void open_at_async (GLib.File file, string content_type, int at_line, int at_line_offset, Ide.BufferOpenFlags flags, GLib.Cancellable? cancellable);
		[Version (since = "3.32")]
		public abstract void project_loaded (Ide.ProjectInfo project_info);
		public abstract void unload (Ide.Workbench workbench);
		public abstract async bool unload_project_async (Ide.ProjectInfo project_info, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.32")]
		public abstract void vcs_changed (Ide.Vcs? vcs);
		public abstract void workspace_added (Ide.Workspace workspace);
		public abstract void workspace_removed (Ide.Workspace workspace);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeWorkerInterface", type_id = "ide_worker_get_type ()")]
	public interface Worker : GLib.Object {
		[Version (since = "3.32")]
		public abstract GLib.DBusProxy create_proxy (GLib.DBusConnection connection) throws GLib.Error;
		public abstract void register_service (GLib.DBusConnection connection);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", type_cname = "IdeWorkspaceAddinInterface", type_id = "ide_workspace_addin_get_type ()")]
	public interface WorkspaceAddin : GLib.Object {
		[Version (since = "3.34")]
		public abstract bool can_close ();
		[Version (since = "3.32")]
		public abstract void load (Ide.Workspace workspace);
		[Version (since = "3.32")]
		public abstract void surface_set (Ide.Surface? surface);
		[Version (since = "3.32")]
		public abstract void unload (Ide.Workspace workspace);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[SimpleType]
	public struct DebuggerAddress : uint64 {
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	public struct LineReader {
		public weak string contents;
		public size_t length;
		public ssize_t pos;
		public void init (string contents, ssize_t length);
		[Version (since = "3.32")]
		public unowned string next (size_t length);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[SimpleType]
	public struct PtyFd : int {
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	public struct PtyIntercept {
		public size_t magic;
		public Ide.PtyInterceptSide master;
		public Ide.PtyInterceptSide slave;
		[Version (since = "3.32")]
		public void clear ();
		[Version (since = "3.32")]
		public static Ide.PtyFd create_master ();
		[Version (since = "3.32")]
		public static Ide.PtyFd create_slave (Ide.PtyFd master_fd, bool blocking);
		[Version (since = "3.32")]
		public Ide.PtyFd get_fd ();
		[Version (since = "3.32")]
		public bool init (Ide.PtyFd fd, GLib.MainContext? main_context);
		[Version (since = "3.32")]
		public void set_callback (Ide.PtyInterceptSide side, Ide.PtyInterceptCallback callback);
		[Version (since = "3.32")]
		public bool set_size (uint rows, uint columns);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	public struct PtyInterceptSide {
		public weak GLib.IOChannel channel;
		public uint in_watch;
		public uint out_watch;
		public int read_prio;
		public int write_prio;
		public weak GLib.Bytes out_bytes;
		public weak Ide.PtyInterceptCallback callback;
		public void* callback_data;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	public struct SearchReducer {
		public weak GLib.Sequence sequence;
		public size_t max_results;
		public size_t count;
		[Version (since = "3.32")]
		public bool accepts (float score);
		[Version (since = "3.32")]
		public void destroy ();
		[Version (since = "3.32")]
		public GLib.GenericArray<weak Ide.SearchResult>? free (bool free_results);
		[Version (since = "3.32")]
		public static void init (out Ide.SearchReducer reducer, size_t max_results);
		[Version (since = "3.32")]
		public void push (Ide.SearchResult result);
		[Version (since = "3.32")]
		public void take (owned Ide.SearchResult result);
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_type_id = false)]
	public struct SnippetInfo {
		public weak string lang;
		public weak string name;
		public weak string desc;
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_ARTIFACT_KIND_", has_type_id = false)]
	public enum ArtifactKind {
		NONE,
		EXECUTABLE,
		SHARED_LIBRARY,
		STATIC_LIBRARY,
		FILE
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_BUFFER_LINE_CHANGE_", has_type_id = false)]
	[Flags]
	public enum BufferLineChange {
		NONE,
		ADDED,
		CHANGED,
		DELETED,
		PREVIOUS_DELETED
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_BUFFER_OPEN_FLAGS_", type_id = "ide_buffer_open_flags_get_type ()")]
	[Flags]
	[Version (since = "3.32")]
	public enum BufferOpenFlags {
		NONE,
		BACKGROUND,
		NO_VIEW,
		FORCE_RELOAD
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_BUFFER_STATE_", type_id = "ide_buffer_state_get_type ()")]
	public enum BufferState {
		READY,
		LOADING,
		SAVING,
		FAILED
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_BUILD_LOCALITY_", type_id = "ide_build_locality_get_type ()")]
	[Flags]
	public enum BuildLocality {
		IN_TREE,
		OUT_OF_TREE,
		DEFAULT
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_BUILD_LOG_", type_id = "ide_build_log_stream_get_type ()")]
	public enum BuildLogStream {
		STDOUT,
		STDERR
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_COMPLETION_", type_id = "ide_completion_activation_get_type ()")]
	public enum CompletionActivation {
		INTERACTIVE,
		USER_REQUESTED,
		TRIGGERED
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_COMPLETION_COLUMN_", type_id = "ide_completion_column_get_type ()")]
	public enum CompletionColumn {
		ICON,
		LEFT_OF,
		TYPED_TEXT,
		RIGHT_OF
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_CURSOR_", type_id = "ide_cursor_type_get_type ()")]
	public enum CursorType {
		COLUMN,
		SELECT,
		MATCH
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DEBUGGER_BREAK_", type_id = "ide_debugger_break_mode_get_type ()")]
	[Version (since = "3.32")]
	public enum DebuggerBreakMode {
		NONE,
		BREAKPOINT,
		COUNTPOINT,
		WATCHPOINT
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DEBUGGER_BREAKPOINT_CHANGE_", type_id = "ide_debugger_breakpoint_change_get_type ()")]
	[Version (since = "3.32")]
	public enum DebuggerBreakpointChange {
		ENABLED
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DEBUGGER_DISPOSITION_", type_id = "ide_debugger_disposition_get_type ()")]
	[Version (since = "3.32")]
	public enum DebuggerDisposition {
		KEEP,
		DISABLE,
		DELETE_NEXT_HIT,
		DELETE_NEXT_STOP
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DEBUGGER_MOVEMENT_", type_id = "ide_debugger_movement_get_type ()")]
	[Version (since = "3.32")]
	public enum DebuggerMovement {
		START,
		CONTINUE,
		STEP_IN,
		STEP_OUT,
		FINISH
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DEBUGGER_STOP_", type_id = "ide_debugger_stop_reason_get_type ()")]
	[Version (since = "3.32")]
	public enum DebuggerStopReason {
		BREAKPOINT_HIT,
		CATCH,
		[CCode (cname = "IDE_DEBUGGER_STOP_EXITED")]
		STOP_EXITED,
		EXITED_NORMALLY,
		EXITED_SIGNALED,
		FUNCTION_FINISHED,
		LOCATION_REACHED,
		SIGNAL_RECEIVED,
		UNKNOWN
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DEBUGGER_", type_id = "ide_debugger_stream_get_type ()")]
	[Version (since = "3.32")]
	public enum DebuggerStream {
		CONSOLE,
		[CCode (cname = "IDE_DEBUGGER_EVENT_LOG")]
		LOG,
		TARGET
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DEVICE_KIND_", type_id = "ide_device_kind_get_type ()")]
	public enum DeviceKind {
		COMPUTER,
		PHONE,
		TABLET,
		MICRO_CONTROLLER
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DIAGNOSTIC_", type_id = "ide_diagnostic_severity_get_type ()")]
	public enum DiagnosticSeverity {
		IGNORED,
		NOTE,
		DEPRECATED,
		WARNING,
		ERROR,
		FATAL;
		[Version (since = "3.32")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DOAP_ERROR_INVALID_", has_type_id = false)]
	public enum DoapError {
		[CCode (cname = "IDE_DOAP_ERROR_INVALID_FORMAT")]
		DOAP_ERROR_INVALID_FORMAT
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_EDITOR_SEARCH_", type_id = "ide_editor_search_direction_get_type ()")]
	public enum EditorSearchDirection {
		FORWARD,
		NEXT,
		PREVIOUS,
		BACKWARD
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_EDITOR_SEARCH_SELECT_", type_id = "ide_editor_search_select_get_type ()")]
	public enum EditorSearchSelect {
		NONE,
		WITH_RESULT,
		TO_RESULT
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_HIGHLIGHT_", has_type_id = false)]
	public enum HighlightResult {
		STOP,
		CONTINUE
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_INDENT_STYLE_", type_id = "ide_indent_style_get_type ()")]
	public enum IndentStyle {
		SPACES,
		TABS
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_LSP_COMPLETION_", has_type_id = false)]
	public enum LspCompletionKind {
		TEXT,
		METHOD,
		FUNCTION,
		CONSTRUCTOR,
		FIELD,
		VARIABLE,
		CLASS,
		INTERFACE,
		MODULE,
		PROPERTY,
		UNIT,
		VALUE,
		ENUM,
		KEYWORD,
		SNIPPET,
		COLOR,
		FILE,
		REFERENCE,
		FOLDER,
		ENUM_MEMBER,
		CONSTANT,
		STRUCT,
		EVENT,
		OPERATOR,
		TYPE_PARAMETER
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_MARKED_KIND_", has_type_id = false)]
	public enum MarkedKind {
		PLAINTEXT,
		MARKDOWN,
		HTML,
		PANGO
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_OBJECT_", has_type_id = false)]
	public enum ObjectLocation {
		START,
		END,
		BEFORE_SIBLING,
		AFTER_SIBLING
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_PIPELINE_PHASE_", type_id = "ide_pipeline_phase_get_type ()")]
	[Flags]
	public enum PipelinePhase {
		NONE,
		PREPARE,
		DOWNLOADS,
		DEPENDENCIES,
		AUTOGEN,
		CONFIGURE,
		BUILD,
		INSTALL,
		COMMIT,
		EXPORT,
		FINAL,
		BEFORE,
		AFTER,
		FINISHED,
		FAILED
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_PROCESS_KIND_", has_type_id = false)]
	public enum ProcessKind {
		HOST,
		FLATPAK
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_SOURCE_SCROLL_", type_id = "ide_source_scroll_align_get_type ()")]
	[Flags]
	public enum SourceScrollAlign {
		NONE,
		BOTH,
		X,
		Y
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_SOURCE_VIEW_MODE_TYPE_", type_id = "ide_source_view_mode_type_get_type ()")]
	[Version (since = "3.32")]
	public enum SourceViewModeType {
		TRANSIENT,
		PERMANENT,
		MODAL
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_SOURCE_VIEW_MOVEMENT_", type_id = "ide_source_view_movement_get_type ()")]
	[Version (since = "3.32")]
	public enum SourceViewMovement {
		PREVIOUS_OFFSET,
		NEXT_OFFSET,
		NTH_CHAR,
		PREVIOUS_CHAR,
		NEXT_CHAR,
		FIRST_CHAR,
		FIRST_NONSPACE_CHAR,
		MIDDLE_CHAR,
		LAST_CHAR,
		NEXT_WORD_START,
		NEXT_FULL_WORD_START,
		NEXT_SUB_WORD_START,
		PREVIOUS_SUB_WORD_START,
		PREVIOUS_WORD_START,
		PREVIOUS_FULL_WORD_START,
		PREVIOUS_WORD_END,
		PREVIOUS_FULL_WORD_END,
		NEXT_WORD_END,
		NEXT_FULL_WORD_END,
		NEXT_WORD_START_NEWLINE_STOP,
		NEXT_FULL_WORD_START_NEWLINE_STOP,
		PREVIOUS_WORD_START_NEWLINE_STOP,
		PREVIOUS_FULL_WORD_START_NEWLINE_STOP,
		PREVIOUS_WORD_END_NEWLINE_STOP,
		PREVIOUS_FULL_WORD_END_NEWLINE_STOP,
		NEXT_WORD_END_NEWLINE_STOP,
		NEXT_FULL_WORD_END_NEWLINE_STOP,
		SENTENCE_START,
		SENTENCE_END,
		PARAGRAPH_START,
		PARAGRAPH_END,
		PREVIOUS_LINE,
		NEXT_LINE,
		FIRST_LINE,
		NTH_LINE,
		LAST_LINE,
		LINE_PERCENTAGE,
		LINE_CHARS,
		LINE_END,
		HALF_PAGE_UP,
		HALF_PAGE_DOWN,
		HALF_PAGE_LEFT,
		HALF_PAGE_RIGHT,
		PAGE_UP,
		PAGE_UP_LINES,
		PAGE_DOWN,
		PAGE_DOWN_LINES,
		SCREEN_UP,
		SCREEN_DOWN,
		SCREEN_LEFT,
		SCREEN_RIGHT,
		SCREEN_TOP,
		SCREEN_MIDDLE,
		SCREEN_BOTTOM,
		MATCH_SPECIAL,
		SCROLL_SCREEN_TOP,
		SCROLL_SCREEN_CENTER,
		SCROLL_SCREEN_BOTTOM,
		SCROLL_SCREEN_LEFT,
		SCROLL_SCREEN_RIGHT,
		PREVIOUS_UNMATCHED_BRACE,
		NEXT_UNMATCHED_BRACE,
		PREVIOUS_UNMATCHED_PAREN,
		NEXT_UNMATCHED_PAREN,
		NEXT_MATCH_MODIFIER,
		PREVIOUS_MATCH_MODIFIER,
		NEXT_MATCH_SEARCH_CHAR,
		PREVIOUS_MATCH_SEARCH_CHAR,
		SMART_HOME
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_SOURCE_VIEW_THEATRIC_", type_id = "ide_source_view_theatric_get_type ()")]
	[Version (since = "3.32")]
	public enum SourceViewTheatric {
		EXPAND,
		SHRINK
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_SPACES_STYLE_", type_id = "ide_spaces_style_get_type ()")]
	[Flags]
	public enum SpacesStyle {
		IGNORE,
		BEFORE_LEFT_PAREN,
		BEFORE_LEFT_BRACKET,
		BEFORE_LEFT_BRACE,
		BEFORE_LEFT_ANGLE,
		BEFORE_COLON,
		BEFORE_COMMA,
		BEFORE_SEMICOLON
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_SYMBOL_FLAGS_", type_id = "ide_symbol_flags_get_type ()")]
	[Flags]
	public enum SymbolFlags {
		NONE,
		IS_STATIC,
		IS_MEMBER,
		IS_DEPRECATED,
		IS_DEFINITION
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_SYMBOL_KIND_", type_id = "ide_symbol_kind_get_type ()")]
	public enum SymbolKind {
		NONE,
		ALIAS,
		ARRAY,
		BOOLEAN,
		CLASS,
		CONSTANT,
		CONSTRUCTOR,
		ENUM,
		ENUM_VALUE,
		FIELD,
		FILE,
		FUNCTION,
		HEADER,
		INTERFACE,
		MACRO,
		METHOD,
		MODULE,
		NAMESPACE,
		NUMBER,
		PACKAGE,
		PROPERTY,
		SCALAR,
		STRING,
		STRUCT,
		TEMPLATE,
		UNION,
		VARIABLE,
		KEYWORD,
		UI_ATTRIBUTES,
		UI_CHILD,
		UI_ITEM,
		UI_MENU,
		UI_MENU_ATTRIBUTE,
		UI_OBJECT,
		UI_PACKING,
		UI_PROPERTY,
		UI_SECTION,
		UI_SIGNAL,
		UI_STYLE,
		UI_STYLE_CLASS,
		UI_SUBMENU,
		UI_TEMPLATE,
		XML_ATTRIBUTE,
		XML_DECLARATION,
		XML_ELEMENT,
		XML_COMMENT,
		XML_CDATA;
		public unowned string get_icon_name ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_TASK_KIND_", has_type_id = false)]
	public enum TaskKind {
		DEFAULT,
		COMPILER,
		INDEXER,
		IO,
		LAST
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_TEST_STATUS_", type_id = "ide_test_status_get_type ()")]
	public enum TestStatus {
		NONE,
		RUNNING,
		SUCCESS,
		FAILED
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_THREAD_POOL_", has_type_id = false)]
	public enum ThreadPoolKind {
		DEFAULT,
		COMPILER,
		INDEXER,
		IO,
		LAST
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_TRANSFER_ERROR_", has_type_id = false)]
	public enum TransferError {
		UNKNOWN,
		CONNECTION_IS_METERED
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_TREE_NODE_FLAGS_", has_type_id = false)]
	[Flags]
	public enum TreeNodeFlags {
		NONE,
		DESCENDANT,
		ADDED,
		CHANGED,
		REMOVED
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_TREE_NODE_VISIT_", has_type_id = false)]
	public enum TreeNodeVisit {
		BREAK,
		CONTINUE,
		CHILDREN
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_VCS_CONFIG_", type_id = "ide_vcs_config_type_get_type ()")]
	public enum VcsConfigType {
		FULL_NAME,
		EMAIL
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_VCS_FILE_STATUS_", type_id = "ide_vcs_file_status_get_type ()")]
	public enum VcsFileStatus {
		IGNORED,
		UNCHANGED,
		UNTRACKED,
		ADDED,
		RENAMED,
		DELETED,
		CHANGED
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_BUILD_ERROR_")]
	public errordomain BuildError {
		UNKNOWN,
		BROKEN,
		NOT_LOADED,
		NEEDS_REBUILD;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_DEVICE_ERROR_NO_SUCH_")]
	public errordomain DeviceError {
		DEVICE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cprefix = "IDE_RUNTIME_ERROR_")]
	public errordomain RuntimeError {
		UNKNOWN,
		NO_SUCH_RUNTIME,
		BUILD_FAILED,
		TARGET_NOT_FOUND,
		SPAWN_FAILED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 2.9)]
	public delegate void BufferChangeMonitorForeachFunc (uint line, Ide.BufferLineChange change);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 1.9)]
	[Version (since = "3.32")]
	public delegate void BufferForeachFunc (Ide.Buffer buffer);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 3.9)]
	public delegate void BuildLogObserver (Ide.BuildLogStream log_stream, string message, ssize_t message_len);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 2.9)]
	[Version (since = "3.32")]
	public delegate void DiagnosticsLineCallback (uint line, Ide.DiagnosticSeverity severity);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 3.9)]
	public delegate void ExtensionSetAdapterForeachFunc (Ide.ExtensionSetAdapter @set, Peas.PluginInfo plugin_info, Peas.Extension extension);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 2.9)]
	public delegate void FileWalkCallback (GLib.File directory, GLib.GenericArray<GLib.FileInfo> file_infos);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_target = false)]
	public delegate Ide.HighlightResult HighlightCallback (Gtk.TextIter begin, Gtk.TextIter end, string style_name);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 4.9)]
	public delegate void PtyInterceptCallback (Ide.PtyIntercept intercept, Ide.PtyInterceptSide side, uint8 data, size_t len);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 2.9)]
	public delegate void RunHandler (Ide.RunManager self, Ide.Runner runner);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 2.9)]
	public delegate void SnippetStorageForeach (Ide.SnippetStorage self, Ide.SnippetInfo info);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_target = false)]
	public delegate void TaskThreadFunc (Ide.Task task, void* source_object, void* task_data, GLib.Cancellable? cancellable = null);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 2.9)]
	public delegate bool TextIterCharPredicate (Gtk.TextIter iter, unichar ch);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 0.9)]
	[Version (since = "3.32")]
	public delegate void ThreadFunc ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_target = false)]
	[Version (since = "3.32")]
	public delegate int TreeNodeCompare (Ide.TreeNode node, Ide.TreeNode child);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", instance_pos = 1.9)]
	[Version (since = "3.32")]
	public delegate Ide.TreeNodeVisit TreeTraverseFunc (Ide.TreeNode node);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", has_target = false)]
	public delegate void WidgetContextHandler (Gtk.Widget widget, Ide.Context context);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_BUILD_CHANNEL")]
	public const string BUILD_CHANNEL;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_BUILD_IDENTIFIER")]
	public const string BUILD_IDENTIFIER;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_BUILD_TYPE")]
	public const string BUILD_TYPE;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_DEBUGGER_ADDRESS_INVALID")]
	public const int DEBUGGER_ADDRESS_INVALID;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_ENABLE_TRACE")]
	public const int ENABLE_TRACE;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_FILE_SETTINGS_EXTENSION_POINT")]
	public const string FILE_SETTINGS_EXTENSION_POINT;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_LSP_COMPLETION_PROVIDER_PRIORITY")]
	public const int LSP_COMPLETION_PROVIDER_PRIORITY;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_PIPELINE_PHASE_MASK")]
	public const int PIPELINE_PHASE_MASK;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_PIPELINE_PHASE_WHENCE_MASK")]
	public const int PIPELINE_PHASE_WHENCE_MASK;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_PTY_FD_INVALID")]
	public const int PTY_FD_INVALID;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_PTY_INTERCEPT_MAGIC")]
	public const int PTY_INTERCEPT_MAGIC;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_RECENT_PROJECTS_BOOKMARK_FILENAME")]
	public const string RECENT_PROJECTS_BOOKMARK_FILENAME;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_RECENT_PROJECTS_BUILD_SYSTEM_GROUP_PREFIX")]
	public const string RECENT_PROJECTS_BUILD_SYSTEM_GROUP_PREFIX;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_RECENT_PROJECTS_BUILD_SYSTEM_HINT_GROUP_PREFIX")]
	public const string RECENT_PROJECTS_BUILD_SYSTEM_HINT_GROUP_PREFIX;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_RECENT_PROJECTS_DIRECTORY")]
	public const string RECENT_PROJECTS_DIRECTORY;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_RECENT_PROJECTS_GROUP")]
	public const string RECENT_PROJECTS_GROUP;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_RECENT_PROJECTS_LANGUAGE_GROUP_PREFIX")]
	public const string RECENT_PROJECTS_LANGUAGE_GROUP_PREFIX;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_LANGUAGE_ANY")]
	public const string TOOLCHAIN_LANGUAGE_ANY;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_LANGUAGE_C")]
	public const string TOOLCHAIN_LANGUAGE_C;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_LANGUAGE_CPLUSPLUS")]
	public const string TOOLCHAIN_LANGUAGE_CPLUSPLUS;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_LANGUAGE_D")]
	public const string TOOLCHAIN_LANGUAGE_D;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_LANGUAGE_FORTRAN")]
	public const string TOOLCHAIN_LANGUAGE_FORTRAN;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_LANGUAGE_PYTHON")]
	public const string TOOLCHAIN_LANGUAGE_PYTHON;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_LANGUAGE_VALA")]
	public const string TOOLCHAIN_LANGUAGE_VALA;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_TOOL_AR")]
	public const string TOOLCHAIN_TOOL_AR;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_TOOL_CC")]
	public const string TOOLCHAIN_TOOL_CC;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_TOOL_CPP")]
	public const string TOOLCHAIN_TOOL_CPP;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_TOOL_EXEC")]
	public const string TOOLCHAIN_TOOL_EXEC;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_TOOL_LD")]
	public const string TOOLCHAIN_TOOL_LD;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_TOOL_PKG_CONFIG")]
	public const string TOOLCHAIN_TOOL_PKG_CONFIG;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_TOOLCHAIN_TOOL_STRIP")]
	public const string TOOLCHAIN_TOOL_STRIP;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h", cname = "IDE_VERSION_S")]
	public const string VERSION_S;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static unowned Ide.BuildSystem? build_system_from_context (Ide.Context context);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static GLib.Resource code_get_resource ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static string create_host_triplet (string arch, string kernel, string system);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static string create_project_id (string name);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static unowned Ide.EditorAddin? editor_addin_find_by_module_name (Ide.EditorSurface editor, string module_name);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static GLib.Resource editor_get_resource ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool environ_parse (string pair, out string key, out string value);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.34")]
	public static string? find_program_in_host_path (string program);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static GLib.Icon? g_content_type_get_symbolic_icon (string content_type);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static void g_file_add_ignored_pattern (string pattern);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static async GLib.GenericArray<GLib.File> g_file_find_async (GLib.File file, string pattern, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static async GLib.File g_file_find_in_ancestors_async (GLib.File directory, string name, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static GLib.GenericArray<GLib.File> g_file_find_with_depth (GLib.File file, string pattern, uint max_depth, GLib.Cancellable? cancellable = null);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static async void g_file_find_with_depth_async (GLib.File file, string pattern, uint max_depth, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static async GLib.GenericArray<GLib.FileInfo> g_file_get_children_async (GLib.File file, string attributes, GLib.FileQueryInfoFlags flags, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static string? g_file_get_uncanonical_relative_path (GLib.File file, GLib.File other);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool g_file_is_ignored (GLib.File file);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static void g_file_walk (GLib.File directory, string attributes, GLib.Cancellable? cancellable, Ide.FileWalkCallback callback);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.34")]
	public static void g_file_walk_with_ignore (GLib.File directory, string attributes, string? ignore_file, GLib.Cancellable? cancellable, Ide.FileWalkCallback callback);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool g_host_file_get_contents (string path, out string contents, out size_t len) throws GLib.Error;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static unowned string get_application_id ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static unowned GLib.Thread get_main_thread ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static Ide.ProcessKind get_process_kind ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static unowned string get_program_name ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static string get_projects_dir ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static string get_relocatable_path (string path);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static string get_system_arch ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static size_t get_system_page_size ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static unowned string get_system_type ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static unowned string get_user_shell ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static unowned string gettext (string message);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static GLib.Resource greeter_get_resource ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool gtk_show_uri_on_window (Gtk.Window window, string uri, int64 timestamp) throws GLib.Error;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static void gtk_window_present (Gtk.Window window);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static string language_format_header (Gtk.SourceLanguage language, string header);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static int log_get_verbosity ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static void log_increase_verbosity ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static void log_init (bool stdout_, string filename);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static void log_set_verbosity (int level);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static void log_shutdown ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static string path_collapse (string path);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static string path_expand (string path);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool path_is_c_like (string path);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool path_is_cpp_like (string path);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool path_is_ignored (string path);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static void set_application_id (string app_id);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static async void source_search_context_backward_async (Gtk.SourceSearchContext search, Gtk.TextIter iter, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool source_search_context_backward_finish2 (Gtk.SourceSearchContext search, GLib.AsyncResult result, out Gtk.TextIter match_begin, out Gtk.TextIter match_end, out bool has_wrapped_around) throws GLib.Error;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool source_style_scheme_apply_style (Gtk.SourceStyleScheme style_scheme, string style, Gtk.TextTag tag);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static GLib.Resource sourceview_get_resource ();
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_backward_WORD_end (Gtk.TextIter iter, bool newline_stop);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_backward_WORD_start (Gtk.TextIter iter, bool newline_stop);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool text_iter_backward_find_char (Gtk.TextIter iter, [CCode (delegate_target_pos = 2.5)] Ide.TextIterCharPredicate pred, Gtk.TextIter limit);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool text_iter_backward_paragraph_start (Gtk.TextIter iter);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_backward_sentence_start (Gtk.TextIter iter);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_backward_word_end (Gtk.TextIter iter, bool newline_stop);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_backward_word_start (Gtk.TextIter iter, bool newline_stop);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static string text_iter_current_symbol (Gtk.TextIter iter, Gtk.TextIter out_begin);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool text_iter_find_chars_backward (Gtk.TextIter iter, Gtk.TextIter? limit, out unowned Gtk.TextIter? end, string str, bool only_at_start);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool text_iter_find_chars_forward (Gtk.TextIter iter, Gtk.TextIter? limit, out unowned Gtk.TextIter? end, string str, bool only_at_start);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_forward_WORD_end (Gtk.TextIter iter, bool newline_stop);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_forward_WORD_start (Gtk.TextIter iter, bool newline_stop);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool text_iter_forward_find_char (Gtk.TextIter iter, [CCode (delegate_target_pos = 2.5)] Ide.TextIterCharPredicate pred, Gtk.TextIter limit);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool text_iter_forward_paragraph_end (Gtk.TextIter iter);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_forward_sentence_end (Gtk.TextIter iter);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_forward_word_end (Gtk.TextIter iter, bool newline_stop);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool text_iter_forward_word_start (Gtk.TextIter iter, bool newline_stop);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static bool text_iter_in_string (Gtk.TextIter iter, string str, out Gtk.TextIter str_start, out Gtk.TextIter str_end, bool include_str_bounds);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static void text_util_delete_line (Gtk.TextView text_view, int count);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static bool vcs_cloner_clone_simple (Ide.Context context, string module_name, string url, string branch, string destination, Ide.Notification notif, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static unowned Ide.Vcs vcs_from_context (Ide.Context context);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static Ide.Vcs vcs_ref_from_context (Ide.Context context);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static int vte_pty_create_slave (Vte.Pty pty);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static unowned Ide.Context? widget_get_context (Gtk.Widget widget);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static unowned Ide.Workbench? widget_get_workbench (Gtk.Widget widget);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static unowned Ide.Workspace? widget_get_workspace (Gtk.Widget widget);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	public static void widget_reveal_and_grab (Gtk.Widget widget);
	[CCode (cheader_filename = "libide-code.h,libide-core.h,libide-debugger.h,libide-editor.h,libide-foundry.h,libide-greeter.h,libide-gui.h,libide-io.h,libide-lsp.h,libide-plugins.h,libide-projects.h,libide-search.h,libide-sourceview.h,libide-terminal.h,libide-threading.h,libide-tree.h,libide-vcs.h")]
	[Version (since = "3.32")]
	public static void widget_set_context_handler (Gtk.Widget widget, [CCode (scope = "async")] Ide.WidgetContextHandler handler);
}
