(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/43#nonneg-int?
    (lambda (_x80670_)
      (if (integer? _x80670_) (not (negative? _x80670_)) '#f)))
  (define std/srfi/43#between?
    (lambda (_x80666_ _y80667_ _z80668_)
      (if (< _x80666_ _y80667_) (<= _y80667_ _z80668_) '#f)))
  (define std/srfi/43#unspecified-value (lambda () (if '#f '#f '#!void)))
  (define std/srfi/43#vectors-ref
    (lambda (_vectors80660_ _i80661_)
      (map (lambda (_v80663_) (vector-ref _v80663_ _i80661_)) _vectors80660_)))
  (define std/srfi/43#check-type
    (lambda (_pred?80656_ _value80657_ _callee80658_)
      (if (_pred?80656_ _value80657_)
          _value80657_
          (std/srfi/43#check-type
           _pred?80656_
           (error '"erroneous value"
                  (list _pred?80656_ _value80657_)
                  (cons 'while (cons 'calling (cons _callee80658_ '()))))
           _callee80658_))))
  (define std/srfi/43#check-index
    (lambda (_vec80650_ _index80651_ _callee80652_)
      (let ((_index80654_
             (std/srfi/43#check-type integer? _index80651_ _callee80652_)))
        (if (< _index80654_ '0)
            (std/srfi/43#check-index
             _vec80650_
             (error '"vector index too low"
                    _index80654_
                    (cons 'into (cons 'vector (cons _vec80650_ '())))
                    (cons 'while (cons 'calling (cons _callee80652_ '()))))
             _callee80652_)
            (if (>= _index80654_ (vector-length _vec80650_))
                (std/srfi/43#check-index
                 _vec80650_
                 (error '"vector index too high"
                        _index80654_
                        (cons 'into (cons 'vector (cons _vec80650_ '())))
                        (cons 'while (cons 'calling (cons _callee80652_ '()))))
                 _callee80652_)
                _index80654_)))))
  (define std/srfi/43#check-indices
    (lambda (_vec80634_
             _start80635_
             _start-name80636_
             _end80637_
             _end-name80638_
             _callee80639_)
      (let ((_lose80643_
             (lambda _things80641_
               (apply error
                      '"vector range out of bounds"
                      (append _things80641_
                              (cons 'vector (cons 'was (cons _vec80634_ '())))
                              (cons _start-name80636_
                                    (cons 'was (cons _start80635_ '())))
                              (cons _end-name80638_
                                    (cons 'was (cons _end80637_ '())))
                              (cons 'while
                                    (cons 'calling
                                          (cons _callee80639_ '())))))))
            (_start80644_
             (std/srfi/43#check-type integer? _start80635_ _callee80639_))
            (_end80645_
             (std/srfi/43#check-type integer? _end80637_ _callee80639_)))
        (if (> _start80644_ _end80645_)
            (let ((_g80845_
                   (_lose80643_
                    (cons _end-name80638_
                          (cons '< (cons _start-name80636_ '()))))))
              (begin
                (let ((_g80846_
                       (if (##values? _g80845_) (##vector-length _g80845_) 1)))
                  (if (not (##fx= _g80846_ 2))
                      (error "Context expects 2 values" _g80846_)))
                (let ((_new-start80647_ (##vector-ref _g80845_ 0))
                      (_new-end80648_ (##vector-ref _g80845_ 1)))
                  (std/srfi/43#check-indices
                   _vec80634_
                   _new-start80647_
                   _start-name80636_
                   _new-end80648_
                   _end-name80638_
                   _callee80639_))))
            (if (< _start80644_ '0)
                (std/srfi/43#check-indices
                 _vec80634_
                 (_lose80643_ (cons _start-name80636_ (cons '< (cons '0 '()))))
                 _start-name80636_
                 _end80645_
                 _end-name80638_
                 _callee80639_)
                (if (>= _start80644_ (vector-length _vec80634_))
                    (std/srfi/43#check-indices
                     _vec80634_
                     (_lose80643_
                      (cons _start-name80636_ (cons '> (cons 'len '())))
                      (cons 'len
                            (cons 'was (cons (vector-length _vec80634_) '()))))
                     _start-name80636_
                     _end80645_
                     _end-name80638_
                     _callee80639_)
                    (if (> _end80645_ (vector-length _vec80634_))
                        (std/srfi/43#check-indices
                         _vec80634_
                         _start80644_
                         _start-name80636_
                         (_lose80643_
                          (cons _end-name80638_ (cons '> (cons 'len '())))
                          (cons 'len
                                (cons 'was
                                      (cons (vector-length _vec80634_) '()))))
                         _end-name80638_
                         _callee80639_)
                        (values _start80644_ _end80645_))))))))
  (define std/srfi/43#vector-parse-start+end
    (lambda (_vec80626_
             _args80627_
             _start-name80628_
             _end-name80629_
             _callee80630_)
      (let ((_len80632_ (vector-length _vec80626_)))
        (if (null? _args80627_)
            (values '0 _len80632_)
            (if (null? (cdr _args80627_))
                (std/srfi/43#check-indices
                 _vec80626_
                 (car _args80627_)
                 _start-name80628_
                 _len80632_
                 _end-name80629_
                 _callee80630_)
                (if (null? (cddr _args80627_))
                    (std/srfi/43#check-indices
                     _vec80626_
                     (car _args80627_)
                     _start-name80628_
                     (cadr _args80627_)
                     _end-name80629_
                     _callee80630_)
                    (error '"too many arguments"
                           (cons 'extra
                                 (cons 'args
                                       (cons 'were
                                             (cons (cddr _args80627_) '()))))
                           (cons 'while
                                 (cons 'calling
                                       (cons _callee80630_ '()))))))))))
  (define std/srfi/43#%smallest-length
    (letrec ((_loop80620_
              (lambda (_vector-list80622_ _length80623_ _callee80624_)
                (if (null? _vector-list80622_)
                    _length80623_
                    (_loop80620_
                     (cdr _vector-list80622_)
                     (min (vector-length
                           (std/srfi/43#check-type
                            vector?
                            (car _vector-list80622_)
                            _callee80624_))
                          _length80623_)
                     _callee80624_)))))
      _loop80620_))
  (define std/srfi/43#%vector-copy!
    (letrec ((_loop/l->r80599_
              (lambda (_target80602_
                       _source80603_
                       _send80604_
                       _i80605_
                       _j80606_)
                (if (< _i80605_ _send80604_)
                    (begin
                      (vector-set!
                       _target80602_
                       _j80606_
                       (vector-ref _source80603_ _i80605_))
                      (_loop/l->r80599_
                       _target80602_
                       _source80603_
                       _send80604_
                       (+ _i80605_ '1)
                       (+ _j80606_ '1)))
                    '#!void)))
             (_loop/r->l80600_
              (lambda (_target80608_
                       _source80609_
                       _sstart80610_
                       _i80611_
                       _j80612_)
                (if (>= _i80611_ _sstart80610_)
                    (begin
                      (vector-set!
                       _target80608_
                       _j80612_
                       (vector-ref _source80609_ _i80611_))
                      (_loop/r->l80600_
                       _target80608_
                       _source80609_
                       _sstart80610_
                       (- _i80611_ '1)
                       (- _j80612_ '1)))
                    '#!void))))
      (lambda (_target80614_
               _tstart80615_
               _source80616_
               _sstart80617_
               _send80618_)
        (if (> _sstart80617_ _tstart80615_)
            (_loop/l->r80599_
             _target80614_
             _source80616_
             _send80618_
             _sstart80617_
             _tstart80615_)
            (_loop/r->l80600_
             _target80614_
             _source80616_
             _sstart80617_
             (- _send80618_ '1)
             (+ '-1 _tstart80615_ _send80618_ (- _sstart80617_)))))))
  (define std/srfi/43#%vector-reverse-copy!
    (letrec ((_loop80585_
              (lambda (_target80587_
                       _source80588_
                       _sstart80589_
                       _i80590_
                       _j80591_)
                (if (>= _i80590_ _sstart80589_)
                    (begin
                      (vector-set!
                       _target80587_
                       _j80591_
                       (vector-ref _source80588_ _i80590_))
                      (_loop80585_
                       _target80587_
                       _source80588_
                       _sstart80589_
                       (- _i80590_ '1)
                       (+ _j80591_ '1)))
                    '#!void))))
      (lambda (_target80593_
               _tstart80594_
               _source80595_
               _sstart80596_
               _send80597_)
        (_loop80585_
         _target80593_
         _source80595_
         _sstart80596_
         (- _send80597_ '1)
         _tstart80594_))))
  (define std/srfi/43#%vector-reverse!
    (letrec ((_loop80573_
              (lambda (_vec80575_ _i80576_ _j80577_)
                (if (<= _i80576_ _j80577_)
                    (let ((_v80579_ (vector-ref _vec80575_ _i80576_)))
                      (vector-set!
                       _vec80575_
                       _i80576_
                       (vector-ref _vec80575_ _j80577_))
                      (vector-set! _vec80575_ _j80577_ _v80579_)
                      (_loop80573_ _vec80575_ (+ _i80576_ '1) (- _j80577_ '1)))
                    '#!void))))
      (lambda (_vec80581_ _start80582_ _end80583_)
        (_loop80573_ _vec80581_ _start80582_ (- _end80583_ '1)))))
  (define std/srfi/43#%vector-fold1
    (letrec ((_loop80560_
              (lambda (_kons80562_ _knil80563_ _len80564_ _vec80565_ _i80566_)
                (if (= _i80566_ _len80564_)
                    _knil80563_
                    (_loop80560_
                     _kons80562_
                     (_kons80562_
                      _i80566_
                      _knil80563_
                      (vector-ref _vec80565_ _i80566_))
                     _len80564_
                     _vec80565_
                     (+ _i80566_ '1))))))
      (lambda (_kons80568_ _knil80569_ _len80570_ _vec80571_)
        (_loop80560_ _kons80568_ _knil80569_ _len80570_ _vec80571_ '0))))
  (define std/srfi/43#%vector-fold2+
    (letrec ((_loop80547_
              (lambda (_kons80549_
                       _knil80550_
                       _len80551_
                       _vectors80552_
                       _i80553_)
                (if (= _i80553_ _len80551_)
                    _knil80550_
                    (_loop80547_
                     _kons80549_
                     (apply _kons80549_
                            _i80553_
                            _knil80550_
                            (std/srfi/43#vectors-ref _vectors80552_ _i80553_))
                     _len80551_
                     _vectors80552_
                     (+ _i80553_ '1))))))
      (lambda (_kons80555_ _knil80556_ _len80557_ _vectors80558_)
        (_loop80547_ _kons80555_ _knil80556_ _len80557_ _vectors80558_ '0))))
  (define std/srfi/43#%vector-map1!
    (letrec ((_loop80533_
              (lambda (_f80535_ _target80536_ _vec80537_ _i80538_)
                (if (zero? _i80538_)
                    _target80536_
                    (let ((_j80540_ (- _i80538_ '1)))
                      (vector-set!
                       _target80536_
                       _j80540_
                       (_f80535_ _j80540_ (vector-ref _vec80537_ _j80540_)))
                      (_loop80533_
                       _f80535_
                       _target80536_
                       _vec80537_
                       _j80540_))))))
      (lambda (_f80542_ _target80543_ _vec80544_ _len80545_)
        (_loop80533_ _f80542_ _target80543_ _vec80544_ _len80545_))))
  (define std/srfi/43#%vector-map2+!
    (letrec ((_loop80519_
              (lambda (_f80521_ _target80522_ _vectors80523_ _i80524_)
                (if (zero? _i80524_)
                    _target80522_
                    (let ((_j80526_ (- _i80524_ '1)))
                      (vector-set!
                       _target80522_
                       _j80526_
                       (apply _f80521_
                              _j80526_
                              (std/srfi/43#vectors-ref
                               _vectors80523_
                               _j80526_)))
                      (_loop80519_
                       _f80521_
                       _target80522_
                       _vectors80523_
                       _j80526_))))))
      (lambda (_f80528_ _target80529_ _vectors80530_ _len80531_)
        (_loop80519_ _f80528_ _target80529_ _vectors80530_ _len80531_))))
  (define std/srfi/43#vector-unfold
    (letrec ((_tabulate!80483_
              (lambda (_f80487_ _vec80488_ _i80489_ _len80490_)
                (if (< _i80489_ _len80490_)
                    (begin
                      (vector-set! _vec80488_ _i80489_ (_f80487_ _i80489_))
                      (_tabulate!80483_
                       _f80487_
                       _vec80488_
                       (+ _i80489_ '1)
                       _len80490_))
                    '#!void)))
             (_unfold1!80484_
              (lambda (_f80492_ _vec80493_ _i80494_ _len80495_ _seed80496_)
                (if (< _i80494_ _len80495_)
                    (let ((_g80847_ (_f80492_ _i80494_ _seed80496_)))
                      (begin
                        (let ((_g80848_
                               (if (##values? _g80847_)
                                   (##vector-length _g80847_)
                                   1)))
                          (if (not (##fx= _g80848_ 2))
                              (error "Context expects 2 values" _g80848_)))
                        (let ((_elt80498_ (##vector-ref _g80847_ 0))
                              (_new-seed80499_ (##vector-ref _g80847_ 1)))
                          (begin
                            (vector-set! _vec80493_ _i80494_ _elt80498_)
                            (_unfold1!80484_
                             _f80492_
                             _vec80493_
                             (+ _i80494_ '1)
                             _len80495_
                             _new-seed80499_)))))
                    '#!void)))
             (_unfold2+!80485_
              (lambda (_f80501_ _vec80502_ _i80503_ _len80504_ _seeds80505_)
                (if (< _i80503_ _len80504_)
                    (let ((_g80849_ (apply _f80501_ _i80503_ _seeds80505_)))
                      (begin
                        (let ((_g80850_
                               (if (##values? _g80849_)
                                   (##vector-length _g80849_)
                                   1)))
                          (if (not (##fx>= _g80850_ 1))
                              (error "Context expects at least 1 values"
                                     _g80850_)))
                        (let ((_elt80507_
                               (if (##values? _g80849_)
                                   (##vector-ref _g80849_ 0)
                                   _g80849_))
                              (_new-seeds80508_
                               (if (##values? _g80849_)
                                   (##cdr (##vector->list _g80849_))
                                   '())))
                          (begin
                            (vector-set! _vec80502_ _i80503_ _elt80507_)
                            (_unfold2+!80485_
                             _f80501_
                             _vec80502_
                             (+ _i80503_ '1)
                             _len80504_
                             _new-seeds80508_)))))
                    '#!void))))
      (lambda (_f80510_ _len80511_ . _initial-seeds80512_)
        (let ((_f80514_
               (std/srfi/43#check-type
                procedure?
                _f80510_
                std/srfi/43#vector-unfold))
              (_len80515_
               (std/srfi/43#check-type
                std/srfi/43#nonneg-int?
                _len80511_
                std/srfi/43#vector-unfold)))
          (let ((_vec80517_ (make-vector _len80515_)))
            (if (null? _initial-seeds80512_)
                (_tabulate!80483_ _f80514_ _vec80517_ '0 _len80515_)
                (if (null? (cdr _initial-seeds80512_))
                    (_unfold1!80484_
                     _f80514_
                     _vec80517_
                     '0
                     _len80515_
                     (car _initial-seeds80512_))
                    (_unfold2+!80485_
                     _f80514_
                     _vec80517_
                     '0
                     _len80515_
                     _initial-seeds80512_)))
            _vec80517_)))))
  (define std/srfi/43#vector-unfold-right
    (letrec ((_tabulate!80449_
              (lambda (_f80453_ _vec80454_ _i80455_)
                (if (>= _i80455_ '0)
                    (begin
                      (vector-set! _vec80454_ _i80455_ (_f80453_ _i80455_))
                      (_tabulate!80449_ _f80453_ _vec80454_ (- _i80455_ '1)))
                    '#!void)))
             (_unfold1!80450_
              (lambda (_f80457_ _vec80458_ _i80459_ _seed80460_)
                (if (>= _i80459_ '0)
                    (let ((_g80851_ (_f80457_ _i80459_ _seed80460_)))
                      (begin
                        (let ((_g80852_
                               (if (##values? _g80851_)
                                   (##vector-length _g80851_)
                                   1)))
                          (if (not (##fx= _g80852_ 2))
                              (error "Context expects 2 values" _g80852_)))
                        (let ((_elt80462_ (##vector-ref _g80851_ 0))
                              (_new-seed80463_ (##vector-ref _g80851_ 1)))
                          (begin
                            (vector-set! _vec80458_ _i80459_ _elt80462_)
                            (_unfold1!80450_
                             _f80457_
                             _vec80458_
                             (- _i80459_ '1)
                             _new-seed80463_)))))
                    '#!void)))
             (_unfold2+!80451_
              (lambda (_f80465_ _vec80466_ _i80467_ _seeds80468_)
                (if (>= _i80467_ '0)
                    (let ((_g80853_ (apply _f80465_ _i80467_ _seeds80468_)))
                      (begin
                        (let ((_g80854_
                               (if (##values? _g80853_)
                                   (##vector-length _g80853_)
                                   1)))
                          (if (not (##fx>= _g80854_ 1))
                              (error "Context expects at least 1 values"
                                     _g80854_)))
                        (let ((_elt80470_
                               (if (##values? _g80853_)
                                   (##vector-ref _g80853_ 0)
                                   _g80853_))
                              (_new-seeds80471_
                               (if (##values? _g80853_)
                                   (##cdr (##vector->list _g80853_))
                                   '())))
                          (begin
                            (vector-set! _vec80466_ _i80467_ _elt80470_)
                            (_unfold2+!80451_
                             _f80465_
                             _vec80466_
                             (- _i80467_ '1)
                             _new-seeds80471_)))))
                    '#!void))))
      (lambda (_f80473_ _len80474_ . _initial-seeds80475_)
        (let ((_f80477_
               (std/srfi/43#check-type
                procedure?
                _f80473_
                std/srfi/43#vector-unfold-right))
              (_len80478_
               (std/srfi/43#check-type
                std/srfi/43#nonneg-int?
                _len80474_
                std/srfi/43#vector-unfold-right)))
          (let ((_vec80480_ (make-vector _len80478_))
                (_i80481_ (- _len80478_ '1)))
            (if (null? _initial-seeds80475_)
                (_tabulate!80449_ _f80477_ _vec80480_ _i80481_)
                (if (null? (cdr _initial-seeds80475_))
                    (_unfold1!80450_
                     _f80477_
                     _vec80480_
                     _i80481_
                     (car _initial-seeds80475_))
                    (_unfold2+!80451_
                     _f80477_
                     _vec80480_
                     _i80481_
                     _initial-seeds80475_)))
            _vec80480_)))))
  (define std/srfi/43#vector-copy
    (lambda (_vec80438_ . _args80439_)
      (let* ((_vec80441_
              (std/srfi/43#check-type
               vector?
               _vec80438_
               std/srfi/43#vector-copy))
             (_g80855_
              (std/srfi/43#vector-copy:parse-args _vec80441_ _args80439_)))
        (begin
          (let ((_g80856_
                 (if (##values? _g80855_) (##vector-length _g80855_) 1)))
            (if (not (##fx= _g80856_ 3))
                (error "Context expects 3 values" _g80856_)))
          (let ((_start80443_ (##vector-ref _g80855_ 0))
                (_end80444_ (##vector-ref _g80855_ 1))
                (_fill80445_ (##vector-ref _g80855_ 2)))
            (let ((_new-vector80447_
                   (make-vector (- _end80444_ _start80443_) _fill80445_)))
              (std/srfi/43#%vector-copy!
               _new-vector80447_
               '0
               _vec80441_
               _start80443_
               (if (> _end80444_ (vector-length _vec80441_))
                   (vector-length _vec80441_)
                   _end80444_))
              _new-vector80447_))))))
  (define std/srfi/43#vector-copy:parse-args
    (lambda (_vec80423_ _args80424_)
      (letrec ((_parse-args80426_
                (lambda (_start80430_ _end80431_ _n80432_ _fill80433_)
                  (let ((_start80435_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _start80430_
                          std/srfi/43#vector-copy))
                        (_end80436_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _end80431_
                          std/srfi/43#vector-copy)))
                    (if (and (<= '0 _start80435_ _end80436_)
                             (<= _start80435_ _n80432_))
                        (values _start80435_ _end80436_ _fill80433_)
                        (error '"illegal arguments"
                               (cons 'while
                                     (cons 'calling
                                           (cons std/srfi/43#vector-copy '())))
                               (cons 'start
                                     (cons 'was (cons _start80435_ '())))
                               (cons 'end (cons 'was (cons _end80436_ '())))
                               (cons 'vector
                                     (cons 'was (cons _vec80423_ '())))))))))
        (let ((_n80428_ (vector-length _vec80423_)))
          (if (null? _args80424_)
              (_parse-args80426_
               '0
               _n80428_
               _n80428_
               (std/srfi/43#unspecified-value))
              (if (null? (cdr _args80424_))
                  (_parse-args80426_
                   (car _args80424_)
                   _n80428_
                   _n80428_
                   (std/srfi/43#unspecified-value))
                  (if (null? (cddr _args80424_))
                      (_parse-args80426_
                       (car _args80424_)
                       (cadr _args80424_)
                       _n80428_
                       (std/srfi/43#unspecified-value))
                      (if (null? (cdddr _args80424_))
                          (_parse-args80426_
                           (car _args80424_)
                           (cadr _args80424_)
                           _n80428_
                           (caddr _args80424_))
                          (error '"too many arguments"
                                 std/srfi/43#vector-copy
                                 (cdddr _args80424_))))))))))
  (define std/srfi/43#vector-reverse-copy
    (lambda (_vec80413_ . _maybe-start+end80414_)
      (let* ((_vec80416_
              (std/srfi/43#check-type
               vector?
               _vec80413_
               std/srfi/43#vector-reverse-copy))
             (_g80857_
              (std/srfi/43#vector-parse-start+end
               _vec80416_
               _maybe-start+end80414_
               'start
               'end
               std/srfi/43#vector-reverse-copy)))
        (begin
          (let ((_g80858_
                 (if (##values? _g80857_) (##vector-length _g80857_) 1)))
            (if (not (##fx= _g80858_ 2))
                (error "Context expects 2 values" _g80858_)))
          (let ((_start80418_ (##vector-ref _g80857_ 0))
                (_end80419_ (##vector-ref _g80857_ 1)))
            (let ((_new80421_ (make-vector (- _end80419_ _start80418_))))
              (std/srfi/43#%vector-reverse-copy!
               _new80421_
               '0
               _vec80416_
               _start80418_
               _end80419_)
              _new80421_))))))
  (define std/srfi/43#vector-append
    (lambda _vectors80411_
      (std/srfi/43#vector-concatenate:aux
       _vectors80411_
       std/srfi/43#vector-append)))
  (define std/srfi/43#vector-concatenate
    (lambda (_vector-list80409_)
      (std/srfi/43#vector-concatenate:aux
       _vector-list80409_
       std/srfi/43#vector-concatenate)))
  (define std/srfi/43#vector-concatenate:aux
    (letrec ((_compute-length80379_
              (lambda (_vectors80382_ _len80383_ _callee80384_)
                (if (null? _vectors80382_)
                    _len80383_
                    (let ((_vec80386_
                           (std/srfi/43#check-type
                            vector?
                            (car _vectors80382_)
                            _callee80384_)))
                      (_compute-length80379_
                       (cdr _vectors80382_)
                       (+ (vector-length _vec80386_) _len80383_)
                       _callee80384_)))))
             (_concatenate!80380_
              (lambda (_vectors80388_ _target80389_ _to80390_)
                (if (null? _vectors80388_)
                    _target80389_
                    (let* ((_vec180392_ (car _vectors80388_))
                           (_len80394_ (vector-length _vec180392_)))
                      (std/srfi/43#%vector-copy!
                       _target80389_
                       _to80390_
                       _vec180392_
                       '0
                       _len80394_)
                      (_concatenate!80380_
                       (cdr _vectors80388_)
                       _target80389_
                       (+ _to80390_ _len80394_)))))))
      (lambda (_vectors80397_ _callee80398_)
        (if (null? _vectors80397_)
            (make-vector '0)
            (if (null? (cdr _vectors80397_))
                (let* ((_vec80400_
                        (std/srfi/43#check-type
                         vector?
                         (car _vectors80397_)
                         _callee80398_))
                       (_len80402_ (vector-length _vec80400_))
                       (_new80404_ (make-vector _len80402_)))
                  (std/srfi/43#%vector-copy!
                   _new80404_
                   '0
                   _vec80400_
                   '0
                   _len80402_)
                  _new80404_)
                (let ((_new-vector80407_
                       (make-vector
                        (_compute-length80379_
                         _vectors80397_
                         '0
                         _callee80398_))))
                  (_concatenate!80380_ _vectors80397_ _new-vector80407_ '0)
                  _new-vector80407_))))))
  (define std/srfi/43#vector-empty?
    (lambda (_vec80375_)
      (let ((_vec80377_
             (std/srfi/43#check-type
              vector?
              _vec80375_
              std/srfi/43#vector-empty?)))
        (zero? (vector-length _vec80377_)))))
  (define std/srfi/43#vector=
    (lambda (_elt=?80360_ . _vectors80361_)
      (let ((_elt=?80363_
             (std/srfi/43#check-type
              procedure?
              _elt=?80360_
              std/srfi/43#vector=)))
        (if (null? _vectors80361_)
            '#t
            (if (null? (cdr _vectors80361_))
                (begin
                  (std/srfi/43#check-type
                   vector?
                   (car _vectors80361_)
                   std/srfi/43#vector=)
                  '#t)
                (let _loop80365_ ((_vecs80367_ _vectors80361_))
                  (let ((_vec180369_
                         (std/srfi/43#check-type
                          vector?
                          (car _vecs80367_)
                          std/srfi/43#vector=))
                        (_vec2+80370_ (cdr _vecs80367_)))
                    (let ((_$e80372_ (null? _vec2+80370_)))
                      (if _$e80372_
                          _$e80372_
                          (if (std/srfi/43#binary-vector=
                               _elt=?80363_
                               _vec180369_
                               (car _vec2+80370_))
                              (_loop80365_ _vec2+80370_)
                              '#f))))))))))
  (define std/srfi/43#binary-vector=
    (lambda (_elt=?80335_ _vector-a80336_ _vector-b80337_)
      (let ((_$e80339_ (eq? _vector-a80336_ _vector-b80337_)))
        (if _$e80339_
            _$e80339_
            (let ((_length-a80342_ (vector-length _vector-a80336_))
                  (_length-b80343_ (vector-length _vector-b80337_)))
              (letrec ((_loop80345_
                        (lambda (_i80348_)
                          (let ((_$e80350_ (= _i80348_ _length-a80342_)))
                            (if _$e80350_
                                _$e80350_
                                (if (< _i80348_ _length-b80343_)
                                    (_test80346_
                                     (vector-ref _vector-a80336_ _i80348_)
                                     (vector-ref _vector-b80337_ _i80348_)
                                     _i80348_)
                                    '#f)))))
                       (_test80346_
                        (lambda (_elt-a80353_ _elt-b80354_ _i80355_)
                          (if (or (eq? _elt-a80353_ _elt-b80354_)
                                  (_elt=?80335_ _elt-a80353_ _elt-b80354_))
                              (_loop80345_ (+ _i80355_ '1))
                              '#f))))
                (if (= _length-a80342_ _length-b80343_)
                    (_loop80345_ '0)
                    '#f)))))))
  (define std/srfi/43#vector-fold
    (lambda (_kons80327_ _knil80328_ _vec80329_ . _vectors80330_)
      (let ((_kons80332_
             (std/srfi/43#check-type
              procedure?
              _kons80327_
              std/srfi/43#vector-fold))
            (_vec80333_
             (std/srfi/43#check-type
              vector?
              _vec80329_
              std/srfi/43#vector-fold)))
        (if (null? _vectors80330_)
            (std/srfi/43#%vector-fold1
             _kons80332_
             _knil80328_
             (vector-length _vec80333_)
             _vec80333_)
            (std/srfi/43#%vector-fold2+
             _kons80332_
             _knil80328_
             (std/srfi/43#%smallest-length
              _vectors80330_
              (vector-length _vec80333_)
              std/srfi/43#vector-fold)
             (cons _vec80333_ _vectors80330_))))))
  (define std/srfi/43#vector-fold-right
    (letrec ((_loop180306_
              (lambda (_kons80309_ _knil80310_ _vec80311_ _i80312_)
                (if (negative? _i80312_)
                    _knil80310_
                    (_loop180306_
                     _kons80309_
                     (_kons80309_
                      _i80312_
                      _knil80310_
                      (vector-ref _vec80311_ _i80312_))
                     _vec80311_
                     (- _i80312_ '1)))))
             (_loop2+80307_
              (lambda (_kons80314_ _knil80315_ _vectors80316_ _i80317_)
                (if (negative? _i80317_)
                    _knil80315_
                    (_loop2+80307_
                     _kons80314_
                     (apply _kons80314_
                            _i80317_
                            _knil80315_
                            (std/srfi/43#vectors-ref _vectors80316_ _i80317_))
                     _vectors80316_
                     (- _i80317_ '1))))))
      (lambda (_kons80319_ _knil80320_ _vec80321_ . _vectors80322_)
        (let ((_kons80324_
               (std/srfi/43#check-type
                procedure?
                _kons80319_
                std/srfi/43#vector-fold-right))
              (_vec80325_
               (std/srfi/43#check-type
                vector?
                _vec80321_
                std/srfi/43#vector-fold-right)))
          (if (null? _vectors80322_)
              (_loop180306_
               _kons80324_
               _knil80320_
               _vec80325_
               (- (vector-length _vec80325_) '1))
              (_loop2+80307_
               _kons80324_
               _knil80320_
               (cons _vec80325_ _vectors80322_)
               (- (std/srfi/43#%smallest-length
                   _vectors80322_
                   (vector-length _vec80325_)
                   std/srfi/43#vector-fold-right)
                  '1)))))))
  (define std/srfi/43#vector-map
    (lambda (_f80295_ _vec80296_ . _vectors80297_)
      (let ((_f80299_
             (std/srfi/43#check-type
              procedure?
              _f80295_
              std/srfi/43#vector-map))
            (_vec80300_
             (std/srfi/43#check-type
              vector?
              _vec80296_
              std/srfi/43#vector-map)))
        (if (null? _vectors80297_)
            (let ((_len80302_ (vector-length _vec80300_)))
              (std/srfi/43#%vector-map1!
               _f80299_
               (make-vector _len80302_)
               _vec80300_
               _len80302_))
            (let ((_len80304_
                   (std/srfi/43#%smallest-length
                    _vectors80297_
                    (vector-length _vec80300_)
                    std/srfi/43#vector-map)))
              (std/srfi/43#%vector-map2+!
               _f80299_
               (make-vector _len80304_)
               (cons _vec80300_ _vectors80297_)
               _len80304_))))))
  (define std/srfi/43#vector-map!
    (lambda (_f80288_ _vec80289_ . _vectors80290_)
      (let ((_f80292_
             (std/srfi/43#check-type
              procedure?
              _f80288_
              std/srfi/43#vector-map!))
            (_vec80293_
             (std/srfi/43#check-type
              vector?
              _vec80289_
              std/srfi/43#vector-map!)))
        (if (null? _vectors80290_)
            (std/srfi/43#%vector-map1!
             _f80292_
             _vec80293_
             _vec80293_
             (vector-length _vec80293_))
            (std/srfi/43#%vector-map2+!
             _f80292_
             _vec80293_
             (cons _vec80293_ _vectors80290_)
             (std/srfi/43#%smallest-length
              _vectors80290_
              (vector-length _vec80293_)
              std/srfi/43#vector-map!)))
        (std/srfi/43#unspecified-value))))
  (define std/srfi/43#vector-for-each
    (letrec ((_for-each180268_
              (lambda (_f80271_ _vec80272_ _i80273_ _len80274_)
                (if (< _i80273_ _len80274_)
                    (begin
                      (_f80271_ _i80273_ (vector-ref _vec80272_ _i80273_))
                      (_for-each180268_
                       _f80271_
                       _vec80272_
                       (+ _i80273_ '1)
                       _len80274_))
                    '#!void)))
             (_for-each2+80269_
              (lambda (_f80276_ _vecs80277_ _i80278_ _len80279_)
                (if (< _i80278_ _len80279_)
                    (begin
                      (apply _f80276_
                             _i80278_
                             (std/srfi/43#vectors-ref _vecs80277_ _i80278_))
                      (_for-each2+80269_
                       _f80276_
                       _vecs80277_
                       (+ _i80278_ '1)
                       _len80279_))
                    '#!void))))
      (lambda (_f80281_ _vec80282_ . _vectors80283_)
        (let ((_f80285_
               (std/srfi/43#check-type
                procedure?
                _f80281_
                std/srfi/43#vector-for-each))
              (_vec80286_
               (std/srfi/43#check-type
                vector?
                _vec80282_
                std/srfi/43#vector-for-each)))
          (if (null? _vectors80283_)
              (_for-each180268_
               _f80285_
               _vec80286_
               '0
               (vector-length _vec80286_))
              (_for-each2+80269_
               _f80285_
               (cons _vec80286_ _vectors80283_)
               '0
               (std/srfi/43#%smallest-length
                _vectors80283_
                (vector-length _vec80286_)
                std/srfi/43#vector-for-each)))))))
  (define std/srfi/43#vector-count
    (lambda (_pred?80253_ _vec80254_ . _vectors80255_)
      (let ((_pred?80257_
             (std/srfi/43#check-type
              procedure?
              _pred?80253_
              std/srfi/43#vector-count))
            (_vec80258_
             (std/srfi/43#check-type
              vector?
              _vec80254_
              std/srfi/43#vector-count)))
        (if (null? _vectors80255_)
            (std/srfi/43#%vector-fold1
             (lambda (_index80260_ _count80261_ _elt80262_)
               (if (_pred?80257_ _index80260_ _elt80262_)
                   (+ _count80261_ '1)
                   _count80261_))
             '0
             (vector-length _vec80258_)
             _vec80258_)
            (std/srfi/43#%vector-fold2+
             (lambda (_index80264_ _count80265_ . _elts80266_)
               (if (apply _pred?80257_ _index80264_ _elts80266_)
                   (+ _count80265_ '1)
                   _count80265_))
             '0
             (std/srfi/43#%smallest-length
              _vectors80255_
              (vector-length _vec80258_)
              std/srfi/43#vector-count)
             (cons _vec80258_ _vectors80255_))))))
  (define std/srfi/43#vector-index
    (lambda (_pred?80249_ _vec80250_ . _vectors80251_)
      (std/srfi/43#vector-index/skip
       _pred?80249_
       _vec80250_
       _vectors80251_
       std/srfi/43#vector-index)))
  (define std/srfi/43#vector-skip
    (lambda (_pred?80243_ _vec80244_ . _vectors80245_)
      (std/srfi/43#vector-index/skip
       (lambda _elts80247_ (not (apply _pred?80243_ _elts80247_)))
       _vec80244_
       _vectors80245_
       std/srfi/43#vector-skip)))
  (define std/srfi/43#vector-index/skip
    (letrec ((_loop180222_
              (lambda (_pred?80225_ _vec80226_ _len80227_ _i80228_)
                (if (= _i80228_ _len80227_)
                    '#f
                    (if (_pred?80225_ (vector-ref _vec80226_ _i80228_))
                        _i80228_
                        (_loop180222_
                         _pred?80225_
                         _vec80226_
                         _len80227_
                         (+ _i80228_ '1))))))
             (_loop2+80223_
              (lambda (_pred?80230_ _vectors80231_ _len80232_ _i80233_)
                (if (= _i80233_ _len80232_)
                    '#f
                    (if (apply _pred?80230_
                               (std/srfi/43#vectors-ref
                                _vectors80231_
                                _i80233_))
                        _i80233_
                        (_loop2+80223_
                         _pred?80230_
                         _vectors80231_
                         _len80232_
                         (+ _i80233_ '1)))))))
      (lambda (_pred?80235_ _vec80236_ _vectors80237_ _callee80238_)
        (let ((_pred?80240_
               (std/srfi/43#check-type procedure? _pred?80235_ _callee80238_))
              (_vec80241_
               (std/srfi/43#check-type vector? _vec80236_ _callee80238_)))
          (if (null? _vectors80237_)
              (_loop180222_
               _pred?80240_
               _vec80241_
               (vector-length _vec80241_)
               '0)
              (_loop2+80223_
               _pred?80240_
               (cons _vec80241_ _vectors80237_)
               (std/srfi/43#%smallest-length
                _vectors80237_
                (vector-length _vec80241_)
                _callee80238_)
               '0))))))
  (define std/srfi/43#vector-index-right
    (lambda (_pred?80218_ _vec80219_ . _vectors80220_)
      (std/srfi/43#vector-index/skip-right
       _pred?80218_
       _vec80219_
       _vectors80220_
       std/srfi/43#vector-index-right)))
  (define std/srfi/43#vector-skip-right
    (lambda (_pred?80212_ _vec80213_ . _vectors80214_)
      (std/srfi/43#vector-index/skip-right
       (lambda _elts80216_ (not (apply _pred?80212_ _elts80216_)))
       _vec80213_
       _vectors80214_
       std/srfi/43#vector-index-right)))
  (define std/srfi/43#vector-index/skip-right
    (letrec ((_loop180193_
              (lambda (_pred?80196_ _vec80197_ _i80198_)
                (if (negative? _i80198_)
                    '#f
                    (if (_pred?80196_ (vector-ref _vec80197_ _i80198_))
                        _i80198_
                        (_loop180193_
                         _pred?80196_
                         _vec80197_
                         (- _i80198_ '1))))))
             (_loop2+80194_
              (lambda (_pred?80200_ _vectors80201_ _i80202_)
                (if (negative? _i80202_)
                    '#f
                    (if (apply _pred?80200_
                               (std/srfi/43#vectors-ref
                                _vectors80201_
                                _i80202_))
                        _i80202_
                        (_loop2+80194_
                         _pred?80200_
                         _vectors80201_
                         (- _i80202_ '1)))))))
      (lambda (_pred?80204_ _vec80205_ _vectors80206_ _callee80207_)
        (let ((_pred?80209_
               (std/srfi/43#check-type procedure? _pred?80204_ _callee80207_))
              (_vec80210_
               (std/srfi/43#check-type vector? _vec80205_ _callee80207_)))
          (if (null? _vectors80206_)
              (_loop180193_
               _pred?80209_
               _vec80210_
               (- (vector-length _vec80210_) '1))
              (_loop2+80194_
               _pred?80209_
               (cons _vec80210_ _vectors80206_)
               (- (std/srfi/43#%smallest-length
                   _vectors80206_
                   (vector-length _vec80210_)
                   _callee80207_)
                  '1)))))))
  (define std/srfi/43#vector-binary-search
    (lambda (_vec80168_ _value80169_ _cmp80170_ . _maybe-start+end80171_)
      (let* ((_cmp80173_
              (std/srfi/43#check-type
               procedure?
               _cmp80170_
               std/srfi/43#vector-binary-search))
             (_vec80175_
              (std/srfi/43#check-type
               vector?
               _vec80168_
               std/srfi/43#vector-binary-search))
             (_g80859_
              (std/srfi/43#vector-parse-start+end
               _vec80175_
               _maybe-start+end80171_
               'start
               'end
               std/srfi/43#vector-binary-search)))
        (begin
          (let ((_g80860_
                 (if (##values? _g80859_) (##vector-length _g80859_) 1)))
            (if (not (##fx= _g80860_ 2))
                (error "Context expects 2 values" _g80860_)))
          (let ((_start80177_ (##vector-ref _g80859_ 0))
                (_end80178_ (##vector-ref _g80859_ 1)))
            (let _loop80180_ ((_start80182_ _start80177_)
                              (_end80183_ _end80178_)
                              (_j80184_ '#f))
              (let ((_i80186_ (quotient (+ _start80182_ _end80183_) '2)))
                (if (or (= _start80182_ _end80183_)
                        (and _j80184_ (= _i80186_ _j80184_)))
                    '#f
                    (let ((_comparison80191_
                           (std/srfi/43#check-type
                            integer?
                            (_cmp80173_
                             (vector-ref _vec80175_ _i80186_)
                             _value80169_)
                            (cons _cmp80173_
                                  (cons 'for
                                        (cons std/srfi/43#vector-binary-search
                                              '()))))))
                      (if (zero? _comparison80191_)
                          _i80186_
                          (if (positive? _comparison80191_)
                              (_loop80180_ _start80182_ _i80186_ _i80186_)
                              (_loop80180_
                               _i80186_
                               _end80183_
                               _i80186_))))))))))))
  (define std/srfi/43#vector-any
    (letrec ((_loop180136_
              (lambda (_pred?80139_
                       _vec80140_
                       _i80141_
                       _len80142_
                       _len-180143_)
                (if (not (= _i80141_ _len80142_))
                    (if (= _i80141_ _len-180143_)
                        (_pred?80139_ (vector-ref _vec80140_ _i80141_))
                        (let ((_$e80145_
                               (_pred?80139_
                                (vector-ref _vec80140_ _i80141_))))
                          (if _$e80145_
                              _$e80145_
                              (_loop180136_
                               _pred?80139_
                               _vec80140_
                               (+ _i80141_ '1)
                               _len80142_
                               _len-180143_))))
                    '#f)))
             (_loop2+80137_
              (lambda (_pred?80148_
                       _vectors80149_
                       _i80150_
                       _len80151_
                       _len-180152_)
                (if (not (= _i80150_ _len80151_))
                    (if (= _i80150_ _len-180152_)
                        (apply _pred?80148_
                               (std/srfi/43#vectors-ref
                                _vectors80149_
                                _i80150_))
                        (let ((_$e80154_
                               (apply _pred?80148_
                                      (std/srfi/43#vectors-ref
                                       _vectors80149_
                                       _i80150_))))
                          (if _$e80154_
                              _$e80154_
                              (_loop2+80137_
                               _pred?80148_
                               _vectors80149_
                               (+ _i80150_ '1)
                               _len80151_
                               _len-180152_))))
                    '#f))))
      (lambda (_pred?80157_ _vec80158_ . _vectors80159_)
        (let ((_pred?80161_
               (std/srfi/43#check-type
                procedure?
                _pred?80157_
                std/srfi/43#vector-any))
              (_vec80162_
               (std/srfi/43#check-type
                vector?
                _vec80158_
                std/srfi/43#vector-any)))
          (if (null? _vectors80159_)
              (let ((_len80164_ (vector-length _vec80162_)))
                (_loop180136_
                 _pred?80161_
                 _vec80162_
                 '0
                 _len80164_
                 (- _len80164_ '1)))
              (let ((_len80166_
                     (std/srfi/43#%smallest-length
                      _vectors80159_
                      (vector-length _vec80162_)
                      std/srfi/43#vector-any)))
                (_loop2+80137_
                 _pred?80161_
                 (cons _vec80162_ _vectors80159_)
                 '0
                 _len80166_
                 (- _len80166_ '1))))))))
  (define std/srfi/43#vector-every
    (letrec ((_loop180104_
              (lambda (_pred?80107_
                       _vec80108_
                       _i80109_
                       _len80110_
                       _len-180111_)
                (let ((_$e80113_ (= _i80109_ _len80110_)))
                  (if _$e80113_
                      _$e80113_
                      (if (= _i80109_ _len-180111_)
                          (_pred?80107_ (vector-ref _vec80108_ _i80109_))
                          (if (_pred?80107_ (vector-ref _vec80108_ _i80109_))
                              (_loop180104_
                               _pred?80107_
                               _vec80108_
                               (+ _i80109_ '1)
                               _len80110_
                               _len-180111_)
                              '#f))))))
             (_loop2+80105_
              (lambda (_pred?80116_
                       _vectors80117_
                       _i80118_
                       _len80119_
                       _len-180120_)
                (let ((_$e80122_ (= _i80118_ _len80119_)))
                  (if _$e80122_
                      _$e80122_
                      (if (= _i80118_ _len-180120_)
                          (apply _pred?80116_
                                 (std/srfi/43#vectors-ref
                                  _vectors80117_
                                  _i80118_))
                          (if (apply _pred?80116_
                                     (std/srfi/43#vectors-ref
                                      _vectors80117_
                                      _i80118_))
                              (_loop2+80105_
                               _pred?80116_
                               _vectors80117_
                               (+ _i80118_ '1)
                               _len80119_
                               _len-180120_)
                              '#f)))))))
      (lambda (_pred?80125_ _vec80126_ . _vectors80127_)
        (let ((_pred?80129_
               (std/srfi/43#check-type
                procedure?
                _pred?80125_
                std/srfi/43#vector-every))
              (_vec80130_
               (std/srfi/43#check-type
                vector?
                _vec80126_
                std/srfi/43#vector-every)))
          (if (null? _vectors80127_)
              (let ((_len80132_ (vector-length _vec80130_)))
                (_loop180104_
                 _pred?80129_
                 _vec80130_
                 '0
                 _len80132_
                 (- _len80132_ '1)))
              (let ((_len80134_
                     (std/srfi/43#%smallest-length
                      _vectors80127_
                      (vector-length _vec80130_)
                      std/srfi/43#vector-every)))
                (_loop2+80105_
                 _pred?80129_
                 (cons _vec80130_ _vectors80127_)
                 '0
                 _len80134_
                 (- _len80134_ '1))))))))
  (define std/srfi/43#vector-swap!
    (lambda (_vec80093_ _i80094_ _j80095_)
      (let ((_vec80097_
             (std/srfi/43#check-type
              vector?
              _vec80093_
              std/srfi/43#vector-swap!)))
        (let ((_i80099_
               (std/srfi/43#check-index
                _vec80097_
                _i80094_
                std/srfi/43#vector-swap!))
              (_j80100_
               (std/srfi/43#check-index
                _vec80097_
                _j80095_
                std/srfi/43#vector-swap!)))
          (let ((_x80102_ (vector-ref _vec80097_ _i80099_)))
            (vector-set! _vec80097_ _i80099_ (vector-ref _vec80097_ _j80100_))
            (vector-set! _vec80097_ _j80100_ _x80102_))))))
  (define std/srfi/43#%%vector-fill!
    (let ((_%vector-fill!80077_ vector-fill!))
      (lambda (_vec80079_ _value80080_ . _maybe-start+end80081_)
        (if (null? _maybe-start+end80081_)
            (_%vector-fill!80077_ _vec80079_ _value80080_)
            (let* ((_vec80083_
                    (std/srfi/43#check-type vector? _vec80079_ vector-fill!))
                   (_g80861_
                    (std/srfi/43#vector-parse-start+end
                     _vec80083_
                     _maybe-start+end80081_
                     'start
                     'end
                     vector-fill!)))
              (begin
                (let ((_g80862_
                       (if (##values? _g80861_) (##vector-length _g80861_) 1)))
                  (if (not (##fx= _g80862_ 2))
                      (error "Context expects 2 values" _g80862_)))
                (let ((_start80085_ (##vector-ref _g80861_ 0))
                      (_end80086_ (##vector-ref _g80861_ 1)))
                  (let _$loop80088_ ((_i80091_ _start80085_))
                    (if (= _i80091_ _end80086_)
                        '#!void
                        (begin
                          (vector-set! _vec80083_ _i80091_ _value80080_)
                          (_$loop80088_ (+ _i80091_ '1))))))))))))
  (define std/srfi/43#vector-copy!
    (lambda (_target80060_
             _tstart80061_
             _source80062_
             .
             _maybe-sstart+send80063_)
      (letrec ((_doit!80065_
                (lambda (_sstart80069_ _send80070_ _source-length80071_)
                  (let ((_tstart80073_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _tstart80061_
                          std/srfi/43#vector-copy!))
                        (_sstart80074_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _sstart80069_
                          std/srfi/43#vector-copy!))
                        (_send80075_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _send80070_
                          std/srfi/43#vector-copy!)))
                    (if (and (<= '0
                                 _sstart80074_
                                 _send80075_
                                 _source-length80071_)
                             (<= (+ _tstart80073_
                                    (- _send80075_ _sstart80074_))
                                 (vector-length _target80060_)))
                        (std/srfi/43#%vector-copy!
                         _target80060_
                         _tstart80073_
                         _source80062_
                         _sstart80074_
                         _send80075_)
                        (error '"illegal arguments"
                               (cons 'while
                                     (cons 'calling
                                           (cons std/srfi/43#vector-copy!
                                                 '())))
                               (cons 'target
                                     (cons 'was (cons _target80060_ '())))
                               (cons 'target-length
                                     (cons 'was
                                           (cons (vector-length _target80060_)
                                                 '())))
                               (cons 'tstart
                                     (cons 'was (cons _tstart80073_ '())))
                               (cons 'source
                                     (cons 'was (cons _source80062_ '())))
                               (cons 'source-length
                                     (cons 'was
                                           (cons _source-length80071_ '())))
                               (cons 'sstart
                                     (cons 'was (cons _sstart80074_ '())))
                               (cons 'send
                                     (cons 'was (cons _send80075_ '())))))))))
        (let ((_n80067_ (vector-length _source80062_)))
          (if (null? _maybe-sstart+send80063_)
              (_doit!80065_ '0 _n80067_ _n80067_)
              (if (null? (cdr _maybe-sstart+send80063_))
                  (_doit!80065_
                   (car _maybe-sstart+send80063_)
                   _n80067_
                   _n80067_)
                  (if (null? (cddr _maybe-sstart+send80063_))
                      (_doit!80065_
                       (car _maybe-sstart+send80063_)
                       (cadr _maybe-sstart+send80063_)
                       _n80067_)
                      (error '"too many arguments"
                             std/srfi/43#vector-copy!
                             (cddr _maybe-sstart+send80063_)))))))))
  (define std/srfi/43#vector-reverse-copy!
    (lambda (_target80040_
             _tstart80041_
             _source80042_
             .
             _maybe-sstart+send80043_)
      (letrec ((_doit!80045_
                (lambda (_sstart80049_ _send80050_ _source-length80051_)
                  (let ((_tstart80053_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _tstart80041_
                          std/srfi/43#vector-reverse-copy!))
                        (_sstart80054_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _sstart80049_
                          std/srfi/43#vector-reverse-copy!))
                        (_send80055_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _send80050_
                          std/srfi/43#vector-reverse-copy!)))
                    (if (and (eq? _target80040_ _source80042_)
                             (or (std/srfi/43#between?
                                  _sstart80054_
                                  _tstart80053_
                                  _send80055_)
                                 (std/srfi/43#between?
                                  _tstart80053_
                                  _sstart80054_
                                  (+ _tstart80053_
                                     (- _send80055_ _sstart80054_)))))
                        (error '"vector range for self-copying overlaps"
                               std/srfi/43#vector-reverse-copy!
                               (cons 'vector
                                     (cons 'was (cons _target80040_ '())))
                               (cons 'tstart
                                     (cons 'was (cons _tstart80053_ '())))
                               (cons 'sstart
                                     (cons 'was (cons _sstart80054_ '())))
                               (cons 'send (cons 'was (cons _send80055_ '()))))
                        (if (and (<= '0
                                     _sstart80054_
                                     _send80055_
                                     _source-length80051_)
                                 (<= (+ _tstart80053_
                                        (- _send80055_ _sstart80054_))
                                     (vector-length _target80040_)))
                            (std/srfi/43#%vector-reverse-copy!
                             _target80040_
                             _tstart80053_
                             _source80042_
                             _sstart80054_
                             _send80055_)
                            (error '"illegal arguments"
                                   (cons 'while
                                         (cons 'calling
                                               (cons std/srfi/43#vector-reverse-copy!
                                                     '())))
                                   (cons 'target
                                         (cons 'was (cons _target80040_ '())))
                                   (cons 'target-length
                                         (cons 'was
                                               (cons (vector-length
                                                      _target80040_)
                                                     '())))
                                   (cons 'tstart
                                         (cons 'was (cons _tstart80053_ '())))
                                   (cons 'source
                                         (cons 'was (cons _source80042_ '())))
                                   (cons 'source-length
                                         (cons 'was
                                               (cons _source-length80051_
                                                     '())))
                                   (cons 'sstart
                                         (cons 'was (cons _sstart80054_ '())))
                                   (cons 'send
                                         (cons 'was
                                               (cons _send80055_ '()))))))))))
        (let ((_n80047_ (vector-length _source80042_)))
          (if (null? _maybe-sstart+send80043_)
              (_doit!80045_ '0 _n80047_ _n80047_)
              (if (null? (cdr _maybe-sstart+send80043_))
                  (_doit!80045_
                   (car _maybe-sstart+send80043_)
                   _n80047_
                   _n80047_)
                  (if (null? (cddr _maybe-sstart+send80043_))
                      (_doit!80045_
                       (car _maybe-sstart+send80043_)
                       (cadr _maybe-sstart+send80043_)
                       _n80047_)
                      (error '"too many arguments"
                             std/srfi/43#vector-reverse-copy!
                             (cddr _maybe-sstart+send80043_)))))))))
  (define std/srfi/43#vector-reverse!
    (lambda (_vec80032_ . _start+end80033_)
      (let* ((_vec80035_
              (std/srfi/43#check-type
               vector?
               _vec80032_
               std/srfi/43#vector-reverse!))
             (_g80863_
              (std/srfi/43#vector-parse-start+end
               _vec80035_
               _start+end80033_
               'start
               'end
               std/srfi/43#vector-reverse!)))
        (begin
          (let ((_g80864_
                 (if (##values? _g80863_) (##vector-length _g80863_) 1)))
            (if (not (##fx= _g80864_ 2))
                (error "Context expects 2 values" _g80864_)))
          (let ((_start80037_ (##vector-ref _g80863_ 0))
                (_end80038_ (##vector-ref _g80863_ 1)))
            (std/srfi/43#%vector-reverse!
             _vec80035_
             _start80037_
             _end80038_))))))
  (define std/srfi/43#%%vector->list
    (let ((_%vector->list80016_ vector->list))
      (lambda (_vec80018_ . _maybe-start+end80019_)
        (if (null? _maybe-start+end80019_)
            (_%vector->list80016_ _vec80018_)
            (let* ((_vec80021_
                    (std/srfi/43#check-type vector? _vec80018_ vector->list))
                   (_g80865_
                    (std/srfi/43#vector-parse-start+end
                     _vec80021_
                     _maybe-start+end80019_
                     'start
                     'end
                     vector->list)))
              (begin
                (let ((_g80866_
                       (if (##values? _g80865_) (##vector-length _g80865_) 1)))
                  (if (not (##fx= _g80866_ 2))
                      (error "Context expects 2 values" _g80866_)))
                (let ((_start80023_ (##vector-ref _g80865_ 0))
                      (_end80024_ (##vector-ref _g80865_ 1)))
                  (let _$loop80026_ ((_i80029_ (- _end80024_ '1))
                                     (_result80030_ '()))
                    (if (< _i80029_ _start80023_)
                        _result80030_
                        (_$loop80026_
                         (- _i80029_ '1)
                         (cons (vector-ref _vec80021_ _i80029_)
                               _result80030_)))))))))))
  (define std/srfi/43#reverse-vector->list
    (lambda (_vec80002_ . _maybe-start+end80003_)
      (let* ((_vec80005_
              (std/srfi/43#check-type
               vector?
               _vec80002_
               std/srfi/43#reverse-vector->list))
             (_g80867_
              (std/srfi/43#vector-parse-start+end
               _vec80005_
               _maybe-start+end80003_
               'start
               'end
               std/srfi/43#reverse-vector->list)))
        (begin
          (let ((_g80868_
                 (if (##values? _g80867_) (##vector-length _g80867_) 1)))
            (if (not (##fx= _g80868_ 2))
                (error "Context expects 2 values" _g80868_)))
          (let ((_start80007_ (##vector-ref _g80867_ 0))
                (_end80008_ (##vector-ref _g80867_ 1)))
            (let _$loop80010_ ((_i80013_ _start80007_) (_result80014_ '()))
              (if (= _i80013_ _end80008_)
                  _result80014_
                  (_$loop80010_
                   (+ _i80013_ '1)
                   (cons (vector-ref _vec80005_ _i80013_)
                         _result80014_)))))))))
  (define std/srfi/43#%%list->vector
    (let ((_%list->vector79956_ list->vector))
      (lambda (_lst79958_ . _maybe-start+end79959_)
        (if (null? _maybe-start+end79959_)
            (_%list->vector79956_ _lst79958_)
            (if (null? _maybe-start+end79959_)
                (let* ((_start79961_ '0) (_end79963_ (length _lst79958_)))
                  (let ((_start79966_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _start79961_
                          list->vector))
                        (_end79967_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _end79963_
                          list->vector)))
                    ((lambda (_f79969_)
                       (std/srfi/43#vector-unfold
                        _f79969_
                        (- _end79967_ _start79966_)
                        (list-tail _lst79958_ _start79966_)))
                     (lambda (_index79971_ _l79972_)
                       (if (null? _l79972_)
                           (error '"list was too short"
                                  (cons 'list
                                        (cons 'was (cons _lst79958_ '())))
                                  (cons 'attempted
                                        (cons 'end
                                              (cons 'was
                                                    (cons _end79967_ '()))))
                                  (cons 'while
                                        (cons 'calling
                                              (cons std/srfi/43#%%list->vector
                                                    '()))))
                           (if (pair? _l79972_)
                               (values (car _l79972_) (cdr _l79972_))
                               (error '"erroneous value"
                                      (list list? _lst79958_)
                                      (cons 'while
                                            (cons 'calling
                                                  (cons std/srfi/43#%%list->vector
                                                        '()))))))))))
                (let ((_start79974_ (car _maybe-start+end79959_))
                      (_new-args79975_ (cdr _maybe-start+end79959_)))
                  (if (null? _new-args79975_)
                      (let ((_end79978_ (length _lst79958_)))
                        (let ((_start79981_
                               (std/srfi/43#check-type
                                std/srfi/43#nonneg-int?
                                _start79974_
                                list->vector))
                              (_end79982_
                               (std/srfi/43#check-type
                                std/srfi/43#nonneg-int?
                                _end79978_
                                list->vector)))
                          ((lambda (_f79984_)
                             (std/srfi/43#vector-unfold
                              _f79984_
                              (- _end79982_ _start79981_)
                              (list-tail _lst79958_ _start79981_)))
                           (lambda (_index79986_ _l79987_)
                             (if (null? _l79987_)
                                 (error '"list was too short"
                                        (cons 'list
                                              (cons 'was
                                                    (cons _lst79958_ '())))
                                        (cons 'attempted
                                              (cons 'end
                                                    (cons 'was
                                                          (cons _end79982_
                                                                '()))))
                                        (cons 'while
                                              (cons 'calling
                                                    (cons std/srfi/43#%%list->vector
                                                          '()))))
                                 (if (pair? _l79987_)
                                     (values (car _l79987_) (cdr _l79987_))
                                     (error '"erroneous value"
                                            (list list? _lst79958_)
                                            (cons 'while
                                                  (cons 'calling
                                                        (cons std/srfi/43#%%list->vector
                                                              '()))))))))))
                      (let ((_end79989_ (car _new-args79975_))
                            (_new-args79990_ (cdr _new-args79975_)))
                        (if (null? _new-args79990_)
                            (let ()
                              (let ((_start79994_
                                     (std/srfi/43#check-type
                                      std/srfi/43#nonneg-int?
                                      _start79974_
                                      list->vector))
                                    (_end79995_
                                     (std/srfi/43#check-type
                                      std/srfi/43#nonneg-int?
                                      _end79989_
                                      list->vector)))
                                ((lambda (_f79997_)
                                   (std/srfi/43#vector-unfold
                                    _f79997_
                                    (- _end79995_ _start79994_)
                                    (list-tail _lst79958_ _start79994_)))
                                 (lambda (_index79999_ _l80000_)
                                   (if (null? _l80000_)
                                       (error '"list was too short"
                                              (cons 'list
                                                    (cons 'was
                                                          (cons _lst79958_
                                                                '())))
                                              (cons 'attempted
                                                    (cons 'end
                                                          (cons 'was
                                                                (cons _end79995_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              '()))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                              (cons 'while
                                                    (cons 'calling
                                                          (cons std/srfi/43#%%list->vector
                                                                '()))))
                                       (if (pair? _l80000_)
                                           (values (car _l80000_)
                                                   (cdr _l80000_))
                                           (error '"erroneous value"
                                                  (list list? _lst79958_)
                                                  (cons 'while
                                                        (cons 'calling
                                                              (cons std/srfi/43#%%list->vector
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            '()))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                            (error '"too many arguments"
                                   (length _maybe-start+end79959_)
                                   _maybe-start+end79959_))))))))))
  (define std/srfi/43#reverse-list->vector
    (lambda (_lst79912_ . _maybe-start+end79913_)
      (if (null? _maybe-start+end79913_)
          (let* ((_start79915_ '0) (_end79917_ (length _lst79912_)))
            (let ((_start79920_
                   (std/srfi/43#check-type
                    std/srfi/43#nonneg-int?
                    _start79915_
                    std/srfi/43#reverse-list->vector))
                  (_end79921_
                   (std/srfi/43#check-type
                    std/srfi/43#nonneg-int?
                    _end79917_
                    std/srfi/43#reverse-list->vector)))
              ((lambda (_f79923_)
                 (std/srfi/43#vector-unfold-right
                  _f79923_
                  (- _end79921_ _start79920_)
                  (list-tail _lst79912_ _start79920_)))
               (lambda (_index79925_ _l79926_)
                 (if (null? _l79926_)
                     (error '"list too short"
                            (cons 'list (cons 'was (cons _lst79912_ '())))
                            (cons 'attempted
                                  (cons 'end
                                        (cons 'was (cons _end79921_ '()))))
                            (cons 'while
                                  (cons 'calling
                                        (cons std/srfi/43#reverse-list->vector
                                              '()))))
                     (if (pair? _l79926_)
                         (values (car _l79926_) (cdr _l79926_))
                         (error '"erroneous value"
                                (list list? _lst79912_)
                                (cons 'while
                                      (cons 'calling
                                            (cons std/srfi/43#reverse-list->vector
                                                  '()))))))))))
          (let ((_start79928_ (car _maybe-start+end79913_))
                (_new-args79929_ (cdr _maybe-start+end79913_)))
            (if (null? _new-args79929_)
                (let ((_end79932_ (length _lst79912_)))
                  (let ((_start79935_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _start79928_
                          std/srfi/43#reverse-list->vector))
                        (_end79936_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _end79932_
                          std/srfi/43#reverse-list->vector)))
                    ((lambda (_f79938_)
                       (std/srfi/43#vector-unfold-right
                        _f79938_
                        (- _end79936_ _start79935_)
                        (list-tail _lst79912_ _start79935_)))
                     (lambda (_index79940_ _l79941_)
                       (if (null? _l79941_)
                           (error '"list too short"
                                  (cons 'list
                                        (cons 'was (cons _lst79912_ '())))
                                  (cons 'attempted
                                        (cons 'end
                                              (cons 'was
                                                    (cons _end79936_ '()))))
                                  (cons 'while
                                        (cons 'calling
                                              (cons std/srfi/43#reverse-list->vector
                                                    '()))))
                           (if (pair? _l79941_)
                               (values (car _l79941_) (cdr _l79941_))
                               (error '"erroneous value"
                                      (list list? _lst79912_)
                                      (cons 'while
                                            (cons 'calling
                                                  (cons std/srfi/43#reverse-list->vector
                                                        '()))))))))))
                (let ((_end79943_ (car _new-args79929_))
                      (_new-args79944_ (cdr _new-args79929_)))
                  (if (null? _new-args79944_)
                      (let ()
                        (let ((_start79948_
                               (std/srfi/43#check-type
                                std/srfi/43#nonneg-int?
                                _start79928_
                                std/srfi/43#reverse-list->vector))
                              (_end79949_
                               (std/srfi/43#check-type
                                std/srfi/43#nonneg-int?
                                _end79943_
                                std/srfi/43#reverse-list->vector)))
                          ((lambda (_f79951_)
                             (std/srfi/43#vector-unfold-right
                              _f79951_
                              (- _end79949_ _start79948_)
                              (list-tail _lst79912_ _start79948_)))
                           (lambda (_index79953_ _l79954_)
                             (if (null? _l79954_)
                                 (error '"list too short"
                                        (cons 'list
                                              (cons 'was
                                                    (cons _lst79912_ '())))
                                        (cons 'attempted
                                              (cons 'end
                                                    (cons 'was
                                                          (cons _end79949_
                                                                '()))))
                                        (cons 'while
                                              (cons 'calling
                                                    (cons std/srfi/43#reverse-list->vector
                                                          '()))))
                                 (if (pair? _l79954_)
                                     (values (car _l79954_) (cdr _l79954_))
                                     (error '"erroneous value"
                                            (list list? _lst79912_)
                                            (cons 'while
                                                  (cons 'calling
                                                        (cons std/srfi/43#reverse-list->vector
                                                              '()))))))))))
                      (error '"too many arguments"
                             (length _maybe-start+end79913_)
                             _maybe-start+end79913_)))))))))
