/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.activemq.protobuf.BaseMessage;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.protobuf.CodedInputStream;
import org.apache.activemq.protobuf.CodedOutputStream;
import org.apache.activemq.protobuf.InvalidProtocolBufferException;
import org.apache.activemq.protobuf.UninitializedMessageException;
import org.apache.activemq.store.kahadb.JournalCommand;
import org.apache.activemq.store.kahadb.Visitor;
import org.apache.activemq.store.kahadb.data.KahaAddMessageCommandBase;
import org.apache.activemq.store.kahadb.data.KahaDestination;
import org.apache.activemq.store.kahadb.data.KahaEntryType;
import org.apache.activemq.store.kahadb.data.KahaTransactionInfo;

public final class KahaAddMessageCommand
extends KahaAddMessageCommandBase<KahaAddMessageCommand>
implements JournalCommand<KahaAddMessageCommand> {
    public ArrayList<String> missingFields() {
        ArrayList missingFields = super.missingFields();
        if (!this.hasDestination()) {
            missingFields.add("destination");
        }
        if (!this.hasMessageId()) {
            missingFields.add("messageId");
        }
        if (!this.hasMessage()) {
            missingFields.add("message");
        }
        if (this.hasTransactionInfo()) {
            try {
                this.getTransactionInfo().assertInitialized();
            }
            catch (UninitializedMessageException e) {
                missingFields.addAll(this.prefix(e.getMissingFields(), "transaction_info."));
            }
        }
        if (this.hasDestination()) {
            try {
                this.getDestination().assertInitialized();
            }
            catch (UninitializedMessageException e) {
                missingFields.addAll(this.prefix(e.getMissingFields(), "destination."));
            }
        }
        return missingFields;
    }

    public void clear() {
        super.clear();
        this.clearTransactionInfo();
        this.clearDestination();
        this.clearMessageId();
        this.clearMessage();
        this.clearPriority();
        this.clearPrioritySupported();
    }

    public KahaAddMessageCommand clone() {
        return new KahaAddMessageCommand().mergeFrom(this);
    }

    public KahaAddMessageCommand mergeFrom(KahaAddMessageCommand other) {
        if (other.hasTransactionInfo()) {
            if (this.hasTransactionInfo()) {
                this.getTransactionInfo().mergeFrom(other.getTransactionInfo());
            } else {
                this.setTransactionInfo(other.getTransactionInfo().clone());
            }
        }
        if (other.hasDestination()) {
            if (this.hasDestination()) {
                this.getDestination().mergeFrom(other.getDestination());
            } else {
                this.setDestination(other.getDestination().clone());
            }
        }
        if (other.hasMessageId()) {
            this.setMessageId(other.getMessageId());
        }
        if (other.hasMessage()) {
            this.setMessage(other.getMessage());
        }
        if (other.hasPriority()) {
            this.setPriority(other.getPriority());
        }
        if (other.hasPrioritySupported()) {
            this.setPrioritySupported(other.getPrioritySupported());
        }
        return this;
    }

    public int serializedSizeUnframed() {
        if (this.memoizedSerializedSize != -1) {
            return this.memoizedSerializedSize;
        }
        int size = 0;
        if (this.hasTransactionInfo()) {
            size += KahaAddMessageCommand.computeMessageSize((int)1, (BaseMessage)this.getTransactionInfo());
        }
        if (this.hasDestination()) {
            size += KahaAddMessageCommand.computeMessageSize((int)2, (BaseMessage)this.getDestination());
        }
        if (this.hasMessageId()) {
            size += CodedOutputStream.computeStringSize((int)3, (String)this.getMessageId());
        }
        if (this.hasMessage()) {
            size += CodedOutputStream.computeBytesSize((int)4, (Buffer)this.getMessage());
        }
        if (this.hasPriority()) {
            size += CodedOutputStream.computeInt32Size((int)5, (int)this.getPriority());
        }
        if (this.hasPrioritySupported()) {
            size += CodedOutputStream.computeBoolSize((int)6, (boolean)this.getPrioritySupported());
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public KahaAddMessageCommand mergeUnframed(CodedInputStream input) throws IOException {
        int tag;
        block9: while (((tag = input.readTag()) & 7) != 4) {
            switch (tag) {
                case 0: {
                    return this;
                }
                default: {
                    continue block9;
                }
                case 10: {
                    if (this.hasTransactionInfo()) {
                        this.getTransactionInfo().mergeFramed(input);
                        continue block9;
                    }
                    this.setTransactionInfo((KahaTransactionInfo)((Object)new KahaTransactionInfo().mergeFramed(input)));
                    continue block9;
                }
                case 18: {
                    if (this.hasDestination()) {
                        this.getDestination().mergeFramed(input);
                        continue block9;
                    }
                    this.setDestination((KahaDestination)((Object)new KahaDestination().mergeFramed(input)));
                    continue block9;
                }
                case 26: {
                    this.setMessageId(input.readString());
                    continue block9;
                }
                case 34: {
                    this.setMessage(input.readBytes());
                    continue block9;
                }
                case 40: {
                    this.setPriority(input.readInt32());
                    continue block9;
                }
                case 48: 
            }
            this.setPrioritySupported(input.readBool());
        }
        return this;
    }

    public void writeUnframed(CodedOutputStream output) throws IOException {
        if (this.hasTransactionInfo()) {
            KahaAddMessageCommand.writeMessage((CodedOutputStream)output, (int)1, (BaseMessage)this.getTransactionInfo());
        }
        if (this.hasDestination()) {
            KahaAddMessageCommand.writeMessage((CodedOutputStream)output, (int)2, (BaseMessage)this.getDestination());
        }
        if (this.hasMessageId()) {
            output.writeString(3, this.getMessageId());
        }
        if (this.hasMessage()) {
            output.writeBytes(4, this.getMessage());
        }
        if (this.hasPriority()) {
            output.writeInt32(5, this.getPriority());
        }
        if (this.hasPrioritySupported()) {
            output.writeBool(6, this.getPrioritySupported());
        }
    }

    public static KahaAddMessageCommand parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (KahaAddMessageCommand)new KahaAddMessageCommand().mergeUnframed(data).checktInitialized();
    }

    public static KahaAddMessageCommand parseUnframed(Buffer data) throws InvalidProtocolBufferException {
        return (KahaAddMessageCommand)((KahaAddMessageCommand)new KahaAddMessageCommand().mergeUnframed(data)).checktInitialized();
    }

    public static KahaAddMessageCommand parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return (KahaAddMessageCommand)((KahaAddMessageCommand)new KahaAddMessageCommand().mergeUnframed(data)).checktInitialized();
    }

    public static KahaAddMessageCommand parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (KahaAddMessageCommand)((KahaAddMessageCommand)new KahaAddMessageCommand().mergeUnframed(data)).checktInitialized();
    }

    public static KahaAddMessageCommand parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (KahaAddMessageCommand)((KahaAddMessageCommand)new KahaAddMessageCommand().mergeFramed(data)).checktInitialized();
    }

    public static KahaAddMessageCommand parseFramed(Buffer data) throws InvalidProtocolBufferException {
        return (KahaAddMessageCommand)((KahaAddMessageCommand)new KahaAddMessageCommand().mergeFramed(data)).checktInitialized();
    }

    public static KahaAddMessageCommand parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return (KahaAddMessageCommand)((KahaAddMessageCommand)new KahaAddMessageCommand().mergeFramed(data)).checktInitialized();
    }

    public static KahaAddMessageCommand parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (KahaAddMessageCommand)((KahaAddMessageCommand)new KahaAddMessageCommand().mergeFramed(data)).checktInitialized();
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder sb, String prefix) {
        if (this.hasTransactionInfo()) {
            sb.append(prefix + "transaction_info {\n");
            this.getTransactionInfo().toString(sb, prefix + "  ");
            sb.append(prefix + "}\n");
        }
        if (this.hasDestination()) {
            sb.append(prefix + "destination {\n");
            this.getDestination().toString(sb, prefix + "  ");
            sb.append(prefix + "}\n");
        }
        if (this.hasMessageId()) {
            sb.append(prefix + "messageId: ");
            sb.append(this.getMessageId());
            sb.append("\n");
        }
        if (this.hasMessage()) {
            sb.append(prefix + "message: ");
            sb.append(this.getMessage());
            sb.append("\n");
        }
        if (this.hasPriority()) {
            sb.append(prefix + "priority: ");
            sb.append(this.getPriority());
            sb.append("\n");
        }
        if (this.hasPrioritySupported()) {
            sb.append(prefix + "prioritySupported: ");
            sb.append(this.getPrioritySupported());
            sb.append("\n");
        }
        return sb;
    }

    @Override
    public void visit(Visitor visitor) throws IOException {
        visitor.visit(this);
    }

    @Override
    public KahaEntryType type() {
        return KahaEntryType.KAHA_ADD_MESSAGE_COMMAND;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != KahaAddMessageCommand.class) {
            return false;
        }
        return this.equals((KahaAddMessageCommand)obj);
    }

    public boolean equals(KahaAddMessageCommand obj) {
        if (this.hasTransactionInfo() ^ obj.hasTransactionInfo()) {
            return false;
        }
        if (this.hasTransactionInfo() && !this.getTransactionInfo().equals(obj.getTransactionInfo())) {
            return false;
        }
        if (this.hasDestination() ^ obj.hasDestination()) {
            return false;
        }
        if (this.hasDestination() && !this.getDestination().equals(obj.getDestination())) {
            return false;
        }
        if (this.hasMessageId() ^ obj.hasMessageId()) {
            return false;
        }
        if (this.hasMessageId() && !this.getMessageId().equals(obj.getMessageId())) {
            return false;
        }
        if (this.hasMessage() ^ obj.hasMessage()) {
            return false;
        }
        if (this.hasMessage() && !this.getMessage().equals(obj.getMessage())) {
            return false;
        }
        if (this.hasPriority() ^ obj.hasPriority()) {
            return false;
        }
        if (this.hasPriority() && this.getPriority() != obj.getPriority()) {
            return false;
        }
        if (this.hasPrioritySupported() ^ obj.hasPrioritySupported()) {
            return false;
        }
        return !this.hasPrioritySupported() || this.getPrioritySupported() == obj.getPrioritySupported();
    }

    public int hashCode() {
        int rc = 1601475350;
        if (this.hasTransactionInfo()) {
            rc ^= 0xFD5C48C ^ this.getTransactionInfo().hashCode();
        }
        if (this.hasDestination()) {
            rc ^= 0xE2FEBEE ^ this.getDestination().hashCode();
        }
        if (this.hasMessageId()) {
            rc ^= 0x219D4362 ^ this.getMessageId().hashCode();
        }
        if (this.hasMessage()) {
            rc ^= 0x9C2397E7 ^ this.getMessage().hashCode();
        }
        if (this.hasPriority()) {
            rc ^= 0xBE62DDC4 ^ this.getPriority();
        }
        if (this.hasPrioritySupported()) {
            rc ^= 0x3504534A ^ (this.getPrioritySupported() ? 6 : -6);
        }
        return rc;
    }
}

