package Geo::TigerLine::Record::Z;

use strict;

use Carp::Assert;
use base qw(Geo::TigerLine::Record::Parser Geo::TigerLine::Record::Accessor
            Geo::TigerLine::Record Class::Data::Inheritable);

use vars qw($VERSION);
$VERSION = '0.03';


# Auto-generated data dictionary.
my %Data_Dict = (
               'tlid' => {
                           'len' => 10,
                           'beg' => 6,
                           'bv' => 'No',
                           'fieldnum' => 3,
                           'type' => 'N',
                           'description' => 'TIGER/Line ID, Permanent 1-Cell Number',
                           'end' => 15,
                           'fmt' => 'R',
                           'field' => 'tlid'
                         },
               'zip4r' => {
                            'len' => 4,
                            'beg' => 23,
                            'bv' => 'Yes',
                            'fieldnum' => 6,
                            'type' => 'N',
                            'description' => '+4 Postal Add-On Code, Right',
                            'end' => 26,
                            'fmt' => 'L',
                            'field' => 'zip4r'
                          },
               'zip4l' => {
                            'len' => 4,
                            'beg' => 19,
                            'bv' => 'Yes',
                            'fieldnum' => 5,
                            'type' => 'N',
                            'description' => '+4 Postal Add-On Code, Left',
                            'end' => 22,
                            'fmt' => 'L',
                            'field' => 'zip4l'
                          },
               'rtsq' => {
                           'len' => 3,
                           'beg' => 16,
                           'bv' => 'No',
                           'fieldnum' => 4,
                           'type' => 'N',
                           'description' => 'Record Sequence Number',
                           'end' => 18,
                           'fmt' => 'R',
                           'field' => 'rtsq'
                         },
               'version' => {
                              'len' => 4,
                              'beg' => 2,
                              'bv' => 'No',
                              'fieldnum' => 2,
                              'type' => 'N',
                              'description' => 'Version Number',
                              'end' => 5,
                              'fmt' => 'L',
                              'field' => 'version'
                            },
               'rt' => {
                         'len' => 1,
                         'beg' => 1,
                         'bv' => 'No',
                         'fieldnum' => 1,
                         'type' => 'A',
                         'description' => 'Record Type',
                         'end' => 1,
                         'fmt' => 'L',
                         'field' => 'rt'
                       }
             );


my @Data_Fields = (
                 'rt',
                 'version',
                 'tlid',
                 'rtsq',
                 'zip4l',
                 'zip4r'
               );


assert(keys %Data_Dict == @Data_Fields);

# Turn the data dictionary into class data
__PACKAGE__->mk_classdata('Fields');
__PACKAGE__->mk_classdata('Dict');
__PACKAGE__->mk_classdata('Pack_Tmpl');

__PACKAGE__->Dict(\%Data_Dict);
__PACKAGE__->Fields(\@Data_Fields);

# Generate a pack template for parsing and turn it into class data.
my $pack_tmpl = join ' ', map { "A$_" } map { $_->{len} } 
                                          @Data_Dict{@Data_Fields};
__PACKAGE__->Pack_Tmpl($pack_tmpl);

# Generate accessors for each data field
foreach my $def (@Data_Dict{@Data_Fields}) {
    __PACKAGE__->mk_accessor($def);
}


=pod

=head1 NAME

Geo::TigerLine::Record::Z - TIGER/Line 2006 ZIP+4 Codes

=head1 SYNOPSIS

  use Geo::TigerLine::Record::Z;

  @records = Geo::TigerLine::Record::Z->parse_file($fh);
  @records = Geo::TigerLine::Record::Z->parse_file($fh, \&callback);

  $record = Geo::TigerLine::Record::Z->new(\%fields);

  $record->rt();
  $record->version();
  $record->tlid();
  $record->rtsq();
  $record->zip4l();
  $record->zip4r();


=head1 DESCRIPTION

This is a class representing record type Z of the TIGER/Line 2006
census geographic database.  Each object is one record.  It also
contains methods to parse TIGER/Line record type Z files and turn them
into objects.

This is intended as an intermediate format between pulling the raw
data out of the simplistic TIGER/Line data files into something more
sophisticated (a process you should only have to do once).  As such,
it's not very fast, but its careful, easy to use and performs some
verifications on the data being read.

As this class is autogenerated by mk_parsers, think before you modify this
file.  It's OO, so consider sub-classing instead.


=head2 Accessors

These are simple get/set accessors for each field of a record
generated from the TIGER/Line 2006 data dictionary.  They perform some
data validation.

=over 4

=item B<rt>

    $data = $record->rt();
    $record->rt($data);

Record Type.  

Expects alphanumeric data of no more than 1 characters.  $data cannot be blank 
and should be left justified.


=item B<version>

    $data = $record->version();
    $record->version($data);

Version Number.  

Expects numeric data of no more than 4 characters.  $data cannot be blank 
and should be left justified.


=item B<tlid>

    $data = $record->tlid();
    $record->tlid($data);

TIGER/Line ID, Permanent 1-Cell Number.  

Expects numeric data of no more than 10 characters.  $data cannot be blank 
and should be right justified.


=item B<rtsq>

    $data = $record->rtsq();
    $record->rtsq($data);

Record Sequence Number.  

Expects numeric data of no more than 3 characters.  $data cannot be blank 
and should be right justified.


=item B<zip4l>

    $data = $record->zip4l();
    $record->zip4l($data);

+4 Postal Add-On Code, Left.  

Expects numeric data of no more than 4 characters.  $data can be blank 
and should be left justified.


=item B<zip4r>

    $data = $record->zip4r();
    $record->zip4r($data);

+4 Postal Add-On Code, Right.  

Expects numeric data of no more than 4 characters.  $data can be blank 
and should be left justified.



=back


=head2 Data dictionary

This is the original TIGER/Line 2006 data dictionary from which this
class was generated.

    Record Type Z - ZIP+4 Codes  
    
    Field   BV  Fmt Type Beg End Len Description
    RT      No   L   A    1    1  1  Record Type
    VERSION No   L   N    2    5  4  Version Number
    TLID    No   R   N    6   15 10  TIGER/Line ID, Permanent 1-Cell Number
    RTSQ    No   R   N   16   18  3  Record Sequence Number
    ZIP4L   Yes  L   N   19   22  4  +4 Postal Add-On Code, Left
    ZIP4R   Yes  L   N   23   26  4  +4 Postal Add-On Code, Right



=head1 AUTHOR

Michael G Schwern <schwern@pobox.com>

=head1 SEE ALSO

L<Geo::TigerLine>, L<mk_parsers>

=cut


return 'Honey flash!';
