-- -*- coding: utf-8 -*-
-- jfm-tmin.lua: tmin10 互換
-- Based on utmin10.tfm (a counterpart of tmin10.tfm for upTeX).

local vscale = 0.916443 / 0.962216
local vht = 0.458221 / 0.962216

luatexja.jfont.define_jfm {
   dir = 'tate',
   zw = 1.0, zh = vscale,
   kanjiskip = { 0.0, 0.091641/0.962216, 0.0 },
   xkanjiskip = { 0.229101/0.962216, 0.183283/0.962216, 0.114551/0.962216 },
   [0] = {
      align = 'middle', left = 0.00, down = 0.00,
      width = 1.0, height = vht, depth = vht, italic=0.0,
      glue = {
	 [1] = { 0, 0, 0 },
	 [2] = { 0, 0, 0 },
	 [3] = { 0.111608, 0.0, 0.111608 },
	 [5] = { 0, 0, 0 },
	 [6] = { 0.5, 0.190480, 0.5 },
	 [7] = { 0.25, 0.190480, 0.25 },
	 [10] = { 0, 0, 0 },
      }
   },

   [1] = {
      chars = {
	 '，', '．'
      },
      align = 'left', left = 0.00, down = 0.00,
      width = 0.5, height = vht, depth = vht, italic=0.0,
      glue = {
	 [0] = { 0.5, 0.190480, 0.5 },
	 [1] = { 0, 0, 0 },
	 [2] = { 0, 0, 0 },
	 [3] = { 0.5, 0.190480, 0.5 },
	 [4] = { 0, 0, 0 },
	 [5] = { 0.5, 0.190480, 0.5 },
	 [6] = { 0.5, 0.190480, 0.5 },
	 [7] = { 0.5, 0.190480, 0.5 },
	 [10] = { 0, 0, 0 },
      }
   },

   [2] = {
      chars = {
	 '、', '。'
      },
      align = 'left', left = 0.00, down = 0.00,
      width = 0.5, height = vht, depth = vht, italic=0.0,
      glue = {
	 [0] = { 0.5, 0.190480, 0.5 },
	 [1] = { 0, 0, 0 },
	 [2] = { 0, 0, 0 },
	 [3] = { 0.5, 0.190480, 0.5 },
	 [4] = { 0, 0, 0 },
	 [5] = { 0.5, 0.190480, 0.5 },
	 [6] = { 0.5, 0.190480, 0.5 },
	 [7] = { 0.5, 0.190480, 0.5 },
	 [10] = { 0, 0, 0 },
      }
   },

   [3] = {
      chars = {
	 '〃', '々', 'ぁ', 'ぃ', 'ぅ', 'ぇ', 'ぉ', 'っ', 'ゃ', 'ゅ',
	 'ょ', 'ゎ', 'ゕ', 'ゖ', 'ゝ', 'ゞ', 'ァ', 'ィ', 'ゥ', 'ェ',
	 'ォ', 'ッ', 'ャ', 'ュ', 'ョ', 'ヮ', 'ヵ', 'ヶ', 'ヽ', 'ヾ',
	 'ㇰ', 'ㇱ', 'ㇲ', 'ㇳ', 'ㇴ', 'ㇵ', 'ㇶ', 'ㇷ', 'ㇸ', 'ㇹ',
	 'ㇺ', 'ㇻ', 'ㇼ', 'ㇽ', 'ㇾ', 'ㇿ',
      },
      align = 'middle', left = 0.00, down = 0.00,
      width = 0.776784, height = vht, depth = vht, italic=0.0,
      glue = {
	 [0] = { 0.111608, 0.0, 0.111608 },
	 [1] = { 0, 0, 0 },
	 [2] = { 0, 0, 0 },
	 [3] = { 0.111608, 0.0, 0.111608 },
	 [5] = { 0, 0, 0 },
	 [6] = { 0.5, 0.190480, 0.5 },
	 [7] = { 0.25, 0.190480, 0.25 },
	 [10] = { 0, 0, 0 },
      }
   },

   [4] = {
      chars = {
	 '！', '？'
      },
      align = 'middle', left = 0.00, down = 0.00,
      width = 1.0, height = vht, depth = vht, italic=0.0,
      glue = {
	 [0] = { 1.0, 0.0, 0.5 },
	 [1] = { 0, 0, 0 },
	 [2] = { 0, 0, 0 },
	 [3] = { 1.0, 0.0, 0.5 },
	 [5] = { 0, 0, 0 },
	 [6] = { 1.0, 0.0, 0.5 },
	 [7] = { 1.0, 0.0, 0.5 },
	 [10] = { 0, 0, 0 },
      }
   },

   [5] = {
      chars = {
	 '―', '‥', '…'
      },
      align = 'middle', left = 0.00, down = 0.00,
      width = 1.0, height = vht, depth = vht, italic=0.0,
      glue = {
	 [0] = { 0, 0, 0 },
	 [1] = { 0, 0, 0 },
	 [2] = { 0, 0, 0 },
	 [3] = { 0, 0, 0 },
	 [4] = { 0, 0, 0 },
	 [5] = { 0, 0, 0 },
	 [6] = { 0.25, 0.190480, 0.25 },
	 [7] = { 0.25, 0.190480, 0.25 },
	 [10] = { 0, 0, 0 },
      }
   },

   [6] = { -- 開き括弧類
      chars = {
	 '‘', '“', '〈', '《', '「', '『', '【', '〔', '〖',
	 '〘', '〝', '（', '［', '｛', '｟'
      },
      align = 'right', left = 0.0, down = 0.0,
      width = 0.5, height = vht, depth = vht, italic=0.0,
      glue = {
         [0] = {0, 0, 0},
         [1] = {0, 0, 0},
	 [2] = {0, 0, 0},
	 [3] = {0, 0, 0},
	 [4] = {0, 0, 0},
	 [5] = {0, 0, 0},
	 [6] = {0, 0, 0},
	 [7] = { 0.25, 0.0, 0.25 },
         [8] = {0, 0, 0},
	 [9] = {0, 0, 0},
      }
   },

   [7] = {
      chars = {
	 '‐', '‖', '・', '｜'
      },
      align = 'middle', left = 0.00, down = 0.00,
      width = 0.5, height = vht, depth = vht, italic=0.0,
      glue = {
	 [0] = { 0.25, 0.190480, 0.25 },
	 [1] = { 0.25, 0, 0.25 },
	 [2] = { 0.25, 0, 0.25 },
	 [3] = { 0.111608, 0.0, 0.111608 },
	 [4] = { 0.25, 0.190480, 0.25 },
	 [5] = { 0.25, 0.190480, 0.25 },
	 [6] = { 0.25, 0.190480, 0.25 },
	 [7] = { 0, 0.190480, 0.0 },
	 [10] = { 0.25, 0, 0.25 },
      }
   },

   [10] = { -- 閉じ括弧類
      chars = {
	 '’', '”', '〉', '》', '」', '』', '】', '〕',
	 '〗', '〙', '〟', '）', '］', '｝', '｠'
      },
      align = 'left', left = 0.0, down = 0.0,
      width = 0.5, height = vht, depth = vht, italic=0.0,
      glue = {
-- 3 は四分, 2, 4, 9 は0, あとは0.5
	 [0] = { 0.5 , 0.190480, 0.5 },
	 [1] = { 0, 0, 0 },
         [2] = { 0, 0, 0 },
	 [3] = { 0.5 , 0.190480, 0.5 },
         [4] = { 0, 0, 0 },
	 [5] = { 0.25 , 0.190480, 0.25 },
	 [6] = { 0.5 , 0.190480, 0.5 },
	 [7] = { 0.25 , 0.190480, 0.25 },
         [10] = {0, 0, 0},
      }
   },

   [99] = { -- box末尾
      chars = {'boxbdd', 'parbdd'},
   },

}
