/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class GenericCommand
extends Command {
    private TeXObjectList definition;

    public GenericCommand(String string) {
        this(true, string);
    }

    public GenericCommand(boolean bl, String string) {
        this(bl, string, null, new TeXObjectList(), false, 0);
    }

    public GenericCommand(String string, TeXObjectList teXObjectList, TeXObject teXObject) {
        this(true, string, teXObjectList, teXObject);
    }

    public GenericCommand(boolean bl, String string, TeXObjectList teXObjectList, TeXObject teXObject) {
        super(string);
        this.isShort = bl;
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof Group)) {
            this.definition = (TeXObjectList)teXObject;
        } else {
            this.definition = new TeXObjectList();
            this.definition.add(teXObject);
        }
        this.setSyntax(teXObjectList);
    }

    public GenericCommand(TeXParserListener teXParserListener, boolean bl, String string, int n, TeXObjectList teXObjectList) {
        super(string);
        this.isShort = bl;
        this.definition = teXObjectList;
        this.setSyntax(teXParserListener, n);
    }

    private GenericCommand(boolean bl, String string, TeXObjectList teXObjectList, TeXObjectList teXObjectList2, boolean bl2, int n) {
        super(string);
        this.isShort = bl;
        this.syntax = teXObjectList;
        this.definition = teXObjectList2;
        this.isDelimited = bl2;
        this.numArgs = n;
    }

    public GenericCommand(boolean bl, String string, TeXObject[] teXObjectArray, TeXObject[] teXObjectArray2) {
        super(string);
        this.isShort = bl;
        this.setSyntax(teXObjectArray);
        this.definition = new TeXObjectList(teXObjectArray2 == null || teXObjectArray2.length == 0 ? 1 : teXObjectArray2.length);
        if (teXObjectArray2 != null) {
            for (int i = 0; i < teXObjectArray2.length; ++i) {
                this.definition.add(teXObjectArray2[i]);
            }
        }
    }

    @Override
    public Object clone() {
        return new GenericCommand(this.isShort, this.getName(), this.syntax, this.definition, this.isDelimited, this.numArgs);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof GenericCommand)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GenericCommand genericCommand = (GenericCommand)object;
        if (this.isShort != genericCommand.isShort || this.isDelimited != genericCommand.isDelimited || this.numArgs != genericCommand.numArgs || this.syntax == null && genericCommand.syntax != null || this.syntax != null && genericCommand.syntax == null || !this.definition.equals(genericCommand.definition)) {
            return false;
        }
        if (this.syntax == genericCommand.syntax) {
            return true;
        }
        return this.syntax.equals(genericCommand.syntax);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.getReplacement(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.getReplacement(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.getReplacement(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.getReplacement(teXParser).expandfully(teXParser);
    }

    private TeXObjectList getReplacement(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject[] teXObjectArray = this.numArgs == 0 ? null : new TeXObject[this.numArgs];
        int n = 0;
        if (this.syntax != null) {
            byte by = this.isShort ? TeXObjectList.POP_SHORT : (byte)0;
            for (TeXObject teXObject : this.syntax) {
                if (teXObject instanceof Param) {
                    if (((Param)teXObject).getDigit() == -1) continue;
                    teXObjectArray[n] = this.isDelimited && n == this.numArgs - 1 ? teXObjectList.popToGroup(teXParser, by) : teXObjectList.popStack(teXParser, by);
                    ++n;
                    continue;
                }
                TeXObject teXObject2 = teXObjectList.popArg(teXParser, by);
                if (teXObject2 != null && teXObject.equals(teXObject2)) continue;
                throw new TeXSyntaxException(teXParser, "tex.error.syntax", this.toString(teXParser));
            }
        }
        TeXObjectList teXObjectList2 = new TeXObjectList(this.definition.size());
        if (n != this.numArgs) {
            throw new TeXSyntaxException(teXParser, "tex.error.syntax", this.toString(teXParser));
        }
        for (TeXObject teXObject : this.definition) {
            if (teXObject instanceof Param) {
                teXObjectList2.add(teXObjectArray[((Param)teXObject).getDigit() - 1]);
                continue;
            }
            if (teXObject instanceof DoubleParam) {
                teXObjectList2.add(((DoubleParam)teXObject).getParam());
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                teXObjectList2.add(this.replaceList(teXParser, (TeXObjectList)teXObject, teXObjectArray));
                continue;
            }
            teXObjectList2.add(teXObject);
        }
        return teXObjectList2;
    }

    private TeXObjectList getReplacement(TeXParser teXParser) throws IOException {
        TeXObject[] teXObjectArray = this.numArgs == 0 ? null : new TeXObject[this.numArgs];
        int n = 0;
        if (this.syntax != null) {
            byte by = this.isShort ? TeXObjectList.POP_SHORT : (byte)0;
            for (TeXObject teXObject : this.syntax) {
                if (teXObject instanceof Param) {
                    if (((Param)teXObject).getDigit() == -1) continue;
                    teXObjectArray[n] = this.isDelimited && n == this.numArgs - 1 ? teXParser.popToGroup(by) : teXParser.popNextArg(by);
                    ++n;
                    continue;
                }
                TeXObject teXObject2 = teXParser.popNextArg(by);
                if (teXObject2 == null) {
                    throw new TeXSyntaxException(teXParser, "tex.error.syntax", this.toString(teXParser));
                }
                if (teXObject.equals(teXObject2)) continue;
                throw new TeXSyntaxException(teXParser, "tex.error.syntax", this.toString(teXParser));
            }
        }
        TeXObjectList teXObjectList = new TeXObjectList(this.definition.size());
        if (n != this.numArgs) {
            throw new TeXSyntaxException(teXParser, "tex.error.syntax", this.toString(teXParser));
        }
        for (TeXObject teXObject : this.definition) {
            if (teXObject instanceof Param) {
                teXObjectList.add(teXObjectArray[((Param)teXObject).getDigit() - 1]);
                continue;
            }
            if (teXObject instanceof DoubleParam) {
                teXObjectList.add(((DoubleParam)teXObject).getParam());
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                teXObjectList.add(this.replaceList(teXParser, (TeXObjectList)teXObject, teXObjectArray));
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    private TeXObject replaceList(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject[] teXObjectArray) {
        TeXObjectList teXObjectList2 = teXObjectList.createList();
        for (TeXObject teXObject : teXObjectList) {
            if (teXObject instanceof Param) {
                teXObjectList2.add(teXObjectArray[((Param)teXObject).getDigit() - 1]);
                continue;
            }
            if (teXObject instanceof DoubleParam) {
                teXObjectList2.add(((DoubleParam)teXObject).getParam());
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                teXObjectList2.add(this.replaceList(teXParser, (TeXObjectList)teXObject, teXObjectArray));
                continue;
            }
            teXObjectList2.add(teXObject);
        }
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.getReplacement(teXParser, teXObjectList).process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.getReplacement(teXParser).process(teXParser);
    }

    public boolean isEmpty() {
        return this.definition.isEmpty();
    }

    public String show(TeXParser teXParser) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isShort) {
            stringBuilder.appendCodePoint(teXParser.getEscChar());
            stringBuilder.append("long ");
        }
        stringBuilder.append("macro:");
        if (this.syntax != null) {
            for (TeXObject teXObject : this.syntax) {
                if (teXObject instanceof Param && ((Param)teXObject).getDigit() == -1) {
                    stringBuilder.appendCodePoint(teXParser.getBgChar());
                    continue;
                }
                stringBuilder.append(teXObject.toString(teXParser));
            }
        }
        stringBuilder.append("->");
        for (TeXObject teXObject : this.definition) {
            stringBuilder.append(teXObject.toString(teXParser));
        }
        stringBuilder.append(".");
        if (this.isDelimited) {
            stringBuilder.appendCodePoint(teXParser.getBgChar());
        }
        return stringBuilder.toString();
    }

    public TeXObjectList getDefinition() {
        return this.definition;
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,prefix=%d,syntax=%s,definition=%s]", this.getClass().getSimpleName(), this.getName(), this.getPrefix(), this.getSyntax(), this.getDefinition());
    }
}

