/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;

public class MagicNumberCheck
extends Check {
    private static final int BASE_8 = 8;
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;
    private float[] mIgnoreNumbers = new float[]{-1.0f, 0.0f, 1.0f, 2.0f};

    public int[] getDefaultTokens() {
        return new int[]{142, 140, 137, 141};
    }

    public void visitToken(DetailAST aAST) {
        if (!this.inIgnoreList(aAST) && !this.isConstantDefinition(aAST)) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "magic.number", (Object)aAST.getText());
        }
    }

    private boolean inIgnoreList(DetailAST aAST) {
        float value = this.parseFloat(aAST.getText(), aAST.getType());
        return Arrays.binarySearch(this.mIgnoreNumbers, value) >= 0;
    }

    private float parseFloat(String aText, int aType) {
        float result = 0.0f;
        if (aType == 140) {
            result = Float.parseFloat(aText);
        }
        if (aType == 142) {
            result = (float)Double.parseDouble(aText);
        } else {
            int radix = 10;
            if (aText.startsWith("0x") || aText.startsWith("0X")) {
                radix = 16;
                aText = aText.substring(2);
            } else if (aText.charAt(0) == '0') {
                radix = 8;
                aText = aText.substring(1);
            }
            if (aType == 137) {
                if (aText.length() > 0) {
                    result = Integer.parseInt(aText, radix);
                }
            } else if (aType == 141) {
                if (aText.endsWith("L") || aText.endsWith("l")) {
                    aText = aText.substring(0, aText.length() - 1);
                }
                if (aText.length() > 0) {
                    result = Long.parseLong(aText, radix);
                }
            }
        }
        return result;
    }

    private boolean isConstantDefinition(DetailAST aAST) {
        DetailAST parent = aAST.getParent();
        if (parent == null || parent.getType() != 28) {
            return false;
        }
        if ((parent = parent.getParent()) == null || parent.getType() != 80) {
            return false;
        }
        if ((parent = parent.getParent()) == null || parent.getType() != 10) {
            return false;
        }
        DetailAST modifiersAST = parent.findFirstToken(5);
        return modifiersAST.branchContains(39);
    }

    public void setIgnoreNumbers(float[] aList) {
        if (aList == null || aList.length == 0) {
            this.mIgnoreNumbers = new float[0];
        } else {
            this.mIgnoreNumbers = new float[aList.length];
            System.arraycopy(aList, 0, this.mIgnoreNumbers, 0, aList.length);
            Arrays.sort(this.mIgnoreNumbers);
        }
    }
}

