/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.arnx.jsonic.util.BeanInfo;

public class MethodInfo
implements Iterable<Method>,
Comparable<MethodInfo> {
    private Class<?> beanClass;
    private String name;
    private boolean isStatic;
    List<Method> methods = new ArrayList<Method>();

    public MethodInfo(Class<?> beanClass, String name, Collection<Method> methods, boolean isStatic) {
        this.beanClass = beanClass;
        this.name = name;
        this.isStatic = isStatic;
        if (methods != null) {
            this.methods.addAll(methods);
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public Object invoke(Object instance, Object ... args) {
        Method method = this.findMethod(args);
        try {
            return method.invoke(instance, args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int compareTo(MethodInfo method) {
        if (!this.beanClass.equals(method.beanClass)) {
            return this.beanClass.getName().compareTo(method.beanClass.getName());
        }
        return this.name.compareTo(method.name);
    }

    public Method findMethod(Object ... args) {
        Method method = null;
        Class<?>[] types = null;
        Method vmethod = null;
        Class<?>[] vtypes = null;
        for (Method cmethod : this.methods) {
            Class<?>[] cparams = cmethod.getParameterTypes();
            if (cmethod.isVarArgs()) {
                if (args.length < cparams.length - 1) continue;
                if (vmethod == null) {
                    Class<?> vtype = cparams[cparams.length - 1].getComponentType();
                    Class[] tmp = new Class[args.length];
                    System.arraycopy(cparams, 0, tmp, 0, cparams.length - 1);
                    for (int i = cparams.length - 1; i < tmp.length; ++i) {
                        tmp[i] = vtype;
                    }
                    vmethod = cmethod;
                    vtypes = tmp;
                    continue;
                }
                int vpoint = BeanInfo.calcurateDistance(vtypes, args);
                int cpoint = BeanInfo.calcurateDistance(cparams, args);
                if (cpoint > vpoint) {
                    vmethod = cmethod;
                    vtypes = cparams;
                    continue;
                }
                if (cpoint != vpoint) continue;
                cmethod = null;
                cparams = null;
                continue;
            }
            if (args.length != cparams.length) continue;
            if (method == null) {
                method = cmethod;
                types = cparams;
                continue;
            }
            int point = BeanInfo.calcurateDistance(types, args);
            int cpoint = BeanInfo.calcurateDistance(cparams, args);
            if (cpoint > point) {
                method = cmethod;
                types = cparams;
                continue;
            }
            if (cpoint != point) continue;
            cmethod = null;
            cparams = null;
        }
        if (vmethod != null) {
            if (method == null) {
                method = vmethod;
            } else {
                int point = BeanInfo.calcurateDistance(types, args);
                int vpoint = BeanInfo.calcurateDistance(vtypes, args);
                if (vpoint > point) {
                    method = vmethod;
                }
            }
        }
        if (method == null) {
            throw new IllegalStateException("suitable method is not found: " + this.name);
        }
        return method;
    }

    @Override
    public Iterator<Method> iterator() {
        return this.methods.iterator();
    }

    public int size() {
        return this.methods.size();
    }

    public String toString() {
        return "MethodInfo [class=" + this.beanClass + ", name=" + this.name + ", isStatic=" + this.isStatic + "]";
    }
}

