/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class RedactionUtils {
    public static final String SOLR_REDACTION_SYSTEM_PATTERN_PROP = "solr.redaction.system.pattern";
    private static Pattern pattern = Pattern.compile(System.getProperty("solr.redaction.system.pattern", ".*password.*"), 2);
    private static final String REDACT_STRING = "--REDACTED--";
    private static boolean redactSystemProperty = Boolean.parseBoolean(System.getProperty("solr.redaction.system.enabled", "true"));

    public static boolean isSystemPropertySensitive(String name) {
        return redactSystemProperty && pattern.matcher(name).matches();
    }

    public static String getRedactString() {
        return REDACT_STRING;
    }

    public static void setRedactSystemProperty(boolean redactSystemProperty) {
        RedactionUtils.redactSystemProperty = redactSystemProperty;
    }

    public static String redactNames(Collection<String> names, String redactionPrefix, String data) {
        TreeSet<String> uniqueNames = new TreeSet<String>(names);
        HashSet<Integer> uniqueCode = new HashSet<Integer>();
        int codeShift = 0;
        int codeSpace = names.size();
        for (String name : uniqueNames) {
            int code = Math.abs(name.hashCode() % codeSpace);
            while (uniqueCode.contains(code)) {
                codeSpace = names.size() << ++codeShift;
                code = Math.abs(name.hashCode() % codeSpace);
            }
            uniqueCode.add(code);
            data = data.replaceAll("\\Q" + name + "\\E", redactionPrefix + Integer.toString(code, 36));
        }
        return data;
    }
}

