/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.security.HadoopAuthPlugin;
import org.apache.solr.security.HttpClientBuilderPlugin;

public class ConfigurableInternodeAuthHadoopPlugin
extends HadoopAuthPlugin
implements HttpClientBuilderPlugin {
    private static final String HTTPCLIENT_BUILDER_FACTORY = "clientBuilderFactory";
    private HttpClientBuilderFactory factory = null;

    public ConfigurableInternodeAuthHadoopPlugin(CoreContainer coreContainer) {
        super(coreContainer);
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        super.init(pluginConfig);
        String httpClientBuilderFactory = (String)Objects.requireNonNull(pluginConfig.get(HTTPCLIENT_BUILDER_FACTORY), "Please specify clientBuilderFactory to be used for Solr internal communication.");
        this.factory = this.coreContainer.getResourceLoader().newInstance(httpClientBuilderFactory, HttpClientBuilderFactory.class);
    }

    @Override
    public void setup(Http2SolrClient client) {
        this.factory.setup(client);
    }

    @Override
    public SolrHttpClientBuilder getHttpClientBuilder(SolrHttpClientBuilder builder) {
        return this.factory.getHttpClientBuilder(Optional.ofNullable(builder));
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.factory != null) {
            this.factory.close();
        }
    }
}

