/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class LogProxy
implements LogAdapter {
    private String name;
    private LogAdapter logger;

    public LogProxy(String name) {
        this.name = name;
    }

    public LogProxy(LogAdapter logger2) {
        this.logger = logger2;
    }

    @Override
    public void debug(Serializable message) {
        if (this.logger != null) {
            this.logger.debug(message);
        }
    }

    @Override
    public void error(Serializable message) {
        if (this.logger != null) {
            this.logger.error(message);
        }
    }

    @Override
    public void error(CharSequence message, Throwable throwable) {
        if (this.logger != null) {
            this.logger.error(message, throwable);
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.logger != null) {
            this.logger.fatal(message);
        }
    }

    @Override
    public void fatal(CharSequence message, Throwable throwable) {
        if (this.logger != null) {
            this.logger.fatal(message, throwable);
        }
    }

    @Override
    public LogLevel getEffectiveLogLevel() {
        if (this.logger != null) {
            return this.logger.getEffectiveLogLevel();
        }
        return LogLevel.OFF;
    }

    @Override
    public Iterator getLogHandler() {
        if (this.logger != null) {
            return this.logger.getLogHandler();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public LogLevel getLogLevel() {
        if (this.logger != null) {
            return this.logger.getLogLevel();
        }
        return LogLevel.OFF;
    }

    @Override
    public String getName() {
        if (this.logger != null) {
            this.logger.getName();
        }
        return this.name;
    }

    @Override
    public void info(CharSequence message) {
        if (this.logger != null) {
            this.logger.info(message);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger != null && this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger != null && this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger != null && this.logger.isWarnEnabled();
    }

    @Override
    public void setLogLevel(LogLevel level) {
        if (this.logger != null) {
            this.logger.setLogLevel(level);
        }
    }

    @Override
    public void warn(Serializable message) {
        if (this.logger != null) {
            this.logger.warn(message);
        }
    }

    public LogAdapter getLogger() {
        return this.logger;
    }

    public void setLogger(LogAdapter logger2) {
        this.logger = logger2;
    }
}

