/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.Calendar;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.tasks.TakeSnapshotTask;
import org.hibernate.Hibernate;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class TakeGroupSnapshotTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(TakeGroupSnapshotTask.class);
    private DeviceGroup deviceGroup;
    private int limitToOutofdateDeviceHours = -1;
    private boolean dontRunDiagnostics = false;
    private boolean dontCheckCompliance = false;

    public TakeGroupSnapshotTask() {
    }

    public TakeGroupSnapshotTask(DeviceGroup group, String comments, String author, int limitToOutofdateDeviceHours, boolean dontRunDiagnostics, boolean dontCheckCompliance) {
        super(comments, group.getName(), author);
        this.deviceGroup = group;
        this.limitToOutofdateDeviceHours = limitToOutofdateDeviceHours;
        this.dontRunDiagnostics = dontRunDiagnostics;
        this.dontCheckCompliance = dontCheckCompliance;
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Group snapshot";
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getDeviceGroup());
        Hibernate.initialize(this.getDeviceGroup().getCachedDevices());
    }

    @Override
    public void run() {
        logger.debug("Starting snapshot task for group {}.", (Object)this.getDeviceGroup().getId());
        Set<Device> devices = this.getDeviceGroup().getCachedDevices();
        logger.debug("{} devices in the group.", (Object)devices.size());
        String comment = String.format("Started due to group %s snapshot", this.getDeviceGroup().getName());
        Calendar referenceDate = Calendar.getInstance();
        referenceDate.add(10, -this.getLimitToOutofdateDeviceHours());
        for (Device device : devices) {
            if (referenceDate.getTime().before(device.getChangeDate())) {
                this.info(String.format("Ignoring device %s because it changed less than %d hours ago", device.getName(), this.getLimitToOutofdateDeviceHours()));
                continue;
            }
            this.info(String.format("Starting snapshot task for device %s.", device.getName()));
            TakeSnapshotTask task = new TakeSnapshotTask(device, comment, this.author, false, this.dontRunDiagnostics, this.dontCheckCompliance);
            try {
                TaskManager.addTask(task);
            }
            catch (Exception e) {
                logger.error("Error while scheduling the individual snapshot task.", e);
                this.error("Error while scheduling the task.");
            }
        }
        logger.debug("Everything went fine.");
        this.status = Task.Status.SUCCESS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public DeviceGroup getDeviceGroup() {
        return this.deviceGroup;
    }

    public void setDeviceGroup(DeviceGroup deviceGroup) {
        this.deviceGroup = deviceGroup;
    }

    public int getLimitToOutofdateDeviceHours() {
        return this.limitToOutofdateDeviceHours;
    }

    public void setLimitToOutofdateDeviceHours(int limitToOutofdateDeviceHours) {
        this.limitToOutofdateDeviceHours = limitToOutofdateDeviceHours;
    }

    public boolean isDontRunDiagnostics() {
        return this.dontRunDiagnostics;
    }

    public void setDontRunDiagnostics(boolean dontRunDiagnostics) {
        this.dontRunDiagnostics = dontRunDiagnostics;
    }

    public boolean isDontCheckCompliance() {
        return this.dontCheckCompliance;
    }

    public void setDontCheckCompliance(boolean dontCheckCompliance) {
        this.dontCheckCompliance = dontCheckCompliance;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TakeGroupSnapshotTask task = (TakeGroupSnapshotTask)super.clone();
        task.setDeviceGroup(this.deviceGroup);
        return task;
    }

    @Override
    @Transient
    public JobKey getIdentity() {
        return new JobKey(String.format("Task_%d", this.getId()), String.format("TakeGroupSnapshot_%d", this.getDeviceGroup().getId()));
    }
}

