/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.script.JsCliScript;
import onl.netfishers.netshot.work.Task;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class RunDeviceScriptTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(RunDeviceScriptTask.class);
    private Device device;
    private String script;
    private String deviceDriver;

    protected RunDeviceScriptTask() {
    }

    public RunDeviceScriptTask(Device device, String script, DeviceDriver driver, String comments, String author) {
        super(comments, device.getLastConfig() == null ? device.getMgmtAddress().getIp() : device.getName(), author);
        this.device = device;
        this.script = script;
        this.deviceDriver = driver.getName();
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getDevice());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Starting script task for device {}.", (Object)this.device.getId());
        this.info(String.format("Run script task for device %s (%s).", this.device.getName(), this.device.getMgmtAddress().getIp()));
        JsCliScript cliScript = null;
        try (Session session = Database.getSession();){
            session.beginTransaction();
            session.refresh(this.device);
            if (this.deviceDriver == null || !this.deviceDriver.equals(this.device.getDriver())) {
                logger.trace("The script doesn't apply to the driver of the device.");
                this.error("The script doesn't apply to the driver of the device.");
                this.status = Task.Status.CANCELLED;
                return;
            }
            if (this.device.getStatus() != Device.Status.INPRODUCTION) {
                logger.trace("Device not INPRODUCTION, stopping the run script task.");
                this.warn("The device is not enabled (not in production).");
                this.status = Task.Status.FAILURE;
                return;
            }
            cliScript = new JsCliScript(this.script, false);
            cliScript.connectRun(session, this.device);
            this.info(String.format("Device logs (%d next lines):", cliScript.getJsLog().size()));
            this.log.append(cliScript.getPlainJsLog());
            session.update(this.device);
            session.getTransaction().commit();
            this.status = Task.Status.SUCCESS;
        }
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Device script execution";
    }

    @ManyToOne(fetch=FetchType.LAZY)
    protected Device getDevice() {
        return this.device;
    }

    protected void setDevice(Device device) {
        this.device = device;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RunDeviceScriptTask task = (RunDeviceScriptTask)super.clone();
        task.setDevice(this.device);
        return task;
    }

    @Column(length=10000000)
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getDeviceDriver() {
        return this.deviceDriver;
    }

    public void setDeviceDriver(String deviceDriver) {
        this.deviceDriver = deviceDriver;
    }

    @Override
    @Transient
    public JobKey getIdentity() {
        return new JobKey(String.format("Task_%d", this.getId()), String.format("RunDevice_%d", this.getDevice().getId()));
    }
}

