/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.Domain;
import onl.netfishers.netshot.device.DynamicDeviceGroup;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.access.Snmp;
import onl.netfishers.netshot.device.credentials.DeviceCredentialSet;
import onl.netfishers.netshot.device.credentials.DeviceSnmpCommunity;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv1Community;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv2cCommunity;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv3Community;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.tasks.TakeSnapshotTask;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class DiscoverDeviceTypeTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(DiscoverDeviceTypeTask.class);
    private Set<DeviceCredentialSet> credentialSets = new HashSet<DeviceCredentialSet>();
    private Network4Address deviceAddress;
    private DeviceCredentialSet successCredentialSet = null;
    private String discoveredDeviceType = null;
    private Domain domain;
    private long deviceId = 0L;
    private long snapshotTaskId = 0L;

    protected DiscoverDeviceTypeTask() {
    }

    public DiscoverDeviceTypeTask(Network4Address deviceAddress, Domain domain, String comments, String author) {
        super(comments, deviceAddress.getIp(), author);
        this.deviceAddress = deviceAddress;
        this.domain = domain;
    }

    public String getDiscoveredDeviceType() {
        return this.discoveredDeviceType;
    }

    public void setDiscoveredDeviceType(String discoveredDeviceType) {
        this.discoveredDeviceType = discoveredDeviceType;
    }

    @XmlElement
    @Transient
    public String getDiscoveredDeviceTypeDescription() {
        String description = "Unknown";
        DeviceDriver driver = DeviceDriver.getDriverByName(this.discoveredDeviceType);
        if (driver == null) {
            logger.debug("No driver named {}.", (Object)this.discoveredDeviceType);
        } else {
            description = driver.getDescription();
        }
        return description;
    }

    public void addCredentialSet(DeviceCredentialSet credentialSet) {
        this.credentialSets.add(credentialSet);
    }

    @Transient
    public DeviceCredentialSet getSuccessCredentialSet() {
        return this.successCredentialSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean snmpDiscover(Snmp poller) {
        logger.debug("Trying SNMP discovery.");
        try {
            String sysDesc = poller.getAsString("1.3.6.1.2.1.1.1.0");
            String sysObjectId = poller.getAsString("1.3.6.1.2.1.1.2.0");
            this.debug("Got sysDesc = " + sysDesc);
            this.debug("Got sysObjectID = " + sysObjectId);
            logger.trace("Got sysDesc '{}' and sysObjectID '{}'.", (Object)sysDesc, (Object)sysObjectId);
            Iterator<DeviceDriver> iterator = DeviceDriver.getAllDrivers().iterator();
            while (true) {
                if (iterator.hasNext()) {
                    DeviceDriver driver = iterator.next();
                    if (!driver.snmpAutoDiscover(this, sysObjectId, sysDesc, this.getJsLogger())) continue;
                    logger.trace("The driver {} did accept the OID.", (Object)driver.getName());
                    this.discoveredDeviceType = driver.getName();
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.warn("Error while polling the device via SNMP.", e);
            this.error("Error while polling the device via SNMP.");
        }
        finally {
            try {
                poller.stop();
            }
            catch (IOException iOException) {}
        }
        logger.debug("No driver has accepted the OID.");
        return false;
    }

    private boolean snmpv1Discover(DeviceSnmpCommunity community) {
        logger.trace("SNMPv1 discovery with community {}.", (Object)community.getCommunity());
        this.trace("Trying SNMPv1 discovery.");
        try {
            Snmp poller = new Snmp(this.deviceAddress, community);
            return this.snmpDiscover(poller);
        }
        catch (UnknownHostException e) {
            logger.warn("SNMPv1 unknown host error.", e);
            this.warn("SNMPv1 unknown host error: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("SNMPv1 error while polling the device.", e);
            this.warn("Error while SNMPv1 polling the device: " + e.getMessage());
        }
        return false;
    }

    private boolean snmpv2cDiscover(DeviceSnmpCommunity community) {
        this.trace("Trying SNMPv2c discovery.");
        try {
            Snmp poller = new Snmp(this.deviceAddress, community);
            return this.snmpDiscover(poller);
        }
        catch (UnknownHostException e) {
            logger.warn("SNMPv2 unknown host error.", e);
            this.warn("SNMPv2 unknown host error: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("SNMPv2 error while polling the device.", e);
            this.warn("Error while SNMPv2 polling the device: " + e.getMessage());
        }
        return false;
    }

    private boolean snmpv3Discover(DeviceSnmpv3Community cred) {
        this.trace("Trying SNMPv3 discovery.");
        try {
            Snmp poller = new Snmp(this.deviceAddress, cred);
            return this.snmpDiscover(poller);
        }
        catch (UnknownHostException e) {
            logger.warn("SNMPv3 unknown host error.", e);
            this.warn("SNMPv3 unknown host error: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("SNMPv3 error while polling the device.", e);
            this.warn("Error while SNMPv3 polling the device: " + e.getMessage());
        }
        return false;
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getCredentialSets());
        this.getDomain().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Starting autodiscovery process.");
        boolean didTrySnmp = false;
        logger.trace("{} credential sets in the list.", (Object)this.credentialSets.size());
        for (DeviceCredentialSet credentialSet : this.credentialSets) {
            DeviceSnmpCommunity community;
            if (credentialSet instanceof DeviceSnmpv1Community) {
                logger.trace("SNMPv1 credential set.");
                didTrySnmp = true;
                community = (DeviceSnmpv1Community)credentialSet;
                if (!this.snmpv1Discover(community)) continue;
                this.status = Task.Status.SUCCESS;
                this.successCredentialSet = credentialSet;
                break;
            }
            if (credentialSet instanceof DeviceSnmpv2cCommunity) {
                logger.trace("SNMPv2c credential set.");
                didTrySnmp = true;
                community = (DeviceSnmpv2cCommunity)credentialSet;
                if (!this.snmpv2cDiscover(community)) continue;
                this.status = Task.Status.SUCCESS;
                this.successCredentialSet = credentialSet;
                break;
            }
            if (!(credentialSet instanceof DeviceSnmpv3Community)) continue;
            logger.trace("SNMPv3 credential set.");
            didTrySnmp = true;
            DeviceSnmpv3Community DeviceSnmpcred = (DeviceSnmpv3Community)credentialSet;
            if (!this.snmpv3Discover(DeviceSnmpcred)) continue;
            this.status = Task.Status.SUCCESS;
            this.successCredentialSet = credentialSet;
            break;
        }
        if (this.status == Task.Status.SUCCESS) {
            TakeSnapshotTask snapshotTask = null;
            Device device = null;
            try (Session session = Database.getSession();){
                session.beginTransaction();
                device = new Device(this.discoveredDeviceType, this.deviceAddress, this.domain, this.author);
                device.addCredentialSet(this.successCredentialSet);
                session.save(device);
                this.deviceId = device.getId();
                snapshotTask = new TakeSnapshotTask(device, "Automatic snapshot after discovery", this.author, true, false, false);
                session.save(snapshotTask);
                session.getTransaction().commit();
                this.snapshotTaskId = snapshotTask.getId();
            }
            if (device != null) {
                DynamicDeviceGroup.refreshAllGroups(device);
            }
            try {
                if (snapshotTask != null) {
                    TaskManager.addTask(snapshotTask);
                }
            }
            catch (Exception e) {
                logger.error("Error while registering the new task.", e);
            }
            return;
        }
        if (!didTrySnmp) {
            logger.warn("No available SNMP credential set.");
            this.error("No available SNMP credential set... can't start autodiscovery.");
        }
        this.status = Task.Status.FAILURE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (this.deviceAddress == null ? 0 : this.deviceAddress.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DiscoverDeviceTypeTask)) {
            return false;
        }
        DiscoverDeviceTypeTask other = (DiscoverDeviceTypeTask)obj;
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        return !(this.deviceAddress == null ? other.deviceAddress != null : !this.deviceAddress.equals(other.deviceAddress));
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="address", column=@Column(name="ipv4_address")), @AttributeOverride(name="prefixLength", column=@Column(name="ipv4_pfxlen")), @AttributeOverride(name="addressUsage", column=@Column(name="ipv4_usage"))})
    @XmlElement
    public Network4Address getDeviceAddress() {
        return this.deviceAddress;
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Device autodiscovery";
    }

    @XmlElement
    public long getDeviceId() {
        return this.deviceId;
    }

    @XmlElement
    public long getSnapshotTaskId() {
        return this.snapshotTaskId;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    protected Set<DeviceCredentialSet> getCredentialSets() {
        return this.credentialSets;
    }

    protected void setCredentialSets(Set<DeviceCredentialSet> credentialSets) {
        this.credentialSets = credentialSets;
    }

    protected void setDeviceAddress(Network4Address deviceAddress) {
        this.deviceAddress = deviceAddress;
    }

    protected void setSuccessCredentialSet(DeviceCredentialSet successCredentialSet) {
        this.successCredentialSet = successCredentialSet;
    }

    protected void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    protected void setSnapshotTaskId(long snapshotTaskId) {
        this.snapshotTaskId = snapshotTaskId;
    }

    @Override
    @Transient
    public JobKey getIdentity() {
        return new JobKey(String.format("Task_%d", this.getId()), String.format("DiscoverDeviceType_%s", this.getDeviceAddress().getIp()));
    }
}

