/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.diagnostic;

import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.attribute.LongTextConfiguration;
import onl.netfishers.netshot.diagnostic.Diagnostic;
import onl.netfishers.netshot.diagnostic.DiagnosticResult;

@Entity
@DiscriminatorValue(value="T")
public class DiagnosticLongTextResult
extends DiagnosticResult {
    private LongTextConfiguration longText;

    protected DiagnosticLongTextResult() {
    }

    public DiagnosticLongTextResult(Device device, Diagnostic diagnostic, String value) {
        super(device, diagnostic);
        this.longText = new LongTextConfiguration(value);
    }

    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public LongTextConfiguration getLongText() {
        return this.longText;
    }

    public void setLongText(LongTextConfiguration value) {
        this.longText = value;
    }

    @Override
    @Transient
    public String getAsText() {
        if (this.longText == null || this.longText.getText() == null) {
            return "";
        }
        return this.longText.getText();
    }

    @Override
    @Transient
    public Object getData() {
        if (this.getLongText() == null) {
            return null;
        }
        return this.getLongText().getText();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.longText == null ? 0 : this.longText.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DiagnosticLongTextResult)) {
            return false;
        }
        DiagnosticLongTextResult other = (DiagnosticLongTextResult)obj;
        return !(this.longText == null ? other.longText != null : !this.longText.equals(other.longText));
    }
}

