/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.script;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.access.Cli;
import onl.netfishers.netshot.device.access.Snmp;
import onl.netfishers.netshot.device.attribute.AttributeDefinition;
import onl.netfishers.netshot.device.attribute.ConfigAttribute;
import onl.netfishers.netshot.device.credentials.DeviceCliAccount;
import onl.netfishers.netshot.device.credentials.DeviceCredentialSet;
import onl.netfishers.netshot.device.credentials.DeviceSnmpCommunity;
import onl.netfishers.netshot.device.script.CliScript;
import onl.netfishers.netshot.device.script.helper.JsCliHelper;
import onl.netfishers.netshot.device.script.helper.JsCliScriptOptions;
import onl.netfishers.netshot.device.script.helper.JsConfigHelper;
import onl.netfishers.netshot.device.script.helper.JsDeviceHelper;
import onl.netfishers.netshot.device.script.helper.JsSnmpHelper;
import onl.netfishers.netshot.work.TaskLogger;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotCliScript
extends CliScript {
    private static Logger logger = LoggerFactory.getLogger(SnapshotCliScript.class);

    public SnapshotCliScript(boolean cliLogging) {
        super(cliLogging);
    }

    @Override
    protected void run(Session session, Device device, Cli cli, Snmp snmp, DeviceDriver.DriverProtocol protocol, DeviceCredentialSet account) throws Device.InvalidCredentialsException, IOException, ScriptException, Device.MissingDeviceDriverException {
        TaskLogger taskLogger = this.getJsLogger();
        JsCliHelper jsCliHelper = null;
        JsSnmpHelper jsSnmpHelper = null;
        switch (protocol) {
            case SNMP: {
                jsSnmpHelper = new JsSnmpHelper(snmp, (DeviceSnmpCommunity)account, taskLogger);
                break;
            }
            case TELNET: 
            case SSH: {
                jsCliHelper = new JsCliHelper(cli, (DeviceCliAccount)account, taskLogger, this.getCliLogger());
            }
        }
        DeviceDriver driver = device.getDeviceDriver();
        ScriptEngine engine = driver.getEngine();
        try {
            ConfigAttribute newAttribute;
            Map<String, ConfigAttribute> newAttributes;
            boolean different;
            Config config;
            block27: {
                JsCliScriptOptions options = new JsCliScriptOptions(jsCliHelper, jsSnmpHelper);
                options.setDevice(new JsDeviceHelper(device, session, taskLogger, false));
                config = new Config(device);
                options.setConfigHelper(new JsConfigHelper(device, config, cli, taskLogger));
                ((Invocable)((Object)engine)).invokeFunction("_connect", "snapshot", protocol.value(), options, taskLogger);
                different = false;
                try {
                    Config lastConfig = Database.unproxy(device.getLastConfig());
                    if (lastConfig == null) {
                        different = true;
                        break block27;
                    }
                    Map<String, ConfigAttribute> oldAttributes = lastConfig.getAttributeMap();
                    newAttributes = config.getAttributeMap();
                    for (AttributeDefinition definition : driver.getAttributes()) {
                        if (definition.getLevel() != AttributeDefinition.AttributeLevel.CONFIG) continue;
                        ConfigAttribute oldAttribute = oldAttributes.get(definition.getName());
                        newAttribute = newAttributes.get(definition.getName());
                        if (oldAttribute != null) {
                            if (oldAttribute.equals(newAttribute)) continue;
                            different = true;
                        } else {
                            if (newAttribute == null) continue;
                            different = true;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.error("Error while comparing old and new configuration. Will save the new configuration.", e);
                }
            }
            if (different) {
                device.setLastConfig(config);
                device.getConfigs().add(config);
            } else {
                taskLogger.info("The configuration hasn't changed. Not storing a new one in the DB.");
            }
            String path = Netshot.getConfig("netshot.snapshots.dump");
            if (path != null) {
                try {
                    BufferedWriter output = new BufferedWriter(new FileWriter(Paths.get(path, device.getName()).normalize().toFile()));
                    newAttributes = config.getAttributeMap();
                    for (AttributeDefinition definition : driver.getAttributes()) {
                        String postText;
                        String text;
                        if (!definition.isDump()) continue;
                        String preText = definition.getPreDump();
                        if (preText != null) {
                            preText = preText.replaceAll("%when%", Matcher.quoteReplacement(new Date().toString()));
                            output.write(preText);
                            output.write("\r\n");
                        }
                        if ((newAttribute = newAttributes.get(definition.getName())) != null && (text = newAttribute.getAsText()) != null) {
                            if (definition.getPreLineDump() != null || definition.getPostLineDump() != null) {
                                String[] lines;
                                for (String line : lines = text.split("\\r?\\n")) {
                                    if (definition.getPreLineDump() != null) {
                                        output.write(definition.getPreLineDump());
                                    }
                                    output.write(line);
                                    if (definition.getPostLineDump() != null) {
                                        output.write(definition.getPostLineDump());
                                    }
                                    output.write("\r\n");
                                }
                            } else {
                                output.write(text);
                            }
                        }
                        if ((postText = definition.getPostDump()) == null) continue;
                        postText = postText.replaceAll("%when%", Matcher.quoteReplacement(new Date().toString()));
                        output.write(postText);
                        output.write("\r\n");
                    }
                    output.close();
                    taskLogger.info("The configuration has been saved as a file in the dump folder.");
                }
                catch (Exception e) {
                    logger.warn("Couldn't write the configuration into file.", e);
                    taskLogger.warn("Unable to write the configuration as a file.");
                }
            }
        }
        catch (ScriptException e) {
            logger.error("Error while running snapshot using driver {}.", (Object)driver.getName(), (Object)e);
            taskLogger.error(String.format("Error while running snapshot using driver %s: '%s'.", driver.getName(), e.getMessage()));
            if (e.getMessage().contains("Authentication failed")) {
                throw new Device.InvalidCredentialsException("Authentication failed");
            }
            throw e;
        }
        catch (NoSuchMethodException e) {
            logger.error("No such method 'snapshot' while using driver {}.", (Object)driver.getName(), (Object)e);
            taskLogger.error(String.format("No such method 'snapshot' while using driver %s to take snapshot: '%s'.", driver.getName(), e.getMessage()));
            throw new ScriptException(e);
        }
    }
}

