/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.access;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.Security;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.access.Cli;
import onl.netfishers.netshot.work.TaskLogger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ssh
extends Cli {
    private static Logger logger = LoggerFactory.getLogger(Ssh.class);
    private static int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private int port = 22;
    private JSch jsch;
    private Session session;
    private Channel channel;
    private String username;
    private String password;
    private String publicKey = null;
    private String privateKey = null;

    public Ssh(NetworkAddress host, int port, String username, String password, TaskLogger taskLogger) {
        super(host, taskLogger);
        if (port != 0) {
            this.port = port;
        }
        this.username = username;
        this.password = password;
        this.privateKey = null;
        this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    }

    public Ssh(NetworkAddress host, int port, String username, String publicKey, String privateKey, String passphrase, TaskLogger taskLogger) {
        super(host, taskLogger);
        if (port != 0) {
            this.port = port;
        }
        this.username = username;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.password = passphrase;
        this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    }

    public Ssh(NetworkAddress host, String username, String publicKey, String privateKey, String passphrase, TaskLogger taskLogger) {
        super(host, taskLogger);
        this.username = username;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.password = passphrase;
        this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    }

    public Ssh(NetworkAddress host, String username, String password, TaskLogger taskLogger) {
        super(host, taskLogger);
        this.username = username;
        this.password = password;
        this.privateKey = null;
        this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    }

    @Override
    public void connect() throws IOException {
        this.jsch = new JSch();
        try {
            if (this.privateKey != null && this.publicKey != null) {
                final KeyPair kpair = KeyPair.load(this.jsch, this.privateKey.getBytes(), this.publicKey.getBytes());
                this.jsch.addIdentity(new Identity(){

                    @Override
                    public boolean setPassphrase(byte[] passphrase) throws JSchException {
                        return kpair.decrypt(passphrase);
                    }

                    @Override
                    public boolean isEncrypted() {
                        return kpair.isEncrypted();
                    }

                    @Override
                    public byte[] getSignature(byte[] data) {
                        return kpair.getSignature(data);
                    }

                    @Override
                    public byte[] getPublicKeyBlob() {
                        return kpair.getPublicKeyBlob();
                    }

                    @Override
                    public String getName() {
                        return "Key";
                    }

                    @Override
                    public String getAlgName() {
                        switch (kpair.getKeyType()) {
                            case 2: {
                                return "ssh-rsa";
                            }
                            case 1: {
                                return "ssh-dss";
                            }
                            case 0: {
                                return "ERROR";
                            }
                        }
                        return "UNKNOWN";
                    }

                    @Override
                    public boolean decrypt() {
                        throw new RuntimeException("Not implemented");
                    }

                    @Override
                    public void clear() {
                        kpair.dispose();
                    }
                }, this.password == null ? null : this.password.getBytes());
            }
            this.session = this.jsch.getSession(this.username, this.host.getIp(), this.port);
            if (this.privateKey == null || this.publicKey == null) {
                this.session.setPassword(this.password);
            }
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.setTimeout(this.receiveTimeout);
            this.session.connect(this.connectionTimeout);
            this.channel = this.session.openChannel("shell");
            this.inStream = this.channel.getInputStream();
            this.outStream = new PrintStream(this.channel.getOutputStream());
            this.channel.connect(this.connectionTimeout);
        }
        catch (JSchException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void disconnect() {
        try {
            this.channel.disconnect();
            this.session.disconnect();
        }
        catch (Exception e) {
            logger.warn("Error on SSH disconnect.", e);
        }
    }

    private int scpCheckAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer("SCP error: ");
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            throw new IOException(sb.toString());
        }
        return b;
    }

    public void scpDownload(String remoteFileName, String localFileName) throws IOException {
        if (localFileName == null) {
            throw new FileNotFoundException("Invalid destination file name for SCP copy operation. Have you defined 'netshot.snapshots.binary.path'?");
        }
        if (remoteFileName == null) {
            throw new FileNotFoundException("Invalid source file name for SCP copy operation");
        }
        if (!this.session.isConnected()) {
            throw new IOException("The SSH session is not connected, can't start the SCP transfer");
        }
        this.taskLogger.info(String.format("Downloading '%s' to '%s' using SCP.", remoteFileName, localFileName.toString()));
        Channel channel = null;
        FileOutputStream fileStream = null;
        try {
            int len;
            String command = String.format("scp -f '%s'", remoteFileName.replace("'", "'\"'\"'"));
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect(this.connectionTimeout);
            byte[] buf = new byte[4096];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (this.scpCheckAck(in) != 67) {
                throw new IOException("SCP error, no file to download");
            }
            in.read(buf, 0, 5);
            long fileSize = 0L;
            while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                fileSize = fileSize * 10L + (long)(buf[0] - 48);
            }
            this.taskLogger.debug(String.format("File size: %d bytes", fileSize));
            String retFileName = null;
            int i = 0;
            while (true) {
                if (in.read(buf, i, 1) < 0) {
                    throw new IOException("Can't receive the file name");
                }
                if (buf[i] == 10) break;
                ++i;
            }
            retFileName = new String(buf, 0, i);
            this.taskLogger.debug(String.format("Name: '%s'", retFileName));
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            fileStream = new FileOutputStream(localFileName);
            do {
                if ((len = in.read(buf, 0, Math.min(buf.length, (int)fileSize))) < 0) {
                    throw new IOException("SCP read error");
                }
                fileStream.write(buf, 0, len);
            } while ((fileSize -= (long)len) != 0L);
            fileStream.close();
            fileStream = null;
        }
        catch (JSchException error) {
            throw new IOException("SCP exception", error);
        }
        finally {
            try {
                channel.disconnect();
            }
            catch (Exception exception) {}
            try {
                fileStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void sftpDownload(String remoteFileName, String localFileName) throws IOException {
        if (localFileName == null) {
            throw new FileNotFoundException("Invalid destination file name for SFTP copy operation. Have you defined 'netshot.snapshots.binary.path'?");
        }
        if (remoteFileName == null) {
            throw new FileNotFoundException("Invalid source file name for SFTP copy operation");
        }
        if (!this.session.isConnected()) {
            throw new IOException("The SSH session is not connected, can't start the SFTP transfer");
        }
        this.taskLogger.info(String.format("Downloading '%s' to '%s' using SFTP.", remoteFileName, localFileName.toString()));
        Channel channel = null;
        try {
            channel = this.session.openChannel("sftp");
            channel.connect(this.connectionTimeout);
            ChannelSftp sftpChannel = (ChannelSftp)channel;
            sftpChannel.get(remoteFileName, localFileName);
        }
        catch (JSchException error) {
            throw new IOException("SSH error: " + error.getMessage(), error);
        }
        catch (SftpException error) {
            throw new IOException("SFTP error: " + error.getCause().getMessage(), error);
        }
        finally {
            try {
                channel.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    static {
        Security.insertProviderAt(new BouncyCastleProvider(), 1);
        int configuredConnectionTimeout = Netshot.getConfig("netshot.cli.ssh.connectiontimeout", DEFAULT_CONNECTION_TIMEOUT);
        if (configuredConnectionTimeout < 1) {
            logger.error("Invalid value {} for {}", (Object)configuredConnectionTimeout, (Object)"netshot.cli.ssh.connectiontimeout");
        } else {
            DEFAULT_CONNECTION_TIMEOUT = configuredConnectionTimeout;
        }
        logger.info("The default connection timeout value for SSH sessions is {}s", (Object)DEFAULT_CONNECTION_TIMEOUT);
    }
}

