/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.NetworkAddress;

@Embeddable
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Network6Address
extends NetworkAddress {
    private long address1;
    private long address2;
    private int prefixLength;
    private NetworkAddress.AddressUsage addressUsage = NetworkAddress.AddressUsage.PRIMARY;

    public static String intToIP(long address1, long address2) {
        InetAddress address = Network6Address.longToInetAddress(address1, address2);
        return address.getHostAddress();
    }

    public static InetAddress longToInetAddress(long address1, long address2) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(address1);
        buffer.putLong(address2);
        try {
            return InetAddress.getByAddress(buffer.array());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    protected Network6Address() {
    }

    public Network6Address(Inet6Address address, int prefixLength) {
        byte[] buffer = address.getAddress();
        ByteBuffer bBuffer = ByteBuffer.wrap(buffer);
        this.address1 = bBuffer.getLong();
        this.address2 = bBuffer.getLong();
    }

    public Network6Address(String address) throws UnknownHostException {
        this(address, 0);
    }

    public Network6Address(String address, int prefixLength) throws UnknownHostException {
        this.prefixLength = prefixLength;
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            if (inetAddress instanceof Inet6Address) {
                byte[] buffer = inetAddress.getAddress();
                ByteBuffer bBuffer = ByteBuffer.wrap(buffer);
                this.address1 = bBuffer.getLong();
                this.address2 = bBuffer.getLong();
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        throw new UnknownHostException("Unable to parse the IPv6 address.");
    }

    public Network6Address(String address, String length) throws UnknownHostException {
        this(address, Integer.parseInt(length));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network6Address)) {
            return false;
        }
        Network6Address other = (Network6Address)obj;
        return this.address1 == other.address1 && this.address2 == other.address2 && this.prefixLength == other.prefixLength;
    }

    @Column(name="ipv6address_1")
    public long getAddress1() {
        return this.address1;
    }

    @Column(name="ipv6address_2")
    public long getAddress2() {
        return this.address2;
    }

    @Override
    @Transient
    public InetAddress getInetAddress() {
        return Network6Address.longToInetAddress(this.address1, this.address2);
    }

    @Override
    @Transient
    @XmlAttribute
    public String getIp() {
        return Network6Address.intToIP(this.address1, this.address2);
    }

    @Override
    @Transient
    public String getPrefix() {
        return this.getIp() + "/" + this.prefixLength;
    }

    @Override
    @Column(name="ipv6mask")
    @XmlAttribute
    public int getPrefixLength() {
        return this.prefixLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.address1 ^ this.address1 >>> 32);
        result = 31 * result + (int)(this.address2 ^ this.address2 >>> 32);
        result = 31 * result + this.prefixLength;
        return result;
    }

    protected void setAddress1(long address1) {
        this.address1 = address1;
    }

    protected void setAddress2(long address2) {
        this.address2 = address2;
    }

    protected void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    @Override
    public String toString() {
        return this.getPrefix();
    }

    @Override
    @XmlElement
    @Column(name="ipv6usage")
    public NetworkAddress.AddressUsage getAddressUsage() {
        return this.addressUsage;
    }

    @Override
    public void setAddressUsage(NetworkAddress.AddressUsage usage) {
        this.addressUsage = usage;
    }

    public boolean contains(Network6Address address) {
        if (this.prefixLength <= 64) {
            return this.address1 >> 64 - this.prefixLength == address.address1 >> 64 - this.prefixLength;
        }
        return this.address1 == address.address1 && this.address2 >> 64 - this.prefixLength == address.address2 >> 64 - this.prefixLength;
    }
}

